/*
 * Decompiled with CFR 0.152.
 */
package apple.finder.search.ui;

import apple.finder.search.ui.AppleFinderController;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AbstractRow
extends Composite {
    private Button btnAdd;
    private Button btnDelete;
    private Button btnGroup;
    private Label topSeparator;
    private Label dragHint;
    protected Combo combo;
    protected Composite middle;
    protected int level;
    protected String id = String.valueOf(((Object)((Object)this)).hashCode());
    private AppleFinderController controller;
    private List<Resource> disposables = new ArrayList<Resource>();

    public AbstractRow(Composite parent, int style) {
        super(parent, 0);
        this.topSeparator = new Label((Composite)this, 258);
        this.dragHint = new Label((Composite)this, 16384);
        this.dragHint.setText(" | | ");
        this.combo = new Combo((Composite)this, 8);
        this.middle = new Composite((Composite)this, 0);
        this.btnDelete = new Button((Composite)this, 9);
        this.btnDelete.setText("\u2212");
        this.btnDelete.setToolTipText("Supprimer la ligne (avec ses sous-lignes)");
        this.btnAdd = new Button((Composite)this, 8);
        this.btnAdd.setText("+");
        this.btnAdd.setToolTipText("Ajouter une ligne");
        this.btnGroup = new Button((Composite)this, 8);
        this.btnGroup.setText("gr.");
        this.btnGroup.setToolTipText("Copier le groupe");
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRow.this.controller.addCriteria(AbstractRow.this);
            }
        });
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRow.this.controller.delete(AbstractRow.this);
            }
        });
        this.btnGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent e) {
                try {
                    AbstractRow.this.controller.setDeferRowLayout(true);
                    AbstractRow group = AbstractRow.this.controller.addGroup(AbstractRow.this);
                    AbstractRow.this.controller.addCriteria(group);
                }
                finally {
                    AbstractRow.this.controller.setDeferRowLayout(false);
                }
            }
        });
        FormLayout layout = new FormLayout();
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.combo, 0, 0x1000000);
        data.left = new FormAttachment(0);
        this.dragHint.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment((Control)this.dragHint);
        this.combo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment((Control)this.combo);
        data.right = new FormAttachment((Control)this.btnDelete, 0, 16384);
        this.middle.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnGroup, 0, 0x1000000);
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment((Control)this.btnAdd, 0, 16384);
        data.width = this.btnGroup.computeSize((int)-1, (int)-1).x;
        this.btnDelete.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnGroup, 0, 0x1000000);
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment((Control)this.btnGroup, 0, 16384);
        data.width = this.btnGroup.computeSize((int)-1, (int)-1).x;
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment(100);
        this.btnGroup.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.height = 2;
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.topSeparator.setLayoutData((Object)data);
        this.topSeparator.setVisible(false);
        DragSource source = new DragSource((Control)this.dragHint, 19);
        source.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = AbstractRow.this.id;
                }
            }
        });
        source.setDragSourceEffect(new DragSourceEffect((Control)this){
            private Image image;

            public void dragStart(DragSourceEvent event) {
                event.image = this.image = AbstractRow.this.getDragEffectImage();
            }

            public void dragFinished(DragSourceEvent event) {
                if (this.image != null && !this.image.isDisposed()) {
                    this.image.dispose();
                }
            }
        });
        DropTargetAdapter dropListener = new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                AbstractRow.this.topSeparator.setVisible(true);
            }

            public void drop(DropTargetEvent event) {
                String dropId;
                AbstractRow.this.topSeparator.setVisible(false);
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && (dropId = (String)event.data) != null) {
                    AbstractRow.this.getController().dragBeforeRow(dropId, AbstractRow.this.id);
                }
            }

            public void dragLeave(DropTargetEvent event) {
                AbstractRow.this.topSeparator.setVisible(false);
            }
        };
        DropTarget target = new DropTarget((Control)this, 19);
        target.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        target.addDropListener((DropTargetListener)dropListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Resource res : AbstractRow.this.disposables) {
                    res.dispose();
                }
            }
        });
    }

    protected Image getDragEffectImage() {
        return null;
    }

    public AppleFinderController getController() {
        return this.controller;
    }

    public void setController(AppleFinderController controller) {
        this.controller = controller;
    }

    public String toString() {
        if (this.isDisposed()) {
            return String.format("Row [disposed]", new Object[0]);
        }
        return "Row (" + this.level + ") [" + this.combo.getItem(this.combo.getSelectionIndex()) + "]";
    }
}

