(function(){
	var tempAssist = angular.module('tempAssist', []);
	
	tempAssist.factory('TempAssistAccessor', 
			['DashAPI','model','$q', 'FlView', '$filter', 'QValidation',
				function(DashAPI, model, $q, FlView, $filter, QValidation) {
		var accessor = {
			getAssistText : function (data, callback, error){
				DashAPI.get('/dashboard/template/ws/getAssistText?idType=' + data.idType + '&txt='+data.txt, callback, error);
			},
			assistantSelectedCount : function (data, callback, error){
				DashAPI.get('/dashboard/template/ws/assistantSelectedCount?idTemplate=' + data.idTemplate, callback, error);
			},
			openTemplateEditor : function (type, callback, error){
				DashAPI.get('/dashboard/template/ws/openTemplateEditor?type=' + type, callback, error);
			},
			quicksave : function (data, callback, error){
				return DashAPI.get('/dashboard/template/ws/quicksave?idType=' + data.idType + '&txt='+data.txt + '&name='+ data.name, callback, error);
			},
			find:function(data, callback,error){
                return DashAPI.get('dashboard/template/ws/find?type=' + data.type + '&txt=' + data.txt, callback, error);
            },
			getAll:function(data, callback,error){
                return DashAPI.get('dashboard/template/ws/getAll?type=' + data, callback, error);
            },
			getClientAndGlobal:function(data, callback, error){
                return DashAPI.get('dashboard/template/ws/getMostUsedClientAndGlobal?idType=' + data.idType + '&offset=' + data.offset, callback, error);
            },
            getUser:function(data, callback, error){
                return DashAPI.get('dashboard/template/ws/getMostUsedUser?idType=' + data.idType + '&offset=' + data.offset + '&txt='+ (data.txt ? data.txt : ""), callback, error);
            },
			getGlobal:function(data, callback, error){
                return DashAPI.get('dashboard/template/ws/getMostUsedGlobal?idType=' + data.idType + '&offset=' + data.offset + '&txt='+ (data.txt ? data.txt : ""), callback, error);
            },
			getClient:function(data, callback, error){
                return DashAPI.get('dashboard/template/ws/getMostUsedClient?idType=' + data.idType + '&offset=' + data.offset + '&txt='+ (data.txt ? data.txt : ""), callback, error);
            },
            saveTemplate: function(data, callback, error){
                return DashAPI.post('/dashboard/template/ws/save', data, callback, error);
            },
			computeDesc: function (template, isHtml, isFinalText){
				var str = "";
				for(var i = 0; i< template.sections.length;i++){
					str += accessor.getVarText(template.sections[i], isHtml, isFinalText);
				}
				if(isHtml){
					str = str.replace(/(?:\r\n|\r|\n)/g, '<br />');
				}
				return str;
			},
			hasVar: function(template){
				for(var i = 0; i< template.sections.length;i++){
					if(template.sections[i].className && template.sections[i].className !== 'DRaw'){
						return true;
					}
				}
				return false;
			},
			getVarText: function (tVar, isHtml, isFinalText){
				if(tVar.className =="DRaw"){
					return tVar.raw;
				}else if(tVar.className =="DRawBreak"){
					return "\n"
				}else {
					if(OfysUtils.isNotEmpty(tVar.m) && tVar.m !== "undefined")
						return tVar.m;
					else{
						if(isFinalText){
							return "";
						}else if(isHtml){
							return '<b>['+tVar.name+']</b>';
						}else{
							return '['+tVar.name+']';
						}
					}
				}
			},
			api: {
				getAssistText: function(idType, text){
//					console.log("getAssistText not yet implemented!! id:"+ idType+" Text: "+ text);
					return $q(function(resolve, reject) {
						accessor.getAssistText({idType: idType, txt: text}, function(res){
							for(var i = 0 ; i < res.data.length; i++){
								res.data[i].computeDescription = accessor.computeDesc(res.data[i], true); 
							}
							resolve(res);
						}, reject);
					});
				},
				
				assistantSelectedCount: function(idTemplate){
					accessor.assistantSelectedCount({idTemplate: idTemplate});
//					console.log("assistantSelectedCount not yet implemented!!");
				},
					
//					No need to implement in dashboard and web because computeDescription variable is already populated in list.
//					gabaritGetDescription: function(){
//						console.log("gabaritGetDescription not yet implemented!!");
//					},
					
				gabaritGetFinalText: function(text, template){
					if(accessor.hasVar(template)){
						return FlView.open({templateUrl: "/dashboard/resources/ofys/widgets/template_assist_fill.html?v=ba", 
						template: template}, {windowClass: 'gabarit to-top', backdrop:'static'});
					}else{
						return accessor.computeDesc(template, false, true);
					}
				},
				openTemplateEditor: function(type){
//					accessor.openTemplateEditor(type, function(){
//						model.notice().ifEmbeded($filter('translate')('embedOpenDocument'));
//					});
					data = {
						idType : type,
						offset: null
					}
					var templateList = []
//					let chain = $q.resolve();
					function getUser(data){
						return accessor.getUser(data,function(res){
							if (res.data && res.data.success===false) {
								model.notice().warn(res.data.ms);
							}else{
								templateList.push(...res.data);
							}
							return true;
						},function(err) {
							console.log(err);
							model.notice().warn($filter('translate')('error') + ": " + err);	
						});
					}
					function getClient(data){
						return accessor.getClient(data,function(res){
							if (res.data && res.data.success===false) {
								model.notice().warn(res.data.ms);
							}else{
								templateList.push(...res.data);
							}
							return true;
						},function(err) {
							console.log(err);
							model.notice().warn($filter('translate')('error') + ": " + err);	
						});
					}
					function resolveTemplateData(){
						model.template().chosenType = Object.values(model.enums().templateList).find((e) => e.value == type)
						model.template().chosenTypeList = [];
						if(model.patient()){
							model.patient('template').currList = model.patient().currList;
							model.patient('template').currPatient = model.patient().currPatient;
						}
						if(templateList && templateList.length == 0){
							model.template().searchMoreTemplate = false
						}else{
							model.template().searchMoreTemplate = true;
							if(templateList){
								model.template().chosenTypeList = templateList;
							}
							model.template().offset = 50;
						}
						if(!model.template().chosenType){
							model.template().chosenType = {
								show: true,
								type: "OTHER_FORM",
								value: type
							}
						}
						var flOptions = {
							templateUrl: "/dashboard/resources/ofys/template/template_modal.html",
							fl:{
								beforeCancel: function(e, obj){
									return QValidation.closeContext($filter('translate')('UnsavedChanges'), "templates_"+model.template().chosenType.value).then(function(successful){
										if(!successful){
											e.prevent();
										}
										return successful;
									});
								}
							}
						}
						FlView.open(flOptions, {windowClass:'templatemodal', backdrop:'static'});
						model.templateLstUpdated(true);
					}
					getUser(data).then(function(){
						return getClient(data);
					}).then(function(){
						resolveTemplateData()
					})
				}
			}
			
		};
		
		AutoComplete.hasAngular = true;
		AutoComplete.api = accessor.api;
		return accessor;
	}]);

	tempAssist.directive('dynaAutocomplete', ['TempAssistAccessor','$timeout', 
		function(TempAssistAccessor, $timeout){
		return {
			scope:{
				dynaAutocomplete: "=",
			},
			controller: ['$scope', '$element', '$attrs', function (scope, element, attrs) {
				//This allows communicating with other directives for autocomplete. especially used in toasteditor
				var ctrl = this;
				$(element).attr('idType', scope.dynaAutocomplete);
				$timeout(function(){
					/**
					 * autocompleteDelegate : Personalize autocomplete (first implementation for taostui editor)
					 * {
					 * 		openTrigger: function (baseElement, assistant) {} - > function that should call assistant.openAssistant(); to open the template.
					 * }
					 * 
					*/
					AutoComplete.eformWrap($(element), null, ctrl.autocompleteDelegate);
				});
			}]
		};
	}]);

	tempAssist.factory('TemplateAssistAction', [function(){
		var accessor = {
			setPayload: function(payload){
				accessor.payload = payload;
			},
			clearPayload: function(){
				delete accessor.payload;
			},
			actionOnPayload: function(param){
				if(accessor.payload && accessor.payload.actionOnPayload){
					accessor.payload.actionOnPayload(param);
				}
			}
		}
		return accessor;
	}]);

	tempAssist.controller('TemplateAssistFillController',
			['$scope', 'model','$filter','TempAssistAccessor', 'TemplateAssistAction',
			 function($scope, model,$filter, TempAssistAccessor, TemplateAssistAction){
		$scope.template.res = TempAssistAccessor.computeDesc($scope.template, true); 
		$scope.template.vars = $filter('filter')($scope.template.sections, {className: '!DRaw'}); 
		$scope.readyToFill = false;
		$scope.updateVar = function(tempVar){
			var orig = $scope.template.text;
			$scope.template.res = TempAssistAccessor.computeDesc($scope.template, true);
			$scope.readyToFill = isReadyToFill();
		};
		
		function setDefaults(){
			for(var i = 0; i < $scope.template.vars.length; i++){
				if($scope.template.vars[i].className === 'DText'){
					
				}
				if($scope.template.vars[i].className === 'DNum'){
					if($scope.template.vars[i].typeDeMesure && $scope.template.vars[i].typeDeMesure !== 'S_O'){
						$scope.template.vars[i].structured = true;
					}
				}
				if($scope.template.vars[i].className === 'DDate'){
					if($scope.template.vars[i].todayAuto){
						$scope.template.vars[i].m = moment().format("YYYY-MM-DD");
					}
					$scope.template.vars[i].varDynaDateOptions = {
						acceptFutureDate: $scope.template.vars[i].allowFuture ? true : false,
						acceptPastDate: $scope.template.vars[i].allowPast ? true : false,
					};
				}
				if($scope.template.vars[i].className === 'DList'){
					if($scope.template.vars[i].typeDeDonnee && $scope.template.vars[i].typeDeDonnee !== 'S_O'){
						$scope.template.vars[i].structured = true;
					}
					if($scope.template.vars[i].defaultItem !== undefined){
						$scope.toogleList($scope.template.vars[i], 
							$scope.template.vars[i].items[$scope.template.vars[i].defaultItem]);
					}
				}
			}
			$scope.updateVar();
		}
		function isReadyToFill (){
			for(i = 0; i< $scope.template.sections.length; i++){
				if($scope.template.sections[i].required &&  !$scope.template.sections[i].m){
					return false;
				}
			}
			return true;
		}
		
		$scope.toogleList = function(templateVar, item){
			if(!templateVar.selectedItems)templateVar.selectedItems = [];
			var i = templateVar.selectedItems.indexOf(item) ;
			if(i< 0){
				if(!templateVar.multiple){
					templateVar.selectedItems = [];
				}
				templateVar.selectedItems.push(item);
			}else{
				templateVar.selectedItems.splice(i, 1);
			}
			templateVar.m = toStringList(templateVar);
		};
		
		function toStringList(templateVar){
			var str = "";
			for(i = 0; i< templateVar.selectedItems.length; i++){
				if(templateVar.selectedItems[i] !== undefined){
					str += templateVar.selectedItems[i] + templateVar.separator;
				}
			}
			str = str.substring(0, str.lastIndexOf(templateVar.separator));
			return str;
		}
		
		$scope.submitTemplate = function(){
			TemplateAssistAction.actionOnPayload($scope.template);
			$scope.fl.ok(TempAssistAccessor.computeDesc($scope.template, false, true));
		};
		
		setDefaults();
	}]);
	
})();