(function(){
	var user = angular.module("user");
	
    //Replacing professional table directive, also taking care of opening modal form for new professional
    user.directive('userView', ['model', 'UserAccessor','$timeout','ModificationStatus','PatientFormService','$filter','QConfirm','DashAPI',
    function(model, UserAccessor, $timeout, ModificationStatus, PatientFormService, $filter, QConfirm, DashAPI){
        return {
            restrict: 'E',
            templateUrl: '/dashboard/resources/ofys/user/profil/user_view.html?v=ay',
            scope: {
                base:'=',
                origBase:'=',
                formOptions: '='
            },
            link: function(scope, element, attrs){
                scope.model = model;
                scope.isUserAdmin = model.user().isUserAdmin;

                scope.validFromDateDynaDateOptions = {
                    acceptFutureDate: true,
                }
                scope.validToDateDynaDateOptions = {
                    acceptFutureDate: true,
                }
                scope.crisisRoleEndDynaDateOptions = {
                    acceptFutureDate: true,
                }

                scope.closeView = function(){
                    if(scope.formOptions.exit){
                        scope.formOptions.exit();
                    }
                }
                scope.unblockUser = function(){
                    if(scope.base.user.isBlocked){
                        UserAccessor.unblockUser(scope.base.user.id, function(res){
                            scope.base.user.isBlocked = false;
                            scope.base.user.lockUntilRefreshed = true;//Bug de version modif 
                            model.notice().success($filter("translate")("unblockUserSuccess"))
                        });
                    }
                }

                scope.changeOwnPassword = function(){
                    var qconfirmOptions = {templateUrl: 'changePasswordFrm_index.html',
                        changePass: {password: "", confirmPassword:""},
                        qconfirm: {
                            hideNo: true,
                            yesTitle: "Save",
                            beforeYes: function(e, obj){
                                if(obj.qconfirm.frm && obj.qconfirm.frm.$valid){
                                    sendChangePassword(obj.qconfirm.frm, obj.changePass);
                                }else{
                                    obj.qconfirm.frm.errorMsgs = PatientFormService.getFormErrors(obj.qconfirm.frm,null, 
                                        {compareTo: "Mismatch"});
                                    e.prevent();
                                }
                            }
                    }};
                    QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(){});
                }

                function update2FAActiveConfigured(base, active, configured){
                    base.user.twoFactorActive = active;
                    base.user.twoFactorConfigured = configured;
                }
                function update2FAConfirmationEmail(base, active, configured){
                    base.user.twoFactorEmail = active;
                }
                scope.deactivateTwoFactorAuth = function(){

                    QConfirm.open({title: $filter('translate')(model.clientPreferences().twoFactorEnforced?'ConfirmReconfigureTwoFactor':'ConfirmDeactivateTwoFactor')}, {windowClass:'top-modal'}).then(function(ok){
                        if(ok){
                            var params = "?userId="+scope.base.user.id
                            DashAPI.get("/dashboard/Login/ws/deleteTwoFactor"+params, function (res) {
                                if(res){
                                    update2FAActiveConfigured(scope.base, false, false);//UI
                                    update2FAActiveConfigured(scope.origBase, false, false);//Model update
                                }
                            });
                        }
                    });
                }
                scope.activateTwoFactorAuthUserAdmin = function(){
                    QConfirm.open({title: $filter('translate')('ConfirmActivateTwoFactorUserAdmin')}, {windowClass:'top-modal'}).then(function(ok){
                        if(ok){
                            DashAPI.post("/dashboard/Login/ws/saveTwoFactorConfig",{userId:scope.base.user.id}, function (res) {
                                if(res){
                                    update2FAActiveConfigured(scope.base, true, false);//UI
                                    update2FAActiveConfigured(scope.origBase, true, false);//Model update
                                }
                            }, function(){
                            });
                        }
                    });
                }

                function getTwoFactorSteps (reconfigure){
                    var twoFactorFormCtrler = {
                        steps:[
                            {
                                template: "download_configureTwoFactorFrm.html",
                                next:function(step, twoFactorCtrler, modalCtrler){
                                    twoFactorCtrler.page += 1;
                                    if(twoFactorCtrler.code == undefined){
                                        DashAPI.get("/dashboard/Login/ws/configureTwoFactor", function (res) {
                                            if(res.qrCode != null){
                                                res.qrCodePng = "data:image/png;base64," +OfysUtils.byteArrayToBase64(res.qrCode);
                                                res.qrCodeTemplate = 'qr_configureTwoFactorFrmImageTemplate_index.html';
                                            }
                                            if(res.secret != null){
                                                res.secretReadable = res.secret.replace(/(.{4})/g,"$1 ").split(" ");
                                            }
                                            twoFactorCtrler.code = res;
                                            
                                        });
                                    }
                                    return true;
                                }
                            },
                            {
                                template: "qr_configureTwoFactorFrm.html",
                                next:function(step, twoFactorCtrler, modalCtrler){
                                    if(!reconfigure){
                                        twoFactorCtrler.page += 1;
                                    }
                                    return !reconfigure;
                                }
                            },
                            {
                                template: "code_configureTwoFactorFrm.html",
                                next:function(step, twoFactorCtrler, modalCtrler){
                                    twoFactorCtrler.validating = true;
                                    if(twoFactorCtrler.validationCode == undefined || 
                                        twoFactorCtrler.validationCode.length < 6 ||
                                        isNaN(twoFactorCtrler.validationCode)){
                                        twoFactorCtrler.codeInvalid = true;
                                        twoFactorCtrler.validating = false;
                                    }else{
                                        DashAPI.post("/dashboard/Login/ws/saveTwoFactorConfig", {code:twoFactorCtrler.validationCode , sec:twoFactorCtrler.code.secret}, function (res) {
                                            twoFactorCtrler.validating = false;
                                            twoFactorCtrler.codeInvalid = !res;
                                            if(res){

                                                update2FAActiveConfigured(scope.base, true, true);//UI
                                                update2FAActiveConfigured(scope.origBase, true, true);//Model update
                                                twoFactorCtrler.page += 1;
                                            }
                                        }, function(){
                                            twoFactorCtrler.validating = false;
                                        });
                                    }
                                    return true;
                                }
                            },
                            {
                                template: "recovery_configureTwoFactorFrm.html",
                                sendConfirmationEmail: function(step, twoFactorCtrler){
                                    twoFactorCtrler.validating =true;
                                    var params = {email:twoFactorCtrler.recoveryEmail, lang: DashAPI.lang};
                                    DashAPI.post("/dashboard/Login/ws/sendTwoFactorCodeToEmail", params, function (res) {
                                        // $timeout(function(){// ensure that there is at least a visible laoding time to show the user that the action is being processed.
                                            // console.log(res);
                                            twoFactorCtrler.validating =false;
                                            twoFactorCtrler.recoveryEmailCodeSent = true;
                                            twoFactorCtrler.recoveryEmailCodeSentTo = params.email;
                                            twoFactorCtrler.emailValidationId = res;
                                            if(twoFactorCtrler.emailValidationId != null){
                                                twoFactorCtrler.emailValidationExpiry = moment().add(30, "m") //extend the default 30 seconds to 30 mins for email to account for email delivery wait times
                                            }
                                        // }, 200)
                                    }, function(){
                                        twoFactorCtrler.validating = false;
                                    });
                                },
                                skipRecoveryEmailStep:function(step, twoFactorCtrler){
                                    twoFactorCtrler.validating =false;
                                    twoFactorCtrler.page += 1;
                                },
                                emailWithCode: function(twoFactorCtrler){
                                    return twoFactorCtrler.recoveryEmailCodeSent && 
                                    twoFactorCtrler.recoveryEmailCodeSentTo == twoFactorCtrler.recoveryEmail;
                                },
                                next:function(step, twoFactorCtrler, modalCtrler){
                                    function clearErrorMsgs(){
                                        if(modalCtrler.qconfirm.frm == undefined){
                                            modalCtrler.qconfirm.frm = {};
                                        }
                                        modalCtrler.qconfirm.frm.errorMsgs = [];
                                    }
                                    function validFailed(){
                                        twoFactorCtrler.validating =false;
                                        clearErrorMsgs();
                                        modalCtrler.qconfirm.frm.errorMsgs.push({msg:"AUTH_2_FACTEUR_INVALIDE"});
                                    }
                                    function emailValidationFailed(){
                                        twoFactorCtrler.validating =false;
                                        clearErrorMsgs();
                                        modalCtrler.qconfirm.frm.errorMsgs.push({msg:"AUTH_2_FACTEUR_EMAIL_INVALIDE"});
                                    }


                                    twoFactorCtrler.validating =true;
                                    if(!this.emailWithCode(twoFactorCtrler)){
                                        if(twoFactorCtrler.recoveryEmail != null && twoFactorCtrler.recoveryEmail.length > 0){
                                            clearErrorMsgs();
                                            this.sendConfirmationEmail(step, twoFactorCtrler);
                                        }else{
                                            emailValidationFailed();
                                        }
                                    }else{
                                        if(twoFactorCtrler.recoveryEmailCode != null){
                                            var validationId = btoa(twoFactorCtrler.recoveryEmailCode);

                                            function saveEmailAndNext(code){
                                                clearErrorMsgs();
                                                DashAPI.post("/dashboard/Login/ws/saveTwoFactorConfigEmail", {email:twoFactorCtrler.recoveryEmail, code: code}, function (res) {
                                                    if(res === false){
                                                        validFailed();
                                                    }else{
                                                        twoFactorCtrler.validating =false;
                                                        twoFactorCtrler.page += 1;
                                                        
                                                        update2FAConfirmationEmail(scope.base, twoFactorCtrler.recoveryEmail);//UI
                                                        update2FAConfirmationEmail(scope.origBase, twoFactorCtrler.recoveryEmail);//Model update
                                                    }
                                                }, function(){
                                                    twoFactorCtrler.validating = false;
                                                });
                                            }

                                            //Valid and unexpired
                                            if(OfysUtils.isEmpty(twoFactorCtrler.emailValidationId) == false && 
                                                validationId == twoFactorCtrler.emailValidationId && 
                                                moment().isBefore(twoFactorCtrler.emailValidationExpiry)){
                                                    saveEmailAndNext();
                                            }else if(OfysUtils.isEmpty(twoFactorCtrler.emailValidationId)){
                                                saveEmailAndNext(twoFactorCtrler.recoveryEmailCode);
                                            }else{
                                                validFailed();
                                            }
                                            
                                        }
                                    }
                                    return true;
                                }
                            },
                            {
                                template: "success_configureTwoFactorFrm.html",
                                next:function(step, twoFactorCtrler, modalCtrler){
                                    return false;
                                }
                            },
                        ],
                        page: 0
                    }
                    return twoFactorFormCtrler;
                }

                function openTwoFactorSteps(twoFactorFormCtrler){
                    var qconfirmOptions = {templateUrl: '/dashboard/resources/ofys/user/configureTwoFactorFrm.html?v=ay',
                    configObj: twoFactorFormCtrler,
                    qconfirm: {
                        hideNo: true,
                        yesTitle: "Next",
                        beforeYes: function(e, obj){
                            var step = twoFactorFormCtrler.steps[twoFactorFormCtrler.page];
                            
                            if(step.next(step, twoFactorFormCtrler, obj)){
                                e.prevent();
                            }
                            if(obj.configTwoFactorFrm){
                                console.log(obj.configTwoFactorFrm);
                            }
                        }
                    }};
                    QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(){});
                }

                scope.activateTwoFactorAuth = function(reconfigure){
                    var twoFactorFormCtrler = getTwoFactorSteps(reconfigure);
                    openTwoFactorSteps(twoFactorFormCtrler);
                }
                scope.twoFactorEnforced = function(){
					return model.clientPreferences().twoFactorEnforced;
				}

                scope.addTwoFactorEmail = function(reconfigure){
                    var twoFactorFormCtrler = getTwoFactorSteps(reconfigure);
                    twoFactorFormCtrler.page = 3;//Recovery email step.
                    twoFactorFormCtrler.changeEmail = true;
                    openTwoFactorSteps(twoFactorFormCtrler);
                }

                scope.removeTwoFactorEmail = function(reconfigure){
                    var qconfirmOptions = {title: $filter('translate')('CONFIRM_REMOVE_RECOVERY_EMAIL')};
                    QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(proceed, function(){});
                    function proceed(proceed){
                        if(proceed){
                            DashAPI.post("/dashboard/Login/ws/saveTwoFactorConfigEmail", {email:null}, function (res) {
                                update2FAConfirmationEmail(scope.base, null);//UI
                                update2FAConfirmationEmail(scope.origBase, null);//Model update
                            });
                        }
                    }
                }

                function sendChangePassword(frm, changePass) {
                    if (frm.$valid) {
                        DashAPI.post("/dashboard/Login/ws/changePassword", changePass, function (res) {
                            model.notice().success($filter("translate")("passwordChangeSuccess"))
                            //console.log(res);
                        });
                    } else {
                        model.notice().fail($filter('translate')("invalidOrIncomplet"))
                    }
                };

    //				if(!scope.showUserForm){
    //					return ;
    //				}
                var defaultUser = {
                    isNew: true,
                    modificationStatus: ModificationStatus.STATUS_NEW,
                    mustChangePassword: true,
                    changePassword: true,
                    role: []
                }
                var frmApi = {
                    isDirty:function(){
                        return scope.userform && scope.userform.$dirty
                    },
                    okToClose(){
                        if(scope.base.isUser==false && scope.base.user && scope.base.user.isNew ){
                            delete scope.base.user;
                        }
                        if(scope.userform && scope.userform.$dirty){
                            if (scope.base.user) {
                                if (scope.base.isUser==false) {
                                    scope.base.user.modificationStatus = ModificationStatus.STATUS_DELETED;
                                    scope.base.user.isDeleted = true;
                                } else {
                                    if (scope.base.user.modificationStatus==undefined || scope.base.user.modificationStatus != ModificationStatus.STATUS_NEW) {
                                        scope.base.user.modificationStatus = ModificationStatus.STATUS_UPDATED;
                                    }
                                    scope.base.user.isDeleted = false;
                                }
                            }
                        }
                        
                        if(scope.userform){
                            scope.userFormErrors = PatientFormService.getFormErrors(scope.userform,null, {compareTo: "Mismatch"})
                        }
                        if(scope.userFormErrors && scope.userFormErrors.length > 0){
                            return false;
                        }
                        return true;
                    },
                    reset: function(){
                        if (scope.userform) {
                            scope.userform.$setPristine();
                            updateRoles();							
                        }
                    }
                };

                scope.updateFormOptions = function (){
                    if(scope.formOptions && scope.formOptions.children){
                        scope.formOptions.children.push(frmApi);
                    }
                }
                
                scope.$watch(scope.formOptions, scope.updateFormOptions)
                
                scope.initUser = function (){
                    if(scope.base && scope.base.isUser && !scope.base.user){
                        scope.base.user = angular.copy(defaultUser);
                        scope.base.user.basePerson = scope.base.idPerson;
                    }
                }

                scope.changePassword = function(){
                    if(!scope.base.user.changePassword){
                        $timeout(scope.focusWritePassword, 100)
                    }
                    scope.base.user.changePassword = !scope.base.user.changePassword;
                }
                scope.selectedUserRoles = ["USER_MANAGEMENT", "ADMIN", "HEALTHCARE_PROVIDER", "STAGIAIRE", "BILLING"]
                scope.selectedUserEmployeeRoles = ["USER_MANAGEMENT", "ADMIN", "MEDICAL_SECRETARY", "SECRETARY","BILLING"]
                UserAccessor.getAllUserRoles(function(userRoles){
                    scope.userRolesObj = userRoles
                    scope.userRolesLst = scope.selectedUserRoles.map(function(role){
                        return userRoles[role];
                    });
                    scope.userEmployeeRolesLst = scope.selectedUserEmployeeRoles.map(function(role){
                        return userRoles[role];
                    })
                    
                    scope.normalUserEmployeeRoles = {
                        name: "roleSelector",
                        list: scope.userEmployeeRolesLst,
                        selectable: false,
                        toModel: function(i){
                            return i.type;     
                        },
                        selectorName:function (s) {
                            return s.i18n;
                        },
                        setDirty: function(){
                            scope.userform.$setDirty();
                        },
                        inputPlaceHolder: $filter("translate")("AddRole"),
                    };

                    scope.normalUserRoles = {
                        name: "roleSelector",
                        list: scope.userRolesLst,
                        selectable: false,
                        toModel: function(i){
                            return i.type;     
                        },
                        selectorName:function (s) {
                            return s.i18n;
                        },
                        setDirty: function(){
                            scope.userform.$setDirty();
                        },
                        inputPlaceHolder: $filter("translate")("AddRole"),
                    };
                    
                    scope.crisisUserEmployeeRoles = {
                        name: "crisisRoleSelector",
                        list: scope.userEmployeeRolesLst,
                        selectable: false,
                        toModel: function(i){
                            return i.type;
                        },
                        selectorName:function (s) {
                            return s.i18n;
                        },
                        inputPlaceHolder: $filter("translate")("AddRole"),
                    };

                    scope.crisisUserRoles = {
                        name: "crisisRoleSelector",
                        list: scope.userRolesLst,
                        selectable: false,
                        toModel: function(i){
                            return i.type;
                        },
                        selectorName:function (s) {
                            return s.i18n;
                        },
                        inputPlaceHolder: $filter("translate")("AddRole"),
                    };
                });

                function updateRoles(){
                    $timeout(function(){
                        if(scope.normalUserRoles && scope.normalUserRoles.update){
                            scope.normalUserRoles.update()
                        }
                        if(scope.crisisUserRoles && scope.crisisUserRoles.update){
                            scope.normalUserRoles.update()
                        }
                        if(scope.normalUserEmployeeRoles && scope.normalUserEmployeeRoles.update){
                            scope.normalUserEmployeeRoles.update()
                        }
                        if(scope.crisisUserEmployeeRoles && scope.crisisUserEmployeeRoles.update){
                            scope.normalUserEmployeeRoles.update()
                        }
                    },50)
                }
                var profClassNames = ["CProfessional",'CBaseProfessionnal']
                function update(){
                    if(scope.base){
                        scope.isProf = profClassNames.includes(scope.base.className);
                        if(model.user().profil.id > 0){
                            scope.isUserOwnData = model.user().profil.id==scope.base.id;
                        }else{
                            scope.isUserOwnData = model.user().session.user.id==scope.base.id;
                        }
                    }
                }
                scope.$watch(function(){
                    return scope.base
                }, update)
            }
        };
    }]);
})();