(function(){
	var pref = angular.module('pref', ['ngSanitize']);
	pref.factory('PrefAccessor', ['DashAPI','$filter',
	                            function(DashAPI, $filter ) {

		var accessor = {
			utils : {
			},
			browserSettings: {
				'list_qv_size': '1',
			},
			loadInitialBrowserSettings: function () {
				var settings = Object.keys(this.browserSettings);
				for (var i = 0; i < settings.length; i++){
					if(localStorage.getItem(settings[i]) != undefined){
						this.browserSettings[settings[i]] = localStorage.getItem(settings[i])
					}
				}
			},
			setBrowserProp: function (key,value) {
				this.browserSettings[key] = value;
				localStorage.setItem(key, value);
			},
			getUserSettings : function (keys, callback, error){
				DashAPI.get("/dashboard/pref/ws/getUserSetting?keys="+ keys, callback, error);
			},
			setUserSettings : function (keysdatapair, callback, error){
				DashAPI.get("/dashboard/pref/ws/setUserSetting?keysdatapair="+ keysdatapair, callback, error);
			},
			saveUserPref : function (data, callback, error){
				DashAPI.post("/dashboard/pref/ws/user/savePref", data, callback, error);
			},
			getUserProp : function (data, callback, error){
				DashAPI.post("/dashboard/pref/ws/user/get", data, callback, error);
			},
			contextSite: function(callback, error){
				DashAPI.get('/dashboard/pref/ws/contextSite', callback, error);
			},
			setContextSite: function(data, callback, error){
				DashAPI.post('/dashboard/pref/ws/contextSite',data, callback, error);
			},
			getGlobalProp : function (data, callback, error){
				DashAPI.post("/dashboard/pref/ws/global/get", data, callback, error);
			},
			setUserProp : function (data, callback, error){
				DashAPI.post("/dashboard/pref/ws/user/set", data, callback, error);
			},
			setGlobalProp : function (data, callback, error){
				DashAPI.post("/dashboard/pref/ws/global/set", data, callback, error);
			},
			restartJetty : function (q, callback, error){
				DashAPI.post("/dashboard/pref/ws/jetty_restart", q, callback, error);
			},
			getWebLinks : function (q, callback, error){
				//If linkId is not provided, null or 0, the whole list of weblink in ofys are added.
				var url = "/dashboard/pref/ws/getWebLinks" + (q ? "?linkId=" + q : "");
				DashAPI.get(url, callback, error);
			}
		}
		accessor.loadInitialBrowserSettings();
		return accessor;
	}]);

	pref.controller('PrefController', ['$scope', 'model', '$filter','Notification',
	                                  function($scope, model, $filter, Notification){
		// TODO
	}]);

	pref.controller('WorksiteSettingsController', ['$scope', 'model', 'PrefAccessor', '$log', 'Store',
		function($scope, model, PrefAccessor, $log, Store){
		$scope.siteSettings = {}
		$scope.workSites = angular.copy(Store.sites.filter.workSites.list()).map(function(e){
			e.isCurrent = function(site){
				if(site){
					var currSite = this;
					model.user().session.setWorkSite(currSite);
					PrefAccessor.setContextSite({site: currSite.id}, function(){ }, function(e){
						$log.error("Failed to set the site with id "+ currSite);
					});
				}
				return model.user().session.site === this.id;
			}
			return e;
		});

		$scope.activateAllFilters = function(){
			model.prefSettings("user_settings_SiteAppointments", true);
			model.prefSettings("user_settings_SiteLaboDocs", true);
			model.prefSettings("user_settings_SitePatients", true);
			model.prefSettings("user_settings_SiteMessages", true);
			model.prefSettings("user_settings_SiteTasks", true);
		}
		$scope.desactivateAllFilters = function(){
			model.prefSettings("user_settings_SiteAppointments", false);
			model.prefSettings("user_settings_SiteLaboDocs", false);
			model.prefSettings("user_settings_SitePatients", false);
			model.prefSettings("user_settings_SiteMessages", false);
			model.prefSettings("user_settings_SiteTasks", false);
		}

		model.addPrefSettings([
			'SiteAppointments',
			'SiteLaboDocs',
			'SitePatients',
			'SiteMessages',
			'SiteTasks',
		], $scope.siteSettings, 'user_settings_');
	}]);

	pref.controller('UserSettingsController', ['$scope', 'model','DashAPI','$http','SessionWatch','$filter',
	                                  function($scope, model, DashAPI, $http, SessionWatch, $filter){
		$scope.userSettings= {};
		model.addPrefSettings(['ShowAllLabs'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowRecPos'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowSuggPos'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['AlwaysShowOtherProv'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowMoreDemoData'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowAllProfsInAppt'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowCanceledAppt'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowAllProfsInLaboDoc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ExcludeMySeenLaboDoc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowProfsReplacedInLaboDoc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['SearchMdProvNB'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['SetSeenAuto'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['AlwaysAddBilling'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['AddSvInEnc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['AddMesuresInEnc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['AddConclusionInEnc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['DirectPrint'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['PrintRxDevSep'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['NoShowSignWarning'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowSummaryDxInEnc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['labOneLine'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['docOneLine'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['showLaboDocComments'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['UseNewPDFViewer'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['labodoc_savenext'], $scope.userSettings, '');

		this.logout = function () {
			DashAPI.get("/dashboard/Login/ws/logout", function (res) {
				model.logout();
				//console.log(res);
			}, function (err) {
				console.log(err);
			});
		}

		$scope.isDownloading = false;
		this.assist = function() {
			if ($scope.isDownloading===false) {
				$scope.isDownloading=true;
				 if (model.isWeb()) {
					 var app = OfysUtils.isMac===true ? 'AnyDesk.dmg' : (OfysUtils.isWin===true ? 'AnyDesk.exe' : undefined);
					 // SEE https://stackoverflow.com/questions/43262121/trying-to-use-fetch-and-pass-in-mode-no-cors
					 if (app) {
						 //var proxyUrl = 'https://cors-anywhere.herokuapp.com/',
						 //targetUrl = 'https://www.ofys.ca/tv/' + app;
						 targetUrl = 'https://ofys.net/download/tv/' + app;
						 //fetch(proxyUrl+targetUrl)
						 fetch(targetUrl)
						 .then(function(resp) {
							 return resp.blob()
							})
						 .then(function(blob) {
							 var url = window.URL.createObjectURL(blob);
							 var a = document.createElement('a');
							 a.style.display = 'none';
							 a.href = url;
							 // the filename you want
							 a.download = app;
							 document.body.appendChild(a);
							 a.click();
							 window.URL.revokeObjectURL(url);
							 $scope.isDownloading = false;
							model.notice().success($filter('translate')('DOWNLOAD_SUCCESS'));
						 })
						 .catch(function(err) {
							 $scope.isDownloading = false;
							 alert('Erreur / Error!\n' + err);
						 });
					 }
				 } else {
					 DashAPI.get("/dashboard/Login/ws/assist", function (res) {
						 $scope.isDownloading = false;
					 }, function (err) {
						 $scope.isDownloading = false;
						 console.log(err);
					 });
				 }
			}
		};
		this.lockSession = function () {
			DashAPI.get("/dashboard/Login/ws/logout", function (res) {
				SessionWatch.status = 'EXPIRED';
			}, function (err) {
				console.log(err);
			});
		}
		$scope.isWeb = model.isWeb();
		this.toggleLang = function () {
			DashAPI.updateLanguage(DashAPI.lang === 'fr'? 'en': 'fr');
			// this is a get call since updateLanguages sets the cookie, this calls also updates the locale server side.
			$http.get('/dashboard/User/ws/lang');
			model.translationUpdate("translation", true);
		}
	}]);

})();