(function () {
    var recall = angular.module('recall', []);
    recall.factory('RecallAccessor', ['DashAPI', 'MessageLink', 'model','$filter', 'QuickEdit',
                function(DashAPI, MessageLink, model, $filter, QuickEdit) {
        var labels = {data: [], fetched:false};

		var accessor = {
			utils:{
				labelsListSearchIn : function (query, resolve, reject){
					accessor.labels(function(v){
						if (query) {
							var searchTextRegExp = OfysUtils.searchRegExpArray(query);
							resolve(v.filter(function(a){return OfysUtils.matchInRegExpArray(searchTextRegExp, a.nameLc);}));
						} else {
							resolve(v);
						}
					}, reject);
				}
			},
			labels : function (callback, error){
				if(labels.fetched===true){
					if (callback) callback(labels.data);
				}else{
					DashAPI.get('/dashboard/docs/ws/alllabels?type=WAIT_LIST', function(res){
                        OfysUtils.fuzzyListSearch(res.data, "name");
						labels.data = res.data;
						if (callback) callback(labels.data);
					}, error);
				}
            },
            openNew: function (data, callback, error) {
                return QuickEdit.open({ quickEditData: { qeActData: { className: "CPatientRecall" } }, templateUrl: "qe_task_editor_index.html", heading: "Nouvelle tâche" });
            },
            save: function(data, callback, error){
                return DashAPI.post('/dashboard/apps/ws/save?type=CPatientRecall', data, callback, error);
            },
			msgLinkMap:{},//Used for message/task link of current document.
			updateMessageLink: function (patient,scope){
				accessor.messageLinkKey = MessageLink.setLinkType({
					patient: patient.id,
					linkType: MessageLink.linkTypes.patient,
					id: patient.id,
					pat: patient
				},scope);
				accessor.msgLinkMap[patient.uid] = accessor.messageLinkKey
			}
		};

		return accessor;
    }]);


    recall.directive("recallView", ['model','RecallAccessor','$q','PatientAccessor', '$filter','utils','$timeout','ModificationStatus','QuickView','QValidation','Event','QConfirm', 'MessageLink',
            function(model, RecallAccessor, $q, PatientAccessor, $filter, utils, $timeout, ModificationStatus, QuickView, QValidation, Event, QConfirm, MessageLink){
        return {
            restrict: 'E',
            templateUrl: '/dashboard/resources/ofys/recall/recall_view.html?v=ba',
            scope: true,
            link: function (scope, element, attrs) {
                scope.allLables = [];
                searchLabels = {};
                scope.allRecallStatus = [
                    {val:'NORMAL',name:'RECALL_NORMAL'},
                    {val:'CANCELED',name:'RECALL_CANCELED'},
                    {val:'CLIENT_NOT_REACHED',name:'RECALL_CLIENT_NOT_REACHED'},
                    {val:'APPOINTMENT_GIVEN',name:'RECALL_APPOINTMENT_GIVEN'}
                ];

                scope.allRecallTimePref = [
                    {val:'NONE',name:'RECALL_PT_NONE'},
                    {val:'AM',name:'RECALL_PT_AM'},
                    {val:'PM',name:'RECALL_PT_PM'},
                    {val:'EVENING',name:'RECALL_PT_EVENING'}
                ];

                scope.allPriorities = [
                    {val:'NORMAL',name:'RECALL_P_NORMAL'},
                    {val:'IMPORTANT',name:'RECALL_P_IMPORTANT'},
                    {val:'WITHOUT_FAIL',name:'RECALL_P_WITHOUT_FAIL'}
                ];

                RecallAccessor.labels(function(labels){
                    scope.allLables = labels;
                    labels.forEach(function(lb){
                        searchLabels[lb.id] = lb;
                    })
                });

                function update(){
                    scope.recall = scope.$eval(attrs.view);
                    scope.quickViewData = scope.$eval(attrs.quickViewData);
                    scope.recall.save = scope.save;
                    loadRecall(scope.recall);
                    model.safeCall(addEventsEvent);
                    if(scope.recall && scope.recall.editMode){
                        scope.edit(scope.recall);
                    }
					scope.linkManager = MessageLink.linkManager(RecallAccessor, scope.quickViewData.pat, scope.quickViewData.pat.uid, scope)
                }

                scope.edit = function(recall){
                    recall.editMode = true;
                    // pour les new recall, si user actif == prof, assigner tout de suite ici
                    if (recall.id === undefined && recall.professionnal === undefined && model.user().isProf===true) {
                    	recall.professionnal = model.user().profil.id;
                    }
                    recall.viewbag = {
                        editRecall: angular.copy(recall),
                        patientName: scope.patName(recall.patient)
                    };

                    if(recall.labels){
                        recall.viewbag.editRecall.editLabels = {};
                        recall.viewbag.editRecall.viewbag = {};
                        recall.labels.forEach(function(labl){
                            recall.viewbag.editRecall.editLabels[labl.id] = true;
                        });
                    }
                    if (recall.professionnal) {
                    	setViewProf(recall.viewbag.editRecall);
                    }
                    registerDirty(recall);
                }

                function setViewProf(recall){
                    if(recall.professionnal){
                        recall.viewbag.prof =  scope.lstProfs.find(function(prof){return prof.id === recall.professionnal;});
						scope.recall.viewbag.editRecall.profName = scope.profName(recall.viewbag.prof);
                    }
                    if(recall.referringProfessionnal){
                        recall.viewbag.refprof =  scope.lstProfs.find(function(prof){ return prof.id === recall.referringProfessionnal;});
                    }
                }
                scope.recallDateDynaDateOptions = {
                    format: 'YYYY-MM-DD',
                    acceptFutureDate: true,
                    onDateSelected: function (mDate, dAssist) {
                        if (scope.recall) {
                            var m = mDate.format(dAssist.format);
                            scope.recall.viewbag.editRecall.dateRecall = m;
                            // console.log(m);
                        }
                    }
                };
                var patientSearchTemplate = '/dashboard/resources/ofys/pat/profil/patient_searchItem.html?v=ba';
				utils.getTemplate(patientSearchTemplate);
				scope.patientSearchAssist = {
					assistId: "autocomplete_recall_patient",
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					dynaType: document.getElementsByTagName("BODY")[0],
					trigger: 'focus',
					getAsyncData: function(query, assist){
						query = query.replace(',', '');//make sure that composed names with commas are searchable too
						return $q(function(resolve, reject) {
							if(query.length > 2){
								PatientAccessor.search(b64EncodeUnicode(query), function(res){
									resolve(res.data);
								}, angular.noop);
							}else{
								resolve([]);
							}
						});
					},
					getKey: function(recipient) {
						var newScope = scope.$new();
						newScope.item = recipient;
						var res =  utils.getTemplateAndCompileSync(newScope, patientSearchTemplate);
						$timeout(function(){
							if(!newScope.$$phase) {
								newScope.$digest();
							}
						},0);
						return res;
					},
					selection: function(pat, assistObject) {
						scope.recall.viewbag.editRecall.patient = pat;
						return scope.patName(pat);
					}
                };
                scope.lstProfs = $filter('orderBy')(model.store.profs.list(), ['lastName', 'firstName']);
				scope.lstProfs.splice(0, 0, {});
				scope.professionalSearchAssist = {
					assistId: "autocomplete_recall_prof",
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					dynaType: document.getElementsByTagName("BODY")[0],
					minChar: 0,
					trigger: 'focus',
					getAsyncData: function(query, assist){
						return $q(function(resolve, reject) {
							resolve($filter('filter')(scope.lstProfs, query));
						});
					},
					getKey: function(prof) {
						return scope.profName(prof);
					},
					selection: function(prof, assistObject) {
						scope.recall.viewbag.editRecall.profName = scope.profName(prof);
                        scope.recall.viewbag.editRecall.professionnal = prof.id;
                        setViewProf(scope.recall.viewbag.editRecall);
						return scope.recall.viewbag.editRecall.profName;
					}
                };


                scope.profName = function(prof){
					return prof.lastName + ', '+ prof.firstName + ' (' + prof.code + ')';
                }

                scope.patName = function (pat){
                    if(pat){
                        return pat.lastName + ', '+ pat.firstName;
                    }
                    return "";
                }

                scope.removeProf = function(recall){
                    delete recall.professionnal;
                    delete recall.profName;
                    delete scope.recall.viewbag.editRecall.viewbag.prof;
                }

                scope.removeRefProf = function(recall){
                    delete recall.referringProfessionnal;
                    delete recall.refProfName;
                    delete scope.recall.viewbag.editRecall.viewbag.refprof;
                }

                scope.refProfSearchAssist = angular.copy(scope.professionalSearchAssist);
				scope.refProfSearchAssist.dynaType = document.getElementsByTagName("BODY")[0]
				scope.refProfSearchAssist.assistId = "autocomplete_recall_ref_prof";
				scope.refProfSearchAssist.selection = function(prof, assistObject){
                    scope.recall.viewbag.editRecall.refProfName = scope.profName(prof);
                    scope.recall.viewbag.editRecall.referringProfessionnal = prof.id;
                    setViewProf(scope.recall.viewbag.editRecall);
                    return scope.recall.viewbag.editRecall.refProfName;
                };

                var registeredDirtyId;
                function registerDirty(recall){
                    if(recall.id){
                        registeredDirtyId = "patientrecall_"+recall.id;
                    }else{
                        registeredDirtyId = "patientrecall_New"+ (Math.floor(Math.random() * 1000) + 1);
                    }
                    QValidation.registerDirty(registeredDirtyId, function(){
                        return scope.save(recall.viewbag.editRecall, recall);
                    }, function(){
                        return scope.cancel(recall);
                    });
                }

                function unregisterDirty(){
                    if(registeredDirtyId){
                        QValidation.unregisterDirty(registeredDirtyId);
                        registeredDirtyId = undefined;
                    }
                }

                if(scope.qv){
					scope.qv.isDirty = function(){
						return !!(registeredDirtyId);
					};
				}
                //This function should be normalized and put in quickview function as a helper function
                //It is useful for all quickview activities that need to listen to quickview events
                //especially ones that can have a dirty state
                // - forms, docs, laboratories and eventullly all other items that can be modified
                function addEventsEvent(){
                    //Ne pas ajouter les événements si on est pas en mode quick view
                    if(!scope.qv){
                        return;
                    }

					if(!QuickView.eventsActive(scope.qv)){
						return;// event have already been deleted (because of a close or one quickview that triggers another)
					}
                    //Si c'est la première ouverture, créer la variable d'événements
                    if(!scope.qv.ActiveEventsRef){
                        scope.qv.ActiveEventsRef = {};
                    }
                    //Make sure previously created evens are not referred to
                    //Very important to avoid leaks
                    QuickView.removeAllEventHandlers(scope);

                    function onMinimizeOrClose(event, fct) {
                        var act = event.mObj.quickViewData.qvActData;
                        if (registeredDirtyId) {
                            event.stopPropagation();
                            QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}).then(function(save){
                                function continueAction(res){
                                    unregisterDirty();
                                    scope.ignoreChanges = true;
                                    //Makes sure the original action is called again in 'fct()'
                                    //- if changeActivity was the origianl action it should be recalled and
                                    //   the second time the validation message is not shown because scope.ignoreChanges === true
                                    if (fct) fct();
                                }
                                function saveFailedCanNotContinue(res){
                                    var errMsg = res.statusText ? res.statusText : "";
                                    model.notice().fail($filter('translate')('docFailedSaveErrMsg', {errMsg: errMsg}));
                                }
                                if(save){
                                    act.save().then(continueAction, saveFailedCanNotContinue);//save should change the dirty state to make sure that the second time closing goes through
                                }else{
                                    scope.cancel(scope.recall);
                                    continueAction();
                                }
                            });
                            return true;
                        }
                        return false;
                    }

                    //L'événement existe donc il ne faut pas le recréer
                    if(!scope.qv.ActiveEventsRef.onQvClose){
                        //Ici elle est appeller ajouté aussi-tot que le viewer s'ouvre donc toujours active
                        //Comme le scope n'est pas passé en parametre, le handler est seulement detruit quand le quickview est fermer
                        scope.qv.ActiveEventsRef.onQvClose = Event.on(scope.qv.onQvClose,function(event){
                            console.log("######Quick view is closing");
                            onMinimizeOrClose(event, scope.qv.$$close);
                        });
                    }

                    if(!scope.qv.ActiveEventsRef.onQvMinimize){
                        scope.qv.ActiveEventsRef.onQvMinimize = Event.on(scope.qv.onQvMinimize, function(event){
                            console.log("######Quick view is minimizing");
                            if(onMinimizeOrClose(event, scope.qv.$$minimize)){
                                QuickView.removeAllEventHandlers(scope);
                            }
                        }, scope);
                    }

                    //événement de changement d'activité
                    if(!scope.qv.ActiveEventsRef.onQvActivityChange){
                        scope.qv.ActiveEventsRef.onQvActivityChange = Event.on(scope.qv.onQvActivityChange,function(event){
                            console.log("######Quick view is changing the activity");
                            var newAct = event.newAct;
                            onMinimizeOrClose(event, function(){
                                if(scope.qv && scope.qv.$$changeActivity && scope.qv.$$changeActivity (newAct)){
                                    model.actUpdated(true);
                                    scope.ignoreChanges = false;
                                    QuickView.removeAllEventHandlers(scope);
                                }
                            });
                        }, scope);
                    }

                    if(!scope.qv.ActiveEventsRef.onQvExternalize){
                        scope.qv.ActiveEventsRef.onQvExternalize = Event.on(scope.qv.onQvExternalize,function(event){
                            console.log("######Quick view is externalizing");
                            QuickView.removeAllEventHandlers(scope);
                        }, scope);
                    }
                }

                scope.cancel = function(recall){
                    recall.editMode = false;
                    unregisterDirty();
                    if(!recall.id ){
                        clearRecall(recall);
                        if(scope.qv){
                            scope.qv.$$close();
                        }
                    }
                }
                function getPatientData(){
                    if(scope.quickViewData &&
                        scope.quickViewData.pat &&
                        scope.quickViewData.pat.viewbag &&
                        scope.quickViewData.pat.viewbag.patData){
                            return scope.quickViewData.pat.viewbag.patData;
                    }

                }
                function clearRecall(recall){
                    var pd = getPatientData();
                    if(pd != undefined && pd.rem){
                        var i = pd.rem.indexOf(recall);
                        if(i > -1){
                            pd.rem.splice(i, 1);
                        }
                    }
                }

                function sending(isSending) {
                    if (isSending) {
                        scope.sending = true;
                    } else {
                        $timeout(function () {
                            scope.sending = false;
                        }, 200);
                    }
                }

                function copyForSave(recall) {
                    var res = angular.copy(recall);
                    if(res.editLabels){
                        res.labels = [];
                        Object.keys(res.editLabels).forEach(function(id){
                            if(res.editLabels[id]){
                                res.labels.push(searchLabels[id]);
                            }
                        });
                    }
                    delete res.editLabels;
                    delete res.viewbag;
                    res.modificationStatus = ModificationStatus.STATUS_UPDATED;
                    return res;
                }

                function loadRecall(recall){
                    if(!recall.viewbag){
                        recall.viewbag ={}
                    }
                    recall.viewbag.editRecall = _.omit(angular.copy(recall), 'viewbag');
                    OfysUtils.update(scope.recall, recall, ['save']);
                    model.actUpdated(true);
                }
                scope.save = function (recall, original) {
                    if(!recall){
                        if(scope.recall.viewbag.editRecall){
                            recall = scope.recall.viewbag.editRecall;
                            original = scope.recall;
                        }else{
                            model.notice().fail($filter('translate')('SaveError'));
                            return;
                        }
                    }
                    if (!scope.sending) {
                        sending(true);
                        var toSave = copyForSave(recall);

                        // console.log(toSave); sending();
                        // return;

                        return RecallAccessor.save(toSave, function (res) {
                            var saved ;
                            if(res.className === "CPatientRecall"){
                                saved = res;
                            }
                            if (saved) {
                                loadRecall(saved)
                                unregisterDirty();
                            } else {
                                model.notice().fail($filter('translate')('SaveError'));
                            }

                            //Prevent double sending when clicking too fast;
                            sending();
                        }, function () {
                            //Unlock sending on error
                            sending();
                        });
                    }
                }

                scope.$watch(attrs.view, update);
            }
        }
    }]);
})();