(function(){
	var search = angular.module("home",['ui.grid', 'ui.grid.selection']);

	search.controller('HomeController', ['$scope','$state','model','metabase','$q', 'QuickView','UserAccessor', 'FaxAccessor', '$timeout','$filter',
	                                      function($scope, $state, model, metabase, $q, QuickView, UserAccessor, FaxAccessor, $timeout, $filter){
		model.activeController('search');
		model.activeMenu('Search');
		$scope.model = model;
		if(model.store.profs && model.store.profs.filter && model.store.profs.filter.treatingMD){
			$scope.treatingMd = $filter("orderBy")(model.store.profs.filter.treatingMD.list(), "lastName");
		}

		var update = function() {
			// je le reset tout de suite car je ne voudrais pas 2 calls exactement en même temps.
			model.resetDashBoardCountInterval();
			// model.callDashBoardCount();
		};

		$scope.openUserProfil = function () {
			// console.log("User profile opening....");
			var user = model.user().sessionUser.user;
			QuickView.open(QuickView.getUserQVPayLoad(user, {}, user));
		};

		$scope.openMetabase = function () {
			// console.log("User profile opening....");
			metabase.openMetabaseService(metabase.openHome);
		};
		
		$scope.openMetabaseQuestion = function (q) {
			// console.log("User profile opening....");
			metabase.openMetabaseServiceQuestion(q, metabase.openQuestion);
		};
		
		$scope.faxDynaDateOptions = {acceptFutureDate: false};
		model.fax = {
			searchDate:	moment().format('YYYY-MM-DD')
		};
		$scope.pickDate = function(){
			var pic = $('#appointmentDateTime').data('DateTimePicker');
			pic.toggle();
		};

		$scope.compassnav = function(direction){
			var d = moment(model.fax.searchDate, OfysUtils.DATEFORMAT);
			if(direction === 'N'){
				model.fax.searchDate = d.add(1, 'days').format(OfysUtils.DATEFORMAT);
			}else if(direction === 'C'){
				model.fax.searchDate = moment().format(OfysUtils.DATEFORMAT);
			}else if(direction === 'S'){
				model.fax.searchDate = d.subtract(1, 'days').format(OfysUtils.DATEFORMAT);
			}
			$scope.updateFaxStats();
		};

		$scope.updateFaxStats = function() {
			var newDate = moment(model.fax.searchDate, OfysUtils.DATEFORMAT, true);
			if(!newDate.isValid())return;
			var idProf =  model.user().profil ? model.user().profil.id : undefined;
			if (idProf) {
				var cnts = model.dayData(idProf).cnts;
			}
			cnts.fax_sent_id = [];
			cnts.fax_sent = 0;
			cnts.fax_err_id = [];
			cnts.fax_err = 0;
			cnts.fax_inprog_id = [];
			cnts.fax_inprog = 0;
			FaxAccessor.listOnDate({date:model.fax.searchDate, idUser:model.user().sessionUser.user.id}, function(resp) {
				if (cnts) {
					if (resp && resp.data) {
						if (resp.data.COMPLETE) {
							cnts.fax_sent_id = resp.data.COMPLETE;
							cnts.fax_sent = resp.data.COMPLETE.length;
						}
						if (resp.data.SENT) { // in progress
							cnts.fax_inprog_id = resp.data.SENT;
							cnts.fax_inprog = resp.data.SENT.length;
						}
						if (resp.data.ERROR) {
							cnts.fax_err_id = resp.data.ERROR;
							cnts.fax_err = resp.data.ERROR.length;
						}
					}
				}
				model.refreshCountsUpdated(true);
			}, function(resp) {
				console.log(resp);
			});
		};

		$scope.openFaxUser = function (data) {
			// console.log("User profile opening....");
			var allIds = {ids:[]};
			var sent = data.ids_fax_sent?data.ids_fax_sent:[];
			var inprog = data.ids_fax_inprog?data.ids_fax_inprog:[];
			var error = data.ids_fax_err?data.ids_fax_err:[];
			allIds.ids = _.union(sent, inprog, error);
			var user = model.user().sessionUser.user;
			QuickView.open(QuickView.getFaxQVPayLoad(user, allIds, user));
		};

		$scope.openSuiviPrev = function (idProf) {
			SuiviPrevAccessor.get({idProf:idProf}, function(resp) {
				if (resp && resp.data) {
					var user = model.user().sessionUser.user;
					QuickView.open(QuickView.getSuiviPrevQVPayLoad(resp.data, user));
				}
			}, function(resp) {
				console.log(resp);
			});

		};

		// model.callDashBoardCount(update, false);	// reloadData called after the return of data from counts.

		$scope.forceReload = function() {
			model.resetDashBoardCountInterval();
			model.callDashBoardCount(update, true);	// reloadData called after the return of data from counts.
		};

		$scope.forceReload();

		$scope.forceReloadSafir = function() {
			model.callDashBoardCountSafir(undefined, true);
		};

		$scope.getReplacedProfName = function() {
			var replacedProfId = model.prefSettings('replacedProfId');
			if (replacedProfId!==undefined && replacedProfId!==null && replacedProfId >0) {
				var prof = model.store.profs.get(replacedProfId);
				return prof===undefined ? "" : prof.lastName + ' ' + prof.firstName;
			}
			return ""
		};
		$scope.setReplacedProf = function(md) {
			model.prefSettings('replacedProfId', md.id);
			model.currentApptMd(md);
			model.currentLaboDocMd(md);
		};
		$scope.delReplacedProf = function() {
			model.prefSettings('replacedProfId', -1);
		};

		$scope.getSuperviseurName = function() {
			var superviseurId = model.prefSettings('superviseurId');
			if (superviseurId!==undefined && superviseurId!==null && superviseurId > 0) {
				var prof = model.store.profs.get(superviseurId);
				return prof===undefined ? "" : prof.lastName + ' ' + prof.firstName;
			}
			return ""
		};
		$scope.setSuperviseur = function(md) {
			model.prefSettings('superviseurId', md.id);
		};
		$scope.delSuperviseur = function() {
			model.prefSettings('superviseurId', -1);
		};

		$scope.dayDataCnt = function() {
        	var idProf =  model.user().profil ? model.user().profil.id : undefined;
			return model.dayData(idProf).cnts;
		};
		$scope.dayDataCntSafir = function() {
			return model.dayData().cnts;
		};

		//  ex.: root.view.Crds
		$scope.go = function(l, d) {
			$state.go(l, d);
		};

		$scope.editUserPopoverOptions = {
				showDsqAlias: true,
				showExit: true,
				exit:function(){
					$timeout(function() {
						angular.element('#btn-edit-user').triggerHandler('click');
						$scope.popoverEdit = false;
						$scope.disableToggleClose = false;
					});
				}
			};
		$scope.openChartPopoverOptions = {
				showExit: true,
				exit:function(){
					$timeout(function() {
						angular.element('#btn-open-chart').triggerHandler('click');
						$scope.popoverShowChart = false;
						$scope.disableToggleCloseChart = false;
					});
				}
		};
		$scope.disableToggleClose = false;
		$scope.disableToggleCloseChart = false;
		$scope.profilReady = 0;
		$scope.initProfile = function(){
			updateEditableUserProfile().then(function(){
				$scope.profilReady = 1;
				$scope.disableToggleClose = true;
			}, function(){
				$scope.profilReady = 2;
				$scope.disableToggleClose = false;
			})
		};

		$scope.chartReady = 0;
		$scope.initShowChart = function(){
			showChart().then(function(){
				$scope.chartReady = 1;
				$scope.disableToggleCloseChart = true;
			}, function(){
				$scope.chartReady = 2;
				$scope.disableToggleCloseChart = false;
			})
		};
		$scope.showFact = function(factType) {
			var isOk = false;
			try {
				var prof = model.user().profil;
				var session = model.user().session;
				var user = session.user;
				if (user.factType && factType.includes(user.factType)) {				
					var apiKey = session.apiKeyOrToken;
					var xacteUserName = user.factUsername;
					isOk = prof!==undefined && prof.code!==undefined && apiKey!==undefined && xacteUserName!==undefined;
				}
			} catch(e) {
				console.error(e);
			}
			return isOk;
		};

		function updateEditableUserProfile(){
			return $q(function(resolve, reject){
				if(!model.user().editableProfile){
					if(model.user().profil.id > 0){
						UserAccessor.searchProfiles({idPersons: [model.user().profil.idPerson]}, function (searchResults){
							UserAccessor.getSearchProfilesPage({referenceId: searchResults.referenceId, pageNumber: 1, nbItemsPerPage:searchResults.total }, function(res){
								model.user().editableProfile = res[0];
								resolve(model.user().editableProfile);
							}, reject);
						}, reject);
					}else{// infodata ou user sans profil employée ou Md
						model.user().editableProfile = angular.copy(model.user().session.user);
						model.user().editableProfile.user = model.user().editableProfile;//set for base
						resolve(model.user().editableProfile);
					}
				}else{
					resolve(model.user().editableProfile);
				}
			});
		}
		function showChart(){
			return $q(function(resolve, reject){
				// TODO à terminer.
				if(!model.user().editableProfile){
					UserAccessor.getCharts({idPersons: [model.user().profil.idPerson]}, function (searchResults){
						UserAccessor.getSearchProfilesPage({referenceId: searchResults.referenceId, pageNumber: 1, nbItemsPerPage:searchResults.total }, function(res){
							model.user().editableProfile = res[0];
							resolve(model.user().editableProfile);
						}, reject);
					}, reject);
				}else{
					resolve(model.user().editableProfile);
				}
			});
		}

	}]);

	search.directive('metabase', ['model', 'metabase', 'UserAccessor', 'DashAPI', 'DashWebSocket', function(model, metabase, UserAccessor, DashAPI, DashWebSocket){
		return {
			restrict: 'A',
			link: function(scope, element, attrs){
				var currLanguage = DashAPI.lang;

				scope.questions = [];
				// il faut aller chercher les questions.
				UserAccessor.getMetabaseQuestion(function (resp) {
					if (resp && resp.length) {
						for (var i=0; i<resp.length; i++) {
							// adapter selon la langue
							scope.questions.push({titre:resp[i]['question_' +currLanguage], id:resp[i].id});
						}
					}
				});
				
				scope.openMetabase = function () {
					// console.log("User profile opening....");
					metabase.openMetabaseService(metabase.openHome);
				};
				
				scope.openMetabaseQuestion = function (q) {
					// console.log("User profile opening....");
					metabase.openMetabaseServiceQuestion(q, metabase.openQuestion);
				};
				
				scope.openUrl = function(v) {
					if(model.isWeb()){
						var win = window.open(v, '_blank');
						win.focus();
					}else{
						DashWebSocket.send({url: "/dashboard", data:{url:v}});
					}					
				}
				
			}
		};
	}]);


	search.directive('dsqall', ['$timeout', 'Notification','DashWebSocket', 'DashAPI', 'model','PatientUtils',
		function($timeout, Notification, DashWebSocket, DashAPI, model, PatientUtils){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){
				scope.closeView = function(){
					$timeout(function() {
						angular.element('#search-dsq-all-day').triggerHandler('click');
					});
				};
				scope.searchCriteria = { start: moment().subtract(2, 'years').format("YYYY-MM-DD"), end: moment().format("YYYY-MM-DD")};

				function updateLab(dsqList){
					if(dsqList){
						scope.patient.viewbag.patData.lab = scope.patient.viewbag.patData.lab.concat(dsqList);
						model.actUpdated(true);
					}
					// var showList = scope.patient.viewbag.patData.lab.filterFast(scope.filterAllLab(false));
					// console.log(showList);
				}

				scope.neededSignFirst = false;
				var dsqAllSearchHandlerId = Notification.registerHandler('dsqAllSearch', function(msg){
					var status = DashAPI.getSimpleStatus(msg.data.status);

					// var status = DashAPI.handleReturnObject(msg.data.status, DashAPI.hideMsg());
					if (status=='ERROR') {
					} else if (status=='WARNING') {
						// signature demandé? Si oui et succès, on aura OK ensuite
						scope.neededSignFirst = true;
					} else if (status=='OK') {
						if (scope.neededSignFirst==true) {
							// donc a réussi le call, incluant l'obtentino des signature
							scope.searchAllDsq();
						}
					}
				}, scope);

				scope.searchAllDsq = function(){
					if (model.home().dsqAppointmentCallInProgress===false) {
						model.home().dsqAppointmentCallInProgress = true;
						scope.neededSignFirst = false;
						//var whatToDo=$("#searchDsqAllCheckbox").is(":checked");
						scope.searchCriteria.whatToDo = 1;
						//Results are handled in the main controller
						DashWebSocket.sendRequest("/dashboard/dsq/ws/all/search", scope.searchCriteria);
						delete model.home().dsqAppointmentCallDone;
						delete model.home().dsqAppointmentCallRemaining;
						scope.closeView();
					}
				};
			}
		};
	}]);

	search.directive('dsqGestionSignatures', ['$timeout', 'Notification','DashWebSocket', 'DashAPI', 'model',
		function($timeout, Notification, DashWebSocket, DashAPI, model){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){
				scope.closeView = function(){
					$timeout(function() {
						angular.element('#gestion-dsq-sign').triggerHandler('click');
					});
				};
				scope.searchCriteria = {};

				scope.creerDsqJetons = function(){
					scope.searchCriteria.whatToDo = 2;
					DashWebSocket.sendRequest("/dashboard/dsq/ws/all/search", scope.searchCriteria);
					scope.closeView();
				};
				scope.removeDsqData = function(){
					//var whatToDo=$("#removeCheckbox").is(":checked");
					var varWhatToDo = 4;
					DashWebSocket.sendRequest("/dashboard/dsq/ws/all/removeSignatures", {whatToDo:varWhatToDo});
					scope.closeView();
				};
			}
		};
	}]);

	search.directive('billingPrint', ['EncounterAccessor', 'model',
		function(EncounterAccessor, model){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){
				scope.dateTimeOptions = {
					format: 'YYYY-MM-DD HH:mm',
					acceptFutureDate: false
				};
				scope.dtOpt1 = angular.copy(scope.dateTimeOptions);
				scope.dtOpt2 = angular.copy(scope.dateTimeOptions);
				model.home().billingPrintCallInProgress = false;

				var start = moment().startOf('day'), end = moment(), destination=1;
				var dateType = 'billing';
				scope.pref = {
						dateTypeBilling : function(val) {
							if (arguments.length) {
								dateType = 'billing';
							} else {
								return dateType == 'billing';
							}
						},
						dateTypeService : function(val) {
							if (arguments.length) {
								dateType = 'service';
							} else {
								return dateType == 'service';
							}
						},
						pdf : function(val) {
							if (arguments.length) {
								if (destination!==1 && val===true) {
									destination=1;
								}
							} else {
								return destination==1;
							}
						},
						csv : function(val) {
							if (arguments.length) {
								if (destination!==2 && val===true) {
									destination=2;
								}
							} else {
								return destination==2;
							}
						},
						start : function(val) {
							if (arguments.length) {
								start = moment(val);
							} else {
								return start.format("YYYY-MM-DD HH:mm");
							}
						},
						end : function(val) {
							if (arguments.length) {
								end = moment(val);
							} else {
								return end.format("YYYY-MM-DD HH:mm");
							}
						}
					};

				scope.onClickDo = function(){
					end = moment();
				};
				scope.doBillingPrint = function(){
					if (model.home().billingPrintCallInProgress===false) {
						model.home().billingPrintCallInProgress = true;
						scope.billing = {};
						if (dateType == 'billing') {
							scope.billing.entryDateStart = start.format("YYYY-MM-DD HH:mm");
							scope.billing.entryDateEnd = end.add(1, 'm').format("YYYY-MM-DD HH:mm");
							if (scope.billing.serviceStart) delete scope.billing.serviceStart;
							if (scope.billing.serviceEnd) delete scope.billing.serviceEnd;
						} else {
							scope.billing.serviceStart = start.format("YYYY-MM-DD HH:mm");
							scope.billing.serviceEnd = end.add(1, 'm').format("YYYY-MM-DD HH:mm");
							if (scope.billing.entryDateStart) delete scope.billing.entryDateStart;
							if (scope.billing.entryDateEnd) delete scope.billing.entryDateEnd;
						}
						scope.billing.idProf = model.user().profil.id;
						scope.billing.destination = destination;
						EncounterAccessor.printBilling(scope.billing, function(resp) {
							model.home().billingPrintCallInProgress = false;
							// success
						}, function(resp) {
							model.home().billingPrintCallInProgress = false;
							// error
						});
						scope.$hide && scope.$hide();
					}
				};

			}
		};
	}]);

	search.directive('xacteReport', ['EncounterAccessor', 'model',
		function(EncounterAccessor, model){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){
				scope.dateTimeOptions = {
					format: 'YYYY-MM-DD',
					acceptFutureDate: false
				};
				scope.dtOpt1 = angular.copy(scope.dateTimeOptions);
				scope.dtOpt2 = angular.copy(scope.dateTimeOptions);
				model.home().reportCallInProgress = false;
				var start = moment().startOf('day'), end = moment();
				scope.pref = {
						start : function(val) {
							if (arguments.length) {
								start = moment(val);
							} else {
								return start.format("YYYY-MM-DD");
							}
						},
						end : function(val) {
							if (arguments.length) {
								end = moment(val);
							} else {
								return end.format("YYYY-MM-DD");
							}
						}
					};
				scope.onClickDo = function(){
					end = moment();
				};
				
				scope.doXacteReport = function(){
					if (model.home().reportCallInProgress===false) {
						model.home().reportCallInProgress = true;
						scope.billing = {};
						scope.billing.entryDateStart = Math.floor(start.unix()/(3600*24));
						scope.billing.entryDateEnd = Math.floor(end.unix()/(3600*24));
						scope.billing.idProf = model.user().profil.id;
						EncounterAccessor.listStatusFactureOnDate(scope.billing, function(resp) {
							model.home().reportCallInProgress = false;
							model.home().xacteStatusFacturation = resp;
							document.getElementById('billing-report-btn').click();
						}, function(resp) {
							model.home().reportCallInProgress = false;
							// error
							console.log('ERROR:\n' + resp);
						});
						scope.$hide && scope.$hide();
					}
				};

				scope.openXacteWorkspace = function(){
					var prof = model.user().profil;
					var code = prof.code;
					var noGroup = prof.noGroup?prof.noGroup:'00000';
					// var noAgence = prof.noAgenceRamq;
					var session = model.user().session;
					var user = session.user;
					if (OfysUtils.isNotEmpty(user.factCodeProf)) {
						code = user.factCodeProf;
					}
					var useXacte = user.factType == 'XACTE';
					var useMultiD = user.factType == 'MULTID';
					var apiKey = useXacte===true||useMultiD===true ? session.apiKeyOrToken : undefined;
					var http = session.factHttp;
					var domain = session.factDomain;					
					var factUsername = user.factUsername;
					var data = {
						http: http, domain:domain,
						userId: factUsername, apiKey: apiKey,
						prof:{code:code, noGroup:noGroup, id:prof.id}
						};
					openXacte(data);
				};
				function openXacte(data) {
					var oHeader = {alg: 'HS256', typ: 'JWT'};
					var oPayload = {};
					oPayload.iat = KJUR.jws.IntDate.get('now');
					oPayload.jti = UUID.generate();
					oPayload.usr = data.userId;
					var sJWT = KJUR.jws.JWS.sign("HS256", oHeader, oPayload, data.apiKey);
					var url = data.http + '://' + data.domain + '/account/account/jwt/?jwt=' + sJWT + '&username=' + data.userId
					 + "&return_to=" + encodeURIComponent(data.http + "://" + data.domain + "/Workspace");
					 ;
//					console.log(url);
					if (typeof openExternalBroswer === "function") {
						openExternalBroswer(url);
					} else {
						openRequestedSinglePopup(url,'RAMQ_Billing');
					}
				}

				var previousUrl; /* global variable that will store the url currently in the secondary window */
				function openRequestedSinglePopup(url, windowName) {
				  if(scope['wor_'+ windowName] == undefined || scope['wor_'+ windowName].closed) {
					scope['wor_'+ windowName] = window.open(url, windowName, "popup");
				  } else if(previousUrl != url) {
				    scope['wor_'+ windowName] = window.open(url, windowName, "popup");
				    scope['wor_'+ windowName].focus();
				  } else {
				    scope['wor_'+ windowName].focus();
				  };
				
				  previousUrl = url;
				}
			}
		};
	}]);
	
	search.directive('fmpReport', ['EncounterAccessor', 'model',
		function(EncounterAccessor, model){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){
				scope.dateTimeOptions = {
					format: 'YYYY-MM-DD',
					acceptFutureDate: false
				};
				scope.dtOpt1 = angular.copy(scope.dateTimeOptions);
				scope.dtOpt2 = angular.copy(scope.dateTimeOptions);
				model.home().reportCallInProgress = false;
				var start = moment().startOf('day'), end = moment();
				scope.pref = {
						start : function(val) {
							if (arguments.length) {
								start = moment(val);
							} else {
								return start.format("YYYY-MM-DD");
							}
						},
						end : function(val) {
							if (arguments.length) {
								end = moment(val);
							} else {
								return end.format("YYYY-MM-DD");
							}
						}
					};
				scope.onClickDo = function(){
					end = moment();
				};
				
				scope.doReport = function(){
					if (model.home().reportCallInProgress===false) {
						model.home().reportCallInProgress = true;
						scope.billing = {};
						scope.billing.entryDateStart = Math.floor(start.unix()/(3600*24));
						scope.billing.entryDateEnd = Math.floor(end.unix()/(3600*24));
						scope.billing.idProf = model.user().profil.id;
						EncounterAccessor.listStatusFactureOnDate(scope.billing, function(resp) {
							model.home().reportCallInProgress = false;
							model.home().xacteStatusFacturation = resp;
							document.getElementById('billing-report-btn').click();
						}, function(resp) {
							model.home().reportCallInProgress = false;
							// error
							console.log('ERROR:\n' + resp);
						});
						scope.$hide && scope.$hide();
					}
				};
			}
		};
	}]);
	
	search.controller('xacteController', ['$scope', 'model', '$filter',
		function($scope, model, $filter){
		$scope.title = $filter('translate')('BILLING_REPORT');
		var x = _.sortBy(model.home().xacteStatusFacturation, 'encEntryDate');
		if (x!=undefined && x.length>0) {
			var status = {
				new: $filter('translate')('xacte_new'),
				sent: $filter('translate')('xacte_sent'),
				statement: $filter('translate')('xacte_statement'),
				error: $filter('translate')('xacte_error')
			}
			var notFound = $filter('translate')('xacte_not_found');
			var pat = $filter('translate')('Patient');
			var encDate = $filter('translate')('enc_date');
			var statusFact = $filter('translate')('status_fact');
			var montant = $filter('translate')('montant');
			
			var c = '<table><tr><th>' + pat + '</th><th>' + encDate +  '</th><th>' + statusFact +  '</th><th>' + montant + '</th></tr>';
			var total = 0;
			for (var i=0; i<x.length; i++) {
				var y = x[i];
				if (y.statusFacture.statusCode===200) {
					c += '<tr><td>' + y.patientName + '</td><td>' + y.encEntryDate + '</td><td>' + (status[y.statusFacture.statut]?status[y.statusFacture.statut]:y.statusFacture.statut) + '</td><td class="right">' + (y.statusFacture.montant? y.statusFacture.montant.toFixed(2):'') + '</td></tr>';
					total += y.statusFacture.montant ? y.statusFacture.montant : 0;
				} else if (y.statusFacture.statusCode===400) {
					c += '<tr class="red bold"><td>' + y.patientName + '</td><td>' + y.encEntryDate + '</td><td>' + notFound + '</td><td></td></tr>';				
				} else {
					c += '<tr class="red bold"><td>' + y.patientName + '</td><td>' + y.encEntryDate + '</td><td>' + y.statusFacture.statut + '</td><td></td></tr>';				
				}
			}
			c += '<tr class="bolder"><td>' + $filter('translate')('TOTAL')+ '</td><td></td><td></td><td class="right">' + total.toFixed(2) + '</td></tr>';			
			c += '</table>'
			$scope.content = c;
			
		} else {
			$scope.content = '<h5>' + $filter('translate')('xacte_not_found') + '</h5>';
		}
		$scope.printXacte = function() {
		    var mywindow = window.open('', 'PRINT', 'height=600,width=800');
		
		    mywindow.document.write('<html><head><title>' + $scope.title  + '</title>');
		    mywindow.document.write('</head><body >');
		    mywindow.document.write(document.getElementById('xacte_status_facturation').innerHTML);
		    mywindow.document.write('</body></html>');
		
		    mywindow.document.close(); // necessary for IE >= 10
		    mywindow.focus(); // necessary for IE >= 10*/
		
		    mywindow.print();
		    // mywindow.close();
	
		    return true;
	    };
	
	}]);

	search.directive('encOnDate', ['$timeout', 'EncounterAccessor', 'model',
		function($timeout, EncounterAccessor, model){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){
				scope.dateTimeOptions = {
						format: 'YYYY-MM-DD',
						acceptFutureDate: false
				};
				scope.dtOpt1 = angular.copy(scope.dateTimeOptions);
				var idProf =  model.user().profil ? model.user().profil.id : undefined;

				var start = model.dayData(idProf).cnts.enc_date_date!='' ? moment(model.dayData(idProf).cnts.enc_date_date) : moment();
				scope.pref = {
						onDate : function(val) {
							if (arguments.length) {
								start = moment(val);
							} else {
								return start.format("YYYY-MM-DD");
							}
						}
				};

				scope.doGetEncOnDate = function(){
					var today = Math.floor(start.unix()/(3600*24));
					EncounterAccessor.listOnDate(today, function(resp) {
						var idProf =  model.user().profil ? model.user().profil.id : undefined;
						if (idProf) {
							if (resp && resp.length) {
								model.dayData(idProf).cnts.enc_date_edits_id = resp;
								model.dayData(idProf).cnts.enc_date_edits = resp.length;
								model.dayData(idProf).cnts.enc_date_date = start.format("YYYY-MM-DD");
							} else {
								model.dayData(idProf).cnts.enc_date_edits_id = [];
								model.dayData(idProf).cnts.enc_date_edits = 0;
								model.dayData(idProf).cnts.enc_date_date = '';
							}
							model.refreshCountsUpdated(true);
						}

					}, function(resp) {
						var idProf =  model.user().profil ? model.user().profil.id : undefined;
						if (idProf) {
							model.dayData(idProf).cnts.enc_date_edits_id = [];
							model.dayData(idProf).cnts.enc_date_edits = 0;
							model.refreshCountsUpdated(true);
							model.dayData(idProf).cnts.enc_date_date = '';
						}
					});
					scope.$hide && scope.$hide();
				};
				scope.doGetEncStatusFactureOnDate = function(){
					var today = Math.floor(start.unix()/(3600*24));
					EncounterAccessor.listStatusFactureOnDate(today, function(resp) {
						var idProf =  model.user().profil ? model.user().profil.id : undefined;
						if (idProf) {
							if (resp && resp.length) {
								model.dayData(idProf).cnts.enc_date_edits_id = resp;
								model.dayData(idProf).cnts.enc_date_edits = resp.length;
								model.dayData(idProf).cnts.enc_date_date = start.format("YYYY-MM-DD");
							} else {
								model.dayData(idProf).cnts.enc_date_edits_id = [];
								model.dayData(idProf).cnts.enc_date_edits = 0;
								model.dayData(idProf).cnts.enc_date_date = '';
							}
							model.refreshCountsUpdated(true);
						}

					}, function(resp) {
						var idProf =  model.user().profil ? model.user().profil.id : undefined;
						if (idProf) {
							model.dayData(idProf).cnts.enc_date_edits_id = [];
							model.dayData(idProf).cnts.enc_date_edits = 0;
							model.refreshCountsUpdated(true);
							model.dayData(idProf).cnts.enc_date_date = '';
						}
					});
					scope.$hide && scope.$hide();
				};
			}
		};
	}]);


})();