var MyNamespace = MyNamespace || {};

var versionUrl = "";
MyNamespace.helpers = {
   clearAndAddToArray: function(actual, toAdd) {
	  actual.length = 0;
	  for (var i = 0; i < toAdd.length; i++) {
	    if (toAdd[i]) {
	    	actual.push(toAdd[i]);
	    }
	  }
   },
   cleanArray: function(actual) {
	   var newArray = new Array();
	   for (var i = 0; i < actual.length; i++) {
		   if (actual[i]) {
			   newArray.push(actual[i]);
		   }
	   }
	   return newArray;
   },
   remove: function(item, arr) {
	   var idx = $.inArray(item, arr);
	   if (idx!=-1) {
		   arr.splice(idx,1);
	   }
	  return arr;
   },
   removeWithNoLigne: function(noLigne, arr) {
	   for (var o in arr) {
		   	if (arr[o].noLigne==noLigne) {
			   var idx = $.inArray(arr[o], arr);
			   	if (idx!=-1) {
					arr.splice(idx,1);
				}
		   	}
	   }
	   return;
   },
   convertDateStringsToDates: function(input) {
	   var regexIso8601 = /^(\d{4}|\+\d{6})(?:-(\d{2})(?:-(\d{2})(?:T(\d{2}):(\d{2}):(\d{2})\.(\d{1,})(Z|([\-+])(\d{2}):(\d{2}))?)?)?)?$/;
	    // Ignore things that aren't objects.
	    if (typeof input !== "object") return input;
	    for (var key in input) {
	        if (!input.hasOwnProperty(key)) continue;
	        var value = input[key]; var match;
	        // Check for string properties which look like dates.
	        if (typeof value === "string" && (match = value.match(regexIso8601))) {
	            var milliseconds = Date.parse(match[0])
	            if (!isNaN(milliseconds)) {
	                input[key] = new Date(milliseconds);
	            }
	        } else if (typeof value === "object") {
	            // Recurse into object
	        	MyNamespace.helpers.convertDateStringsToDates(value);
	        }
	    }
   },
   abbreviate: function(str, max, suffix) {
	   if((str = str.replace(/^\s+|\s+$/g, '').replace(/[\r\n]*\s*[\r\n]+/g, ' ').replace(/[ \t]+/g, ' ')).length <= max) {
		   return str;
	   }
	  var abbr='',str=str.split(/[ -]/),suffix=(typeof suffix!=='undefined'?suffix:' ...'),max=(max-suffix.length);
	  for(var len = str.length, i = 0; i < len; i ++){
	    if((abbr + str[i]).length < max){
	      abbr += str[i] + ' ';
	    } else {break;}
	  }
	  return abbr.replace(/[ ]$/g, '') + suffix;
   },
   isEmpty: function(v) {
		return angular.isUndefined(v) || v==null || v=='';
   },
   isNotEmpty: function(v) {
		return angular.isDefined(v) && v!==null && v!=='';
   },
   isObject: function(v) {
		return $.isPlainObject(v);
   },
   compare: function (obj1, obj2) {
		//Loop through properties in object 1
		if ((this.isEmpty(obj1) && this.isNotEmpty(obj2)) ||
				(this.isEmpty(obj2) && this.isNotEmpty(obj1))) {
			return false;
		} else if (this.isEmpty(obj1) && this.isEmpty(obj2)) {
			return true;
		}
		for (var p in obj1) {
			//Check property exists on both objects
			if (obj1.hasOwnProperty(p) !== obj2.hasOwnProperty(p)) {
				return false;
			}

			switch (typeof (obj1[p])) {
				//Deep compare objects
				case 'object':
					if (!this.compare(obj1[p], obj2[p])) {
						return false;
					}
					break;
				//Compare function code
				case 'function':
					if (typeof (obj2[p]) == 'undefined' || (p != 'compare' && obj1[p].toString() != obj2[p].toString())) {
						return false;
					}
					break;
				//Compare values
				default:
					if (obj1[p] != obj2[p]) {
						return false;
					}
			}
		}

		//Check object 2 for any extra properties
		for (var p in obj2) {
			if (typeof (obj1[p]) == 'undefined' && typeof (obj2[p]) !== 'undefined')  {
				return false;
			}
		}
		return true;
	},
	isDate: function(x) {
	  return (null != x) && !isNaN(x) && ("undefined" !== typeof x.getDate);
	},
	versionUrl: function(v) {
		if (arguments.length) {
			versionUrl = v;
		}
		return versionUrl;
	},
	showNews: function() {
		var url = "https://ofys.ca/ofys_aide/fr/syra_news.html?v=ba";
		if (versionUrl) {
			url = "https://ofys.ca/ofys_aide/fr/syra_news" + versionUrl + ".html";
		}
		if (typeof openHelp === "function") {
			openHelp(url);
		    // safe to use the function
		} else {
			window.open(url, url);
		}
	}
 };

String.prototype.hashCode = function(){
    var hash = 0;
    for (var i = 0; i < this.length; i++) {
        var character = this.charCodeAt(i);
        hash = ((hash<<5)-hash)+character;
        hash = hash & hash; // Convert to 32bit integer
    }
    return hash;
};
String.prototype.append = function(str) {
	var r = String(this);
    if (str != null && typeof str === 'string') {
    	r = r + str;
    }
    return r;
};
String.prototype.equalsIgnoreCase = function(str) {
    return (str != null && typeof str === 'string'
            && this.toUpperCase() === str.toUpperCase());
};
String.prototype.equals = function(str) {
	return (str != null && typeof str === 'string' && this === str);
};
String.prototype.replaceAll = function(search, replacement) {
    var target = this;
    return target.split(search).join(replacement);
};
var dict = {"Â":"A", "À":"A", "É":"E", "È":"E", "Ê":"E", "Ë":"E", "Î":"I", "Ï":"I", "Ô":"O", "Ö":"O", "Ù":"U", "Û":"U", "Ü":"U", "Ç":"C"};
String.prototype.removeAccentsUc = function() {
	return this.replace(/[^\w ]/g, function(char) {
		  return dict[char] || char;
	});;
};
var dict = {"â":"a", "à":"a", "é":"e", "è":"e", "ê":"e", "ë":"e", "î":"i", "ï":"i", "ô":"o", "ö":"o", "ù":"u", "û":"u", "ü":"u", "ç":"c"};
String.prototype.removeAccentsLc = function() {
	return this.replace(/[^\w ]/g, function(char) {
		return dict[char] || char;
	});;
};
if (!String.prototype.splice) {
    String.prototype.splice = function(start, delCount, newSubStr) {
        return this.slice(0, start) + newSubStr + this.slice(start + Math.abs(delCount));
    };
}
if (!String.prototype.startsWith) {
    String.prototype.startsWith = function(searchString, position){
		position = position || 0;
		return this.substr(position, searchString.length) === searchString;
  	};
}
Array.prototype.insertInOrder = function(item, field) {
    /* Insert item into arr keeping low to high order according to field */
	let ix = 0;
	if(item!= undefined && item[field] != undefined){
		while (ix < this.length) {
			if (item[field].toLowerCase() < (this[ix][field] !== undefined?this[ix][field].toLowerCase():'')) { break; }
			ix++;
		}
	}
	this.splice(ix,0,item);
    return this;
}
Array.prototype.filterLength = function (fn) {
	var c=0, l = this.length;
	while (l--) {
		if (fn(this[l])) c++;
	}
	return c;
};
//
Array.prototype.range = function(s, e) {
	var newlst = [];
	var lLen = this.length;
	var end = Math.min(lLen, s+e);
	for (var i=s; i<end; i++) {
		newlst.push(this[i]);
	}
	return newlst;
}

// je ne prends pas while (len--) car je veux conserver l'ordre.
Array.prototype.filterFast = function (fn) {
	var results = [];
	var item;
	for (var i = 0, len = this.length; i < len; i++) {
		item = this[i];
		if (fn(item)) results.push(item);
	}
	return results;
};

// je ne prends pas while (len--) car je veux conserver l'ordre.
Array.prototype.filterFastFirst = function (fn) {
	var results = [];
	var item;
	for (var i = 0, len = this.length; i < len; i++) {
		item = this[i];
		if (fn(item)) {
			results.push(item);
			break;
		}
	}
	return results;
};
// pour tester vitesse des méthodes natives.
Array.prototype.filterLength1 = function (fn) {
	return this.filter(fn).length;
};
Array.prototype.filterFast1 = function (fn) {
	return this.filter(fn);
};
if (!Array.prototype.find) {
Object.defineProperty(Array.prototype, 'find', {
	value: function(predicate) {
	// 1. Let O be ? ToObject(this value).
	if (this == null) {
		throw new TypeError('"this" is null or not defined');
	}

	var o = Object(this);

	// 2. Let len be ? ToLength(? Get(O, "length")).
	var len = o.length >>> 0;

	// 3. If IsCallable(predicate) is false, throw a TypeError exception.
	if (typeof predicate !== 'function') {
		throw new TypeError('predicate must be a function');
	}

	// 4. If thisArg was supplied, let T be thisArg; else let T be undefined.
	var thisArg = arguments[1];

	// 5. Let k be 0.
	var k = 0;

	// 6. Repeat, while k < len
	while (k < len) {
		// a. Let Pk be ! ToString(k).
		// b. Let kValue be ? Get(O, Pk).
		// c. Let testResult be ToBoolean(? Call(predicate, T, « kValue, k, O »)).
		// d. If testResult is true, return kValue.
		var kValue = o[k];
		if (predicate.call(thisArg, kValue, k, o)) {
		return kValue;
		}
		// e. Increase k by 1.
		k++;
	}

	// 7. Return undefined.
	return undefined;
	}
});
}

if(Number.isNaN === undefined){
	Number.isNaN = function () {
		return typeof(this) === 'number' && isNaN(this);
	}
}
_.mixin({
    nested5LevelOmit: function(obj, iteratee, level) {
		if(level === undefined)level = 0;
		level = level+1;
		var r = _.omit(obj, iteratee);
		function isObj(o){
			return o !== null && o !== undefined && typeof(o) === "object"
		}
        _.each(r, function(val, key) {
			if(level <5){
				if(Array.isArray(val)){
					for (var i = 0; i < val.length; i++) {
						if(!Array.isArray(val[i]) && isObj(val[i])){
							r[key][i] = _.nested5LevelOmit(val[i], iteratee, level);
						}
					}
				}else if(isObj(val)){
					// only go 5 levels deep. Protection against circular dependancy
					r[key] = _.nested5LevelOmit(val, iteratee, level);
				}
			}
        });

        return r;
    }
});

var QV_EXTERNAL_PATH = "/qviewer";

/**
 * Fast UUID generator, RFC4122 version 4 compliant.
 * @author Jeff Ward (jcward.com).
 * @license MIT license
 * @link http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/21963136#21963136
 **/
var UUID = (function() {
  var self = {};
  var lut = []; for (var i=0; i<256; i++) { lut[i] = (i<16?'0':'')+(i).toString(16); }
  self.generate = function() {
    var d0 = Math.random()*0xffffffff|0;
    var d1 = Math.random()*0xffffffff|0;
    var d2 = Math.random()*0xffffffff|0;
    var d3 = Math.random()*0xffffffff|0;
    return lut[d0&0xff]+lut[d0>>8&0xff]+lut[d0>>16&0xff]+lut[d0>>24&0xff]+'-'+
      lut[d1&0xff]+lut[d1>>8&0xff]+'-'+lut[d1>>16&0x0f|0x40]+lut[d1>>24&0xff]+'-'+
      lut[d2&0x3f|0x80]+lut[d2>>8&0xff]+'-'+lut[d2>>16&0xff]+lut[d2>>24&0xff]+
      lut[d3&0xff]+lut[d3>>8&0xff]+lut[d3>>16&0xff]+lut[d3>>24&0xff];
  }

  self.atomicInt = -10;
  self.atomic = function(){
	  self.atomicInt -= 1;
	  return self.atomicInt;
  }
  return self;
})();

$('body').on('touchmove', function(e){
	if($('.scroll-disable').has($(e.target)).length) e.preventDefault();
});
$('body').on('shown.bs.modal', function(){
	$(this).addClass('scroll-disable');
});
$('body').on('hidden.bs.modal', function(){
	$(this).removeClass('scroll-disable');
});

(function(){
	var dash = angular.module('dash',
		['mod', 'ui.router','ngResource','ngCookies','ngTouch','angular-loading-bar', 'angular-websocket',
			'cfp.hotkeys', 'widgets','mgcrea.ngStrap','mgcrea.ngStrap.helpers.dimensions','site',
			'mgcrea.ngStrap.scrollspy', 'angular-notification-icons','quickedit','logger','rzModule',
			'datetimeboot', 'pref', 'patient', 'encounter', 'appointment', 'ressource', 'doc', 'form', 'labo', 'ui.mask','suiviprev',
			'courriel','task','dashi18n', 'ui.calendar', 'home', 'crds', 'ngSanitize','angular.bind.notifier','recall','ngAnimate',
			'angularUtils.directives.dirPagination', 'ui.bootstrap', 'dashboard.websocket', 'dash.api','dash.store', 'sticky', 'history', 'print', 'scan', 'template',
			'user', 'fax', 'quickview', 'infodataUtils', 'durationPicker','tempAssist', 'ui.tree', 'ofys.debug','b2b', 'prof', 'employee', 'rtssOAuth', 'inspqVaccins', 'fullcalendar', 'color.picker']);
	dash.config(function($animateProvider) {
		$animateProvider.classNameFilter(/ofys-ng-animate/);
	});

	dash.config(function($popoverProvider) {
		angular.extend($popoverProvider.defaults, {
			keyboard: false//disable escape key from closing popovers.
		});
	})
	dash.config(['cfpLoadingBarProvider', function(cfpLoadingBarProvider) {
	    cfpLoadingBarProvider.includeSpinner = false;
	    cfpLoadingBarProvider.includeBar = true;
	    cfpLoadingBarProvider.latencyThreshold = 500;
	  }]);

	var httpinterceptor = function ($q, $location, $timeout) {
	    return {
	        request: function (config) {
	            //show your loading message
	        	activate($(".loader"));
	        	$(".loader").show();
	            return config;
	        },

	        response: function (result) {
	            //hide your loading message
	        	$(".loader").css("color", "#00FF7F");
	        	$timeout(function(){deactivate($(".loader"))}, 2);
	            return result;
	        },

	        responseError: function (rejection) {
	            //hide your loading message
	        	$(".loader").css("color", "#FF4500");
	        	$timeout(function(){deactivate($(".loader"));}, 2);
	            return $q.reject(rejection);
	        }
	    };
	};

	dash.config(function ($httpProvider) {
	    $httpProvider.interceptors.push(httpinterceptor);
	});

	dash.constant('LinkMode', {
		REPRESCRIBEMODE: 3,
		MED_STOP_MODE: 4,
		DEVICEREPRESCRBE: 5,
		DEVICEMED_STOP_MODE: 6,
		DX_ADD_MODE: 7,
	});

	dash.factory('viewer', [function() {
		return {
			msg:{template:""},
			msg:{template:""},
		};
	}]);
	
	dash.factory('metabase', ['model', 'UserAccessor',
		function (model, UserAccessor) {

		function isActive() {
			return true; // model.metabase().isMetabaseActive==1;
		}
		function openMetabaseService(fct) {
			if (isActive()) {
				// var now = Date.now();
				// var fullDaysSinceEpoch = Math.floor(now/8.64e7);
				if (model.metabase().token==undefined || model.metabase().token.length!=2 || model.metabase().token[0]==undefined || model.metabase().token[1].msecSince1970>Date.now()) {
					UserAccessor.metabaseToken(function (resp) {
						if (resp && resp.data && resp.data.token) {
							model.metabase().token = [ resp.data.token, resp.data.msecSince1970];
							fct();
						}
					});
				} else {
					fct();
				}
			}
		}
		function openMetabaseServiceQuestion(q, fct) {
			if (isActive()) {
				// var now = Date.now();
				// var fullDaysSinceEpoch = Math.floor(now/8.64e7);
				if (model.metabase().tokenQuestion == undefined) model.metabase().tokenQuestion = {};
				if (model.metabase().tokenQuestion['q'+q]==undefined || model.metabase().tokenQuestion['q'+q].length!=2 || model.metabase().tokenQuestion['q'+q][0]==undefined || model.metabase().tokenQuestion['q'+q][1].msecSince1970>Date.now()) {
					UserAccessor.metabaseToken4Question(q, function (resp) {
						if (resp && resp.data && resp.data.token) {
							model.metabase().tokenQuestion['q'+q] = [resp.data.token, resp.data.msecSince1970];
							fct(q);
						}
					});
				} else {
					fct(q);
				}
			}
		}
		function openHome() {
			var url = "https://metabase.ofys.net/embed/dashboard/" + model.metabase().token[0];
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(url);
			} else {
				window.open(url,'_blank');
			}
		}
		function openQuestion(q) {
			var url = "https://metabase.ofys.net/embed/question/" + model.metabase().tokenQuestion['q'+q][0];
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(url);
			} else {
				window.open(url,'_blank');
			}
		}
		return {
			isActive: isActive,
			openMetabaseService: openMetabaseService,
			openMetabaseServiceQuestion: openMetabaseServiceQuestion,
			openQuestion: openQuestion,
			openHome: openHome
		}
	}]);

	dash.factory('rxvigilance', ['model', 'UserAccessor', '$filter', '$timeout', 
				function (model, UserAccessor, $filter, $timeout) {

		function isActive() {
			return model.rxVigilance().rxvLicence>0 && model.rxVigilance().rxvUrl;
		}
		function din8ctrs(d) {
			if (d===undefined) return undefined;
			var sDin = d+'';
			var din = sDin.length < 8 ? '0'.repeat(8-sDin.length) + sDin : sDin;
			return din;
		}
		function openRxViglanceService(fct, item, addedItems, retObj) {
			if (isActive()) {
				var now = Date.now();
				var fullDaysSinceEpoch = Math.floor(now/8.64e7);
				if (model.rxVigilance().token===undefined || model.rxVigilance().daySince1970!=fullDaysSinceEpoch) {
					UserAccessor.rxVigilanceToken(function (resp) {
						if (resp && resp.data && resp.data.token) {
							model.rxVigilance().token = resp.data.token;
							model.rxVigilance().daySince1970 = resp.data.daySince1970;
							fct(item, addedItems, retObj);
						}
					});
				} else {
					fct(item, addedItems, retObj);
				}
			}
		}
		function openHome() {
			var url = model.rxVigilance().rxvUrl+'module/accueil/accueil-ndx.html?token=' + model.rxVigilance().token + '&langue=' + model.prefSettings('language');
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(url);
			} else {
				window.open(url,'_blank');
			}
		}
		function openAntibio() {
			// https://rx.stg.vigilance.ca/module/indexes/indexes-ndx.html?index=antibio&language=fr&serviceItem=antibio
			var url = model.rxVigilance().rxvUrl+'module/indexes/indexes-ndx.html?token=' + model.rxVigilance().token + '&langue=' + model.prefSettings('language') + "&index=antibio&serviceItem=antibio";
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(url);
			} else {
				window.open(url,'_blank');
			}
		}
		function openTabComp() {
			// https://rx.stg.vigilance.ca/module/indexes/indexes-ndx.html?index=tab&language=fr&serviceItem=tab
			var url = model.rxVigilance().rxvUrl+'module/indexes/indexes-ndx.html?token=' + model.rxVigilance().token + '&langue=' + model.prefSettings('language') + "&index=tab&serviceItem=tab";
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(url);
			} else {
				window.open(url,'_blank');
			}
		}
		function openFeuilletInfo() {
			var url = model.rxVigilance().rxvUrl+'module/indexes/indexes-ndx.html?token=' + model.rxVigilance().token + '&langue=' + model.prefSettings('language') + "&index=flt_complet&serviceItem=flt_complet";
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(url);
			} else {
				window.open(url,'_blank');
			}
		}
		function openIndicTher() {
			var url = model.rxVigilance().rxvUrl+'module/indexes/indexes-ndx.html?token=' + model.rxVigilance().token + '&langue=' + model.prefSettings('language') + "&index=diag&serviceItem=diag";
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(url);
			} else {
				window.open(url,'_blank');
			}
		}
		function openCalculGros() {
			var url = model.rxVigilance().rxvUrl+'module/calculs/calculs-ndx.html?token=' + model.rxVigilance().token + '&langue=' + model.prefSettings('language') + "&serviceItem=pregnancyCalculator";
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(url);
			} else {
				window.open(url,'_blank');
			}
		}
		function openDocProf() {
			// https://rx.stg.vigilance.ca/module/docproform/docproform-ndx.html?langue=fr
			var url = model.rxVigilance().rxvUrl+'module/docproform/docproform-ndx.html?token=' + model.rxVigilance().token + '&langue=' + model.prefSettings('language') + "&index=tab&serviceItem=tab";
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(url);
			} else {
				window.open(url,'_blank');
			}
		}
		function openMonograph(item) {
			var din = din8ctrs(item.din);
			var url = model.rxVigilance().rxvUrl+'service/find?token=' + model.rxVigilance().token + '&din=' + din + '&langue=' + model.prefSettings('language') + "&index=tab&serviceItem=tab";
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(url);
			} else {
				window.open(url,'_blank');
			}
		}

		// https://rx.stg.vigilance.ca/module/couverture/couverture-ndx.html?langue=fr&origin=home&searchString=aricept
		// https://rx.stg.vigilance.ca/module/couverture/couverture-ndx.html?langue=fr&origin=home&searchString=

		function engineQueryJsonShow(pt, addedItems, retVal) {
			engineQuery("query", pt, addedItems, retVal, getPerspective);
		}
		function engineQueryJson(pt, addedItems, retVal) {
			engineQuery("query", pt, addedItems, retVal);
		}
		function engineQueryViewer(pt, addedItems, retVal) {
			engineQuery("queryviewer", pt, addedItems, retVal);
		}
		function newRxVigilanceToken() {
			UserAccessor.newRxVigilanceToken(function (resp) {
				if (resp && resp.data && resp.data.token) {
					model.rxVigilance().token = resp.data.token;
					model.rxVigilance().daySince1970 = resp.data.daySince1970;
				}
			});
		}
		function engineQuery(module, pt, addedItems, retVal, showPerspFct) {
			if (pt.viewbag===undefined || pt.viewbag.patData===undefined || pt.viewbag.patData.sum.lstAllPrescription===undefined || pt.viewbag.patData.sum.lstAllPrescription.length===0) return;
			var lstRx = pt.viewbag.patData.sum.lstAllPrescription;
			var lstD = pt.viewbag.patData.sum.lstDx;
			var lstP = pt.viewbag.patData.sum.lstProb;
			var lstDx = _.union(lstD, lstP);
			var lstProf = pt.viewbag.patData.sum.lstProf;
			var lstAll = pt.viewbag.patData.sum.lstAllergy;
			var lstInt = pt.viewbag.patData.sum.lstIntolerance;
			var obj = {query:{}};
			obj.query.service = {id:"analysis", userType:2, analysisMode: 0};
			obj.query.service.config = {creatinineClearanceFormula:"MDRD"};
			obj.query.config = {zone:['QC']};
			obj.profile = {medications:[], diagnoses:[], rxProblems:[], laboratories:[]};
			obj.profile.patient={firstName: pt.firstName.charAt(0),
				      lastName: pt.lastName.charAt(0),
				      gender: pt.gender,
				      age: {years: pt.age}
					};
			if (pt.viewbag.creatinine) {
				obj.profile.patient.serumCreatinine=pt.viewbag.creatinine*1;
			}
			if (pt.viewbag.creatinine_cl) {
				obj.profile.patient.creatinineClearance={value: pt.viewbag.creatinine_cl*1};
			}
			if (pt.viewbag.patData.sum.lastMesure) {
				if (pt.viewbag.patData.sum.lastMesure.weight) {
					obj.profile.patient.weightKg =  parseFloat(pt.viewbag.patData.sum.lastMesure.weight.toFixed(2));
				}
				if (pt.viewbag.patData.sum.lastMesure.height) {
					obj.profile.patient.heightCm = parseFloat(pt.viewbag.patData.sum.lastMesure.height.toFixed(2));
				}
			}
			obj.institution = {type: 2};
			obj.viewerConfig = {language: model.prefSettings('language')};
			var idPrevRx = [];
			var idRx = [];	// si on modifie une rencontre, il ne faut pas comparer en double
			if (addedItems!==undefined && addedItems.length>0) {
				for(var i=0; i<addedItems.length; i++) {
					var item = addedItems[i];
					if (item.din!==undefined) {
						if (item.idPrevPrescription!==undefined) idPrevRx.push(item.idPrevPrescription);
						if (item.id!==undefined) idRx.push(item.id);
						if (item.deleted===true || item.stopDateSD!==undefined) continue;
						var din = din8ctrs(item.din);
						obj.profile.medications.push({
							product: [{
								code: din,
								fmt: "din"
							}],
							spec: 'targeted',
							description: {
								name: {
									fr: item.name
								}
							}
						});
					}
				}
			}
			// si rx represcrit, ne pas le reprendre dans lstRx
			for(var i=0; i<lstRx.length; i++) {
				var item = lstRx[i];
				if (item.din!==undefined) {
					var idx = $.inArray(item.id, idPrevRx);
					if (idx>-1) continue;
					idx = $.inArray(item.id, idRx);
					if (idx===-1) {
						var din = din8ctrs(item.din);
						obj.profile.medications.push({
							product: [{
								code: din,
								fmt: "din"
							}],
							description: {
								name: {
									fr: item.name + " (" + item.baseDrugName + ")"
								}
							}
						});
					}
				}
			}
			for(var i=0; i<lstDx.length; i++) {
				var item = lstDx[i];
				if (item.code !== undefined && 'icd9,icd10,cim9,cim10'.indexOf(item.classificationDiagnostic)>-1) {
					var dx = {
						code : "",
						from: {
							code: $filter('dxcode')(item),
							fmt: item.classificationDiagnostic.replace('cim','icd'),
						},
						altDescription: {}
					}
					if ('en'==model.prefSettings('language')) {
						dx.altDescription.en= $filter('FirstMaj')(item.descrShort);
					} else {
						dx.altDescription.fr= $filter('FirstMaj')(item.descrShort);
					}
					obj.profile.diagnoses.push(dx);
				}
			}
			for(var i=0; i<lstAll.length; i++) {
				var item = lstAll[i];
				if (item.din!==undefined) {
					var din = din8ctrs(item.din);
					obj.profile.rxProblems.push({
						code : din,
						fmt: "din",
						prob: 1
					});
				}
			}
			for(var i=0; i<lstInt.length; i++) {
				var item = lstInt[i];
				if (item.din!==undefined) {
					var din = din8ctrs(item.din);
					obj.profile.rxProblems.push({
						code : din,
						fmt: "din",
						prob: 7
					});
				}
			}
			if (pt.viewbag.lstAbnLab4Rxv && pt.viewbag.lstAbnLab4Rxv.length) {
				obj.profile.laboratories = pt.viewbag.lstAbnLab4Rxv;
			}
			
			window.fetch(model.rxVigilance().rxvUrl+'service/rxvengine/' + module + '/?token=' + model.rxVigilance().token + '&langue=' + model.prefSettings('language'), {
				  method: 'POST',
				  headers: {
				      'Accept': 'application/json',
				      'Content-Type': 'application/json;charset=UTF-8'
				    },
				  withCredentials: true,
				  body: JSON.stringify(obj)
				}).then(function(response) {
					  // response.body is a readable stream.
					  // Calling getReader() gives us exclusive access to
					  // the stream's content
					if (response.status==200) {
						var runGetPerspective = false;
						if (model.rxVigilance().perspective===undefined) {
							// il faut ouvrir cette fenêtre une fois pour obtenir le cookie de connection pour pouvoir utiliser ensuite perspective
							var url = model.rxVigilance().rxvUrl+'module/connect/index.html?token=' + model.rxVigilance().token + '&langue=' + model.prefSettings('language');
							if (typeof openExternalBroswer === "function") {
								openExternalBroswer(url);
							} else {
								var myWindow = window.open(url,'_blank', "menubar=0,statusbar=0,titlebar=0,toolbar=0,width=100,height=100");
								$timeout(function(){myWindow && myWindow.close();}, 1500);
							}
							runGetPerspective = true;
						}
						if (module==='queryviewer') {
							insertIntoPerspective(retVal.rxvEngineOutput,retVal);
						} else {
							response.json().then(body => {
						        if (response.status === 200) {
						            retVal.rxvEngineOutput = body;
						            if (showPerspFct!==undefined) {
						            	showPerspFct(retVal.rxvEngineOutput, undefined, retVal);
						            } else {
										if (runGetPerspective===true) {
											getPerspective();
										}
						            	retVal.isWorking = false;
						            }
						        } else {
						        	newRxVigilanceToken();
						        	if (model.rxVigilance().perspective) delete model.rxVigilance().perspective;
						            throw body;
						        }
							});
						}
					} else {
						retVal.isWorking = false;
			        	newRxVigilanceToken();
			        	if (model.rxVigilance().perspective) delete model.rxVigilance().perspective;
					}
				}, function(resp) {
					// reject
					retVal.isWorking = false;
		        	if (model.rxVigilance().perspective) delete model.rxVigilance().perspective;
		        	if (resp.message == "Failed to fetch") {
			        	newRxVigilanceToken();
		        	}
					// console.log(resp);
				});
		}

		function insertIntoPerspective(obj, retVal) {
			if (obj!==undefined && retVal!==undefined) {
				var form = document.createElement('form');
				form.setAttribute('method', 'POST');
				form.setAttribute('target', 'wor_RXV_PROFIL');
				form.setAttribute('action', model.rxVigilance().rxvUrl+'module/perspectives/perspectives-ndx.html?token=' + model.rxVigilance().token);
				var input = document.createElement("input");
				input.setAttribute('name', 'intrant');
				input.setAttribute('value', JSON.stringify(obj));
				form.appendChild(input);
				document.body.appendChild(form);
				form.submit();
				retVal.isWorking = false;
			}
		}

		function getPerspective(jsonObj, item, retVal) {
			if (model.rxVigilance().perspective===undefined) {
				window.fetch(model.rxVigilance().rxvUrl+'module/perspectives/perspectives-ndx.html?token=' + model.rxVigilance().token + '&langue=' + model.prefSettings('language'), {
					method: 'POST',
					headers: {
						'Accept': 'application/json',
						'Content-Type': 'application/json;charset=UTF-8'
					},
				}).then(function(response) {
					// response.body is a readable stream.
					// Calling getReader() gives us exclusive access to
					// the stream's content
					if (response.status==200) {
						var reader = response.body.getReader();
						var queryResult = '';
						var decoder = new TextDecoder();
						// read() returns a promise that resolves when a value has been received
						return reader.read().then(function processResult(result) {
							// Result objects contain two properties:
							// done  - true if the stream has already given
							//         you all its data.
							// value - some data. Always undefined when
							//         done is true.
							if (result.done) {
								// console.log(queryResult);
								model.rxVigilance().perspective = queryResult;
								insertIntoPerspective(jsonObj, retVal);
								return;
							}
							var val = decoder.decode(result.value, {stream: false});
							queryResult += val;
							// Read some more, and call this function/ again
							return reader.read().then(processResult);
						});
					} else {
						retVal.isWorking = false;
					}
				}, function(resp) {
					// reject
					retVal.isWorking = false;
					//console.log(resp);
				});
			} else {
				insertIntoPerspective(jsonObj, retVal);
			}
		}
		
		function openContent(content) {
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(content);
			} else {
				openRequestedSinglePopup(content,'RXV_PROFIL');
			}
		}
		var localScope = {};
		function openRequestedSinglePopup(content, windowName) {
		  if(localScope['wor_'+ windowName] == undefined || localScope['wor_'+ windowName].closed) {
			localScope['wor_'+ windowName] = window.open('', windowName, "popup");			
			localScope['wor_'+ windowName].document.documentURI = '';
			localScope['wor_'+ windowName].document.write(content);
			localScope['wor_'+ windowName].document.close();			
		  } else {
			localScope['wor_'+ windowName].document.documentURI = '';
			localScope['wor_'+ windowName].document.write(content);
			localScope['wor_'+ windowName].document.close();			
		    localScope['wor_'+ windowName].focus();
		  };
		  return localScope['wor_'+ windowName]
		}
		

		return {
			isActive: isActive,
			openRxViglanceService: openRxViglanceService,
			openHome: openHome,
			openAntibio: openAntibio,
			openTabComp:openTabComp,
			openFeuilletInfo: openFeuilletInfo,
			openIndicTher:openIndicTher,
			openCalculGros:openCalculGros,
			openDocProf:openDocProf,
			openMonograph:openMonograph,
			getPerspective:getPerspective,
			engineQueryJsonShow:engineQueryJsonShow,
			engineQueryJson:engineQueryJson,
			engineQueryViewer:engineQueryViewer
		};
	}]);

	dash.directive('viewerData', ['model', '$filter', '$log','QuickView',
	                          function(model, $filter, $log, QuickView){
		return {
			restrict: 'E',
			scope: {
				quickViewData:"=",
				qv:"=qvFunction",
				options: "="
			},
			templateUrl: '/dashboard/resources/ofys/quickview/dataViewer.html?v=ba',
			link: function(scope, element, attrs){
				scope.getDataTypeCallCount = 0;
				scope.getDataType = function(quickViewData){
					scope.getDataTypeCallCount++;
					return QuickView.addQuickViewOptions(quickViewData).viewerType;
				}
			}
		}
	}]);

	dash.directive('editorData', ['model', '$filter', '$log','QuickEdit',
	                              function(model, $filter, $log, QuickEdit){
		return {
			restrict: 'E',
			scope: {
				quickEditData:"=",
				qe:"=qeFunction"
			},
			templateUrl: '/dashboard/resources/ofys/quickview/dataEditor.html?v=ba',
			link: function(scope, element, attrs){
				scope.getDataTypeCallCount = 0;
				scope.getDataType = function(quickEditData){
					scope.getDataTypeCallCount++;
					return "msg";
				}
			}
		}
	}]);


	dash.directive('userName', ['$http','model', '$timeout','$filter', function($http, model, $timeout,$filter ){
		return {
			restrict: 'AE',
			template: '{{name}}',
			scope:true,
			link: function(scope, element, attrs){
				scope.name = "";
				function update(){
					scope.id = scope.$eval(attrs.userid);
					scope.waitingIds = {};
					if(scope.id){
						if(scope.id === model.user().sessionUser.user.id){
							scope.name = $filter('translate')('meUserNameTask');
							return;
						}
						var u = model.user().list[scope.id];
						if(u){
							scope.name = u.personName?u.personName: u.str;
						}else{
							if(!scope.waitingIds[scope.id]){
								scope.waitingIds[scope.id] = true;
								var url = "/dashboard/User/ws/get?id=" + scope.id;
								$http.get(url).then(function(res){
									model.user().list[res.data.id] = res.data;
									scope.name = res.data.personName;
									scope.waitingIds[res.data.id] = false;
								});
							}
						}
					}
				}
				scope.$watch(attrs.userid, update);
			}
		}
	}]);

	dash.directive('groupName', ['$http','model', '$timeout', function($http, model, $timeout){
		return {
			restrict: 'AE',
			template: '{{name}}',
			scope:true,
			link: function(scope, element, attrs){
				scope.name = "";
				function update(){
					scope.id = scope.$eval(attrs.id);
					if(scope.id){
						var u = model.user().groups[scope.id];
						if(u){
							scope.name = u.name;
						}else{
							scope.name = "Group";
						}
					}
				}
				scope.$watch(attrs.id, update);
			}
		}
	}]);

	dash.directive('personGroup', ['$http','model', 'UserAccessor', function($http, model, UserAccessor){
		return {
			restrict: 'AE',
			template: '<span j-tooltip="personGroupOptions" class="btn btn-xs">'+
							'<i class="fa fa-users" aria-hidden="true"></i>'+
							'{{name}}'+
						'</span>',
			scope:true,
			link: function(scope, element, attrs){
				scope.name = "";
				scope.personGroupOptions = {
					trigger: 'mouseenter',
					closeOnMouseleave: true,
					templateUrl: 'personGroup_index.html',
					position: {
						x: 'right',
						y: 'center'
					},
					outside: 'x',
				}


				function update(){
					scope.id = scope.$eval(attrs.groupId);
					scope.personGroup = [];
					if(scope.id){
						var u = model.user().groups[scope.id];
						if(u){
							scope.name = u.name;
							for(var i = 0; i < u.persons.length; i++){
								if(u.persons[i].idPerson){
									UserAccessor.person(u.persons[i].idPerson, function(res){
										scope.personGroup.push(res.data);
									});
								}
							}
						}else{
							scope.name = "Group";
						}
					}
				}

				scope.$watch(attrs.id, update);
			}
		}
	}]);

	dash.directive('profName', ['$http','model', function($http, model){
		return {
			restrict: 'AE',
			template: '<i class="fa fa-user-md qvFolder" aria-hidden="true"></i> {{name}}',
			scope:true,
			link: function(scope, element, attrs){
				scope.name = "";
				function update(){
					scope.id = scope.$eval(attrs.id);
					if(scope.id){
						model.store.profs.get(scope.id, setName);
					}
				}

				function setName(prof){
					scope.name = prof.lastName + ", "+ prof.firstName + " (" + prof.code + ")";
				}
				scope.$watch(attrs.id, update);
			}
		}
	}]);

	dash.directive('siteSelector', ['model','$q', '$filter', function( model, $q, $filter){
		return {
			restrict: 'AE',
			template: '<input type="text" data-input-focus-function="focus" data-dyna-assist="siteSearchAssist" data-ng-model="selectedSite"></input>',
			scope:{
				select: '=?',
				focus: '=?',
				model: '=?',
				filter: '=?'
			},
			link: function(scope, element, attrs){
				var allSites = $filter('filter')(OfysUtils.ObjectValuesAsArray(model.user().sites), scope.filter);
				scope.siteSearchAssist = {
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: true,
					hasHeader: false,
					parentWidth:true,
					displayOnBottom:true,
//					descWidth:0,
					dynaType: document.getElementsByTagName("BODY")[0],
					trigger: 'focus',
					updateDataSourceWithValues: function (assistObject) {
						assistObject.setData(allSites);
					},
					getDescription: function(site) {
						var description = "<ul style='list-style-type:none;-webkit-padding-start:12px;margin-bottom:0px;line-height:1.5'>";
						let stret = site.street ? site.street : ""
						let cityName = (site.city && site.city.name) ? site.city.name : ""
						description +=
							"<li style='margin-bottom:3px;font-weight:900;font-variant-caps: small-caps;'>" + site.code + "</li>" +
							"<li style='margin-bottom:3px'>" + stret + "</li>"+
							"<li style='margin-bottom:3px'>" + cityName + "</li>" +
							"<li style='margin-bottom:3px'>Tel: " + $filter('tel')(site.phonenumber1)  + "</li>" +
							"<li style='margin-bottom:3px'>Fax: " + $filter('tel')(site.phonenumber2) + "</li>" +
							"</ul>";
						return description;
					},
					getAsyncData: function(query, assist){
						query = query.replace(',', ' ');//make sure that composed names with commas are searchable too
						return $q(function(resolve, reject) {
							resolve(allSites.filter(function(a){return OfysUtils.matchInRegExpArray(OfysUtils.searchRegExpArray(query,0), OfysUtils.normaliseSearchField(JSON.stringify(a) ));}));
						});
					},
					getKey: function(site) {
						return site.nameCommon;
					},
					selection: function(site, assistObject) {
						if(scope.select){
							scope.select(site);
						}
						if(!scope.$$phase) {
							scope.$digest();
						}
						return site.nameCommon;
					}
				};
			}
		}
	}]);

	dash.directive('sitePicker', ['$filter','$q', 'model','ProfAccessor',
		function($filter, $q, model, ProfAccessor){
		return {
			restrict: 'E',
            templateUrl:'/dashboard/resources/ofys/main/site_picker.html?v=ba',
            scope:{
                onselect: '=',
				model: '=?',
				set:'=?',
                options: '=?',
				sites: '=?',
            },
			link: function(scope, element, attrs){
				scope.list = _.values(model.user().sites);
				scope.allSites = model.user().sites;

				function update(){
					if(scope.set !== undefined && scope.set.length > 0){
						scope.list = scope.set;
					}else{
						scope.list = model.user().sites;
					}
				}
				scope.$watch(scope.set, update);
                scope.select = function(site){
                    if(scope.onselect){
                        scope.onselect(site);
                    }
                    scope.model = site;
                }

            }
        }
	}]);
	
	dash.directive('adminNavPicker', ['model',
		function(model){
		return {
			restrict: 'E',
            templateUrl:'/dashboard/resources/ofys/main/admin_nav_picker.html?v=ba',

			link: function(scope){
				
            }
        }
	}]);

	dash.directive('fixedSiteSelector', ['model','SiteAccessor', 'PatientAccessor', '$q', '$filter', function( model, SiteAccessor, PatientAccessor, $q, $filter){
		return {
			restrict: 'AE',
			template: '<input type="text" style="width: 100%;" data-input-focus-function="focus" data-dyna-assist="siteSearchAssist" data-ng-model="selectedSite"></input>',
			scope:{
				select: '=?',
				focus: '=?',
				model: '=?',
			},
			link: function(scope, element, attrs){
				scope.siteSearchAssist = {
						nextTabOnTab: true,
						nextTabOnEnter: true,
						hasDetails: true,
						hasHeader: false,
						dynaType: document.getElementsByTagName("BODY")[0],
						listWidth: 350,
						descWidth: 250,
						minChar: 6,
						trigger: 'focus',
						getAsyncData: function(query, assist){
							query = query.replace(',', ' ');//make sure that composed names with commas are searchable too
							var resp = SiteAccessor.findFixedPharmacies({searchString:query}, angular.noop);
							return resp;
						},
						getKey: function(site) {
							return site.nameOfficial;
						},
						getDescription: function(site) {
							var description = "<ul style='list-style-type:none;-webkit-padding-start:12px;margin-bottom:0px;line-height:1.5'>";
							var idxVille = site.street.lastIndexOf(' ');
							var street = site.street.substring(0, idxVille);
							var ville = site.street.substring(idxVille+1);
							description +=
								"<li style='margin-bottom:3px;font-weight:900;font-variant-caps: small-caps;'>" + site.code + "</li>" +
								"<li style='margin-bottom:3px'>" + street + "</li>"+
								"<li style='margin-bottom:3px'>" + ville + "</li>" +
								"<li style='margin-bottom:3px'>Tel: " + $filter('tel')(site.phonenumber1)  + "</li>" +
								"<li style='margin-bottom:3px'>Fax: " + $filter('tel')(site.phonenumber2) + "</li>" +
								"</ul>";
							return description;
						},
						selection: function(site, assistObject) {
							if(scope.select){
								scope.select(site);
							}
							if(!scope.$$phase) {
								scope.$digest();
							}
							assistObject.close();
							return site.nameOfficial;
						}
				};
			}
		}
	}]);

	dash.directive('siteName', ['model', function(model){
		return {
			restrict: 'AE',
			template: '<i data-ng-if="name" class="fa fa-building-o qvFolder" aria-hidden="true" title="Site"></i> {{name}}',
			scope:true,
			link: function(scope, element, attrs){
				scope.name = "";
				function update(){
					scope.id = scope.$eval(attrs.id);

					if(scope.id){
						var u = model.user().sites[scope.id];
						if(u){
							setName(u);
						}
					}
				}

				function setName(site){
					scope.name = site.nameCommon;
				}
				scope.$watch(attrs.id, update);
			}
		}
	}]);

	dash.directive('patientName', ['$http','model', function($http, model){
		return {
			restrict: 'AE',
			templateUrl: 'qvPatient_index.html',
			scope:{
				patientName: "="
			},
			link: function(scope, element, attrs){
				function update(){
					// scope.patName = scope.$eval(attrs.pat);
					if(scope.patientName){
						scope.quickViewData = {pat: scope.patientName};
					}
				}
//				scope.$watch(scope.patName, update);
				scope.$watch(function() {
					if(scope.patientName){
						return scope.patientName.id;
					}
				}, update);
			}
		}
	}]);

	dash.directive('patientNameSmall', ['$http','model', function($http, model){
		return {
			restrict: 'AE',
			templateUrl: 'qvPatientSmall_index.html',
			scope:{
				patientNameSmall: "="
			},
			link: function(scope, element, attrs){
				function update(){
					// scope.patName = scope.$eval(attrs.pat);
					if(scope.patientNameSmall){
						scope.quickViewData = {pat: scope.patientNameSmall};
					}
				}
//				scope.$watch(scope.patientNameSmall.id, update);
				scope.$watch(function() {
					if(scope.patientNameSmall){
						return scope.patientNameSmall.id;
					}
				}, update);
			}
		}
	}]);

	dash.directive('patientNameOnly', ['$http','model', function($http, model){
		return {
			restrict: 'AE',
			templateUrl: 'qvPatientNameOnly_index.html',
			scope:{
				patientNameOnly: "="
			},
			link: function(scope, element, attrs){
				function update(){
					// scope.patName = scope.$eval(attrs.pat);
					if(scope.patientNameOnly){
						scope.quickViewData = {pat: scope.patientNameOnly};
					}
				}
//				scope.$watch(scope.patientNameSmall.id, update);
				scope.$watch(function() {
					if(scope.patientNameOnly){
						return scope.patientNameOnly.id;
					}
				}, update);
			}
		}
	}]);

	dash.directive('appPatientName', [function(){
		return {
			restrict: 'AE',
			templateUrl: 'appPatient_index.html',
			scope:{
				appPatientName: "="
			},
			link: function(scope, element, attrs){
				function update(){
					// scope.patName = scope.$eval(attrs.pat);
					if(scope.appPatientName){
						scope.quickViewData = {pat: scope.appPatientName};
					}
				}
				scope.$watch(scope.patName, update);
			}
		}
	}]);

	dash.config(function($alertProvider) {
		  angular.extend($alertProvider.defaults, {
			    animation: 'am-fade-and-slide-top',
			    placement: 'top'
			  });
	});
	dash.config(function($stateProvider, $urlRouterProvider) {
		var ROLE_NON_USERMANAGEMENT = ['model','$state','$q', function(model, $state, $q){
			//Ensures that only users with the right role can access this url
			if(model.user().isUserAdmin ){
				$state.go('root.view.Home');
				return $q.reject("Permission denied.");
			}
			return true;
		}];
		var ROLE_USERMANAGEMENT = ['model','$state','$q', function(model, $state, $q){
			//Ensures that only users with the right role can access this url
			if(!model.user().isUserAdmin){
				$state.go('root.view.Home');
				return $q.reject("Permission denied.");
			}
			return true;
		}];
		var ROLE_PROF_OR_MDSECRETARY= ['model','$state','$q', function(model, $state, $q){
			//Ensures that only users with the right role can access this url
			if(!model.user().isProf && !model.user().isMdSecretary){
				$state.go('root.view.Home');
				return $q.reject("Permission denied.");
			}
			return true;
		}];
		var ADMIN_STATE_UPDATE = function(stateName){
			return ['model','$state','$q', function(model, $state, $q){
				if(stateName == 'root.view.admin.scan'){
					model.admin().currentTab = "Scanning";
				}else if(stateName == 'root.view.admin.site'){
					model.admin().currentTab = "Sites";
				}else if(stateName == 'root.view.admin.users'){
					model.admin().currentTab = "professionnels";
				}else if(stateName == 'root.view.admin.template'){
					model.admin().currentTab = "Template";
				}else if(stateName == 'root.view.admin.ress'){
					model.admin().currentTab = "billedTitle";
				}
				model.admin().currentTabName = stateName;
				model.adminPageUpdate(true);
			}]
		};

		$urlRouterProvider.otherwise("/Home");

		$stateProvider
			// Global route application wide.
			.state('root', {
			    abstract: true,
			    templateUrl: '/dashboard/resources/ofys/main/main.html?v=ba',
			    resolve: {
			    	modelReady: ['model', function(model){
			    		//Ensures that the model state is ready i.e all required data has been loaded.
			    		return model.ready;
			    	}]
			    }
			})
			.state({name:'root.login',
				templateUrl: '/dashboard/resources/ofys/main/login_view.html?v=ba',
				url: "/login",
				controller: 'LoginController as loginCtrl'
			})
			.state({name:'root.view',
				abstract: true,
				templateUrl : '/dashboard/resources/ofys/main/section_view.html?v=ba',
				redirectTo: 'root.view.Home',
				resolve: {
			    	encounterReady: ['EncounterAccessor', function(EncounterAccessor){
			    		//Ensures that the enumlist and favs are loaded used because some user would require it before it was ready
			    		return EncounterAccessor.ready;
			    	}]
			    }
			})
			.state({name:'root.view.admin',
				abstract: true,
				templateUrl : '/dashboard/resources/ofys/main/section_admin_view.html?v=ba',
				redirectTo: 'root.view.Home',
				resolve: {
			    	encounterReady: ['EncounterAccessor', function(EncounterAccessor){
			    		//Ensures that the enumlist and favs are loaded used because some user would require it before it was ready
			    		return EncounterAccessor.ready;
			    	}],
					hasRight: ROLE_NON_USERMANAGEMENT
			    }
			})
			// route for the Patients Index page
			.state({name:'root.view.PatientIndex',
				url: "/PatientsIndex",
				template : '<patient-edit patient="model.patient().currentPatient"></patient-edit>'
			})
			// route for the Patients page
			.state({name:'QuickView',
				url: QV_EXTERNAL_PATH,
				templateUrl : '/dashboard/resources/ofys/quickview/qv_external.html?v=ba',
				controller: 'QuickViewExternalController as qvCtrl'
			})
            .state({name:'root.view.Appointments',
            	url: "/Appointments",
                templateUrl : 'dashboard/resources/ofys/appointment/tab_appointment.html?v=ba',
                controller: 'AppointmentController as appCtrl',
			    resolve: {
			    	hasRight: ROLE_NON_USERMANAGEMENT
			    }
            })
            .state({name:'root.view.Schedule',
            	url: "/Schedule",
                templateUrl : 'dashboard/resources/ofys/appointment/tab_schedule.html?v=ba',
                controller: 'ScheduleController as scheduleCtrl',
			    resolve: {
			    	hasRight: ROLE_NON_USERMANAGEMENT
			    }
            })
            .state({name:'root.view.Users',
            	url: "/Users",
                templateUrl : 'dashboard/resources/ofys/user/tab_users.html?v=ba',
                controller: 'UserController as userCtrl',
			    resolve: {
			    	hasRight: ROLE_USERMANAGEMENT
			    }
            })
            .state({name:'root.view.Patients',
            	url: "/Patients/",
				params: {term_ids: undefined, rev_ids: undefined, rappel_ids: undefined, edits_ids: undefined, date_edits_ids: undefined, attente_ids:undefined},
            	templateUrl : 'dashboard/resources/ofys/pat/tab_patients.html?v=ba',
            	controller: 'PatientController as cliCtrl',
			    resolve: {
			    	hasRight: ROLE_NON_USERMANAGEMENT
			    }
            })
            .state({name:'root.view.Secteur',
            	url: "/Secteur/",
            	templateUrl : 'dashboard/resources/ofys/ress/tab_ressource.html?v=ba',
            	controller: 'RessourceController as ressCtrl',
			    resolve: {
			    	hasRight: ROLE_NON_USERMANAGEMENT
			    }
            })
            .state({name:'root.view.Documents',
            	url: "/Documents",
            	params: {ids_lab_see: null, ids_lab_regl: null, ids_doc_see: null, ids_doc_regl: null,
            		ids_lab_see_temp: null, ids_lab_regl_temp: null, ids_doc_see_temp: null, ids_doc_regl_temp: null},
            	templateUrl : '/dashboard/resources/ofys/doc/tab_doclab.html?v=ba',
            	controller: 'ReviewController as reviewCtrl',
			    resolve: {
			    	hasRight: ROLE_NON_USERMANAGEMENT
			    }
            })
            .state({name:'root.view.Home',
            	url: "/Home?query",
            	controller: 'HomeController as searchCtrl',
            	templateUrl :  '/dashboard/resources/ofys/main/tab_home.html?v=ba'
            })
			.state( {name: 'root.view.Messages.channelId',
				url: "/{channelId:[0-9]*}"
			})
			// route for the Messages page
			.state( {name:'root.view.Messages',
				url: "/Messages/",
            	params: {type: null, ids: null},
				controller: 'MessageController as msgCtrl',
				templateUrl : '/dashboard/resources/ofys/msg/tab_msg.html?v=ba'
			})
			// route for the Task page
			.state( {name:'root.view.Tasks',
				url: "/tasks/",
				params: {ids_task_late: null, ids_task_tod: null, ids_task_sem:null, ids_task_sans:null, type: 'A'},
				controller: 'TaskController as msgCtrl',
				templateUrl : '/dashboard/resources/ofys/task/tab_task.html?v=ba'
			})
			// route for the u page
			.state( {name:'root.view.Courriels',
				url: "/courriel/{folder}/{msg}",
				params: {folder:null,msg:null,ids:null},
				controller: 'CourrielController as msgCtrl',
				templateUrl : '/dashboard/resources/ofys/courriel/tab_courriel.html?v=ba'
			})
			// route for the CRDS page
			.state( {name:'root.view.Crds',
				url: "/safir/",
				params: {ids_crds_red: null, ids_saf_prer: null, ids_saf_compl:null, ids_saf_valid: null},
            	controller: 'CrdsController as crdsCtrl',
				templateUrl : '/dashboard/resources/ofys/eform/tab_crds.html?v=ba',
			    resolve: {
			    	hasRight: ROLE_NON_USERMANAGEMENT
			    }
			})
			.state( {name:'root.view.Actions',
				url:"/actions/",
				controller:'HistoryController as hisCtrl',
				templateUrl : '/dashboard/resources/ofys/history/tab_history.html?v=ba'
			})
			.state( {name:'root.view.admin.scan',
				url:"/admin/scan/",
				controller:'ScanningController as scanCtrl',
				templateUrl : '/dashboard/resources/ofys/doc/tab_docscan.html?v=ba',
				onEnter:ADMIN_STATE_UPDATE('root.view.admin.scan'),
				resolve: {
			    	hasRight: ROLE_PROF_OR_MDSECRETARY
			    }
			})
			.state( {name:'root.view.admin.site',
				url:"/admin/sites/",
				controller:'SiteController as siteCtrl',
				templateUrl : '/dashboard/resources/ofys/site/tab_site.html?v=ba',
				onEnter:ADMIN_STATE_UPDATE('root.view.admin.site')
			})
			.state( {name:'root.view.admin.template',
				url:"/admin/template/",
				controller:'TemplateController as templateCtrl',
				templateUrl : '/dashboard/resources/ofys/template/tab_template.html?v=ba',
				onEnter:ADMIN_STATE_UPDATE('root.view.admin.template')
			})
			.state( {name:'root.view.admin.ress',
				url:"/admin/resource/",
				controller:'ResEditController as resEditCtrl',
				templateUrl : '/dashboard/resources/ofys/ress/tab_billing.html?v=ba',
				onEnter:ADMIN_STATE_UPDATE('root.view.admin.ress')
			})
			.state( {name:'root.view.admin.users',
				url: "/admin/Users",
                templateUrl : 'dashboard/resources/ofys/user/tab_users_admin.html?v=ba',
                controller: 'UserController as userCtrl',
			    resolve: {
			    	hasRight: ROLE_NON_USERMANAGEMENT
			    },
				onEnter:ADMIN_STATE_UPDATE('root.view.admin.users')
			})
			;
	});


	dash.directive('notifCount', ['$http', 'model', function($http, model){
		return {
			restrict: 'AE',
			template: '<span data-ng-if="notifCountShow" class="badge notifCount" data-ng-bind-template="{{notifCountN}}"></span>',
			scope: true,
			link: function(scope, element, attrs){
				var viewOptions = {};

				function update(){
					viewOptions = scope.$eval(attrs.options);

					if(angular.isDefined(viewOptions.onRegisterApi)){
						viewOptions.onRegisterApi(scope.notifCountApi, scope);
					}

					scope.notifCountApi.refresh();
				}

				scope.notifCountApi = {
					updateCount : function (count){
						scope.notifCountN = count;
						scope.notifCountApi.show();
					},
					refresh: function(){
						if(angular.isDefined(viewOptions.getCount)){
							var count =  viewOptions.getCount(scope.notifCountApi.updateCount);
							if(angular.isDefined(count)){
								scope.notifCountN = count;
								scope.notifCountApi.show();
							}
						}else{
							scope.notifCountShow = false;
						}
					},
					count : function(){
						return scope.notifCountN;
					},
					show: function (){
						if(viewOptions.showCount){
							scope.notifCountShow = viewOptions.showCount(count);
						}else{
							scope.notifCountShow = scope.notifCountN > 0;
						}
					}
				}

				scope.$watch(attrs.options, update);
			}
		}
	}]);
	
//	dash.directive('activeWatch', ['model',
//	 function (model){
//		return {
//			link: function(scope, element, attrs) {
//				scope.$watch(function(){
//					return element.hasClass('active');
//				}, function(nv, ov){
//					console.log('success')
//				})
//			}
//		}
//	}]);


	dash.directive('sessionReconnect', ['model','$timeout','DashAPI','SessionWatch','$filter',
	 function (model, $timeout, DashAPI, SessionWatch, $filter) {
		return {
			restrict: 'E',
			templateUrl: 'session_reconnect_index.html',
			link: function (scope, element, attrs) {
				scope.reconnect = {};

				scope.connect = function(reconnectfrm){
					// console.log(scope.reconnect);
					sendLogin(reconnectfrm);
				}

				function getLogin(){
					return {
						userName: model.user().session.user.name,
						clientCode:model.user().session.client.clientCode,
						workSiteId:model.user().session.site,
						isFastLogin: true,
						st: (navigator.userAgent.indexOf('Mac OS X') != -1) ? 7 : 6,
					}
				}

				scope.errorMsgs = [];
				var loginProgress = false;
				function sendLogin(frm) {
					scope.errorMsgs = [];
					if (frm && frm.$valid && !loginProgress) {
						loginProgress = true;
						var login = getLogin();
						login.password = scope.reconnect.password;
						DashAPI.post("/j_security_check/login", login, acceptLogin, function (err, errorMsgs) {
							loginProgress = false;
							if(errorMsgs && errorMsgs.length > -1){
								scope.errorMsgs = errorMsgs;
							}
						}, DashAPI.hideMsg());
					} else {
						scope.errorMsgs.push(
							{
								severity: "ERROR",
								message: $filter('translate')('sessionLockInvalidForm')
							})
					}
				};

				function acceptLogin(){
					console.log("Logged in successfully");
					SessionWatch.status = 'ACTIVE';

					if(scope.mx){
						scope.mx.close();
					}
				}

				function getErrorPrint(err) {
					var res = "";
					if (typeof err === 'string') {
						return err;
					}
					if (err.status) {
						res += err.status + " : \n";
					}
					if (err.statusText) {
						res += err.statusText + " \n";
					}
					if (err.data) {
						res += err.data;
					}
					return res;
				}

				scope.disconnect = function(){
					model.logout();
				}
				$timeout(function(){
					if(scope.reconnect.focusPWInput){
						scope.reconnect.focusPWInput();
						console.log("has input focus fn");
					}
				}, 500);
			}
		};
	}]);
	
	dash.factory('CommonAccessor', ['DashAPI', 'model', '$state', '$filter',
		function (DashAPI, model, $state, $filter) {
			var accessor = {
				findModificationEntries: function (data, callback, error) {
					return DashAPI.get('/dashboard/common/ws/findModificationEntries?type=' + data.type + "&id=" + data.id, callback, error);
				}
			};
			return accessor;
		}]);
			
	dash.controller('CommonController', ['$scope', 'model', 'CommonAccessor', 'AppointmentAccessor', 'UserAccessor', '$filter', 'DashAPI', 'Store',
		function($scope, model, CommonAccessor, AppointmentAccessor, UserAccessor, $filter, DashAPI, Store){
		$scope.modifEntry;
		if ($scope.task) {
			$scope.modifEntry = $scope.task;
		} else if ($scope.app) {
			$scope.modifEntry = $scope.app;
		} else if ($scope.editPatient) {
			$scope.modifEntry = $scope.editPatient;			
		}
		var empty = $filter('translate')('encTemplate_empty');
		var modBy = $filter('translate')('modified_by');
		var ibOn = "<i>";
		var ibOff = "</i>";
		var cc = ':&nbsp;&nbsp;';
		var arrow = '<span class="bolderBiggerRed">&nbsp;&rarr;&nbsp;</span>';
		var mapYN = {
			'0': $filter('translate')('No'),
			'1': $filter('translate')('Yes'),
			'false': $filter('translate')('No'),
			'true': $filter('translate')('Yes'),
		};
		var apptTypeLang = DashAPI.lang=='en' ? 'english' : 'french';

		if($scope.editPatient && $scope.editPatient.id != undefined){
		
			// var logTypeRecord = $filter('translate')('PATIENT');
			var addedby = $filter('translate')('added_by');
			var note = ' - ' + $filter('translate')('NOTE');
			var importance = ' - ' + $filter('translate')('IMPORTANCE_TTT');
			var deleted = ' - ' + $filter('translate')('isDeleted');
			var origine = ' - ' + $filter('translate')('ORIGIN');
			var mapLogType = {
				'pati': $filter('translate')('PATIENT'),
				'addr': $filter('translate')('Address'),
				'cont': $filter('translate')('ContactMeans'),
				'site': $filter('translate')('Sites') + '/' + $filter('translate')('Pharmacies'),
				'cons': $filter('translate')('Limitation'),
				'iden': $filter('translate')('Idents'),
				'valu': $filter('translate')('Alerts'),
				'disp': $filter('translate')('OtherProf')
			};
 			var mapTitle = {
				'health_insurance_number': $filter('translate')('NAM'),
				'id_treating_professionnal_anchor': $filter('translate')('MD_TX'),
				'message_appointment': $filter('translate')('AppointmentMsg'),
				'last_verification_date': $filter('translate')('LastVerif'),
				'last_activity_date': $filter('translate')('LastActivity'),
				'expiration_cam': $filter('translate')('ExpNam'),
				'blood_type': $filter('translate')('blood_type'),
				'mid_initial': $filter('translate')('midInitialtitle'),
				'father_name': $filter('translate')('Father'),
				'spouse_name': $filter('translate')('Partner'),
				'mother_name': $filter('translate')('Mother'),
				'pati_is_deleted': $filter('translate')('PATIENT') + deleted,
				'gender': $filter('translate')('Gender'),
				'race': $filter('translate')('Race'),
				'language_code': $filter('translate')('Language'),
				'marital_status': $filter('translate')('Civil'),
				'birth_date': $filter('translate')('BirthDate'),
				'mid_initial': $filter('translate')('midInitial'),
				'pati_note': $filter('translate')('PATIENT') + note,
				'title': $filter('translate')('personTitle'),
				'record_number': $filter('translate')('FileNo'),
				'last_name_ba': $filter('translate')('Name'),
				'first_name_ba': $filter('translate')('FirstName'),
				'is_sensible': $filter('translate')('Sensible'),
				'is_scanned': $filter('translate')('Numerised'),
				'custody_terms': $filter('translate')('ChildcareMsg'),
				'id_mother': $filter('translate')('Mother') + ' ID',
				'id_father': $filter('translate')('Father') + ' ID',
				'id_tutor': $filter('translate')('tutorName') + ' ID',
				'tutor_name': $filter('translate')('tutorName'),
				'inactive_date': 'Date inactif',
				'inactive_raison': $filter('translate')('InactiveReason'),
				'id_citizenship': $filter('translate')('Citizenship'),
				'sofy_authorized': $filter('translate')('Sofy'),
				'street': $filter('translate')('Street'),
				'postal_code': $filter('translate')('POSTAL_CODE'),
				'id_province': $filter('translate')('Province'),
				'id_city': $filter('translate')('City'),
				'id_country': $filter('translate')('Country'),
				'addr_note': $filter('translate')('Address') + note,
				'addr_is_deleted': $filter('translate')('Address') + deleted,
				'addr_origin': $filter('translate')('Address') + origine,
				'addr_importance': $filter('translate')('Address') + importance,
				'id_user_anchor': $filter('translate')('Rights') + ' ' + $filter('translate')('User'),
				'date_time_start': $filter('translate')('Rights') + ' ' + $filter('translate')('StartTime'),
				'date_time_end':  $filter('translate')('Rights') + ' ' + $filter('translate')('EndTime'),
				'droits': $filter('translate')('Rights'),
				'type_contact': $filter('translate')('Contact') + ' type',
				'contact': $filter('translate')('Contact'),
				'cont_note': $filter('translate')('Contact') + note,
				'cont_is_deleted': $filter('translate')('Contact') + deleted,
				'cont_origin': $filter('translate')('Contact') + origin,
				'cont_importance': $filter('translate')('Contact') + importance,
				'id_professionnal_anchor': $filter('translate')('OtherPr'),
				'disp_note': $filter('translate')('OtherPr') + note,
				'id_site': $filter('translate')('Site')  + '/' + $filter('translate')('Pharmacy'),
				'id_identifier_type': $filter('translate')('Ident') + ' type',
				'identifier': $filter('translate')('Ident'),
				'iden_is_deleted': $filter('translate')('Ident') + deleted,
				'akey': 'Patient  key',
				'avalue':  $filter('translate')('Alert')
			};
			var mapOrig = {
				'0': 'Ofys', '1':'Sofy', '2':'Hub'
			};
			var mapLC = {'0':'French','1':'English','2':'Spanish','3':'Other'};
			var mapRaces = {
					'0': 'Caucasian',
					'1': 'Native',
					'2': 'African',
					'3': 'Latino',
					'4': 'Asian',
					'5': 'Chinese',
					'6': 'Filipino',
					'7': 'Arab',
					'8': 'Japanese',
					'9': 'Korean',
					'10': 'Other',
					'11': 'Unspecified'
			};
			var contactTypes = [
				$filter('translate')('Phone'), 
				$filter('translate')('MainEmail'),
				$filter('translate')('Fax'), 
				$filter('translate')('Pager'),
				$filter('translate')('OtherEmail'),
				$filter('translate')('Cellphone'),
				$filter('translate')('OtherCellphone'),
				$filter('translate')('Iphone'),
				$filter('translate')('OtherPhone')
			];
			var mapCitizen = {};
			UserAccessor.getAllCitizenships(function(citizenships){
				mapCitizen = citizenships;
			});

			var mapMS = {
				'0': 'N/A',
				'1': 'Single',
				'2': 'Partnership',
				'3': 'Married',
				'4': 'Divorced',
				'5': 'Widowed'
			};

			CommonAccessor.findModificationEntries({type:'patient', id:$scope.modifEntry.id}, function success(response){
				$scope.modifEntry.modif = {};
				if (response.data==undefined || response.data==null) {
					model.notice().warn($filter('translate')('ERR_GET_SURVEY'));
					return;
				}
				$scope.modifEntry.modif.html = '';
				var lastDateEntryUser = "-";
				var isNewModif = true;
				for (var i = 0; i < response.data.length; i++) {
					var modifEntry = response.data[i];
					var modifDate = moment(modifEntry.datetime).format("YYYY-MM-DD HH:mm");
					var user = model.user().list[modifEntry.idUser];
					if (modifEntry.updatedData && modifEntry.updatedData.length>4) {	// si len=4 -> un ajout de record, le nom du type
						if (lastDateEntryUser!=modifDate+user) {
							isNewModif = true;
							lastDateEntryUser = modifDate+user;
							if (lastDateEntryUser != "-") {
				        		$scope.modifEntry.modif.html += '</ul></div>';								
							}
						} else {
							isNewModif = false;
						}
						if (isNewModif===true) {
							$scope.modifEntry.modif.html += '<div class="mt-2"><b>' + modifDate + '</b> ' + modBy + '<b>' + (user ? user.personName:'???') + '</b></div>';						
						}
						var updateData;
						try{
							$scope.modifEntry.modif.html += '<div class="retraitList"><ul>';
			        		updateData = JSON.parse(modifEntry.updatedData);
							Object.keys(updateData).forEach(function(key) {
								var vals = updateData[key].split('~>');
								$scope.modifEntry.modif.html += '<li>' + ibOn;
								var titleKey = mapTitle[key]==undefined ? key : mapTitle[key];
								if (key.indexOf('is_deleted')>-1 || key==='is_scanned' || key==='is_sensible' || key==='sofy_authorized') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?mapYN[vals[0]]:empty) + arrow + (vals[1]!=''?mapYN[vals[1]]:empty);
								} else if (key=='date_time_start' || key=='date_time_end') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?moment(vals[0]*1).format("YYYY-MM-DD HH:mm") : empty) + arrow + (vals[1]!='' ? moment(vals[1]*1).format("YYYY-MM-DD HH:mm") : empty);									
								} else if (key.indexOf('_origin')>-1) {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?mapOrig[vals[0]]:empty) + arrow + (vals[1]!=''?mapOrig[vals[1]]:empty);
								} else if (key=='language_code') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?mapLC[vals[0]]:empty) + arrow + (vals[1]!=''?mapLC[vals[1]]:empty);									
								} else if (key=='id_citizenship') {
									var citiz0 = vals[0]!=''?_.find(mapCitizen, function(x) {return x.id===vals[0]*1; }):undefined;
									var citiz1 = vals[1]!=''?_.find(mapCitizen, function(x) {return x.id===vals[1]*1; }):undefined;
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (citiz0?citiz0[apptTypeLang]:empty) + arrow + (citiz1?citiz1[apptTypeLang]:empty);									
								} else if (key=='race') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?mapRaces[vals[0]]:empty) + arrow + (vals[1]!=''?mapRaces[vals[1]]:empty);									
								} else if (key=='marital_status') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?mapMS[vals[0]]:empty) + arrow + (vals[1]!=''?mapMS[vals[1]]:empty);									
								} else if (key=='type_contact') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?contactTypes[vals[0]*1]:empty) + arrow + (vals[1]!=''?contactTypes[vals[1]*1]:empty);
								} else if (key=='id_site') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + model.user().sites[vals[0]*1].nameCommon + arrow + model.user().sites[vals[1]*1].nameCommon;							
								} else if (key=='id_treating_professionnal_anchor' || key=='id_professionnal_anchor'){
									var prov0 = empty;var prov1 = empty;
									if (vals[0]!='') {
										Store.profs.get(vals[0]*1, function(prof){prov0 = prof.firstName.charAt(0)+' '+prof.lastName;});
									}
									if (vals[1]!='') {
										Store.profs.get(vals[1]*1, function(prof){prov1 = prof.firstName.charAt(0)+' '+prof.lastName;});
									}
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + prov0 + arrow + prov1;									
								} else if (key=='is_first'){
									$scope.modifEntry.modif.html += key + cc + ibOff + (vals[0]!=''?mapYN[vals[0]]:empty) + arrow + (vals[1]!=''?mapYN[vals[1]]:empty);
								} else {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?vals[0]:empty) + arrow + (vals[1]!=''?vals[1]:empty);									
								}
								$scope.modifEntry.modif.html += '</li>';
							});
						}catch(e){
							console.error(e);
							console.log("ERROR -> " + modifEntry.updatedData);
						}
					} else {
						$scope.modifEntry.modif.html += '<div class="mt-2"><b>' + modifDate + '</b> (' + ibOn + mapLogType[modifEntry.updatedData] + ibOff + ') ' + addedby + '<b>' + (user ? user.personName:'???') + '</b></div>';
					}
					if (lastDateEntryUser != "-") {	// a eu un/des colonnes modifiées
		        		$scope.modifEntry.modif.html += '</ul></div>';								
					}
				}
			});
			
		} else if($scope.task && $scope.task.id != undefined){
		
			// var logTypeRecord = $filter('translate')('Task');
			var addedby = $filter('translate')('added_e_by');
			var mapTitle = {
				'id_to_user': $filter('translate')('TO'),
				'id_to_group': $filter('translate')('TO'),
				'priority': $filter('translate')('priorityTask'),
				'progress': $filter('translate')('progress'),
				'due_datetime': $filter('translate')('dueDate'),
				'completion_datetime': $filter('translate')('COMPLETION_DATETIME'),
				'auto_send_reminder': $filter('translate')('smsReminder'),
				'note': $filter('translate')('NOTE')
			};
			var mapProg = {
				'0': $filter('translate')('TASK_PROGRESS_SO'),
				'1': $filter('translate')('TASK_PROGRESS_RECU'),
				'2': $filter('translate')('TASK_PROGRESS_EN_COURS2'),
				'20': $filter('translate')('task_st20'),
				'40': $filter('translate')('task_st40'),
				'60': $filter('translate')('task_st60'),
				'80': $filter('translate')('task_st80'),
				'100': $filter('translate')('TASK_PROGRESS_EN_COURS100'),
			};
			var mapPriority = {
				'0': $filter('translate')('L_PRIORITY'),
				'1': $filter('translate')('N_PRIORITY'),
				'2': $filter('translate')('H_PRIORITY')
			};
			
			CommonAccessor.findModificationEntries({type:'task', id:$scope.modifEntry.id}, function success(response){
				$scope.modifEntry.modif = {};
				if (response.data==undefined || response.data==null) {
					model.notice().warn($filter('translate')('ERR_GET_SURVEY'));
					return;
				}
				$scope.modifEntry.modif.html = '';
				for (var i = 0; i < response.data.length; i++) {
					var modifEntry = response.data[i];
					var user = model.user().list[modifEntry.idUser];
					var modifDate = moment(modifEntry.datetime).format("YYYY-MM-DD HH:mm");
					if (modifEntry.updatedData) {
						$scope.modifEntry.modif.html += '<div class="mt-2"><b>' + modifDate + '</b> ' + modBy + '<b>' + (user ? user.personName:'???') + '</b></div>';
						$scope.modifEntry.modif.html += '<div class="retraitList"><ul>';
						var updateData;
						try{
			        		updateData = JSON.parse(modifEntry.updatedData);
							Object.keys(updateData).forEach(function(key) {
								var vals = updateData[key].split('~>');
								$scope.modifEntry.modif.html += '<li>' + ibOn;
								var titleKey = mapTitle[key]==undefined ? key : mapTitle[key];
								if (key=='id_to_user' || key=='id_to_group') {
									var uname;
									var lstUG;
									if (key=='id_to_user') {
										 uname = 'personName';
										 lstUG = model.user().list;
									} else {
										 uname = 'name';
										 lstUG = model.user().groups;										
									}
									$scope.modifEntry.modif.html += titleKey + '&nbsp;&nbsp;' + ibOff +  (vals[0]!='' && lstUG[vals[0]] ? lstUG[vals[0]][uname] : empty) + arrow + (vals[1]!='' && lstUG[vals[1]] ? lstUG[vals[1]][uname] : empty);
								} else if (key=='priority') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + mapPriority[vals[0]] + arrow + mapPriority[vals[1]];
								} else if (key=='progress') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + mapProg[vals[0]] + arrow + mapProg[vals[1]];									
								} else if (key=='due_datetime' || key=='completion_datetime') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?moment(vals[0]*1).format("YYYY-MM-DD HH:mm") : empty) + arrow + (vals[1]!='' ? moment(vals[1]*1).format("YYYY-MM-DD HH:mm") : empty);									
								} else if (key=='auto_send_reminder') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?mapYN[vals[0]]:empty) + arrow + (vals[1]!=''?mapYN[vals[1]]:empty);
								} else {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?vals[0]:empty) + arrow + (vals[1]!=''?vals[1]:empty);									
								}
								$scope.modifEntry.modif.html += '</li>';
							});
			        		$scope.modifEntry.modif.html += '</ul></div>';
						}catch(e){
							console.error(e);
							console.log("ERROR -> " + modifEntry.updatedData);
						}
					} else {
						$scope.modifEntry.modif.html += '<div class="mt-2"><b>' + modifDate + '</b> ' + addedby + '<b>' + (user ? user.personName:'???') + '</b></div>';
					}
				}
			});
			
		} else if ($scope.app && $scope.app.id != undefined){
		
			// var logTypeRecord = $filter('translate')('Appointment');
			var addedby = $filter('translate')('added_by');
			var mapTitle = {
				'start_time': $filter('translate')('StartTime'),
				'end_time': $filter('translate')('EndTime'),
				'arrived_time': $filter('translate')('ArrivedTime'),
				'seen_time': $filter('translate')('SeenTime'),
				'status': $filter('translate')('AppStatus'),
				'is_annual_exam': $filter('translate')('AnnualExam'),
				'note': $filter('translate')('NOTE'),
				'patient_status': $filter('translate')('ETAT_PATIENT'),
				'is_deleted': $filter('translate')('isDeleted'),
				'id_site': $filter('translate')('Site'),
				'id_appointment_date_anchor': $filter('translate')('STAFTRDay'),
				'id_appointment_type': $filter('translate')('apptType'),
				'is_confidential': $filter('translate')('isConfidential'),
				'status_note': $filter('translate')('appointmentStatusNote'),
				'auto_send_reminder': $filter('translate')('autoSendReminder'),
				'time_reminder_done': $filter('translate')('smsReminder') + ' ' + $filter('translate')('Done'),
				'note_patient': $filter('translate')('PatientNote'),
				'consultation_reason': $filter('translate')('ConsultReason'),
				'cancelled': $filter('translate')('AppPatientStatus_CANCEL'),
				'cancelled_date': $filter('translate')('cancelled_date'),
				'cancelled_by': $filter('translate')('cancelled_by')
			};
			var mapCancelledBy = {
				'0':'CLINIC',
				'1':'SOFY',
				'2':'HUB',
				'3':'PATIENT',
				'4':'BONJOUR SANTE',
				'5':'LOGIBEC',
				'6':'MEDESYNC',
				'7':'MYLE',
				'8':'OMNIMED',
				'9':'POMELO',
				'10':'RVSQ',
				'11':'RVSQ HUB',
				'12':'TAP MEDICAL'
			};
			
			CommonAccessor.findModificationEntries({type:'appointment', id:$scope.modifEntry.id}, function success(response){
				$scope.modifEntry.modif = {};
				if (response.data==undefined || response.data==null) {
					model.notice().warn($filter('translate')('ERR_GET_SURVEY'));
					return;
				}
				$scope.modifEntry.modif.html = '';
				for (var i = 0; i < response.data.length; i++) {
					var modifEntry = response.data[i];
					var user = model.user().list[modifEntry.idUser];
					var modifDate = moment(modifEntry.datetime).format("YYYY-MM-DD HH:mm");
					if (modifEntry.updatedData) {
						$scope.modifEntry.modif.html += '<div class="mt-2"><b>' + modifDate + '</b> ' + modBy + '<b>' + (user ? user.personName:'???') + '</b></div>';
						$scope.modifEntry.modif.html += '<div class="retraitList"><ul>';
						var updateData;
						try{
			        		updateData = JSON.parse(modifEntry.updatedData);
							Object.keys(updateData).forEach(function(key) {
								var vals = updateData[key].split('~>');
								$scope.modifEntry.modif.html += '<li>' + ibOn;
								var titleKey = mapTitle[key]==undefined ? key : mapTitle[key];
								if (key=='start_time' || key=='end_time' || key=='arrived_time' || key=='seen_time') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!='' ? $filter('clvtime')(vals[0]*1) : empty) + arrow + (vals[1]!='' ? $filter('clvtime')(vals[1]*1) : empty);									
								} else if (key=='status') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + _.find(AppointmentAccessor.allAppointementStatus, function(x) { return x.value===vals[0]*1; }).i18n + arrow + _.find(AppointmentAccessor.allAppointementStatus, function(x) { return x.value===vals[1]*1; }).i18n;
								} else if (key=='patient_status') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + _.find(AppointmentAccessor.allPatientStatus, function(x) { return x.value===vals[0]*1; }).i18n + arrow + _.find(AppointmentAccessor.allPatientStatus, function(x) { return x.value===vals[1]*1; }).i18n;
								} else if (key=='is_annual_exam' || key=='is_deleted' || key=='is_confidential' || key=='auto_send_reminder' || key=='cancelled' ) {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?mapYN[vals[0]]:empty) + arrow + (vals[1]!=''?mapYN[vals[1]]:empty);
								} else if (key=='id_appointment_type') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + AppointmentAccessor.appointmentTypesById()[vals[0]][apptTypeLang] + arrow + AppointmentAccessor.appointmentTypesById()[vals[1]][apptTypeLang];							
								} else if (key=='id_site') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + model.user().sites[vals[0]*1].nameCommon + arrow + model.user().sites[vals[1]*1].nameCommon;							
								} else if (key=='cancelled_by') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff +(vals[0]!=''?mapCancelledBy[vals[0]]:empty) + arrow +(vals[1]!=''?mapCancelledBy[vals[1]]:empty);
								} else if (key=='cancelled_date') {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!='' ? moment(vals[0]*1).format("YYYY-MM-DD HH:mm") : empty) + arrow + (vals[1]!='' ? moment(vals[1]*1).format("YYYY-MM-DD HH:mm") : empty);									
								} else {
									$scope.modifEntry.modif.html += titleKey + cc + ibOff + (vals[0]!=''?vals[0]:empty) + arrow + (vals[1]!=''?vals[1]:empty);									
								}
								$scope.modifEntry.modif.html += '</li>';
							});
			        		$scope.modifEntry.modif.html += '</ul></div>';
						}catch(e){
							console.error(e);
							console.log("ERROR -> " + modifEntry.updatedData);
						}
					} else {
						$scope.modifEntry.modif.html += '<div class="mt-2"><b>' + modifDate + '</b> ' + addedby + '<b>' + (user ? user.personName:'???') + '</b></div>';
					}
				}
			});
		}		
	}]);
			
	dash.controller('MainController',
			['$rootScope','$compile', '$scope','$state','Rights','model', '$http','$timeout','$location','SessionWatch',
			 'TaskAccessor','QuickView', 'EncounterAccessor','UserAccessor', 'DocAccessor','$transitions','QValidation',
			 '$filter','AppointmentAccessor','CourrielAccessor','Notification','QuickEdit','DashAPI','DocAccessor','rxvigilance',
			 function($rootScope, $compile, $scope, $state, Rights, model, $http, $timeout,$location,SessionWatch,
					 TaskAccessor, QuickView, EncounterAccessor/*is here to make sure enums ajax calls are always resolve early enough */,
					 UserAccessor, DocAccessor, $transitions, QValidation,
					 $filter, AppointmentAccessor, CourrielAccessor, Notification, QuickEdit, DashAPI, DocAccessor,rxvigilance){

		$rootScope.model = model;
		$scope.qvActive = function(){
			return QuickView.qvActive;
		};
		$scope.aside = {
			"title": "Menu",
		};
		this.isProd = DashAPI.isProd();	// par défaut - on ne prend pas de chance et page init sera mieux
		if (this.isProd === undefined) {
			this.isProd = true;
		}
		$scope.SessionWatch = SessionWatch;
		$scope.$watch('SessionWatch.status', sessionChange)
		var exitModal;
		function sessionChange(){
			if(SessionWatch.status === 'EXPIRED' &&
				SessionWatch.dialogOpen === false){
				var templateString = $('.auth_dialog').html();
				var newScope = $rootScope.$new();

				exitModal = new jBox('Modal', {
					content: $compile(templateString)(newScope),
					position: {x: 'center', y: 50},
					closeOnEsc: false,
					closeOnClick: false,
					closeOnMouseleave: false,
					closeButton: false,
					overlay: true,
					overlayClass: 'auth_dialog_overlay',
					addClass: 'auth_dialog_container',
					onOpen: function() {
						SessionWatch.dialogOpen = true;
					},
					onClose: function() {
						SessionWatch.dialogOpen = false;
					}
				});
				newScope.mx = exitModal;
				exitModal.open();
				$timeout(function(){
					exitModal.position();
				}, 50);
				// SessionWatch.dialogOpen = true;
			}else if(SessionWatch.status === 'ACTIVE' &&
				SessionWatch.dialogOpen === true && exitModal){
					exitModal.close();
					delete exitModal;
			}
		}

		$scope.appointmentContextMenuOptions = {
		};

		$rootScope.goTo= function(url){
			$http.get(url);
		};

		$rootScope.openNewTask = function(){
			TaskAccessor.openNew();
		};


		$rootScope.openNewMessage = function(currMsg){
			CourrielAccessor.openNew(currMsg);
		};

		$scope.openAppointmentEdit = function(){
			AppointmentAccessor.openEdit(model.user().profil.id);
		};

		$rootScope.openRxVigilance = function(){

		};

		$scope.getPatient = function() {
			return model.patient() ? model.patient().currPatient : undefined;
		};

		$scope.openVigilanceSanteMd = function(){
			var url = 'https://www.vigilance.ca/medecins';
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(url);
			    // safe to use the function
			} else {
				window.open(url,'_blank');
			}
		};
		$scope.openVigilanceSante = function(){
			var url = 'https://www.vigilance.ca';
			if (typeof openExternalBroswer === "function") {
				openExternalBroswer(url);
				// safe to use the function
			} else {
				window.open(url,'_blank');
			}
		};
		$scope.openRxVigilanceHome = function(){
			rxvigilance.openRxViglanceService(rxvigilance.openHome);
		};
		$scope.openRxVigilanceMonog = function(item){
			rxvigilance.openRxViglanceService(rxvigilance.openMonograph, item);
		};
		$scope.openRxVigilanceAntibio = function() {
			rxvigilance.openRxViglanceService(rxvigilance.openAntibio);
		};
		$scope.openRxVigilanceTabComp = function() {
			rxvigilance.openRxViglanceService(rxvigilance.openTabComp);
		};
		$scope.openRxVigilanceFeuilletInfo = function() {
			rxvigilance.openRxViglanceService(rxvigilance.openFeuilletInfo);
		};
		$scope.openRxVigilanceIndicTher = function() {
			rxvigilance.openRxViglanceService(rxvigilance.openIndicTher);
		};
		$scope.openRxVigilanceCalculGros = function() {
			rxvigilance.openRxViglanceService(rxvigilance.openCalculGros);
		};
		$scope.openRxVigilanceDocProf = function() {
			rxvigilance.openRxViglanceService(rxvigilance.openDocProf);
		};
		$scope.openRxVigilanceEngineQueryViewer = function(pt, addedRx) {
			if (pt.viewbag.analyseRxv===undefined) pt.viewbag.analyseRxv = {};
			if (pt.viewbag.analyseRxv.isWorking===true) return;
			pt.viewbag.analyseRxv.isWorking = true;
			if (pt.viewbag.analyseRxv.rxvEngineOutput===undefined) {
				rxvigilance.openRxViglanceService(rxvigilance.engineQueryViewer, pt, addedRx, pt.viewbag.analyseRxv);
			} else {
				rxvigilance.openRxViglanceService(rxvigilance.getPerspective, pt.viewbag.analyseRxv.rxvEngineOutput, addedRx, pt.viewbag.analyseRxv);
			}
		};
		$scope.openRxVigilanceEngineQueryJson = function(pt, addedRx) {
			if (pt.viewbag.analyseRxv===undefined) pt.viewbag.analyseRxv = {};
			if (pt.viewbag.analyseRxv.isWorking===true) return;
			pt.viewbag.analyseRxv.isWorking = true;
			rxvigilance.openRxViglanceService(rxvigilance.engineQueryJson, pt, addedRx, pt.viewbag.analyseRxv);
		};

		$transitions.onBefore( { to: 'root.**' }, function(trans) {
		  var $state = trans.router.stateService;

		  if (QValidation.isDirty()) {
			  return QValidation.closeContext($filter('translate')('documentUnsavedChanges'));
		  }

		});
		// n'est pas utilisé - mais notfi devrait l'etre - TODO à adapter pour dashboardcount
//		$scope.msgCountOptions = {
//				getCount: function(asyncCount){
//					$http.get('/dashboard/Chat/ws/newCount').then(function success(response){
//						model.chat().msgCount = response.data;
//						asyncCount(response.data);
//					});
//				},
//				onRegisterApi: function(countApi, scope){
//					model.chat().msgCountApi = countApi;
//					var msgHandlerId = Notification.registerHandler('msg', function(msg){
//						model.chat().msgCountApi.refresh();
//						var result = model.chat().currList.filter(function( obj ) {
//							return obj.id == msg.id;
//						});
//						if(!(result.length > 0)){
//							model.chat().currList.unshift(msg);
//							model.chat().currList = $filter('orderBy')(model.chat().currList, '-createDateTime');
//						}else if(angular.isDefined(msg.readDateTime) && angular.isUndefined(result[0].readDateTime)){
//							model.chat().currList[model.chat().currList.indexOf(result[0])] = msg;
//						}
//					}, scope);
//				}
//		};

		var registeredExternalDirtyId;

		function registerExternalDirty(){
			registeredExternalDirtyId = "externalPatMedSum_"+model.summaryExternalViewer.quickViewData.pat.id;
			QValidation.registerDirty(registeredExternalDirtyId, function(){
				registeredExternalDirtyId = undefined;
				return model.summaryExternalViewer.quickViewData.qvActData.save();
			}, function(){
				unregisterExternalDirty();
				if(model.summaryExternalViewer.quickViewData.qvActData.close){
					model.summaryExternalViewer.quickViewData.qvActData.close();
				}
				return false;
			}, $filter("translate")("ExternalPatMedSumUnsavedChanges"));
		//					model.loadingOverlay().show('ExternalPatMedSumUnsavedChanges', true, true);
		}

		function unregisterExternalDirty(){
			if(registeredExternalDirtyId){
				QValidation.unregisterDirty(registeredExternalDirtyId);
				registeredExternalDirtyId = undefined;
			}
		}
		$scope.$watch(function(){
			if(model.summaryExternalViewer ){
				
				return model.summaryExternalViewer.quickViewData.qvActData.isDirty
			}
		}, function(){
			if(model.summaryExternalViewer){
				if(registeredExternalDirtyId == undefined &&  model.summaryExternalViewer.quickViewData.qvActData.isDirty ){
					registerExternalDirty();
				}else if(registeredExternalDirtyId !== undefined && 
					model.summaryExternalViewer.quickViewData.qvActData.isDirty === false){
						unregisterExternalDirty();
				}
			}
		})

		var sessionLoggedoutHandlerId = Notification.registerHandler('sessionLoggedout', function(msg){
			if(msg && msg.data == "true"){
				location.reload();
			}
		}, $scope);

		var openFileHandlerId = Notification.registerHandler('patientOpenFile', function(notif){
			$location.path('/Patients/');
			var patToOpen = notif.data;
			var p = model.patient('pt');
			//Initiate
			if(!p.currList){
				p.currList = []
			}
			//Search
			var index = p.currList.findIndex(function(e){return e.id === patToOpen.id});
			if(index < 0 ){
				p.currList.unshift(patToOpen);
				index = 0;
			}
			p.currPatient = p.currList[index];
			model.patientUpdated(true)
			model.searchPtUpdated(true);
		}, $scope);

		var courrielPageHandlerId = Notification.registerHandler('courrielOpenPage', function(notif){
			$location.path('/courriel/1/');
		}, $scope);

		var courrielNewHandlerId = Notification.registerHandler('courrielCreateNew', function(notif){
			var payload
			if (notif.data) {
				payload = {patient: notif.data, idPatient:notif.data.id};
			}
			CourrielAccessor.openNew(payload);
		}, $scope);

		var documentHandlerId = Notification.registerHandler('patientImageUpdate', function(wsTarget){
			var notif = wsTarget.data;
			var idProf = model.user().profil ? model.user().profil.id : undefined;
			if (model.dayData(idProf)!==undefined) {
				if(notif && DocAccessor.utils.isNotSeen(notif) || DocAccessor.utils.isToResolve(notif)){
					var allDocs = model.dayData(idProf).cnts.doc_see_id.concat(model.dayData(idProf).cnts.doc_regl_id);
					if(allDocs.indexOf(notif.id) === -1 ){
						if(!model.dayData(idProf).cnts.new_docs){
							model.dayData(idProf).cnts.new_docs = [];
						}
						if(model.dayData(idProf).cnts.new_docs.indexOf(notif.id) === -1){
							model.dayData(idProf).cnts.new_docs.push(notif.id);
						}
					}
				}else if(notif && model.dayData(idProf).cnts.new_docs ){
					var indx = model.dayData(idProf).cnts.new_docs.indexOf(notif.id);
					if(indx !== -1){
						model.dayData(idProf).cnts.new_docs.splice(indx, 1);
					}
				}
			}
		}, $scope);

		var laboratoryHandlerId = Notification.registerHandler('laboResultsProfessionnalUpdate', function(wsTarget){
			var notif = wsTarget.data;
			var idProf = model.user().profil ? model.user().profil.id : undefined;
			if (model.dayData(idProf)!==undefined) {
				if(notif && DocAccessor.utils.isNotSeen(notif) || DocAccessor.utils.isToResolve(notif)){
					var allLabs = model.dayData(idProf).cnts.lab_see_id.concat(model.dayData(idProf).cnts.lab_regl_id);
					if(allLabs.indexOf(notif.id) === -1){
						if(!model.dayData(idProf).cnts.new_labs){
							model.dayData(idProf).cnts.new_labs = [];
						}
						if(model.dayData(idProf).cnts.new_labs.indexOf(notif.id) === -1){
							model.dayData(idProf).cnts.new_labs.push(notif.id);
						}
					}
				}else if(notif && model.dayData(idProf).cnts.new_labs ){
					var indx = model.dayData(idProf).cnts.new_labs.indexOf(notif.id);
					if(indx !== -1){
						model.dayData(idProf).cnts.new_labs.splice(indx, 1);
					}
				}
			}
		}, $scope);

//		var lockSessionHandlerId = Notification.registerHandler('lock', function(notif){
//			if (notif.isLocked===true) {
//				DashAPI.get("/dashboard/Login/ws/logout", function (res) {
//					if(model.isWeb()){
//						location.href = "/login.html";
//					}else{
//						window.close();
//					}
//				}, function (err) {
//					console.log(err);
//				});
//			}
//		}, $scope);

		var schdlDatetemplateUpdateHandlerId = Notification.registerHandler('schdlDatetemplateUpdate', function(wsnotif){
			var notif = wsnotif.data;
			if(model.schedule().store && model.schedule().store.handleSchdlDatetemplateUpdateNotification){
				model.schedule().store.handleSchdlDatetemplateUpdateNotification(notif);
			}
		});
		var schdlWeektemplateUpdateHandlerId = Notification.registerHandler('schdlWeektemplateUpdate', function(wsnotif){
			var notif = wsnotif.data;
			if(model.schedule().store && model.schedule().store.handleSchdlWeektemplateUpdateNotification){
				model.schedule().store.handleSchdlWeektemplateUpdateNotification(notif);
			}
		});
		var schdlAppointmentperiodtypeUpdateHandlerId = Notification.registerHandler('schdlAppointmentperiodtypeUpdate', function(wsnotif){
			var notif = wsnotif.data;
			if(model.schedule().store && model.schedule().store.handleSchdlAppointmentperiodtypeUpdateNotification){
				model.schedule().store.handleSchdlAppointmentperiodtypeUpdateNotification(notif);
			}
		});

		var schdlBaseAppointmentDateUpdateHandlerId = Notification.registerHandler('schdlBaseAppointmentDateUpdate', function(wsnotif){
			var notif = wsnotif.data;
			if(model.schedule().store && model.schedule().store.handleBaseAppointmentDateNotification){
				model.schedule().store.handleBaseAppointmentDateNotification(notif);
			}
		});

		var schdlDateKeyUpdateHandlerId = Notification.registerHandler('schdlDateKeyUpdate', function(wsnotif){
			var notif = wsnotif.data;
			if(model.schedule().store && model.schedule().store.handleDateKeyNotification){
				model.schedule().store.handleDateKeyNotification(notif);
			}
		});

		var appointmentReservationHandlerId = Notification.registerHandler('appReservation', function(wsnotif){
			var notif = wsnotif.data;
			if(model.schedule().store && model.schedule().store.handleAppointmentReservationNotification){
				model.schedule().store.handleAppointmentReservationNotification(notif);
			}
		});

		var appointmentDateHandlerId = Notification.registerHandler('appDate', function(wsnotif){
			var notif = wsnotif.data;
			if(model.schedule().store && model.schedule().store.handleAppointmentDateNotification){
				model.schedule().store.handleAppointmentDateNotification(notif);
			}
		});

		var appointmentHandlerId = Notification.registerHandler('app', function(wsnotif){
			var notif = wsnotif.data;
			if(model.schedule().store && model.schedule().store.handleAppointmentNotification){
				model.schedule().store.handleAppointmentNotification(notif);
			}
			if(model.appointment().loaded && notif.date === model.appointment().currDate){
				var result = model.appointment().currList.filter(function( obj ) {
					return obj.id == notif.id;
				});

				//Appointment is new and belongs to the current date.
				if(result.length < 1){
					if (notif.idProfessional===model.currentApptMd().id) {
						var i = 0;
						var currList = model.appointment().currList;
						while(i < currList.length && currList[i].startTime <= notif.startTime ){
							i++;
						}
						//Add appointment to current list
						model.appointment().currList.splice(i, 0, notif);
					}
				//Appointment exists (changed status)
				}else{
					//Modify appointment
					var currList = model.appointment().currList;
					var currAppt = result[0];
					var currIdx = currList.indexOf(currAppt);
					if (currAppt.startTime!=notif.startTime) {
						// RV déplacé.
						var i = 0;
						currList.splice(currIdx, 1);
						while(i < currList.length && currList[i].startTime <= notif.startTime ){
							i++;
						}
						//Add appointment to current list
						currList.splice(i, 0, notif);
					} else {
						var aApp = currList[currIdx];
						notif.uid = aApp.uid;
						for(var i = 0; i < notif.patients.length; i++){
							var pt = notif.patients[i];
							for(var j = 0; j < aApp.patients.length; j++){
								if (aApp.patients[j].id===pt.id) {
									pt.viewbag = aApp.patients[j].viewbag;
									pt.uid = aApp.patients[j].uid;
								}
							}
							if (i===0) notif.firstPatient = pt;
						}
						currList[currIdx] = notif;
					}
				}
				model.apptLstUpdated(true);
				model.refreshCountsUpdated(true);
			}
		}, $scope);

		function persistPatientState(oldpat, newpat){
			// This is the prefered method to update patient while making sure that directives are updated accordingly.
			// changing the object by doing "oldpat = newpat" causes UI bugs Ticket #306311
			OfysUtils.update(oldpat,newpat, ['viewbag', 'uid']);
			if(oldpat.viewbag){// recalculate the limitations incase they were changed.
				oldpat.viewbag.limitations = Rights.getSessionUserConsent(oldpat);
			}
		}
		function updateTabsCurrPatient(tab, newpat){
			if(tab.currPatient && tab.currPatient.id == newpat.id){
				persistPatientState(tab.currPatient, newpat);
				model.patientUpdated(true);
			}
		}

		var patientHandlerId = Notification.registerHandler('patientUpdate', function(wsTarget){
			var notif = wsTarget.data;
			updateTabsCurrPatient(model.patient('pt'), notif)
			updateTabsCurrPatient(model.patient('rv'), notif)
			updateTabsCurrPatient(model.patient('ress'), notif)

			if (model.appointment().loaded) {
				var appts = model.appointment().currList;
				for(var h = 0; h < appts.length; h++) {
					for(var i = 0; i < appts[h].patients.length; i++){
						if (appts[h].patients[i].id===notif.id) {
							persistPatientState(appts[h].patients[i], notif);
							model.apptLstUpdated(true);
						}
					}
				}
			}

			if (model.appointment().currAppointment &&
				model.appointment().currAppointment.firstPatient &&
				model.appointment().currAppointment.firstPatient.id===notif.id) {
				persistPatientState(model.appointment().currAppointment.firstPatient, notif);
				model.apptLstUpdated(true);
			}

			if (model.patient() && model.patient().currList && model.patient().currList.length>0) {
				var ptLst = model.patient().currList;
				for(var h = 0; h < ptLst.length; h++){
					if (ptLst[h].id===notif.id) {
						persistPatientState(ptLst[h], notif);
						model.searchPtUpdated(true);
					}
				}
			}
		}, $scope);

		function destIndex(idPerson, courrielText){
			if(courrielText.courrielDest && courrielText.courrielDest.length > 0){
				for (var i = 0; i < courrielText.courrielDest.length; i++) {
					if(idPerson === courrielText.courrielDest[i].idPerson){
						return i;
					};
				}
			}
			return -1;
		}
		var courrielHandlerId = Notification.registerHandler('mailNew', function(data){
			var msg = data.data;
			var idProf = model.user().profil ? model.user().profil.id : undefined;
			var idPerson = model.user().profil ? model.user().profil.idPerson : undefined;
			var currDestIndex = destIndex(idPerson, msg);

			if (model.dayData(idProf)!==undefined && currDestIndex > -1) {
				var c = model.dayData(idProf).cnts;
				var destId = msg.courrielDest[currDestIndex].id;
				if(c.mail_new_id.indexOf(destId) === -1){
					c.mail_new_id.unshift(destId);
					c.mail_new = c.mail_new_id.length;
				}
				if (msg.importance>1 && c.mail_urg_id.indexOf(destId) === -1) {
	                c.mail_urg = c.mail_urg==null ? 1 : c.mail_urg+1;
	                c.mail_urg_id.push(destId);
				}
				model.refreshCountsUpdated(true);
			}
		}, $scope);

		var courrielAlertHandlerId = Notification.registerHandler('mailAlert', function(data){
			var msg = data.data;
			var idProf = model.user().profil ? model.user().profil.id : undefined;
			var idPerson = model.user().profil ? model.user().profil.idPerson : undefined;

			if (model.dayData(idProf)!==undefined && idPerson === msg.idPerson) {
				var c = model.dayData(idProf).cnts;

				if(c.mail_new_id.indexOf(msg.id) === -1){
					c.mail_new_id.unshift(msg.id);
					c.mail_new = c.mail_new_id.length;
				}
				if (msg.courrielTexte) {
					if (msg.courrielTexte.importance==2 && c.mail_urg_id.indexOf(msg.id) === -1) {
		                c.mail_urg = c.mail_urg==null ? 1 : c.mail_urg+1;
		                c.mail_urg_id.push(msg.id);
					}
				}
				var cc = model.courriel();
				if (cc.activeCourrielFolder == 1) { // ds unread - ajouter item.
					// un peu compliqué rendu ici... mais serait bien d'updater la liste auto en ajoutant le nouveau courriel dans le haut!
				}
				model.refreshCountsUpdated(true);
			}
		}, $scope);

		var taskHandlerId = Notification.registerHandler('taskUpdate', function(wsTarget){
			var notif = wsTarget.data;
			var idProf = model.user().profil ? model.user().profil.id : undefined;
			var idUser = model.user().sessionUser ? model.user().sessionUser.user.id : undefined;
			if (model.dayData(idProf)!==undefined) {
				var modDtProf = model.dayData(idProf);
				var listSubMenu = model.task().listSubMenu;
				var currFilterShorcut = model.task().currFilterShorcut;
				var taskType = getType(notif);
				TaskAccessor.initTask(notif);//required to initiate task state.
				var hasUpdatedTask = false;
				if (model.task().todo &&  model.task().todo.length>0) {
					for(var i = 0; i < model.task().todo.length; i++){
						if(model.task().todo[i].id === notif.id){
							OfysUtils.update(model.task().todo[i], notif, ['viewbag']);
							var wasComplete = model.task().todo[i].viewbag.isComplete;
							model.task().todo[i].viewbag.isComplete = notif.completionDatetime != undefined;
							if (model.task().todo[i].viewbag.isComplete===true) {
								if (wasComplete===false) {
									modDtProf.cnts[taskType] = modDtProf.cnts[taskType] - 1;
									if (taskType.indexOf('_group')>-1) {
										modDtProf.cnts[taskType.replace('_group','')+'_total'] = modDtProf.cnts[taskType.replace('_group','')+'_total'] - 1;
									} else {
										modDtProf.cnts[taskType+'_total'] = modDtProf.cnts[taskType+'_total'] - 1;
									}
								}
							} else {
								if (wasComplete==true) {
									// donc n'est plus complete!
									modDtProf.cnts[taskType] = modDtProf.cnts[taskType] + 1;
									if (taskType.indexOf('_group')>-1) {
										modDtProf.cnts[taskType.replace('_group','')+'_total'] = modDtProf.cnts[taskType.replace('_group','')+'_total'] + 1;								
									} else {
										modDtProf.cnts[taskType+'_total'] = modDtProf.cnts[taskType+'_total'] + 1;								
									}
								}
								
							}
							hasUpdatedTask = true;
							i =  model.task().todo.length;
						}
					}
					if (hasUpdatedTask===true) {
						model.refreshCountsUpdated(true);
	                    model.taskDataUpdate(true);						
					}
				}
				if (idUser===notif.toUser || notif.toGroup) {
					var allIds = modDtProf.cnts.task_id_total().concat( modDtProf.cnts.task_group_id());
					// var taskIds = model.dayData().cnts[taskType+"_id"];
					if(taskType){ //The notified task is relevant to the tab sections that are available
						var inMyGroup = notif.toGroup && isInMyGroup(notif);
						if(allIds.indexOf(notif.id) === -1 && (inMyGroup || (notif.toUser && notif.toUser === idUser))) {
							if(model.task().tabLoaded){//Avoid showing only the notified object
								if(//Currently selected tab should contain the notified task
									(currFilterShorcut === 'NB_TASK_ALL') ||
									(currFilterShorcut === 'NB_TASK_LATE' && taskType === "task_late" && (listSubMenu === 'A' || listSubMenu === 'P')) ||
									(currFilterShorcut === 'NB_TASK_LATE' && taskType === "task_late_group" && (listSubMenu === 'A' || listSubMenu === 'G')) ||
									(currFilterShorcut === 'NB_TASK_TODAY' && taskType === "task_tod" && (listSubMenu === 'A' || listSubMenu === 'P')) ||
									(currFilterShorcut === 'NB_TASK_TODAY' && taskType === "task_tod_group" && (listSubMenu === 'A' || listSubMenu === 'G')) ||
									(currFilterShorcut === 'NB_TASK_SEM' && taskType === "task_sem" && (listSubMenu === 'A' || listSubMenu === 'P')) ||
									(currFilterShorcut === 'NB_TASK_SEM' && taskType === "task_sem_group" && (listSubMenu === 'A' || listSubMenu === 'G')) ||
									(currFilterShorcut === 'NB_TASK_SANS_ECHEANCE' && taskType === "task_sans" && (listSubMenu === 'A' || listSubMenu === 'P')) ||
									(currFilterShorcut === 'NB_TASK_SANS_ECHEANCE' && taskType === "task_sans_group" && (listSubMenu === 'A' || listSubMenu === 'G'))
								){
									model.task().todo.unshift(notif);
								}
							}
							modDtProf.cnts[taskType+"_id"].unshift(notif.id);
							modDtProf.cnts[taskType] = modDtProf.cnts[taskType] + 1;
							if (taskType.indexOf('_group')==-1) {
								modDtProf.cnts[taskType+"_id_total"].unshift(notif.id);
							}
							modDtProf.cnts[taskType.replace('_group','')+'_total'] = modDtProf.cnts[taskType.replace('_group','')+'_total'] + 1;
							if (notif.priority=='HAUT') {
								var urgType = inMyGroup ? 'task_urg_group' : 'task_urg';
								var urgTypeId = inMyGroup ? 'task_urg_group_id' : 'task_urg_id';
								modDtProf.cnts[urgType] = modDtProf.cnts[urgType]==null ? 1 : modDtProf.cnts[urgType]+1;
								modDtProf.cnts['task_urg_total'] = modDtProf.cnts['task_urg_total']==null ? 1 : modDtProf.cnts['task_urg_total']+1;
								modDtProf.cnts[urgTypeId].push(notif.id);
								modDtProf.cnts['task_urg_id_total'].push(notif.id);
							}
						}
					}
                    model.taskDataUpdate(true);						
					model.refreshCountsUpdated(true);
				}
			}
		}, $scope);

		var suiviprevProfHandlerId = Notification.registerHandler('suiviprevProf', function(data){
			// on ne prend pas cette notification car inutile - le post save met à jour les données - sauf si est connecté sur 2 postes différents... 
			var suiviProf = data.data;
			var idProf = model.user().profil ? model.user().profil.id : undefined;
//model.suiviPrevs().prof			
		}, $scope);

		var suiviprevPatHandlerId = Notification.registerHandler('suiviprevPat', function(data){
			var d = data.data;
			var idProf = model.user().profil ? model.user().profil.id : undefined;
			if (idProf!==d.idProfessionnal) {
				// mettre à jour les données car pas même prof qui a fait les modifications
				var idPat = d.idPatient;
				if (model.suiviPrevs().pat[idPat]) {
					// liste déjà chargée, il faut la mettre à jour
					var lst = model.suiviPrevs().pat[idPat];
					var idx = _.findIndex(lst, function(a){ return a.id==d.id;})
					if (d.deactivatedDate) {
						if (idx!=-1) {lst.splice(idx, 1);}
					} else {
						if (idx!=-1) {
							lst[idx] = d;
						} else {
							lst.push(d);								
						}
					}
					// je pense que le code et incomplet. il faudrait aussi associer au besoin le suiviPat au CSummarySuiviPrevPat au au CSuiviPrevBase.
					model.patientSumUpdated(true);
				}
			}
//model.suiviPrevs().pat			
		}, $scope);

		// billingRessource
/*
		var bresHandlerId = Notification.registerHandler('billingResourceUpdate', function(wsTarget){
			var notif = wsTarget.data;
			if (false) {	// TODO
				if (model.ressource().currList) {
					for(var i = 0; i < model.ressource().currList.length; i++){
						var defData = model.ressource().currList[i] && model.ressource().currList[i].currPatient.ressDefDatas ? model.ressource().currList[i].currPatient.ressDefDatas : undefined;
						if (defData) {
							for(var j = 0; j < defData.length; j++){
								if(defData[j].id === notif.id){
									j =  defData.length;
									OfysUtils.update(defData[j], notif, ['viewbag']);
									if (defData[j].dateTimeEnd) {
										defData.splice(j,1);
									}
								}
							}
						}
					}
				}
			}
		}, $scope);
*/
		var dsqAppointmentSearchProgressHandlerId = Notification.registerHandler('dsqAllSearchProgress', function(msg){
			if(msg && msg.data && msg.data.obj){
				model.home().dsqAppointmentCallDone = msg.data.obj.item;
				model.home().dsqAppointmentCallRemaining = msg.data.obj.over;
			}
		}, $scope);

		var dsqAppointmentSearchHandlerId = Notification.registerHandler('dsqAllSearch', function(msg){
			model.home().dsqAppointmentCallInProgress = false;
			handleDsqResp(msg);
		}, $scope);

		var dsqGestionSignaturesHandlerId = Notification.registerHandler('dsqGestionSignatures', function(msg){
			if(handleDsqGestionResp(msg) == 'OK'){
				delete model.home().dsqAppointmentCallDone;
				delete model.home().dsqAppointmentCallRemaining;
			}
		}, $scope);

		function handleDsqGestionResp(msg){
			var statusError = DashAPI.handleReturnObject(msg.data.status);
			if (statusError=='OK') {
				model.notice().success($filter('translate')('DSQGestionSuccessful'));
			}
			return statusError;
		}

		function handleDsqResp(msg){
			var statusError = DashAPI.handleReturnObject(msg.data.status);
			if (statusError=='OK') {
				if (msg.data.status.message) {
					model.notice().success(msg.data.status.message);
				} else {
					model.notice().success($filter('translate')('DSQAppointmentsDownloadSuccessful'));
				}
			}
			return statusError;
		}

		var errorHandlerId = Notification.registerHandler('error', function(msg){
			var statusError = DashAPI.handleReturnObject(msg.data.status);
		}, $scope);

		// var dsqAppointmentConsentHandlerId = Notification.registerHandler('dsqAllSearchConsent', function(msg){

		// }, $scope);

		var myGroups;
		function isInMyGroup(task){
			if(!myGroups){
				myGroups = [];
				var allGroups = model.user().groups;
				var allGroupsId = Object.keys(allGroups);
				allGroupsId.forEach(function(id){
					for(var i = 0; i < allGroups[id].persons.length; i++){
						if(allGroups[id].persons[i].idPerson === model.user().sessionUser.user.idPerson){
							myGroups.push(id);
							i = allGroups[id].persons.length;
						}
					}
				});
			}
			return myGroups.indexOf(task.toGroup+"") > -1;
		}

		function getType(task){
			var typeStr = "task";
			if(task.dueDatetime){
				if(moment(task.dueDatetime).isBefore(moment(), "day")){
					typeStr = typeStr + "_late";
				} else if(moment(task.dueDatetime).isSame(moment(), "day")){
					typeStr = typeStr + "_tod";
				} else if(moment(task.dueDatetime).isBetween(moment(), moment().add(7, "days"))){
					typeStr = typeStr + "_sem";
				}
			}else{
				typeStr = typeStr +"_sans";
			}

			if(typeStr !== "task"){
				if(task.toGroup){
					typeStr = typeStr + "_group";
				}
				return typeStr;
			}else{
				return "";
			}
		}


		var msgWebSocketActivity = Notification.registerHandler('pingPulse', function(msg){
			model.webSocketActivity(true);
		}, $scope);

		var msgInfoWebSocketActivity = Notification.registerHandler('INFO', function(msg){
			model.notice().success(msg.message);
		}, $scope);
		var msgWarnWebSocketActivity = Notification.registerHandler('WARN', function(msg){
			if (msg != undefined
				&& msg.message != undefined
				// && msg.wsTarget != 'dsq.sommhosp.search'
				// && msg.wsTarget != 'dsq.doc.search'
				) {
				model.notice().warn(msg.message);
			}
		}, $scope);

		// rafraichi avec le refresh auto des stats du tableau de bord.
		$scope.docCountToSee = function() {
			if (model.user().profil && model.dayData(model.user().profil.id)) {
				var c = model.dayData(model.user().profil.id).cnts;
				return (c===undefined || c.doc_see==null?0:c.doc_see);
			}
			return 0;
		}
		$scope.labCountToSee = function() {
			if (model.user().profil && model.dayData(model.user().profil.id)) {
				var c = model.dayData(model.user().profil.id).cnts;
				return (c===undefined || c.lab_see==null?0:c.lab_see);
			}
			return 0;
		}
		$scope.newMessageCount = function() {
			if (model.user().profil && model.dayData(model.user().profil.id)) {
				var c = model.dayData(model.user().profil.id).cnts;
				return (c===undefined || c.msg_new==null?0:c.msg_new);
			}
			return 0;
		}
		$scope.newCourrielCount = function() {
			if (model.user().profil && model.dayData(model.user().profil.id)) {
				var c = model.dayData(model.user().profil.id).cnts;
				return (c===undefined || c.mail_new==null?0:c.mail_new);
			}
			return 0;
		}
		$scope.newUrgentCourrielCount = function() {
			if (model.user().profil && model.dayData(model.user().profil.id)) {
				var c = model.dayData(model.user().profil.id).cnts;
				return (c===undefined || c.mail_urg==null?0:c.mail_urg);
			}
			return 0;
		}
		// on considère les tâches en retard et du jour
		$scope.newTaskCount = function() {
			if (model.user().profil && model.dayData(model.user().profil.id)) {
				var c = model.dayData(model.user().profil.id).cnts;
				return c ? model.dayData(model.user().profil.id).cnts.task_total() : 0;
			}
			return 0;
		}
		$scope.urgentMessageCount = function() {
			if (model.user().profil && model.dayData(model.user().profil.id)) {
				var c = model.dayData(model.user().profil.id).cnts;
				return (c===undefined || c.msg_urg==null?0:c.msg_urg);
			}
			return 0;
		}
		// on considère les tâches en retard et du jour
		$scope.urgentTaskCount = function() {
			if (model.user().profil && model.dayData(model.user().profil.id)) {
				var c = model.dayData(model.user().profil.id).cnts;
				return c && c.task_urg_total!=null ? c.task_urg_total : 0;
			}
			return 0;
		}

		$scope.wRefresh = function() {
			if (QValidation.isDirty()) {
				QValidation.closeContext($filter('translate')('documentUnsavedChanges')).then(pageReload);
			}else{
				pageReload();
			}
		}

		function pageReload(){
			window.location.reload(true);
		}

		$scope.apptsArrivedCount = function() {
			var c=0;
			if (model.appointment().currDate==moment().format(OfysUtils.DATEFORMAT) &&
					model.appointment() && model.appointment().currList && model.appointment().currList.length>0 &&
					model.user().profil && model.currentApptMd().id===model.user().profil.id) {
				c = model.appointment().currList.filterLength(function(a){return a.arrivedTime!==undefined&&a.seenTime===undefined;});
			}
			return c;
		}

		$scope.search = function(valid){
			if(valid){
				$state.go('root.Search', {query: model.search().q });
			}
		};

		$timeout(getQuery,0);
		function getQuery(){
			if($state.current.name =='Search'){
				if(angular.isDefined($state.params.query) ){
					model.search().q = $state.params.query;
				}
			}
		}
	}]);
})();
var activeRequest = 0;
function deactivate(elem){
	activeRequest--
	if(activeRequest === 0){
		$(elem).removeClass("activated");
	}
}

function activate(elem){
	activeRequest++
	if(activeRequest === 1){
		$(elem).addClass("activated");
	}
}