(function(){
	var history = angular.module('history', ['widgets'])
	
	history.controller('HistoryController', ['$scope','model', 'UserAccessor', 'DocAccessor', '$filter',
									function($scope, model, UserAccessor, DocAccessor, $filter){
		
		model.activeController('actions');
		model.activeMenu('Actions');
		model.listResearchOptionSize(1);
		$scope.isSearching = false;
		entries = Object.entries(model.user().list)
		filtered = entries.filter(function(ele){ if(ele[1].idPerson){return ele}});
		$scope.lstUsers = Object.fromEntries(filtered);
		$scope.lstUsers = Object.values($scope.lstUsers).sort((a,b) => (a.personName > b.personName) ? 1 : ((b.personName > a.personName) ? -1 : 0))
		$scope.lstProf = $filter('orderBy')(model.store.profs.filter.treating.list(), ['lastName', 'firstName']);
		$scope.seenItem = [{n:$filter('translate')('UNSEEN'), val:'0'},
							{n:$filter('translate')('SEEN'), val:'1'},
							{n:$filter('translate')('TO_RESOLVE'), val:'2'},
							{n:$filter('translate')('SIGNED_BY_OTHER'), val:'4'},
							{n:$filter('translate')('OPEN_WITH_FILE'), val:'8'}];
		DocAccessor.labels(function(res){
			$scope.listLabels = res.filter(label => !label.isDeleted);
		})
		
		$scope.searchText = "";
		$scope.searchUpdated = function(v) {
			if (v && v.length>2) {
				$scope.searching= true
				var x = v.split(' '); var len = x.length;
				$scope.searchTextRegExp = [];
				for(var i=0;i<len;i++) {
					$scope.searchTextRegExp.push(new RegExp(x[i], 'i'));
				}
			} else {
				delete $scope.searchTextRegExp;
			}
			model.research().mergedDataFiltered = model.research().mergedData.filterFast(filterData);
			model.actUpdated(true);
		};
		
		function matchInArray(string) {
			if ($scope.searchTextRegExp) {
				var len = $scope.searchTextRegExp.length, i=0
				for (; i < len; i++) {
					if (!$scope.searchTextRegExp[i].test(string)) {
						return false;
					}
				}
				return true;
			}
			return true;
		}
		
		var filterData = function(d) {
			if (!filterSearchText(d)) return false;
			
			return true;
		};
		
		/**
		 * COMMENT: HIST LISTHISTORY @function
		 *
		 * Permet de filtrer les items dans la liste d'item trouver vérifie le classname afin 
		 * de faire son trie
		 * 		
		 * @param l: item dans la liste à filtrer
		 */
		var filterSearchText = function(l) {
			var b = true;
			if ($scope.searchTextRegExp) {
				if ('CLaboFile'===l.className || 'CLaboResultsProfessionnal'===l.className) {
					b = matchInArray(l.date+'~'+l.req+'~'+model.getPatIdTitle(l.patient));
				} else if ('CPatientImage'===l.className || 'CBasePatientImage'===l.className) {
					var lbls = "";
					if (l.labels) {
						for (var i2 = 0; i2 < l.labels.length; i2++) {
							lbls += l.labels[i2].n + '~';
						}
					}
					b = matchInArray(l.date+'~'+lbls+'~'+l.scanUserName+'~'+l.name+'~'+model.getPatIdTitle(l.patient));
				} else if ('CEncounter' === l.className){
					var i2;
					var lRx = "";
					if (l.lstPrescription && l.lstPrescription.length && l.lstPrescription.length>0) {
						lRx += 'prescription~ordonnance~';
						for (i2 = 0; i2 < l.lstPrescription.length; i2++) {
							lRx += l.lstPrescription[i2].entryDateSD + '~'+ l.lstPrescription[i2].baseDrugName + '~'+ l.lstPrescription[i2].name + '~';
						}
					}
					var lDv = "";
					if (l.lstDevice && l.lstDevice.length && l.lstDevice.length>0) {
						lDv += 'device~fourniture~';
						for (i2 = 0; i2 < l.lstDevice.length; i2++) {
							lDv += l.lstDevice[i2].entryDateSD + '~'+ l.lstDevice[i2].name + '~';
						}
					}
					var lDx = "";
					if (l.lstDx && l.lstDx.length && l.lstDx.length>0) {
						for (i2 = 0; i2 < l.lstDx.length; i2++) {
							lDx += l.lstDx[i2].entryDateSD + '~'+ l.lstDx[i2].descr[0].toString()+ '~';
						}
					}
					var lPx = "";
					if (l.lstProb && l.lstProb.length && l.lstProb.length>0) {
						for (i2 = 0; i2 < l.lstProb.length; i2++) {
							lPx += l.lstProb[i2].entryDateSD + '~'+ l.lstProb[i2].descr[0].toString()+ '~';
						}
					}
					var lNote = "";
					if (l.lstNote && l.lstNote.length && l.lstNote.length>0) {
						for (i2 = 0; i2 < l.lstNote.length; i2++) {
							lNote += l.lstNote[i2].entryDateS + '~'+ l.lstNote[i2].note+ '~';
						}
					}
					var lRaison = "";
					if (l.lstRaison && l.lstRaison.length && l.lstRaison.length>0) {
						for (i2 = 0; i2 < l.lstRaison.length; i2++) {
							lRaison += l.lstRaison[i2].reason+ '~';
						}
					}
					lRaison += l.encounterTypeS+ '~';

					var lSocHisto = l.socialHistoryObj?l.socialHistoryObj.note:"";
					var lFamHisto = l.familyHistoryObj?l.familyHistoryObj.note:"";
					var lOtherRx = l.otherMedicationsObj?l.otherMedicationsObj.note:"";
					var lRxHisto = l.medicalHistoryObj?l.medicalHistoryObj.note:"";
					var lOngConc = l.ongoingConcernsObj?l.ongoingConcernsObj.note:"";
					var lRem = l.remindersObj?l.remindersObj.note:"";
					var lProf = "";
					if (l.lstProf && l.lstProf.length && l.lstProf.length>0) {
						for (i2 = 0; i2 < l.lstProf.length; i2++) {
							lProf += l.lstProf[i2].entryDateS + '~'+ l.lstProf[i2].profNom+ '~';
						}
					}
					var lAll = "";
					if (l.lstAllergy && l.lstAllergy.length && l.lstAllergy.length>0) {
						lAll +=  'allergie~allergy~';
						for (i2 = 0; i2 < l.lstAllergy.length; i2++) {
							lAll +=  l.lstAllergy[i2].descr.toString()+ '~';
						}
					}
					var lInt = "";
					if (l.lstIntolerance && l.lstIntolerance.length && l.lstIntolerance.length>0) {
						lInt += 'intolerance~';
						for (i2 = 0; i2 < l.lstIntolerance.length; i2++) {
							lInt += l.lstIntolerance[i2].descr.toString()+ '~';
						}
					}
					var lIntv = "";
					if (l.lstIntervention && l.lstIntervention.length && l.lstIntervention.length>0) {
						lIntv += 'intervention~surgery~chirurgie~';
						for (i2 = 0; i2 < l.lstIntervention.length; i2++) {
							lIntv += l.lstIntervention[i2].descr.toString()+ '~';
						}
					}
					var lImm = "";
					if (l.lstImmunization && l.lstImmunization.length && l.lstImmunization.length>0) {
						lImm += 'vaccine~immunisation~immunization~';
						for (i2 = 0; i2 < l.lstImmunization.length; i2++) {
							lImm += l.lstImmunization[i2].descr.toString()+ '~';
						}
					}
					var lPrev = "";
					if (l.lstPrevent && l.lstPrevent.length && l.lstPrevent.length>0) {
						lPrev += 'prevention~';
						for (i2 = 0; i2 < l.lstPrevent.length; i2++) {
							lPrev += l.lstPrevent[i2].descr.toString()+ '~';
						}
					}
					var lRapp = "";
					if (l.lstRappel && l.lstRappel.length && l.lstRappel.length>0) {
						lRapp += 'rappel~reminder~';
						for (i2 = 0; i2 < l.lstRappel.length; i2++) {
							lRapp += l.lstRappel[i2].descr.toString()+ '~';
						}
					}
					var lDoc = "";
					if (l.lstDoc && l.lstDoc.length && l.lstDoc.length>0) {
						lDoc += 'document~';
						for (i2 = 0; i2 < l.lstDoc.length; i2++) {
							lDoc += l.lstDoc[i2].descr ? l.lstDoc[i2].descr.toString()+ '~' : '~';
						}
					}
					var lBp = "";
					if (l.lstBloodPres && l.lstBloodPres.length && l.lstBloodPres.length>0) {
						lBp += 'bloodpressure~tensionarterielle~TA~BP~FC~HR~';
						for (i2 = 0; i2 < l.lstBloodPres.length; i2++) {
							lBp += l.lstBloodPres[i2].descr ? l.lstBloodPres[i2].entryDateS + '~'+ l.lstBloodPres[i2].descr.toString()+ '~' : '~';
						}
					}
					var lTemp = "";
					if (l.lstBodyTemp && l.lstBodyTemp.length && l.lstBodyTemp.length>0) {
						lTemp += 'temperature~';
						for (i2 = 0; i2 < l.lstBodyTemp.length; i2++) {
							lTemp += l.lstBodyTemp[i2].descr ? l.lstBodyTemp[i2].entryDateS + '~'+ l.lstBodyTemp[i2].descr.toString()+ '~' : '~';
						}
					}
					var lFreq = "";
					if (l.lstFreq && l.lstFreq.length && l.lstFreq.length>0) {
						lFreq += 'frequencerespiratoire~breathingfrequency~FR~BR~';
						for (i2 = 0; i2 < l.lstFreq.length; i2++) {
							lFreq += l.lstFreq[i2].descr ? l.lstFreq[i2].entryDateS + '~'+ l.lstFreq[i2].descr.toString()+ '~' : '~';
						}
					}
					var lMeas = "";
					if (l.lstMeasurement && l.lstMeasurement.length && l.lstMeasurement.length>0) {
						lMeas += 'mesure~poids~taille~height~weight~';
						for (i2 = 0; i2 < l.lstMeasurement.length; i2++) {
							lMeas += l.lstMeasurement[i2].descr ? l.lstMeasurement[i2].entryDateS + '~'+ l.lstMeasurement[i2].descr.toString()+ '~' :'~';
						}
					}
					var lPhEx = "";
					if (l.lstPhysicalExam && l.lstPhysicalExam.length && l.lstPhysicalExam.length>0) {
						lPhEx += 'examenphysique~physicalexamination~';
						for (i2 = 0; i2 < l.lstPhysicalExam.length; i2++) {
							lPhEx += l.lstPhysicalExam[i2].descr ? l.lstPhysicalExam[i2].entryDateS + '~'+ l.lstPhysicalExam[i2].descr.toString()+ '~' : '~';
						}
					}
					var lCons = "";
					if (l.lstConsult && l.lstConsult.length && l.lstConsult.length>0) {
						lCons += 'consultation~';
						for (i2 = 0; i2 < l.lstConsult.length; i2++) {
							lCons += l.lstConsult[i2].descr.toString()+ '~';
						}
					}
					var lCustMes = "";
					if (l.lstCustMeasure && l.lstCustMeasure.length && l.lstCustMeasure.length>0) {
						lCustMes += 'mesure~';
						for (i2 = 0; i2 < l.lstCustMeasure.length; i2++) {
							lCustMes += l.lstCustMeasure[i2].entryDateS + '~'+ l.lstCustMeasure[i2].descr.toString()+ '~';
						}
					}
					b = matchInArray(lRx+'~'+lDv+'~'+lRaison+'~'+lNote+'~'+lSocHisto+'~'+lFamHisto+'~'+lOtherRx +
						'~'+lRxHisto+'~'+lOngConc+'~'+lRem+'~'+lDx+'~'+lPx+'~'+lProf+'~'+lAll+'~'+lInt+'~'+lIntv+
						'~'+lImm+'~'+lPrev+'~'+lRapp+'~'+lDoc+'~'+lBp+'~'+lTemp+'~'+lFreq+'~'+lMeas+'~'+lPhEx+'~'+lCons+'~'+lCustMes);
				}
			}
			return b;
		};
		
		if (model.research().currPatient) {
			$scope.quickViewData = model.research().currPatient.currItem;
		}
		
		$scope.hasSelectedActivities = function(){
			return model.research().activitiesType.filterLength(function(a){return a.selected===true;})>0;
		}
		
		$scope.$watch('model.research().activitiesType|filter:{selected:true}', function (nv) {
			model.research().selectedOption = nv.map(function (option) {
		   		return option.id;
			});
			if (model.research().currList.length>0) {
				loadData();
			}
		}, true);
		
		$scope.compassnav = function(direction){
			var d = moment(model.research().currDate, OfysUtils.DATEFORMAT);
			if(!model.research().currDate){
				model.research().currDate = moment().format(OfysUtils.DATEFORMAT);
				d = moment(model.research().currDate, OfysUtils.DATEFORMAT);
			}
			if(direction === 'N'){
				model.research().currDate = d.add(1, 'days').format(OfysUtils.DATEFORMAT);
			}else if(direction === 'C'){
				model.research().currDate = moment().format(OfysUtils.DATEFORMAT);
			}else if(direction === 'S'){
				model.research().currDate = d.subtract(1, 'days').format(OfysUtils.DATEFORMAT);
			}
		};
		
		$scope.researchDynaDateOptions = {acceptFutureDate: false};
		$scope.listSize = function() {
			return model.listResearchSize();
		};
		
		$scope.listOptionSize = function() {
			return model.listResearchOptionSize();
		}
		
		$scope.selectAllType = function(){
			for(const type of model.research().activitiesType){
				if(model.research().selectedOption.indexOf(type.name) === -1){
					type.selected = true;
				}
			}
		}
		
		$scope.researchActivities = function(){
			model.research().currList.length=0;
			model.research().loaded = 1;
			model.actUpdated(true);
			var data = {
				idProfessionnal: model.user().profil.id,
				dateRange: moment(model.research().currDate).startOf('day').valueOf(),
				researchType: model.research().selectedOption
			}
			if (model.research().selectedOption.length > 0){
				$scope.isSearching = true;
				UserAccessor.researchActivities(data,function(res){
					$scope.isSearching = false;
					if (res.data.success===false) {
						model.notice().warn(res.data.ms);
					} else  {
						if(res.data.lstBasePatientImage && res.data.lstBasePatientImage.length > 0){
							model.research().currList.push({'baseImages': res.data.lstBasePatientImage});
						}
						if (res.data.lstCEncounter && res.data.lstCEncounter.length > 0){
							model.research().currList.push({'baseEncounter': res.data.lstCEncounter})
						}
						if (res.data.lstLaboFile && res.data.lstLaboFile.length > 0){
							model.research().currList.push({'laboFile': res.data.lstLaboFile})
						}
						model.research().resData = res.data;
						loadData(res.data)
						model.research().loaded = 2;
						if(model.research().currList.length>0){
							model.listResearchOptionSize(2)
						} else{
							model.listResearchOptionSize(1)
						}
					}
				}, function(err) {
					console.log(err);
					model.notice().warn($filter('translate')('error') + ": " + err);										
					$scope.isSearching = false;			
				});
			}
			
		}
		
		$scope.isFirst = function(d, arr) {
			if (arr.first === -1 || d === arr.first) {
				arr.first = d;
				return true
			}
			return false;
		};
				
		if ($scope.labs===undefined) $scope.labs = {loaded:false, all:[], lastIds:'', first:-1};
		if ($scope.docs===undefined) $scope.docs = {loaded:false, all:[], lastIds:'', first:-1};
		if ($scope.encs===undefined) $scope.encs = {loaded:false, all:[], lastIds:'', first:-1};
		
		function resetFirsts() {
			$scope.labs.first = -1;
			$scope.docs.first = -1;
			$scope.encs.first = -1;
		}
		
		function loadData(d) {
			if (d==undefined) {
				d = model.research().resData;
			}
			var newArray = [];			
			for (arr in d){
				if ('lstBasePatientImage'===arr && model.research().selectedOption.indexOf(1)>-1) {
					newArray = [].concat(newArray, d[arr]);
				} else if ('lstLaboFile'===arr && model.research().selectedOption.indexOf(2)>-1) {
					newArray = [].concat(newArray, d[arr]);
				} else if ('lstCEncounter'===arr && model.research().selectedOption.indexOf(4)>-1) {
					newArray = [].concat(newArray, d[arr]);					
				} 
			}
			model.research().mergedData = newArray;
			model.research().mergedDataFiltered = model.research().mergedData;
			resetFirsts();
			model.actUpdated(true);
		}

		model.callDashBoardCount();
												
	}]);
	
	/**
	 * COMMENT: HIST RESEARCH @directive
	 *
	 * La directive sert seulement à afficher la section research pour le moment.
	 *
	 */
	history.directive('research', ['model', function(model){

		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/history/research_tab.html?v=ba',
			//scope: true,
			link: function(scope){
//				scope.researchTypes = [{val:0,name:'Documents'},{val:1,name:'Laboratories'}];
//				scope.researchType = 0;
			}
		};
	}]);
	
	history.directive('researchDoc', ['model', '$filter', 'DocAccessor', 'PatientFormService', function(model, $filter, DocAccessor, PatientFormService){

		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/history/research_doc.html?v=ba',
			//scope: true,
			link: function(scope){
				var DATEFORMAT = 'YYYY-MM-DD';
				var datesArr = [['docAfterDate','docBeforeDate'],['docCreateAfterDate','docCreateBeforeDate']];
				
				scope.normalityItems = [{n:$filter('translate')('SO'), val:'0'},
				                       {n:$filter('translate')('NORMAL'), val:'1'},
				                       {n:$filter('translate')('ANORMAL'), val:'2'},
				                       {n:$filter('translate')('VERY_ANORMAL'), val: '3'}];

				scope.researchDynaDateOptionsDocAfter = {acceptFutureDate: false};
				scope.researchDynaDateOptionsDocBefore = {
						acceptFutureDate: false,
						defaultDate: moment(new Date())
					};
				scope.researchDynaDateOptionsCreateAfter = {acceptFutureDate: false};
				scope.researchDynaDateOptionsCreateBefore = {acceptFutureDate: false};				

                scope.greaterThanDoc = function(val){
					let diffDateDoc = moment(val).diff(model.research().docsearch.docAfterDate, 'years', true)
                    return (isNaN(diffDateDoc) || diffDateDoc >=0);
                }
				scope.smallerThanDoc = function(val){
					let diffDateDoc = moment(model.research().docsearch.docBeforeDate).diff(val, 'years', true)
                    return (isNaN(diffDateDoc) || diffDateDoc >= 0);
                }
				scope.validDoc = function(validator) {
                    validator.dateStartDoc.$validate();
                    validator.dateEndDoc.$validate();
                }
				scope.greaterThanCreate = function(val){
					let diffDatecreated = moment(val).diff(model.research().docsearch.docCreateAfterDate, 'years', true)
                    return (isNaN(diffDatecreated) || diffDatecreated >= 0);
                }
				scope.smallerThanCreate = function(val){
					let diffDateDoc = moment(model.research().docsearch.docBeforeDate).diff(val, 'years', true)
                    return (isNaN(diffDateDoc) || diffDateDoc >= 0);
                }
				scope.validCreate = function(validator) {
                    validator.dateStartCreate.$validate();
                    validator.dateEndCreate.$validate();
                }
								
				scope.$watch('listLabels|filter:{selected:true}', function (nv) {
					model.research().docsearch.selectedLabels = nv.map(function (option) {
				   		return option.id;
					});
				}, true);
				
				scope.patientSearch = {
                    onSelect:function(pat){
                    	model.research().docsearch.patientDoc = pat; 
						model.actUpdated(true); 
                    }
                }

				scope.removePatient =function(pat){
                    model.research().docsearch.patientDoc = null;
					model.actUpdated(true); 
                }

				function initialFocus(){
                    $timeout(function(){
                        if(scope.patientSearch.focus){
                            scope.patientSearch.focus();
                        }
                    }, 50)
                };
				
				function setMissingDate(ds, dates, itv) {
					var now = moment();
					for (var i=0;i<dates.length;i++) {
						var dd = dates[i];
						if (MyNamespace.helpers.isNotEmpty(ds[dd[0]]) && MyNamespace.helpers.isEmpty(ds[dd[1]])) {
							var max = moment(ds[dd[0]]).add(itv.nb, itv.unit);
							if (max.isBefore(now)) {
								ds[dd[1]] = max.format(DATEFORMAT);
							} else {
								ds[dd[1]] = now.format(DATEFORMAT);
							}
						} else if (MyNamespace.helpers.isNotEmpty(ds[dd[1]]) && MyNamespace.helpers.isEmpty(ds[dd[0]])) {
							var min = moment(ds[dd[1]]).subtract(itv.nb, itv.unit);
							ds[dd[0]] = min.format(DATEFORMAT);
						}
					}					
				}
				function hasADate(ds, dates) {
					for (var i=0;i<dates.length;i++) {
						var dd = dates[i];
						if (MyNamespace.helpers.isNotEmpty(ds[dd[0]]) || MyNamespace.helpers.isNotEmpty(ds[dd[1]])) {
							return true;
						}
					}
				}
				scope.hasSelectedADate = function(){
					return hasADate(model.research().docsearch, datesArr);
				}
				
				scope.researchDoc = function(frm){
					scope.frmErrors = PatientFormService.getFormErrors(frm,null, {validfn: "inverse_"});
					model.actUpdated(true);
				    if(frm.$valid && scope.hasSelectedADate()){
						model.research().docList.length=0;
						model.research().loaded = 1;
						var idPatient = null
						var canDo = true;
						setMissingDate(model.research().docsearch, datesArr, {unit:'years', nb:1});
						
						if(model.research().docsearch.patientDoc && model.research().docsearch.patientDoc.id){
							idPatient = model.research().docsearch.patientDoc.id;
						} else {
							var diffDateDoc = moment(model.research().docsearch.docBeforeDate).diff(model.research().docsearch.docAfterDate, 'years', true)
							var diffDatecreated = moment(model.research().docsearch.docCreateBeforeDate).diff(model.research().docsearch.docCreateAfterDate, 'years', true)
							canDo = (!isNaN(diffDateDoc) && diffDateDoc <= 1) || (!isNaN(diffDatecreated) && diffDatecreated <= 1);
						}
						if (canDo) {
							var data = {
								idProfessionnal: model.research().docsearch.profIdDoc,
								idUser: model.research().docsearch.userIdDoc,
								listTypes: model.research().docsearch.selectedLabels,
								idPatient: idPatient,
								status: model.research().docsearch.seen,
								results: model.research().docsearch.normality,
								startDocDate: moment(model.research().docsearch.docAfterDate).startOf('day').valueOf(),
								endDocDate: moment(model.research().docsearch.docBeforeDate).startOf('day').valueOf(),
								startCreateDate: moment(model.research().docsearch.docCreateAfterDate).startOf('day').valueOf(),
								endCreateDate: moment(model.research().docsearch.docCreateBeforeDate).startOf('day').valueOf(),
								name: model.research().docsearch.docName,
								getFuturAppts: false,	
							}
							
							scope.isSearching = true;
							DocAccessor.searchDoc(data,function(res){
								scope.isSearching = false;
								if (res.data.success===false) {
									model.notice().warn(res.data.ms);
								} else  {
									model.research().docList = res.data;
									if(model.research().docsearch.patientDoc && model.research().docsearch.patientDoc.id){
										for (element of model.research().docList) {
											element.patient = model.research().docsearch.patientDoc
										}
									}
									model.research().loaded = 2;
									model.actUpdated(true);
								}
							}, function(err) {
								console.log(err);
								model.notice().warn($filter('translate')('error') + ": " + err);										
								scope.isSearching = false;			
							});					
						}else{
							scope.frmErrors = [{msg : $filter('translate')('invalid_date', {interval: $filter('translate')('1an')})}];				
						}
					} else{
						let msg = 'required_date'
						if(scope.hasSelectedADate()){
							msg = "inverse_date";
						}
						scope.frmErrors = [{msg : $filter('translate')(msg)}];
					}
				}
			}
		};
	}]);
	
	history.directive('researchLabo', ['model', 'LabAccessor', '$filter', 'PatientFormService', function(model, LabAccessor, $filter, PatientFormService){

		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/history/research_labo.html?v=ba',
			//scope: true,
			link: function(scope){
				var DATEFORMAT = 'YYYY-MM-DD';
				var datesArr = [
							['labServiceAfterDate','labServiceBeforeDate'],
							['labRequestAfterDate','labRequestBeforeDate'],
							['labSeenAfterDate','labSeenBeforeDate'],
							['labSignAfterDate','labSignBeforeDate']
						];
				
				function setMissingDate(ds, dates, itv) {
					var now = moment();
					for (var i=0;i<dates.length;i++) {
						var dd = dates[i];
						if (MyNamespace.helpers.isNotEmpty(ds[dd[0]]) && MyNamespace.helpers.isEmpty(ds[dd[1]])) {
							var max = moment(ds[dd[0]]).add(itv.nb, itv.unit);
							if (max.isBefore(now)) {
								ds[dd[1]] = max.format(DATEFORMAT);
							} else {
								ds[dd[1]] = now.format(DATEFORMAT);
							}
						} else if (MyNamespace.helpers.isNotEmpty(ds[dd[1]]) && MyNamespace.helpers.isEmpty(ds[dd[0]])) {
							var min = moment(ds[dd[1]]).subtract(itv.nb, itv.unit);
							ds[dd[0]] = min.format(DATEFORMAT);
						}
					}					
				}
				function hasADate(ds, dates) {
					for (var i=0;i<dates.length;i++) {
						var dd = dates[i];
						if (MyNamespace.helpers.isNotEmpty(ds[dd[0]]) || MyNamespace.helpers.isNotEmpty(ds[dd[1]])) {
							return true;
						}
					}
				}
				scope.hasSelectedADate = function(){
					return hasADate(model.research().labosearch, datesArr);
				}
				
                scope.greaterThanService = function(val){
					let diffDateService = moment(val).diff(model.research().labosearch.labServiceAfterDate, 'months', true)
					return isNaN(diffDateService) || diffDateService >= 0;
                }
				scope.greaterThanRequest = function(val){
                    let diffDateRequest = moment(val).diff(model.research().labosearch.labRequestAfterDate, 'months', true)
					return isNaN(diffDateRequest) || diffDateRequest >= 0;
                }
				scope.greaterThanSeen = function(val){
                    let diffDateSeen = moment(val).diff(model.research().labosearch.labSeenAfterDate, 'months', true)
					return isNaN(diffDateSeen) || diffDateSeen >= 0;
                }
				scope.greaterThanSign = function(val){
                    let diffDateSign = moment(val).diff(model.research().labosearch.labSignAfterDate, 'months', true)
                    return isNaN(diffDateSign) || diffDateSign >= 0;
                }
				scope.smallerThanService = function(val){
					let diffDateService = moment(model.research().labosearch.labServiceBeforeDate).diff(val, 'months', true)
					return isNaN(diffDateService) || diffDateService >= 0;
                }
				scope.smallerThanRequest = function(val){
					let diffDateRequest = moment(model.research().labosearch.labRequestBeforeDate).diff(val, 'months', true)
					return isNaN(diffDateRequest) || diffDateRequest >= 0;
                }
				scope.smallerThanSeen = function(val){
					let diffDateSeen = moment(model.research().labosearch.labSeenBeforeDate).diff(val, 'months', true)
					return isNaN(diffDateSeen) || diffDateSeen >= 0;
                }
				scope.smallerThanSign = function(val){
					let diffDateSign = moment(model.research().labosearch.labSignBeforeDate).diff(val, 'months', true)
                    return isNaN(diffDateSign) || diffDateSign >= 0;
                }

				scope.validService = function(validator) {
                    validator.dateStartService.$validate();
                    validator.dateEndService.$validate();
                }
				scope.validRequest = function(validator) {
                    validator.dateStartRequest.$validate();
                    validator.dateEndRequest.$validate();
                }
				scope.validSeen = function(validator) {
                    validator.dateStartSeen.$validate();
                    validator.dateEndSeen.$validate();
                }
				scope.validSign = function(validator) {
                    validator.dateStartSign.$validate();
                    validator.dateEndSign.$validate();
                }
								
				scope.otherValues = [{n:$filter('translate')('extreme_value'), val:'0'},
				                       {n:$filter('translate')('abnormal_result'), val:'1'},];
				scope.finalResults = [{n:$filter('translate')('final_result'), val:'10'}];
				scope.researchDynaDateOptionsServiceAfter = {acceptFutureDate: false};
				scope.researchDynaDateOptionsServiceBefore = {acceptFutureDate: false};
				scope.researchDynaDateOptionsRequestAfter = {acceptFutureDate: false};
				scope.researchDynaDateOptionsRequestBefore = {acceptFutureDate: false};
				scope.researchDynaDateOptionsSeenAfter = {acceptFutureDate: false};
				scope.researchDynaDateOptionsSeenBefore = {acceptFutureDate: false};
				scope.researchDynaDateOptionsSignAfter = {acceptFutureDate: false};
				scope.researchDynaDateOptionsSignBefore = {acceptFutureDate: false};
				
				scope.$watch('otherValues|filter:{selected:true}', function (nv) {
					model.research().labosearch.otherValue = nv.map(function (option) {
						if (option.val == 0 && (model.research().labosearch.otherValue == 1)){
							scope.otherValues[1].selected = false
						} else if (option.val == 1 && (model.research().labosearch.otherValue == 0)){
							scope.otherValues[0].selected = false
						}
				   		return option.val;
					})[0];
				}, true);
				
				scope.$watch('finalResults|filter:{selected:true}', function (nv) {
					scope.finalResult = nv.map(function (option) {
				   		return option.val;
					});
				}, true);
								
				scope.researchLab = function(frm){
					scope.frmErrors = PatientFormService.getFormErrors(frm,null, {validfn: "inverse_"});
					model.actUpdated(true);
				    if(frm.$valid && scope.hasSelectedADate()){
						scope.isSearching = true;
						model.research().laboList.length=0;
						model.research().loaded = 1;
						var idPatient = null
						var canDo = true;
						// complete missing date
						setMissingDate(model.research().labosearch, datesArr, {unit:'months', nb:3});
						if(model.research().labosearch.patientLab && model.research().labosearch.patientLab.id){
							idPatient = model.research().labosearch.patientLab.id;
						} else {
							var diffDateService = moment(model.research().labosearch.labServiceBeforeDate).diff(model.research().labosearch.labServiceAfterDate, 'months', true)
							var diffDateRequest = moment(model.research().labosearch.labRequestBeforeDate).diff(model.research().labosearch.labRequestAfterDate, 'months', true)
							var diffDateSeen = moment(model.research().labosearch.labSeenBeforeDate).diff(model.research().labosearch.labSeenAfterDate, 'months', true)
							var diffDateSign = moment(model.research().labosearch.labSignBeforeDate).diff(model.research().labosearch.labSignAfterDate, 'months', true)
							canDo = (!isNaN(diffDateService) && diffDateService <= 3 || (!isNaN(diffDateRequest) && diffDateRequest <= 3) 
								|| (!isNaN(diffDateSeen) && diffDateSeen <= 3) || (!isNaN(diffDateSign) && diffDateSign <= 3 ));
						}
						if (canDo) {					
							extremeValue = false;
							resultFlag = model.research().labosearch.otherValue;
							if(model.research().labosearch.otherValue && resultFlag == 0) {
								extremeValue = true;
								resultFlag = null;
							}
							var data = {
								idProfessionnal: model.research().labosearch.profIdlab,
								idDispensateur: model.research().labosearch.otherProfIdDoc,
								idPatient: idPatient,
								status: model.research().labosearch.seen,
								labRequestAfterDate: moment(model.research().labosearch.labRequestAfterDate).startOf('day').valueOf(),
								labRequestBeforeDate: moment(model.research().labosearch.labRequestBeforeDate).startOf('day').valueOf(),
								labSeenAfterDate: moment(model.research().labosearch.labSeenAfterDate).startOf('day').valueOf(),
								labSeenBeforeDate: moment(model.research().labosearch.labSeenBeforeDate).startOf('day').valueOf(),
								labServiceAfterDate: moment(model.research().labosearch.labServiceAfterDate).startOf('day').valueOf(),
								labServiceBeforeDate: moment(model.research().labosearch.labServiceBeforeDate).startOf('day').valueOf(),
								labSignAfterDate: moment(model.research().labosearch.labSignAfterDate).startOf('day').valueOf(),
								labSignBeforeDate: moment(model.research().labosearch.labSignBeforeDate).startOf('day').valueOf(),
								name: model.research().labosearch.contains,
								resultFlag: resultFlag,
								hasExtremeValue: extremeValue,
								orderStatus: model.research().labosearch.finalResult[0]
							}
							
							LabAccessor.searchLabo(data,function(res){
								scope.isSearching = false;
								if (res.data.success===false) {
									model.notice().warn(res.data.ms);
								} else  {
									res.data.forEach(function(l){
										l.fromSearch = true;
									})
									model.research().laboList = res.data;
									if(model.research().labosearch.patientLab && model.research().labosearch.patientLab.id){
										for (element of model.research().docList) {
											element.patient = model.research().docsearch.patientDoc
										}
									}
									model.research().loaded = 2;
									model.actUpdated(true);
								}
							}, function(err) {
								console.log(err);
								model.notice().warn($filter('translate')('error') + ": " + err);										
								scope.isSearching = false;			
							});	
						}else{
							scope.frmErrors = [{msg : $filter('translate')('invalid_date', {interval: $filter('translate')('3mois')} )}];										
							scope.isSearching = false;	
						}	
					} else{
						let msg = 'required_date'
						if(scope.hasSelectedADate()){
							msg = inverse_date;
						}
						scope.frmErrors = [{msg : $filter('translate')(msg)}];
					}		
				}
				
				scope.patientSearch = {
                    onSelect:function(pat){
                    	delete scope.patientLab; 
						model.research().labosearch.patientLab = pat;
						model.actUpdated(true); 
                    }
                }

				scope.removePatient =function(pat){
                    model.research().labosearch.patientLab = null;
					model.actUpdated(true); 
                }

				function initialFocus(){
                    $timeout(function(){
                        if(scope.patientSearch.focus){
                            scope.patientSearch.focus();
                        }
                    }, 50)
                };
			}
		};
	}]);
	
	/**
	 * COMMENT: HIST ACTIVITY @directive
	 *
	 * La directive sert seulement à afficher la section activité pour le moment.
	 * Le reste des méthode est gérer dans LISTHISTORY
	 */
	history.directive('activity', ['model', function(model){

		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/history/activity_tab.html?v=ba',
			//scope: true,
			link: function(scope){
				
			}
		};
	}]);
	
	/**
	 * COMMENT: HIST LISTHISTORY @directive
	 *
	 * La directive sert à gérer la liste des résultats de recherche.
	 * Permet le trie, la gestion de l'affichage ainsi que l'ouverture des items dans leur section		
	 */
	history.directive('listhistory', ['model', function(model){
			return{
				restrict: 'A',
				scope:true,
				link: function (scope){
					
				scope.showData = function(data){
					model.research().currPatient = data.patient;
					model.research().currPatient.viewOnly = true;
					if (scope.quickViewData==undefined)	{
						// si on veut que le scope.$watch fonctionne dans le doc.js, il faut réutiliser scope.quickViewData si existe deja. 
						scope.quickViewData = {};
					}
					scope.quickViewData.qvActData = data;
					scope.quickViewData.pat = data.patient;
					model.research().currPatient.currItem = scope.quickViewData;
					data.patient.viewbag.patData = {
										fax:[],app:[],ffApp:[],msg:[],msgpat:[],srvy:[],docofys:[],doc:[],lab:[],labofys:[],rem:[],ress:[],task:[],form:[],frm1:[],frm2:[],frm3:[],enc:[],encLast5Last3y:[],sum:[], hxrx:[],
										loaded:{fax:0,app:2,ffApp:0,msg:0,msgpat:0,srvy:2,doc:2,lab:2,rem:2,ress:0,task:2,form:2, encLast5Last3y: 2, enc:2,presaveenc:2,sum:2,doneLoaded:0, dsqlab: 0,dsqsommhosp:0, dsqdoc:0, hxrx:0},
										counts:{},
										docs:{labels:[]}
									};
					model.actUpdated(true);
					model.patientUpdated(true);
				}	
		
				scope.actOptions = {verbose: false, fct:scope.showData};	
					
			}
		}							
	}]);	
})();
