(function(){
	var encounter = angular.module('encounter', ['ui.grid','ui.grid.selection', 'ui.grid.pinning', 'ngSanitize']);
	
	
	encounter.factory('EncounterAccessor', ['DashAPI','MessageLink','model','$q','DashWebSocket',
						function(DashAPI, MessageLink, model, $q, DashWebSocket ) {
		var accessor = {
			utils : {
			},
			baseDrugTypes: {
				REGULAR:0,
				NARCOTIC:1,
				CONTROLED:2,
				FOURNITURE:3,
			},
			allEncSections: [
				'header',
				'lstRaison',
				'lstNote',
				'lstBloodPres',
				'lstFreq',
				'lstBodyTemp',
				'lstMeasurement',
				'lstCustMeasure',
				'lstPhysicalExam',
				'lstDoc',
				'lstImmunization',
				'lstPrescription',
				'lstDevice',
				'lstDxEnc',
				'lstBilling',
			],
			summarySections: [
				'lstDx',	// modif du sommaire faits dans une rencontre
				'lstConsult',//here to remove it from encounter addables.. but is not added through the summary
				//Summary items;
				'lstAllergy',
				'ongoingConcernsObjArr',
				'lstIntolerance',
				'otherMedicationsObjArr',
				'lstProb',
				'lstIntervention',
				'medicalHistoryObjArr',
				'lstLifeHabit',
				'lstRappel',
				'familyHistoryObjArr',
				'socialHistoryObjArr',
				//end of Summary items
			],
			isSummarySpecific: function(title){
				return accessor.summarySections.indexOf(title) !== -1;
			},
			EncView: function(id, callback, error){
				return DashAPI.get('/dashboard/encs/ws/encview?encId=' + id, callback, error);
			},
			findAllNotesIncludingRevisionsAndDeletedByEncounterAnchor: function(id, callback, error, config){
				return DashAPI.get('/dashboard/encs/ws/findAllNotesIncludingRevisionsAndDeletedByEncounterAnchor?idAnchor=' + id, callback, error, config);
			},
			listStatusFactureOnDate : function (d, callback, error){
				return DashAPI.get("/dashboard/encs/ws/listStatusFactureOnDate?modOnDate=" + d.entryDateStart +'&modToDate=' + d.entryDateEnd, callback, error);
			},
			listStatusFacture : function (d, callback, error){
				return DashAPI.get("/dashboard/encs/ws/listStatusFacture?factUid=" + d.factUid, callback, error);
			},
			saveFactType : function (data, callback, error){
				return DashAPI.get("/dashboard/encs/ws/enc/saveFactType?idEncAnc=" + data.idEncAnc + '&idProf=' + data.idProf + '&idPat=' + data.idPat + '&idFactType=' + data.idFactType + '&factUid=' + data.factUid, model.handlePrint(callback), error);
			},
			listOnDate : function (d, callback, error){
				return DashAPI.get("/dashboard/encs/ws/listOnDate?modOnDate=" + d, callback, error);
			},
			list : function (id, callback, error){
				return DashAPI.get("/dashboard/encs/ws/list?idPt=" + id, callback, error);
			},
			listLast5Last3y : function (id, callback, error){
				return DashAPI.get("/dashboard/encs/ws/listLast5Last3y?idPt=" + id, callback, error);
			},
			getPresaved : function (id, callback, error){
				return DashAPI.get("/dashboard/encs/ws/enc/presave/get?idPt=" + id, callback, error);
			},
			deletePresaved : function (id, callback, error){
				return DashAPI.get("/dashboard/encs/ws/enc/presave/delete?idPt=" + id, callback, error, DashAPI.hideMsg());
			},
			followUpChartRx : function (data, callback, error){
				return DashAPI.get("/dashboard/encs/ws/followUpChartRx?patId=" + data.patId+"&start="+ data.start+"&end="+data.end, callback, error);
			},
			searchDrug : function (data, callback, error){
				return DashAPI.get("/dashboard/encs/ws/prescriptor/searchDrug?q=" + b64EncodeUnicode(data.q), callback, error);
			},
			doseCalculatorData : function (data, callback, error){
				return DashAPI.get("/dashboard/encs/ws/doseCalculatorData?drugName=" + data.drugName + "&strength="+ data.strength, callback, error);
			},
			selectDrug : function (data, callback, error){
				var sObj = JSON.stringify(_.omit(data.current, 'viewbag') );
				return DashAPI.post('/dashboard/encs/ws/prescriptor/selectDrug/post?id='+data.id, accessor.toUidObj(sObj, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter.Prescription'), callback, error);
			},
			analyseAllergies : function (data, callback, error){
				var type = 'ca.infodata.ofys.ui.dashboard.models.DataForRxAllergies';
				var sObj = JSON.stringify(data);
				return DashAPI.post('/dashboard/encs/ws/analyseAllergies/post', accessor.toUidObj(sObj, type), function(res){
					if (callback) callback(res);
				}, error);
			},
			renalDosing : function (data, callback, error){
				var type = 'ca.infodata.ofys.ui.dashboard.models.DataForRenalDosing';
				var sObj = JSON.stringify(data);
				return DashAPI.post('/dashboard/encs/ws/renalDosing/post', accessor.toUidObj(sObj, type), function(res){
					if (callback) callback(res);
				}, error);
			},
			prescriptionexceptionpdf : function (data, callback, error){
				function handleUrl(res){
					if(res && res.data && typeof res.data === "string"){
						window.open(res.data,'_blank');
					}
					if(callback !== undefined){
						callback(res);
					}
				}
				return DashAPI.post('/dashboard/encs/ws/prescriptionexceptionpdf', data, handleUrl, error);
			},
			rxinteractions : function (data, callback, error){
				return DashAPI.post('/dashboard/encs/ws/rxinteractions', data, callback, error);
			},
			hasEncounterInEdit: function(patient, currentEncounter){
				var i = accessor.inEditIndex(patient);
				if(i > -1){
					if(currentEncounter && patient.viewbag.patData.enc[i].uid === currentEncounter.uid){
						return false;
					}
					return true;
				}
				return false;
			},
			inEditIndex:function(patient){
				if(patient && patient.viewbag && patient.viewbag.patData.enc){
					return patient.viewbag.patData.enc.findIndex(accessor.inEditMode);
				}
				return -1;
			},
			inEditMode: function(e){
				return e.editMode || (e.viewbag && e.viewbag.editEnc && e.viewbag.editEnc.editMode)
			},
			noTitle: ['header'],
			getNameKey: function (keyg){
				var fileMap = {
					lstAllergy: [
						'lstIntolerance'
					],
					lstDx:[
						'lstProb'
					],
					lstNote: [
						'ongoingConcernsObjArr',
						'otherMedicationsObjArr',
						'medicalHistoryObjArr',
						'familyHistoryObjArr',
						'socialHistoryObjArr',
					]
				};
				var vMap = Object.keys(fileMap);
				for(var i = 0; i < vMap.length; i++){
					if(fileMap[vMap[i]].indexOf(keyg) > -1){
						return vMap[i];
					}
				}
				return keyg;
			},
			initEntry: function (key, entryDefs, forEntryDef, editEnc){
				entryDefs[key].read = true;
				if(accessor.isSummarySpecific(key)){
					entryDefs[key].readOnly = true;
				}
				entryDefs[key].isList = key.startsWith("lst")

				if(accessor.noTitle.indexOf(key) === -1){
					entryDefs[key].title = key;
				}
				var keyFile = accessor.getNameKey(key);
				entryDefs[key].inEncounter = true;
				entryDefs[key].hasOkPlusBtn = true;
				entryDefs[key].listItemActions = [{icon:"fa-trash-o red", namei18n: 'Delete',show: function(){return !accessor.isSummarySpecific(key) && editEnc.editMode;},type: 'popover', popoverUrl: '/dashboard/resources/ofys/widgets/confirmDelete.html?v=ba'}];
				entryDefs[key].readTemplateUrl = '/dashboard/resources/ofys/encounter/entry/'+ keyFile + '_enc_entry_read.html?v=ba';
				entryDefs[key].editTemplateUrl =  '/dashboard/resources/ofys/encounter/entry/'+ keyFile + '_enc_entry_edit.html?v=ba';
				if(forEntryDef[key]){
					forEntryDef[key](entryDefs[key])
				}
			},
			encounterTypes : function (group, callback, error){
				if(accessor.allEncTypes){
					if(!group){
						callback(accessor.allEncTypes);
						callback(accessor.encTypes);
					}else if(group === 1){
						callback(accessor.importSumTypes);
					}else if(group === 2){
						callback(accessor.importRxTypes);
					}else if(group === 3){
						callback(accessor.encTypes);
					}
				}else{
					DashAPI.get("/dashboard/encs/ws/enctypes", function(res){
						delete res.data.className;
						accessor.allEncTypes = res.data;
						var importSumary = {};
						var importRxDsq = {};
						var encounter = {};
						Object.keys(res.data).filter(function(k){return k==1}).forEach(function(key){
							importSumary[key]= res.data[key];
						});
						Object.keys(res.data).filter(function(k){return k==2}).forEach(function(key){
							importRxDsq[key]= res.data[key];
						});
						Object.keys(res.data).filter(function(k){return k>9}).forEach(function(key){
							encounter[key]= res.data[key];
						});
						accessor.importSumTypes = importSumary;
						accessor.importRxTypes = importRxDsq;
						accessor.encTypes = encounter;
						if(group===0){
							callback(accessor.allNoteTypes);
						}else if(group === 1){
							callback(accessor.importSumTypes);
						}else if(group === 2){
							callback(accessor.importRxTypes);
						}else if(group === 3){
							callback(accessor.encTypes);
						}
					}, error);				
				}
			},
			noteTypes : function (group, callback, error){
				if(accessor.allNoteTypes){
					if(!group){
						callback(accessor.allNoteTypes);
					}else if(group === 1){
						callback(accessor.encNoteTypes);
					}else if(group === 2){
						callback(accessor.sumNoteTypes);
					}
				}else{
					return DashAPI.get("/dashboard/encs/ws/sumnotess", function(res){
						delete res.data.className;
						accessor.allNoteTypes = res.data;
						var enc = {};
						var sum = {};
						Object.keys(res.data).filter(function(k){return k <= 100}).forEach(function(key){
							enc[key] = res.data[key];
						});
						Object.keys(res.data).filter(function(k){return k > 100}).forEach(function(key){
							sum[key] = res.data[key];
						});
						accessor.encNoteTypes = enc;
						accessor.sumNoteTypes = sum;
						if(!group){
							callback(accessor.allNoteTypes);
						}else if(group === 1){
							callback(accessor.encNoteTypes);
						}else if(group === 2){
							callback(accessor.sumNoteTypes);
						}
					}, error);
				}
			},
			lifeHabitTypes : function (callback, error){
				if(accessor.allHabitTypes){
					callback(accessor.allHabitTypes);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlist?className=ca.infodata.ofys.data.middle.dataobjects.encounter.XLifeHabitType", function(res){
						delete res.data.className;
						accessor.allHabitTypes = res.data;
						accessor.habitTypes = [];
						accessor.frequencyOptions = [];
						Object.keys(res.data).forEach(function(k0){
							var theData = res.data[k0];
							var key = k0.split('~');
							var keyVal = key[0];
							var keyName = key[1];
							accessor.habitTypes[keyVal] = keyName;
							accessor.frequencyOptions[keyVal]={};
							Object.keys(theData).forEach(function(k1){
								accessor.frequencyOptions[keyVal][k1] = theData[k1];
							});							
						});
						
					}, error);
				}
			},
			dxStatus : function (callback, error){// 0, 1=fait, 2=mettre histo, 3=1+2 (car ds bd=enumset) 
				if(accessor.allDxStatus){
					callback(accessor.allDxStatus);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlist?className=ca.infodata.ofys.data.middle.dataobjects.encounter.XDiagnosticStatus", function(res){
						delete res.data.className;
						accessor.allDxStatus = res.data;
						callback(accessor.allDxStatus);
					}, error);
				}
			},
			rxType : function (callback, error){// 0, 1=fait, 2=mettre histo, 3=1+2 (car ds bd=enumset) 
				if(accessor.allRxType){
					callback(accessor.allRxType);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlist?className=ca.infodata.ofys.data.middle.dataobjects.medication.XDrugType", function(res){
						delete res.data.className;
						accessor.allRxType = res.data;
						callback(accessor.allRxType);
					}, error);
				}
			},
			bodyTemperatureType : function (callback, error){
				if(accessor.allBodyTemperatureType){
					callback(accessor.allBodyTemperatureType);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlist?className=ca.infodata.ofys.data.middle.dataobjects.encounter.XBodyTemperatureType", function(res){
						delete res.data.className;
						accessor.allBodyTemperatureType = res.data;
						callback(accessor.allBodyTemperatureType);
					}, error);
				}
			},
			rxAllergyTypeCode : function (callback, error){
				if(accessor.allRxAllergyTypeCode){
					callback(accessor.allRxAllergyTypeCode);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlist?className=ca.infodata.ofys.data.middle.dataobjects.encounter.XRxAllergyTypeCode&enumType=true", function(res){
						delete res.data.className;
						accessor.allRxAllergyTypeCode = res.data;
						callback(accessor.allRxAllergyTypeCode);
					}, error);
				}
			},
			routeOfAdmin : function (callback, error){
				if(accessor.allRouteOfAdmin){
					callback(accessor.allRouteOfAdmin);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlist?className=ca.infodata.ofys.data.middle.dataobjects.medication.XMyRouteOfAdministration&enumType=true", function(res){
						delete res.data.className;
						accessor.allRouteOfAdmin = res.data;
						callback(accessor.allRouteOfAdmin);
					}, error);
				}
			},
			siteOfAdmin : function (callback, error){
				if(accessor.allSiteOfAdmin){
					callback(accessor.allSiteOfAdmin);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlist?className=ca.infodata.ofys.data.middle.dataobjects.medication.XMyHumanSubstanceAdministrationSite&enumType=true", function(res){
						delete res.data.className;
						accessor.allSiteOfAdmin = res.data;
						callback(accessor.allSiteOfAdmin);
					}, error);
				}
			},
			drugFormat : function (callback, error){
				if(accessor.allDrugFormat){
					callback(accessor.allDrugFormat);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlist?className=ca.infodata.ofys.data.middle.dataobjects.medication.XMyOrderableDrugForm&enumType=true", function(res){
						delete res.data.className;
						accessor.allDrugFormat = res.data;
						callback(accessor.allDrugFormat);
					}, error);
				}
			},
			sumNotesObj: [
				'socialHistoryObj', 
				'familyHistoryObj', 
				'ongoingConcernsObj', 
				'medicalHistoryObj',
				'otherMedicationsObj'
			],
			convSumToArr: function(sum){
				//Format CSummary encounter note types into list object this should be reversed before save of CSummary
				accessor.sumNotesObj.forEach(function(i){
					if(sum[i]){
						sum[i + 'Arr'] = [sum[i]];
					}
				});
				return sum
			},
			sum : function (id, callback, error){
				return DashAPI.get("/dashboard/encs/ws/sum?idPt=" + id, function(res){
					accessor.convSumToArr(res.data);
					callback(res);
				}, error);
			},
			search : function (q, callback, error){
				return DashAPI.get("/dashboard/encs/ws/search?q="+ q, callback, error);
			},
			findFavRx : function (data, callback, error){
				if(accessor.allFavRx){
					if (callback) callback(accessor.allFavRx);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enc/favrx/get?idProf="+ data, function(res){
						if(!res){
							res = [];
						}
						function getName(x){
							if(x && x.name !== undefined){
								return x.name;
							}else{
								return "";
							}
						}
						accessor.allFavRx = res.sort(function(a,b) {
							var an = getName(a).toLowerCase();
							var bn = getName(b).toLowerCase();
							if (an < bn)
									return -1;
								if (an > bn)
									return 1;
								return 0;
						});
						if (callback) callback(accessor.allFavRx);
					}, error);
				}
			},
			addFavIdRx : function (data, callback, error){//data => {idProf: , idRx: }
				return DashAPI.get('/dashboard/encs/ws/addFavIdRx/get?idProf='+ data.idProf +'&idRx=' + data.idRx, function(res){
					if (callback) callback(res);
				}, error);
			},
			delFavIdRx : function (data, callback, error){	// data = idRx
				return DashAPI.get('/dashboard/encs/ws/delFavIdRx/get?idRx=' + data, callback, error);
			},
			addFavRx : function (data, idProf, callback, error){
				var type = data.baseDrugType==3 ? 'ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter.Device': 'ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter.Prescription';
				data.idProfessionnalAnchor = idProf;
				var sObj = JSON.stringify(data);
				return DashAPI.post('/dashboard/encs/ws/addFavRx/post', accessor.toUidObj(sObj, type), function(res){
					if (callback) callback(res);
				}, error);
			},
			searchDevices : function (data, callback, error){
				return DashAPI.get("/dashboard/encs/ws/searchDevices?q="+ b64EncodeUnicode(data.q), callback, error);
			},			
			searchDx : function (data, callback, error){
				return DashAPI.get("/dashboard/encs/ws/searchDx?q="+ b64EncodeUnicode(data.q)+'&code='+data.code, callback, error);
			},
			searchRxForce : function (q, n, callback, error){
				return DashAPI.get("/dashboard/encs/ws/searchRxForce?q="+b64EncodeUnicode(q)+"&n="+b64EncodeUnicode(n), callback, error);
			},
			findDxCodeByCode : function (data, callback, error){
				return DashAPI.get("/dashboard/encs/ws/findDxCodeByCode?class="+ data.class+'&code='+b64EncodeUnicode(data.code), callback, error);
			},
			aiGenEncSum : function (data, callback, error){
				// data data.idEncAnc, data.idPat, data.encInJsonString -- b64EncodeUnicode(data.encInJsonString)
				return DashAPI.post("/dashboard/encs/ws/aiGenEncSum",  accessor.toUidObj(data, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CencInJson'), callback, error);
			},
			searchAllergy : function (data, callback, error){
				return DashAPI.get("/dashboard/encs/ws/searchAllergy?q="+ b64EncodeUnicode(data.q)+"&types="+data.types, callback, error);
			},
			searchInactiveRx : function (id, callback, error){
				return DashAPI.get("/dashboard/encs/ws/searchInactiveRx?idPt=" + id +"&u=" + DashWebSocket.clientUid, callback);
			},
			open : function (id, callback, error){
				return DashAPI.get('/dashboard/encs/editor?encId='+ id, callback, error);
			},
			printBilling : function (data, callback, error){
				var sObj = JSON.stringify(data);
				return DashAPI.post('/dashboard/encs/ws/enc/printBilling/post', accessor.toUidObj(sObj, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter'), model.handlePrint(callback), error);
			},
			printRx : function (data, callback, error){
				var itemSaved = angular.copy(data);
				itemSaved.enc = cleanEncountertoSave(itemSaved.enc);
				var sObj = JSON.stringify(itemSaved);
				return DashAPI.post('/dashboard/encs/ws/enc/printrx/post', accessor.toUidObj(sObj, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter'), model.handlePrint(callback), error);
			},
			printRxAndForm : function (data, callback, error){
				var itemSaved = angular.copy(data);
				itemSaved.enc = cleanEncountertoSave(itemSaved.enc);
				var sObj = JSON.stringify(itemSaved);
				return DashAPI.post('/dashboard/encs/ws/enc/printdirectRxAndForms/post', accessor.toUidObj(sObj, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter'), model.handlePrint(callback), error);
			},
			printDirectEncounter : function (data, callback, error){
				var itemSaved = angular.copy(data);
				itemSaved.enc = cleanEncountertoSave(itemSaved.enc);
				var sObj = JSON.stringify(itemSaved);
				return DashAPI.post('/dashboard/encs/ws/enc/printdirect/post', accessor.toUidObj(sObj, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter'), model.handlePrint(callback), error);
			},
			printEncounter : function (data, callback, error){
				var itemSaved = cleanEncountertoSave(angular.copy(data));
				var sObj = JSON.stringify(itemSaved);
				return DashAPI.post('/dashboard/encs/ws/enc/print/post', accessor.toUidObj(sObj, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter'), callback, error);
			},
			printConsult : function (data, callback, error){
				return DashAPI.get("/dashboard/encs/ws/consult/print?id=" + data.idConsult, model.handlePrint(callback), error);
			},
			printSummary : function (data, callback, error){
				return DashAPI.get("/dashboard/encs/ws/sum/print?idPt=" + data.idPt, model.handlePrint(callback), error);
			},
			toUidObj:function(obj, type){
				return {'o': obj, 'u': DashWebSocket.clientUid, 't' : type};

			},
			savePlan : function (data, callback, error){
				var sObj = JSON.stringify(data);
				return DashAPI.post('/dashboard/encs/ws/plan/post', accessor.toUidObj(sObj, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CSummary.Plan'), callback, error);
			},
			saveImportance : function (data, callback, error){
				var sObj = JSON.stringify(data);
				return DashAPI.post('/dashboard/encs/ws/sum/importance/post', accessor.toUidObj(sObj, 'ca.infodata.ofys.ui.dashboard.controller.CImportance[]'), callback, error);
			},
			saveSummary : function (data, callback, error){
				console.log("Saving summary");
				var itemSaved = cleanEncountertoSave(angular.copy(data));
				var sObj = JSON.stringify(itemSaved);
				return DashAPI.post('/dashboard/encs/ws/sum/save/post', accessor.toUidObj(sObj, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CSummary'), callback, error);
			},
			saveSummaryImportDsq : function (data, callback, error){
				console.log("Saving summary import DSQ");
				var sObj = JSON.stringify(data);
				return DashAPI.post('/dashboard/encs/ws/sum/saveImpDsq/post', accessor.toUidObj(sObj, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CSummary'), callback, error);
			},
			preSaveEnc : function (data, callback, error){
				console.log("Pre-Saving encounter");
				var itemSaved = cleanEncountertoSave(angular.copy(data));
				var sObj = JSON.stringify(itemSaved);
				return DashAPI.post('/dashboard/encs/ws/enc/presave/post', accessor.toUidObj(sObj, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter'), callback, error, DashAPI.hideMsg());
			},
			saveEnc : function (data, callback, error){
				console.log("Saving encounter");
				var i;
				var itemSaved = angular.copy(data);
				if(itemSaved && itemSaved.encounter){
					if(itemSaved.encounter.lstDxEnc === undefined){
						itemSaved.encounter.lstDxEnc = [];
					}
					if(itemSaved.encounter.lstDx === undefined){
						itemSaved.encounter.lstDx = [];
					}

					if(itemSaved.encounter.lstDxEnc.length>0){
						// Add summary dx from lstDxEnc to lstDx
						for(i = 0; i < itemSaved.encounter.lstDxEnc.length; i++){
							if(itemSaved.encounter.lstDxEnc[i].addToSummary){
								var itemToAdd = _.omit(angular.copy(itemSaved.encounter.lstDxEnc[i]), ['id','version']);
								itemSaved.encounter.lstDxEnc[i].addToSummary = false;
								itemSaved.encounter.lstDx.push(itemToAdd);
							}
						}
					}

					if(itemSaved.encounter.lstDxEnc.length === 0){
						delete itemSaved.encounter.lstDxEnc;
					}
					if(itemSaved.encounter.lstDx.length === 0){
						delete itemSaved.encounter.lstDx;
					}
				}
				if(itemSaved && itemSaved.encounter.lstDoc){
					for(i = 0; i < itemSaved.encounter.lstDoc.length; i++){
						delete itemSaved.encounter.lstDoc[i].viewbag;
					}
				}
				itemSaved.encounter = cleanEncountertoSave(itemSaved.encounter);
				var sObj = OfysUtils.safeStringify(itemSaved);
				return DashAPI.post('/dashboard/encs/ws/enc/save/post', accessor.toUidObj(sObj, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter'), callback, error);
			},
			saveImportRxDsq : function (data, callback, error){
				console.log("saveImportRxDsq");
				var itemSaved = angular.copy(data);
				cleanEncountertoSave(itemSaved);
				var sObj = JSON.stringify(itemSaved);
				return DashAPI.post('/dashboard/encs/ws/rxdsq/post', accessor.toUidObj(sObj, 'ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter'), callback, error);
			},
			msgLinkMap:{},
			updateMessageLink: function (patient,scope, docId){
				accessor.messageLinkKey = MessageLink.setLinkType({
					patient: patient.id,
					linkType: MessageLink.linkTypes.patient,
					id: patient.id,
					pat: patient
				},scope);
				if(docId !== undefined){
					accessor.msgLinkMap[docId] = accessor.messageLinkKey
				}
			}
		}

		function cleanEncountertoSave(itemSaved) {
			// Since some errors still occurs in prod for viewbag Converting circular structure to JSON
			itemSaved = _.nested5LevelOmit(itemSaved, 'viewbag');
			if(itemSaved.save){
				delete itemSaved.save;
			}
			if(itemSaved.attachDocument){
				delete itemSaved.attachDocument;
			}
			if(itemSaved.patient && itemSaved.patient.currItem){
				delete itemSaved.patient.currItem;
			}
			return itemSaved;
		}

		function setupEnum(name, className){
			var alls = 'all'+name.charAt(0).toUpperCase() + name.slice(1);
			accessor[name] = function (callback, error){
				if(accessor[alls]){
					callback(accessor[alls]);
				}else{
					DashAPI.get("/dashboard/encs/ws/enumlist?className="+className, function(res){
						delete res.data.className;
						accessor[alls] = res.data;
						callback(accessor[alls]);
					}, error);
				}
			}
			accessor[name](angular.noop);
		}

		setupEnum('habitFrequencyTypes', "ca.infodata.ofys.data.middle.dataobjects.encounter.XLifeHabitFrequency");
		setupEnum('rappelResolvedStatus', "ca.infodata.ofys.data.middle.dataobjects.encounter.XRappelResolvedStatus");
		setupEnum('allergyProbability', "ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergyProbability");
		
		
		var mustResolveBeforeLoad = [
			accessor.noteTypes(null, angular.noop),
			accessor.encounterTypes(null, angular.noop),
			accessor.lifeHabitTypes(angular.noop),
			accessor.dxStatus(angular.noop),
			accessor.rxType(angular.noop),
			accessor.bodyTemperatureType(angular.noop),
			accessor.rxAllergyTypeCode(angular.noop), 
			accessor.routeOfAdmin(angular.noop),
			accessor.siteOfAdmin(angular.noop),
			accessor.drugFormat(angular.noop)
		];
		
		// doit attendre que le user soit loader avant de determiner si les favoris sont nécessaires.
		model.ready.then(function(){
			if (model.user().profil && model.user().profil.id) {
				mustResolveBeforeLoad.push(accessor.findFavRx(model.user().profil.id));			
			}
			accessor.ready = $q.all(mustResolveBeforeLoad);
		})
		// //setup encounter types.
		// accessor.noteTypes(null, angular.noop);
		// accessor.encounterTypes(null, angular.noop);
		// accessor.lifeHabitTypes(angular.noop);
		// // accessor.rappelResolvedStatus(angular.noop);
		// accessor.dxStatus(angular.noop);
		// accessor.rxType(angular.noop);
		// accessor.bodyTemperatureType(angular.noop);
		// accessor.rxAllergyTypeCode(angular.noop); 
		// accessor.routeOfAdmin(angular.noop);
		// accessor.siteOfAdmin(angular.noop);
		// accessor.drugFormat(angular.noop);
		// if (model.user().profil && model.user().profil.id) {
		// 	accessor.findFavRx(model.user().profil.id);			
		// }
		return accessor;
	}]);
	
	encounter.controller('EncounterController', ['$scope', 'model', 'EncounterAccessor','QValidation','$filter','DocAccessor','Notification',
	                                  function($scope, model, EncounterAccessor, QValidation, $filter, DocAccessor, Notification){
		$scope.searchResolved = false;
		$.extend($scope, EncounterAccessor.utils);
		
		$scope.updateEncList = function(){
			var inSearch = angular.isDefined(model.labo().q) && model.labo().q != "";
			
			var clear= function(clearList) {
				if(clearList == undefined){
					for(var list in model.labo().currList){
						model.labo().currList[list].visible = false;
					}
				}else if(model.labo().currList[clearList] != undefined) {
					model.labo().currList[clearList].visible = false;
				}
			};
			
			var listcb = function(response, group, order) {
				order = angular.isDefined(order)?order:0;
				model.labo().currList[group] = {
					list: response.data,
					order: order,
					showHeader: true,
					title: group+"_lab_list_title",
					visible: true,
				}
				$scope.searchResolved = inSearch;
			};
			
			if(inSearch){
				EncounterAccessor.search(model.labo().q, function(res){clear();listcb(res, EncounterAccessor.categories.SEARCH)});
			}else{
				clear(EncounterAccessor.categories.SEARCH);
				EncounterAccessor.review({id:model.user().profil.id, status: EncounterAccessor.categories.UNSEEN}, function(res){listcb(res, EncounterAccessor.categories.UNSEEN, 1)});
				EncounterAccessor.review({id:model.user().profil.id, status: EncounterAccessor.categories.TO_RESOLVE}, function(res){listcb(res, EncounterAccessor.categories.TO_RESOLVE, 2)});
			}
		};
		
		$scope.qvPatientOptions = {};
		
		$scope.getStatus = function(lab){
			return "TO_RESOLVE";
		};
		
		$scope.updateLaboList();
		
		var laboratoryHandlerId = Notification.registerHandler('laboResultsProfessionnalUpdate', function(notif){
			notif = EncounterAccessor.utils.getBaseLab(notif );
			var doc = $scope.findDocumentByIdInCurrentList(notif, model.labo().currList, Object.keys(model.labo().currList));
			if(doc !== null){
				//Replace existing document with new doc.
				model.labo().currList[doc.group].list[doc.index] = notif;
			}else{
				//Place document in the corresponding list
				if(DocAccessor.utils.isNotSeen(notif)){
					model.document().currList[DocAccessor.categories.UNSEEN].list.push(notif);
				}else if(DocAccessor.utils.isToResolve(notif)){
					model.document().currList[DocAccessor.categories.TO_RESOLVE].list.push(notif);
				}
			}
		}, $scope);
		
		$scope.selectLabo = function(lab){
			QValidation.closeContext($filter('translate')('documentUnsavedChanges')).then(function(successful){
				if(successful){
					//Flag labo as seen.
					if(DocAccessor.utils.isNotSeen(lab)){
						var i = $.inArray("UNSEEN", lab.status);
						if(i > -1){
							lab.status.splice(i, 1);
							model.document().docCountApi.updateCount(model.document().docCountApi.count() -1);
						}
					}
					model.labo().currLabo = lab;
				}
			});
		};
		$scope.isActive = function(lab){
			 return angular.isDefined(model.labo().currLabo) && model.labo().currLabo.id === lab.id;
		};
	}]);

	
	encounter.factory('EncounterSummaryCommon', ['EncounterAccessor','ModificationStatus','model','$filter','$timeout', 'encEnumList', 'rxvigilance',
	                            function(EncounterAccessor,ModificationStatus, model,$filter, $timeout, encEnumList, rxvigilance) {

		var partialDateOptions = {
			hasCalendar: false,
			acceptFutureDate: true
		};

		function getFavClass(item) {
			if(EncounterAccessor.allFavRx != undefined){
				return EncounterAccessor.allFavRx.filterFastFirst(function(e) {
						return e.hash == item.hash;}
					).length > 0 ? 'fa-star green2':'fa-star-o';
			}else{
				return 'fa-star-o';
			}
		}

		var accessor = {
			deviceFavActionBtn: {
				type:'btn',
				class:'',
				clickName: 'addDelFav',
				namei18n: 'addDelFav',
				title: 'addDelFav',
				classForItem: getFavClass,
				act: function(prescr){
					var c = EncounterAccessor.allFavRx.filterFastFirst(function(e) { 
						return e.hash == prescr.hash;
					});
					if (c.length>0) {	// on veut retirer le favori
						EncounterAccessor.delFavIdRx(c[0].id, function(){
							EncounterAccessor.allFavRx.splice(EncounterAccessor.allFavRx.indexOf(c[0]),1);
						});
					} else {
						if (prescr.id) {
							EncounterAccessor.addFavIdRx({idProf: model.user().profil.id, idRx: prescr.id},
									function(item){
								if (item && item.hash) {	// si pas de hash, signifie qu'a eu erreur
									EncounterAccessor.allFavRx.insertInOrder(item, 'name');
								}
							});
						} else {
							EncounterAccessor.addFavRx(prescr, model.user().profil.id, function(item){
								if (item && item.hash) {	// si pas de hash, signifie qu'a eu erreur
									EncounterAccessor.allFavRx.insertInOrder(item, 'name');
									prescr.hash = item.hash;	// pour que l'étoile indique que bien ajouté.
								}
							})
						}
					}
				}								
			},
			favActionBtn: {
				type:'btn',
				clickName: 'addDelFav',
				namei18n: 'addDelFav',
				title: 'addDelFav',
				classForItem: getFavClass,
				act: function(prescr){
					var c = EncounterAccessor.allFavRx.filterFastFirst(function(e) { 
						return e.hash == prescr.hash;
					});
					if (c.length>0) {	// on veut retirer le favori
						EncounterAccessor.delFavIdRx(c[0].id, function(){
							EncounterAccessor.allFavRx.splice(EncounterAccessor.allFavRx.indexOf(c[0]),1);
						});
					} else {
						if (prescr.id) {
							EncounterAccessor.addFavIdRx({idProf: model.user().profil.id, idRx: prescr.id},
									function(item){
								if (item && item.hash) {	// si pas de hash, signifie qu'a eu erreur
									EncounterAccessor.allFavRx.insertInOrder(item, 'name');
								}
							});
						} else {
							EncounterAccessor.addFavRx(prescr, model.user().profil.id, function(item){
								if (item && item.hash) {	// si pas de hash, signifie qu'a eu erreur
									EncounterAccessor.allFavRx.insertInOrder(item, 'name');
									prescr.hash = item.hash;	// pour que l'étoile indique que bien ajouté.
								}
							})
						}
					}
				},
			},
			nowDateTime: function (){
				return moment().format("YYYY-MM-DD HH:mm");
			},
			nowDateOnly: function(){
				return moment().format("YYYY-MM-DD");
			},
			clearDevice: function(item){
				var fields = ["id", "idAnchor", "idDevice", "version", "idNextModificationEntry", "idProfessionnalAnchor",
				"entryDate", "note", "name", "quantity", "posology", "rx", "startDate", "stopDate", "endDate", "stopReason",
				"dsqIt1", "dsqIt2", "dsqIt3", "dsqIt4", "dsqIt5", "fromProfExterne", "treatmentDuration",
				"toReprescribe", "idPrevPrescription", "idEncounter","idStopEncounter", "deleted", "dsqStatus", "encLabelInt" ]
				for (let i = 0; i < fields.length; i++) {
					delete item[fields[i]];
				}
			},
			deviceOnEdit: function(item){
				function favToDev(fav){
					var dev = _.omit(angular.copy(fav), ['id','version']);
					return dev;
				}

				item.viewbag.name = function(val) {
					if (arguments.length) {
						if (item.viewbag.item.name!=val) {
							// this makes sure that a new version is created for the 
							if (item.viewbag.item.idDevice) delete item.viewbag.item.idDevice;

							//Same as prescription?? Not sure if it's necessary
							if (item.viewbag.item.din) delete item.viewbag.item.din;
							if (item.viewbag.item.idStrength) delete item.viewbag.item.idStrength;							
						}
						item.viewbag.item.name = val;
					} else {
						return item.viewbag.item.name;
					}
				};
				
				item.viewbag.txDur = function(val) {
					if (arguments.length) {
						item.viewbag.item.treatmentDuration = val;
						item.viewbag.item.quantity = 0;
					} else {
						return item.viewbag.item.treatmentDuration;
					}
				};
				item.viewbag.txQty = function(val) {
					if (arguments.length) {
						item.viewbag.item.treatmentDuration = 0;
						item.viewbag.item.quantity = val;
					} else {
						return item.viewbag.item.quantity;
					}
				};
				item.viewbag.selectDevice = function(device) {
					item.viewbag.item.idDevice = device.k;
					item.viewbag.item.name = device.v;
				};
				item.viewbag.selectFav = function(fav, opt){
					if(opt.inEncounter || opt.inSummary && !item.id){
						//console.log(item);;
						accessor.clearDevice(item.viewbag.item);// Have to use a clear cause changing the object causes model corruption
						item.viewbag.isNew = false;
						item.viewbag.item = $.extend(item.viewbag.item, accessor.deviceDefaultItem(), favToDev(fav));
						if (item.viewbag.item.quantity && item.viewbag.item.quantity>0) {
							delete item.viewbag.item.treatmentDuration;
						} else if (item.viewbag.item.treatmentDuration && item.viewbag.item.treatmentDuration>0) {
							delete item.viewbag.item.quantity;
						}
						item.viewbag.item.expiredStatus = 0;
					}
				};
				
				item.viewbag.startDateOptions = angular.copy(partialDateOptions);
				item.viewbag.endDateOptions = angular.copy(partialDateOptions);
				var size = 1;
				for(var i = 1; i < 6; i++){//Max of 5 items
					if(item.viewbag.item["dsqIt"+i]){
						size = i;
					}
				}
				if(size < 5 && item.viewbag.item["dsqIt"+size]){
					size += 1;
				}
				if(!item.viewbag.item.therapyIntentions){
					item.viewbag.item.therapyIntentions = [];
				}
				for(var i = item.viewbag.item.therapyIntentions.length; i < size; i++){//Max of 5 items
					item.viewbag.item.therapyIntentions.push({note: item.viewbag.item["dsqIt"+(i+1)]});
				}
				item.viewbag.updateTherapy = function(item){
					if(item.viewbag.item.therapyIntentions && 
						item.viewbag.item.therapyIntentions.length < 5 && //Max of 5 items
						item.viewbag.item.therapyIntentions.length > 0 && 
						item.viewbag.item.therapyIntentions[item.viewbag.item.therapyIntentions.length-1].note){
						item.viewbag.item.therapyIntentions.push({note:""});
					}

					for(var i = 0; i < item.viewbag.item.therapyIntentions.length; i++){
						item.viewbag.item["dsqIt"+(i+1)] = item.viewbag.item.therapyIntentions[i].note;
					}
				};
				var inSummary = this.def && this.def.inSummary;
				
				item.viewbag.isFav = function(item) {
					if(EncounterAccessor.allFavRx){
						var c = EncounterAccessor.allFavRx.filterFastFirst(function(e) { 
							return e.hash == item.hash;
						});
						return c.length > 0;
					}
					return false;
				};
				item.viewbag.onChangeEditState = function(item, def){
					if(item.viewbag.rxFocus && !item.name){
						item.viewbag.rxFocus()
					}
				};
				
			},
			clearPrescription: function(item){
				var fields = ["id", "idAnchor", "idStrength", "version", "idNextModificationEntry", "idProfessionnalAnchor",
				"entryDate", "note", "name", "baseDrugName", "baseDrugType", "quantity", "strength", "route",
				"format", "site", "frequency", "posology", "rx", "startDate", "stopDate", "endDate", "stopReason",
				"dsqIt1", "dsqIt2", "dsqIt3", "dsqIt4", "dsqIt5", "fromProfExterne", "treatmentDuration",
				"toReprescribe", "idPrevPrescription", "din", "dosageChange", "idEncounter","idStopEncounter", "severity","allergy", "deleted", "dsqStatus", "encLabelInt" ];
				for (let i = 0; i < fields.length; i++) {
					delete item[fields[i]];
				}
			},
			prescriptionOnEdit: function(item, def){
				function favToRx(fav){
					var rx = _.omit(angular.copy(fav), ['id','version']);
					return rx;
				}
				item.viewbag.renalDosing = function(item, def){
					renalDosing(def, item);
				};
				item.viewbag.openMedException = function(item, def){
					var data = {url: "https://www.ramq.gouv.qc.ca/SiteCollectionDocuments/professionnels/formulaires/3633.pdf"};
					exceptionData(	data, def, item);
				};
				item.viewbag.openPatientException = function(item, def){
					var data = {url: "https://www.ramq.gouv.qc.ca/SiteCollectionDocuments/professionnels/formulaires/3996.pdf"};
					exceptionData(data, def, item);
				};

				item.viewbag.removeCode = function(viewbag){
					delete viewbag.searchDrugCode;
					delete viewbag.item.drugrefId;
					delete viewbag.item.drugrefDesc;
					delete viewbag.item.drugrefDescType;
					delete viewbag.item.baseDrugName;
					delete viewbag.item.name;
					delete viewbag.item.strength;
					delete viewbag.item.formatString;
					if (viewbag.item.din) delete viewbag.item.din;
					if (viewbag.item.idStrength) delete viewbag.item.idStrength;
				};
				item.viewbag.showRxvMonographie = function(item){
					rxvigilance.openRxViglanceService(rxvigilance.openMonograph, item);
				};
				function renalDosing(def, item){
					delete item.renal_dosing_html;
					if(def.inSummary === true){
						return;
					}
					var data = {};
					if (def.patient.viewbag.patData.sum.lastMesure && def.patient.viewbag.patData.sum.lastMesure.weight) {
						data.weight = def.patient.viewbag.patData.sum.lastMesure.weight;
					}
					data.sex = def.patient.gender;
					data.din = item.din;
					data.rxName = item.baseDrugName;
					data.isBlack = def.patient.race==2;
					data.age = ((def.patient.oAge !== undefined) && def.patient.oAge.years) ? def.patient.oAge.years : def.patient.age;
					data.creatinine = def.patient.viewbag.creatinine;
					EncounterAccessor.renalDosing(data, function(res) {
						if (res && OfysUtils.isNotEmpty(res.data)) {
							item.renal_dosing_html = res.data;					
						}
					});
				}
				
				function allergyAnalysis(def, item){
					delete item.allergyAnalysis;
					if(def.inSummary === true){
						return;
					}
					if (def.patient && def.patient.viewbag) {
						var lstD = def.patient.viewbag.patData.sum.lstDx;
						var lstP = def.patient.viewbag.patData.sum.lstProb;
						var lstDx = _.union(lstD, lstP);
						var lstAll = def.patient.viewbag.patData.sum.lstAllergy;
						var lstInt = def.patient.viewbag.patData.sum.lstIntolerance;
						var lstRx = def.patient.viewbag.patData.sum.lstPrescription;
						var data = {
								prescription: item,
								lstDx: lstDx,
								lstPrescription: lstRx,
								lstAllergies: lstAll,
								lstIntolerances: lstInt
						};
						EncounterAccessor.analyseAllergies(data, function(data) {
							if(data && data.data && data.data.lstAllergies){
								data.data.lstAllergies.forEach(function(e){
									if(e.severity !== undefined){
										e.severityStr = encEnumList.allergyServerity[e.severity];
									}
								})
								data.data.lstAllergiesNotFound.forEach(function(e){
									if(e.severity !== undefined){
										e.severityStr = encEnumList.allergyServerity[e.severity];
									}
								})
							}
							item.allergyAnalysis = data.data
						});
					}					
				}

				function analyseRxVigilance(def, item) {
					if(def.inSummary === true){
						return;
					}
					if (def.patient && def.patient.viewbag && rxvigilance.isActive()) {
						var items = [item];
						// l'analyse dans une recontre est différente de l'analyse auto quand on selectionne un pt
						if (item.analyseInEncRxv===undefined) item.analyseInEncRxv = {};
						item.analyseInEncRxv.isWorking = true;
						rxvigilance.openRxViglanceService(rxvigilance.engineQueryJson, def.patient, items, item.analyseInEncRxv);
					}
				}
				
				function exceptionData(data, def, item){
					data.data = {};
					data.data.pt = angular.copy(_.omit(def, 'viewbag'));
					data.data.rx = item;
//					data.site = model.get
					EncounterAccessor.prescriptionexceptionpdf(data);
					return data;
				}
				
				item.viewbag.txDur = function(val) {
					if (arguments.length) {
						item.viewbag.item.treatmentDuration = val;
						item.viewbag.item.quantity = 0;
					} else {
						return item.viewbag.item.treatmentDuration;
					}
				};
				item.viewbag.txQty = function(val) {
					if (arguments.length) {
						item.viewbag.item.treatmentDuration = 0;
						item.viewbag.item.quantity = val;
					} else {
						return item.viewbag.item.quantity;
					}
				};				
				
				item.viewbag.startDateOptions = angular.copy(partialDateOptions);
				item.viewbag.endDateOptions = angular.copy(partialDateOptions);
				item.viewbag.selectFav = function(fav, opt){
					if(opt.inEncounter || opt.inSummary && !item.id){
						//console.log(item);
						accessor.clearPrescription(item.viewbag.item);// Have to use a clear cause changing the object causes model corruption
						item.viewbag.isNew = false;
						item.viewbag.item = $.extend(item.viewbag.item, accessor.prescriptionDefaultItem(), favToRx(fav));
						if (item.viewbag.item.quantity && item.viewbag.item.quantity>0) {
							delete item.viewbag.item.treatmentDuration;
						} else if (item.viewbag.item.treatmentDuration && item.viewbag.item.treatmentDuration>0) {
							delete item.viewbag.item.quantity;
						}
						item.viewbag.item.expiredStatus = 0;
						allergyAnalysis(def, item.viewbag.item);
						renalDosing(def, item.viewbag.item);
						analyseRxVigilance(def, item.viewbag.item);
					}
				};
				var size = 1;
				for(var i = 1; i < 6; i++){//Max of 5 items
					if(item.viewbag.item["dsqIt"+i]){
						size = i;
					}
				}
				if(size < 5 && item.viewbag.item["dsqIt"+size]){
					size += 1;
				}
				if(!item.viewbag.item.therapyIntentions){
					item.viewbag.item.therapyIntentions = [];
				}
				for(var i = item.viewbag.item.therapyIntentions.length; i < size; i++){//Max of 5 items
					item.viewbag.item.therapyIntentions.push({note: item.viewbag.item["dsqIt"+(i+1)]});
					// if(item.viewbag.item["dsqIt"+(i+1)]){
					// 	size = i;
					// }
				}
				item.viewbag.isFav = function(item) {
					if(EncounterAccessor.allFavRx){
						var c = EncounterAccessor.allFavRx.filterFastFirst(function(e) { 
							return e.hash == item.hash;
						});
						return c.length > 0;
					}
					return false;
				};

				item.viewbag.stopMed = function(item){
					item.stopDateSD = this.reason.stopDate;
					item.stopReason = this.reason.reason;
					item.allergy = this.reason.allergy;
					item.severity = this.reason.severity;
					item.modificationStatus = ModificationStatus.STATUS_UPDATED;
					scope.formOptions.setFormStatus('dirty');
				};
				item.viewbag.updateTherapy = function(item){
					if(item.viewbag.item.therapyIntentions && 
						item.viewbag.item.therapyIntentions.length < 5 && //Max of 5 items
						item.viewbag.item.therapyIntentions.length > 0 && 
						item.viewbag.item.therapyIntentions[item.viewbag.item.therapyIntentions.length-1].note){
						item.viewbag.item.therapyIntentions.push({note:""});
					}

					for(var i = 0; i < item.viewbag.item.therapyIntentions.length; i++){
						item.viewbag.item["dsqIt"+(i+1)] = item.viewbag.item.therapyIntentions[i].note;
					}
				};
				item.viewbag.setDrug = function(rx, fctAllergy){
					if (item.viewbag.item.idStrength) delete item.viewbag.item.idStrength;
					if (item.viewbag.item.hash) delete item.viewbag.item.hash;
					EncounterAccessor.selectDrug({id: rx.id, current: item.viewbag.item}, function(res){
						$.extend(item.viewbag.item, res.data);
						if(item.viewbag.posologyUpdate){
							item.viewbag.posologyUpdate(item.viewbag.item.lstRxData);
						}
						if (item.viewbag.posFocus) item.viewbag.posFocus();
						allergyAnalysis(def, item.viewbag.item);
						renalDosing(def, item.viewbag.item);
						analyseRxVigilance(def, item.viewbag.item);
					});
				};
				var inSummary = def && def.inSummary;
				item.viewbag.searRxOptions = {
					setException : function(code){
						item.viewbag.item.note = code.code
					},
					inSummary: inSummary,
					inEncounter: !inSummary
				};
				item.viewbag.selectForce = function(s){
					item.viewbag.strength(s.Teneur);
					// if (item.viewbag.item.din===undefined) 
					item.viewbag.item.din = s.regional_identifier;
//					item.viewbag.item.baseDrugName = s.name;	// baseDrugName devrait être le même...
					if (s.product!=item.viewbag.item.name) {
						if (s.name!=item.viewbag.item.name) {
							if (s.othername!=item.viewbag.item.name) {
								item.viewbag.item.name = s.product;
							}
						}
					}
					if (s.othername!=item.viewbag.item.baseDrugName) {
						if (s.name!=item.viewbag.item.baseDrugName) {
					item.viewbag.item.baseDrugName = s.othername;
						}
					}
//					item.viewbag.item.name = s.product; // todo kedep same name si possi bl						
//					item.viewbag.item.baseDrugName = s.othername;
//					item.viewbag.item.name = s.name;
				};
				item.viewbag.strength = function(val) {
					if (arguments.length) {
						if (item.viewbag.item.strength!=val) {
							//console.log('val different - delete din and idStrength: '+val);
							if (item.viewbag.item.din) delete item.viewbag.item.din;
							if (item.viewbag.item.idStrength) delete item.viewbag.item.idStrength;							
						}
						item.viewbag.item.strength = val;
					} else {
						return item.viewbag.item.strength;
					}
				};

				item.viewbag.name = function(val) {
					if (arguments.length) {
						if (item.viewbag.item.name!=val) {
							if (item.viewbag.item.din) delete item.viewbag.item.din;
							if (item.viewbag.item.idStrength) delete item.viewbag.item.idStrength;							
						}
						item.viewbag.item.name = val;
					} else {
						return item.viewbag.item.name;
					}
				};
				item.viewbag.setRoute = function(route){
					item.viewbag.item.route = route.key*1;
//					console.log("Route set to next "+ item.viewbag.item.route);
				};
				item.viewbag.firstChangeRoute = function(){
					if(item.viewbag.item.route !== undefined){
						item.viewbag.item.route = undefined;
					}
					//console.log("format set to next "+ item.viewbag.item.format);
				};
				item.viewbag.validRoute = function(){
					return item.viewbag.item.route !== undefined ? true : false;
				}
				item.viewbag.setSite = function(site){
					item.viewbag.item.site = site.key*1;
					//console.log("Site set to next "+ item.viewbag.item.site);
				};
				item.viewbag.setDrugFormat = function(f){
					item.viewbag.item.format = f.key*1;
					//console.log("format set to next "+ item.viewbag.item.format);
				};
				item.viewbag.firstChangeFormat = function(){
					if(item.viewbag.item.format !== undefined){
						item.viewbag.item.format = undefined;
					}
					//console.log("format set to next "+ item.viewbag.item.format);
				};
				item.viewbag.validFormat = function(){
					return item.viewbag.item.format !== undefined ? true : false;
				}
				item.viewbag.selectPos = function(pos){
					item.viewbag.item.posology = pos.pos;
					item.viewbag.item.quantity = pos.qte === undefined ? 0 : pos.qte;
					item.viewbag.item.frequency = pos.freq;
					item.viewbag.item.treatmentDuration = pos.jrs === undefined ? 0 : pos.jrs;
					item.viewbag.item.rx = pos.rep===undefined ? 0 : pos.rep;
				};

				item.viewbag.onChangeEditState = function(item, def){
					if(item.viewbag.rxFocus && !item.name){
						item.viewbag.rxFocus()
					}
				};
				// $timeout(
				// 	function(){
				// 		if(item.viewbag.rxFocus){
				// 			item.viewbag.rxFocus();
				// 		}
				// 	}
				// ,100);
			},
		};
	
		accessor.prescriptionDefaultItem = function(){
			return {
			startDateSD: accessor.nowDateOnly(),
			toReprescribeB:true,
			baseDrugType: 0,
//			treatmentDuration: 0,
			format: 166,
			formatString: EncounterAccessor.allDrugFormat["166"][1],
			site: 0,
			siteString: EncounterAccessor.allSiteOfAdmin["0"],
			route: 193000,
			routeString: EncounterAccessor.allRouteOfAdmin["193000"],
			allergy: 0,
			rx: model.prefSettings('med_rx_defaut'),
			posology: '1',
			severity: 0,
			dosageChange: 0,
			dsqStatusStr:'',
			therapyIntentions: [{note:""}],
			dosageChangeString: "NO_INFO"
			};
		};

		accessor.deviceDefaultItem = function(){
			return {
				startDateSD: accessor.nowDateOnly(),
				toReprescribeB:true,
				baseDrugType: 3,
	//			treatmentDuration: 0,
				allergy: 0,
				rx: 11,
				posology: $filter("translate")('USAGE'),
				severity: 0,
				dosageChange: 0,
				dsqStatusStr:'',
				therapyIntentions: [{note:""}],
				dosageChangeString: "NO_INFO",
				descr:[]
			};
		};
		
		function parsedName(fav, medicationName, medicationDescription) {
			var parsedName = {commercial:"",generic:"",strength:"",format:""};
			var text = medicationName;
			//parse medication.name in this format: generic strength format
			if (text && text.trim()!='') {
				//parse commercial name, stop on first word matching strength pattern
				var nameParts = text.split(' ');
				var ii = 0;
				for (; ii < nameParts.length; ii++) {
					var s = nameParts[ii];
					if (s.length===0) {
						break;
					}
					if (s.substring(0, 1).match(/\d/)) {
						break;
					}
					parsedName.commercial += " " + s.trim();
				}
				parsedName.commercial = parsedName.commercial.trim();
				
				//parse format and strength
				for (; ii < nameParts.length; ii++) {
					var s = nameParts[ii];
					if (s.length===0) {
						break;
					}
					if (s.substring(0, 1).match(/\d/)) {
						parsedName.strength = s.trim();
					} else {
						parsedName.format += " " + s.trim();
					}
				}
				parsedName.format = parsedName.format.trim();
			}
			
			text = medicationDescription;
			//parse medication.description in this format: generic strength format
			if (text && text.trim()!='') {
				//parse generic name, stop on first word matching strength pattern
				var nameParts = text.split(' ');
				var ii = 0;
				for (; ii < nameParts.length; ii++) {
					var s = nameParts[ii];
					if (s.length===0) {
						break;
					}
					if (s.substring(0, 1).match(/\d/)) {
						break;
					}
					parsedName.generic += " " + s;
				}
				parsedName.generic = parsedName.generic.trim();
				
				if (parsedName.format==='') {
					//parse format and strenth second try from medication.prescription
					if (parsedName.format && parsedName.format!='') {
						for (; ii < nameParts.length; ii++) {
							var s = nameParts[ii];
							if (s.length===0) {
								break;
							}
							if (s.substring(0, 1).match(/\d/)) {
								parsedName.strength = s;
							} else {
								parsedName.format += " " + s;
							}
						}
						parsedName.format = parsedName.format.trim();
					}
				}
			} else {
				//generic name is parsed from medication.description, if that field is blank, set to commercial name
				parsedName.generic = parsedName.commercial;
			}
			fav.name = parsedName.commercial;
			fav.baseDrugName = parsedName.generic;
			fav.strength = parsedName.strength;
			return parsedName;
		}
		
		function parsedMedicationFromRxSum(fav, rx) {
			var medicationName;
			var medicationDescription;
//			ex rx.medication.name;	// ex "LEVOTHYROXINE 25MCG COMPRIME"
//			ex rx.medication.code.text;	// ex. "SYNTHROID 25MCG COMPRIME"
			if (rx.medication) {
				medicationName = rx.medication.code.text;
				medicationDescription = rx.medication.name;
			}
			if (medicationDescription==undefined) {
				 medicationDescription = medicationName;
			}
			if (medicationName==undefined) {
				medicationName = medicationDescription;
			}
			return parsedName(fav, medicationName, medicationDescription);
			
		}
		function parsedMedicationFromDevSum(fav, d) {
			var medicationName;
			var medicationDescription;
			//if d is a magistral of 1 ingredient, use ingredient medication instead
			if (d.device) {
				if (d.device.code && d.device.code.text) {
					medicationName = d.device.code.text;
				} else {
					medicationName = d.device.name;
				}
				medicationDescription = d.device.desc;		
				if (medicationDescription==undefined) {
					medicationDescription = medicationName;
				}
			}
			return parsedName(fav, medicationName, medicationDescription);			
		}
		function parsedMedicationFromDisp(fav, d) {
			var medicationName;
			var medicationDescription;
			//if d is a magistral of 1 ingredient, use ingredient medication instead
			if (d.drugCode) {
				medicationName = d.drugCode.text;
			}
			if (d.drugName) {
				medicationDescription = d.drugName;						
			} else {
				medicationDescription = medicationName;						
			}
			if (medicationName==undefined) medicationName=medicationDescription;
			return parsedName(fav, medicationName, medicationDescription);
		}
		function parsedMedicationFromOther(fav, d) {
			var medicationName;
			var medicationDescription;
			//if d is a magistral of 1 ingredient, use ingredient medication instead
			if (d.consumable) {
				if (d.consumable.code) {
					medicationName = d.consumable.code.text;
				}
				medicationDescription = d.consumable.name;		
				if (medicationName==undefined) {
					medicationName = medicationDescription;
				}
			}
			return parsedName(fav, medicationName, medicationDescription);
		}
		function warn(name) {
			var opt = {n: name};
			model.notice().warn($filter('translate')('ERROR_IMPORT_DSQ', opt));			
		}
//		function parsePosologie(fav, p) {
//			console.long("posologie=" + p);
//		}				
//		function parsePosologieFromDisp(fav, p) {
//			return parsePosologie(fav, p);
//		}
//		function parsePosologieFromRxSum(fav, p) {
//			return parsePosologie(fav, p);
//		}
		var lstDrugFormat;
		var lstRoutesOfAmin;
		function setFormCodeFromText(fav, code, text) {
			if (lstDrugFormat==undefined) {
				lstDrugFormat = [];
				var ks = Object.keys(EncounterAccessor.allDrugFormat);
				for (let i = 0; i < ks.length; i++) {
					const k = ks[i];
					lstDrugFormat.push({key: k, n: EncounterAccessor.allDrugFormat[k][0], val: EncounterAccessor.allDrugFormat[k][1], vallc: EncounterAccessor.allDrugFormat[k][1].toLowerCase().removeAccentsLc()});
				}
			}
			var drugFormat;
			var format1;
			if (code) {
				format1 = lstDrugFormat.filter(function(e) {return e.n==code;});
				if (format1.length===1) {
					fav.format = format1[0].key;
					fav.formatString = format1[0].val;
					return;
				}
			}
			var ltext = text.toLowerCase().removeAccentsLc();
			format1 = lstDrugFormat.filter(function(e) {return e.vallc.indexOf(ltext)>-1;});
			if (format1.length===1) {
				fav.format = format1[0].key;
				fav.formatString = format1[0].val;
			} else if (format1.length>1) {
				var format2 = format1.filter(function(e) {return e.vallc==ltext;});
				if (format2.length>0) {
					fav.format = format2[0].key;
					fav.formatString = format2[0].val;
				} else {
					fav.format = format1[0].key;
					fav.formatString = format1[0].val;								
				}
			}
		}
		
		function setRouteFromText(fav, text) {
			if (lstRoutesOfAmin==undefined) {
				lstRoutesOfAmin = [];
				var ks = Object.keys(EncounterAccessor.allRouteOfAdmin);
				for (let i = 0; i < ks.length; i++) {
					const k = ks[i];
					lstRoutesOfAmin.push({key: k, val: EncounterAccessor.allRouteOfAdmin[k], vallc: EncounterAccessor.allRouteOfAdmin[k].toLowerCase().removeAccentsLc()});
				}
			}
			var route;
			var ltext = text.toLowerCase().removeAccentsLc();
			var format1 = lstRoutesOfAmin.filter(function(e) {return e.vallc.indexOf(ltext)>-1;});
			if (format1.length===1) {
				fav.route = format1[0].key;
				fav.routeString = format1[0].val;
			} else if (format1.length>1) {
				var format2 = format1.filter(function(e) {return e.vallc==ltext;});
				if (format2.length>0) {
					fav.route = format2[0].key;
					fav.routeString = format2[0].val;
				} else {
					fav.route = format1[0].key;
					fav.routeString = format1[0].val;								
				}
			}
		}
		
		function setPosologieAndNote(fav, di) {
			if (di && di.length>0) {
				var poso;
				var note;
				var dil = di.toLowerCase().removeAccentsLc();
				var format = fav.formatString ? fav.formatString.toLowerCase().removeAccentsLc() : '';
				if (dil.indexOf('appl')===0) {
					setRouteFromText(fav, 'topique');
				} else if (dil.indexOf('langu')!=-1 || dil.indexOf('1tongu')!=-1) {
					setRouteFromText(fav, 'sublingual');					
				} else if (dil.indexOf('pre')===0 || dil.indexOf('donne')===0 || dil.indexOf('take')===0 || format.indexOf('comprim')!=-1 || format.indexOf('capsul')!=-1 || format.indexOf('tablet')!=-1 || format.indexOf('pill')!=-1) {
					setRouteFromText(fav, 'per OS');
				} else if (dil.indexOf('instil')===0) {
					setRouteFromText(fav, 'topique');
				} else if (dil.indexOf('inhalat')!=-1) {
					setRouteFromText(fav, 'inhalation, respiratoire');						
				}
				
				var extraRx = [];
				if (dil.indexOf(' id')!=-1 || dil.indexOf(' die')!=-1 || 
						(dil.indexOf(' 1 foi')!=-1 && dil.indexOf('jour')!=-1) || 
						(dil.indexOf(' 1 time')!=-1 && (dil.indexOf('day')!=-1 || dil.indexOf('daily')!=-1)) || 
						(dil.indexOf(' once')!=-1 && (dil.indexOf('day')!=-1 || dil.indexOf('daily')!=-1))
				){
					extraRx.push('ID');
				} else if (dil.indexOf('bid')!=-1 || 
						(dil.indexOf('2 fois')!=-1 && dil.indexOf('jour')!=-1) || 
						(dil.indexOf('2 times')!=-1 && (dil.indexOf('day')!=-1 || dil.indexOf('daily')!=-1)) || 
						(dil.indexOf('twice')!=-1 && (dil.indexOf('day')!=-1 || dil.indexOf('daily')!=-1))
						){
					extraRx.push('BID');
				} else if (dil.indexOf(' tid')!=-1 || 
						(dil.indexOf(' 3 foi')!=-1 && dil.indexOf('jour')!=-1) || 
						(dil.indexOf(' 3 times')!=-1 && (dil.indexOf('day')!=-1 || dil.indexOf('daily')!=-1)) ||
						(dil.indexOf(' thrice')!=-1 && (dil.indexOf('day')!=-1 || dil.indexOf('daily')!=-1))
				){
					extraRx.push('TID');
				} else if (dil.indexOf(' qid')!=-1 || 
						(dil.indexOf(' 4 foi')!=-1 && dil.indexOf('jour')!=-1) || 
						(dil.indexOf(' 4 times')!=-1 && (dil.indexOf('day')!=-1 || dil.indexOf('daily')!=-1))
				){
					extraRx.push('QID');
				} else if (dil.indexOf(' 4 heure')!=-1 || dil.indexOf(' 4 hour')!=-1) {
					extraRx.push('Q4H');
				} else if (dil.indexOf(' 6 heure')!=-1 || dil.indexOf(' 6 hour')!=-1) {
					extraRx.push('Q6H');
				} else if (dil.indexOf(' 8 heure')!=-1 || dil.indexOf(' 8 hour')!=-1) {
					extraRx.push('Q8H');
				} else if (dil.indexOf('12 heure')!=-1 || dil.indexOf('12 hour')!=-1) {
					extraRx.push('Q12H');
				} else if (dil.indexOf('24 heure')!=-1 || dil.indexOf('24 hour')!=-1) {
					extraRx.push('Q24H');
				} else if (dil.indexOf('semaine')!=-1) {
					extraRx.push('Q1SEM');
				} else if (dil.indexOf('week')!=-1) {
					extraRx.push('Q1WEEK');
				}
				if (dil.indexOf('coucher')!=-1 || dil.indexOf('bedtime')!=-1) {
					extraRx.push('HS');
				}
				if (dil.indexOf('prn')!=-1 || dil.indexOf('besoin')!=-1 || dil.indexOf('needed')!=-1) {
					extraRx.push('PRN');
				}
				if (extraRx.length>0) {
					fav.frequency = extraRx.join(' ');					
				}
				
				di = di.replace(/^(apply)|(appliquer)|(appliquez)|(take)|(prendre)|(prenez)|(donner)|(donnez)/ig, "").trim();
				var firstPar = di.indexOf("(");
				var firstAst = di.indexOf("*");
				if (firstAst < firstPar && firstAst>20) {
					poso = di.substring(0, firstAst).trim();
					note = di.substring(firstAst).replace(/\(|\)/g, "").trim();							
				} else if (firstPar>20) {
					poso = di.substring(0, firstPar).trim();
					note = di.substring(firstPar).replace(/\(|\)/g, "").trim();
				} else {
					poso = di;
				}
								
				if (poso.length>100) {
					var firstVirg = poso.indexOf(',');
					if (firstVirg>20 && firstVirg<100) {
						note = poso.substring(firstVirg+1);
						poso = poso.substring(0, firstVirg).trim();
					}
				}
				if (poso.length>100) {
					var posoText = OfysUtils.wordWrap(poso, 80);
					var posos = posoText.split('\n');
					poso = posos[0];
					var idx = 1;
					note = '';
					for(; idx < posos.length; idx++){
						note = (note.length>0 ? note + " ":"") + note[idx];
					}
				}
				fav.posology = poso;
				if (note && note.trim().length>0) {
					fav.note = fav.note && fav.note.length>0 ? fav.note + "\n"+note : note;					
				}
			} else {
				fav.posology = "-";
			}
		}
		
		function otherMedicationSummaryToCFavPrescription(rx) {
			var fav = {};
			$.extend(fav, accessor.prescriptionDefaultItem());
			delete fav.route;delete fav.routeString;
			delete fav.format;delete fav.formatString;
			fav.dsqStatus = 1; fav.dsqStatusStr='[I.dsq] '  // i.dsq
			var parseMedicationName = parsedMedicationFromOther(fav, rx);
			if (fav.strength==undefined || fav.strength.trim()=="") {
				fav.strength = '-';
			}
			if (rx.consumable && rx.consumable.code) {
				if (rx.consumable.code.code && rx.consumable.code.code.length > 0) {
					fav.din = rx.consumable.code.code*1;
				}
				if (rx.consumable.formCode.text){
					setFormCodeFromText(fav, rx.consumable.formCode.code, rx.consumable.formCode.text);
				} else if (parseMedicationName.format && parseMedicationName.format!='') {
					setFormCodeFromText(fav, undefined, parseMedicationName.format);				
				}
			}
			if (fav.format==undefined) {
				if (fav.strength.toLowerCase().indexOf('ml')!=-1) {
					// SUSP(new Integer(223),"suspension","","suspension" ,""),
					fav.format = 223; fav.formatString="suspension";
				} else {
					fav.format = 100; fav.formatString = "Voir détails";
				}
			}
			fav.quantity = 1;
			if (fav.frequency == undefined) {
				fav.frequency = "-";
			}
			fav.site = 0;
			fav.siteString = "S/O";
			fav.rx = model.prefSettings('med_rx_defaut');
			fav.posology = '-';			
			if (fav.route==undefined) {
				fav.route = 0;
				fav.routeString = 'Voir détails';
			}
			fav.note = fav.note && fav.note.length>0 ? fav.note+"\nImport DSQ" : "Import DSQ";
			return fav;
		}
		
		function dispenseSummaryToCFavPrescription(rx) {
			var fav = {};
			$.extend(fav, accessor.prescriptionDefaultItem());
			delete fav.route;delete fav.routeString;
			delete fav.format;delete fav.formatString;
			fav.dsqStatus = 1; fav.dsqStatusStr='[I.dsq] '  // i.dsq
			var parseMedicationName = parsedMedicationFromDisp(fav, rx);
			if (fav.strength==undefined || fav.strength.trim()=="") {
				fav.strength = '-';
			}
			if (rx.drugCode && rx.drugCode.code && rx.drugCode.code.length > 0) {
				fav.din = rx.drugCode.code*1;
			}
			if ((fav.baseDrugName==undefined || (fav.baseDrugName==fav.name)) && rx.ingredients!=null && rx.ingredients.length>0) {
				var lstName = [];
				for (let ing of rx.drugIngredients) {
					if (ing.name) {
						lstName.push(ing.name);						
					}
				}
				fav.note = lstName.join('\n');
				fav.baseDrugName = fav.name;
			}
			if (rx.drugFormCode && rx.drugFormCode.text){
				setFormCodeFromText(fav, rx.drugFormCode.code, rx.drugFormCode.text);			
			} else if (parseMedicationName.format && parseMedicationName.format!='') {
				setFormCodeFromText(fav, undefined, parseMedicationName.format);						
			}
			if (fav.format==undefined) {
				if (fav.strength.toLowerCase().indexOf('ml')!=-1) {
					// SUSP(new Integer(223),"suspension","","suspension" ,""),
					fav.format = 223; fav.formatString="suspension";
				} else {
					fav.format = 100; fav.formatString = "Voir détails";
				}
			}
			if (rx.quantity!=null && rx.quantity!=undefined) {
				fav.quantity = rx.quantity.value;
			}
			if (fav.quantity==undefined) {
				fav.quantity = 1;
			} else {
				fav.quantity = Math.round(fav.quantity);
			}
			
//			parsePosologieFromDisp(fav, rx.dosageInstructions);
			fav.site = 0;
			fav.siteString = "S/O";
			fav.rx = model.prefSettings('med_rx_defaut');
			
			setPosologieAndNote(fav, rx.dosageInstructions);
			if (fav.frequency == undefined) {
				fav.frequency = "-";
			}
			if (fav.route==undefined) {
				fav.route = 0;
				fav.routeString = 'Voir détails';
			}
			
			fav.note = fav.note && fav.note.length>0 ? fav.note+"\nImport DSQ" : "Import DSQ";
			
//			fav.frequency = //??
//			fav.idDevice;
//			fav.idStrength
//			fav.noSubstitution
//			fav.professionnal
//			fav.toReprescribeB
//			fav.treatmentDuration
			return fav;
		}
		
		function prescriptionDeviceSummaryToCFavPrescription(rx) {
			var fav = {};
			$.extend(fav, accessor.deviceDefaultItem());
			fav.dsqStatus = 1; fav.dsqStatusStr='[I.dsq] '  // i.dsq
			var parseMedicationName = parsedMedicationFromDevSum(fav, rx);
			if (rx.device.code && rx.device.code.code && rx.device.code.code.length > 0) {
				fav.din = rx.device.code.code*1;
			}
			if (rx.device.formCode && rx.device.formCode.text){
				setFormCodeFromText(fav, rx.device.formCode.code, rx.device.formCode.text);	
			} else if (parseMedicationName.format && parseMedicationName.format!='') {
				setFormCodeFromText(fav, undefined, parseMedicationName.format);						
			}
			if (fav.format==undefined) {
				if (fav.strength.toLowerCase().indexOf('ml')!=-1) {
					// SUSP(new Integer(223),"suspension","","suspension" ,""),
					fav.format = 223; fav.formatString="suspension";
				} else {
					fav.format = 100; fav.formatString = "Voir détails";
				}
			}

			fav.quantity = rx.supplyRequestTotalQuantity;
			if (fav.quantity==undefined) {
				fav.quantity = 1;
			} else {
				fav.quantity = Math.round(fav.quantity);
			}
			fav.site = 0;
			fav.siteString = "S/O";
			setPosologieAndNote(fav, rx.usageInstructions);
			if (fav.frequency == undefined) {
				fav.frequency = "-"						
			}
			if (fav.rx == undefined) {
				fav.rx = model.prefSettings('med_rx_defaut');
			} else {
				fav.rx = Math.min(998, Math.round(fav.rx));
			}
			if (fav.route==undefined) {
				fav.route = 0;
				fav.routeString = 'Voir détails';
			}
			fav.note = fav.note && fav.note.length>0 ? fav.note+"\nImport DSQ" : "Import DSQ";
//			fav.treatmentDuration
			return fav;
		}
		
		function prescriptionDrugSummaryToCFavPrescription(rx) {
			var fav = {};
			$.extend(fav, accessor.prescriptionDefaultItem());
			delete fav.route;delete fav.routeString;
			delete fav.format;delete fav.formatString;
			fav.dsqStatus = 1; fav.dsqStatusStr='[I.dsq] '  // i.dsq
			var parseMedicationName = parsedMedicationFromRxSum(fav, rx);
			if (fav.strength==undefined || fav.strength.trim()=="") {
				fav.strength = '-';
			}
			if (rx.medication.code && rx.medication.code.code && rx.medication.code.code.length > 0) {
				fav.din = rx.medication.code.code*1;
			}
			if ((fav.baseDrugName==undefined || (fav.baseDrugName==fav.name)) && rx.medication.ingredients!=null && rx.medication.ingredients.length>0) {
				var lstName = [];
				for (let ing of rx.medication.ingredients) {
					if (ing.name) {
						lstName.push(ing.name);						
					}
				}
				fav.note = lstName.join('\n');
				fav.baseDrugName = fav.name;
			}
			if (rx.medication.formCode && rx.medication.formCode.text){
				setFormCodeFromText(fav, rx.medication.formCode.code, rx.medication.formCode.text);	
			} else if (parseMedicationName.format && parseMedicationName.format!='') {
				setFormCodeFromText(fav, undefined, parseMedicationName.format);						
			}
			if (fav.format==undefined) {
				if (fav.strength.toLowerCase().indexOf('ml')!=-1) {
					// SUSP(new Integer(223),"suspension","","suspension" ,""),
					fav.format = 223; fav.formatString="suspension";
				} else {
					fav.format = 100; fav.formatString = "Voir détails";
				}
			}
			if (rx.supplyEventSummary) {
				var ses = rx.supplyEventSummary;
				if (ses.firstDispensedQuantity) {
					fav.quantity = ses.firstDispensedQuantity.value;
					if (ses.fillsRemaining) {
						fav.rx = ses.fillsRemaining;
					}
				} else if (ses.remainingTotalQuantity && ses.fillsRemaining) {
					fav.quantity = (ses.remainingTotalQuantity.value/ses.fillsRemaining) | 0;
					fav.rx = ses.fillsRemaining;
				}
				if (fav.quantity==undefined && ses.supplyRequestQuantity) {
					fav.quantity = ses.supplyRequestQuantity.value;
				}
				if (fav.rx==undefined && rx.supplyRequestQuantity) {
					fav.rx = (rx.supplyRequestQuantity.value/fav.quantity) | 0;
					if (fav.rx>0) fav.rx = fav.rx-1;
				}
			}
			if (fav.quantity==undefined) {
				fav.quantity = 1;
			} else {
				fav.quantity = Math.round(fav.quantity);
			}
				
			fav.site = 0;
			fav.siteString = "S/O";
			setPosologieAndNote(fav, rx.dosageText);
			if (fav.frequency == undefined) {
				fav.frequency = "-"						
			}
			if (fav.rx == undefined) {
				fav.rx = model.prefSettings('med_rx_defaut');
			} else {
				fav.rx = Math.min(998, Math.round(fav.rx));
			}
			if (fav.route==undefined) {
				fav.route = 0;
				fav.routeString = 'Voir détails';
			}
			
			fav.note = fav.note && fav.note.length>0 ? fav.note+"\nImport DSQ" : "Import DSQ";
//			fav.treatmentDuration
			return fav;
		}
		
		accessor.deviceReprescribe = function(prescription){
			return accessor.prescriptionReprescribe(prescription);
		};

		accessor.prescriptionReprescribe = function(prescription){
			var df = "YYYY-MM-DD";
			var iv = angular.copy(prescription);
			iv.idPrevPrescription = iv.id;
			delete iv.id;
			delete iv.idAnchor;
			delete iv.idEncounter;
			delete iv.dsqStatusStr;
			delete iv.stopDate;
			delete iv.stopDateSD;
			delete iv.stopReason;
			delete iv.expiredDateSD;
			iv.dosageChange = 0;
			iv.dsqStatus = prescription.dsqStatus ? prescription.dsqStatus : 0;
			iv.dsqStatusStr = prescription.dsqStatusStr ? prescription.dsqStatusStr : '';
			iv.modificationStatus = "STATUS_NEW";
			var dureeRx; var now = moment();
			if(iv.endDate && iv.startDate){
				dureeRx = moment(iv.endDate).diff(moment(iv.startDate), 'days');
			}
			if(iv.endDate){
				delete iv.endDateSD;
				delete iv.endDate;
			}
			iv.entryDateSD = now.format(df);
			iv.entryDate = moment(iv.entryDateSD).valueOf();
			iv.startDateSD = now.format(df);
			iv.startDate = moment(iv.startDateSD).valueOf();
			if (dureeRx) {
				var endDate = moment().add(dureeRx, 'days');
				iv.endDateSD = endDate.format(df);
				iv.endDate = +endDate;	// pour la valeur unix (epoch msec)
			}			
			return iv;
		};

		accessor.represcribe = function(patData, rxIds, type, sum){
			// select right type of prescription (ofys, dsq dm, oe or disp) and create code to import 
			// if prescription is an array, means an array of id from dsq and then type is defined as
			// either dm, oe or disp.
//			List<PrescriptionDrugSummary> dsqDmList;
//			List<OtherMedicationSummary> dsqDmOtherRxList;
//			List<PrescriptionDrugSummary> dsqOeRxList;
//			List<PrescriptionDeviceSummary> dsqOeDevList;
//			List<DispenseSummary> dsqDispList;
			var rxToImport = [];
			if ('dm'===type) {
				var toImport = [];
				var toImport2 = [];
				if (patData.dsqDmList) {
					toImport = patData.dsqDmList.filter(function(e){return rxIds.includes(e.id);})
				}
				if (patData.dsqDmOtherRxList) {
					toImport2 = patData.dsqDmOtherRxList.filter(function(e){return rxIds.includes(e.niu.value);})
				}
				for (let rx of toImport) {
					try{
						rxToImport.push(prescriptionDrugSummaryToCFavPrescription(rx));
					}catch(e){
						console.error(e);console.error(rx);
						warn(rx.name ? rx.name : rx.baseDrugName);
					}
				}
				for (let rx of toImport2) {
					try{
						rxToImport.push(otherMedicationSummaryToCFavPrescription(rx));
					}catch(e){
						console.error(e);console.error(rx);
						warn(rx.name ? rx.name : rx.baseDrugName);
					}
				}
			} else if ('oe'===type) {
				var toImport = [];
				var toImport2 = [];
				if (patData.dsqOeRxList) {
					toImport = patData.dsqOeRxList.filter(function(e){return rxIds.includes(e.id);})
				}
				if (patData.dsqOeDevList) {
					toImport2 = patData.dsqOeDevList.filter(function(e){return rxIds.includes(e.id);})
				}
				for (let rx of toImport) {
					try{
						rxToImport.push(prescriptionDrugSummaryToCFavPrescription(rx));
					}catch(e){
						console.error(e);console.error(rx);
						warn(rx.name ? rx.name : rx.baseDrugName);
					}
				}
				for (let rx of toImport2) {
					try{
						rxToImport.push(prescriptionDeviceSummaryToCFavPrescription(rx));
					}catch(e){
						console.error(e);console.error(rx);
						warn(rx.name ? rx.name : rx.baseDrugName);
					}
				}
			} else if ('disp'===type) {
				if (patData.dsqDispList) {
					var toImport = patData.dsqDispList.filter(function(e){return rxIds.includes(e.id);})
					for (let rx of toImport) {
						try{
							rxToImport.push(dispenseSummaryToCFavPrescription(rx));
						}catch(e){
							console.error(e);console.error(rx);
							warn(rx.name ? rx.name : rx.baseDrugName);
						}
					}
				}
			}
			if (sum) {
				for (let prescription of rxToImport) {
					if(prescription.baseDrugType !== undefined ){
						try{
							if(prescription.baseDrugType === EncounterAccessor.baseDrugTypes.FOURNITURE){
								sum.lstDevice.push(accessor.deviceReprescribe(prescription));
							}else if(accessor.isPrescription(prescription)){// prescriptions
								sum.lstPrescription.push(accessor.prescriptionReprescribe(prescription));
							}
						}catch(e){
							console.error(e);console.error(rx);
							warn(rx.name);
						}
					}
				}
			} else {
				return rxToImport;
			}
		};
				
		accessor.isPrescription = function(p){
			return p && p.baseDrugType != undefined &&
			(p.baseDrugType ==  EncounterAccessor.baseDrugTypes.REGULAR ||
			p.baseDrugType ==  EncounterAccessor.baseDrugTypes.NARCOTIC ||
			p.baseDrugType ==  EncounterAccessor.baseDrugTypes.CONTROLED)
		};
		
		return accessor;
	}]);

	encounter.controller('InteractionsController', ['$scope', function($scope){
	}]);

	encounter.directive('encHistory', 
		[
			'$filter','DashAPI','EncounterAccessor',
		function($filter,DashAPI, EncounterAccessor){
			return {
				restrict: 'EA',
				templateUrl: '/dashboard/resources/ofys/encounter/enc_history.html?v=ba',
				scope: {
					enc: '=encHistory',
				},
				link: function(scope, element, attrs){

					var notesHistoryFactory = { 
						lstNote:function(def){
							def.multiple = true;
							def.clearSeparation = true;
							def.noteTypes = scope.noteTypes;
							def.completeType = 20
							def.isAllEmpty = function(item) {
								return OfysUtils.isAllEmpty(item, ['note']);
							};
							def.setErrors = function(e){
								def.errors = e;
							}
						}
					}
					scope.editEnc = {editMode: false};
					scope.entryDef = {lstNote:{}};
					EncounterAccessor.initEntry('lstNote', scope.entryDef, notesHistoryFactory, scope.editEnc);

					function update(){
						scope.entryDef.lstNote.loading = true;
						EncounterAccessor.findAllNotesIncludingRevisionsAndDeletedByEncounterAnchor(scope.enc.idAnchor, function(res){
							scope.entryDef.lstNote.loading = false;
							if(res && res.length === 0){
								scope.entryDef.lstNote.setErrors([{status: 'INFO', message: $filter('translate')('NoNoteVersion')}]);
							}
							scope.editEnc.lstNote =res;
						}, function(e){
							scope.entryDef.lstNote.loading = false;
							scope.entryDef.lstNote.setErrors(e);
							// scope.closeHistory();
						}, DashAPI.hideMsg());
					}

					scope.closeHistory = function(fn){
						if(fn){
							fn();
						}else{
							$("#btn-encounter-history-edit").click();
						}
					}

					scope.$watch(scope.enc, update);
				}
			}
		}
	]);

	encounter.directive('prescriptionDevicePicker', ['$filter','$q', 'model','EncounterAccessor', 'Notification', 'DashWebSocket',
		function($filter, $q, model, EncounterAccessor, Notification, DashWebSocket){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				allRx: '=',
				allDevices: '=',
				options: '=?',
			},
			templateUrl:'/dashboard/resources/ofys/encounter/prescription_device_picker.html?v=ba',
			link: function(scope, element, attrs){
				var defaultOptions = {
						setTab: function (t){
							this.tab = t;
						},
					};
				scope.options = $.extend(defaultOptions, scope.options || {});
				scope.options.setTab('rx');
				scope.selectRx = function(item){
					if(scope.select !== undefined){
						scope.select(item, 'rx')
					}
				}
				scope.selectDevice = function(item){
					if(scope.select !== undefined){
						scope.select(item, 'device')
					}
				}
			}
		}
	}]);

	encounter.directive('printRxPicker',[function(){
		return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/encounter/printRx_picker.html?v=ba',
			link: function(scope, element, attrs){
				scope.selectedPage = 0;
				scope.pages = [{rx: [], device:[]}];
				function update(){
					scope.pages = [{rx: [], device:[]}];
				}
				scope.$watch(scope.editEnc.lstPrescription, update);
				
				scope.cleanItemsToIds = function(){
					var p = [];
					for (var i = 0; i < scope.pages.length; i++) {
						var x = {rx: [], device:[]};
						x.rx = scope.pages[i].rx.map(function(e){
							return e.id;
						});
						x.device = scope.pages[i].device.map(function(e){
							return e.id;
						});
						p.push(x);
					}
					return p;
				}
				scope.addToList = function(item, type){
					if(item && item.id && scope.pages[scope.selectedPage] && scope.pages[scope.selectedPage][type].indexOf(item) === -1){
						scope.pages[scope.selectedPage][type].push(item);
					}
				}
				scope.addPage = function(){
					scope.pages.push({rx: [], device:[]})
					scope.selectCurrentPage(scope.pages.length - 1);
				}
				scope.removePage = function(i){
					scope.pages.splice(i, 1);
					if(scope.selectedPage >= scope.pages.length){
						scope.selectedPage = 0;
					}
				}
				scope.selectCurrentPage = function(i){
					scope.selectedPage = i;
				}
				scope.removePrintRxPicker = function(page, index){
					scope.pages[page].rx.splice(index, 1);
				}
				scope.removePrintDevicePicker = function(page, index){
					scope.pages[page].device.splice(index, 1);
				}
			}
		}
	}]);
	
	/**
	 * COMMENT: SHOW FACTURATION TYPE DIRECTIVE
	*/
	encounter.directive('showFactType', ['EncounterAccessor','model', '$filter','$http', function(EncounterAccessor, model, $filter, $http){
		return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/encounter/fact_type.html?v=ba',
			link: function(scope, element, attrs){
				scope.loadedStatus = '...';
				var prof = model.user().profil;
				var encId = scope.enc.idAnchor;
				var patId = scope.enc.idPatientAnchor;
				var session = model.user().session;
				var user = session.user;
				var http = session.factHttp;
				var domain = session.factDomain;
				var fmpDomain = session.fmpDomain;
				var useXacte = user.factType == 'XACTE';
				var useMultiD = user.factType == 'MULTID';
				var useFactnet = user.factType == 'FMP';
				scope.encounterEdit = {
					factTypeToggle: function(val) {
						if (arguments.length) {
							var data2 = {idEncAnc: encId, idProf: prof.id, idPat:patId, idFactType: (val===true?0:null), factUid: scope.enc.profEnc.factUid};
					 		EncounterAccessor.saveFactType(data2, 
						 		function(res) {
									if (res.data && res.data.success===true) {
										scope.enc.profEnc.factType = (val===true?0:undefined);
									}
						 		},
						 		function(res) {
									console.log(res);
					 		});
						} else {
							return scope.enc.profEnc.factType===0;
						}
					}
				};
				
				var data = {
					apiKey: useXacte===true||useMultiD===true||useFactnet===true ? session.apiKeyOrToken : undefined,
					http: http, domain:domain, fmpDomain:fmpDomain
				};
				if (useFactnet==true) {
					var extId = scope.enc.profEnc.factUid;
					$http({method : "GET",
					 	url : data.http + '://' + data.domain + '/api/preinvoice/' + extId + '/status',
					 	headers: {'Content-Type': 'application/json; charset=utf-8', 'Authorization': 'bearer ' +data.apiKey}
					 }).then(function success(res) {
					 	// console.log(res);
					 	if (res.status==200) {
					 		if (res.data!=undefined && (null != res.data) && !isNaN(res.data)) {
					 		/* 
					 		statut de la demande (0 pour draft, 1 pour soumise, 2 pour obtenue par logiciel FMP pour traitement, 3 pour payée par RAMQ, valeur à confirmer car je ne les connais pas par cœur..).  
	 						*/
					 			scope.loadedStatus = $filter('translate')('FACT_NET_STAT_'+res.data);
						 	} else {
					 			scope.loadedStatus = $filter('translate')('BILL_NOT_FOUND');
					 		}
					 	} else {
					 		scope.loadedStatus = res.statusText;
					 	}
					 }, function myError(res) {
					 	console.log(res);
					 	scope.loadedStatus = res.statusText;
					 });
				} else if (useXacte==true || useMultiD==true) {
					var extId = encId+'_'+prof.id;
			 		EncounterAccessor.listStatusFacture({factUid:extId}, 
				 		function(y) {
							if (y.statusFacture && y.statusFacture.statusCode==200) {
								var status = {
									new: $filter('translate')('xacte_new'),
									sent: $filter('translate')('xacte_sent'),
									statement: $filter('translate')('xacte_statement'),
									error: $filter('translate')('xacte_error')
								}
								scope.loadedStatus = (status[y.statusFacture.statut]?status[y.statusFacture.statut]:y.statusFacture.statut) + ': $  ' +  (y.statusFacture.montant? y.statusFacture.montant.toFixed(2):'0');
							} else if (y.statusFacture.statusCode===400) {
								scope.loadedStatus = $filter('translate')('xacte_not_found');
							} else {
								scope.loadedStatus = y.statusFacture.statut;
							}
				 		},
				 		function(res) {
							console.log(res);
			 		});
				}
			}
		}
	}]);
	
	/**
	 * COMMENT: ENCOUNTER VIEW DIRECTIVE
	*/
	encounter.directive('encView', [
			'model', '$filter', 'patientShowTitles','PrefAccessor','DashWebSocket','FlView','FormAccessor', 'DocAccessor', 'Markdown',
			'FormAccessor','PatientFormService','ModificationStatus', 'TemplateAssistAction', '$q','LinkMode','MessageLink', '$rootScope',
			'Event','EncounterAccessor','$timeout','encEnumList','QuickView','QConfirm','EncounterSummaryCommon','PatientUtils','rxvigilance', '$http',
		function(model, $filter, patientShowTitles, PrefAccessor, DashWebSocket, FlView,FormAccessor, DocAccessor, Markdown,
			FormAccessor, PatientFormService, ModificationStatus, TemplateAssistAction, $q, LinkMode,MessageLink, $rootScope,
			Event, EncounterAccessor,$timeout, encEnumList, QuickView, QConfirm, EncounterSummaryCommon, PatientUtils, rxvigilance,$http){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/encounter/enc_view.html?v=ba',
			scope: true,
			link: function(scope, element, attrs){
				//
				var HEADERSECTION = EncounterAccessor.allEncSections[0];
				scope.model = model;
				scope.linkModeOn = false;
				scope.fullMenu = false;
				scope.isStagiaire = model.user().isStagiaire()===true;
				scope.systemeChoiceMetricAnglais = 1;	// 1=metric, 2=anglais
				//Api pour la fonction de reorgainser l'ordre des elements de la rencontre.
				scope.dragOptions = {
					dropped : function(event){
						saveOrder()
					}
				};

				
				scope.openNoteVersions = function(){
					$("#btn-encounter-history-edit").click();
				};
				
				scope.pop = {
					onPopupHide : function(event){
						// console.log("Am hidding")
						return true;
					}
				};

				scope.isSummarySpecific = function(title){
					return EncounterAccessor.isSummarySpecific(title);
				};

				scope.$on('$destroy', function () {
					TemplateAssistAction.clearPayload();
				});

				//executer à la selection du sous menue de Note types
				function selectNoteType(){
					if (scope.isDirty()<2) {
						var i = angular.copy(defaultItems.lstNote);
						i.noteType = this.noteType;
						scope.encFormOptions.addNewItem(scope.editEnc, 'lstNote', i);						
					}
				}
				function selectNoteStylet(){
					if (scope.isDirty()<2) {
						FormAccessor.utils.findFormByIdAnchor(FormAccessor.ANCHOR_STYLET,newForm);
					}
				}

				scope.DebugEncPrint = function(){
					console.log(scope.editEnc)
				};

				//Met a jour les types de notes à partir de l'enum XNoteType du Backend
				function updateNotetypes(){
					if(scope.noteTypes && lstNoteNav){
						Object.keys(scope.noteTypes).filter(function(k){return k <= 100}).forEach(function(key){
							lstNoteNav.sub.push({title: scope.noteTypes[key], select: selectNoteType, noteType : key*1, plainTxt: true})
						});

						lstNoteNav.sub.push({title: "Stylet", select: selectNoteStylet, plainTxt: true});
					}
				}

				//Appel backend pour les types de notes appeller à l'ouverture du viewer et mis en cache.
				EncounterAccessor.noteTypes(1, function(res){
					scope.noteTypes = res;
					updateNotetypes();
				});
				scope.printFax = {P:{name: 'EncPrint'},F:{name: 'EncFax'}};
				scope.printFaxStatus = model.prefSettings('user_settings_LastUsedPrintFax');
				
				scope.changePrintFaxStatus = function(p) {
					model.prefSettings('user_settings_LastUsedPrintFax', p);
					scope.printFaxStatus = p;
				};
				scope.isDirty= function(){
					//Possible states - 
					// 0: not saved to backend new encounter
					// 1: Modified unsaved
					// 2: Read only mode - saved to back end
					// 3: pre-save on - non utilisé.
					// 4: from search page
					// 5: modif sommaire
					if (scope.viewOptions) {
						if (scope.editEnc.fromSearch){
							return 4;
						}
						if(scope.editEnc.isNew){
							return 0;
						}
						if(scope.editEnc.editMode){
							return 1;
						}
					}
					if (scope.editEnc.encounterType<10) {
						return 5;
					} else if (scope.encFormOptions.canModifyEncounter(true)===true) {
						return 2;
					}
					return 5;
				};

				scope.isSaved = function(){
					return scope.isDirty() === 2 || scope.isDirty() === 5;
				};

				scope.isUnsaved = function(){
					return scope.isDirty() < 2;
				};

				function encIsMoreThan7DaysOld(){
					var aweekago = moment().subtract(7, 'days');
					var encDate = moment(scope.editEnc.date);
					return encDate.isBefore(aweekago);
				}

				scope.edit = function(skipQuestion){
					if(EncounterAccessor.hasEncounterInEdit(scope.quickViewData.pat, scope.enc)){
						model.notice().warn($filter("translate")('encEditInProgressPresaveError'));
					}else if(encIsMoreThan7DaysOld() && !skipQuestion){
						askForOldEncounterModification()
					}else{
						doEdit()	
					}
				};

				function getEncounterAge(){
					var encDate = moment(scope.editEnc.date)
					return moment().diff(encDate, 'days');
				}

				function askForOldEncounterModification(){
					var txtInput =  {days: getEncounterAge()};
					var qconfirmOptions = {title: $filter('translate')('modifyOldEncounter', txtInput)};

					QConfirm.open(qconfirmOptions).then(proceedWithEdit);
					function proceedWithEdit(proceed){
						if(proceed){
							doEdit()
						}
					}
				}
				scope.showBillRamq = function() {
					var user = model.user().session.user;
					return scope.enc.profEnc!=undefined && user.factTypeI && user.factTypeI>0;
				};
				scope.billRamq = function() {
					if (scope.enc.profEnc!=undefined && scope.enc.profEnc.factType==0) {
						model.notice().warn($filter('translate')('MUST_DEACTIVATE_EXCLUDE_BILLING'));
					} else {
					var prof = model.user().profil;
					var code = prof.code;
					var noGroup = prof.noGroup?prof.noGroup:'00000';
					var noAgence = prof.noAgenceRamq;
					var session = model.user().session;
					var noEtabl = session.workSite.b2bInformations.noEtabGmf;
					var user = session.user;
					if (OfysUtils.isNotEmpty(user.factCodeProf)) {
						code = user.factCodeProf;
					}
					var useXacte = user.factType == 'XACTE';
					var useMultiD = user.factType == 'MULTID';
					var useFactnet = user.factType == 'FMP';
					var apiKey = useXacte===true||useMultiD===true||useFactnet===true ? session.apiKeyOrToken : undefined;
					var http = session.factHttp;
					var domain = session.factDomain;
					var fmpDomain = session.fmpDomain;
					var factUsername = user.factUsername;
					var encDate, encTime;
					if (scope.enc.profEnc!=undefined) {
						if (scope.enc.profEnc.entryDate) {
							var theDate = moment(scope.enc.profEnc.entryDate);
							encDate = theDate.format("YYYY-MM-DD");
							encTime = theDate.format("HHmm");
							encDateTime = theDate.format("YYYY-MM-DDTHH:mm");
						}
					}
					if (encDate !=undefined) {
						var diag = [];
						if (scope.enc.lstDxEnc && scope.enc.lstDxEnc.length>0) {
							if (useFactnet===true) {
								
								var dxArr = scope.enc.lstDxEnc.filter(function(a){return a.cim10Code!==undefined}).map(function(v) {return v.cim10Code;});
								diag.push(...dxArr);
							} else {
								var dxArr = scope.enc.lstDxEnc.filter(function(a){return a.cim9Code!==undefined}).map(function(v) {return v.cim9Code;});
								diag.push(...dxArr);
							}
						}
						var data = {
								http: http, domain:domain, fmpDomain:fmpDomain, factType:user.factTypeI,
								userId: factUsername, apiKey: apiKey, profEnc:scope.enc.profEnc,
								prof:{code:code, noGroup:noGroup, noAgence:noAgence, id:prof.id, firstName: prof.firstName, lastName:prof.lastName},
								encId:scope.enc.idAnchor, encDate:encDate, encTime:encTime, encDateTime: encDateTime,
							noEtabl:noEtabl, dx:diag,
							pat: scope.quickViewData.pat
							};
						if (useXacte===true||useMultiD===true) {
								openXacte(data);
						} else if (useFactnet===true) {
								openFmp(data);
							}
						}
					}
				};
				
				function openFmp(data) {
					var fact = {patient:{}, doctor:{}, appointment:{}};
					var noGmf;
					if (data.pat.b2bInformation!=undefined && data.pat.b2bInformation.status==2 && data.pat.txProfCode) {
						var familyDoctor = {};
						familyDoctor.licenceNumber = data.pat.txProfCode;
						familyDoctor.firstName = data.prof.firstName;
						familyDoctor.lastName = data.prof.lastName;
						familyDoctor.patientCareStartDate = data.pat.b2bInformation.startDate;
					    familyDoctor.patientCareEndDate = null;
						var site = model.user().sites[data.pat.b2bInformation.idSiteFollow];
						if (site && site.b2bInformations) {
							familyDoctor.locationCode = site.b2bInformations.noEtabGmf;			
							noGmf = site.b2bInformations.noGmf;
						}
						familyDoctor.patientCareEndDate = null;
						familyDoctor.patientCareType = 1;	// ?? signification
						fact.patient.familyDoctor=familyDoctor;
					}
					if (data.pat.b2bInformation.vulnerabilities) {
						fact.patient.vulnerabilities = [];
						var vuln = _.filter(data.pat.b2bInformation.vulnerabilities, function(v) { if (v.disCode) {return true;} else { return false;}});
						for(var i = 0 ; i < vuln.length; i++){
							v = vuln[i];
							fact.patient.vulnerabilities.push({
								code: v.disCode.substring(1),
								startDate: v.date,
								endDate: v.dateEnd==undefined ? null : v.dateEnd
							});
						}
					}
					
					fact.patient.providersPatientInternalId = '_' + data.pat.id; // pour forcer un String - pourle guid patient
					fact.patient.firstName = data.pat.firstName;
					fact.patient.lastName = data.pat.lastName;
					if (OfysUtils.isEmpty(data.pat.healthInsuranceNumber)) {
						fact.patient.hin = null;
						fact.patient.representant=null;
						if (OfysUtils.isNotEmpty(data.pat.motherHin)) {
							fact.patient.familyHin = data.pat.motherHin;
						} else if (OfysUtils.isNotEmpty(data.pat.fatherHin)) {
							fact.patient.familyHin = data.pat.fatherHin;
						} else {
							fact.patient.familyHin = null;
						}
					} else {
						fact.patient.hin = data.pat.healthInsuranceNumber;						
					}
					// gender male= ?, female = ?
					fact.patient.gender = data.pat.gender=='M'?1:2;
					fact.patient.birthDate = data.pat.birthDate;
					//fact.patient.familyHin = null;
					//fact.patient.birthOrder = 1;
					if (data.pat.lstAddress && data.pat.lstAddress.length>0) {		
						var addrs = data.pat.lstAddress[0];
						fact.patient.address = addrs.street;
						fact.patient.city = addrs.city ? addrs.city.name : null;
						fact.patient.province = addrs.province ? addrs.province.name : null;
						fact.patient.postalCode = addrs.postalCode ? addrs.postalCode : null;
					}					
					fact.doctor.licenceNumber = data.prof.code;
					fact.doctor.adminGroup = data.prof.noGroup;
					fact.doctor.agencyNo = data.prof.noAgence;
					//  fact.appointment.referringProfessional = {
					//  fact.appointment.referringProfessional.licenceNumber": "1810761",
					//  fact.appointment.referringProfessional.speciality": "eeee",
					//  fact.appointment.referringProfessional.firstname": "Denis",
					//  fact.appointment.referringProfessional.lastname": "Prince"
					// }
					
					fact.appointment.medicalActTime = encDateTime;
					fact.appointment.locationCode = data.noEtabl,
					//fact.appointment.cnesstEventDate": "2000-01-01T00:00:00",
					fact.appointment.diagnosisCode = data.dx ? data.dx[0] : null;	// Possible d'en mettre plus de 1 ? 
					fact.appointment.isScheduledVisit = true;
					fact.appointment.medicalCareDeliveryLocationType = 0;	// ??
					fact.appointment.establishmentType = 2;	// ??
					fact.appointment.isUmf = false;
					fact.appointment.isGmf = noGmf!=undefined;
					fact.appointment.isNetworkClinic = false;
					
					fact.siteID= '_ofys_' + data.noEtabl;
					if (data.dx.length>0) {
						fact.diagnosisCode = data.dx[0];
					}
					// fact.providersInvoiceInternalId = data.encId+'_'+data.prof.id;	// ne plus utiliser. Il faut garder le uid
					
					var data2 = {idEncAnc:data.encId, idProf:data.prof.id, idFactType:3, idPat:data.pat.id};
					var encFactType = data.profEnc.factType;
					if (encFactType===data2.idFactType && data.profEnc.factUid!=undefined && data.profEnc.factUid!=null) {
						// donc a deja facturé cette visite.
						var url = data.http + '://' + data.fmpDomain + '/preInvoice/' + data.profEnc.factUid + '?token=' + data.apiKey;
						openUrl(url);
					} else {
						$http({method : "POST",
						 	url : data.http + '://' + data.domain + '/api/preinvoice/create',
						 	data:  JSON.stringify(fact),
						 	headers: {'Content-Type': 'application/json; charset=utf-8', 'Accept': 'application/json', 'Authorization': 'bearer ' +data.apiKey}
						 }).then(function success(res) {
						 	console.log(res);
						 	if (res.data && res.data.preInvoiceId) {
								var url = data.http + '://' + data.fmpDomain + '/preInvoice/' + res.data.preInvoiceId + '?token=' + data.apiKey;
								openUrl(url);
								data2.factUid = res.data.preInvoiceId;
								saveFactType(encFactType, data2, data.profEnc);
						 	} else {
						 		model.notice().warn("Erreur/Error: " + res);
						 	}
						 }, function myError(res) {
						 	console.log(res);
						 	if (res.data) {
								 if (res.data.message) {									 
							 		if (res.data.message.startsWith('Le ID existe')) {
										var url = data.http + '://' + data.fmpDomain + '/preInvoice/' + data.profEnc.factUid + '?token=' + data.apiKey;
										openUrl(url);
										data2.factUid = data.profEnc.factUid;
										saveFactType(encFactType, data2, data.profEnc);
							 		} else {
								 		var msg = [res.data.message];
								 		if (res.data.modelState) {
											Object.keys(res.data.modelState).forEach(function(key,index) {
											  msg.push(key + ': ' + res.data.modelState[key]);							
											});
										}
								 		model.notice().warn(msg.join('\n'));
								 	}
								 } else {
									 // Ex new version: "--Erreur: Aucun dossier pour cette licence et ce code de localité (MedecinGroupe)."
									 model.notice().warn(res.data);
								 }
						 	}
						 });
					}
				}
				
				function openXacte(data) {
					var oHeader = {alg: 'HS256', typ: 'JWT'};
					var oPayload = {};
					oPayload.iat = KJUR.jws.IntDate.get('now');
					oPayload.jti = UUID.generate();
					oPayload.usr = data.userId;
					var encFactType = data.factType;
					var sJWT = KJUR.jws.JWS.sign("HS256", oHeader, oPayload, data.apiKey);
					var pat = "";
					if (OfysUtils.isNotEmpty(data.pat.healthInsuranceNumber)) {
						pat += "&nam=" + data.pat.healthInsuranceNumber;
					} else {
						if (OfysUtils.isNotEmpty(data.pat.motherHin)) {
							pat += "&namParent=" + data.pat.motherHin;
						} else if (OfysUtils.isNotEmpty(data.pat.fatherHin)) {
							pat += "&namParent=" + data.pat.fatherHin;
						}						
					}
					pat += "&nom=" + data.pat.lastName + "&prenom=" + data.pat.firstName + "&dateNaissance=" + data.pat.birthDate + "&sexe=" + data.pat.gender
					pat += "&idExternePatient=" + data.pat.id;
					if (data.dx) {
						pat += '&diagnostics=' + data.dx.join('$');
					}
					if (data.pat.b2bInformation!=undefined && data.pat.b2bInformation.status==2 && data.pat.txProfCode) {
						pat += "&noMedecinFamille=" + data.pat.txProfCode; //  -> est le id du prof. Le chercher pour avoir son no
						pat += "&dateDebutMedecinFamille=" + data.pat.b2bInformation.startDate;
						var site = model.user().sites[data.pat.b2bInformation.idSiteFollow];
						if (site && site.b2bInformations) {
							pat += "&noGMFOuCabinet=" + site.b2bInformations.noEtabGmf;							
						}
						if (data.pat.b2bInformation.vulnerabilities) {
							var vuln = _.filter(data.pat.b2bInformation.vulnerabilities, function(v) { if (v.disCode) {return true;} else { return false;}}).map(function(v) {return v.disCode.substring(1);}); 
							pat += "&codesVulnerabilite=" + vuln.join('$');
						}
					}

					var url = data.http + '://' + data.domain + '/account/account/jwt/?jwt=' + sJWT + '&username=' + data.userId
					 + "&return_to=" + encodeURIComponent(data.http + "://" + data.domain + "/A/Demande/?noProfessionelRAMQ=" + data.prof.code + "&noGroupeRAMQ=" + data.prof.noGroup
					 + "&noReferenceExterne=" + data.encId+'_'+data.prof.id + "&noEtablissementRAMQ=" + data.noEtabl + "&date=" + data.encDate
					 + "&heure=" + data.encTime + pat);
					 ;
					openUrl(url);
					var data2 = {idEncAnc:data.encId, idProf:data.prof.id, idFactType:data.factType, idPat:data.pat.id};
					saveFactType(encFactType, data2, data.profEnc);
				};

				function saveFactType(encFT, data, profEnc) {								
					//if (encFT!=data.idFactType) {
				 		EncounterAccessor.saveFactType(data, 
					 		function(res) {
								if (res.data && res.data.success===true) {
									profEnc.factType = data.idFactType;
									if (data.factUid) {
										profEnc.factUid = data.factUid;			
									}
								}
					 		},
					 		function(res) {
								console.log(res);
				 		});
				 	//}
				 }
								 
				function openUrl(url) {
					if (typeof openExternalBroswer === "function") {
						openExternalBroswer(url);
					} else {
						openRequestedSinglePopup(url,'RAMQ_Billing');
					}
				}

				var previousUrl; /* global variable that will store the url currently in the secondary window */
				function openRequestedSinglePopup(url, windowName) {
				  if(scope['wor_'+ windowName] == undefined || scope['wor_'+ windowName].closed) {
					scope['wor_'+ windowName] = window.open(url, windowName, "popup");
				  } else if(previousUrl != url) {
				    scope['wor_'+ windowName] = window.open(url, windowName, "popup");
				    scope['wor_'+ windowName].focus();
				  } else {
				    scope['wor_'+ windowName].focus();
				  };
				  previousUrl = url;
				}
				
				function doEdit(){
					scope.editEnc.editMode = true;
					scope.enc.editMode = true;
					setEncounterGuid()//set guid if not already set.
					scope.item  = scope.encFormOptions.editItem({}, HEADERSECTION)
					var def;
					for(var i = 0 ; i < allEncSections.length; i++){
						def = scope.entryDefs[allEncSections[i]];
						if(!scope.isSummarySpecific(allEncSections[i]) && !def.isList && !(def.hide && def.hide(scope.editEnc))){
							def.read = false;
						}
					}
				}

				scope.printConsult = function(id) {
					var toPrint = {idConsult:id}
					return EncounterAccessor.printConsult(toPrint, angular.noop);					
				};

				function clearPresaved(enc){
					if(scope.quickViewData && 
						scope.quickViewData.pat.viewbag && 
						scope.quickViewData.pat.viewbag.patData && 
						scope.quickViewData.pat.viewbag.patData.presaveenc &&
						scope.quickViewData.pat.viewbag.patData.presaveenc.length > 0 ){
						var presaveIndex = scope.quickViewData.pat.viewbag.patData.presaveenc.indexOf(enc);
						if(presaveIndex > -1){
							scope.quickViewData.pat.viewbag.patData.presaveenc.splice(presaveIndex, 1);
						}
					}
				}

				function clearEnc(enc){
					if(scope.quickViewData && 
						scope.quickViewData.pat.viewbag && 
						scope.quickViewData.pat.viewbag.patData && 
						scope.quickViewData.pat.viewbag.patData.enc &&
						scope.quickViewData.pat.viewbag.patData.enc.length > 0 ){
						var i = scope.quickViewData.pat.viewbag.patData.enc.indexOf(enc);
						if(i > -1){
							scope.quickViewData.pat.viewbag.patData.enc.splice(i, 1);
						}
					}
					clearPresaved(enc)
				}

				//Should only do cleanup of state and restore state before creation.
				scope.cancel = function(){
					if(scope.enc && scope.enc.viewbag){
						delete scope.enc.viewbag.editEnc;
					}
					setReadMode(false);
					delete scope.item;// Header section item used for validations.
					if(scope.editEnc.editMode){
						//Clean presave in backend.
						scope.editEnc.editMode = false;
						if(scope.editEnc && scope.enc.editMode){
							scope.quickViewData.pat.viewbag.patData.enc = _.reject(scope.quickViewData.pat.viewbag.patData.enc, 
								function(e){ 
									return e.guid === scope.editEnc.guid;
								});
						}
						model.safeCall(deletePresaved);
					}
					removeEncounterGuid();
					if(scope.editEnc && scope.editEnc.id === undefined){
						//if called onclose the isNew is set to false to change the dirty state and close the viewer.
						scope.editEnc.isNew = false;
						clearEnc(scope.enc);
					}
					model.actUpdated(true);
				};

				function deletePresaved(){
					stopActivePresave();
					if(scope.quickViewData.pat.viewbag
						&& scope.quickViewData.pat.viewbag.patData){
						delete scope.quickViewData.pat.viewbag.patData.presaveenc;
					}
					EncounterAccessor.deletePresaved(scope.quickViewData.pat.id, angular.noop, angular.noop);
				}
				
				scope.cancelEdit = function(){
					askForCancelModification()
				};
				function askForCancelModification(){
					var qconfirmOptions = {title: $filter('translate')('encounterUnsavedChanges')};

					QConfirm.open(qconfirmOptions).then(proceedWithEditCancel);
					function proceedWithEditCancel(proceed){
						if(proceed){
						}else{
							doCancelEdit()
						}
					}
				}

				function doCancelEdit(){
					//Encounter was never saved to backend, or is opened via presave Quit the editor.
					if(!scope.enc.id){
						delete scope.editEnc.isNew;
						scope.rejectEncounter = true;
						scope.qv.$$close();
					}else{
						scope.cancel();
						loadEnc(scope.enc);
					}
				}

				function saveOrder(){
					var encounterOrder = scope.navdef.reduce(function(acc, cur){
						if(acc.title){
							return [acc.title , cur.title]
						}else{
							acc.push(cur.title);
							return acc;
						}
					});
					//Since reason is always viewed and should be the first on the top of the list
					encounterOrder.unshift(HEADERSECTION)
					// console.log(encounterOrder.join(','))
					model.prefSettings('enc_Order', _.unique(encounterOrder).join(','));
				}

				var allEncSections  = EncounterAccessor.allEncSections.concat(EncounterAccessor.summarySections);
				var encLists = allEncSections.filter(function(e){return e !== HEADERSECTION});


				//Preference de l'ordre des elements de la rencontre.
				var savedOrder = model.prefSettings('enc_Order');
				if(savedOrder!=undefined && savedOrder !== ""){
					var tempSavedOrder = savedOrder.split(',');
					var diff = _.difference(allEncSections, tempSavedOrder);
					if (diff.length==0) {
						allEncSections = tempSavedOrder;
					}
					// console.log(model.prefSettings('enc_Order'));
				}

				scope.entryDefs = {};
				scope.navdef = [];
				var alwaysVisibleSections = ['lstPrescription','lstDxEnc', 'lstDevice', 'lstDoc'];
				var alwaysHiddenSections = [];

				//Créer un element de la rencontre. pour chaque element de la list allEncSections l'element est initialisé
				function initNaV(key){
					scope.entryDefs[key] = {};

					if(key != HEADERSECTION){//Reason section is always visible
						scope.navdef.push({title:key});
						//Add a hide function to know when to hide the section.
						(function(x){
							scope.entryDefs[x].hide = function(enc){
//								if(x === "lstDxEnc" && enc.lstDx){
//									return false
//								}else
								if(alwaysVisibleSections.indexOf(x) !== -1 && scope.editEnc.editMode ){
									return false;
								} else if(alwaysHiddenSections.indexOf(x) !== -1 ){
									return true;
								}else{
									return !(enc[x]) && scope.entryDefs[x].read
								}
							};
						})(key);
					}
				}

				function hasSummaryPrescriptions(){
					return scope.quickViewData && 
					scope.quickViewData.pat && 
					scope.quickViewData.pat.viewbag && 
					scope.quickViewData.pat.viewbag.patData&& 
					scope.quickViewData.pat.viewbag.patData.sum && 
					scope.quickViewData.pat.viewbag.patData.sum.lstAllPrescription && 
					scope.quickViewData.pat.viewbag.patData.sum.lstAllPrescription.length > 0 ;
				}
				function hasSummaryDevices(){
					return scope.quickViewData && 
					scope.quickViewData.pat && 
					scope.quickViewData.pat.viewbag && 
					scope.quickViewData.pat.viewbag.patData&& 
					scope.quickViewData.pat.viewbag.patData.sum && 
					scope.quickViewData.pat.viewbag.patData.sum.lstDevice && 
					scope.quickViewData.pat.viewbag.patData.sum.lstDevice.length > 0 ;
				}
				function inReadOnlyMode(){
					var t = scope.editEnc.editMode!==true || model.user().isClinician()===false;
					return t;
				}
				allEncSections.forEach(initNaV);
				
				var lstNoteNav = scope.navdef.find(function(d){return d.title =="lstNote"});
				lstNoteNav.sub = [ ]
				
				updateNotetypes();
				
				scope.removeNew = function(type){
					if(scope.entryDefs[type] && !scope.entryDefs[type].read){
						scope.entryDefs[type].read = true; 
					}
				}

				/*Close the editor context if possible
					Returns true if the context can be closed and false if not.
				*/
				scope.closeContext = function(act, onContextClosed){
					function contextClosed(){
						scope.ignoreChanges = true;
						onContextClosed && onContextClosed(false);
					}
					function rejectEncounter(){
						model.safeCall(act.cancel);
						contextClosed()
					}
					if (scope.isUnsaved() ) {
						if(!scope.rejectEncounter){
							QConfirm.open({title: $filter('translate')('encounterUnsavedChanges')})
							.then(function(save){
								if(save){
									act.save().then(contextClosed);//should change the dirty state to make sure that the second time closing goes through
								}else{
									rejectEncounter()
								}
							});
						}else{
							rejectEncounter();
						}
						return false;
					}
					onContextClosed && onContextClosed(true);
					return true;
				}

				function getActiveDocLenght(){
					return scope.enc.viewbag && scope.enc.activeDocs && scope.enc.activeDocs.length ? scope.enc.activeDocs.length: 0;
				}
				function cascadeClose (event){
					var dl = getActiveDocLenght();
					if(dl > 0){
						if(!scope.enc.viewbag.currentdoc){
							scope.setActiveDoc(dl - 1)
						}
						var i = scope.enc.activeDocs.indexOf(scope.enc.viewbag.currentdoc)
						scope.closeOpenDoc(i, function(){cascadeClose(event)});
					}
				}

				function closeEncounterContext(event){
					var act = event.mObj.quickViewData.qvActData;
					if(!scope.closeContext(act, scope.qv.$$close)){
						// event.stopPropagation();
					}
				}
				scope.addEventsEvent = function (){
						//Ne pas ajouter les événements si on est pas en mode quick view
						if(!scope.qv ){
							return;
						}
						
						if(!QuickView.eventsActive(scope.qv)){
							return;// event have already been deleted (because of a close or one quickview that triggers another)
						}
						//Si c'est la première ouverture, créer la variable d'événements
						if(!scope.qv.ActiveEventsRef){
							scope.qv.ActiveEventsRef = {};
						}
						//Make sure previously created events are not referred to 
						//Very important to avoid leaks
						QuickView.removeAllEventHandlers(scope);
						//L'événement existe donc il ne faut pas le recréer
						if(!scope.qv.ActiveEventsRef.onQvClose){
							//Ici elle est appeller ajouté aussi-tot que le viewer s'ouvre donc toujours active
							//Comme le scope n'est pas passé en parametre, le handler est seulement detruit quand le quickview est fermer
							scope.qv.ActiveEventsRef.onQvClose = Event.on(scope.qv.onQvClose,function(event){
								if (scope.isUnsaved()) {
									event.stopPropagation();
									var openEncounter = getActiveDocLenght();
									if(!QuickView.isCurrent(event.mObj)){
										var closePromise = QuickView.open(event.mObj);
										closePromise.then(function(){
											if(openEncounter > 0){
												cascadeClose(event);
											} else {
												closeEncounterContext(event)
											}
										});
									}else{
										if(openEncounter > 0){
											cascadeClose(event);
										} else {
											closeEncounterContext(event)
										}
									}
								}
							});
						}
						if(!scope.qv.ActiveEventsRef.onQvMinimize){
							scope.qv.ActiveEventsRef.onQvMinimize = Event.on(scope.qv.onQvMinimize,function(event){
								scope.saveActiveDocState();
							});
						}
						
						//événement de changement d'activité
						if(!scope.qv.ActiveEventsRef.onQvActivityChange){
							scope.qv.ActiveEventsRef.onQvActivityChange = Event.on(scope.qv.onQvActivityChange,function(event){
								//Ici l'objet 'event' passé en paramètre contient l'objet 
								//mObj=objet modal contenat qv, quickviewData,
								//le oldAct=activité courant qui a le controle du quickview 
								// newAct=activité qui veut prendre contrôle du quickview.

								scope.saveActiveDocState();
								// scope.linkManager.clear()
								// console.log('oldAct:' + event.oldAct.uid + ', newAct:'+event.newAct.uid);
								var oldAct; 
								if (scope.isUnsaved()) {
									oldAct = event.oldAct;
								}else{
									// doit garder les events quickview parce qu'une autre quickview est ouver pour le newAct. 
									//en cas de fermeture du quickview les close doit être appeler pour l'element.
									QuickView.removeAllEventHandlers(scope);
								}
								if (oldAct) {
									event.stopPropagation();
									if(scope.qv.isExternal){
										model.notice().warn($filter("translate")('InExternalEditRestrictionEnc'))
										return;
									}
									
									// preSaveForm(true);
									// il ne faut pas fermer le old. Il faut le minimiser - je le ferai après le changement.
									$timeout(function() {
										// peut ouvrir 2 x le meme. il faut prévenir cela. 
										patientShowTitles.openActivity(event.newAct, {mode: 'n', minimize: false}, event.mObj.quickViewData.pat);
									}, 1000);
								}
							});
						}
						if(!scope.qv.ActiveEventsRef.onQvExternalize){
							scope.qv.ActiveEventsRef.onQvExternalize = Event.on(scope.qv.onQvExternalize,function(event){
								scope.saveActiveDocState();
								QuickView.removeAllEventHandlers(scope);
							});
						}
					
				}

				
				scope.encFormOptions = {
					isDirty: scope.isDirty,
					editItem : function(item, type){

						// if(scope.isSummarySpecific(type)){
						// 	return;
						// }
						if(item.isReadOnly===true){
							return;
						}
						var def = scope.entryDefs[type]
						if(def.onEdit && !def.onEdit(item)){
							return; //When on cancel is declared it must return true for cancel to proceed
						}
						if(!item.viewbag || !item.viewbag.item){
							item.viewbag = {item: angular.copy(item), scrollable: {}};
							if(item.id === undefined && !item.mustHardDelete){
								item.viewbag.isNew = true;
							}
							if(type){
								if(forEdit[type]){
									forEdit[type](item, def);
								}
							}
							item.editMode = true;//For presave. 
						}
						if(def.onPostEdit) {
							def.onPostEdit(item.viewbag.item);
						}
						$timeout(function(){
							if(item.viewbag && 
								item.viewbag.scrollable && 
								item.viewbag.scrollable.scrollToScreen && 
								item.viewbag.scrollable.scrollToScreenElem){
								if(!OfysUtils.isScrolledIntoView(item.viewbag.scrollable.scrollToScreenElem)){
									item.viewbag.scrollable.scrollToScreen();
								}
							}
							if(item.viewbag && 
								item.viewbag.onChangeEditState){
								item.viewbag.onChangeEditState(item, def);
							}
						}, 500);//plus fiable a 500ms, ne semble pas marcher tout le temps à moins de 300ms.
						return item;
					},
					canModifyEncounter: function(ready){
						return model.user().isClinician();
					},
					saveItemEdit: function(modifyItem, originalItem, def, skipPresave){
						if(def && def.onSave && !def.onSave(modifyItem, originalItem, def, skipPresave)){
							return false;
						}

						if(originalItem && originalItem.viewbag 
							&& originalItem.viewbag.okToClose &&
							originalItem.viewbag.okToClose()){
								//Update the modification status of the object
								modifyItem.modificationStatus = ModificationStatus.STATUS_UPDATED;
								if(originalItem && originalItem.viewbag && originalItem.viewbag.isNew){
									modifyItem.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
									originalItem.viewbag.isNew = false;
								}

								OfysUtils.update(originalItem, modifyItem);
								originalItem.editMode = false;
								if(!skipPresave){
									scope.commitForPresave(originalItem, def.title)
								}
								// TODO à activer dans next version - il faut développer et tester
//								if (scope.entryDefs.lstPrescription && scope.entryDefs.lstPrescription.patient && scope.entryDefs.lstPrescription.patient.viewbag) {
//									var lstDx = scope.entryDefs.lstPrescription.patient.viewbag.patData.sum.lstDx;
//									var lstAll = scope.entryDefs.lstPrescription.patient.viewbag.patData.sum.lstAllergy;
//									var lstInt = scope.entryDefs.lstPrescription.patient.viewbag.patData.sum.lstIntolerance;
//									var lstRx = scope.entryDefs.lstPrescription.patient.viewbag.patData.sum.lstPrescription;
//									var data = {
//											prescription: modifyItem,
//											lstDx: lstDx,
//											lstPrescription: lstRx,
//											lstAllergies: lstAll,
//											lstIntolerances: lstInt
//									};
//									EncounterAccessor.analyseAllergies(data, function(data) {
//										if(data && data.data && data.data.lstAllergies){
//											data.data.lstAllergies.forEach(function(e){
//												if(e.severity !== undefined){
//													e.severityStr = encEnumList.allergyServerity[e.severity];
//												}
//											})
//											data.data.lstAllergiesNotFound.forEach(function(e){
//												if(e.severity !== undefined){
//													e.severityStr = encEnumList.allergyServerity[e.severity];
//												}
//											})
//										}
//										
//										originalItem.allergyAnalysis = data.data
//									});
//								}
								
								return true;
						}else{
							return false;
						}
					},
					deleteItemEdit: function(item, def, skipPresave){
						if(!item.id){
							var i = scope.editEnc[def.title].indexOf(item);
							// scope.editEnc[def.title].splice(i, 1);
							//For presave if deleted without an id, status should be updated
							//removed otherwise the status can be saved to the backend.
							item.viewbag.item.modificationStatus = ModificationStatus.STATUS_DELETED;
						}else{
							delete item.viewbag;
						}
					},
					cancelItemEdit: function(item, def, skipPresave){
						if(def.onCancel && !def.onCancel(item)){
							return; //When on cancel is declared it must return true for cancel to proceed
						}
						if(item.viewbag && item.viewbag.isNew){
							var i = scope.editEnc[def.title].indexOf(item);
							scope.editEnc[def.title].splice(i, 1);
							//For presave if deleted without an id, status should be updated
							//removed otherwise the status can be saved to the backend.
							item.viewbag.item.modificationStatus = ModificationStatus.STATUS_DELETED;
						}else{
							delete item.viewbag;
						}
						item.editMode = false;//For presave. 
						if(!skipPresave){
							scope.commitForPresave(item, def.title)
						}
					},
					saveAndNew: function(modifyItem, originalItem, def){
						if(scope.encFormOptions.saveItemEdit(modifyItem, originalItem, def) && def){
							scope.encFormOptions.addToList(def);
						}
					},
					//Adds a new element to the encounter
					//@params: 
					//	enc - The encounter object to which a new item is to be added.
					//	type - type of item to add eg. lstDx, lstPro, note ...
					addNewItem: function (enc, type, addThis){
						if(!enc.editMode){
							return;
						}
						if(type === 'lstDoc' && !scope.linkModeOn){
							scope.toggleLinkMode();
							return;
						}
						if(scope.entryDefs[type].isList){
							// var itemInEditMode = false;
							var inEditIndex = -1;
							if(!enc[type]){
								enc[type] = [];
							}
							for(var i = 0; i < enc[type].length ; i++){
								if(enc[type][i].viewbag && enc[type][i].editMode && enc[type][i].viewbag.item){
									// itemInEditMode = true; //find if another item is already in edit.
									scope.encFormOptions.saveItemEdit(enc[type][i].viewbag.item, enc[type][i], scope.entryDefs[type])
								}
							}
							// if(!itemInEditMode){
								if(addThis || defaultItems[type]){
									var ni = addThis || angular.copy(defaultItems[type]);
									var editable = scope.encFormOptions.editItem(ni, type);
									editable.viewbag.isNew = true;
									enc[type].unshift(editable);
								}
							// }
						}else{
							scope.entryDefs[type].read = false;
						}
					},
					addToList: function(def){
//						scope.encFormOptions.addNewItem(scope.editEnc, (def.title === 'lstDx'? 'lstDxEnc': def.title));
						scope.encFormOptions.addNewItem(scope.editEnc, def.title);
						// var list = scope.editEnc[def.title];
						// list.push(scope.encFormOptions.editItem(angular.copy(defaultItems[def.title]), def.title));
					},
					removeList: function(def){
						if(scope.editEnc[def.title] && scope.editEnc[def.title].length < 1){
							delete scope.editEnc[def.title];
						}
						//removeList Not yet implemented.
					},
					okToClose: function(scope){
						var canClose = true;
						var msgCarrier = scope;
						
						if(scope.encForm && scope.encForm.$invalid){
							msgCarrier.messages.clearAndAdd(PatientFormService.getFormErrors(scope.encForm));
							canClose = false;
						}
						return canClose;
					},
					onFormLoad: function(formscope, item){
						//commitForPresave(item)
						$timeout(function(){
							if(formscope.encForm){// While form is visible.
								if(formscope.encForm.$dirty){
									//Item is dirty and must be presaved.
									// console.log("My item has been changed");
									scope.commitForPresave(formscope.item, formscope.def.title)
									formscope.encForm.$setPristine();
								}
								scope.encFormOptions.onFormLoad(formscope);
							}
						}, 1000);
					}
				}

				//After calling this function the presave is sent to jetty server after x seconds.
				//If this is called multiple times the counter starts after the last call
				function activatePresave(){
					stopActivePresave();
					console.log("Creating new Presave timer");
					scope.quickViewData.pat.viewbag.patData.presaveTimeout = $timeout(function(){
						// console.log("Going to presave who hoooo!!! ");
						scope.presave();
					}, 2000);
				}

				function stopActivePresave(){
					if(scope.quickViewData.pat.viewbag.patData.presaveTimeout){
						console.log("Canceling presave");
						$timeout.cancel(scope.quickViewData.pat.viewbag.patData.presaveTimeout);
					}
				}
				scope.headerOkToClose = function(){
					return scope.entryDefs[HEADERSECTION].read || (!scope.entryDefs[HEADERSECTION].read &&scope.item && scope.item.viewbag 
							&& scope.item.viewbag.okToClose &&
							scope.item.viewbag.okToClose())
				}

				var forEntryDef = {
					header: function(def){
						def.selectSupervisor = function(prof){
							if (scope.editEnc.tbrObj == undefined) {
								scope.editEnc.tbrObj = {};
							}
							scope.editEnc.tbrObj.supervisor = prof.id;
							scope.editEnc.tbrObj.deleted=false;
							def.supervisor = prof;
							def.supervisorName = prof.lastName + ', '+ prof.firstName;
							scope.editEnc.tbrObj.modificationStatus = ModificationStatus.STATUS_UPDATED;
							def.encForm.$setDirty();
						}
						def.removeSupervisor = function(){
							delete scope.editEnc.tbrObj.supervisor;
							scope.editEnc.tbrObj.deleted=true;
							scope.editEnc.tbrObj.modificationStatus = ModificationStatus.STATUS_UPDATED;
							def.supervisorName = "";
							def.encForm.$setDirty();
						}
						if (scope.editEnc.tbrObj && scope.editEnc.tbrObj.supervisor && scope.editEnc.tbrObj.supervisor>0 && scope.editEnc.tbrObj.deleted===false) {
							model.store.profs.get(scope.editEnc.tbrObj.supervisor, function(prof){
								def.supervisorName = prof.lastName + ", "+ prof.firstName;// + " (" +prof.code + ")"
							});
						}
						def.allEncTypes = EncounterAccessor.allEncTypes;
						def.userEncTypes = [];
						_.chain(def.allEncTypes).omit(function(value, key, object) {
							return parseInt(key) < 10;
						}).each(function(v, k, list){
							def.userEncTypes.push({k: parseInt(k), v: v});
						});
						def.userEncTypes = $filter('orderBy')(def.userEncTypes, 'v');
						if (scope.editEnc.tbcObj == undefined) {
							scope.editEnc.tbcObj = {};
							scope.editEnc.tbcObj.deleted = true;
						}
						if (scope.editEnc.tbrObj == undefined) {
							scope.editEnc.tbrObj = {};
							scope.editEnc.tbrObj.deleted = true;
						}
					},
					lstNote: function(def){
						def.model = model;
						def.multiple = true;
						def.noteTypes = scope.noteTypes;
						def.completeType = 20;
						def.isAllEmpty = function(item) {
							return OfysUtils.isAllEmpty(item, ['note','id']);
						};
						def.copyNote = function(str) {
							Markdown.copieStr = str;
						}
						def.pasteNote = function(item, editor) {
							if(editor && Markdown.copieStr){
								if(Markdown.copieStr.indexOf(Markdown.MD) > -1){
									editor.insertHTML(Markdown.toHTML(Markdown.copieStr.substring(Markdown.MD.length)));
									return;
								}
								editor.insertText(Markdown.copieStr)
							}
						}
						def.openTemplate = function(item, editor) {
							if(editor){
								editor.moveCursorToEndAndOpenAutocomplete();
							}
						}
						// Object.keys(EncounterAccessor.allNoteTypes).forEach(function(k){
						// 	var kInt = parseInt(k);
						// 	if(kInt < 101){
						// 		def.noteTypes.push({l:EncounterAccessor.allNoteTypes[k], val:kInt})
						// 	}
						// })
					},
					lstLifeHabit: function(def){
						def.habitTypes = scope.habitTypes;
						def.frequencyOptions = function(i){
							return scope.frequencyOptions[i];
						}
					},
					lstProb: function(def){
						def.dxStatus = scope.dxStatus
					},
					lstDx: function(def){
						def.dxStatus = scope.dxStatus;
					},
					lstDxEnc: function(def){
						def.showSummaryDxActive =  model.prefSettings('user_settings_ShowSummaryDxInEnc');
						def.dxStatus = scope.dxStatus;
						def.removeCode= function(viewbag){
							delete viewbag.searchDxCode;
							delete viewbag.item.classificationDiagnostic;
							delete viewbag.item.code;
							delete viewbag.item.codeId;
							delete viewbag.item.descrLong;
							delete viewbag.item.descrShort
						}
						def.isAllEmpty = function(item) {
							return OfysUtils.isAllEmpty(item, ['code','note', 'id']);
						}
						scope.editEnc.lstDxTemp = scope.quickViewData.pat.viewbag.patData.sum.lstDx;
						scope.editEnc.lstProbTemp = scope.quickViewData.pat.viewbag.patData.sum.lstProb;
						def.scrollSumDxEdit = function(item){
							$timeout(function(){
								if(item && item.viewbag && item.viewbag.scrollable && item.viewbag.scrollable.scrollToScreen){
									item.viewbag.scrollable.scrollToScreen()
								}
							}, 100)
						}
						def.showSummaryDx = function(){
							return scope.editEnc.editMode && ((scope.editEnc.lstDxTemp && scope.editEnc.lstDxTemp.length > 0) || (scope.editEnc.lstProbTemp && scope.editEnc.lstProbTemp.length > 0)) ;
						}
						def.hasSummaryDx = function(){
							return scope.editEnc.lstDxTemp && scope.editEnc.lstDxTemp.length > 0;
						}
						// not used
						def.addProbToDx = function(item){
							var currIdx = scope.editEnc.lstProbTemp.indexOf(item);
							item.modificationStatus = ModificationStatus.STATUS_UPDATED;
							scope.editEnc.lstDxTemp.push(item);
							scope.editEnc.lstProbTemp.splice(currIdx, 1);
						}
						// not used
						def.addDxToProb = function(item){
							var currIdx = scope.editEnc.lstDxTemp.indexOf(item);
							item.modificationStatus = ModificationStatus.STATUS_UPDATED;
							scope.editEnc.lstProbTemp.push(item);
							scope.editEnc.lstDxTemp.splice(currIdx, 1);
						}
						def.addDxFromSummary = function(dx){
							if(scope.editEnc.lstDxEnc === undefined){
								scope.editEnc.lstDxEnc = [];
							}
							var useCode = dx.codeId !== undefined;
							var useNote = dx.note !== undefined && dx.note !== "";
							function sameDx(e){
								if(useCode && e.codeId === dx.codeId){
									return true;
								}
								if(useNote && e.note === dx.note){
									return true;
								}
								return  false;
							}
							var notIncludedInEnc = (!scope.editEnc.lstDxEnc || scope.editEnc.lstDxEnc.find(sameDx) === undefined);
							if(notIncludedInEnc){
								var nDx = _.omit(angular.copy(dx), ['id']);
								nDx.status = 0;
								nDx.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
								nDx.mustHardDelete = true;
								scope.editEnc.lstDxEnc.push(nDx);
							}
						}
					},
					lstBloodPres: function(def){
						def.definedNone = definedNone;
						def.isAllEmpty = function(item) {
							return OfysUtils.isAllEmpty(item, ['systolic','diastolic','pulse','saturation','id']);
						};
					},
					lstMeasurement: function(def){
						def.definedNone = definedNone;
						def.patient = scope.quickViewData.pat;
						def.isAllEmpty = function(item) {
							return OfysUtils.isAllEmpty(item, ['weightS2','heightS1','waistMeasurementS1','headCircS1','id']);
						};
						def.system = {
							convertTo: function(t) {
								if (model.prefSettings('mesure_system')==1) {// 1=metric
									return 1;
								} else {
									if (t==='len') {
										return 0.3937007874;
									} else if (t==='pds') {
										return 2.204622622;
									}
								}
							},
							convertEN2SI: function(t, v) {
								if (v) {
									if (t==='len') {
										return OfysUtils.parseFloat(v)*2.54;
									} else if (t==='pds') {
										return OfysUtils.parseFloat(v)*0.45359237;
									}
								}
							},
							convertSI2EN: function(t, v) {
								if (v) {
									if (t==='len') {
										return OfysUtils.parseFloat(v)*0.3937007874;
									} else if (t==='pds') {
										return OfysUtils.parseFloat(v)*2.204622622;
									}									
								}
							},
							text: function(t) {
								if (model.prefSettings('mesure_system')==1) {
									if (t==='len') {
										return ' cm';
									} else if (t==='pds') {
										return ' kg';
									}								
								} else {
									if (t==='len') {
										return $filter('translate')('pouces');
									} else if (t==='pds') {
										return $filter('translate')('livres');
									}								
								}							
							}
						};
						
						def.onEdit = function(i){
							def.itemVal = i;	// après le edit (voir scope.encformOptions.editItem), on a un def.itemVal.viewbag.item
							return true;
						},
						def.onPostEdit = function(vbitem) {
							// les données sont tjrs conservées en val SI.
//							if (model.prefSettings('mesure_system')==2) {
//								vbitem.weight = def.system.convertSI2EN('pds',vbitem.weightS2);
//								vbitem.height = def.system.convertSI2EN('len',vbitem.heightS1);
//								vbitem.waistMeasurement = def.system.convertSI2EN('len',vbitem.waistMeasurementS1);
//								vbitem.headCirc = def.system.convertSI2EN('len',vbitem.headCircS1);
//								def.toString(vbitem);			
//							}
						},
						def.toString = function(item) {
							item.weightS2 = item.weight?$filter('dec2')(item.weight):'';
							item.heightS1 = item.height?$filter('dec1')(item.height):'';
							item.waistMeasurementS1 = item.waistMeasurement?$filter('dec1')(item.waistMeasurement):'';
							item.headCircS1 = item.headCirc?$filter('dec1')(item.headCirc):'';				
						};

						scope.resizeGrowChart = angular.noop;

						def.actions = [
							{
								act: function(){
									model.prefSettings('mesure_system', model.prefSettings('mesure_system')===1?2:1);
									if(model.prefSettings('mesure_system')==1){
										this.namei18n = 'system-metric';
//										if (def.itemVal && def.itemVal.viewbag) {
//											def.itemVal.viewbag.item.weight = def.system.convertEN2SI('pds',def.itemVal.viewbag.item.weightS2);
//											def.itemVal.viewbag.item.height = def.system.convertEN2SI('len',def.itemVal.viewbag.item.heightS1);
//											def.itemVal.viewbag.item.waistMeasurement = def.system.convertEN2SI('len',def.itemVal.viewbag.item.waistMeasurementS1);
//											def.itemVal.viewbag.item.headCirc = def.system.convertEN2SI('len',def.itemVal.viewbag.item.headCircS1);
//											def.toString(def.itemVal.viewbag.item);
//										}
									}else{
										this.namei18n = 'system-anglais';
//										if (def.itemVal && def.itemVal.viewbag) {
//											def.itemVal.viewbag.item.weight = def.system.convertSI2EN('pds',def.itemVal.viewbag.item.weightS2);
//											def.itemVal.viewbag.item.height = def.system.convertSI2EN('len',def.itemVal.viewbag.item.heightS1);
//											def.itemVal.viewbag.item.waistMeasurement = def.system.convertSI2EN('len',def.itemVal.viewbag.item.waistMeasurementS1);
//											def.itemVal.viewbag.item.headCirc = def.system.convertSI2EN('len',def.itemVal.viewbag.item.headCircS1);
//											def.toString(def.itemVal.viewbag.item);
//										}
									}
									model.actUpdated(true);
								},
								icon: 'fa-exchange',
								namei18n: (model.prefSettings('mesure_system')==1?'system-metric':'system-anglais'),
							},
							{
								act: angular.noop,
								popoverUrl:'/dashboard/resources/ofys/encounter/growth_curve.html?v=ba',
								type: 'popover',
								icon: 'fa-line-chart enc-growth-curve',
								namei18n: 'GrowthChart',
								placement: 'left'
							}
						];
						scope.growthChart = "";
						scope.invalidForGrowthCurve = function(patient, mesures){
							return mesures.length == 0 || !patient.birthDate || patient.age > 22
						}
						scope.closeGrowthView = function(hide){
							hide();
						};
						scope.getGrowthChart = function() {
							var growthChartData = {
									blackAndWhite: false
							};
							var Gender = {
								"I":'INCONNU',
								"M":'MASCULIN',
								"F": 'FEMININ'
							};
							var pat = def.patient;// model.patient();
							growthChartData.pat = PatientUtils.getSuperCleanPatient(pat);
							growthChartData.gender = Gender[growthChartData.pat.gender];
							growthChartData.measurementsForGraph = [];
							var activeItem = def.itemVal && def.itemVal.viewbag ? def.itemVal.viewbag.item : def.itemVal;
							var mesureIds=[];
							if (activeItem && activeItem.timeVitalSignS && (activeItem.weight || activeItem.height)) {
								var mesure = angular.copy(activeItem);
								mesure.timeVitalSign = moment(mesure.timeVitalSignS).valueOf();
								mesure.entryDatetime = mesure.timeVitalSign;
								if (mesure.id) {
									mesureIds.push(mesure.id);
								} else {
									mesure.id = -1;										
								}
								growthChartData.measurementsForGraph.push(mesure);
							}
							if(scope.editEnc && scope.editEnc.lstMeasurement && scope.editEnc.lstMeasurement.length>0) {
								var mesures = scope.editEnc.lstMeasurement.filterFast(function(a){return a.editMode!==true;});
								if (mesures.length>0) {
									for(var j=0; j < mesures.length; j++){
										if (mesures[j].id) {
											mesureIds.push(mesures[j].id);
										}
										mesures[j].timeVitalSign = moment(mesures[j].timeVitalSignS).valueOf();
										mesures[j].entryDatetime = mesures[j].timeVitalSign;
										growthChartData.measurementsForGraph.push(mesures[j]);
									}
								}
							}
							
							if(pat.viewbag && pat.viewbag.patData.sum && pat.viewbag.patData.sum.lstMeasurement){
								var mesures = angular.copy(pat.viewbag.patData.sum.lstMeasurement);
								for(var i=0; i < mesures.length; i++){
									if (_.contains(mesureIds, mesures[i].id)) {
										continue;
									}
									mesures[i].entryDatetime = mesures[i].timeVitalSign;
									growthChartData.measurementsForGraph.push(mesures[i]);
								}
							}
							if (growthChartData.measurementsForGraph.length>0) {
								DocAccessor.growthChart(growthChartData,function(res){
									scope.growthChart = res;
								});									
							}
						};
						
						def.hasLastHeight = function(){
							if(scope.getPatient().age >= 20 && !def.lastHeight && 
									(scope.getPatient().viewbag && scope.getPatient().viewbag.patData.sum && scope.getPatient().viewbag.patData.sum.lstMeasurement &&
									scope.getPatient().viewbag.patData.sum.lstMeasurement.length > 0)){
								def.lastHeight = []
								let birthdate = new Date(scope.getPatient().birthDate);
								birthdate.setFullYear(birthdate.getFullYear() + 20);
								for(let i = 0; i < scope.getPatient().viewbag.patData.sum.lstMeasurement.length; i++){
									if(scope.getPatient().viewbag.patData.sum.lstMeasurement[i].heightS1){
										let index = scope.getPatient().viewbag.patData.sum.lstMeasurement[i].descrTitle.findIndex(e => e == "Date");
										let measurementDate = new Date(scope.getPatient().viewbag.patData.sum.lstMeasurement[i].descr[index]);
										if(measurementDate > birthdate){
											let height = scope.getPatient().viewbag.patData.sum.lstMeasurement[i].heightS1
											def.lastHeight.push({measurementDate, height});
										}
									}
								}
								def.lastHeight.sort((a,b) => a.measurementDate < b.measurementDate);
							}
							return def.lastHeight && def.lastHeight.length > 0;
						}
						def.getClosestHeight = function(date){
							if(def.hasLastHeight()){
								for(let i = 0; i < def.lastHeight.length; i++){
									if(def.lastHeight[i].measurementDate <= date){
										return def.lastHeight[i].height
									}
								}
							}
							return undefined;
						}
						def.lastHeight = undefined;
						def.getIMC = function(item){
							closestHeight = def.getClosestHeight( new Date(item.timeVitalSignS));
							if (item && item.weightS2 && (item.heightS1 || closestHeight)) {
								var w;
								var h;
//								if (model.prefSettings('mesure_system')==2) {
//									w = def.system.convertEN2SI('pds',item.weightS2);
//									h = def.system.convertEN2SI('len',item.heightS1);									
//								} else {
									w = OfysUtils.parseFloat(item.weightS2);
									h = OfysUtils.parseFloat(item.heightS1 ? item.heightS1 : closestHeight);
//								}
								if (w != NaN && h != NaN  && w > 5 && h > 75) {
									// pas d'IMC pour les valeurs extrêmes < 5kg et <75cm - ad enfant 2 ans
									var hM = (h/100) //taille en metre
									var imc = w /(hM*hM);
									item.IMC = Math.round( imc * 10 ) / 10;//Un chiffre après le 0;	
									return item.IMC;
								}
							}
							return '';
						};
						def.onSave = function(modifyItem, originalItem, def, skipPresave){
//							if (model.prefSettings('mesure_system')==2) {
//								if(modifyItem.weightS2 && modifyItem.heightS1){
//									modifyItem.IMC = this.getIMC(modifyItem);
//								}
//								modifyItem.weight = def.system.convertEN2SI('pds',modifyItem.weightS2);
//								modifyItem.height = def.system.convertEN2SI('len',modifyItem.heightS1);
//								modifyItem.waistMeasurement = def.system.convertEN2SI('len',modifyItem.waistMeasurementS1);
//								modifyItem.headCirc = def.system.convertEN2SI('len',modifyItem.headCircS1);
//								def.toString(modifyItem);
//							} else {
								if(modifyItem.weightS2){
									if (modifyItem.heightS1) {
										modifyItem.IMC = this.getIMC(modifyItem);
									}
									// setter lastMesure au besoin
									var pat = scope.getPatient();
									var ms = pat.viewbag.patData.sum.lastMesure;
									var lastTimeVitalSign = ms && ms.timeVitalSign ? ms.timeVitalSign : 0;
									var newMs = pat.viewbag.patData.sum.newLastMesure;	// utilisé par le calculateur de dose
									var newLastTimeVitalSign = newMs && newMs.timeVitalSign && newMs.timeVitalSign > lastTimeVitalSign ? newMs.timeVitalSign : lastTimeVitalSign;
									modifyItem.timeVitalSign = moment(modifyItem.timeVitalSignS).valueOf();
									if (modifyItem.timeVitalSign > newLastTimeVitalSign) {
										pat.viewbag.patData.sum.newLastMesure = modifyItem;
									}
								}
//							}
							return true;
						};
						def.onPreSave = def.onSave;
					},
					lstCustMeasure: function(def){
						def.definedNone = definedNone;
						def.isAllEmpty = function(item) {
							return OfysUtils.isAllEmpty(item, ['typeCode','typeName','avalue','id']);
						};
					},
					lstBodyTemp: function(def){
						def.tempTypes = EncounterAccessor.allBodyTemperatureType;
						def.isAllEmpty = function(item) {
							return OfysUtils.isAllEmpty(item, ['bodyTemperature','note','id']);
						};
					},
					lstFreq: function(def){
						def.isAllEmpty = function(item) {
							return OfysUtils.isAllEmpty(item, ['respiration','note','id']);
						};
					},
					lstBilling: function(def){
						def.isAllEmpty = function(item) {
							return OfysUtils.isAllEmpty(item, ['cod1','ctx1','cod2','ctx2','cod3','ctx3','timeBilling','note','id']);
						};
					},
					lstRaison: function(def){
						def.isAllEmpty = function(item) {
							if (OfysUtils.isAllEmpty(item, ['reason','id'])) {
								if (item.visitReason) {
									return OfysUtils.isAllEmpty(item.visitReason, ['code', 'id']);
								}
								return true;
							}
							return false;
						};
					},
					lstPhysicalExam: function(def){
						def.isAllEmpty = function(item) {
							return OfysUtils.isAllEmpty(item, ['note','id']);
						};
					},
					lstAllergy: function(def){
						def.severityStatus = scope.severityStatus
					},
					lstIntolerance: function(def){
						def.severityStatus = scope.severityStatus
					},
					lstImmunization: function(def){
						def.isAllEmpty = function(item) {
							return OfysUtils.isAllEmpty(item, ['code','vaccineName','note','id']);
						};
						def.removeCode = function (viewbag) {
							delete viewbag.searchDxCode;
							delete viewbag.item.classificationDiagnostic;
							delete viewbag.item.code;
							delete viewbag.item.codeId;
							delete viewbag.item.descrLong;
							delete viewbag.item.descrShort
						}
					},
					lstPrescription: function(def){
						def.patient = scope.quickViewData.pat;
						def.model = model;
						if (scope.editEnc.encounterType>9) {
							var vb = def.patient.viewbag ? def.patient.viewbag : {};
							def.actions = [
								{
									hideFn: inReadOnlyMode,
									type: 'label',
									text: (vb.creatinine_cl ? 
											$filter('translate')('CL_CREATININE') + vb.creatinine_cl : 
												(vb.creatinine ? $filter('translate')("CREATININE") + ": " + vb.creatinine + vb.creatinine_unit + " (" + vb.creatinine_date + ")"  : $filter('translate')("CREATININE"))),
									// cl_creatinine = un float - permet d'afficher la sévérité avec un icone et couleur
									title: (vb.creatinine ? $filter('translate')("CREATININE") + ": " + vb.creatinine + vb.creatinine_unit  + " (" + vb.creatinine_date + ")" : $filter('translate')('NO_DATA') ),
									// creatinine_text = val creat en mmol/L (date du test).
									icon: (vb.creatinine_cl ? 
											(vb.creatinine_cl > 60 ? 'fa-check-circle-o green2' : 
												(vb.creatinine_cl >= 30 ? 'fa-warning gold' : 'fa-warning red')) : 'fa-question-circle')
								},
								{
									id: 'represcribe',
									hideFn: inReadOnlyMode,
									act: function(){
										if(scope.togglePrescriptionModes(!scope.linkModeOn, LinkMode.REPRESCRIBEMODE)){
											if(!scope.linkModeOn){
												this.icon = 'fa-retweet';
												this.namei18n = 'represcribe';
												def.actions[def.stopMedActionIndex].hide = false;
												def.hideSectionAddButton = false;
											}else{
												this.icon = 'fa-check lightgreen fa-lg';
												this.namei18n = 'endreprescribe';
												def.actions[def.stopMedActionIndex].hide = true;
												def.hideSectionAddButton = true;
											}
											model.actUpdated(true);
										}
									},
									icon: 'fa-retweet',
									namei18n: 'represcribe',
								},
								{
									id: 'stopMed',
									hideFn: inReadOnlyMode,
									act: function(){
										if(scope.togglePrescriptionModes(!scope.linkModeOn, LinkMode.MED_STOP_MODE)){
											if(!scope.linkModeOn){
												this.icon = 'fa-ban';
												this.namei18n = 'MedStop_Stop';
												def.actions[def.represcribeActionIndex].hide = false;
												def.hideSectionAddButton = false;
											}else{
												this.icon = 'fa-ban lightgreen fa-lg';
												this.namei18n = 'endMedStop_Stop';
												def.actions[def.represcribeActionIndex].hide = true;
												def.hideSectionAddButton = true;
											}
											model.actUpdated(true);
										}
									},
									icon: 'fa-ban',
									namei18n: 'MedStop_Stop',
								},
								{
									id: 'medRxTimes',
									type: 'popover',
									hideFn: inReadOnlyMode,
									placement: 'auto top',
									popoverUrl: '/dashboard/resources/ofys/encounter/entry/medRxTimes_popover.html?v=ba',
									act: function(item){
										// TODO popover un spinner et ok annuler
									},
									icon: 'fa-times',
									namei18n: 'MedRxTimes',
									title: $filter('translate')('MedRxTimes_title')
								}
							];
						} else {
							def.actions = [];
						}
						def.represcribeActionIndex = def.actions.findIndex(function(e){return e.id === 'represcribe'});
						def.stopMedActionIndex = def.actions.findIndex(function(e){return e.id === 'stopMed'});

						var formatLiquid = new Array(197,207,208,209,212,223,224,225,226,227,228,229);
						def.isFormatLiquid = function(rx){
							return rx&&rx.format ? formatLiquid.indexOf(rx.format)>-1 : false;
						};
						
						def.isAllEmpty = function(item) {
							return OfysUtils.isAllEmpty(item, ['baseDrugName','posology','strength','din','note','id']);
						};
						def.rxTypes = _.omit(EncounterAccessor.allRxType, 3);//sans fourniture
						def.isPrescription = true;
						def.viewRxvInter = function(key, val, def, skipModal){
							def.activeInterKey = key;
							def.activeInterVal = val;
							if(!skipModal){
								FlView.open({templateUrl: "/dashboard/resources/ofys/encounter/interaction.html?v=ba",
								def: def}).then(function(){
								});
							}
						};
						def.viewInter = function(key, val, def, skipModal){
							def.activeInterKey = key;
							def.activeInterVal = val;
							if(!skipModal){
								FlView.open({templateUrl: "/dashboard/resources/ofys/encounter/interaction.html?v=ba",
									def: def}).then(function(){
									});
							}
						};
						def.toggleDosageChange = function(item) {
							if (item.dosageChange === undefined) {
								item.dosageChange = 0;
						}
							item.dosageChange = item.dosageChange==3 ? 0 : item.dosageChange+1;
						};

						if(!def.listItemActions){
							def.listItemActions= []
						}
						def.listItemActions.push({
							type:'popover',
							icon: 'fa-ban',
							clickName: 'stopMed',
							namei18n: 'stopMed',
							show: function(){
								return  scope.editEnc.editMode ;
							},
							popoverUrl: '/dashboard/resources/ofys/encounter/entry/stopPrescription_popover.html?v=ba'
						});
						def.listItemActions.push($.extend(EncounterSummaryCommon.favActionBtn, {show: function(){
							return true;/* scope.viewOptions.editMode ;*/
						},}));

						def.showRxvAnalyse = function(def, item) {
							rxvigilance.openRxViglanceService(rxvigilance.getPerspective, item.analyseInEncRxv.rxvEngineOutput, undefined, item.analyseInEncRxv);					
						};
						def.analyse = function(item, def){
							if (rxvigilance.isActive()) {
								var items = [item];
								// l'analyse dans une recontre est différente de l'analyse auto quand on selectionne un pt
								if (item.analyseInEncRxv===undefined) item.analyseInEncRxv = {};
								item.analyseInEncRxv.isWorking = true;
								rxvigilance.openRxViglanceService(rxvigilance.engineQueryJsonShow, def.patient, items, item.analyseInEncRxv);
							} else {
								var input = {profile: []}
								function flattenAndReady(lst){
									for (let i = 0; i < lst.length; i++) {
										var it = {};
										if(lst[i].viewbag && lst[i].viewbag.item){
											it = angular.copy(lst[i].viewbag.item);
										}else{
											it = angular.copy(lst[i])
										}
										if(!_.isEmpty(it)){
											delete it.viewbag;
											input.profile.push(it);
										}
									}
								}
								if(def.patient.viewbag.patData.sum.lstPrescription){
									// console.log("yes");
									input.profile = input.profile.concat(def.patient.viewbag.patData.sum.lstPrescription);
								}
								flattenAndReady(scope.editEnc.lstPrescription);
								EncounterAccessor.rxinteractions(input, function(res){
									for (let i = 0; i < res.data.length; i++) {
										res.data[i].last_update = res.data[i].updated_at.substring(0, 12);
									}
									def.analyseActive = true;
									def.analyseIndexedByType = _.groupBy(res.data, 'significance');
									//console.log(res);
								});
							}
						}
					},
					lstDevice: function(def){
						forEntryDef.lstPrescription(def);
						def.isDevice = true;
						def.isAllEmpty = function(item) {
							return OfysUtils.isAllEmpty(item, ['name', 'posology', 'note','id']);
						};
						if (scope.editEnc.encounterType>9) {
							def.actions = [
								{
									id: 'represcribe',
									hideFn: inReadOnlyMode,
									act: function(){
										if(scope.togglePrescriptionModes(!scope.linkModeOn, LinkMode.DEVICEREPRESCRBE)){
											if(!scope.linkModeOn){
												this.icon = 'fa-retweet';
												this.namei18n = 'represcribe';
													def.actions[def.stopMedActionIndex].hide = false;
												def.hideSectionAddButton = false;
											}else{
												this.icon = 'fa-check lightgreen fa-lg';
												this.namei18n = 'endreprescribe';
													def.actions[def.stopMedActionIndex].hide = true;
												def.hideSectionAddButton = true;
											}
											model.actUpdated(true);
										}
									},
									icon: 'fa-retweet',
									namei18n: 'represcribe',
								},
								{
									id: 'stopMed',
									hideFn: inReadOnlyMode,
									act: function(){
										if(scope.togglePrescriptionModes(!scope.linkModeOn, LinkMode.DEVICEMED_STOP_MODE)){
											if(!scope.linkModeOn){
												this.icon = 'fa-ban';
												this.namei18n = 'MedStop_Stop';
												def.actions[def.represcribeActionIndex].hide = false;
												def.hideSectionAddButton = false;
											}else{
												this.icon = 'fa-ban lightgreen fa-lg';
												this.namei18n = 'endMedStop_Stop';
												def.actions[def.represcribeActionIndex].hide = true;
												def.hideSectionAddButton = true;
											}
											model.actUpdated(true);
										}
									},
									icon: 'fa-ban',
									namei18n: 'MedStop_Stop',
								}
							];
						} else {
							def.actions = [];
						}
						def.represcribeActionIndex = def.actions.findIndex(function(e){return e.id === 'represcribe'});
						def.stopMedActionIndex = def.actions.findIndex(function(e){return e.id === 'stopMed'});
						
						def.rxTypes = _.omit(EncounterAccessor.allRxType, [0,1,2]);//only fourniture
						if(!def.listItemActions){
							def.listItemActions= [];
						}
						def.listItemActions.push(EncounterSummaryCommon.deviceFavActionBtn);
					},
					lstDoc: function(def){
						def.hideSectionAddButton = true;
						def.ngIf = function(item) {
							return ((item.atype === 2 && scope.encFormOptions.isDirty() !== 2) || (item.atype !== 2 && scope.encFormOptions.isDirty() === 2 )) 
							&& !inReadOnlyMode();
						};
						def.actions = [
							{
								//icon: 'fa-list-alt',
								type: 'group',
								hideFn: inReadOnlyMode,
								//namei18n: 'Forms',
								actions: [
									{
										type: 'popover-frm',
										formType: 1,
										popoverUrl: '/dashboard/resources/ofys/eform/selectAddNewForm.html?v=ba',
										icon: 'fa-plus',
										placement: 'left',
										namei18n: 'Form',
										title: 'SELECT_AND_ADD_FORM',
									},
									{
										type: 'popover-frm',
										formType: 2,
										popoverUrl: '/dashboard/resources/ofys/eform/selectAddNewForm.html?v=ba',
										icon: 'fa-plus',
										placement: 'left',
										namei18n: 'FORMS_CRDS',
										title: 'ADD_FORM_CRDS',
									},
									{
										type: 'popover-frm',
										formType: 3,
										popoverUrl: '/dashboard/resources/ofys/eform/selectAddNewForm.html?v=ba',
										icon: 'fa-plus',
										placement: 'left',
										namei18n: 'FORMS_CNESST',
										title: 'ADD_FORM_CNESST',
									},
									{
										type: 'popover-frm',
										formType: 4,
										popoverUrl: '/dashboard/resources/ofys/eform/selectAddNewForm.html?v=ba',
										icon: 'fa-file-o',
										placement: 'left',
										namei18n: 'Modify',
										title: 'ModifyPatientForm',
									},
									{
										type: 'popover-frm',
										formType: 5,
										placement: 'left',
										popoverUrl: '/dashboard/resources/ofys/eform/selectAddNewForm.html?v=ba',
										icon: 'fa-clone',
										namei18n: 'COPY',
										title: 'CopyPatientForm',
									}
								]
							},
							{
								hideFn: inReadOnlyMode,
								act: function(){
									def.toggleLinkMode();
								},
								icon: 'fa-paperclip',
								namei18n: 'EncAttachDoc',
								title: 'EncAttachDocument',
							},							
						];
						// console.log(model.user().profil);
						def.patient = scope.quickViewData.pat;
						def.multiple = true;
						def.hasOkPlusBtn = false;
						def.openDoc = scope.openDoc;
						def.printDoc = scope.printDoc;
						def.faxDoc = scope.faxDoc;
						def.removeLink = scope.removeLink;
						def.toggleLinkMode = scope.toggleLinkMode;
						def.linkModeOn = scope.linkModeOn;
						def.setUpdated = function(item) {
	                    	item.modificationStatus = ModificationStatus.STATUS_UPDATED;
						};
//						def.addUrlLink = function(url){
//							var link = {
//								atype: 1,
//								idDocument: url.id,
//								description: url.description,
//								idProfessionnalAnchor: model.user().profil.id,
//								modificationStatus: ModificationStatus.STATUS_NEW_UPDATED
//							};
//							scope.editEnc.lstDoc.unshift(link);
							// id;
							// idProfessionnalAnchor;
							// idNextModificationEntry;
							// entryDate;
							// entryDateS;
							// idDocumentsAnchor;
							// title = "Documents liés";
//						}
						/* Utility function to convert a canvas to a BLOB */
						var dataURLToBlob = function(dataURL) {
							var BASE64_MARKER = ';base64,';
							if (dataURL.indexOf(BASE64_MARKER) == -1) {
								var parts = dataURL.split(',');
								var contentType = parts[0].split(':')[1];
								var raw = parts[1];

								return new Blob([raw], {type: contentType});
							}

							var parts = dataURL.split(BASE64_MARKER);
							var contentType = parts[0].split(':')[1];
							var raw = window.atob(parts[1]);
							var rawLength = raw.length;

							var uInt8Array = new Uint8Array(rawLength);

							for (var i = 0; i < rawLength; ++i) {
								uInt8Array[i] = raw.charCodeAt(i);
							}

							return new Blob([uInt8Array], {type: contentType});
						}

						
						function convertDataURIToBinary(dataURI) {
							var BASE64_MARKER = ';base64,';
							var base64Index = dataURI.indexOf(BASE64_MARKER) + BASE64_MARKER.length;
							var base64 = dataURI.substring(base64Index);
							var raw = window.atob(base64);
							var rawLength = raw.length;
							var array = new Uint8Array(new ArrayBuffer(rawLength));
							
							for(var i = 0; i < rawLength; i++) {
								array[i] = raw.charCodeAt(i);
							}
							return array;
						}
						/* End Utility function to convert a canvas to a BLOB      */
						def.uploadPhotos = function(item){
							if(item && item.viewbag && item.viewbag.uploadDoc){
								// Read in file
								var file = item.viewbag.uploadDoc;
								
								// console.log(file);
								var kb = Math.round(file.size/1024);
								if(kb > 5120){
									item.viewbag.fileTooBig = true;
									return;
								}else{
									delete item.viewbag.fileTooBig;
								}
								// Ensure it's an image
								// if(file.type.match(/image.*|application.*/)) {
								if(file.type) {
									console.log('An image has been loaded');
			
									// Load the image
									var reader = new FileReader();
									reader.onload = function (readerEvent) {
										if(file.type == 'application/pdf'){
											var input = {
												rawImage: readerEvent.target.result,
												sanitizedImage: readerEvent.target.result,
												file: file,
											};
											item.viewbag.uploadImage = defaultImage(input, def.patient, item);
										}else{
											var image = new Image();
											image.onload = function (imageEvent) {
				
												// Resize the image
												var canvas = document.createElement('canvas'),
													max_size = 900,// TODO : pull max size from a site config
													width = image.width,
													height = image.height;
												if (width > height) {
													if (width > max_size) {
														height *= max_size / width;
														width = max_size;
													}
												} else {
													if (height > max_size) {
														width *= max_size / height;
														height = max_size;
													}
												}
												canvas.width = width;
												canvas.height = height;
												canvas.getContext('2d').drawImage(image, 0, 0, width, height);
												var dataUrl = canvas.toDataURL('image/jpeg');
												var resizedImage = dataURLToBlob(dataUrl);
												$.event.trigger({
													type: "imageResized",
													blob: resizedImage,
													url: dataUrl
												});
												// if(item.viewbag.imgUpload){
												// 	item.viewbag.imgUpload[0].src = dataUrl;
												// }
												// if(!item.viewbag.uploadImage){
													var input = {
														rawImage: readerEvent.target.result,
														sanitizedImage: dataUrl,
														file: file,
													};
													item.viewbag.uploadImage = defaultImage(input, def.patient, item);
												// }
											}
											image.src = readerEvent.target.result;

										}
										
									}
									reader.readAsDataURL(file);
								}
								
							}
						};

						function getDocProf(){
							var prof = model.user().profil;
							var time = moment().valueOf();
							return {
								idProf:prof.id,
								dateAssigned: time,
								seenDatetime: time,
								modificationStatus: ModificationStatus.STATUS_NEW_UPDATED, 
								st: ['SEEN'], 
								activeSt: ['SEEN']
							};
						}

						function defaultImage (input, pat, item){
							var act = {
								rawImage:input.rawImage, 
								modificationStatus: ModificationStatus.STATUS_NEW_UPDATED, 
								sanitizedImage: input.sanitizedImage,
								picture: Array.from(convertDataURIToBinary(input.sanitizedImage)),
								className: "CBasePatientImage",
								date: moment().format("YYYY-MM-DD"),
								isNew: true,
								profs:[],
								idPatient: pat.id,
								patient: PatientUtils.getSuperCleanPatient(pat),
								pictureUpload: true,
							};
							var docProf = getDocProf();
							if(docProf){
								act.profs.push(docProf);
							}

							var ext = input.file.name.split('.').pop().toLowerCase();
							if(ext === 'jpg' || ext === 'png' || ext === 'jpeg' || ext === 'gif'){
								act.t = 'imgviewer';
							}else if(ext === 'pdf'){
								act.t = 'pdfviewer'
							}
							var res = patientShowTitles.getQVPayLoad(act, { onCancel: (function(doc){
								return function(doc){ onNewDocumentCancel(item) ;}
							})(), onSaveSuccess: (function(){return function(doc){onNewDocumentSaveSuccess(doc, item)}})()}, pat)
							if(res.quickViewData && res.quickViewData.qvActData){
								res.quickViewData.qvActData.viewbag = {notesSectionInactive: true};
								res.quickViewData.qvActData.prop = {readonly:false, edit: true};
							}
							return res;
						}
						function onNewDocumentCancel(item){
							unregisterDirty(item)
							if(item && item.viewbag && item.viewbag.uploadFileName && item.viewbag.uploadFileName[0]){
								delete item.viewbag.uploadImage;
								item.viewbag.uploadFileName[0].value = "";
							}
						}
						function onNewDocumentSaveSuccess(doc, item){
							attachDocument(doc);
							onNewDocumentCancel(item)
						}
						function unregisterDirty(item){
							if(item && item.viewbag && item.viewbag.uploadImage && 
								item.viewbag.uploadImage.quickViewData &&
								item.viewbag.uploadImage.quickViewData.qvActData &&
								item.viewbag.uploadImage.quickViewData.qvActData.unregisterDirty){
								item.viewbag.uploadImage.quickViewData.qvActData.unregisterDirty();
							}
						}
						def.onCancel = function(item){
							unregisterDirty(item)
							scope.toggleLinkMode(false);
							return true;
						}
						def.onEdit = function(item){
							PrefAccessor.getWebLinks(null,function(res){
								def.urls = res;
							});

							// scope.toggleLinkMode(2);
							var shouldEdit = _.isEmpty(item);
							return shouldEdit;
						}
						def.onSave = function(modifyItem, originalItem, def, skipPresave){
							if(originalItem.viewbag.uploadImage){
								if(originalItem.viewbag.uploadImage.quickViewData && originalItem.viewbag.uploadImage.quickViewData.qvActData &&
									originalItem.viewbag.uploadImage.quickViewData.qvActData.save){
									originalItem.viewbag.uploadImage.quickViewData.qvActData.save().then(function(){
										scope.encFormOptions.cancelItemEdit(originalItem, def, false)
									})
								}
							}else{
								scope.encFormOptions.cancelItemEdit(originalItem, def, false)
								// scope.toggleLinkMode(false);
							}
							return false;
						}
					}
				}
				scope.saveActiveDocState = function(){
					var cd = scope.enc.viewbag.currentdoc;
					if(cd && cd.act && cd.act.presave){
						cd.act.presave(true);
					}
				}
				scope.testCloseForm = false;
				scope.setActiveDoc = function(i){
					scope.saveActiveDocState();

					scope.testCloseForm = true;
					if(i == undefined){
						delete scope.enc.viewbag.currentdoc
						scope.qv.isDirty = qvDirty;
					}else{
						if(scope.enc.activeDocs && i !== scope.enc.activeDocs.indexOf(scope.enc.viewbag.currentdoc)){
							var dl = scope.enc.activeDocs.length
							if(i > -1 && i < dl){
								setCurrentDoc(scope.enc.activeDocs[i]);
							}
						}
					}
					$timeout(function(){
						scope.testCloseForm = false;
					}, 1000)
				}

				function setFormLinkObjects(){
					scope.enc.addedLinks = scope.enc.viewbag.currentdoc.act.addedLinks;
					scope.enc.initLinking = function(linkVars){
						linkVars.forEach(function(e){
							if(!scope.enc[e] && scope.enc.viewbag.currentdoc.act[e]){
								scope.enc[e] = scope.enc.viewbag.currentdoc.act[e];
							}else if(scope.enc[e] && !scope.enc.viewbag.currentdoc.act[e]){
								scope.enc.viewbag.currentdoc.act[e] = scope.enc[e];
							}
							if(scope.enc.viewbag.currentdoc.act.viewbag){
								scope.enc.viewbag.currentdoc.act.viewbag[e] = scope.enc.viewbag.currentdoc.act[e];
							}
						})
					}
				}

				scope.closeOpenDoc = function(i, onDocClosed){
					var cd = scope.enc.viewbag.currentdoc;
					if(!cd && scope.enc.activeDocs && scope.enc.activeDocs[i]){
						cd = scope.enc.activeDocs[i]
					}
					function onCloseReady(){
						cleanUpActiveDocs(i);
						onDocClosed();
					}
					if(cd && cd.act && cd.act.closeContext){
						cd.act.closeContext(cd.act,onCloseReady)
					}else if(cd && cd.act && cd.act.cancel){
						cd.act.cancel();
						onCloseReady();
					}else{
						//the form possibly failed to open (due to opening error e.g 
						//CRDS cant load) the user should still be able to close it in 
						//the viewer.
						onCloseReady();
					}
				}

				function cleanUpActiveDocs(i){
					if(scope.enc.viewbag.currentdoc == scope.enc.activeDocs[i]){
						scope.qv.isDirty = qvDirty;
						delete scope.enc.viewbag.currentdoc;
					}
					if(scope.enc.activeDocs){
						var dl = scope.enc.activeDocs.length
						if(i > -1 && i < dl){
							scope.enc.activeDocs.splice(i, 1);
						}
					}
				}

				scope.partialDateOptions = {
					hasCalendar: false
				};

				scope.removeOpenDoc = function(i){
					scope.closeOpenDoc(i, angular.noop);
				}

				scope.addForm = function(frm, type){
					if(!type || type < 4){
						newForm(frm);
					}else if( type === 4){
						$timeout(function(){
							editForm(frm, type);
						}, 0);//Avoid dynassit issues when changing the ui immediately
					}else if(type === 5){
						copyForm(frm, type)
					}
				}

				function copyForm(frmData, type){
					var patient = scope.quickViewData.pat;
					
					FormAccessor.copyData({formDataId:frmData.id, patientId:patient.id}, function(resData){
						addFormToActiveDocs(resData, patient);
						model.actUpdated(true);
					});
				}

				function editForm(frm, type){
					var patient = scope.quickViewData.pat;
					addFormToActiveDocs(frm, patient);
				}

				//Called when a new form is saved to attach to the encounter.
				function newFormOnSave(frm, frmOptions){
					var previousForm = frmOptions.previousForm
					console.log("Form saved ready for attaching");
					
					var l = attachDocument(frm, previousForm);
					if(frm.form.type !==3 && frm.form.type !==2){
						scope.removeOpenDoc(scope.enc.activeDocs.indexOf(scope.enc.viewbag.currentdoc));
					}
					frmOptions.previousForm = l;
					scope.commitForPresave(l, "lstDoc")
				}

				function newForm(form){
					var patient = scope.quickViewData.pat;
					if (form.type===2) {
						model.loadingOverlay().show('LOADING_CRDS_FORM', true);
					}
					FormAccessor.newData({formId: form.id, patientId:patient.id }, function(resData){
						addFormToActiveDocs(resData, patient);

						if (form.type===2) {
							model.loadingOverlay().hide();
						}
						if (form.type===3 && scope.cnesstprefillFrm) {
							resData.prefillForm = scope.cnesstprefillFrm;
						}
					}, function(){
						model.loadingOverlay().hide();								
					});
				}
				function alreadyOpened(previousForm){
					if(previousForm && scope.enc.viewbag && scope.enc.activeDocs && scope.enc.activeDocs.length > 0){
						return scope.enc.activeDocs.findIndex(function(e){return e.act.id === previousForm.idDocument;})
					}else{
						return -1;
					}
				}
				function setFormToEditMode(act){
					if(act.isModifiable){
						if(!act.prop){
							act.prop = {};
						}
						act.prop.readonly = act.cnesstRefNo!==undefined;
						act.editMode = act.cnesstRefNo===undefined;
					}
				}
				function addFormToActiveDocs(formData, patient, previousForm){
					setFormToEditMode(formData);
					var alreadyOpenedDoc = alreadyOpened(previousForm);
					var docpayload
					if(alreadyOpenedDoc < 0){
						var newOptions = angular.copy( scope.quickViewData.options);
						newOptions.hasTitle = false;
						newOptions.addEvents = false;
						newOptions.onSaveSuccess = newFormOnSave;
						newOptions.previousForm = previousForm;
						newOptions.updateDoc = function(newDoc, previousDoc){
							if(previousDoc){
								scope.removeOpenDoc(scope.enc.activeDocs.findIndex(function(e){return e.act.id === previousDoc.idDocument;}));
							}
							addFormToActiveDocs(newDoc, patient, previousDoc)
						};
						// il faut mettre le new CFormdata dans la liste form et frm9 (type du form).
						if (formData.patient === undefined) {
							formData.patient = _.omit(patient, 'viewbag');	// formData est un CFormData. J'ai besoin du patient pour les autofill qui se font au chargement du form.
						}
						formData.editMode = true;
						if(!scope.enc.activeDocs){
							scope.enc.activeDocs = [];
						}
						
						docpayload = {options: newOptions, act: formData, name: formData.form.name};
						var newIndex = scope.enc.activeDocs.push(docpayload) - 1;
						docpayload.act.closeActivity = function(){
							scope.removeOpenDoc(newIndex)
						}
					}else{
						docpayload = scope.enc.activeDocs[alreadyOpenedDoc]
					}
					
					setCurrentDoc(docpayload)
					// patientShowTitles.openActivity(resData, newOptions, scope.patient);
				}

				function delegateAct(){
					if(scope.enc && 
						scope.enc.viewbag && 
						scope.enc.viewbag.currentdoc && 
						scope.enc.viewbag.currentdoc.act){
						return scope.enc.viewbag.currentdoc.act;
					}else{
						//This activity has no delegate so the activity is returned.
						return scope.enc;
					}
				}

				function setCurrentDoc(act){
					scope.enc.viewbag.currentdoc = act;
					scope.enc.delegateActivity = delegateAct;
					setFormLinkObjects();
				}

				function definedNone(obj, propArr){
					for (var i = 0; i < propArr.length; i++) {
						if(obj[propArr[i]]){
							return false;
						}
					}
					return true
				}
				function initProp(obj, prop, val){
					if(obj && !obj[prop]){
						obj[prop] = val
					}
				}
				var forEdit = {
					lstNote: function(item){
						item.viewbag.confirmBeforeCancel = true;
						item.viewbag.onChangeEditState = function(item, def){
							if(item.viewbag.focusNote){
								item.viewbag.focusNote()
							}
						};
					},
					lstIntervention: function(item){
						item.viewbag.dateDynaDateOptions = {
							format: 'YYYY-MM-DD',
							acceptFutureDate: false,
							onDateSelected: function (mDate, dAssist) {
								// var m = mDate.format(dAssist.format);
								// item.viewbag.item.entryDateS = m;
							}
						};
					},
					lstRaison: function(item){
						if (item.viewbag.item.visitReason===undefined) item.viewbag.item.visitReason = {};
						item.viewbag.selectDx = function(dx) {
							if (item.viewbag.item.visitReason === undefined) item.viewbag.item.visitReason = {};
							item.viewbag.item.visitReason.id = dx.id;
							item.viewbag.item.visitReason.code = dx.code;
							item.viewbag.item.visitReason.classification = dx.classification;
							item.viewbag.item.visitReason.descriptionShort = dx.descriptionShort;
							item.viewbag.item.visitReason.descriptionLong = dx.descriptionLong;
						};
						if(item.visitReason.code){
							item.viewbag.searchDxCode = item.visitReason.code;
							item.viewbag.searchDxType = {ref:item.classificationVisitReason};
						}
						item.viewbag.removeCode = function(vb) {
							if (vb.searchDxCode) delete vb.searchDxCode;
							if (vb.item.visitReason.id) delete vb.item.visitReason.id;
							if (vb.item.visitReason.code) delete vb.item.visitReason.code;
							if (vb.item.visitReason.classification) delete vb.item.visitReason.classification;
							if (vb.item.visitReason.descriptionShort) delete vb.item.visitReason.descriptionShort;
							if (vb.item.visitReason.descriptionLong) delete vb.item.visitReason.descriptionLong;
						};
						item.viewbag.onChangeEditState = function(item, def){
							if(item.viewbag.focus){
								item.viewbag.focus()
							}
						};
					},
					lstProb: function(item){
					},
					lstBloodPres: function(item){
						item.viewbag.bloodPresDateDynaDateOptions = {
							format: 'YYYY-MM-DD HH:mm',
							acceptFutureDate: false,
							onDateSelected: function (mDate, dAssist) {
								var m = mDate.format(dAssist.format);
								item.viewbag.item.timeVitalSignS = m;
							}
						};
						item.viewbag.onChangeEditState = function(item, def){
							if(item.viewbag.focus){
								item.viewbag.focus()
							}
						};
						initProp(item.viewbag.item,'timeVitalSignS',EncounterSummaryCommon.nowDateTime());
					},
					lstBodyTemp: function(item){
						item.viewbag.bodyTempDynaDateOptions = {
								format: 'YYYY-MM-DD HH:mm',
								acceptFutureDate: false,
								onDateSelected: function (mDate, dAssist) {
									var m = mDate.format(dAssist.format);
									item.viewbag.item.timeVitalSignS = m;
								}
						};
						item.viewbag.onChangeEditState = function(item, def){
							if(item.viewbag.focus){
								item.viewbag.focus()
							}
						};
						initProp(item.viewbag.item,'timeVitalSignS',EncounterSummaryCommon.nowDateTime());
						initProp(item.viewbag.item,'bodyTemperatureType',1);
					},
					lstMeasurement: function(item){
						var def = {};
						forEntryDef.lstMeasurement(def);
						def.itemVal = item;
						item.measurementError = undefined;
						item.viewbag.measurementDateDynaDateOptions = {
							format: 'YYYY-MM-DD HH:mm',
							acceptFutureDate: false,
							onDateSelected: function (mDate, dAssist) {
								if(!mDate){
									mDate = moment();
								}
								var m = mDate.format(dAssist.format);
								item.viewbag.item.timeVitalSignS = m;
							}
						};
						toJsFraction = ['weightS2', 'heightS1', 'headCircS1', 'waistMeasurementS1'].forEach(function(e){
							if(item.viewbag.item[e]){
								item.viewbag.item[e] = item.viewbag.item[e].replace(',', '.');
							}
						});

						item.viewbag.onChangeEditState = function(item, def){
							if(item.viewbag.focus){
								item.viewbag.focus()
							}
						};
						item.viewbag.nbJrsPremature = function(val) {
							if (arguments.length) {
								item.viewbag.item.nbJrsPremature = val;
							} else {
								return item.viewbag.item.nbJrsPremature;
								}
						};
						item.viewbag.weight = function(val) {
							// weightS2
							if (arguments.length) {
								item.measurementError = undefined;
								if (model.prefSettings('mesure_system')==2) {
									item.viewbag.item.weight = def.system.convertEN2SI('pds',val);
								} else {
									item.viewbag.item.weight = OfysUtils.parseFloat(val);									
								}
								item.viewbag.item.weightS2 = item.viewbag.item.weight ? $filter('dec2')(item.viewbag.item.weight) : '';
								if(!OfysUtils.isNotEmpty(item.viewbag.item.weight)){
									item.measurementError = "measurementError_weight";
								}
							} else {
								var retVal;
								if (model.prefSettings('mesure_system')==2) {
									retVal = item.viewbag.item.weightS2 ? $filter('dec2')(def.system.convertSI2EN('pds',item.viewbag.item.weightS2)) : '';
								} else {
									retVal = OfysUtils.isNotEmpty(item.viewbag.item.weight) ? $filter('dec2')(item.viewbag.item.weight) : '';
								}
								return retVal;
							}
						};
						item.viewbag.height = function(val) {
							// heightS1
							if (arguments.length) {
								item.measurementError = undefined;
								if (model.prefSettings('mesure_system')==2) {
									item.viewbag.item.height = def.system.convertEN2SI('len',val);
								} else {
									item.viewbag.item.height = OfysUtils.parseFloat(val);							
								}
								item.viewbag.item.heightS1 = item.viewbag.item.height ? $filter('dec1')(item.viewbag.item.height) : '';
								if(!OfysUtils.isNotEmpty(item.viewbag.item.height)){
									item.measurementError = "measurementError_height";
								}
							} else {
								var retVal;
								if (model.prefSettings('mesure_system')==2) {
									retVal = item.viewbag.item.heightS1 ? $filter('dec1')(def.system.convertSI2EN('len',item.viewbag.item.heightS1)) : '';
								} else {
									retVal = OfysUtils.isNotEmpty(item.viewbag.item.height) ? $filter('dec1')(item.viewbag.item.height) : '';
								}
								return retVal;
							}
						};
						item.viewbag.headCirc = function(val) {
							// headCircS1
							if (arguments.length) {
								item.measurementError = undefined;
								if (model.prefSettings('mesure_system')==2) {
									item.viewbag.item.headCirc = def.system.convertEN2SI('len',val);
								} else {
									item.viewbag.item.headCirc = OfysUtils.parseFloat(val);									
								}
								item.viewbag.item.headCircS1 = item.viewbag.item.headCirc ? $filter('dec1')(item.viewbag.item.headCirc) : '';
								if(!OfysUtils.isNotEmpty(item.viewbag.item.headCirc)){
									item.measurementError = "measurementError_headCirc";
								}
							} else {
								var retVal;
								if (model.prefSettings('mesure_system')==2) {
									retVal = item.viewbag.item.headCircS1 ? $filter('dec1')(def.system.convertSI2EN('len',item.viewbag.item.headCircS1)) : '';
								} else {
									retVal = OfysUtils.isNotEmpty(item.viewbag.item.headCirc) ? $filter('dec1')(item.viewbag.item.headCirc) : '';
								}
								return retVal;
							}
						};
						item.viewbag.waistMeasurement = function(val) {
							// waistMeasurementS1
							if (arguments.length) {
								item.measurementError = undefined;
								if (model.prefSettings('mesure_system')==2) {
									item.viewbag.item.waistMeasurement = def.system.convertEN2SI('len',val);
								} else {
									item.viewbag.item.waistMeasurement = OfysUtils.parseFloat(val);									
								}
								item.viewbag.item.waistMeasurementS1 = item.viewbag.item.waistMeasurement ? $filter('dec1')(item.viewbag.item.waistMeasurement) : '';
								if(!OfysUtils.isNotEmpty(item.viewbag.item.waistMeasurement)){
									item.measurementError = "measurementError_waistMeasurement";
								}
							} else {
								var retVal;
								if (model.prefSettings('mesure_system')==2) {
									retVal = item.viewbag.item.waistMeasurementS1 ? $filter('dec1')(def.system.convertSI2EN('len',item.viewbag.item.waistMeasurementS1)) : '';
								} else {
									retVal = OfysUtils.isNotEmpty(item.viewbag.item.waistMeasurement) ? $filter('dec1')(item.viewbag.item.waistMeasurement) : '';
								}
								return retVal;
							}
						};
						initProp(item.viewbag.item,'timeVitalSignS',EncounterSummaryCommon.nowDateTime());
					},
					lstPhysicalExam: function(item){
						item.viewbag.physicalExamDateDynaDateOptions = {
								format: 'YYYY-MM-DD HH:mm',
								acceptFutureDate: false,
								onDateSelected: function (mDate, dAssist) {
									var m = mDate.format(dAssist.format);
									item.viewbag.item.timeVitalSignS = m;
								}
						};
						item.viewbag.onChangeEditState = function(item, def){
							if(item.viewbag.focus){
								item.viewbag.focus()
							}
						};
						initProp(item.viewbag.item,'timeVitalSignS',EncounterSummaryCommon.nowDateTime());
					},
					lstCustMeasure: function(item){
						initProp(item.viewbag.item,'timeVitalSignS',EncounterSummaryCommon.nowDateTime());
						item.viewbag.onChangeEditState = function(item, def){
							if(item.viewbag.focus){
								item.viewbag.focus()
							}
						};
					},
					lstImmunization: function(item){
						item.viewbag.dateOptions = {
							format: 'YYYY-MM-DD',
							acceptFutureDate: false,
							onDateSelected: function (mDate, dAssist) {
								var m = mDate.format(dAssist.format);
								item.viewbag.item.vaccinationDateSP = m;
							}
						};
						item.viewbag.selectDx = function(dx){
							item.viewbag.item.classificationDiagnostic = dx.classification;
							item.viewbag.item.descrShort = dx.descriptionShort;
							item.viewbag.item.descrLong = dx.descriptionLong;
							item.viewbag.item.code = dx.code;
							item.viewbag.item.codeId = dx.id;
						};
						item.viewbag.removeCode = function(viewbag) {
							delete viewbag.searchDxCode;
							delete viewbag.item.classificationDiagnostic;
							delete viewbag.item.code;
							delete viewbag.item.codeId;
							delete viewbag.item.descrLong;
							delete viewbag.item.descrShort
						};
						item.viewbag.onChangeEditState = function(item, def){
							if(item.viewbag.focus){
								item.viewbag.focus()
							}
						};
						
						initProp(item.viewbag.item,'vaccinationDateSP',EncounterSummaryCommon.nowDateOnly());
						if(item.code){
							item.viewbag.searchDxCode = item.code;
						}						
					},
					lstPrescription: EncounterSummaryCommon.prescriptionOnEdit,
					lstDevice: EncounterSummaryCommon.deviceOnEdit,
					lstFreq: function(item){
						item.viewbag.freqDateDynaDateOptions = {
							format: 'YYYY-MM-DD HH:mm',
							acceptFutureDate: false,
							onDateSelected: function (mDate, dAssist) {
								var m = mDate.format(dAssist.format);
								item.viewbag.item.timeVitalSignS = m;
							}
						};
						item.viewbag.onChangeEditState = function(item, def){
							if(item.viewbag.focus){
								item.viewbag.focus()
							}
						};
						initProp(item.viewbag.item,'timeVitalSignS',EncounterSummaryCommon.nowDateTime());
					},
					lstDx: function(item){
						item.viewbag.selectDx = function(dx){
							item.viewbag.item.classificationDiagnostic = dx.classification;
							item.viewbag.item.descrShort = dx.descriptionShort;
							item.viewbag.item.descrLong = dx.descriptionLong;
							item.viewbag.item.code = dx.code;
							item.viewbag.item.codeId = dx.id;
						}
					},
					lstDxEnc: function(item){
						item.viewbag.solvedDynaDateOptions = angular.copy(scope.partialDateOptions);
						item.viewbag.dateDynaDateOptions = angular.copy(scope.partialDateOptions);
						item.viewbag.selectDx = function(dx){
							item.viewbag.item.classificationDiagnostic = dx.classification.toLowerCase();
							item.viewbag.item.descrShort = dx.descriptionShort;
							item.viewbag.item.descrLong = dx.descriptionLong;
							item.viewbag.item.code = dx.code;
							item.viewbag.item.codeId = dx.id;
						}
						if(item.code){
							item.viewbag.searchDxCode = item.code;
							item.viewbag.searchDxType = {ref:item.classificationDiagnostic};
						}
						item.viewbag.onChangeEditState = function(item, def){
							if(item.viewbag.focusDetail){
								item.viewbag.focusDetail()
							}
						};
					},
					lstBilling: function(item){
						item.viewbag.billingDateDynaDateOptions = {
								format: 'YYYY-MM-DD HH:mm',
								acceptFutureDate: false,
								onDateSelected: function (mDate, dAssist) {
									var m = mDate.format(dAssist.format);
									item.viewbag.item.timeBillingS = m;
								}
						};
						item.viewbag.selectDx = function(dx){
							item.viewbag.item.classificationDiagnostic = dx.classification.toLowerCase();
							item.viewbag.item.descrShort = dx.descriptionShort;
							item.viewbag.item.descrLong = dx.descriptionLong;
							item.viewbag.item.dxcode = dx.code;
						};
						item.viewbag.removeCode = function(viewbag){
							delete viewbag.searchDxCode;
							delete viewbag.item.dxcode;
							delete viewbag.item.descrLong;
							delete viewbag.item.descrShort
						};
						if(item.dxcode){
							item.viewbag.searchDxCode = item.dxcode;
							item.viewbag.searchDxType = {ref:item.classificationDiagnostic};
						}
						
						item.viewbag.onChangeEditState = function(item, def){
							if(item.viewbag.focus){
								item.viewbag.focus()
							}
						};
						var lstD = scope.quickViewData.pat.viewbag.patData.sum.lstDx;
						var lstP = scope.quickViewData.pat.viewbag.patData.sum.lstProb;
						var lstDx = _.union(lstD, lstP);
						item.viewbag.previousDx = lstDx.filter(function (e) {
							return e.cim10Code || (!!(e.cim9Code) && "0000"!=e.cim9Code);
						}).map(function (e) {
							return {
								id: e.codeId,
								classification: (e.cim10Code ? "CIM10" : "CIM9"),
								code: e.code,
								descriptionLong: (e.cim10Code ? e.cim10DescrShort : e.cim9DescrShort),
								descriptionShort: (e.cim10Code ? e.cim10DescrShort : e.cim9DescrShort)
							};
						});

						initProp(item.viewbag.item,'timeBillingS',EncounterSummaryCommon.nowDateTime());
					},
				}
			
				/** COMMENT: ENCOUNTER VIEW @function
				 * 
				 * @description: S'occupe de l'ouverture de formulaire externe et à l'intérieur des vues
				 * 
				 * @argument: 
				 *	doc:
				 *	external :
				 * 
				 * 'encDoc0':"Document",
				 * 'encDoc1':"Lien",
				 * 'encDoc2':"Formulaire",
				 * 'encDoc3':"Labo",
				*/
				scope.openDoc = function(doc, external){
					if(scope.quickViewData.qvActData.activeDocs && !external){
						for(actDoc of scope.quickViewData.qvActData.activeDocs){
							if (actDoc.act.id === doc.idDocument){
								addFormToActiveDocs(actDoc.act, scope.quickViewData.pat, doc);
								return;
							}
						}
					}

					if(doc.viewbag){
						if(! external){
							doc.viewbag.show = !doc.viewbag.show;
						}else if (external && doc.atype !== 2){
							patientShowTitles.openActivity(doc.viewbag.quickViewData.qvActData, {mode: 'n', minimize: false}, doc.viewbag.quickViewData.pat);
						}else if(external && doc.atype === 2){
							doc.viewbag.show = false;
							addFormToActiveDocs(doc.viewbag.quickViewData.qvActData, scope.quickViewData.pat, doc);
						}
						return;
					}
					if(doc.atype === 0){// Scan document (pdf or image)
						showDoc('doc', doc, external);
					}
					if(doc.atype === 1){ // Url link
						if(doc.link){
							DashWebSocket.send({url: "/dashboard", data:{url: doc.link.url}});
						}else{
							PrefAccessor.getWebLinks(doc.idDocument, function(link){
								if(link){
									doc.link = link;
									DashWebSocket.send({url: "/dashboard", data:{url: doc.link.url}});
								}
							});
						}
						// doc.idDocument
						// openHelp(url);
					}
					if(doc.atype === 2){ // Form
						showDoc('form', doc, external);
					}
					if(doc.atype === 3){//Labo not functional still buggy the rest is good
						showDoc('lab', doc, external);
					}
				}

				scope.modifyDoc = function(doc){
					if(doc.atype === 2){
						
					}
				}

				scope.printDoc = OfysUtils.throttle(function(doc){
					if(doc.atype && doc.atype === 2) {
						if (!doc.printing){
							doc.printing = true;
							FormAccessor.printWithLinks({id: doc.idDocument}, function(){
								doc.printing = false;
								model.notice().success($filter('translate')('PRINT_SERVER_SUCCESS'));
							});
						}
					}
				});

				scope.faxDoc = OfysUtils.throttle(function(doc){
					if(doc.atype && doc.atype === 2) {
						if (doc) {
							var formName = doc.description + (doc.entryDateS ? " (" + doc.entryDateS + ")" : "");
						}
						FlView.open({templateUrl: "/dashboard/resources/ofys/fax/fax.html?v=ba", patient: scope.quickViewData.pat, showCoverPageOptions: true }, {
							backdrop: 'static',windowClass: "faxmodal"}).then(function(faxdata){
							if (formName) {
								faxdata.docName = formName;
							}
							FormAccessor.faxWithLinks({id: doc.idDocument, faxdata: faxdata}, function(res){
								model.notice().success($filter('translate')('FAX_SERVER_SUCCESS'));                               
							});
						});
					}
				});
				

				function showDoc(type, doc, external){
					if(hasList(type)){
						var act = findDoc(scope.quickViewData.pat.viewbag.patData[type], doc, type)
						if(act){
							revealAct(act, external, doc, type)
						}else{ 
							//Fallback to search from server if the document version is not loaded.
							if(type === 'form'){
								FormAccessor.data(doc.idDocument, function(resData){
									revealAct(resData, external, doc, type);
								});
							} else if(type === 'doc'){
								DocAccessor.docView({id:doc.idDocument}, function (res) {
									var resData = res.data;
									revealAct(resData, external, doc, type);
								}, function(errData) {
									doc.errors = [$filter("translate")("FileUnavailbleProbablyMoved")]									
								});
								
							}
							// else if(type === 'lab'){
							// 	LabAccessor.labView(doc.idDocument, function success(response){
							// 		revealAct(response.data, external, doc);
							// 	});
							// }
						}
					}
				}


				function revealAct(act, external, doc, type){
					if(act && !external){
						doc.viewbag = patientShowTitles.getQVPayLoad(act, {hasHeader: false}, scope.quickViewData.pat)
					}else if(act && external){
						if(type === 'form'){
							
							addFormToActiveDocs(act, scope.quickViewData.pat, doc)
						}else{
							patientShowTitles.openActivity(act, {mode: 'n', minimize: false}, scope.quickViewData.pat);
						}
					}
					if(doc && doc.viewbag){
						doc.viewbag.show = true;
					}
				}

				/**
				 * 
				 * @param {Integer} status :(2 or 0) 2- if the linkMode is active and the user should be able to add documents, 
				 * 									 0- if  the linkMode should be desactivated.
				 */
				scope.toggleLinkMode = function(status){
					if(scope.linkModeOn !== status){
						model.patientQvAllDataTabs().activeTab = 'PatientData';
						scope.linkModeOn = !scope.linkModeOn;
						if (scope.quickViewData) {
							scope.quickViewData.linkModeOn = scope.linkModeOn ? 2 : 0;
						}
						if(scope.linkModeOn && !hasEditDoc()){
							scope.encFormOptions.addNewItem(scope.editEnc, 'lstDoc');
						}
						scope.entryDefs.lstDoc.activeLinkMode = scope.linkModeOn;
						model.formLinkUpdated(true);
						model.editModeUpdated(true);	// il faut réévaluer quand la val de linkMode change
					}
				};
				/**
				 *
				 * @param {Integer} status :(2 or 0) 2- if the linkMode is active and the user should be able to add documents,
				 * 									 0- if  the linkMode should be desactivated.
				 */
				// scope.toggleLinkModeDx = function(status){
				// 	model.patientQvAllDataTabs().activeTab = 'PatientMedSummary';

				// 	scope.linkModeOn = !scope.linkModeOn;
				// 	if(scope.linkModeOn !== status){
				// 		if (scope.quickViewData) {
				// 			scope.quickViewData.linkModeOn = scope.linkModeOn ? LinkMode.DX_ADD_MODE : 0;
				// 			scope.entryDefs.lstDx.linkModeOn = scope.quickViewData.linkModeOn
				// 		}
				// 	}
				// 	scope.entryDefs.lstDx.activeLinkMode = scope.linkModeOn;
				// 	model.editModeUpdated(true);	// il faut réévaluer quand la val de linkMode change
				// };

				function hasEditDoc(){
					return scope.editEnc.lstDoc && scope.editEnc.lstDoc.find(isInEdit)
				}

				function isInEdit(e){
					return e.editMode;
				}

				scope.togglePrescriptionModes = function(status, mode){
					if (model.patientQvAllDataTabs().activeTab=='PatientData') {
						model.patientQvAllDataTabs().activeTab = 'PatientMedSummary';						
					}
					var deviceModes = mode === LinkMode.DEVICEREPRESCRBE || mode === LinkMode.DEVICEMED_STOP_MODE;
					
					// peut être qu'on veut importer du DSQ... donc on ne doit pas restreindre
//					if(!deviceModes && !hasSummaryPrescriptions() ){
//						model.notice().warn($filter("translate")('NoSummaryPrescription'));
//						return false;
//					}else if(deviceModes && !hasSummaryDevices()){
//						model.notice().warn($filter("translate")('NoSummaryDevices'));
//						return false;
//					}
					if(scope.linkModeOn !== status){
						if(mode === LinkMode.REPRESCRIBEMODE || mode === LinkMode.DEVICEREPRESCRBE){
							scope.enc.viewbag.represcribe = represcribe;
							scope.quickViewData.represcribe = represcribe;
						}else if(mode === LinkMode.MED_STOP_MODE || mode === LinkMode.DEVICEMED_STOP_MODE){
							scope.enc.viewbag.medStopLink = medStopLink;
						}
						scope.linkModeOn = !scope.linkModeOn;
						if (scope.quickViewData) {
							scope.quickViewData.linkModeOn = scope.linkModeOn ? mode : 0;
							scope.entryDefs.lstPrescription.linkModeOn = scope.quickViewData.linkModeOn
						}
						if(scope.linkModeOn){//entering prescription modification mode (stop or represcribe)
						}else{//Finished prescriptoin modification mode(stop or respriscribe.)
							scope.commitForPresave();
						}

						if(deviceModes){
							scope.entryDefs.lstDevice.activeLinkMode = scope.linkModeOn
						}else{
							scope.entryDefs.lstPrescription.activeLinkMode = scope.linkModeOn
						}
						model.formLinkUpdated(true);
						model.editModeUpdated(true);	// il faut réévaluer quand la val de linkMode change
					}
					model.patientSumUpdated(true);
					return true;
				}

				function represcribe(prescription){
					if(prescription.baseDrugType !== undefined ){
						if(prescription.baseDrugType === EncounterAccessor.baseDrugTypes.FOURNITURE){
							var iv = EncounterSummaryCommon.deviceReprescribe(prescription);
							if(!scope.editEnc.lstDevice){
								scope.editEnc.lstDevice = [];
							}
							
							if(scope.quickViewData.linkModeOn == LinkMode.DEVICEREPRESCRBE){
								scope.editEnc.lstDevice.push(iv);
								scope.commitForPresave(iv, "lstDevice");
							}
							return iv;								
						}else if(EncounterSummaryCommon.isPrescription(prescription)){// prescriptions
							var iv = EncounterSummaryCommon.prescriptionReprescribe(prescription)
							if(!scope.editEnc.lstPrescription){
								scope.editEnc.lstPrescription = [];
							}
							if(scope.quickViewData.linkModeOn == LinkMode.REPRESCRIBEMODE){
								scope.editEnc.lstPrescription.push(iv);
								scope.commitForPresave(iv, "lstPrescription");
								$timeout(function() {
									iv.scrollToBottom();
								}, 300)
							}
							return iv;
						}
					}
				}

				function medStopLink(prescription){
					if(prescription.baseDrugType === EncounterAccessor.baseDrugTypes.FOURNITURE){// Accepts prescriptions only.
						if(!scope.editEnc.lstDevice){
							scope.editEnc.lstDevice = [];
						}
						var iv = deviceMedStopLink(prescription)
						if(scope.quickViewData.linkModeOn == LinkMode.DEVICEMED_STOP_MODE){
							scope.editEnc.lstDevice.push(iv);
							scope.commitForPresave(iv, "lstDevice");
						}
					} else if(EncounterSummaryCommon.isPrescription(prescription)){// Accepts prescriptions only.
						if(!scope.editEnc.lstPrescription){
							scope.editEnc.lstPrescription = [];
						}
						var iv = prescriptionMedStopLink(prescription)
						if(scope.quickViewData.linkModeOn == LinkMode.MED_STOP_MODE){
							scope.editEnc.lstPrescription.push(iv);
							scope.commitForPresave(iv, "lstPrescription");
						}
					}  
				}
				
				function deviceMedStopLink(prescription){
					return prescriptionMedStopLink(prescription);
				}

				function prescriptionMedStopLink(prescription){
					// var df = "YYYY-MM-DD";
					
					var iv = angular.copy(prescription);
					iv.isReprescribedFromSummary = true;
					delete iv.idEncounter

					$timeout(function(){
						iv.stopMed && iv.stopMed(true);
						if(iv.stopMedOptions){
							iv.stopMedOptions.stopMed();
						}
					}, 100)
					$timeout(function() {
						iv.scrollToBottom();
					}, 300)
					return iv;
				}

				function hasList(type){
					return scope.quickViewData && scope.quickViewData.pat && 
					scope.quickViewData.pat.viewbag && scope.quickViewData.pat.viewbag.patData &&
					scope.quickViewData.pat.viewbag.patData[type]
				}

				function findDoc(list, doc, type){
					for(var i = 0; i < list.length; i++){
						if(doc.idDocument === list[i].id){
							return list[i];
						}
						//This code is no longer functional / don't know what changed.
						// if(type !== 'lab' && doc.idDocument === list[i].id){
						// 	return list[i];
						// }
						// if(type === 'lab' && list[i].activeProf && list[i].activeProf.id === doc.idDocument){
						// 	return list[i];
						// }
					}
				}


				var defaultOptions = {
					hasHeader: true
				}
				function setViewOptions(options){
					scope.viewOptions = angular.copy(defaultOptions)
					if(options){
						$.extend(scope.viewOptions, options)
					}
				}


				var defaultItems = {
					lstBloodPres: {},
					lstBodyTemp: {bodyTemperatureType: 1},
					lstRaison: {visitReason:{}},
					lstNote: {noteType:10},
					lstDoc: {},
					// lstConsult:{}
					lstMeasurement: {nbJrsPremature:0},
					lstCustMeasure: {},
					lstPhysicalExam: {},
					lstImmunization: {showInPatientSummary: true,
						refused: false
					},
					lstPrescription: EncounterSummaryCommon.prescriptionDefaultItem(),
					lstDevice: EncounterSummaryCommon.deviceDefaultItem(),
					lstFreq: {},
					lstBilling: {},
					lstDxEnc: { status: 0 }
				};

				function loadEnc(enc){//enc can be from save response or loaded by the dataviewer.
					
					//if using directive attribute scope.enc is used if called after save the parameter enc is used.
					if(typeof enc === 'object'){
						if(typeof enc.viewbag !== 'object'){
							enc.viewbag = {};
						}
						scope.enc.save = scope.save;
						scope.enc.cancel = scope.cancel;
						scope.enc.attachDocument = attachDocument;
						if(typeof enc.viewbag.editEnc !== 'object' ){
							enc.viewbag.editEnc = angular.copy(enc);
						}
						scope.editEnc = enc.viewbag.editEnc;
						
						var profList = {unique: {}, byProf: {}}
						scope.profSummary = {};
						Object.keys(scope.entryDefs).forEach(function(k){EncounterAccessor.initEntry(k, scope.entryDefs, forEntryDef, scope.editEnc)});
						createEncFromTemplate();
						if(scope.editEnc.lstProf){
							//Créer le tableau de profs. pour l'affichage grouper par professionnel
							scope.editEnc.lstProf.forEach(function(prof){
								if(!profList.unique[prof.idProfessionnalAnchor] || 
									( 
										profList.unique[prof.idProfessionnalAnchor] && 
										profList.unique[prof.idProfessionnalAnchor].entryDate < prof.entryDate 
									) 
								){
									profList.unique[prof.idProfessionnalAnchor] = prof;
								}
		
								if(!profList.byProf[prof.idProfessionnalAnchor]){
									profList.byProf[prof.idProfessionnalAnchor] = [];
								}
								profList.byProf[prof.idProfessionnalAnchor].push(prof)
							})
							scope.profSummary.unique = OfysUtils.ObjectValuesAsArray(profList.unique);
							scope.profSummary.byProf = profList.byProf;
						}

						
						var templatePayload = {
							actionOnPayload: function(template){

								var data = _.filter(template.vars, 'structured');
								data = _.filter(data,  function(e){return e.m !== undefined});//Only add items with value.
								if(data.length > 0){
									var dataEnc = {};
									var allMesure= {
										'TAs': {
											group: 'lstBloodPres',
											add: function(elem, val){
												elem.systolic = val;
											}
										},
										'TAd':  {
											group: 'lstBloodPres',
											add: function(elem, val){
												elem.diastolic = val;
											}
										},
										'POULS':  {
											group: 'lstBloodPres',
											add: function(elem, val){
												elem.pulse = val;
											}
										},
										'SATUR':  {
											group: 'lstBloodPres',
											add: function(elem, val){
												elem.saturation = val;
											}
										},
										'POIDSKG': {
											group: 'lstMeasurement',
											add: function(elem, val){
//												if (model.prefSettings('mesure_system')==1) {
													elem.weight = OfysUtils.parseFloat(val).toFixed(2);
//												} else {
//													elem.weight = (OfysUtils.parseFloat(val)/0.453592).toFixed(2);
//												}
												elem.weightS2 = elem.weight + "";
											}
										} ,
										'POIDSLBS': {
											group: 'lstMeasurement',
											add: function(elem, val){
//												if (model.prefSettings('mesure_system')==2) {
//													elem.weight = OfysUtils.parseFloat(val).toFixed(2);													
//												} else {
													elem.weight = (OfysUtils.parseFloat(val)*0.453592).toFixed(2);
//												}
												elem.weightS2 = elem.weight + "";
											}
										} ,
										'TAILLECM': {
											group: 'lstMeasurement',
											add: function(elem, val){
//												if (model.prefSettings('mesure_system')==1) {
													elem.height = OfysUtils.parseFloat(val).toFixed(1);													
//												} else {
//													elem.height = (OfysUtils.parseFloat(val)/2.54).toFixed(1);
//												}
												elem.heightS1 = elem.height + "";
											}
										} ,
										'TAILLEPCE': {
											group: 'lstMeasurement',
											add: function(elem, val){
//												if (model.prefSettings('mesure_system')==2) {
//													elem.height = OfysUtils.parseFloat(val).toFixed(1);
//												} else {
													elem.height = (OfysUtils.parseFloat(val)*2.54).toFixed(1);
//												}
												elem.heightS1 = elem.height + "";
											}
										} ,
										'TOUR_TAILLECM': {
											group: 'lstMeasurement',
											add: function(elem, val){
//												if (model.prefSettings('mesure_system')==1) {
													elem.waistMeasurement = OfysUtils.parseFloat(val).toFixed(1);
//												} else {
//													elem.waistMeasurement = (OfysUtils.parseFloat(val)/2.54).toFixed(1);
//												}
												elem.waistMeasurementS1 = elem.waistMeasurement + "";//Conversion de pouce en cm
											}
										} ,
										'TOUR_TAILLEPCE': {
											group: 'lstMeasurement',
											add: function(elem, val){
//												if (model.prefSettings('mesure_system')==2) {
//													elem.waistMeasurement = OfysUtils.parseFloat(val).toFixed(1);
//												} else {
													elem.waistMeasurement = (OfysUtils.parseFloat(val)*2.54).toFixed(1);
//												}
												elem.waistMeasurementS1 = elem.waistMeasurement + "";//Conversion de pouce en cm
											}
										} ,
										'CIRC_TCM': {
											group: 'lstMeasurement',
											add: function(elem, val){
//												if (model.prefSettings('mesure_system')==1) {
													elem.headCirc = OfysUtils.parseFloat(val);
//												} else {
//													elem.headCirc = (OfysUtils.parseFloat(val)/2.54).toFixed(1);
//												}
												elem.headCircS1 = elem.headCirc + "";
											}
										} ,
										'CIRC_TPCE': {
											group: 'lstMeasurement',
											add: function(elem, val){
//												if (model.prefSettings('mesure_system')==2) {
//													elem.headCirc = OfysUtils.parseFloat(val);
//												} else {
													elem.headCirc = (OfysUtils.parseFloat(val)*2.54).toFixed(1);
//												}
												elem.headCircS1 = elem.headCirc + "";
											}
										} ,
										'FR': {
											group: 'lstFreq',
											add: function(elem, val){
												elem.respiration = val;
											}
										} ,
										'TEMP_AXI': {
											group: 'lstBodyTemp',
											add: function(elem, val){
												elem.bodyTemperatureType = 8;
												elem.bodyTemperature = val;
											}
										} ,
										'TEMP_BUC': {
											group: 'lstBodyTemp',
											add: function(elem, val){
												elem.bodyTemperatureType = 1;
												elem.bodyTemperature = val;
											}
										} ,
										'TEMP_REC': {
											group: 'lstBodyTemp',
											add: function(elem, val){
												elem.bodyTemperatureType = 2;
												elem.bodyTemperature = val;
											}
										} ,
										'TEMP_TYM': {
											group: 'lstBodyTemp',
											add: function(elem, val){
												elem.bodyTemperatureType = 4;
												elem.bodyTemperature = val;
											}
										}
									};
									
									//Adds an element in the encounter
									//the tempAssistStructured contains 
									// {
									// 	'lstTemp':[{
									// 		added: ['TAs'],
									// 	}, {added: ['TAs']}]
									// }
									var tempAssistStructured = {};
									//For all data found in the template add element in the encounter
									for (let x = 0; x < data.length; x++) {
										var i = 0;
										var editable = {};
										var added = false;
										if(allMesure[data[x].typeDeMesure]){
											var c = allMesure[data[x].typeDeMesure];
											if(!dataEnc[c.group]){
												dataEnc[c.group] = [];
											}
											if(!tempAssistStructured[c.group]){
												editable = scope.encFormOptions.editItem(angular.copy(defaultItems[c.group]), c.group);
												tempAssistStructured[c.group] = [{added: [data[x].typeDeMesure]}];
												dataEnc[c.group].push(editable);
												added = true;
											}else {
												//look for a elment with out the value
												for (let j = 0; j < tempAssistStructured[c.group].length && !added; j++) {
													var struct = tempAssistStructured[c.group][j];
													if(struct.added.indexOf(data[x].typeDeMesure) === -1){
														added = true;
														editable = dataEnc[c.group][i];
													}
													i = j;
												}
												if(!added){
													i += 1;
													editable = scope.encFormOptions.editItem(angular.copy(defaultItems[c.group]), c.group);
													dataEnc[c.group].push(editable);
													tempAssistStructured[c.group].push({added: [data[x].typeDeMesure]});
												}

											}
											if(data[x].m){
												//Add the value to the encounter element.
												c.add(editable.viewbag.item, data[x].m);
											}
										}
									}
									// console.log(template);
									Object.keys(dataEnc).forEach(function(k) {
										if(!scope.editEnc[k]){
											scope.editEnc[k] = [];
										}
										var addedIndex = scope.editEnc[k].length;
										scope.editEnc[k] = scope.editEnc[k].concat(dataEnc[k]);
										for(; addedIndex < scope.editEnc[k].length; addedIndex++){
											scope.commitForPresave(scope.editEnc[k][addedIndex], k);
										}
									});
								}
							}
						};

						TemplateAssistAction.setPayload(templatePayload);

						if(scope.editEnc.lstDoc){
							// console.log(scope.editEnc.lstDoc);
							for (let i = 0; i < scope.editEnc.lstDoc.length; i++) {
								if(openOnStart(scope.editEnc.lstDoc[i])){
									$timeout(function(){
										scope.entryDefs.lstDoc.openDoc(scope.editEnc.lstDoc[i]);
									}, 10);
								}
								
							}
						}
						refreshEditEncEditMode()//For presave loads encounter in the last opened state. if encounter was in edit mode.
					}
					if(!enc.fromSearch){
						scope.qv.isDirty = qvDirty;
					}
					model.patientSumUpdated(true);
					// EncounterAccessor.updateMessageLink(scope.enc, scope);
				}
				
				function openOnStart(doc){
					return isEncounterTypeDoc(doc) || isStyletForm(doc);
				}
				function isEncounterTypeDoc(doc){
					return doc.atype === 0 &&  doc.description.indexOf('Rencontre')>-1 ;
				}

				function isStyletForm(doc){
					return doc.atype == 2 && doc.idDocument == FormAccessor.ANCHOR_STYLET;
				}

				function qvDirty(){
					return scope.isDirty() < 2; 
				};
				scope.linkManager;
				function update(){
					
					//initialiser la rencontre de 
					scope.enc = scope.$eval(attrs.encs);
					setViewOptions(scope.$eval(attrs.options));

					//Ajouter les evenement du quickview (close, minimize, changeActivity, externalize.)
					model.safeCall(scope.addEventsEvent)
					//Ajouter le patient en cour pour le messages et taches.
					
					scope.linkManager = MessageLink.linkManager(EncounterAccessor, scope.quickViewData.pat, scope.enc.uid, scope)

					//Creer la rencontre de consultation et edition. (ajout viewbag, editEnc) 
					loadEnc(scope.enc);
				};
				// function clearMessageLink(){
				// 	if(angular.isDefined(EncounterAccessor.messageLinkKey) && 
				// 		EncounterAccessor.messageLinkKey !== "" &&
				// 		EncounterAccessor.msgLinkMap[scope.enc.uid] !== undefined){
				// 		MessageLink.removeLinkType(EncounterAccessor.messageLinkKey);
				// 		delete EncounterAccessor.messageLinkKey
				// 		delete EncounterAccessor.msgLinkMap[scope.enc.uid]
				// 	}
				// }

				// function addMessageLink(){
				// 	if (scope.quickViewData) {
				// 		clearMessageLink()
				// 		EncounterAccessor.updateMessageLink(scope.quickViewData.pat,undefined,scope.enc.uid);
				// 		scope.$on('$destroy',  clearMessageLink);
				// 	}
				// }

				function attachDocument(act, previousDoc){
					if(hasAttachement(act)){//The document is already attached to the encounter
						return;
					}
					if(previousDoc){
						var newDocLink = updateLink(previousDoc, act);
						if(newDocLink){
							var i = scope.editEnc.lstDoc.find(function(e){return e.id === previousDoc.id});
							i.modificationStatus = ModificationStatus.STATUS_UPDATED;
							return i;
						}
					}else{

					}
					var link = actoToLink(act);
					if(!scope.editEnc.lstDoc){
						scope.editEnc.lstDoc = []
					}
					scope.editEnc.lstDoc.unshift(link);
					return link;
				}

				function actoToLink(act){
					//console.log(act);
					var link;
					if(act.className && attachDoc[act.className]){
						link = angular.copy(attachDoc[act.className])
						link.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED
						link.init(act);
						return link;
					}
				}
				function updateLink(previousLink, act){
					var link;
					if(previousLink && act){
						link = angular.copy(attachDoc[act.className]);
						link.init(act)
						link = $.extend(previousLink, link);
						return link;
					}
				}
				/*
				'encDoc0':"Document",
				'encDoc1':"Lien",
				'encDoc2':"Formulaire",
				'encDoc3':"Labo",
				*/
				var attachDocImage = {
					atype: 0,
					init: function(act){
						this.description = act.name ? act.name : "Document";
						this.editDescription = true;
						this.idDocument = act.id;
						this.idDocumentsAnchor = act.idAnchor;
						return "Document"
					}
				}
				var attachDoc = {
					CFormData: {
						atype: 2,
						init: function(act){
							this.description = act.form && act.form.name ? act.form.name: "Formulaire";
							this.editDescription = true;
							this.idDocument = act.id;
							this.idDocumentsAnchor = act.idAnchor;
							return 'Form';
						}
					},
					CLaboFile: {
						atype: 3,
						init: function(act){
							this.description = act.req ? act.req: " - ";
							this.editDescription = true;
							this.idDocument = act.id;
							this.idDocumentsAnchor = act.idAnchor;
							return "Labo";
						}
					},
					CBasePatientImage: attachDocImage,
					CPatientImage: attachDocImage
				}
				
				function hasAttachement(act){
					for(var i = 0; i < scope.editEnc.lstDoc; i++){
						if(scope.editEnc.lstDoc[i].id === act.id && scope.editEnc.lstDoc[i].id === act.id ){
							return true;
						}
					}
					return false;
				}

				function isAlreadyAttached(act){
					for(var i = 0; i < scope.editEnc.lstDoc; i++){
						
					}
					return false;
				}

				scope.printEnc = function(){
					console.log("Enc original");
					console.log(scope.enc);
					console.log("Enc editable");
					console.log(scope.editEnc);
				}

				function setNew(item){
					if(item.viewbag){
						item.viewbag.isNew = true;
					}
					return item;
				}

				// TODO on aurait besoin de plus d'info ici. Sol'n: avoir des objets. Ex.... ,{name:HEADERSECTION, type:22}, {name:lstNote, type:1}
				// le type de la var 0 (HEADERSECTION est un XEncoutnerType, celui de lstNote est XNoteType < 100).
				// ex. suiviGs2

				/**
				 * Creating templates
				 * There are 2 types of encounter templates.
				 * 1. ArrayList templates eg ['header', 'lstNote']
				 * 		This type adds an encounter with the default items of listed items.
				 * 		The above example would add an encounter with a header and a note with the default note type and definition.
				 * 2. Object templates: eg-
				 * 		{
				 * 			lst: ['header']
				 * 			base : { lstNote: [ {noteType:10}, {noteType:100} ]},
				 * 			initFunctions: [{name: 'copyForm', params: [3, true]}]
				 * 		}
				 * 		This type is more robust and allows encounter manipulations.
				 * 		@lst parameter has the same function as an ArrayList template.
				 * 		@base parameter declares an encounter used as the base encounter.
				 * 		@initFunctions declares a list of encounter manipulation functions to be used on the template.
				 */
				scope.encTemplates = {
					suiviGrossesse: {
						lst:['lstBloodPres', 'lstMeasurement'],
						base: {	// un CEncounter
							encounterType: 23, 
							encounterTypeS: EncounterAccessor.allEncTypes[24],
							lstNote: [
								scope.encFormOptions.editItem({noteType:10}, 'lstNote')
							]
						}
					},
					empty: [HEADERSECTION],
					suiviAnnuel: {	// visite périodique
//						lst: ['lstBloodPres', 'lstFreq', 'lstMeasurement', 'lstBodyTemp'],
						lst: ['lstBloodPres', 'lstMeasurement'],
						base : {
							encounterType: 12,
							encounterTypeS: EncounterAccessor.allEncTypes[12],
							lstNote: [
								scope.encFormOptions.editItem({noteType:10}, 'lstNote')
							]
						}						
					},
					visitePerPed: {
						lst: ['lstRaison','lstMeasurement'],
						base : {
							encounterType: 13,
							encounterTypeS: EncounterAccessor.allEncTypes[43],
							lstNote: [
								scope.encFormOptions.editItem({noteType:10}, 'lstNote')
								]
						}						
					},
					suiviINR: {
						base : {
							encounterType: 17,
							encounterTypeS: EncounterAccessor.allEncTypes[17],
							lstNote: [
								scope.encFormOptions.editItem({noteType:10}, 'lstNote')
								]
						}						
					},
					suiviDiabete: {
						lst: ['lstBloodPres', 'lstMeasurement'],
						base : {
							encounterType: 14,
							encounterTypeS: EncounterAccessor.allEncTypes[14],
							lstNote: [
								scope.encFormOptions.editItem({noteType:10}, 'lstNote')
								]
						}						
					},
					suiviDiabeteCap: {
						lst: ['lstBloodPres', 'lstMeasurement'],
						base : {
							encounterType: 14,
							encounterTypeS: EncounterAccessor.allEncTypes[14],
							lstNote: [
								scope.encFormOptions.editItem({noteType:10}, 'lstNote')
							],
							lstCustMeasure: [
								scope.encFormOptions.editItem({typeName:'Glycémie cap', typeCode:'bg', typeUnit:'mmol/L', typeInterval:'3.9-6.0'}, 'lstCustMeasure')
							]
						}						
					},
					glycCap: {
						base : {
							encounterType: 14,
							encounterTypeS: EncounterAccessor.allEncTypes[14],
							lstCustMeasure: [
								scope.encFormOptions.editItem({typeName:'Glycémie cap', typeCode:'bg', typeUnit:'mmol/L', typeInterval:'3.9-6.0'}, 'lstCustMeasure')
								]
						}						
					},
					ordonnances: {
						base : {
							encounterType: 28,
							encounterTypeS: EncounterAccessor.allEncTypes[28],
							lstPrescription: [
								setNew(scope.encFormOptions.editItem(angular.copy(defaultItems.lstPrescription), 'lstPrescription'))
								]
						}						
					},
					renewOrdonnances: {
						base : {
							encounterType: 28,
							encounterTypeS: EncounterAccessor.allEncTypes[28],
						}						
					},
					suiviClinique: {
						base : {
							encounterType: 22,
							encounterTypeS: EncounterAccessor.allEncTypes[22],
							lstNote: [
								scope.encFormOptions.editItem({noteType:10}, 'lstNote')
								]
						}						
					},
					Stylet: {
						base : {
							encounterType: 22,
							encounterTypeS: EncounterAccessor.allEncTypes[22],
						},
						initFunctions:[{name:"newForm", params:[FormAccessor.ANCHOR_STYLET]}]//idAnchor du formulaire stylet
					},
					SRV: {
						lst: ['lstBloodPres', 'lstFreq', 'lstBodyTemp'],
						base : {
							encounterType: 29,
							encounterTypeS: EncounterAccessor.allEncTypes[29],
							lstNote: [
								scope.encFormOptions.editItem({noteType:40}, 'lstNote')
							]
						}
					},
					raisonNoteConcl: {
						lst: ['lstRaison'],
						base : {
							encounterType: 11,
							encounterTypeS: EncounterAccessor.allEncTypes[11],
							lstNote: [
								scope.encFormOptions.editItem({noteType:10}, 'lstNote'),
								scope.encFormOptions.editItem({noteType:100}, 'lstNote')
								]
						},
						templateCreated: function (enc) {
							$timeout(function(){
								if (enc && enc.lstRaison && 
									enc.lstRaison.length > 0 && 
									enc.lstRaison[0].viewbag && 
									typeof enc.lstRaison[0].viewbag.focus === 'function') {
									enc.lstRaison[0].viewbag.focus()
								}
							}, 500);
						}
					},
					telephone: {
						base : {
							encounterType: 20,
							encounterTypeS: EncounterAccessor.allEncTypes[20],
							lstNote: [
								scope.encFormOptions.editItem({noteType:30}, 'lstNote')
								]
						}
					},
					cnesst: {
						base : {
							encounterType: 34,
							encounterTypeS: EncounterAccessor.allEncTypes[34],
							lstNote: [
								scope.encFormOptions.editItem({noteType:10}, 'lstNote')
							]
						}
					},
					immunization: {
						lst: ['lstImmunization'],
						base : {
							encounterType: 30,
							encounterTypeS: EncounterAccessor.allEncTypes[30]
						}
					},
					all: [HEADERSECTION,
					'lstRaison',
					'lstNote',
					'lstBloodPres',
					'lstBodyTemp',
					'lstFreq',
					'lstMeasurement',
					'lstCustMeasure',
					'lstPhysicalExam',
					'lstImmunization',
					'lstBilling'
					]
				}

				scope.encTemplatesManipFunctions = {
					/**
					 * The scope.encTemplatesManipFunctions is a list of functions 
					 * that can be called when a new object encounter template is created.
					 * 
					 * The first argument of the function is the encounter and the subsequent 
					 * arguments are passed through the params array of the @initFunctions
					 */
					copyForm: function(enc, formId, makeCopy){
						// {
						// 	atype:2, // XDocumentType  = EForm
						// 	idForm: -1, // obstr 1 ?
						// 	modify: true, //  EX. si trouve cet eform pour ce patient
						// 	makeCopy: false, // EX. ne pas faire de copy
						// }
						if(!enc.lstDoc){
							enc.lstDoc = [];
						}
						var copy = {
							atype:2, // XDocumentType  = EForm
							idForm: formId, // obstr 1 ?
						}
						enc.lstDoc.push(copy)
					},
					newForm: function(enc, form_idAnchor){
						FormAccessor.utils.findFormByIdAnchor(form_idAnchor,newForm);
					}
				};

				function createdFromTemplate(){
					return scope.editEnc && scope.editEnc.viewbag && scope.editEnc.viewbag.isNew && scope.viewOptions.activeType;
				}

				function createEncFromTemplate(){
					//Check if a type is being used for initial set i.e the user choose a specific encounter type to create a new version.
					//If the user chooses a type in scope.encTemplates, the list of default form entries are created.
					if(createdFromTemplate()){
						if(scope.viewOptions.activeType && scope.encTemplates[scope.viewOptions.activeType]){
							var template = scope.encTemplates[scope.viewOptions.activeType];
							if(Array.isArray(template)){
								dolistEncTemplate(template, scope.editEnc);
							}else{
								doObjectEncTemplate(template);
							}
							var encDate = moment();
							setEncDate(scope.enc, encDate);//Show date in patient list
							setEncDate(scope.editEnc, encDate);//Savable date by pdrolet
							// To mark the template as created so as not to recreate from template when the element is reloaded
							delete scope.viewOptions.activeType;
							delete scope.$eval(attrs.options).activeType;
							scope.commitForPresave();

							//
							if (typeof template.templateCreated === 'function') {
								template.templateCreated(scope.editEnc)
							}
						}
					}
				}

				function setEncDate(enc, encDate){
					enc.date = moment(encDate).format("YYYY-MM-DD HH:mm");
					enc.datetimeS = moment(encDate).format("YYYY-MM-DD HH:mm") ;
					enc.datetime = moment(encDate).valueOf();	// .unix() return nb of sec!
				}
				function dolistEncTemplate(lst, enc){
					for (let i = 0; i < lst.length; i++) {
						// if (lst[i]==='lstBloodPres' || lst[i]==='lstBodyTemp' || lst[i]==='lstFreq' || lst[i]==='lstMeasurement') {
							// on n'ajoute pas plusieurs éléments de ces types
							if (enc[lst[i]] && enc[lst[i]].length>0) continue;
						// }
						scope.encFormOptions.addNewItem(enc, lst[i]);
					}
				}
				function doObjectEncTemplate(obj){
					if(obj){
						//Get the base
						if(obj.base){
							if (scope.editEnc.lstNote) {
								lstB = obj.base.lstNote;
								if (lstB===undefined) {
									lstB = [];
								}
								var lstNotes = [].concat(scope.editEnc.lstNote, lstB);
								scope.editEnc.lstNote.length=0;
								var map = new Map();
								for (item of lstNotes) {
								    if(!map.has(item.noteType)){
								        map.set(item.noteType, true);    // set any value to Map
								        scope.editEnc.lstNote.push(item);
								    }
								}		
								obj.base.lstNote = scope.editEnc.lstNote;
								obj.base.lstNote.sort(function(a,b) {
									if (a.noteType < b.noteType)
											return -1;
										if (a.noteType > b.noteType)
											return 1;
										return 0;
								});
							}
							$.extend(scope.editEnc, obj.base);	// extend n'étant pas les listes!
						}
						//Merge the base with the list
						if(obj.lst){
							dolistEncTemplate(obj.lst, scope.editEnc);
						}
						if(obj.initFunctions){
							//execute the functions.
							for (let i = 0; i < obj.initFunctions.length; i++) {
								const mutate = obj.initFunctions[i];
								if(scope.encTemplatesManipFunctions[mutate.name]){
									scope.encTemplatesManipFunctions[mutate.name](scope.editEnc, ...mutate.params);
								}
							}
						}
					}
				}

				//TODO remove the dxStatus types code transfered to summary.
				scope.dxStatus = [];
				for(var dxStatusI = 0; dxStatusI < encEnumList.dxStatus.length; dxStatusI++){
					scope.dxStatus.push({val: dxStatusI, name: encEnumList.dxStatus[dxStatusI]+'_dxStatus'})
				}

				//TODO remove the dxStatus types code transfered to summary.
				scope.severityStatus = [];
				for(var severityStatusI = 0; severityStatusI < encEnumList.allergyServerity.length; severityStatusI++){
					scope.severityStatus.push({val: severityStatusI, name: encEnumList.allergyServerity[severityStatusI]+'_severity'})
				}

				//TODO remove the habit types code transfered to summary.
				scope.habitTypes = [];
				scope.frequencyOptions = [];
				for(var habitTypeI = 0; habitTypeI < encEnumList.typeHabit.length; habitTypeI++){
					scope.habitTypes.push({val: habitTypeI, name: encEnumList.typeHabit[habitTypeI]})
					scope.frequencyOptions[habitTypeI] = [];
					for(var frequencyI = 0; frequencyI < encEnumList.lstLifeHabitFrequency.length; frequencyI++){
						scope.frequencyOptions[habitTypeI].push({
							val: frequencyI, 
							name: encEnumList.typeHabit[habitTypeI] + "." + encEnumList.lstLifeHabitFrequency[frequencyI] })
					}
				}

				scope.hideNav = function(title, enc, nav ){
					if(alwaysHiddenSections.indexOf(title) !== -1 ){
						return true;
					}
					if(scope.editEnc.editMode){
						return scope.isSummarySpecific(title);
					}
					if(scope.fullMenu){
						return false;
					}
					if(scope.entryDefs[title] && 
						scope.entryDefs[title].hide && 
						scope.entryDefs[title].hide(enc)){
						return true;
					}else if(!scope.entryDefs[title] && nav.hide && nav.hide()){
						return true;
					}else {
						return false;
					}
				}

				scope.toggleFullMenu = function(){
					scope.fullMenu = !scope.fullMenu;
				}
				function clearEmptyRx(){
					if(scope.editEnc.lstPrescription &&
						scope.editEnc.lstPrescription.length > 0){
						for (let i = scope.editEnc.lstPrescription.length - 1; i > -1; i--) {
							const e = scope.editEnc.lstPrescription[i];
							if(e.viewbag && !(e.viewbag.item.baseDrugName) && !(e.viewbag.item.name)){ // delete if no name was entered clear if empty
								scope.encFormOptions.cancelItemEdit(e, scope.entryDefs.lstPrescription, false)
							}
						}
					}
				}

				function prepForSave(){
					if(scope.isDirty){
						scope.editEnc.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					if(scope.editEnc.viewbag && scope.editEnc.viewbag.isNew){
						scope.editEnc.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
					}
					// clearEmptyRx();
					var invalid = false;
					//set section to read mode
					_.each(allEncSections, function(e){
						def = scope.entryDefs[e];
//						for(var i = 0 ; scope.editEnc[def.title] && i < scope.editEnc[def.title].length; i++){
						if (scope.editEnc[def.title]) {
							for(var i = scope.editEnc[def.title].length-1; i >= 0 ; i--){
								if (scope.editEnc[def.title][i].viewbag) {
									if (def.isAllEmpty && def.isAllEmpty(scope.editEnc[def.title][i].viewbag.item)) {
										scope.editEnc[def.title][i].viewbag.item.modificationStatus = ModificationStatus.STATUS_DELETED;
										scope.editEnc[def.title].splice(i, 1);
									} else if(scope.editEnc[def.title][i].editMode){
										if(!scope.encFormOptions.saveItemEdit(
												scope.editEnc[def.title][i].viewbag.item, 
												scope.editEnc[def.title][i], def, true)){
											invalid = true;
										}
									}
								}
							}
						}
						def.read = true;
						if(def.title === HEADERSECTION){

						}
					});
					return !invalid;
				}

				scope.saving = false;
				function saving(isSaving){
					if(isSaving){
						scope.saving = true;
					}else{
						$timeout(function(){
							scope.saving = false;
						}, 2000);
					}
				}
				
				scope.presaveEncounterCount = 0;
				scope.presaveEncounter;

				function removeEncounterGuid(){
					delete scope.editEnc.guid;
					delete scope.enc.guid;
				}

				function removeItemGuid(item){
					if(item && item.viewbag && item.viewbag.item){
						delete item.viewbag.item.guid;
					}
				}

				function setEncounterGuid(){
					if(!scope.editEnc.guid){
						scope.editEnc.guid = UUID.generate();
						scope.editEnc.encounterTypeS = EncounterAccessor.allEncTypes[scope.editEnc.encounterType];
						encLists.forEach(function(e){
							if(scope.editEnc[e] && scope.editEnc[e].length){
								for(var i = 0; i < scope.editEnc[e].length; i++){
									setItemGuid(scope.editEnc[e][i])
								};
							}
						});
						['tbrObj', 'tbcObj'].forEach(function(e){
							setItemGuid(scope.editEnc[e]);
						})
						setPresaveEncounter(angular.copy(scope.editEnc))
						return true;
					}
					return false;
				}

				function setPresaveEncounter(enc){
					model.safeCall(function(){
						scope.presaveEncounter = enc;
						scope.enc.guid = scope.editEnc.guid;
						if (scope.quickViewData && scope.quickViewData.pat && scope.quickViewData.pat.viewbag && scope.quickViewData.pat.viewbag.patData) {
							var pd = scope.quickViewData.pat.viewbag.patData;
							pd.presaveenc = pd.presaveenc && Array.isArray(pd.presaveenc) ? pd.presaveenc.push(enc):[enc];
						} else {
							pd.presaveenc = [enc];
						}
					})
				}

				function setItemGuid(item){
					if(item && !item.guid){
						item.guid = UUID.generate();
						if(item.viewbag && item.viewbag.item){
							item.viewbag.item.guid = item.guid;
						}
					}
				}

				//When called without parameters the encounter is sent to presave
				// item: specific item to send to presave. eg scope.editEnc.lstNote[i]
				// list: list name string eg 'lstNote'
				scope.commitForPresave = function(item, list){
					if(item || !scope.enc.guid){
						setItemGuid(item);
						//Make sure editable encounter has guid.
						if(!setEncounterGuid()){
							// Si le 'presaveEncounter' est vide ce que un presave s'est deja fait parce que editEnc a deja un guid.
							if(!scope.presaveEncounter){
								// scope.presaveEncounter = {guid:scope.editEnc.guid};
								scope.presaveEncounter = angular.copy(scope.editEnc);
								encLists.forEach(function(e){
									// delete les listes parce que les données des listes sont sauvegardées granulairement.
									delete scope.presaveEncounter[e];
								});
							}
							if(scope.presaveEncounter[list]){
								var i = _.findIndex(scope.presaveEncounter[list], function(e){return e.guid === item.guid });
								if(i > -1){
									scope.presaveEncounter[list][i] = item;
								}else{
									scope.presaveEncounter[list].push(item);
								}
							}else{
								scope.presaveEncounter[list] =[item];
							}
						}
					}

					//Send presave to jetty server resets timer everytime it is called.
					activatePresave();
				};

				function cleanForPresave(enc){
					delete enc.viewbag;
					encLists.forEach(function(e){
						if(enc[e]){
							for (let i = 0; i < enc[e].length; i++) {
								if(enc[e][i].viewbag && enc[e][i].viewbag.item){
									enc[e][i] = enc[e][i].viewbag.item;
									enc[e][i].editMode = true;
									def = scope.entryDefs[e];
									if (def.onPreSave) {
										var item = angular.copy(enc[e][i]);
										def.onPreSave(item, null, def);//pour mettre en SI PRN
										enc[e][i] = item;
									}
								}
							}
						}
					});
					return enc;
				}

				function refreshEditEncEditMode(){
					var enc = scope.editEnc;
					if(enc.editMode){
						scope.edit(true);
					}
					encLists.forEach(function(e){
						if(enc[e]){
							for (let i = 0; i < enc[e].length; i++) {
								if(enc[e][i].editMode){
									scope.encFormOptions.editItem(enc[e][i],e );
								}
							}
						}
					});
				}
				function askForNip (type, pageWithItems, fct) {
					var qconfirmOptions = {templateUrl: 'getNipForSignature_index.html',
						msgText: {msg: ""},
						qconfirm: {
							hideNo: true,
							yesTitle: "Ok",
							beforeYes: function(e, obj){
								fct(type, pageWithItems, obj.msgText.msg);
							},
							beforeCancel: function(){
								fct(type, pageWithItems);
							}
					}};
					QConfirm.open(qconfirmOptions, {windowClass:'top-modal'});					
				}
				var PRINTSTATUS = 'P';
				var FAXSTATUS = 'F';
				scope.printDirectEncounter = function(type){
					if (model.clientPreferences().needPin==true && model.user().session.hasSignature===true) {
						askForNip(type, null, printDirectEncounter);
					} else {
						printDirectEncounter(type);
					}					
				};
				function printDirectEncounter(type, unused, nip) {
					if(type === PRINTSTATUS){
						EncounterAccessor.printDirectEncounter({enc:scope.editEnc, nip:nip}, function(res){
							model.notice().success($filter('translate')('PRINT_SERVER_SUCCESS'));                               
						});
					}else{
						FlView.open({templateUrl: "/dashboard/resources/ofys/fax/fax.html?v=ba", patient: scope.quickViewData.pat, showCoverPageOptions: true }, {
							backdrop: 'static',windowClass: "faxmodal"}).then(function(faxdata){
							EncounterAccessor.printDirectEncounter({enc: scope.editEnc, faxdata: faxdata, nip:nip}, function(res){
								model.notice().success($filter('translate')('FAX_SERVER_SUCCESS'));                               
							})
						});
					}					
				}
				scope.printEncounter = function(){
					EncounterAccessor.printEncounter(scope.editEnc, function(res){
						model.notice().success($filter('translate')('embedPrintPatient'));                               
					});
				};
				
				function getPrintPayload (pageWithItems){
					var payload = {enc: scope.editEnc};
					if(pageWithItems){
						payload.pageWithItems = pageWithItems;
					}
					return payload
				}
				scope.doPrintRxPicker = function(isRxFormPrint, type, pageWithItems){
					if(isRxFormPrint){
						scope.printRxAndForm(type, pageWithItems);
					}else{
						scope.printRx(type, pageWithItems);
					}
				};
				scope.getPrintOrFax = function(){
					return $filter('translate')('printRx' + model.prefSettings('user_settings_LastUsedPrintFax'));
				};
				scope.printRx = function(type, pageWithItems){
					if (model.clientPreferences().needPin==true && model.user().session.hasSignature===true) {
						askForNip(type, pageWithItems, printRx);
					} else {
						printRx(type, pageWithItems);
					}					
				};

				function printRx(type, pageWithItems, nip) {
					var payload = getPrintPayload(pageWithItems);
					if (nip) payload.nip = nip;
					if(type === PRINTSTATUS){
						EncounterAccessor.printRx(payload, function(res){
							model.notice().success($filter('translate')('PRINT_SERVER_SUCCESS'));                               
						});
					}else{
						FlView.open({templateUrl: "/dashboard/resources/ofys/fax/fax.html?v=ba", patient: scope.quickViewData.pat, showCoverPageOptions: true }, {
							backdrop: 'static',windowClass: "faxmodal"}).then(function(faxdata){
							payload.faxdata = faxdata;
							EncounterAccessor.printRx(payload, function(res){
								model.notice().success($filter('translate')('FAX_SERVER_SUCCESS'));                               
							})
						});
					}					
				}
				
				scope.printRxAndForm = function(type, pageWithItems){
					if (model.clientPreferences().needPin==true && model.user().session.hasSignature===true) {
						askForNip(type, pageWithItems, printRxAndForm);
					} else {
						printRxAndForm(type, pageWithItems);
					}					
					
				};
				function printRxAndForm(type, pageWithItems, nip) {
					var payload = getPrintPayload(pageWithItems);
					if (nip) payload.nip = nip;
					if(type === PRINTSTATUS){
						EncounterAccessor.printRxAndForm(payload, function(res){
							model.notice().success($filter('translate')('PRINT_SERVER_SUCCESS'));                               
						});
					}else{
						FlView.open({templateUrl: "/dashboard/resources/ofys/fax/fax.html?v=ba", patient: scope.quickViewData.pat, showCoverPageOptions: true }, {
							backdrop: 'static',windowClass: "faxmodal"}).then(function(faxdata){
							payload.faxdata = faxdata;
							EncounterAccessor.printRxAndForm(payload, function(res){
								model.notice().success($filter('translate')('FAX_SERVER_SUCCESS'));                               
							})
						});
					}					
				}
				//A presave encounter is created with a UUID that is unique per encounter
				// When a presave is triggered, the presave encounter is saved to the local server.
				// If the save fails, it fails silently and tries later.
				scope.presave = function(){
					if(scope.presaveEncounter){
						var presave = cleanForPresave(scope.presaveEncounter)
						delete scope.presaveEncounter;
						
						// return ;
						return EncounterAccessor.preSaveEnc(presave, function(res){
							var savedElem = res;
							console.log("Finished presave successfully");
						}, function(res){
						});
					}else{
					}
				};

				function setReadMode(){
					scope.$eval(attrs.options).editMode = false;//in case of new encounter.. change the state
					scope.enc.editMode = false;
					// scope.viewOptions.editMode = false;
					if(scope.editEnc && scope.editEnc.viewbag){
						delete scope.editEnc.viewbag.isNew;
					}
					var def;
					//set section to read mode
					_.each(allEncSections, function(e){
						def = scope.entryDefs[e];
						for(var i = 0 ; scope.editEnc[def.title] && i < scope.editEnc[def.title].length; i++){
							if(scope.editEnc[def.title][i].editMode){
								scope.encFormOptions.cancelItemEdit(scope.editEnc[def.title][i], def, true)
							}
						}
						def.read = true;
					});
				}
				// var dl = getActiveDocLenght();
				// if(dl > 0){
				// 	if(!scope.enc.viewbag.currentdoc){
				// 		scope.setActiveDoc(dl - 1)
				// 	}
				// 	var i = scope.enc.activeDocs.indexOf(scope.enc.viewbag.currentdoc)
				// 	scope.closeOpenDoc(i, function(){cascadeClose(event)});
				// }else{
				// 	closeEncounterContext(event)
				// }
				function hasActiveDocs(){
					var dl = getActiveDocLenght();
					return dl > 0
				}
				function hasDirtyActiveDocs(){
					var dirty = false;
					var dl = getActiveDocLenght();
					for (var i = 0; i < dl && !dirty; i++) {
						var doc = scope.enc.activeDocs[i];
						dirty = docIsDirty(doc);
					} 
					return dirty;
				}
				
				function docIsDirty(doc){
					return doc.act.editMode;
				}

				function getActiveDocsRefrences(){
					if(hasActiveDocs()){
						return {docs: scope.enc.activeDocs, current: scope.enc.viewbag.currentdoc}
					}
				}
				scope.getPatient = function() {
					return scope.quickViewData.pat;
				};
				scope.openRxVigilanceEngineQueryViewer = function() {
					var pt = scope.getPatient();
					if (pt.viewbag.analyseEncRxv===undefined) pt.viewbag.analyseEncRxv = {};
					if (pt.viewbag.analyseEncRxv.isWorking===true) return;					
					if (pt.viewbag.analyseEncRxv.rxvEngineOutput!==undefined) {
						rxvigilance.openRxViglanceService(rxvigilance.getPerspective, pt.viewbag.analyseEncRxv.rxvEngineOutput, undefined, pt.viewbag.analyseEncRxv);
					} else {
						pt.viewbag.analyseEncRxv.isWorking = true;
						pt.viewbag.analyseEncRxv.rxvEngineOutput = undefined;
						var addedRx = []; var lstRx = scope.getLstPrescription();
						for (var i = 0; i < lstRx.length; i++) {
							addedRx.push(lstRx[i]);
						}
						rxvigilance.openRxViglanceService(rxvigilance.engineQueryJsonShow, pt, addedRx, pt.viewbag.analyseEncRxv);
					}
				};
				scope.openRxVigilanceMonog = function(item){
					rxvigilance.openRxViglanceService(rxvigilance.openMonograph, item);
				};
				scope.openRxVigilanceEngineQueryJson = function(pt) {
					if (pt.viewbag.analyseEncRxv===undefined) pt.viewbag.analyseEncRxv = {};
					if (pt.viewbag.analyseEncRxv.isWorking===true) return;
					pt.viewbag.analyseEncRxv.isWorking = true;
					var addedRx = []; var lstRx = scope.getLstPrescription();
					for (var i = 0; i < lstRx.length; i++) {
						addedRx.push(lstRx[i]);
					}
					rxvigilance.openRxViglanceService(rxvigilance.engineQueryJson, pt, addedRx, pt.viewbag.analyseEncRxv);
				};

				scope.getLstPrescription = function() {
					return scope.editEnc && scope.editEnc.lstPrescription ? scope.editEnc.lstPrescription : [];
				};

				scope.save = function(){
					if(hasDirtyActiveDocs()){
						model.notice().warn($filter('translate')("SaveEncounterActiveDocs"));
						return;
					}
					if(scope.editEnc && scope.headerOkToClose()){
						if(!scope.saving && prepForSave()){
							saving(true);
							if (scope.isStagiaire===false && scope.editEnc.tbrObj && (scope.editEnc.tbrObj.supervisor || scope.editEnc.tbrObj.deleted===false)) {
								if (scope.editEnc.tbrObj.supervisor) delete scope.editEnc.tbrObj.supervisor;
								if (scope.editEnc.tbrObj.deleted===false) scope.editEnc.tbrObj.deleted=true;
								scope.editEnc.tbrObj.modificationStatus = ModificationStatus.STATUS_UPDATED;
							}
							var pat = _.omit(scope.quickViewData.pat, 'viewbag');
							pat = _.omit(pat,
									['lstConsentement','lstPatientIdentifier','lstPatientProfessionnal','bloodType','messageAppointment','lastVerificationDate','lastActivityDate',
										'expirationCAM','fatherName','spouseName','motherName','fatherHin','motherHin','tutorName','lastProfileVersion','treatingProfessionnal','txProfName',
										'isSensible','isScanned','custodyTerms','lstPatientAlerts','mother','father','tutor','inactiveDate','inactiveRaison',
										'b2bInformation','sofyAuthorized','className','user','searchLastName','searchFirstName','race','maritalStatus','note',
										'age','oAge','ageStr','citizenship','decorators','lstContactInformation','lstAddress','lstSites']);							
							var encounterRequest = {encounter:scope.editEnc, patient:pat};
							var lstRxModified = scope.editEnc.lstPrescription ? scope.editEnc.lstPrescription.filterFast(function(a){return a.modificationStatus!=='STATUS_NEUTRAL';}) : false;
							stopActivePresave();
							return EncounterAccessor.saveEnc(encounterRequest, function(res){
								var savedElem = res && res.className=="CEncounter" ? res : res.data;
								model.safeCall(deletePresaved);
								OfysUtils.update(scope.enc, savedElem);
								loadEnc(scope.enc);
								
								// TODO à valider
								var prof = model.user().profil;
								var session = model.user().session;
								var user = session.user;
								var isBilling = user.factType && user.factTupe != 'AUCUN';
								var apiKey = isBilling===true ? session.apiKeyOrToken : undefined;
								var xacteUserName = user.factUsername;
								var isOkBill = prof!==undefined && prof.code!==undefined && apiKey!==undefined && xacteUserName!==undefined;
								if (isOkBill===true) {
									var encProf = scope.enc.lstProf.filter(function(e) {return e.idProfessionnalAnchor==prof.id;}).sort(function(f, g) {return  f.entryDate>g.entryDate ? 1 : -1;});
									if (encProf.length>0) {
										scope.enc.profEnc = encProf[0];
									}
								}
								
								setReadMode();
								model.notice().success($filter('translate')('successfulSave'));
								// scope.formDirty()//Certain cases the dirty state is not remove. Must be called to reset.
								model.encounterUpdated(true);
								model.actUpdated(true);
								//unlock savingPatient function
								saving();
								// DCI OFF
								//if (lstRxModified.length>0) {
								//	var rxName = "- - - ORDONNANCES - - -";
								//	lstRxModified.forEach(function(entry) {
								//		rxName += '\n' + (entry.modificationStatus==='STATUS_DELETED' ? '<SUPP> ' : '') + entry.name + ' ' + entry.strength;
								//	});
								//	var v = {note: rxName, linkType:1, idLink: scope.editEnc.idPatientAnchor, idPatient: scope.editEnc.idPatientAnchor, patient: scope.getPatient(), parseMessage: true};
								//	TaskAccessor.openNew(v);
								//}
							}, function(res){
								// si la sauvegarde échoue s'assurrer que le header reste en mode edition.
								// pour corriger le bug d'un resident qui sauvegarde et si ça échoue il n'arrive pas à ajouter un superviseur.
								scope.entryDefs.header.read = false

								//unlock savingPatient function
								saving();
								// model.notice().fail(res.status + ' : ' + $filter('translate')('failedSave'));
							});
						}
					}else{
						// model.notice().fail($filter('translate')(msg));
					}
					return $q(function(resolve, reject) { 
						reject($filter('translate')("Failed to save"));
					});
				};
				scope.selectSection = function(enc,nav ,entryDefs){
					if(scope.canAddSection(enc, nav, entryDefs) && !sectionHasEdit(enc,nav)){
						scope.encFormOptions.addNewItem(enc, nav.title)
					}
					$timeout(function(){
						scope.scrollTo(nav.title)
					}, 10);
				}

				function sectionHasEdit(enc,nav){
					if(enc[nav.title] && enc[nav.title].find(function(e){return e.editMode;})){
						return true;
					}else{
						return false;
					}
				}

				scope.canAddSection = function(editEnc, nav, entryDefs){
					return editEnc.editMode && nav.hovered && entryDefs[nav.title].read && !entryDefs[nav.title].multiple
				}
				scope.scrollTo = function(orig) {
					var p = '#'+orig+'_encSection'
					var o = $(p)[0];
					if (o) {
				    	o.scrollIntoView({behavior: "smooth", block: "start", inline: "nearest"});
					}
					$(".enc-content").removeClass("active")
					$(".enc-nav-header").removeClass("active")
					
					$('#'+orig+'enc-nav-header').addClass("active");
					$(p).addClass("active");
				};

				scope.$watch(attrs.encs, update);
			}
		}
	}]);

	encounter.directive('medRxTimes',['encEnumList','model','$filter','ModificationStatus', function(encEnumList, model, $filter, ModificationStatus){
		return {
			restrict: 'A',
			link: function(scope, element, attrs){
				scope.medRxTimes = {
						rxTimes : function(val) {
							if (arguments.length) {
								if (val!=null && val!=undefined) {
									model.prefSettings('med_rx_times', val);
								}
							} else {
								return model.prefSettings('med_rx_times');
							}
						},
						rxDefaut : function(val) {
							if (arguments.length) {
								if (val!=null && val!=undefined) {
									model.prefSettings('med_rx_defaut', val);									
								}
							} else {
								return model.prefSettings('med_rx_defaut');
							}
						}
					};
				scope.medRxTimesOptions = {
					apply: function(){
						var lstRx = scope.editEnc && scope.editEnc.lstPrescription ? scope.editEnc.lstPrescription : [];
						if (lstRx.length>0) {
							var times = model.prefSettings('med_rx_times');
							for (var i = 0; i < lstRx.length; i++) {
								var r = lstRx[i];
								r.rx = times;
								r.modificationStatus = ModificationStatus.STATUS_UPDATED;
								scope.commitForPresave(r, 'lstPrescription');
							}
							if(scope.formOptions){
								scope.formOptions.setFormStatus('dirty');
							}
							model.patientSumUpdated(true);
						}
						scope.$hide();
					}
				}

				function init(){
				}

				init();
			}
		}
	}]);

	encounter.directive('stopPrescription',['encEnumList','model','$filter','ModificationStatus', function(encEnumList, model, $filter, ModificationStatus){
		return {
			restrict: 'A',
			link: function(scope, element, attrs){
				scope.stopMedItem;
				if(!scope.formOptions && scope.item && scope.item.viewbag && scope.item.viewbag.item){
					scope.stopMedItem = scope.item.viewbag.item;
				}else {
					scope.stopMedItem = scope.item;
				}
				scope.severityStatus = [];
				for(var severityStatusI = 0; severityStatusI < encEnumList.allergyServerity.length; severityStatusI++){
					scope.severityStatus.push({val: severityStatusI, name: encEnumList.allergyServerity[severityStatusI]+'_severity'})
				}
				scope.allergyStatus = [];
				for(var allergyStatusI = 0; allergyStatusI < encEnumList.allAllergyProbability.length; allergyStatusI++){
//					scope.allergyStatus.push({val: encEnumList.allAllergyProbability[allergyStatusI], name: 'alProb_' + encEnumList.allAllergyProbability[allergyStatusI]})
					scope.allergyStatus.push({val: allergyStatusI, name: 'alProb_' + encEnumList.allAllergyProbability[allergyStatusI]})
				}

				scope.stopMedOptions = {
					stopDateDynaOptions: angular.copy({ hasCalendar: false }),
					allergyStatus: scope.allergyStatus,
					severityStatus: scope.severityStatus,
					activateMed: function(){
						scope.stopMedItem.severity= 0;
						scope.stopMedItem.allergy= 0;
						delete scope.stopMedItem.stopDateSD;
						delete scope.stopMedItem.stopReason;
						if(scope.formOptions){
							scope.formOptions.setFormStatus('dirty');
							model.patientSumUpdated(true);
						}
						scope.$hide();
					},
					stopMed: function(){
						scope.stopMedItem.stopDateSD = scope.reason.stopDate;
						scope.stopMedItem.stopReason = scope.reason.reason;
						if(!scope.stopMedItem.idDevice){// Ne pas l'ajouter pour les fournitures.
							scope.stopMedItem.allergy = scope.reason.allergy;
							scope.stopMedItem.allergyString = getAllergyString(scope.reason.allergy);
							scope.stopMedItem.severity = scope.reason.severity;
							scope.stopMedItem.severityString = getSeverityString(scope.reason.severity);
						}
						scope.stopMedItem.modificationStatus = ModificationStatus.STATUS_UPDATED;
						if(scope.formOptions){
							scope.formOptions.setFormStatus('dirty');
						}
					},
				}

				function getAllergyString(allergy){
					return $filter('translate')('alProb_'+encEnumList.allAllergyProbability[allergy]);
				}
				function getSeverityString(severity){
					return $filter('translate')(encEnumList.allergyServerity[severity]+'_severity');
				}

				function init(){
					scope.reason = {
						severity: 0,
						allergy: 0,
						stopDate: moment().format('YYYY-MM-DD'),
					}
					if(scope.stopMedItem.stopDateSD){
						scope.reason.stopDate = scope.stopMedItem.stopDateSD;
					}
					if(scope.stopMedItem.stopReason){
						scope.reason.reason = scope.stopMedItem.stopReason;
					}
					if(scope.stopMedItem.allergy){
						scope.reason.allergy = scope.stopMedItem.allergy;
					}
					if(scope.stopMedItem.severity){
						scope.reason.severity = scope.stopMedItem.severity;
					}

					if(scope.stopMedItem){
						scope.stopMedItem.stopMedOptions = scope.stopMedOptions;
					}
				}

				init();
			}
		}
	}]);

	encounter.directive('searchAllergy', ['$filter','$q', 'model','EncounterAccessor',
		function($filter, $q, model, EncounterAccessor){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				focus: '=?',
				model: '=?',
				searchTypes: '=?',
				filter: '=?'
			},
			template:
			'<div><button type="button" placeholder="Type" class="btn btn-default btn-sm mb-1" data-max-length-html="{{:translation:\'SELECTED\'|translate}}" data-placeholder="{{:translation:\'Choose among the following...\'|translate}}" ng-model="searchType" data-html="1" data-multiple="1" data-animation="am-flip-x" '+
			'bs-options="opt.val as \'AllergySearchComposite.\'+opt.name | translate for opt in lstAllergyTypes" bs-select> Action <span class="caret"></span>'+
			// '<select data-ng-model="item.viewbag.item.severity"'+
			// 	'data-ng-options="opt.val as \'AllergySearchComposite.\'+opt.name | translate for opt in lstAllergyTypes">'+
			// '</select>'+
			'</div>'+
			'<div><input type="text" style="width:100%" data-dyna-assist="drugSearchAssist" '+
			'data-ng-model="model" data-input-focus-function="focus"></input></div>',
			link: function(scope, element, attrs){
				scope.lstProfs = $filter('orderBy')(model.store.profs.list(), ['lastName', 'firstName']);
				scope.lstProfs.splice(0, 0, {});
			
				scope.lstAllergyTypes = [
					{name: "CLASSES_THERAPEUTIQUES", val: "DRUG_CLASSES"},
					{name: "INGREDIENTS", val: "INGREDIENTS"},
					{name: "GENERIQUES", val: "GENERIC_NAMES"},
					{name: "COMMERCIALS", val: "BRAND_NAMES"}
				];

				scope.searchType = ["GENERIC_NAMES","BRAND_NAMES"];
				function drugName(drug){
					return drug.name;
				}
				
				scope.drugSearchAssist = {
					// assistId: "autocomplete_patient_professional",
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					dynaType: document.getElementsByTagName("BODY")[0],
					trigger: 'focus',
					listWidth: 450,
					getAsyncData: function(query, assist){
						// return $q(function(resolve, reject) {
						// 	resolve($filter('filter')(scope.lstProfs, query, scope.filter));
						// });
						// console.log(scope.searchType);
						// return;
						if(query.length < 4){
							return $q(function(resolve, reject) {
								reject();
							});
						}
						return EncounterAccessor.searchAllergy({q:query, types: scope.searchType.join(",")}, angular.noop);
					},
					getKey: function(drug) {
						return drug.name;
					},
					selection: function(drug, assistObject) {
						if(scope.select){
							scope.select(drug);
						}
						if(!scope.$$phase) {
							scope.$digest();
						}
						return drugName(drug);
					}
				}
			}
		}
	}]);

	encounter.directive('searchDx', ['$filter','$q', 'model','EncounterAccessor',
		function($filter, $q, model, EncounterAccessor){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				focus: '=?',
				model: '=?',
				type: '=?',
				searchTypes: '=?',
				filter: '=?',
				options: '=?',
				initialList: '=?',
			},
			template:
			// '<div><button type="button" placeholder="Type" class="btn btn-default btn-sm mb-1" ng-model="searchType" data-html="1" data-multiple="1" data-animation="am-flip-x" '+
			// 'bs-options="opt.val as \'AllergySearchComposite.\'+opt.name | translate for opt in lstAllergyTypes" bs-select> Action <span class="caret"></span>'+
			'<select data-ng-if="options.showTypes" data-ng-model="type.ref"'+
				'data-ng-options="opt.val as opt.name | translate for opt in lstClassTypes">'+
			'</select>'+
			'<input type="text" class="ml-3" data-dyna-assist="dxSearchAssist" '+
			'data-ng-model="model"  data-ng-blur="verifyCode()" data-input-focus-function="focus"></input>',
			link: function(scope, element, attrs){
				var defaultOptions = {showTypes: true};
				scope.options = scope.options ? scope.options : {};
				scope.options = $.extend(angular.copy(defaultOptions), scope.options);
				scope.searchTypes = scope.searchTypes ? scope.searchTypes : ['cim10','cim9','cci', 'icpc2'];
//				scope.lstProfs = $filter('orderBy')(model.store.profs.list(), 'lastName');
				scope.lstProfs = model.store.profs.list();
				scope.lstProfs.splice(0, 0, {});
				if(!scope.type){
					scope.type = {ref:'cim10'};
				}

				scope.lstClassTypes = [
					{name: "CIM 10", val: "cim10"},
					{name: "CIM 9", val: "cim9"},
					{name: "CCI", val: "cci"},
					{name: "ICPC 2", val: "icpc2"},
					{name: "IMMUNISATION", val: "immunization"},
				].filter(function(e){return scope.searchTypes.indexOf(e.val) > -1});


				function drugName(dx){
					return dx.code;
				}

				scope.verifyCode = function (){
					if(scope.model){
						if(!scope.selected || scope.model !== scope.selected.code){
							//console.log(scope.type);
							
							EncounterAccessor.findDxCodeByCode({class:scope.type.ref, code: scope.model}, function(res){
								//Si il y a un match. on peut appeller la selection pour valider le code. si aucun retour afficher le message d'erreur.
								if(res){
									scope.model = scope.dxSearchAssist.selection(res);
								}else{
									scope.model = "";
								}
							});
						}
					}
				}
				
				scope.dxSearchAssist = {
					// assistId: "autocomplete_patient_professional",
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					trigger: 'focus',
					dynaType: document.getElementsByTagName("BODY")[0],
					debounce: 500,
					keepOnScreen: true,
					minChar: 0,
					listWidth: 450,
					getAsyncData: function(query, assist){
						if(query.length < 4){
							return $q(function(resolve, reject) {
								if(!scope.initialList || scope.initialList.length === 0){
									reject();
								}else{
									resolve(scope.initialList)
								}
							});
						}
						return EncounterAccessor.searchDx({q:query, code:scope.type.ref}, function(list){
							console.log(list.data);
						});
					},
					getKey: function(dx) {
						return dx.code + ' ' + dx.descriptionLong;
					},
					selection: function(dx, assistObject) {
						if(scope.select){
							scope.select(dx);
						}
						try{
							if(!scope.$$phase) {
								scope.$digest();
							}
						}catch(e){

						}
						scope.selected = dx;
						return drugName(dx);
					}
				}


			}
		}
	}]);


	encounter.controller('ExceptionMedicationController',
		['$scope', 'model', '$filter','DashWebSocket','$timeout', 'EncounterAccessor',
		function ($scope, model, $filter, DashWebSocket, $timeout, EncounterAccessor) {

			var ctrl = this;
			$scope.currentException = {}
			$scope.setCode = function(medEx){
				$scope.fl.ok(medEx);
			}
			$scope.openForm = function(medEx){
				var url = medEx.v.formUrlRoot +'/'+ medEx.v.formurl+ '.pdf';
				var data = {data: {}};
				data.data.pt = angular.copy(_.omit($scope.patient, 'viewbag'));
				data.data.rx = $scope.rx;
				data.data.rx.strength = $scope.rx.Teneur;
				data.data.rx.formatString = $scope.rx.Form;
				data.data.rx.din = $scope.rx.din;
				data.data.rx.baseDrugName = $scope.rx.othername;
				data.data.rx.name = $scope.rx.name;
				data.url = url;
				EncounterAccessor.prescriptionexceptionpdf(data);
				$scope.fl.ok();
			}

			ctrl.medEx = $scope.medEx;

			$timeout(function(){
				ctrl.fcInput()
			}, 310)
		}
	]);

	encounter.directive('followUp', ['$timeout','$filter', '$q', 'EncounterAccessor', 'TempAssistAccessor',
		function($timeout, $filter, $q, EncounterAccessor, TempAssistAccessor){
		return {
			restrict: 'EA',
			link: function(scope, element, attrs){
				/*
				FollowUp stub object.
				{
					date: ""
					name: "",
					value: "",
					inferieourInterval:"",
					superiourInterval: ""
				}*/
				scope.hasLaboCode = scope.fol!=undefined;
				
				scope.parseList = function(){
					if(scope.patient && 
						scope.patient && 
						scope.patient.viewbag && 
						scope.patient.viewbag.patData &&
						scope.patient.viewbag.patData.sum){
						var pd = scope.patient.viewbag.patData;
						var sum = pd.sum;
						if (scope.hasLaboCode) {
							function flc (o){ return o.c==scope.fol.c};
							var all = [];
							for (var i = 0; i < pd.lab.length; i++) {
								var l = pd.lab[i];
								all = all.concat(l.lstNs?l.lstNs.filter(flc):[], l.lstAbns?l.lstAbns.filter(flc):[], l.lstVeryAbns?l.lstVeryAbns.filter(flc):[]);
							}
							//all = _.filter(all, function(o){ return o.c==scope.fol.c});
							var lst = [];
							for (let i = 0; i < all.length; i++) {
								lst.push(getFollowUp(all[i].d, all[i].n, all[i].v, all[i].i, all[i].x, all[i].c));
							}							
							scope.followUps = lst;// getLstFollowUps(pd.lab, "LaboStructure");
							scope.activeRxList = scope.patient.viewbag.patData.sum.lstAllPrescription
							scope.gridData = getDateOnXData(scope.followUps);
							scope.gridData.view = _.map(scope.gridData.data, function(e){return {name: e.name}});
							scope.followUpTestListOption.data =  scope.gridData.view;
							scope.followUpOptions.columnDefs = scope.gridData.columnDefs;
							scope.followUpTestListOption.data =  scope.gridData.data;
							scope.chartLabs = [];
							scope.chartLabs.push(scope.followUpTestListOption.data[0].name);			
							scope.activeView('chart');
						} else { 
							scope.followUps = getLstFollowUps(sum.lstBloodPres, "BloodPres")
							.concat(getLstFollowUps(sum.lstBodyTemp, "BodyTemp"))
							.concat(getLstFollowUps(sum.lstFreq, "Freq"))
							.concat(getLstFollowUps(sum.lstMeasurement, "Measurement"))
							.concat(getLstFollowUps(sum.lstCustMeasure, "CustMeasure"))
							.concat(getLstFollowUps(pd.lab, "LaboStructure"));
							scope.activeRxList = scope.patient.viewbag.patData.sum.lstAllPrescription
							scope.gridData = getDateOnXData(scope.followUps);
							scope.gridData.view = _.map(scope.gridData.data, function(e){return {name: e.name}});
							scope.followUpTestListOption.data =  scope.gridData.view;
							scope.followUpOptions.columnDefs = scope.gridData.columnDefs;
							scope.updateTable();
						}
					}
				}

				scope.filterTest = function(q){
					if(q){
						var normalizeQuery = _.map(q.split(" "), function(e){
							return e.toLowerCase();
						});
						scope.opt.cfilter = getFilter(q);
						scope.followUpTestListOption.data = scope.gridData.data.filter(function(e){return hasString(normalizeQuery, e.name.toLowerCase())});
						
					}else{
						scope.followUpTestListOption.data =  scope.gridData.data;
					}
					scope.chartLabs = [];
					if(scope.followUpTestListOption.data.length > 0){
						scope.chartLabs.push(scope.followUpTestListOption.data[0].name);
					}
				};

				function getFilter(txt){
					for (var i = 0; i < scope.opt.filters.length; i++) {
						if(scope.opt.filters[i].text.trim() === txt.trim()){
							return scope.opt.filters[i]
						}
					}
				}

				function hasString(qArr, str){
					for (let i = 0; i < qArr.length; i++) {
						if(str.indexOf(qArr[i]) > -1){
							return true;
						}
					}
					return false;
				}

				function getDateOnXData(list){
					var res =  {uniqueDays:_.uniq(_.pluck(list, 'day')).sort(), data: []};
					var groupByName = _.groupBy(list, "name");
					var allNames = Object.keys(groupByName);
					// scope.chartLabs = angular.copy(allNames);
					for (var i = 0; i < allNames.length; i++) {
						var element = {name: allNames[i]};
						groupByName[allNames[i]].forEach(function(obj) {
							element[obj.day+""] = obj;
						})
						res.data.push(element)
					}
					res.columnDefs = getDateOnXColumnDef(res.uniqueDays);
					return res;
				}

				function num(str){
					return str.replace(">").replace('<')*1
				}
				function comparemin(min, val){
					return(min !== undefined && val !== undefined && num(min)> val)
				}
				function comparemax(max, val){
					return(max !== undefined && val !== undefined && num(max) < val)
				}
				function sortNumber(a,b) {
					return a - b;
				}
				function getDateOnXColumnDef(uniqueDays){
					var res = [];
					uniqueDays = uniqueDays.filter(function(e){return moment.unix(e).isValid()}).sort(sortNumber).reverse();
					res.push({ displayName:'Name', pinnedLeft:true, enablePinning:true, hidePinLeft: false, hidePinRight: true , enableColumnMenu: false, name: 'name', minWidth:200, width: "*"})
					for (var i = 0; i < uniqueDays.length; i++) {
						res.push({ 
							displayName:moment.unix(uniqueDays[i]).format("YYYY-MM-DD"), 
							enableColumnMenu: false, 
							cellClass: function(grid, row, col){
								var field = col.name.split('.')[0];
								if(row.entity[field]){
									if(comparemin(row.entity[field].min, row.entity[field].value)){
										return "min_critic critic";
									}
									if(comparemax(row.entity[field].max, row.entity[field].value)){
										return "max_critic critic";
									}
								}
							},
							cellTooltip: function(row, col) {
								var res = "( "+ row.entity.name + " )"
								var field = col.name.split('.')[0]
								if(row.entity[field]){
									if(row.entity[field].min){
										res += " Min: " + row.entity[field].min;
									}
									if(row.entity[field].max){
										res += " Max: " + row.entity[field].max;
									}
								}
								return res;
							},
							name: uniqueDays[i]+".value", 
							width: 100
						})
					}
					return res;
				}


				scope.chartLabs = [];
				scope.updatechart = _.throttle(function (){
					if(scope.chartFrame){
						var chartValues = getLabData(scope.followUps, scope.chartLabs.join(", "));
						var chartRxData = {patId: scope.patient.id,start: unixToStr(scope.gridData.uniqueDays[0]), end: unixToStr(scope.gridData.uniqueDays[scope.gridData.uniqueDays.length -1])};
						getRxData(chartRxData).then(function (response) {
							var rxdata;
							if(response.data){
								rxdata = response.data;
							}else{
								rxdata = response;
							}
							if(rxdata.rxGantt){
								rxdata.rxGantt = JSON.parse(rxdata.rxGantt);
							}
							if(rxdata.rxName){
								rxdata.rxName = JSON.parse(rxdata.rxName);
							}
							if(scope.chartLabs.length > 0){
								scope.chartFrame.setDatas(chartValues, rxdata.rxGantt, rxdata.rxName)
								selectInGrid(scope.chartGridApi, scope.followUpTestListOption, scope.chartLabs.join(" "))
							}else{
								delete scope.chartFrame;
							}
						});
					}
				}, 100, {trailing: true})
				function unixToStr(unix){
					return moment.unix(unix).format("YYYY-MM-DD");
				}
				scope.updateTable = _.throttle(function (){
					if(scope.chartLabs && scope.chartLabs.length > 0){
						var res = getTableData(scope.gridData.data, scope.chartLabs.join(", "))
						scope.followUpOptions.data = res.data;
						scope.followUpOptions.columnDefs = res.columnDefs;
					}else{
						scope.followUpOptions.data = [];
					}
				}, 10, {trailing: false});

				scope.saveFilter = _.throttle(function(){
					if(scope.opt.searchTextTemplateName && scope.opt.searchText){
						TempAssistAccessor.
						quicksave({idType: 32, txt: scope.opt.searchText, name: scope.opt.searchTextTemplateName}).
						then(function(){
							updateFilters().then(function(){
								scope.opt.cfilter = getFilter(scope.opt.searchText);
							});
						}, function(){
	
						})
					}
				}, 100, {trailing: false});

				function updateFilters(){
					return TempAssistAccessor.api.getAssistText("32", "").then(function(res){
						scope.opt.filters = _.map(res.data, function(e){return {name: e.name, text: e.text}});
					})
				}
				
				scope.displayChartLoaded = function(iframe){
					if(iframe && iframe[0] &&  
						iframe[0].contentWindow && 
						iframe[0].contentWindow.setDatas){
						var wx = iframe[0].contentWindow;
						scope.chartFrame = wx;
						scope.updatechart();
					}
					
				}

				function selectInGrid(grid,options, names){
					if(grid && grid.selection){
						for (var i = 0; i < options.data.length; i++) {
							if( names.indexOf(options.data[i].name) > -1){
								grid.selection.selectRow(options.data[i]);
							}
						}
					}
				}

				function getTableData(data, include){
					var res =  {data:[], columnDefs: []};
					var days = [];
					if(include){
						data.forEach(function(e){
							if(include.indexOf(e.name) > -1 ){
								res.data.push(e);
								days = days.concat(Object.keys(e).filter(function (e) {
									return moment.unix(e).isValid();
								}));
							}
						})
						res.columnDefs = getDateOnXColumnDef(_.uniq(days).map(function(e){return e * 1}));
					}
					return res;
				}

				function getLabData(data, include){
					var res = [];
					data = _.groupBy(data, 'name')
					var keys = Object.keys(data);
					if(include){
						keys = keys.filter(function (e) {
							return include.indexOf(e) > -1;
						})
					}
					// scope.chartLabs = [];
					for (var i = 0; i < keys.length && i < 5 && include; i++) {
						var elem = {
							label:keys[i],
							yaxis: i+1,
							data: []
						}
						
						for (var j = 0; j < data[keys[i]].length; j++) {
							elem.data.push([
								moment(data[keys[i]][j].date, "YYYY-MM-DD HH:mm:ss").format('x'),
								data[keys[i]][j].value
							]);
						}
						res.push(elem);
						// scope.chartLabs.push(keys[i]);
					}
					return res;
				}

				function getRxData(data){
					var res = {rxData: null, rxNames: null};
					if(scope.opt.showRx && data && data.patId){
						return EncounterAccessor.followUpChartRx(data)
					}else{
						return $q(function(resolve, reject){resolve(res)});
					}
				}

				function getPresumedDateToRenvew(rx){
					var realEnd = null;

					if (!rx.stopDate) {
						realEnd = rx.endDate;
					} else if (!rx.endDate) {
						realEnd = rx.stopDate;
					} else if (rx.endDate > rx.stopDate) { // isBefore
						realEnd = rx.endDate;
					} else {
						realEnd = rx.stopDate;
					}

					if(!realEnd && rx.expiredDateSD){
						realEnd = moment(rx.expiredDateSD.replace('~',""), "YYYY-MM-DD").format("x")*1
					}
					return realEnd;
				}

				function getLstFollowUps(lst, fnName){
					var res = [];
					if(lst && Array.isArray(lst)){
						for (var i = 0; i < lst.length; i++) {
							scope[fnName+"FollowUp"](res,lst[i]);
						}
					}else{
						console.log("Not an array ");
					}
					return res;
				}

				scope.BloodPresFollowUp = function(lst, m){
					if(m.systolic !== undefined){
						lst.push(getFollowUp(m.timeVitalSignS,tr("systolic"), m.systolic))
					}
					if(m.diastolic !== undefined){
						lst.push(getFollowUp(m.timeVitalSignS,tr("diastolic"), m.diastolic))
					}
					if(m.pulse !== undefined){
						lst.push(getFollowUp(m.timeVitalSignS,tr("pulse"), m.pulse))
					}
					if(m.saturation !== undefined){
						lst.push(getFollowUp(m.timeVitalSignS,tr("saturation"), m.saturation))
					}
					return lst;
				}

				scope.BodyTempFollowUp = function(lst, m){
					if(m.bodyTemperature){
						lst.push(getFollowUp(m.timeVitalSignS,tr("bodyTemperature"), m.bodyTemperature))
					}
					return lst;
				}
				
				scope.FreqFollowUp = function(lst, m){
					if(m.respiration){
						lst.push(getFollowUp(m.timeVitalSignS,tr("respiration"), m.respiration))
					}
					return lst;
				}
				scope.MeasurementFollowUp = function(lst, m){
					//function getFollowUp(date, name, value, min, max, status){
					if(m.heightS1){
						lst.push(getFollowUp(m.timeVitalSignS,tr("height"), m.heightS1))
					}
					if(m.weightS2){
						lst.push(getFollowUp(m.timeVitalSignS,tr("weight"), m.weightS2))
					}
					return lst;
				}
				function tr(name){
				// ["weight","height","respiration","bodyTemperature","saturation","pulse","diastolic","systolic"]
					return $filter("translate")("cfu_"+name)
				}
				scope.LaboStructureFollowUp = function(lst, m){
					//function getFollowUp(date, name, value, min, max, status){
					var all = [];
					if(m.lstNs){
						all = all.concat(m.lstNs);
					}
					if(m.lstAbns){
						all = all.concat(m.lstAbns)
					}
					if(m.lstVeryAbns){
						all = all.concat(m.lstVeryAbns)
					}
					for (let i = 0; i < all.length; i++) {
						lst.push(getFollowUp(all[i].d, all[i].n, all[i].v, all[i].i, all[i].x, all[i].c));
					}
					return lst;
				}
				function decimal(n){
					if(!isNaN(n)){
						return ""+ (Math.round((n*1) * 100) / 100)
					}
				}
				scope.CustMeasureFollowUp = function(lst, m){
					lst.push(getFollowUp(m.timeVitalSignS, m.typeName, m.avalue))
					return lst;
				}
				/**
				 * 
				 * @param {string} date 
				 * @param {string} name 
				 * @param {string} value 
				 * @param {string} min : for labs
				 * @param {string} max : superior value for labs
				 * @param {int} status ://  0=norman, 1=anormal, 2=critique
				 */
				function getFollowUp(date, name, value, min, max, status){
					if(value && typeof value === 'string' && value.indexOf(',')){
						value = value.replace(",", '.')
					}

					return {
						day: (date ? moment(date).startOf('day').unix(): undefined),
						date: (date && date.length>10 ? date.substring(0, 10) : date),
						name: name,
						value:value,
						min:decimal(min),
						max: decimal(max),
						status: status, 
					};
				}

				scope.toggleSelection = function(test){
					test.selected = !!!test.selected;
				}
				scope.viewType = "table";

				scope.activeView = function(viewType){
					scope.viewType = viewType;
					$timeout(function(){
						if(scope.viewType === "chart" && scope.chartGridApi && scope.followUpTestListOption){
							selectInGrid(scope.chartGridApi, scope.followUpTestListOption, scope.chartLabs.join(" "))
						}else if(scope.viewType === "table"){
							delete scope.chartFrame;
						}
						updateDataView()
					}, 100);
				};

				scope.opt = {showRx: false, dateOnX: true}

				updateFilters()
// 				enableScrollbars: false,
// 						enableHorizontalScrollbar : 0,
// 						enableVerticalScrollbar : 0,
// 						useExternalPagination: true,
// 						totalItems: 29,
// 						data: scope.messages,
// 						enablePaginationControls: true,
// 						paginationPageSizes: [], //[25, 50, 100, 200],
// 						paginationPageSize: 25,
// 						multiSelect: false,
// 						enableRowSelection: true,
// 						showHeader: true,
// 						enableRowHeaderSelection: false,
// 						noUnselect: true,
// 						enableSorting: false,
// 						modifierKeysToMultiSelect: false,

				scope.followUpOptions = {
					data: [],
					enableRowHeaderSelection: false,
					enableRowSelection: false,
					multiSelect: false,
					noUnselect: false,
					columnDefs: [
						{ displayName: 'date', enableColumnMenu: false, name: 'date', width: "*"},
						{ displayName: 'name', enableColumnMenu: false, name: 'name', width: "*"},
						{ displayName: 'value', enableColumnMenu: false, name: 'value',width: "*"},
						{ displayName: 'min', enableColumnMenu: false, name: 'min', width: "*"},
						{ displayName: 'max', name: 'max', enableColumnMenu: false, width: "*"},
						{ displayName: 'status', enableColumnMenu: false, name: 'status', width: "*"},
					],
					onRegisterApi: function( gridApi ) {
						scope.gridApi = gridApi;
						// gridApi.selection.on.rowSelectionChanged(scope,function(row){
						// 	updateSelectedForChart(row.entity.name, row.isSelected);
						// });
					}						             
				};

				function updateSelectedForChart(name, select){
					var i = scope.chartLabs.indexOf(name);
					if(select){
						if(i === -1){
							scope.chartLabs.push(name);
						}
					}else{
						if(i > -1){
							scope.chartLabs.splice(i, 1);
						}
					}
				}

				function updateDataView(){
					if(scope.viewType === "chart"){
						scope.updatechart();
					}else if(scope.viewType === "table"){
						scope.updateTable();
					}
				}

				scope.followUpTestListOption = {
					data: [],
					enableRowHeaderSelection: true,
					enableRowSelection: true,
					multiSelect: true,
					// noUnselect: false,
					columnDefs: [
						{ displayName: $filter('translate')('RESULT_VAL'), enableColumnMenu: false, name: 'name'},
					],
					onRegisterApi: function( chartGridApi ) {
						scope.chartGridApi = chartGridApi;
						chartGridApi.selection.on.rowSelectionChanged(scope,function(row){
							updateSelectedForChart(row.entity.name, row.isSelected);
							updateDataView()
						});
						chartGridApi.selection.on.rowSelectionChangedBatch(scope,function(rows){
							for (var i = 0; i < rows.length; i++) {
								updateSelectedForChart(rows[i].entity.name, rows[i].isSelected);
							}
							updateDataView()
						});
					}						             
				};

				scope.parseList();
			}
		}
	}]);


	encounter.directive('searchRx', ['$filter','$q', 'model','EncounterAccessor','$popover','FlView',
		function($filter, $q, model, EncounterAccessor, $popover, FlView){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				q: '=?',
				focus: '=?',
				model: '=?',
				type: '=?',
				options: '=?',
				disabled:'=?',
				patient:'=?'
			},
			templateUrl:'searchRx_index.html',
			link: function(scope, element, attrs){
				function itemToString(item){
					return (item.soundex===1 ? "* " : "") + item.name;
				}
				
				function askMedicalExceptions(rx, select, patient){
// Code
// code: "PP205"
// note: ""
// per_aut: ""
// raison: " Dyspepsie non investiguée ou sans lésion repérée lors de l’investigation, avec prédominance de symptômes de reflux gastroœsophagien ou lorsque les symptômes de reflux gastroœsophagien ont été soulagés par un traitement initial et que ces derniers reviennent à l’arrêt des IPP et qu’ils sont présents au moins 3 jours par semaine. Durée de remboursement maximale: 12 mois "
//Formulaire
					var FORM = 'form', CODES = 'code';
					var exceptions = rx.exceptions.map(function(e){
						return {
							type:e.code ? CODES:FORM,
							v: e, 
							k: (e.formurl?e.formurl:e.code),
							desc: e.formraison?e.formraison:e.raison
						}
					});
					var exceptionforms = _.filter(exceptions, function(e){return e.type === FORM});
					var exceptioncodes = _.filter(exceptions, function(e){return e.type === CODES});
					var modalOptions = { templateUrl: "/dashboard/resources/ofys/encounter/entry/exception_med_popover.html?v=ba"};
					if(exceptioncodes && exceptioncodes.length > 0){
						modalOptions.code = exceptioncodes;
						modalOptions.medEx = exceptioncodes[0];
					}
					if(exceptionforms && exceptionforms.length > 0){
						modalOptions.forms = exceptionforms;
						modalOptions.medEx = exceptionforms[0];
					}
					modalOptions.rx = rx;
					modalOptions.patient = patient;						
					FlView.open(modalOptions, {windowClass: 'sm to-top'}).then(function(code){
						if(code && scope.options && scope.options.setException){
							scope.options.setException(code.v);
						}
					});
					// var input = $(element).find(".popover").click();
					// var myPopover = $popover(scope.elem[0], {content: 'RX reasons',title:"works?", trigger: 'manual', container: $('body')});
					// myPopover.show();
					// myPopover.onHide = function(){
					// 	select(rx);
					// }
				}

				scope.rxSearchAssist = {
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: true,
					hasHeader: false,
					trigger: 'focus',
					debounce: 500,
					keepOnScreen: true,
					listWidth: 250,
					descWidth: 250,
					maxHeight: 250,
					dynaType: document.getElementsByTagName("BODY")[0],
					getAsyncData: function(query, assist){
						var qry = query.trim();
						if(qry.length < 4){
							return $q(function(resolve, reject) {
								reject();
							});
						}
						//var idx = query.indexOf(" ");
						// var firstWord = idx===-1 ? query : query.substr(0, idx);
						return EncounterAccessor.searchDrug({q:qry}, angular.noop);
					},
					getKey: itemToString,
					getDescription: function(item){
						var exceptions = "";
						if(item.exceptions){
							exceptions = item.exceptions.map(function(e){
								return (e.formraison?e.formraison:e.raison) + '<br>';
							});
						}
						return item.othername + '<br>'+item.ramq +'<br><br>'+exceptions
					},
					selection: function(rx, assistObject) {
						if(scope.select){
							scope.select(rx);
						}
						
						if(rx.exceptions && scope.options && scope.options.inEncounter===true){
							askMedicalExceptions(rx, scope.select, scope.patient);
						}
						try{
							if(!scope.$$phase) {
								scope.$digest();
							}
						}catch(e){

						}
						scope.selected = rx;
						assistObject.close();
						return rx.product;
					}
				}
			}
		}
	}]);

	encounter.directive('searchDevice', ['$filter','$q', 'model','EncounterAccessor',
		function($filter, $q, model, EncounterAccessor){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				q: '=?',
				focus: '=?',
				model: '=?',
				type: '=?',
				options: '=?',
				disabled:'=?',
			},
			template:
			'<input type="text" class="col-xs-12" ng-disabled="disabled" '+
			'title="{{model}}" data-dyna-assist="devicesSearchAssist" data-ng-model="model"'+
			' data-input-focus-function="focus"></input>',
			link: function(scope, element, attrs){
				
				function itemToString(item){
					return item.v;
				}
				scope.devicesSearchAssist = {
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					trigger: 'res',
					debounce: 300,
					keepOnScreen: true,
					listWidth: 350,
					descWidth: 250,
					maxHeight: 250,
					dynaType: document.getElementsByTagName("BODY")[0],
					getList: function(data){
						var arr = Object.keys(data).map(function (key) {
							return {k:key, v:data[key]};
						});
						return arr;
					},
					getAsyncData: function(query, assist){
						if(query.length < 3){
							return $q(function(resolve, reject) {
								reject();
							});
						}
						return EncounterAccessor.searchDevices({q:query}, angular.noop);
					},
					getKey: itemToString,
					selection: function(rx, assistObject) {
						if(scope.select){
							scope.select(rx);
						}
						try{
							if(!scope.$$phase) {
								scope.$digest();
							}
						}catch(e){

						}
						scope.selected = rx;
						assistObject.close();
						return itemToString(rx);
					}
				}
			}
		}
	}]);
	
	encounter.directive('searchStrength', ['$filter','$q', 'model','EncounterAccessor',
		function($filter, $q, model, EncounterAccessor){
		return {
			restrict: 'E',
			scope: {
				select: '=?',
				q: '=?',
				n: '=?',
				focus: '=?',
				model: '=?',
			},
			template:'<input type="text" class="col-xs-12" title="{{model}}" required name="strength" data-dyna-assist="rxStrengthSearchAssist" data-ng-model="model" data-input-focus-function="focus"></input>',
			link: function(scope, element, attrs){
				function itemToString(item){
					return item.Teneur;
				}

				scope.rxStrengthSearchAssist = {
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					dynaType: document.getElementsByTagName("BODY")[0],
					trigger: 'focus',
					debounce: 500,
					listWidth: 200,
					maxHeight: 250,
//					updateDataSourceWithValues: function(assist){
//						return EncounterAccessor.searchRxForce(scope.q, function(res){
//							assist.setData(res.data);
//						});
//					},
					getAsyncData: function(query, assist){
						return EncounterAccessor.searchRxForce(scope.q, scope.n, angular.noop);
					},
					getKey: itemToString,
					selection: function(rx, assistObject) {
						if(scope.select){
							scope.select(rx);
						}
						try{
							if(!scope.$$phase) {
								scope.$digest();
							}
						}catch(e){

						}
						scope.selected = rx;
						assistObject.close();
						return itemToString(rx);
					}
				}

			}
		}
	}]);
	
	encounter.directive('searchPrescriptorPosology', ['$filter','$q', 'model','EncounterAccessor','$timeout',
		function($filter, $q, model, EncounterAccessor, $timeout){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				updatelst: '=',
				rxdata:'=',
				focus: '=?',
				model: '=?',
				filter: '=?'
			},
			template:'<input type="text" class="col-xs-12" title="{{model}}" data-dyna-assist="prescriptorPosSearchAssist" data-ng-model="model" data-input-focus-function="focus"></input>',
			link: function(scope, element, attrs){
				if(!scope.rxdata){
					scope.rxdata = [];
				}
				function addTxt(prefix, val){
					if(val != undefined){
						return prefix + val;
					}
					return "";
				}

				function itemToString(item){
					var poso = item.pos ? item.pos + " ": "";
					var freq = item.freq ? item.freq + " " : "";
	    			var qty = (OfysUtils.isEmpty(item.qte) ? "" : " # " + item.qte);
	    			var dur = (OfysUtils.isEmpty(item.jrs) ? "" : " x " + item.jrs + " "+ $filter('translate')('JRS'));
	    			var s = item.rep ? " &rArr; Ren x " + item.rep : " &rArr; NR";
	    			return poso + freq + qty + dur + s + '<hr style="color: #e9e9e9;margin: 0;margin-top:6px;">';
				}
				var posAssitObj = {};
				scope.prescriptorPosSearchAssist = {
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					trigger: 'res',
					dynaType: document.getElementsByTagName("BODY")[0],
					debounce: 500,
					minChar: 0,
					listWidth: 425,
					maxHeight: 250,
					useHtml: true,//Dangereux à utiliser, permet les injections de dépendance dans les champs de recherche
					updateDataSourceWithValues: function(assistObject){
						if (model.prefSettings('user_settings_ShowSuggPos')==true) {
							posAssitObj.obj = assistObject;
							if(scope.rxdata){
								assistObject.setData(scope.rxdata);
							}
						}
					},
					getAsyncData: function(query, assist){
						if (model.prefSettings('user_settings_ShowSuggPos')==true) {
							return $q(function(resolve, reject) {
								resolve(scope.rxdata ?$filter('filter')(scope.rxdata, query, scope.filter): []);
							});							
						} else {
							return $q(function(resolve, reject) {
								[];
							});								
						}
					},
					getKey: itemToString,
					selection: function(item, assistObject) {
						if(scope.select){
							scope.select(item);
						}
						if(!scope.$$phase) {
							scope.$digest();
						}
						return item.pos;
					}
				};

				scope.updatelst = function(lst){
					if (model.prefSettings('user_settings_ShowSuggPos')==true) {
						scope.rxdata = lst;
						if(posAssitObj.obj){
							$(posAssitObj.obj.baseElement).blur();
							$(posAssitObj.obj.baseElement).focus();
							posAssitObj.obj.open();
						}
					}
				}
			}
		}
	}]);

	
	encounter.directive('searchPrescriptorRoute', ['$filter','$q', 'model','EncounterAccessor',
		function($filter, $q, model, EncounterAccessor){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				focus: '=?',
				model: '=?',
				filter: '=?',
				validation: '=?',
				firstchange: '=?'
			},
			template:'<input type="text" class="col-xs-12" name="missingRoute" title="{{model}}" validfn="validateRoute" first-change-keypress="firstChangeMade" data-dyna-assist="prescriptorRouteSearchAssist" data-ng-model="model" data-input-focus-function="focus"></input>',
			link: function(scope, element, attrs){
				scope.lstRoutesOfAmin = [];
				var tags = {
					193000:['po'],//per OS
					214000:['sc'],//infusion, sous-cutanée
				}
				var ks = Object.keys(EncounterAccessor.allRouteOfAdmin);
				for (let i = 0; i < ks.length; i++) {
					const k = ks[i];
					var route = {key: k, val: EncounterAccessor.allRouteOfAdmin[k]};
					if(tags[k]){
						route.tags = tags[k]
					}
					scope.lstRoutesOfAmin.push(route);
				}
				function itemToString(item){
					return item.val;
				}
				
				scope.firstChangeMade = function(){
					if(scope.firstchange){
						scope.firstchange();
						scope.$parent.encForm.missingRoute.$validate();
					}
				}
				
				scope.validateRoute = function(){
					if(scope.validation){
						return scope.validation();
					}else{
						return true;
					}
				}
				
				scope.prescriptorRouteSearchAssist = {
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					trigger: 'focus',
					dynaType: document.getElementsByTagName("BODY")[0],
					debounce: 500,
					maxHeight: 250,
					listWidth: 200,
					updateDataSourceWithValues: function(assistObject){
						assistObject.setData(scope.lstRoutesOfAmin);
					},
					getAsyncData: function(query, assist){
						return $q(function(resolve, reject) {
							var res = $filter('filter')(scope.lstRoutesOfAmin, query, scope.filter);
							res = $filter('orderBy')(res, ['tags','val'])
							resolve(res);
						});
					},
					getKey: itemToString,
					selection: function(item, assistObject) {
						if(scope.select){
							scope.select(item);
						}
						if(!scope.$$phase) {
							scope.$digest();
						}
						scope.$parent.encForm.missingRoute.$validate();
						return itemToString(item);
					}
				}
			}
		}
	}]);
	
	
	encounter.directive('searchDrugFormat', ['$filter','$q', 'model','EncounterAccessor',
		function($filter, $q, model, EncounterAccessor){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				focus: '=?',
				model: '=?',
				filter: '=?',
				validation: '=?',
				firstchange: '=?'
			},
			template:'<input type="text" class="col-xs-12" name="missingFormat" title="{{model}}" validfn="validateFormat" first-change-keypress="firstChangeMade" data-dyna-assist="drugFormatSearchAssist" data-ng-model="model" data-input-focus-function="focus"></input>',
			link: function(scope, element, attrs){
				scope.lstDrugFormat = [];
				var ks = Object.keys(EncounterAccessor.allDrugFormat);
				for (let i = 0; i < ks.length; i++) {
					const k = ks[i];
					scope.lstDrugFormat.push({key: k, val: EncounterAccessor.allDrugFormat[k][1]});
				}
				function itemToString(item){
					return item.val;
				}
				
				scope.firstChangeMade = function(){
					if(scope.firstchange){
						scope.firstchange();
						scope.$parent.encForm.missingFormat.$validate();
					}
				}
				
				scope.validateFormat = function(){
					if(scope.validation){
						return scope.validation();
					}else{
						return true;
					}
				}
				
				scope.drugFormatSearchAssist = {
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					trigger: 'focus',
					dynaType: document.getElementsByTagName("BODY")[0],
					debounce: 500,
					maxHeight: 250,
					listWidth: 200,
					updateDataSourceWithValues: function(assistObject){
						assistObject.setData(scope.lstDrugFormat);
					},
					getAsyncData: function(query, assist){
						return $q(function(resolve, reject) {
							resolve($filter('filter')(scope.lstDrugFormat, query, scope.filter));
						});
					},
					getKey: itemToString,
					selection: function(item, assistObject) {
						if(scope.select){
							scope.select(item);
						}
						if(!scope.$$phase) {
							scope.$digest();
						}
						scope.$parent.encForm.missingFormat.$validate();
						return itemToString(item);
					}
				}
			}
		}
	}]);
	
	encounter.directive('searchPrescriptorSite', ['$filter','$q', 'model','EncounterAccessor',
		function($filter, $q, model, EncounterAccessor){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				focus: '=?',
				model: '=?',
				filter: '=?'
			},
			template:'<input type="text" class="col-xs-12" title="{{model}}" data-dyna-assist="prescriptorRouteSearchAssist" data-ng-model="model" data-input-focus-function="focus"></input>',
			link: function(scope, element, attrs){
				scope.lstSitesOfAmin = [];
				var ks = Object.keys(EncounterAccessor.allSiteOfAdmin);
				for (let i = 0; i < ks.length; i++) {
					const k = ks[i];
					scope.lstSitesOfAmin.push({key: k, val: EncounterAccessor.allSiteOfAdmin[k]});
				}
				function itemToString(item){
					return item.val;
				}
				
				scope.prescriptorRouteSearchAssist = {
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					trigger: 'focus',
					dynaType: document.getElementsByTagName("BODY")[0],
					debounce: 500,
					maxHeight: 250,
					listWidth: 200,
					updateDataSourceWithValues: function(assistObject){
						assistObject.setData(scope.lstSitesOfAmin);
					},
					getAsyncData: function(query, assist){
						return $q(function(resolve, reject) {
							resolve($filter('filter')(scope.lstSitesOfAmin, query, scope.filter));
						});
					},
					getKey: itemToString,
					selection: function(item, assistObject) {
						if(scope.select){
							scope.select(item);
						}
						if(!scope.$$phase) {
							scope.$digest();
						}
						return itemToString(item);
					}
				}
			}
		}
	}]);


	encounter.directive('encBrowser', ['Markdown','$filter', '$q', 'model', 'EncounterAccessor', 'DashAPI', 'ProfAccessor',
		function (Markdown, $filter, $q, model, EncounterAccessor, DashAPI, ProfAccessor) {
			return {
				restrict: 'A',
				templateUrl: "/dashboard/resources/ofys/encounter/encounter_browser.html?v=ba",
				scope: {
					patient: '=encBrowser',
				},
				link: function(scope, element, attrs){
					scope.encbrowser = {
						options: {},
						viewdata: {},
						start: '',
						end: '',
						preset: 'all',
						lstNote: true,
						entryDef: {lstNote:{}, lstPrescription:{}},
					}

					var browserPresets = {
						all: function (enc) {
							scope.encbrowser.start = '';
							scope.encbrowser.end = '';
							scope.profGroupSelector.selectedList = [];
							scope.profSelector.selectedList = []
							// scope.encbrowser.start = '';
						},
						mine: function (enc) {
							scope.encbrowser.start = '';
							scope.encbrowser.end = '';
							scope.profGroupSelector.selectedList = [];
							console.log(model.user().profil.idAnchor);
							
							model.store.profs.get(model.user().profil.id, function(currProf){
							scope.profSelector.selectedList = [
								{
										name: scope.profSelector.selectorName(currProf),
										obj: currProf
								}
							]
							})
							filterTypes(enc, getFilters())
						},
						custom: function (enc) {
							filterTypes(enc, getFilters())
						}
					}

					function getFilters() {
						var res = angular.copy(browserFilters);
						for (var i = 0; i < res.length; i++) {
							res[i].init();
						}
						return res;
					}

					function filterDateRange(options, item, i, type) {
						var startCheck = true;
						var endCheck = true;
						if (options.hasStart &&
							item[type] &&
							!(isSameOrAfter(item[type], options.start))) {
							startCheck = false;
						}
						if (options.hasEnd &&
							item[type] &&
							!(isSameOrBefore(item[type], options.end))) {
							endCheck = false;
						}

						return startCheck && endCheck;
					}

					function filterAuthor(options, item, i, type) {
						//idProfessionnalAnchor
						var inGroup = !((options.validGroups.length > 0) || (options.validProfs.length > 0));
						var inProf = !((options.validGroups.length > 0) || (options.validProfs.length > 0));
						if (options.validGroups.length > 0){
							model.store.profs.get(item.idProfessionnalAnchor, function(prof){
								inGroup = options.validGroups.indexOf(prof.professionalType)>-1;
							});
						}
						if (options.validProfs.length > 0) {
							inProf = options.validProfs.indexOf(item.idProfessionnalAnchor)>-1;
						}
						return inGroup || inProf;
					}
					
					var browserFilters = [
						{
							name: "dateRangeFilter",
							init: function (enc) {
								this.hasStart = moment(scope.encbrowser.start).isValid();
								this.hasEnd = moment(scope.encbrowser.end).isValid();
								if (this.hasStart && this.hasEnd && moment(scope.encbrowser.end).isBefore(moment(scope.encbrowser.start))) {
									this.hasEnd = false;
								}
								if (this.hasStart) this.start = scope.encbrowser.start
								if (this.hasEnd) this.end = scope.encbrowser.end
							}, 
							types: {
								lstNote: function (options, item, i, type) {
									return filterDateRange(options, item, i, 'entryDateS')
								},
								lstPrescription: function (options, item, i, type) {
									return filterDateRange(options, item, i, 'entryDateSD')
								},
							},
						},
						{
							name: "authorFilter",
							init: function (enc) {
								this.validGroups = []
								this.validProfs = []

								for (let i = 0; i < scope.profGroupSelector.selectedList.length; i++) {
									const s = scope.profGroupSelector.selectedList[i];
									this.validGroups.push(s.obj.type);
								}
								for (let i = 0; i < scope.profSelector.selectedList.length; i++) {
									const s = scope.profSelector.selectedList[i];
									this.validProfs.push(s.obj.id);
								}
							}, 
							types: {
								lstNote: function (options, item, i, type) {
									return filterAuthor(options, item, i, type)
								},
								lstPrescription: function (options, item, i, type) {
									return filterAuthor(options, item, i, type)
								},
							},
						},
					];

					function isSameOrBefore(orig, test) {
						orig = getDateOnly(orig)
						return moment(orig).isSame(test) || 
								moment(orig).isBefore(test) ;
					}

					function isSameOrAfter(orig, test){
						orig = getDateOnly(orig)
						return moment(orig).isSame(test) || 
								moment(orig).isAfter(test) ;

					}
					function getDateOnly(orig){
						if (orig.length > 10) {
							orig = orig.substring(0, 10);
						}
						return orig;
					}
					var dataTypes = ['lstNote', 'lstPrescription'];

					function filterTypes(enc, filters){
						for (let i = 0; i < dataTypes.length; i++) {
							var datatype = dataTypes[i];// eg. lstNote
							enc[datatype] = enc[datatype].filter(function (el, index, array) {
								for (var j = 0; j < filters.length; j++) {
									var f = filters[j]
									if (!f.types[datatype](f, el, index, datatype)) {
										return false;
									}
								}
								return true;
							});
						}
					}

					scope.editEnc = {editMode: false}

					var notesBrowserFactory = { 
						lstNote:function(def){
							def.multiple = true;
							def.clearSeparation = true;
							def.noteTypes = scope.noteTypes;
							def.completeType = 20
							def.isAllEmpty = function(item) {
								return OfysUtils.isAllEmpty(item, ['note']);
							};
							def.setErrors = function(e){
								def.errors = e;
							}

							def.copyNote = function(str) {
								Markdown.copieStr = str;
							}
							def.pasteNote = function(item, editor) {
								if(editor){
									if(Markdown.copieStr.indexOf(Markdown.MD) > -1){
										editor.insertHTML(Markdown.toHTML(Markdown.copieStr.substring(Markdown.MD.length)));
										return;
									}
									editor.insertText(Markdown.copieStr)
								}
							}
						},
						lstPrescription:function(def){
							def.multiple = true;
							def.clearSeparation = true;
							def.noteTypes = scope.noteTypes;
							def.completeType = 20
							def.isAllEmpty = function(item) {
								return OfysUtils.isAllEmpty(item, ['note']);
							};
							def.setErrors = function(e){
								def.errors = e;
							}
						}
					}
					
					var allProfTypes ;

					function professionalGroupes(q) {
						return $q(function (resolve, reject) {
							function searchGroup(l){
								var res = l.filter(function (group) {
									return group.i18n.toLowerCase().indexOf(q) > -1
								})
								resolve(res);
							}
							if(allProfTypes !== undefined){
								resolve(allProfTypes);
							}else{
								DashAPI.get("/dashboard/encs/ws/enumlistobj?className=ca.infodata.ofys.data.middle.dataobjects.professionnal.XProfessionnalType", function(res){
									allProfTypes = _.values(res.data);
									searchGroup(allProfTypes);
								}, reject);
							}
						});
					}

					scope.profGroupSelector = {
						name: "groupSelector",
						list:professionalGroupes,
						updatedList: function (group) {
							scope.updateFilters('custom');
						},
						selectorName:function (group) {
							return group.i18n;
						},
						inputPlaceHolder: $filter("translate")("FILTER_BY_GROUP"),
					};

					function updateProfCache(res){
						var profs = res.data;
						profs.forEach(function(el){
							if(!model.store.profs.index[el.id]){
								model.store.profs.addToCache(el.id, el);
							}
						});
					}

					scope.profSelector = {
						name: "profSelector",
						checkEquals: function (a, b) {
							return a.id == b.id;
						},
						list: function (query) {
							return ProfAccessor.search(ProfAccessor.getSearchCriteria(query), updateProfCache);
						},
						selectorName: function (prof) {
							return prof.firstName + ', ' + prof.lastName + ' ('+ prof.code + ')';
						},
						updatedList: function (profLst) {
							scope.updateFilters('custom');
						},
						inputPlaceHolder: $filter("translate")("FILTER_BY_PROF"),
					};

					var allencs = [];
					var aggregatedEnc = {
						lstNote: [],
						lstPrescription: []
					};

					function all(enc) {

						//Aggregate all notes for all encounters.
						for(var i = 0; i < allencs.length; i++){
							if(allencs[i].lstNote){
								enc.lstNote = enc.lstNote.concat(allencs[i].lstNote);
							}
							if(allencs[i].lstPrescription){
								enc.lstPrescription = enc.lstPrescription.concat(allencs[i].lstPrescription);
							}
						}
						return enc;
					}

					function resetAggregate() {
						$.extend(scope.editEnc, angular.copy(aggregatedEnc));
						EncounterAccessor.initEntry('lstNote', scope.encbrowser.entryDef, notesBrowserFactory, scope.editEnc);
						EncounterAccessor.initEntry('lstPrescription', scope.encbrowser.entryDef, notesBrowserFactory, scope.editEnc);
					}

					scope.updateFilters = function (preset) {
						scope.encbrowser.preset = preset;
						resetAggregate()
						browserPresets[preset](scope.editEnc)
					};

					function update(n, o) {
						allencs = scope.patient.viewbag.patData.enc
						$.extend(aggregatedEnc, all(aggregatedEnc));
						scope.updateFilters(scope.encbrowser.preset)
					}
					scope.$watch(scope.patient, update);
				}
			}
		}
	]);


	encounter.directive('medCalc', ['$filter','$q', 'model','EncounterAccessor',
		function($filter, $q, model, EncounterAccessor){
			return {
				restrict: 'A',
				link: function(scope, element, attrs){
					scope.medcalcOptions = {
						ageGroup: [{title: 'ENFANT'}, {title: 'ADULTE'}],
						caclParams: [{v: 'weight',title: 'POIDS'},{v: 'poidsmaigre', title:"POIDS_MAIGRE"}, {v: 'surface', title: "SURFACE"}],
						renalFunction: [{title: 'INCONNUE'},{title: 'NORMAL'}, {title: 'ABAISSE'}, {title: 'IR_LEGERE'}, {title: 'IR_MOD'}, {title: 'IR_SEVERE'}],
						totalDose: [{title: 'QUOTIDIENNE'},{title: 'PAR_DOSE'}],
						freq: [{title: 'ID'},{title: 'BID'}, {title: 'TID'}, {title: 'QID'}, {title: 'JR_5'}, {title: 'JR_6'}],
					};
					scope.poslst= [];
					scope.mapDose;
					var freqArray = ['ID', 'BID', 'TID', 'QID', 'JR_5', 'JR_6']
					var age = scope.def.patient && scope.def.patient.age ? scope.def.patient.age : 0 ;

					function getRenalFunction(){
						if(scope.def && scope.def.patient){
							var cr = 0;
							if(scope.def.patient.viewbag.creatinine_cl){
								cr = scope.def.patient.viewbag.creatinine_cl;
							}
							if(cr === 0){
								return 'INCONNUE';
							}else if(cr < 11){
								return 'IR_SEVERE';
							}else if(cr < 21){
								return 'IR_MOD';
							}else if(cr < 51){
								return 'IR_LEGERE';
							}else if(cr < 76){
								return 'ABAISSE';
							}else{
								return 'NORMAL';
							}
						}
					}

					scope.medcalc = {
						ageGroup:  age > 12 ? 'ADULTE':'ENFANT',
						caclParams: 'weight',
						renalFunction: getRenalFunction(),
						totalDose: 'QUOTIDIENNE',
						freq: 'ID',
						height: 0,
						weight: 0,
						poidsmaigre: 0,
						surface: 0,
					};
					initCalculatorData();
					scope.setLblUniteSelection = function() {
						scope.unit = ""; //$NON-NLS-1$
						if (scope.medcalc.caclParams === 'surface') {
							scope.unit = "/m2";
						} else {
							scope.unit = "/kg";
						}
						if (scope.medcalc.totalDose === 'QUOTIDIENNE') {
							scope.base = $filter("translate")('dosCalc_base_PAR_JR'); //$NON-NLS-1$ //$NON-NLS-2$
						} else if (scope.medcalc.totalDose === 'PAR_DOSE') {
							scope.base = $filter("translate")('dosCalc_base_PAR_DOSE'); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}

					scope.calculatePosology = function(){
						
						var mc = scope.medcalc;
						var doseTotale = (mc.posology?mc.posology: 0) * (mc[mc.caclParams]*1);
						if(mc.maxDose && (mc.maxDose*1) < doseTotale){
							doseTotale = (mc.maxDose*1);
						}
						if(scope.medcalc.totalDose == 'QUOTIDIENNE'){
							doseTotale = doseTotale / (freqArray.indexOf(mc.freq) + 1 );
						}
						var dt = Round(doseTotale, 1);

						scope.medcalc.px =  getDose(dt) + " "
						scope.medcalc.px +=  getUnit(mc.unit) ;
						scope.medcalc.resultPosology = scope.medcalc.px + " " + mc.freq;
					};

					function getUnit(u){
						if(scope.mapDose){
							return "ML"
						}else if(u){
							return u;
						}else{
							return "";
						}
					}

					function getDose(doseTotale){
						if(scope.mapDose){
							var sn = scope.item.viewbag.item.strength
							var newForce = ""; //$NON-NLS-1$
							var indexOfEnChiffre = 0;
							var i;
							var d;
							for (i =0 ; i < sn.length; i++) {
								d = sn[i];
								if (!isNaN(d) || d === '.' || d === ',') {
									if (d == ',') {
										d = '.';
									}
									newForce += d;
									indexOfEnChiffre++;
								} else {
									break;
								}
							}
							var nbml = 1;
							var afterSlash = sn.substring(indexOfEnChiffre);
							for (i = 0; i < afterSlash.length; i++) {
								d = afterSlash[i];
								if (d=='/') {
									if ((i+1<afterSlash.length) && !isNaN(afterSlash[i+1])) {
										var l = 1
										if ((i+2<afterSlash.length) && !isNaN(afterSlash[i+2])) {
											l = 2
										}
										var nbmlstr = afterSlash.substring(i+1, i+1+l);
										nbml = parseInt(nbmlstr);
									}
									
									break;
								}
							}
							var force = OfysUtils.parseFloat(newForce);
							var force_ml = force/nbml;
							var dDoseMl = Round(doseTotale/force_ml, 1) ;
							return dDoseMl;
						}else{
							return doseTotale;
						}
					}

					scope.$watch('encCalculatePosologyForm.$dirty', function(){
						if(scope.encCalculatePosologyForm && scope.encCalculatePosologyForm.$dirty){
							updateForm();
							scope.encCalculatePosologyForm.$setPristine();
						}
					}, false);

					function updateForm(){
						scope.setLblUniteSelection();
						scope.calculatePosology();
					}

					function allowPositivesOnly(n){
						return n >= 0? n: "";
					}

					//	The James Formula:
					//		Men: eLBM = 1.1weight(kg) - 128(weight(kg)/height(cm))2
					//		Women: eLBM = 1.07weight(kg) - 148(weight(kg)/height(cm))2
					// 0 = male, 1 = female
					function poidsMaigre(sex,  age, wt, ht) {
						if (age < 14) {
							//			The Peters Formula:
							//				The author suggested that this formula fit for children of 13-14 years old or younger.
							//				eECV = 0.0215weight(kg)0.6469height(cm)0.7236
							//				eLBM = 3.8eECV
							var value = 3.8 * (0.0215 * Math.pow(wt, 0.6469) * Math.pow(ht, 0.7236));
							if (value == NaN) return wt;
							return Round(value, 1);
						} else {
							var s = sex == 0 ? [1.1, 128 ] : [1.07, 148 ];
							var value = s[0] * wt - s[1] * Math.pow(wt / ht, 2);
							return Round(value, 1);
						}
					}

					function BodySurfArea(wt, ht) {
						var value = .007184 * Math.pow(ht, .725) * Math.pow(wt, 0.425);
						return Round(value, 1);
					}

					function Round(value, digits) {
						var d = null;
						if (value == null) {
							return null;
						}
						if (digits == 0) {
							d = (Math.round(value * 1) / 1);
						}
						if (digits == 1) {
							d = ( Math.round(value * 10) / 10);
						}
						if (digits == 2) {
							d = (Math.round(value * 100) / 100);
						}
						if (digits == 3) {
							d = (Math.round(value * 1000) / 1000);
						}
						return d;
					}

					scope.submitCalculation = function(item){
						item.viewbag.item.frequency = scope.medcalc.freq;
						item.viewbag.item.posology = scope.medcalc.px;
					}

					if(scope.def.patient){
						var ms = scope.def.patient.viewbag.patData.sum.lastMesure;
						var newMs = scope.def.patient.viewbag.patData.sum.newLastMesure;
						if (newMs) {
							var lastTimeVitalSign = ms && ms.timeVitalSign ? ms.timeVitalSign : 0;
							if (newMs.timeVitalSign > lastTimeVitalSign) {
								ms = newMs;
							}
						}
						if(ms){
							scope.medcalc.height = ms.height ? ms.height.toFixed(0) : ms.height;
							scope.medcalc.weight = ms.weight ? ms.weight.toFixed(1) : ms.weight;
							scope.medcalc.unit = "MG";
							var pdsMaigre = allowPositivesOnly(poidsMaigre(scope.def.patient.gender === 'M'?0:1, scope.def.patient.age, ms.weight, ms.height));
							scope.medcalc.poidsmaigre = pdsMaigre ? pdsMaigre.toFixed(1) : pdsMaigre;
							var surf = BodySurfArea(ms.weight, ms.height);
							scope.medcalc.surface = surf ? surf.toFixed(2) : surf;
							updateForm();
						}
					}
					scope.setPos = function (pos){
						if(pos){
							scope.medcalc.posology = pos;
							scope.medcalc.posologyassist = pos;
						}
					}
					
					function initCalculatorData(){
						var p = scope.item.viewbag.item;
						if(p.name){
							var data = {
								drugName: p.baseDrugName +'~'+ p.name,
								strength: p.strength
							};
							EncounterAccessor.doseCalculatorData(data, onReceivedCalculatorData);
						}

						function onReceivedCalculatorData(res){
							if(res && res.data && res.data.length > 0){
								var d = res.data[0];
								
								addPos(d.mgkg_pref);
								addPos(d.mgkg_autre);
								scope.setPos(d.mgkg_pref);
								if(d.frequence !== undefined){
									setFrequence(d.frequence);
									setMaxDose(d.frequence * d.dose_unique_max);
								}
								scope.mapDose = d;
								scope.calculatePosology();
							}
						}

						function setMaxDose(max){
							scope.medcalc.maxDose = max;
						}
						function setFrequence(no){
							scope.medcalc.freq = freqArray[no-1];
						}
						function addPos(pos){
							if(pos){
								scope.poslst.push({v: pos+'MG/KG/JR',k: pos});
							}
						}
					}

				}
			}
	}]);

	encounter.directive('prescriptionFavs', ['$filter','$q', 'model','EncounterAccessor', 'Notification', 'DashWebSocket',
		function($filter, $q, model, EncounterAccessor, Notification, DashWebSocket){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				options: '=?'
			},
			templateUrl:'/dashboard/resources/ofys/encounter/entry/prescription_favs.html?v=ba',
			link: function(scope, element, attrs){
				var defaultOptions = {
						setTab: function (t){
							if (scope.options.patient && scope.options.patient.viewbag && scope.options.patient.viewbag.dsqActive!==true) {
//							if (this.dsqIdentified!==true) {
								// il ne faut pas garder la pref dsq dans ce cas
								if (t==='dsq') {
									t = 'fav';
								}
							}
//							if(t === 'dsq'){
//								if (scope.activePatientIdForLstDsq !== scope.options.patient.id && scope.lstDsq) {
//									delete scope.lstDsq;
//								}
//								if (scope.lstDsq===undefined) {
//									DashWebSocket.sendRequest("/dashboard/dsq/ws/enc/favs", {patientId: scope.options.patient.id});
//								}
//							}
							this.tab = t;
							if (t!=model.prefSettings('fav_tab_active')) {
								model.prefSettings('fav_tab_active', t);								
							}
						},
						dsqIdentified: false,
						add: function(presc){
							var c = EncounterAccessor.allFavRx.filterFastFirst(function(e) { 
								return e.hash == presc.hash;
							});
							if (c.length>0) {	// on veut retirer le favori
								EncounterAccessor.delFavIdRx(c[0].id, function(){
									EncounterAccessor.allFavRx.splice(EncounterAccessor.allFavRx.indexOf(c[0]),1);
								});
							} else {
								var rx = angular.copy(_.omit(presc, 'viewbag'));
								var idProf = model.user().profil.id;
								EncounterAccessor.addFavRx(rx, idProf, function(item){
									if (item && item.hash && item.name) {	// si pas de hash, signifie qu'a eu erreur
										EncounterAccessor.allFavRx.insertInOrder(item, 'name');
										presc.hash = item.hash;	// pour que l'étoile indique que bien ajouté.
									}
								})
							}
						}};
				scope.options = $.extend(defaultOptions, scope.options || {});
				if (EncounterAccessor.allFavRx == undefined) {
					EncounterAccessor.allFavRx = [];
				}
				if (scope.options.isDevice) {
					scope.lstFavs = EncounterAccessor.allFavRx.filter(function(k){return k.baseDrugType===3});
				} else {
					scope.lstFavs = EncounterAccessor.allFavRx.filter(function(k){return k.baseDrugType!==3});					
				}
				scope.options.setTab(model.prefSettings('fav_tab_active'));
				// console.log(scope.lstFavs);
				if(scope.options.patient && scope.options.patient.niu){
					scope.options.dsqIdentified = true;
				}
				function dsqToOfysPrescription(dsqRx){
					var ofysRx = {};
					return ofysRx;
				}

//				var dsqEncFavsResponseHandlerId = Notification.registerHandler('dsqEncFavsResponse', function(msg){
//					if(msg.data.status.severity === "OK"){
//						//Patients dsq
//						scope.lstDsq = msg.data.obj;
//						scope.activePatientIdForLstDsq = scope.options.patient.id;
//					}
//				}, scope);

				scope.removeFav = function(fav){
					EncounterAccessor.delFavIdRx(fav.id, function(){
						EncounterAccessor.allFavRx.splice(EncounterAccessor.allFavRx.indexOf(fav),1);
						scope.lstFavs.splice(scope.lstFavs.indexOf(fav),1);//_without copy le array, perdant le lien avec allFavRx
					});
				};
				scope.openUrl = function(v) {
					if(model.isWeb()){
						var win = window.open(v, '_blank');
						win.focus();
					}else{
						DashWebSocket.send({url: "/dashboard", data:{url:v}});
					}					
				}
			}
		}
	}]);

	encounter.directive('encEntry', ['model', '$filter', 'EncounterAccessor',
	                               function(model, $filter, EncounterAccessor){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/encounter/enc_entry.html?v=ba',
			scope: true,
			link: function(scope, element, attrs){
				function update(){
					scope.def = scope.$eval(attrs.def);
					EncounterAccessor.noteTypes(1, function(resp) {
						scope.def.noteTypes = resp;
					});
					if(scope.def.$scope){
						$.extend(scope,scope.def.$scope)
					}
				};
				
				scope.$watch(attrs.def, update);
			}
		}
	}]);

	function patientSubFormController($scope, $timeout, PatientFormService) {
		$scope.messages = $scope.messages ? $scope.messages : {};
		if($scope.item && $scope.item.viewbag){
			$scope.item.viewbag.messages = $scope.messages;
		}
		$scope.messages.list = $scope.messages.list ? $scope.messages.list :[];
		
		$scope.messages.add = function(msgObj){
			if(Array.isArray(msgObj)){
				$scope.messages.list = msgObj;
			}else if(typeof msgObj ==='object'){
				$scope.messages.list.push(msgObj);
			}
		};
		
		$scope.messages.clear = function(){
			$scope.messages.list =[];
		};
		$scope.messages.clearAndAdd = function(msgObj){
			$scope.messages.clear();
			$scope.messages.add(msgObj);
		};
		if($scope.item && $scope.item.viewbag){
			$scope.item.viewbag.okToClose = function(){
				if($scope.encFormOptions){
					return $scope.encFormOptions.okToClose($scope);// for encounter
				}else{
					return PatientFormService.okToClose($scope);// for Patient summary edit
				}
			};

			// Time out to make sure the form is initialized.
			// and visible on screen. called only once
			$timeout(function(){
				if($scope.encFormOptions && $scope.encFormOptions.onFormLoad){
					$scope.encFormOptions.onFormLoad($scope, $scope.item)
				}
			}, 50);
		}
		if($scope.qconfirm){
			$scope.qconfirm.okToClose = function(){
				return PatientFormService.okToClose($scope);
			};
		}
		if($scope.def && $scope.def.$scope){
			$.extend($scope, $scope.def.$scope);
		}
	}
	
	encounter.controller('GenericEncFrmController',['$scope', '$timeout','PatientFormService', patientSubFormController]);
	
	encounter.factory('EncounterTemplates', 
		['EncounterAccessor','MessageLink','model','$filter','$q','DashWebSocket',
			function(EncounterAccessor, MessageLink, model,$filter, $q,DashWebSocket ) {
				var accessor = {
					templatesBase: [
						{namei18n: "encTemplate_empty", type: "empty", hidden: model.prefSettings('et_empty'), unhiddable: true},
						{namei18n: "encTemplate_Stylet", type: "Stylet", hidden: model.prefSettings('et_Stylet')},
						{namei18n: "encTemplate_SRV", type: "SRV", hidden: model.prefSettings('et_SRV')},
						{namei18n: "encTemplate_ordonnances", type: "ordonnances", hidden: model.prefSettings('et_ordonnances')},
						{namei18n: "encTemplate_renewOrdonnances", type: "renewOrdonnances", hidden: model.prefSettings('et_renewOrdonnances')},
						{namei18n: "encTemplate_telephone", type: "telephone", hidden: model.prefSettings('et_telephone')},
						{namei18n: "encTemplate_suiviGrossesse", type: "suiviGrossesse", hidden: model.prefSettings('et_suiviGrossesse')},
						{namei18n: "encTemplate_cnesst", type: "cnesst", hidden: model.prefSettings('et_cnesst')},
						{namei18n: "encTemplate_suiviAnnuel", type: "suiviAnnuel", hidden: model.prefSettings('et_suiviAnnuel')},
						{namei18n: "encTemplate_visitePerPed", type: "visitePerPed", hidden: model.prefSettings('et_visitePerPed')},
						{namei18n: "encTemplate_suiviClinique", type: "suiviClinique", hidden: model.prefSettings('et_suiviClinique')},
						{namei18n: "encTemplate_suiviDiabete", type: "suiviDiabete", hidden: model.prefSettings('et_suiviDiabete')},
						{namei18n: "encTemplate_suiviDiabeteCap", type: "suiviDiabeteCap", hidden: model.prefSettings('et_suiviDiabeteCap')},
						{namei18n: "encTemplate_glycCap", type: "glycCap", hidden: model.prefSettings('et_glycCap')},
						{namei18n: "encTemplate_suiviINR", type: "suiviINR", hidden: model.prefSettings('et_suiviINR')},
						{namei18n: "encTemplate_immunization", type: "immunization", hidden: model.prefSettings('et_immunization')},
						{namei18n: "encTemplate_raisonNoteConcl", type: "raisonNoteConcl", hidden: model.prefSettings('et_raisonNoteConcl')},
						{namei18n: "encTemplate_all", type: "all", hidden: model.prefSettings('et_all')},
					],
					base : function(){
						return accessor.templatesBase
					}

				}
				return accessor;
			}
		]
	);
	
	encounter.directive('addEncounter', ['model', '$filter', '$timeout','patientShowTitles','EncounterAccessor','EncounterTemplates', 'AppointmentAccessor', 'EncounterSummaryCommon',
	                               function(model, $filter, $timeout, patientShowTitles, EncounterAccessor, EncounterTemplates, AppointmentAccessor, EncounterSummaryCommon){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){
				scope.showAll = false;

				function todaysEncs(setter){
					if(arguments.length == 0 ){
						if(scope.patient.viewbag && scope.patient.viewbag.patData){
							return scope.patient.viewbag.patData.todaysEncs;
						}
					}else{
						scope.patient.viewbag.patData.todaysEncs = setter;
					}
				}
				function resetDialog(){
					todaysEncs(undefined);
					delete scope.mustCreateNew;
				}
				scope.encTemplates = EncounterTemplates.base();

				scope.toggleHiddenTemplate = function(m){
					m.hidden = !m.hidden;
					model.prefSettings('et_' + m.type, m.hidden);
				};
				scope.toggleShowAll = function(m){
					scope.showAll = !scope.showAll;
				};

				scope.openUnsavedEncounter = function(type){
					var i = EncounterAccessor.inEditIndex(scope.patient)
					if(i > -1){
						var act = scope.patient.viewbag.patData.enc[i];
						patientShowTitles.open(act, scope);
					}
					resetDialog();
				};
				
				function hasEncounterToday(){
					try{
						if(todaysEncs() === undefined){
							todaysEncs(scope.patient.viewbag.patData.enc.filter(function(e){
								return moment().isSame(moment(e.lstProf[0].entryDate),'day') && e.encounterType>9 && e.idProfAnchor===model.user().profil.id;
							}));
							todaysEncs($filter('orderBy')(todaysEncs(), 'date', true));//Order by date from most recent .								
						}
						return todaysEncs() && todaysEncs().length > 0;
					}catch(e){
						console.error(e);
					}
					return false;
				}

				scope.openTodayEncounter = function(){
					if(todaysEncs() && todaysEncs()[0]){
						patientShowTitles.open(todaysEncs()[0], scope);
					}
				};

				scope.mustCreateNewEnc = function (){
					scope.mustCreateNew = true;
				};

				scope.initDialog = function(){
					if(scope.patient.viewbag){
						resetDialog();
					}
				};

				scope.encounterPage = function(){
					if(hasEncounterToday() && !scope.mustCreateNew){
						return 3; //Encounter created today, open for revision or create new.
					}else if(EncounterAccessor.hasEncounterInEdit(scope.patient)){
						return 2; //'alreadyInEdit';
					}else{
						return 1;//'model'
					}
				};

				scope.addNewEncounter = OfysUtils.singleClick(function(type){
					var tbrObjTemp = {deleted:true};
					if (model.prefSettings('user_settings_SetSeenAuto')===true && model.activeController()=='rv') {
						var today = moment().format('YYYY-MM-DD');
						var modelApt = model.appointment();
						var currApptDate = modelApt.currDate;
						var appt = modelApt.currAppointment;
						if (appt && today==currApptDate && appt.seenTime===undefined) {
							$timeout(function(){
								var data = {apptId: appt.id, statusId:2};	// 2 = vu. voir XPatientStatus
								AppointmentAccessor.setPatientStatus(data, 
										function() {
									var newCol = model.patientStatusColors('SEEN');
									appt.ptStatColor[0] = newCol[0];
									appt.ptStatColor[1] = newCol[1];
									appt.ptStatColor[2] = newCol[2];
								},
								function() {
									console.log("Erreur setPatientStatus ...");	
								});
							}, 10);
						}
					}
					if (model.user().isStagiaire()===true && model.prefSettings('superviseurId') && model.prefSettings('superviseurId')>-1) {
						tbrObjTemp.supervisor = model.prefSettings('superviseurId');
						tbrObjTemp.deleted = false;
						tbrObjTemp.modificationStatus = 'STATUS_NEW';
					}
					var defaultEncounter = {
						"className": "CEncounter",
						tbrObj: tbrObjTemp,
						tbcObj: {deleted:true},	// pour dire que pas actif
						editMode: true,
						idProfAnchor: model.user().profil.id,
						lstProf: [{
							idProfessionnalAnchor: model.user().profil.id,
							profNom: model.user().profil.str, 
							title: "Professionnels impliqués",
							descr:[],
							descrTitle : ["Date", "Professionnal"],
							entryDate: moment().format("x"),	// pour en ms, il faut x min.
							entryDateS: moment().format("YYYY-MM-DD HH:mm")
						}],
						//idSite: function() {return model.user().session.workSite.id;},
						idSite: model.user().session.workSite.id,
						idPatientAnchor: scope.patient.id,
						encounterType:11, // VIS_SAI(11)
						encounterTypeS: EncounterAccessor.allEncTypes[11],
						uid: UUID.atomic(),
						viewbag: {
							isNew: true
						}
					}
					if (model.prefSettings('user_settings_AlwaysAddBilling')===true) {
						defaultEncounter.lstBilling = [{
							editMode: true,
							timeBillingS: EncounterSummaryCommon.nowDateTime(),
						}];
					}
					if (model.prefSettings('user_settings_AddSvInEnc')===true) {
						defaultEncounter.lstBloodPres = [{
							editMode: true,
							timeVitalSignS: EncounterSummaryCommon.nowDateTime(),
						}];
//						defaultEncounter.lstFreq = [{
//							timeVitalSignS: EncounterSummaryCommon.nowDateTime(),
//							editMode: true
//						}];
//						defaultEncounter.lstBodyTemp = [{
//							timeVitalSignS: EncounterSummaryCommon.nowDateTime(),
//							editMode: true
//						}];
					}
					if (model.prefSettings('user_settings_AddMesuresInEnc')===true) {
						defaultEncounter.lstMeasurement = [{
							editMode: true,
							timeVitalSignS: EncounterSummaryCommon.nowDateTime(),
							nbJrsPremature: 0,
						}];
					}
					if (model.prefSettings('user_settings_AddConclusionInEnc')===true) {
						defaultEncounter.lstNote = [{
							editMode: true,
							noteType:100,
						}];
					}
					if(scope.patient.viewbag.patData.enc.length > 0){
						scope.patient.viewbag.patData.enc.unshift(defaultEncounter);
					}else{
						scope.patient.viewbag.patData.enc.push(defaultEncounter);
					}
					patientShowTitles.openActivity(defaultEncounter, 
					{
						mode: 'n', 
						minimize: false, 
						activeType: type
					}, scope.patient);

					resetDialog();
				});

				scope.closeView = function(){
					resetDialog();
					$timeout(function() {
						angular.element('#btn-add-new-enc').triggerHandler('click')
					});
				};
			}
		}
	}]);

	encounter.directive('encList', ['$compile','utils','ModificationStatus', '$timeout', 'model', '$filter',
		function($compile, utils, ModificationStatus, $timeout, model, $filter){
		return {
			restrict: 'E',
			scope:{
				list: '=',
				viewOptions: '=',
				encFormOptions:'=',
				enc:'=',
				def: '=',
				
			},
			compile: function(ele) {
				var transcludestring = ele.html();	
				ele.html('');
				var templateString = utils.getTemplate('encEditList_index.html');
				
				return function(scope, element, attrs){
					var transclude = angular.element(angular.copy(transcludestring));
					var template = angular.element(angular.copy(templateString));
					$(template).find('.listEncItem').append(angular.copy(transclude));
					$compile(template)(scope);
					element.append(template);
					
					
					function update(){

					}
					scope.deleteItem = function(item){
						if(item.isReadOnly ===true){
							model.notice().warn($filter('translate')('NoRight'));
							return;
						}
						if(item.id && !item.isReprescribedFromSummary && !item.mustHardDelete){
							if (!(item.deleted===true || item.isDelete===true)) {
							item.isDelete = true;
							item.deleted = true;
							item.modificationStatus = 'STATUS_DELETED';
							}
						}else{
							var i = scope.list.indexOf(item);
							if(i > -1){
								scope.list.splice(i, 1);
							}
						}

						if(item.weightS2){
							var pat = scope.def ? scope.def.patient : undefined;
							if (pat && pat.viewbag && pat.viewbag.patData.sum.newLastMesure) {
								if (item.timeVitalSign==pat.viewbag.patData.sum.newLastMesure.timeVitalSign) {
									delete pat.viewbag.patData.sum.newLastMesure;
								}
							}
						}
					}
					scope.$watch(scope.options, update);

				};
			},
		};
	}]);

	encounter.directive('encEntryEditItem', ['model', '$filter', 
	                               function(model, $filter){
		return {
			restrict: 'E',
			templateUrl: 'enc_entry_edit_item_index.html',
			scope: true,
			link: function(scope, element, attrs){

				function update(){
					scope.item = scope.$eval(attrs.item);
					if(scope.focus){
						scope.focus();
					}
				};
				update()
			}
		}
	}]);

	encounter.constant('encEnumList', {
		dxStatus: [
			'NA',
			'UNLIKELY',
			'POSSIBLE',
			'PROBABLE',
			'TEMPORARY',
			'CONFIRMED',
			'ELIMINE'
		],
		lstLifeHabitFrequency: [
			'SO',
			'RARE',
			'OCCASIONNEL',
			'REGULIEREMENT',
			'SOUVENT',
			'TRES_SOUVENT'
		],
		typeHabit: [
			'TOBACCO',
			'ALCOHOL',
			'DRUGS',
			'PHYSICAL_ACTIVITY',
			'SEXUAL_LIFE',
			'ANOTHER',
			'CAFEE',
			'COLA',
			'ENERGIZER',
			'NB_SEXUAL_PART_A_VIE'
		],
		allergyServerity: [
			'NA',
			'LIGHT',
			'MODERATE',
			'POTENTIALLY_SERIOUS',
			'SERIOUS',
			'VERY_SERIOUS',
			'POTENTIALLY_MORTAL'
		],
		allAllergyProbability: [
			'NA',
			'POSSIBLE',
			'PROBABLE',
			'CERTAINE',
			'intPOSSIBLE',
			'intPROBABLE',
			'intCERTAINE',
			'NONEFFICACE',
		],
		bodyTempType:{
			0: 'AUCUN',
			1: 'BUCALE',
			2:'RECTALE',
			4:'TYMPANIQUE',
			8:'AXILLAIRE',
			16:'SANGUINE'
		},
		encounterType: {},
		noteType: {},
		rappelResolvedStatus: {},
		diagnosticStatus:{}
	});

	encounter.filter('encEnum', ['encEnumList', 'EncounterAccessor', function(encEnumList, EncounterAccessor) {
	    return function(val,type, extra) {
			var allEnums = encEnumList;
			if(allEnums[type]){
				var res = allEnums[type][val];
				if(type ==='dxStatus'){
					res = res + '_dxStatus';
				}else if(type === 'lstLifeHabitFrequency'){
					res = allEnums.typeHabit[extra]  + "." + res;
				}else if(type === 'bodyTempType'){
					res = 'BodyTemperature.' + val;
				}else if(type === 'allergyServerity'){
					res = res + '_severity';
				}else if(type === 'encounterType'){
					if (val==37) return '';	// voir raison.
					res = EncounterAccessor.encTypes[val]+ ' ';
				}else if(type === 'noteType'){
					res = EncounterAccessor.allNoteTypes[val];
				}else if(type === 'allRappelResolvedStatus'){
					res = EncounterAccessor.allRappelResolvedStatus[val];
				}else if(type === 'diagnosticStatus'){
					res = EncounterAccessor.allDxStatus[val];
				}
				return res;
			}
	        return val;
	    };
	}]);

	encounter.filter('shrtVersionEnc', function() {
	    return function(val,type, extra) {
			var shortName = ['lstIntervention_encEntry', 'lstBloodPres_encEntry', 'lstFreq_encEntry'];
			if(shortName.indexOf(val) > -1){
				return val + '_Shrt';
			}
	        return val;
	    };
	});

})();