/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XVulnerability;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XDisabilityCode;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionCategory;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionEndReason;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionStatus;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2b;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientRepresentativeType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.ui.dashboard.models.CBaseProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CEditableDataObjectList;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.CVulnerability;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.date.IPartialDate;
import java.util.ArrayList;

public class CPatientB2b
extends CEditableDataObject {
    public Integer id;
    public int uid;
    private Integer idPatient;
    public Integer idPatientRepresentative;
    public Integer idProfessionnalResident;
    private Integer idTreatingProfessionnal;
    public CPatient patientRepresentative;
    public Integer patientRepresentativeType;
    public CBaseProfessionnal professionnalResident;
    public Integer idSiteFollow;
    public String siteFollowStartDate;
    public Integer status;
    public Integer category;
    public String startDate;
    public String endDate;
    public Integer endReason;
    public String verificationDate;
    public ArrayList<CVulnerability> vulnerabilities;

    public CPatientB2b(XInscriptionStatus s, XDisabilityCode d0, XDisabilityCode d1, XDisabilityCode d2) {
        this.status = s.value;
        if (this.vulnerabilities == null) {
            this.vulnerabilities = new ArrayList();
        }
        if (d0 != null) {
            this.setVulnerability(d0);
        }
        if (d1 != null) {
            this.setVulnerability(d1);
        }
        if (d2 != null) {
            this.setVulnerability(d2);
        }
    }

    protected void setVulnerability(XDisabilityCode d0) {
        XVulnerability xv = new XVulnerability();
        xv.setDisCode(d0);
        this.vulnerabilities.add(new CVulnerability(xv));
    }

    public CPatientB2b(XPatientB2b patientB2b) {
        this.init(patientB2b);
    }

    public CPatientB2b(XPatient patient) {
        this.init(patient.b2bInformation);
        this.idTreatingProfessionnal = patient.getTreatingProfessionnal();
    }

    public void init(XPatientB2b patientB2b) {
        super.init((IEditableDataObject)patientB2b);
        this.uid = Utils.getNewAtomicInteger();
        this.id = patientB2b.getId();
        this.idPatient = patientB2b.getIdPatient();
        try {
            XPatient xp;
            if (patientB2b.getPatientRepresentative() instanceof XPatient && !(xp = (XPatient)patientB2b.getPatientRepresentative()).getId().equals(patientB2b.getIdPatient())) {
                this.patientRepresentative = new CPatient(xp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.idPatientRepresentative = patientB2b.getIdPatientRepresentative();
        this.patientRepresentativeType = patientB2b.getPatientRepresentativeType() == null ? null : Integer.valueOf(patientB2b.getPatientRepresentativeType().value);
        this.idProfessionnalResident = patientB2b.getIdProfessionnalResident();
        this.professionnalResident = patientB2b.getProfessionnalResident() == null ? null : new CBaseProfessionnal(patientB2b.getProfessionnalResident());
        this.idSiteFollow = patientB2b.getIdSiteFollow();
        this.siteFollowStartDate = Utils.IPToNullableHyStr((IPartialDate)patientB2b.getSiteFollowStartDate());
        this.status = patientB2b.getStatus() == null ? null : Integer.valueOf(patientB2b.getStatus().value);
        this.category = patientB2b.getCategory() == null ? null : Integer.valueOf(patientB2b.getCategory().value);
        this.startDate = Utils.IPToNullableHyStr((IPartialDate)patientB2b.getStartDate());
        this.endDate = Utils.IPToNullableHyStr((IPartialDate)patientB2b.getEndDate());
        this.endReason = patientB2b.getEndReason() == null ? null : Integer.valueOf(patientB2b.getEndReason().getValue());
        this.verificationDate = Utils.IPToNullableHyStr((IPartialDate)patientB2b.getVerificationDate());
        if (patientB2b.getVulnerabilities() != null) {
            this.vulnerabilities = new ArrayList();
            for (int i = 0; i < patientB2b.getVulnerabilities().size(); ++i) {
                this.vulnerabilities.add(new CVulnerability((XVulnerability)patientB2b.getVulnerabilities().get(i)));
            }
        }
    }

    public static CPatientB2b c(XPatientB2b x) {
        return x == null ? null : new CPatientB2b(x);
    }

    public XPatientB2b x() {
        XPatientB2b res = new XPatientB2b();
        super.x((EditableDataObject)res);
        res.id = MiscUtil.fromInt((Integer)this.id);
        res.idPatient = this.idPatient;
        if (null != this.patientRepresentative) {
            res.setPatientRepresentative(this.patientRepresentative.x());
        }
        if (null != this.patientRepresentativeType) {
            res.patientRepresentativeType = XPatientRepresentativeType.from((Integer)this.patientRepresentativeType);
        }
        if (null != this.professionnalResident) {
            res.setProfessionnalResident(CBaseProfessionnal.toX(this.professionnalResident));
        }
        res.idSiteFollow = this.idSiteFollow;
        res.siteFollowStartDate = Utils.strToLocalDate(this.siteFollowStartDate);
        if (null != this.status) {
            res.status = XInscriptionStatus.from((Integer)this.status);
        }
        if (null != this.category) {
            res.category = XInscriptionCategory.from((Integer)this.category);
        }
        res.startDate = Utils.strToLocalDate(this.startDate);
        res.endDate = Utils.strToLocalDate(this.endDate);
        if (null != this.endReason) {
            res.endReason = XInscriptionEndReason.from((Integer)this.endReason);
        }
        res.verificationDate = Utils.strToLocalDate(this.verificationDate);
        res.vulnerabilities = CEditableDataObjectList.x(this.vulnerabilities);
        return res;
    }

    public <T> void convertc(T obj) {
        XPatientB2b x = (XPatientB2b)XPatientB2b.class.cast(obj);
        this.init(x);
    }

    public XPatientB2b convertx() {
        return this.x();
    }
}

