/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.patient.Age;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientInactiveRaison;
import ca.infodata.ofys.data.middle.dataobjects.professionnal.XProfessionnalType;
import ca.infodata.ofys.ui.dashboard.models.CConsentement;
import ca.infodata.ofys.ui.dashboard.models.CEditableDataObjectList;
import ca.infodata.ofys.ui.dashboard.models.CPatientB2b;
import ca.infodata.ofys.ui.dashboard.models.CPatientIdentifier;
import ca.infodata.ofys.ui.dashboard.models.CPatientProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CPatientValue;
import ca.infodata.ofys.ui.dashboard.models.CPerson;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class CPatient
extends CPerson {
    private static final long serialVersionUID = 1L;
    public ArrayList<CConsentement> lstConsentement;
    public ArrayList<CPatientIdentifier> lstPatientIdentifier;
    public ArrayList<CPatientProfessionnal> lstPatientProfessionnal;
    public Integer id;
    public int uid;
    public Integer idPatient;
    public String niu;
    public List<Integer> allIds;
    public String healthInsuranceNumber;
    public String patientRecordNumber;
    public Short bloodType;
    public String messageAppointment;
    public String lastVerificationDate;
    public String lastActivityDate;
    public String expirationCAM;
    public String spouseName;
    public String fatherName;
    public String motherName;
    public String fatherHin;
    public String motherHin;
    public String tutorName;
    public Integer lastProfileVersion;
    public Integer treatingProfessionnal;
    public String txProfName;
    public String txProfCode;
    public Boolean isSensible;
    public Boolean isScanned;
    public String custodyTerms;
    public ArrayList<CPatientValue> lstPatientAlerts;
    public Integer motherId;
    public Integer fatherId;
    public Integer tutorId;
    public CPatient mother;
    public CPatient father;
    public CPatient tutor;
    public String inactiveDate;
    public Integer inactiveRaison;
    public Boolean mustDeleteFutureAppointmentAndRecallOnDelete = false;
    public CPatientB2b b2bInformation;
    public Boolean sofyAuthorized;
    public Integer idSofyLink;
    public boolean motherSofyAccess;
    public boolean motherSofyAccessLocked;
    public boolean motherSofyAccessGranted;
    public boolean fatherSofyAccess;
    public boolean fatherSofyAccessLocked;
    public boolean fatherSofyAccessGranted;
    public boolean tutorSofyAccess;
    public boolean tutorSofyAccessLocked;
    public boolean tutorSofyAccessGranted;
    public boolean permanentSofyAccess;

    public CPatient() {
    }

    public CPatient(XPatient pat) {
        super((XPerson)pat);
        this.init(pat);
    }

    public void init(XPatient pat) {
        super.init((XPerson)pat);
        this.uid = Utils.getNewAtomicInteger();
        this.className = CPatient.class.getSimpleName();
        this.lstConsentement = new CEditableDataObjectList<CConsentement>(pat.lstConsentement, CConsentement.class);
        this.lstPatientIdentifier = new CEditableDataObjectList<CPatientIdentifier>(pat.lstPatientIdentifier, CPatientIdentifier.class);
        this.lstPatientProfessionnal = new CEditableDataObjectList<CPatientProfessionnal>(pat.lstPatientProfessionnal, CPatientProfessionnal.class);
        this.lstPatientAlerts = new CEditableDataObjectList<CPatientValue>(pat.lstPatientAlerts, CPatientValue.class);
        this.id = pat.getId();
        this.idPatient = pat.getId();
        this.niu = pat.niu;
        this.allIds = pat.getAllIds();
        this.healthInsuranceNumber = pat.healthInsuranceNumber;
        this.patientRecordNumber = pat.patientRecordNumber;
        this.bloodType = pat.getBloodType();
        this.messageAppointment = pat.messageAppointment;
        this.lastVerificationDate = Utils.IPToNullableHyStr((IPartialDate)pat.lastVerificationDate);
        this.lastActivityDate = Utils.IPToNullableHyStr((IPartialDate)pat.lastActivityDate);
        this.expirationCAM = pat.expirationCAM;
        this.fatherName = pat.fatherName;
        this.spouseName = pat.spouseName;
        this.motherName = pat.motherName;
        this.tutorName = pat.tutorName;
        this.fatherHin = pat.fatherHin;
        this.motherHin = pat.motherHin;
        this.lastProfileVersion = pat.getLastProfileVersion();
        this.treatingProfessionnal = pat.getTreatingProfessionnal();
        if (this.treatingProfessionnal != null) {
            try {
                XBaseProfessionnal professionnal = Application.get().getPersonPluginController().getBaseProfessionnal(this.treatingProfessionnal);
                this.txProfName = professionnal == null ? null : professionnal.lastName + " " + professionnal.firstName + (XProfessionnalType.MD_OMNIPRATICIEN.equals((Object)professionnal.getProfessionalType()) || XProfessionnalType.MD_SPECIALISTE.equals((Object)professionnal.getProfessionalType()) ? " MD" : "");
                this.txProfCode = professionnal == null ? null : professionnal.getCode();
            }
            catch (Exception e) {
                try {
                    XProfessionnal professionnal = Application.get().getPersonPluginController().getProfessionnal(this.treatingProfessionnal);
                    this.txProfName = professionnal == null ? null : professionnal.lastName + " " + professionnal.firstName + (XProfessionnalType.MD_OMNIPRATICIEN.equals((Object)professionnal.getProfessionnalType()) || XProfessionnalType.MD_SPECIALISTE.equals((Object)professionnal.getProfessionnalType()) ? " MD" : "");
                    this.txProfCode = professionnal == null ? null : professionnal.getCode();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        this.isSensible = pat.isSensible;
        this.isScanned = pat.isScanned;
        this.custodyTerms = pat.custodyTerms;
        this.mother = null == pat.mother ? null : new CPatient(pat.mother);
        this.father = null == pat.father ? null : new CPatient(pat.father);
        this.tutor = null == pat.tutor ? null : new CPatient(pat.tutor);
        this.motherId = pat.getMotherId();
        this.fatherId = pat.getFatherId();
        this.tutorId = pat.getTutorId();
        this.inactiveDate = Utils.IPToNullableHyStr(pat.getInactiveDate());
        if (pat.getInactiveRaison() != null) {
            this.inactiveRaison = pat.getInactiveRaison().value;
            if (XPatientInactiveRaison.DCD.equals((Object)pat.getInactiveRaison()) && pat.getInactiveDate() != null && pat.getBirthDate() != null) {
                LocalDate ldDeces = LocalDate.from((IPartialDate)pat.getInactiveDate());
                this.age = CPatient.getAgeAtASpecificDate(pat.getBirthDate(), ldDeces);
                this.age = pat.getAge();
                this.oAge = new Age(pat.getBirthDate(), ldDeces);
                this.ageStr = this.oAge.toStringNice() + " (DCD)";
            }
        }
        this.mustDeleteFutureAppointmentAndRecallOnDelete = pat.mustDeleteFutureAppointmentAndReccallOnDelete;
        this.sofyAuthorized = pat.sofyAuthorized;
        this.idSofyLink = pat.idSofyLink;
        this.b2bInformation = pat.getB2bInformation() == null ? null : new CPatientB2b(pat.getB2bInformation());
        this.permanentSofyAccess = (pat.getSofyGuardianAccess() & 8) != 0;
        boolean patientLessThan14OrPermanentAccess = pat.age != null && pat.age <= 14 || this.permanentSofyAccess;
        this.motherSofyAccess = (pat.getSofyGuardianAccess() & 1) != 0 && patientLessThan14OrPermanentAccess;
        this.fatherSofyAccess = (pat.getSofyGuardianAccess() & 2) != 0 && patientLessThan14OrPermanentAccess;
        this.tutorSofyAccess = (pat.getSofyGuardianAccess() & 4) != 0 && patientLessThan14OrPermanentAccess;
        this.motherSofyAccessLocked = (pat.getSofyGuardianAccess() & 0x10) != 0 && patientLessThan14OrPermanentAccess;
        this.fatherSofyAccessLocked = (pat.getSofyGuardianAccess() & 0x20) != 0 && patientLessThan14OrPermanentAccess;
        this.tutorSofyAccessLocked = (pat.getSofyGuardianAccess() & 0x40) != 0 && patientLessThan14OrPermanentAccess;
        this.motherSofyAccessGranted = (pat.getSofyGuardianAccess() & 0x80) != 0 && patientLessThan14OrPermanentAccess;
        this.fatherSofyAccessGranted = (pat.getSofyGuardianAccess() & 0x100) != 0 && patientLessThan14OrPermanentAccess;
        this.tutorSofyAccessGranted = (pat.getSofyGuardianAccess() & 0x200) != 0 && patientLessThan14OrPermanentAccess;
    }

    public static Short getAgeAtASpecificDate(LocalDate birthdate, LocalDate base) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (birthdate == null) {
            return null;
        }
        LocalDate today = base;
        short age = (short)(today.year - birthdate.year);
        if (today.before((IPartialDate)birthdate.withYear(today.year))) {
            age = (short)(age - 1);
        }
        return age;
    }

    public XPatient x() {
        String[] temp;
        XPatient res = new XPatient();
        super.x((XPerson)res);
        if (this.inactiveDate != null) {
            temp = Utils.strToLocalDate(this.inactiveDate, "yyyy-MM-dd");
            res.setInactiveDate((IPartialDate)temp);
        }
        res.setInactiveRaison(XPatientInactiveRaison.from((Integer)this.inactiveRaison));
        res.mustDeleteFutureAppointmentAndReccallOnDelete = this.mustDeleteFutureAppointmentAndRecallOnDelete;
        res.lstSites = CEditableDataObjectList.x(this.lstSites);
        res.lstPatientAlerts = CEditableDataObjectList.x(this.lstPatientAlerts);
        res.lstPatientProfessionnal = CEditableDataObjectList.x(this.lstPatientProfessionnal);
        res.lstPatientIdentifier = CEditableDataObjectList.x(this.lstPatientIdentifier);
        res.lstConsentement = CEditableDataObjectList.x(this.lstConsentement);
        res.id = MiscUtil.fromInt((Integer)this.id);
        res.niu = this.niu;
        res.allIds = this.allIds == null ? new IntAVLTreeSet() : new IntAVLTreeSet(this.allIds);
        res.healthInsuranceNumber = this.healthInsuranceNumber;
        res.patientRecordNumber = this.patientRecordNumber;
        res.bloodType = this.bloodType;
        res.messageAppointment = this.messageAppointment;
        if (!"".equals(this.lastVerificationDate) && this.lastVerificationDate != null) {
            res.lastVerificationDate = Utils.dateToLocalDate(Date.valueOf(this.lastVerificationDate));
        }
        if (!"".equals(this.lastActivityDate) && this.lastActivityDate != null) {
            res.lastActivityDate = Utils.dateToLocalDate(Date.valueOf(this.lastActivityDate));
        }
        if (this.expirationCAM != null && this.expirationCAM.length() == 5) {
            temp = this.expirationCAM.split("-");
            res.expirationCAM = temp[0] + temp[1];
        } else {
            res.expirationCAM = this.expirationCAM;
        }
        res.fatherName = this.fatherName;
        res.spouseName = this.spouseName;
        res.motherName = this.motherName;
        res.fatherHin = this.fatherHin;
        res.motherHin = this.motherHin;
        res.tutorName = this.tutorName;
        res.motherId = this.motherId;
        res.fatherId = this.fatherId;
        res.tutorId = this.tutorId;
        res.lastProfileVersion = MiscUtil.fromInt((Integer)this.lastProfileVersion);
        res.treatingProfessionnal = this.treatingProfessionnal;
        res.isSensible = this.isSensible;
        res.isScanned = this.isScanned;
        res.custodyTerms = this.custodyTerms;
        res.sofyAuthorized = this.sofyAuthorized;
        if (this.b2bInformation != null) {
            res.b2bInformation = this.b2bInformation.x();
        }
        String binarySofyGuardianAccess = (this.tutorSofyAccessGranted ? "1" : "0") + (this.fatherSofyAccessGranted ? "1" : "0") + (this.motherSofyAccessGranted ? "1" : "0") + (this.tutorSofyAccessLocked ? "1" : "0") + (this.fatherSofyAccessLocked ? "1" : "0") + (this.motherSofyAccessLocked ? "1" : "0") + (this.permanentSofyAccess ? "1" : "0") + (this.tutorSofyAccess ? "1" : "0") + (this.fatherSofyAccess ? "1" : "0") + (this.motherSofyAccess ? "1" : "0");
        res.sofyGuardianAccess = (short)Integer.parseInt(binarySofyGuardianAccess, 2);
        return res;
    }

    public static CPatient c(XPatient x) {
        return x == null ? null : new CPatient(x);
    }

    public <T> void convertc(T type) {
        XPatient x = (XPatient)XPatient.class.cast(type);
        this.init(x);
    }

    public XPatient convertx() {
        return this.x();
    }

    public static List<XPatient> cToXList(List<CPatient> list) {
        ArrayList<XPatient> xl = new ArrayList<XPatient>();
        for (CPatient c : list) {
            xl.add(c.x());
        }
        return xl;
    }
}

