/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.OrderedDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.OrderedDataObjectList;
import ca.infodata.ofys.ui.dashboard.models.CEditableDataObjectList;
import ca.infodata.ofys.ui.dashboard.models.COrderedDataObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class COrderedDataObjectList<E extends COrderedDataObject>
extends CEditableDataObjectList<E> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(COrderedDataObjectList.class.getName());

    public COrderedDataObjectList() {
    }

    public <T extends EditableDataObject> COrderedDataObjectList(IEditableDataObjectList<T> chainedList, Class<E> conversionClass) {
        if (chainedList != null) {
            try {
                for (int i = 0; i < chainedList.size(); ++i) {
                    COrderedDataObject conv = (COrderedDataObject)((Object)conversionClass.newInstance());
                    conv.convertc(chainedList.get(i));
                    this.add(conv);
                }
            }
            catch (InstantiationException e) {
                logger.log(Level.SEVERE, "Could not instantiate object list", e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, "Violation of access", e);
            }
        }
    }

    public <T extends EditableDataObject> COrderedDataObjectList(List<T> chainedList, Class<E> conversionClass) {
        if (chainedList != null) {
            try {
                for (int i = 0; i < chainedList.size(); ++i) {
                    COrderedDataObject conv = (COrderedDataObject)((Object)conversionClass.newInstance());
                    conv.convertc(chainedList.get(i));
                    this.add(conv);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public <T extends OrderedDataObject> COrderedDataObjectList(OrderedDataObjectList<T> chainedList, Class<E> conversionClass) {
        OrderedDataObject object = chainedList.getFirst();
        int order = 0;
        if (object != null) {
            try {
                COrderedDataObject conv = (COrderedDataObject)((Object)conversionClass.newInstance());
                conv.order = order;
                conv.convertc(object);
                this.add(conv);
                OrderedDataObject prevObject = object;
                while (object.getNext() != null && !prevObject.equals((Object)(object = object.getNext()))) {
                    conv = (COrderedDataObject)((Object)conversionClass.newInstance());
                    conv.order = ++order;
                    conv.convertc(object);
                    this.add(conv);
                    prevObject.setNextNoDirty(object);
                    prevObject = object;
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T extends OrderedDataObject, E extends COrderedDataObject> OrderedDataObjectList<T> xordered(List<E> list) {
        OrderedDataObjectList xlist = new OrderedDataObjectList();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                OrderedDataObject o = (OrderedDataObject)((COrderedDataObject)((Object)list.get(i))).convertx();
                xlist.addAsLast(o);
            }
        }
        return xlist;
    }
}

