/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsText;
import ca.infodata.ofys.ui.dashboard.models.CBaseLaboResultsProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CBaseProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CLaboResultsText;
import ca.infodata.readhl7.Doit;
import ca.infodata.util1.ByteSerialiser;
import ca.infodata.util1.StringUtils;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CLaboResultsProfessionnal
extends CBaseLaboResultsProfessionnal {
    private static final Logger logger = Logger.getLogger(CLaboResultsProfessionnal.class.getName());
    public String note;
    private boolean showDiff = false;
    public Long seenDatetime;
    public Long signedDatetime;
    public CBaseProfessionnal professionnal;
    public CLaboResultsText laboResults;
    public CLaboResultsText previousLaboResultsSeen;
    public String notesHistory;
    public List<CLaboResultsText> prevLaboResultsVersion;
    public String text;
    public String html;
    public String type;

    public CLaboResultsProfessionnal() {
        super((XLaboResultsProfessionnal)null);
    }

    public CLaboResultsProfessionnal(XLaboResultsProfessionnal labres, boolean keepHl7) {
        super(labres);
        this.className = CLaboResultsProfessionnal.class.getSimpleName();
        this.showDiff = false;
        this.note = labres.note;
        this.seenDatetime = labres.seenDatetime == null || labres.seenDatetime == -1L ? null : labres.seenDatetime;
        this.signedDatetime = labres.signedDatetime == null || labres.signedDatetime == -1L ? null : labres.signedDatetime;
        this.professionnal = labres.professionnal == null ? null : new CBaseProfessionnal(labres.professionnal);
        this.status = labres.status;
        this.laboResults = CLaboResultsText.c(labres.laboResults);
        this.previousLaboResultsSeen = CLaboResultsText.c(labres.previousLaboResultsSeen);
        this.notesHistory = labres.notesHistory;
        if (labres.prevLaboResultsVersions != null && !labres.prevLaboResultsVersions.isEmpty()) {
            this.prevLaboResultsVersion = new ArrayList<CLaboResultsText>(labres.prevLaboResultsVersions.size());
            for (XLaboResultsText x : labres.prevLaboResultsVersions) {
                this.prevLaboResultsVersion.add(CLaboResultsText.c(x));
            }
        }
        this.text = this.getText();
        this.html = this.getLaboHtml(keepHl7);
        this.type = this.html != null && this.html != "" ? "html" : (this.text != null && this.text != "" ? "txt" : "nan");
    }

    private String getText() {
        return CLaboResultsProfessionnal.getCleanText(this.laboResults);
    }

    public static String getCleanText(CLaboResultsText laboResults) {
        String res = null;
        if (laboResults == null) {
            logger.log(Level.WARNING, "Null pointer. Empty laboratory.");
            return "";
        }
        if (laboResults.textValueCompressed != null && laboResults.textValueCompressed.length > 10) {
            String texte = (String)ByteSerialiser.deserialize((byte[])laboResults.textValueCompressed);
            if (texte == null) {
                texte = "Invalid text";
                logger.log(Level.WARNING, "Could not deserialize laboratory text");
            }
            res = texte;
        }
        return res;
    }

    public static String getCleanLaboHtml(CLaboResultsText laboResults) {
        String res = "";
        if (laboResults == null) {
            logger.log(Level.WARNING, "Null pointer. Empty laboratory.");
            return "";
        }
        if (laboResults.hl7ValueCompressed != null) {
            String hl7 = (String)ByteSerialiser.deserialize((byte[])laboResults.hl7ValueCompressed);
            laboResults.hl7ValueCompressed = null;
            Doit d = new Doit();
            String htmlText = d.getHtmlFromHl7(hl7);
            String printedBy = Application.get().getApplicationUiPlugin().getPrintedByNotice();
            res = htmlText = StringUtils.replaceOnce((String)htmlText, (String)"print-by-and-date-time", (String)printedBy);
        }
        return res;
    }

    private String getLaboHtml(boolean keepHl7) {
        String res = "";
        if (this.laboResults == null) {
            logger.log(Level.WARNING, "Null pointer. Empty laboratory.");
            return "";
        }
        if (this.laboResults.hl7ValueCompressed != null) {
            String hl7 = (String)ByteSerialiser.deserialize((byte[])this.laboResults.hl7ValueCompressed);
            if (!keepHl7) {
                this.laboResults.hl7ValueCompressed = null;
            }
            Doit d = new Doit();
            String htmlText = d.getHtmlFromHl7(hl7);
            String printedBy = Application.get().getApplicationUiPlugin().getPrintedByNotice();
            htmlText = StringUtils.replaceOnce((String)htmlText, (String)"print-by-and-date-time", (String)printedBy);
            Patch patch = null;
            String hl7Prev = "";
            String htmlTextPrev = "";
            if (this.showDiff) {
                if (this.previousLaboResultsSeen != null && this.previousLaboResultsSeen.hl7ValueCompressed != null) {
                    hl7Prev = (String)ByteSerialiser.deserialize((byte[])this.previousLaboResultsSeen.hl7ValueCompressed);
                    this.previousLaboResultsSeen.hl7ValueCompressed = null;
                    String splitChar = "([\n]|[\r]|[\r\n])";
                    List<String> original = Arrays.asList(hl7Prev.split(splitChar));
                    String mshLine = "";
                    String pidLine = "";
                    String orcLine = "";
                    for (String os : original) {
                        if (os.startsWith("MSH")) {
                            mshLine = os;
                            continue;
                        }
                        if (os.startsWith("PID")) {
                            pidLine = os;
                            break;
                        }
                        if (!os.startsWith("ORC")) continue;
                        orcLine = os;
                        break;
                    }
                    List<String> revised = Arrays.asList(hl7.split(splitChar));
                    patch = DiffUtils.diff(original, revised);
                    StringBuilder hl7Diff = new StringBuilder();
                    boolean mshDone = false;
                    boolean pidDone = false;
                    boolean orcDone = false;
                    String saut = "\r\n";
                    for (Delta delta : patch.getDeltas()) {
                        for (Object l : delta.getRevised().getLines()) {
                            String sl = (String)l;
                            if (!mshDone) {
                                if (sl.startsWith("MSH")) {
                                    hl7Diff.append(sl + saut);
                                } else if (!mshDone) {
                                    hl7Diff.append(mshLine + saut);
                                }
                                mshDone = true;
                                continue;
                            }
                            if (!pidDone) {
                                pidDone = true;
                                if (sl.startsWith("PID")) {
                                    hl7Diff.append(sl + saut);
                                    continue;
                                }
                                hl7Diff.append(pidLine + saut);
                                if (sl.startsWith("ORC")) {
                                    orcDone = true;
                                }
                                hl7Diff.append(sl + saut);
                                continue;
                            }
                            if (!orcDone) {
                                orcDone = true;
                                if (sl.startsWith("ORC")) {
                                    hl7Diff.append(sl + saut);
                                    continue;
                                }
                                hl7Diff.append(orcLine + saut);
                                continue;
                            }
                            hl7Diff.append(sl + saut);
                        }
                    }
                    htmlTextPrev = hl7Diff.toString();
                    htmlTextPrev = d.getHtmlFromHl7(htmlTextPrev).replace("\\X000D\\\\X000A\\", "~");
                    htmlTextPrev = StringUtils.replaceOnce((String)htmlTextPrev, (String)"print-by-and-date-time", (String)printedBy);
                    res = htmlTextPrev = StringUtils.replace((String)htmlTextPrev, (String)"\"#DADAFF\"", (String)"\"#FFFFF0\"");
                } else {
                    res = htmlText;
                }
            } else {
                res = htmlText;
            }
        }
        return res;
    }

    public static CLaboResultsProfessionnal c(XLaboResultsProfessionnal x, boolean keepHl7) {
        return x == null ? null : new CLaboResultsProfessionnal(x, keepHl7);
    }
}

