/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XBasePerson;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformType;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEnumCrdsSousStatut;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEnumCrdsStatut;
import ca.infodata.ofys.data.middle.dataobjects.eform.XFlagStatutCrdsFormData;
import ca.infodata.ofys.ui.dashboard.models.CAttenteResultats;
import ca.infodata.ofys.ui.dashboard.models.CForm;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashSet;

public class CFormData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String className = CFormData.class.getSimpleName();
    public int uid;
    public Integer id;
    public Integer tag;
    public Integer idAnchor;
    public Integer idForm;
    public CForm form;
    public String date;
    public Integer idAuthor;
    public String author;
    public Integer idPatient;
    public CPatient patient;
    public Integer idEncounter;
    public String data;
    public Boolean deleted;
    public String resumeValue;
    public Boolean isModifiable;
    public String metaData;
    public HashSet<String> addedLinks = new HashSet();
    public String dataJsonb;
    public String cnesstRefNo;
    public String crdsRequestId;
    public String crdsNoPermisRef;
    public String crdsNomCreateur;
    public String crdsNomProfRef;
    public CAttenteResultats attente;
    public XEnumCrdsStatut crdsStatut;
    public XEnumCrdsSousStatut crdsSousStatut;
    public String crdsDateModif;
    public String crdsNote;
    public LocalDate apptDate;
    public Short apptTime;
    public EnumSet<XFlagStatutCrdsFormData> flagStatut;

    public CFormData() {
    }

    public XEformData toXEformData() {
        XEformData data = new XEformData();
        data.setId(this.id);
        data.setData(this.data);
        data.setDataJson(this.dataJsonb);
        if (StringUtils.isNotEmpty((String)this.date)) {
            data.setDatetime(DateUtil.dataStringToCalendar((String)this.date.replaceAll("[// /:/-]", "")));
        } else {
            data.setDatetime(Calendar.getInstance());
        }
        data.setIdAnchor(this.idAnchor);
        data.setTag(this.getSetTag());
        data.setIdAuthor(this.idAuthor);
        data.setIdEncounter(this.idEncounter);
        data.setIdPatient(this.idPatient);
        data.setMetaData(this.metaData);
        data.setDeleted(this.deleted);
        data.setIsModifiable(this.isModifiable);
        data.setResumeValue(this.resumeValue);
        data.setEform(new XBaseEform());
        data.getForm().setId(this.idForm);
        data.getForm().setIdAnchor(this.form.idAnchor);
        data.getForm().setType(XEformType.from((Integer)this.form.type));
        data.getForm().setName(this.form.name);
        data.getForm().setCode(this.form.code);
        data.setAddedLinks(this.addedLinks);
        data.setCnesstRefNo(this.cnesstRefNo);
        data.setCrdsRequestId(this.crdsRequestId);
        data.setCrdsNomCreateur(this.crdsNomCreateur);
        data.setCrdsNoPermisRef(this.crdsNoPermisRef);
        data.setAttente(this.attente == null ? null : this.attente.convertx());
        return data;
    }

    public XBaseEformData toXBaseEformData() {
        XBaseEformData data = new XBaseEformData();
        data.setId(this.id);
        data.setDataJson(this.dataJsonb);
        if (StringUtils.isNotEmpty((String)this.date)) {
            data.setDatetime(DateUtil.dataStringToCalendar((String)this.date.replaceAll("[// /:/-]", "")));
        } else {
            data.setDatetime(Calendar.getInstance());
        }
        data.setIdAnchor(this.idAnchor);
        data.setTag(this.getSetTag());
        data.setIdAuthor(this.idAuthor);
        data.setIdEncounter(this.idEncounter);
        data.setIdPatient(this.idPatient);
        data.setMetaData(this.metaData);
        data.setDeleted(this.deleted);
        data.setIsModifiable(this.isModifiable);
        data.setResumeValue(this.resumeValue);
        data.setEform(new XBaseEform());
        data.getForm().setId(this.idForm);
        data.getForm().setIdAnchor(this.form.idAnchor);
        data.getForm().setType(XEformType.from((Integer)this.form.type));
        data.getForm().setName(this.form.name);
        data.getForm().setCode(this.form.code);
        data.setAddedLinks(this.addedLinks);
        data.setCnesstRefNo(this.cnesstRefNo);
        data.setCrdsRequestId(this.crdsRequestId);
        data.setCrdsNomCreateur(this.crdsNomCreateur);
        data.setCrdsNoPermisRef(this.crdsNoPermisRef);
        return data;
    }

    public Integer getSetTag() {
        if (this.tag != null) {
            return this.tag;
        }
        this.tag = Application.get().getAtomicUniqueValueGenerator().nextInt("cformdata");
        return this.tag;
    }

    private Integer newTag() {
        return Application.get().getAtomicUniqueValueGenerator().nextInt("cformdata");
    }

    public CFormData(XBaseEformData data, XBaseEform form) {
        if (form == null) {
            form = data.getForm();
        }
        this.uid = Utils.getNewAtomicInteger();
        this.id = data.getId();
        this.idAnchor = data.getIdAnchor();
        this.tag = this.newTag();
        this.idForm = form.getId();
        this.form = new CForm(form);
        this.date = Utils.getDateTimeFromLong(data.getDatetime().getTimeInMillis());
        this.idAuthor = data.getIdAuthor();
        if (this.idAuthor != null) {
            XBasePerson person = Application.get().getPersonPluginController().getBasePersonByIdPerson(this.idAuthor);
            this.author = person == null ? null : person.getName();
        }
        this.idPatient = data.getIdPatient();
        this.patient = data.getPatient() == null ? null : CPatient.c(data.getPatient());
        this.idEncounter = data.getIdEncounter();
        this.deleted = data.getDeleted();
        this.isModifiable = data.getIsModifiable();
        this.dataJsonb = data.getDataJson();
        this.resumeValue = data.getResumeValue() == null || StringUtils.isEmpty((String)data.getResumeValue().replaceAll("\"", "")) ? null : data.getResumeValue();
        this.addedLinks.addAll(data.getAddedLinks());
        this.cnesstRefNo = data.getCnesstRefNo();
        this.crdsRequestId = data.getCrdsRequestId();
        this.crdsNomCreateur = data.getCrdsNomCreateur();
        this.crdsNoPermisRef = data.getCrdsNoPermisRef();
        XBaseProfessionnal prof = Application.get().getPersonPluginController().getProfessionnalByNoProf(data.getCrdsNoPermisRef());
        if (prof != null) {
            this.crdsNomProfRef = prof.getLastName() + " " + prof.getFirstName();
        }
        if (data.getAttente() != null) {
            CAttenteResultats cAtt = new CAttenteResultats();
            cAtt.convertc(data.getAttente());
            this.attente = cAtt;
        }
        if (data.getCrdsRequestId() != null && data.getCrdsDateModif() != null) {
            this.crdsRequestId = data.getCrdsRequestId();
            this.crdsDateModif = Utils.longTodateStr(data.getCrdsDateModif().getTime(), "yyyy-MM-dd");
            this.apptDate = data.getApptDate();
            this.apptTime = data.getApptTime();
            this.crdsNoPermisRef = data.getCrdsNoPermisRef();
            this.crdsNote = data.getCrdsNote();
            this.crdsStatut = data.getCrdsStatut();
            this.crdsSousStatut = data.getCrdsSousStatut();
            this.flagStatut = data.getFlagStatut();
        }
    }

    public CFormData(XEformData data, XBaseEform form) {
        this.uid = Utils.getNewAtomicInteger();
        this.id = data.getId();
        this.idAnchor = data.getIdAnchor();
        this.tag = this.newTag();
        this.idForm = form.getId();
        this.form = new CForm(form);
        this.date = Utils.getDateTimeFromLong(data.getDatetime().getTimeInMillis());
        this.idAuthor = data.getIdAuthor();
        if (this.idAuthor != null) {
            XBasePerson person = Application.get().getPersonPluginController().getBasePersonByIdPerson(this.idAuthor);
            this.author = person == null ? null : person.getName();
        }
        this.idPatient = data.getIdPatient();
        this.patient = data.getPatient() == null ? null : CPatient.c(data.getPatient());
        this.idEncounter = data.getIdEncounter();
        this.data = data.getData();
        this.deleted = data.getDeleted();
        this.isModifiable = data.getIsModifiable();
        this.resumeValue = data.getResumeValue() == null || StringUtils.isEmpty((String)data.getResumeValue().replaceAll("\"", "")) ? null : data.getResumeValue();
        this.metaData = data.getMetaData();
        this.addedLinks.addAll(data.getAddedLinks());
        this.dataJsonb = data.getDataJson();
        this.crdsRequestId = data.getCrdsRequestId();
        this.crdsNomCreateur = data.getCrdsNomCreateur();
        this.crdsNoPermisRef = data.getCrdsNoPermisRef();
        if (data.getAttente() != null) {
            CAttenteResultats cAtt = new CAttenteResultats();
            cAtt.convertc(data.getAttente());
            this.attente = cAtt;
        }
        if (data.getCrdsRequestId() != null && data.getCrdsDateModif() != null) {
            this.crdsRequestId = data.getCrdsRequestId();
            this.crdsDateModif = Utils.longTodateStr(data.getCrdsDateModif().getTime(), "yyyy-MM-dd");
            this.apptDate = data.getApptDate();
            this.apptTime = data.getApptTime();
            this.crdsNoPermisRef = data.getCrdsNoPermisRef();
            this.crdsNote = data.getCrdsNote();
            this.crdsStatut = data.getCrdsStatut();
            this.crdsSousStatut = data.getCrdsSousStatut();
            this.flagStatut = data.getFlagStatut();
        }
    }

    public CFormData(XEformData data) {
        this(data, data.getForm());
    }
}

