/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterLabel;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDevice;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugStrength;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugType;
import ca.infodata.ofys.data.middle.dataobjects.medication.XFavPrescription;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyHumanSubstanceAdministrationSite;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyOrderableDrugForm;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyRouteOfAdministration;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDrugNameFormat;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class CFavPrescription
extends CEditableDataObject {
    private static final long serialVersionUID = 1L;
    public Integer din;
    public Integer quantity;
    public Integer treatmentDuration;
    public String name;
    public String baseDrugName;
    public String strength;
    public Integer route;
    public String routeString;
    public Integer format;
    public String formatString;
    public Integer site;
    public String siteString;
    public Integer baseDrugType;
    public XMyRouteOfAdministration routeObj;
    public XMyOrderableDrugForm formatObj;
    public XMyHumanSubstanceAdministrationSite siteObj;
    public Integer rx;
    public String posology;
    public Boolean noSubstitution;
    public CDevice deviceObj;
    public Integer idDevice;
    public CDrugStrength strengthObj;
    public Integer idStrength;
    public String frequency;
    public Boolean toReprescribeB;
    public Integer id;
    public String note;
    public Boolean isDeleted;
    public String dsqIt1;
    public String dsqIt2;
    public String dsqIt3;
    public String dsqIt4;
    public String dsqIt5;
    public String noteDsq;
    public Integer professionnal;
    public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
    public int hash;
    public String bgStatusColor = "white";
    private String completeNameForFavorites;

    public EnumSet<XEncounterLabel> getEncLabel() {
        return this.encLabel;
    }

    public void setEncLabel(EnumSet<XEncounterLabel> status) {
        this.encLabel = status;
    }

    public void removeXEncounterLabel(XEncounterLabel x) {
        this.encLabel.remove(x);
    }

    public void addXEncounterLabel(XEncounterLabel x) {
        this.encLabel.add(x);
    }

    public CFavPrescription() {
    }

    public CFavPrescription(XPrescription x) {
        this.din = x.din;
        this.quantity = x.quantity;
        this.treatmentDuration = x.treatmentDuration;
        if (x.route != null) {
            this.route = x.route.getId();
            this.routeString = x.route.description();
        } else {
            this.route = XMyRouteOfAdministration.SO_NA.getId();
            this.routeString = XMyRouteOfAdministration.SO_NA.description();
        }
        if (x.site != null) {
            this.site = x.site.getId();
            this.siteString = x.site.toString();
        } else {
            this.site = XMyHumanSubstanceAdministrationSite.SO_NA.getId();
            this.siteString = XMyHumanSubstanceAdministrationSite.SO_NA.description();
        }
        if (x.format != null) {
            this.format = x.format.getId();
            this.formatString = x.format.description();
        } else {
            this.format = XMyOrderableDrugForm.SO_NA.getId();
            this.formatString = XMyOrderableDrugForm.SO_NA.description();
        }
        this.rx = x.rx;
        this.posology = x.posology;
        this.isDeleted = Boolean.FALSE;
        this.toReprescribeB = x.toReprescribe;
        if (x.getDevice() != null) {
            this.name = x.getDevice().getName();
            this.baseDrugType = XDrugType.FOURNITURE.getValue();
        } else if (x.getStrength() != null) {
            this.strength = x.strength.strength;
            this.baseDrugName = x.strength.baseName;
            this.name = x.strength.name;
            this.din = x.strength.din;
            this.baseDrugType = x.strength.drugType == null ? 0 : x.strength.drugType.getValue();
        }
        this.frequency = x.frequency;
        this.note = x.note;
        this.dsqIt1 = x.dsqIt1;
        this.dsqIt2 = x.dsqIt2;
        this.dsqIt3 = x.dsqIt3;
        this.dsqIt4 = x.dsqIt4;
        this.dsqIt5 = x.dsqIt5;
        this.encLabel = x.encLabel.clone();
        this.hash = this.toString().hashCode();
    }

    public boolean isDirty() {
        boolean dirty = super.isDirty();
        return dirty;
    }

    public Integer getIdDevice() {
        return this.idDevice;
    }

    public void setIdDevice(Integer idDevice) {
        this.idDevice = idDevice;
    }

    public Integer getIdStrength() {
        return this.idStrength;
    }

    public void setIdStrength(Integer idStrength) {
        this.idStrength = idStrength;
    }

    public String getGenericDrugNameStrengthPosol() {
        ArrayList<String> lst = new ArrayList<String>();
        if (this.baseDrugName != null) {
            lst.add(this.baseDrugName);
        }
        if (this.strength != null) {
            lst.add(this.strength);
        }
        lst.add(this.getPosology());
        return new JoinList(" ", lst).toString();
    }

    public final String getCompleteNameForFavorites() {
        if (this.completeNameForFavorites == null) {
            this.completeNameForFavorites = this.getGenericDrugNameStrengthPosol() + this.formatString + this.getFrequency() + this.getRx().toString();
        }
        return this.completeNameForFavorites;
    }

    public String getCommercialDrugNameStrengthPosol() {
        ArrayList<String> lst = new ArrayList<String>();
        if (this.name != null) {
            lst.add(this.name);
        }
        if (this.strength != null) {
            lst.add(this.strength);
        }
        lst.add(this.getPosology());
        return new JoinList(" ", lst).toString();
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Integer getTreatmentDuration() {
        return this.treatmentDuration;
    }

    public void setTreatmentDuration(Integer treatmentDuration) {
        this.treatmentDuration = treatmentDuration;
    }

    public XMyRouteOfAdministration getRouteObj() {
        return this.routeObj;
    }

    public void setRouteObj(XMyRouteOfAdministration route) {
        this.routeObj = route;
        if (route != null) {
            this.route = route.getId();
            this.routeString = route.description();
        } else {
            this.route = XMyRouteOfAdministration.SO_NA.getId();
            this.routeString = XMyRouteOfAdministration.SO_NA.description();
        }
    }

    public XMyOrderableDrugForm getFormatObj() {
        return this.formatObj;
    }

    public void setFormatObj(XMyOrderableDrugForm format) {
        this.formatObj = format;
        if (format != null) {
            this.format = format.getId();
            this.formatString = format.description();
        } else {
            this.format = XMyOrderableDrugForm.SO_NA.getId();
            this.formatString = XMyOrderableDrugForm.SO_NA.description();
        }
    }

    public Integer getRx() {
        return this.rx;
    }

    public void setRx(Integer rx) {
        this.rx = rx;
    }

    public String getPosology() {
        return this.posology;
    }

    public void setPosology(String posology) {
        this.posology = posology;
    }

    public Boolean getNoSubstitution() {
        return this.noSubstitution;
    }

    public void setNoSubstitution(Boolean noSubstitution) {
        this.noSubstitution = noSubstitution;
    }

    public Integer getProfessionnal() {
        return this.professionnal;
    }

    public void setProfessionnal(Integer professionnal) {
        this.professionnal = professionnal;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void useInformationFrom(CFavPrescription prescription) {
        if (prescription == null) {
            throw new NullPointerException("prescription");
        }
        ObjectListenerManager.disable((Object)((Object)this));
        this.setQuantity(prescription.getQuantity());
        this.setTreatmentDuration(prescription.getTreatmentDuration());
        this.setRoute(prescription.getRoute());
        this.setFormat(prescription.getFormat());
        this.setRx(prescription.getRx());
        this.setPosology(prescription.getPosology());
        this.setIsDeleted(prescription.getIsDeleted());
        this.setStrength(prescription.getStrength());
        this.setName(prescription.getName());
        this.setBaseDrugName(prescription.getBaseDrugName());
        this.setBaseDrugType(prescription.getBaseDrugType());
        this.setDin(prescription.getDin());
        this.setFrequency(prescription.getFrequency());
        this.setToReprescribe(prescription.getToReprescribe());
        this.setNote(prescription.getNote());
        this.setDsqIt1(prescription.getDsqIt1());
        this.setDsqIt2(prescription.getDsqIt2());
        this.setDsqIt3(prescription.getDsqIt3());
        this.setDsqIt4(prescription.getDsqIt4());
        this.setDsqIt5(prescription.getDsqIt5());
        this.hash = this.toString().hashCode();
    }

    public CFavPrescription clone() {
        CFavPrescription c = new CFavPrescription();
        c.id = this.id;
        c.din = this.din;
        c.quantity = this.quantity;
        c.treatmentDuration = this.treatmentDuration;
        c.setRoute(this.route);
        c.setSite(this.site);
        c.setFormat(this.format);
        c.rx = this.rx;
        c.posology = this.posology;
        c.isDeleted = this.isDeleted;
        c.toReprescribeB = this.toReprescribeB;
        c.baseDrugType = this.baseDrugType;
        c.name = this.name;
        c.baseDrugName = this.baseDrugName;
        c.strength = this.strength == null ? null : this.strength;
        c.frequency = this.frequency;
        c.note = this.note;
        c.dsqIt1 = this.dsqIt1;
        c.dsqIt2 = this.dsqIt2;
        c.dsqIt3 = this.dsqIt3;
        c.dsqIt4 = this.dsqIt4;
        c.dsqIt5 = this.dsqIt5;
        c.encLabel = this.encLabel.clone();
        return c;
    }

    public Boolean getToReprescribe() {
        return this.toReprescribeB;
    }

    public void setToReprescribe(Boolean toReprescribe) {
        this.toReprescribeB = toReprescribe;
    }

    public XMyHumanSubstanceAdministrationSite getSiteObj() {
        return this.siteObj;
    }

    public void setSiteObj(XMyHumanSubstanceAdministrationSite site) {
        this.siteObj = site;
        if (site != null) {
            this.site = site.getId();
            this.siteString = site.description();
        } else {
            this.site = XMyHumanSubstanceAdministrationSite.SO_NA.getId();
            this.siteString = XMyHumanSubstanceAdministrationSite.SO_NA.description();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBaseDrugName() {
        return this.baseDrugName;
    }

    public void setBaseDrugName(String baseDrugName) {
        this.baseDrugName = baseDrugName;
    }

    public String getStrength() {
        return this.strength;
    }

    public void setStrength(String strength) {
        this.strength = strength;
    }

    public Integer getRoute() {
        return this.route;
    }

    public void setRoute(Integer route) {
        this.route = route;
        this.routeObj = XMyRouteOfAdministration.getRoute((Integer)route);
        this.routeString = this.routeObj == null ? null : this.routeObj.description();
    }

    public String getRouteString() {
        return this.routeString;
    }

    public void setRouteString(String routeString) {
        this.routeString = routeString;
    }

    public Integer getFormat() {
        return this.format;
    }

    public void setFormat(Integer format) {
        this.format = format;
        this.formatObj = XMyOrderableDrugForm.getDrugForm((Integer)format);
        this.formatString = this.formatObj == null ? null : this.formatObj.description();
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public Integer getSite() {
        return this.site;
    }

    public void setSite(Integer site) {
        this.site = site;
        this.siteObj = XMyHumanSubstanceAdministrationSite.getSite((Integer)site);
        this.siteString = this.siteObj == null ? null : this.siteObj.description();
    }

    public String getSiteString() {
        return this.siteString;
    }

    public void setSiteString(String siteString) {
        this.siteString = siteString;
    }

    public Integer getBaseDrugType() {
        return this.baseDrugType;
    }

    public void setBaseDrugType(Integer baseDrugType) {
        this.baseDrugType = baseDrugType;
    }

    public CDevice getDeviceObj() {
        return this.deviceObj;
    }

    public void setDeviceObj(CDevice deviceObj) {
        this.deviceObj = deviceObj;
    }

    public CDrugStrength getStrengthObj() {
        return this.strengthObj;
    }

    public void setStrengthObj(CDrugStrength strengthObj) {
        this.strengthObj = strengthObj;
        if (strengthObj != null) {
            this.name = this.strengthObj.getCommercialName();
            this.baseDrugName = this.strengthObj.getGenericName();
            this.baseDrugType = this.strengthObj.drugType != null ? this.strengthObj.drugType.getValue() : 0;
            this.strength = this.strengthObj.getStrength();
            this.din = this.strengthObj.getDin();
        }
    }

    public String toString() {
        if (XDrugType.FOURNITURE.getValue() == this.baseDrugType.intValue()) {
            return String.format("FavDev [n=%s, qty=%s, dur=%s, rx=%s, pos=%s, frq=%s, tor=%s]", this.name, this.quantity == null ? 0 : this.quantity, this.treatmentDuration == null ? 0 : this.treatmentDuration, this.rx == null ? 0 : this.rx, this.posology, this.frequency == null ? "" : this.frequency, Boolean.TRUE.equals(this.toReprescribeB) ? 1 : 0);
        }
        return String.format("FavRx [din=%s, n=%s, qty=%s, dur=%s, rte=%s, frm=%s, st=%s, rx=%s, pos=%s, str=%s, frq=%s, tor=%s]", this.din == null ? "d0" : Integer.valueOf(this.din), this.name, this.quantity == null ? 0 : this.quantity, this.treatmentDuration == null ? 0 : this.treatmentDuration, this.route == null ? 0 : this.route, this.format == null ? 0 : this.format, this.site == null ? 0 : this.site, this.rx == null ? 0 : this.rx, this.posology, this.strength, this.frequency == null ? "" : this.frequency, Boolean.TRUE.equals(this.toReprescribeB) ? 1 : 0);
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof CFavPrescription) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("CPrescription" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    public Integer getDin() {
        return this.din;
    }

    public void setDin(Integer din) {
        this.din = din;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getDsqIt1() {
        return this.dsqIt1;
    }

    public void setDsqIt1(String dsqIt1) {
        this.dsqIt1 = dsqIt1;
    }

    public String getDsqIt2() {
        return this.dsqIt2;
    }

    public void setDsqIt2(String dsqIt2) {
        this.dsqIt2 = dsqIt2;
    }

    public String getDsqIt3() {
        return this.dsqIt3;
    }

    public void setDsqIt3(String dsqIt3) {
        this.dsqIt3 = dsqIt3;
    }

    public String getDsqIt4() {
        return this.dsqIt4;
    }

    public void setDsqIt4(String dsqIt4) {
        this.dsqIt4 = dsqIt4;
    }

    public String getDsqIt5() {
        return this.dsqIt5;
    }

    public void setDsqIt5(String dsqIt5) {
        this.dsqIt5 = dsqIt5;
    }

    public String formatName(XPrescriptionDrugNameFormat format) {
        StringBuilder ret = new StringBuilder(30);
        switch (format) {
            case GENERIC_AND_COMMERCIAL: {
                ret.append(this.getBaseDrugName());
                ret.append(" (");
                ret.append(this.getName());
                ret.append(")");
                break;
            }
            case COMMERCIAL_AND_GENERIC: {
                ret.append(this.getName());
                ret.append(" (");
                ret.append(this.getBaseDrugName());
                ret.append(")");
                break;
            }
            case COMMERCIAL: {
                ret.append(this.getName());
                break;
            }
            case GENERIC: {
                ret.append(this.getBaseDrugName());
            }
        }
        return ret.toString();
    }

    public String getDsqIt() {
        ArrayList<String> lst = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.getDsqIt1())) {
            lst.add("P1:" + this.getDsqIt1().trim());
        }
        if (StringUtils.isNotBlank((String)this.getDsqIt2())) {
            lst.add("P2:" + this.getDsqIt2().trim());
        }
        if (StringUtils.isNotBlank((String)this.getDsqIt3())) {
            lst.add("P3:" + this.getDsqIt3().trim());
        }
        if (StringUtils.isNotBlank((String)this.getDsqIt4())) {
            lst.add("P4:" + this.getDsqIt4().trim());
        }
        if (StringUtils.isNotBlank((String)this.getDsqIt5())) {
            lst.add("P5:" + this.getDsqIt5().trim());
        }
        String ss = lst.size() == 0 ? "" : new JoinList(", ", lst).toString();
        return ss;
    }

    public CFavPrescription(XFavPrescription x) {
        this.init(x);
    }

    private void init(XFavPrescription x) {
        super.init((IEditableDataObject)x);
        this.id = x.id;
        this.din = x.din;
        this.quantity = x.quantity;
        if (this.quantity == null || this.quantity == 0) {
            this.treatmentDuration = x.treatmentDuration;
        }
        if (x.getStrength() != null) {
            this.name = x.getStrength().getName();
            this.baseDrugName = x.getStrength().getBaseName();
            this.setBaseDrugType(x.getStrength().getDrugType() == null ? XDrugType.REGULAR.value : x.getStrength().getDrugType().getValue());
            this.strength = x.strength.strength;
            this.idStrength = x.getStrength().getId();
        } else if (x.getDevice() != null) {
            this.name = x.getDevice().getName();
            this.setBaseDrugType(XDrugType.FOURNITURE.value);
            this.idDevice = x.getDevice().getId();
        }
        this.setRouteObj(x.route);
        this.setSiteObj(x.site);
        this.setFormatObj(x.format);
        this.rx = x.rx;
        this.posology = x.posology;
        this.isDeleted = x.isDeleted;
        this.toReprescribeB = x.toReprescribeB;
        this.frequency = x.frequency;
        this.note = x.note;
        this.dsqIt1 = x.dsqIt1;
        this.dsqIt2 = x.dsqIt2;
        this.dsqIt3 = x.dsqIt3;
        this.dsqIt4 = x.dsqIt4;
        this.dsqIt5 = x.dsqIt5;
        this.encLabel = x.encLabel.clone();
        this.modificationStatus = x.getModificationStatus().toString();
        this.version = x.getVersion();
        this.hash = this.toString().hashCode();
    }

    public <T> void convertc(T type) {
        XFavPrescription x = (XFavPrescription)XFavPrescription.class.cast(type);
        this.init(x);
    }

    public XFavPrescription convertx() {
        return this.x();
    }

    public static CFavPrescription c(XFavPrescription x) {
        return x == null ? null : new CFavPrescription(x);
    }

    public XFavPrescription x() {
        XFavPrescription x = new XFavPrescription();
        super.x((EditableDataObject)x);
        x.id = this.id;
        x.din = this.din;
        x.quantity = this.quantity;
        if (this.quantity == null || this.quantity == 0) {
            x.treatmentDuration = this.treatmentDuration;
        }
        x.route = this.routeObj;
        x.site = this.siteObj;
        x.format = this.formatObj;
        x.rx = this.rx;
        x.posology = this.posology;
        x.isDeleted = this.isDeleted;
        x.toReprescribeB = this.toReprescribeB;
        if (this.baseDrugType != null && XDrugType.FOURNITURE.value == this.baseDrugType) {
            XDevice xv = new XDevice();
            xv.setId(this.getIdDevice());
            xv.setName(this.name);
            x.device = xv;
        } else {
            XDrugStrength xd = new XDrugStrength();
            xd.setBaseName(this.baseDrugName);
            xd.setName(this.name);
            xd.setDin(this.din);
            xd.setDrugType(XDrugType.from((Integer)this.baseDrugType));
            xd.setStrength(this.strength);
            xd.setId(this.getIdStrength());
            x.strength = xd;
        }
        x.frequency = this.frequency;
        x.note = this.note;
        x.dsqIt1 = this.dsqIt1;
        x.dsqIt2 = this.dsqIt2;
        x.dsqIt3 = this.dsqIt3;
        x.dsqIt4 = this.dsqIt4;
        x.dsqIt5 = this.dsqIt5;
        x.encLabel = this.encLabel.clone();
        x.version.plain_set((Object)this.version);
        x.modificationStatus.plain_set((Object)ModificationStatus.from((String)this.modificationStatus));
        return x;
    }

    public static class CDevice
    extends CEditableDataObject {
        private static final long serialVersionUID = 1L;
        private Integer id;
        private String name;
        private Boolean isDeleted;

        public CDevice() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String n) {
            this.name = n;
        }

        public Boolean getIsDeleted() {
            return this.isDeleted;
        }

        public void setIsDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
        }

        public CDevice clone() {
            CDevice c = new CDevice();
            c.id = this.id;
            c.isDeleted = this.isDeleted;
            c.name = this.name;
            return c;
        }

        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (obj instanceof XDevice) {
                equals = this.hashCode() == obj.hashCode();
            }
            return equals;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = this.getId() == null ? super.hashCode() : (((Object)((Object)this)).getClass().getName() + this.getId()).hashCode();
            return hashCode;
        }

        public String getCompleteName() {
            return this.name;
        }

        public String toString() {
            return String.format("XDevice [id=%s, name=%s, isDeleted=%s]", this.id, this.name, this.isDeleted);
        }

        public CDevice(XDevice x) {
            this.init(x);
        }

        private void init(XDevice x) {
            super.init((IEditableDataObject)x);
            this.id = x.getId();
            this.name = x.getName();
            this.isDeleted = x.getIsDeleted();
            this.modificationStatus = x.getModificationStatus().toString();
            this.version = x.getVersion();
        }

        public <T> void convertc(T type) {
            XDevice x = (XDevice)XDevice.class.cast(type);
            this.init(x);
        }

        public XDevice convertx() {
            return this.x();
        }

        public static CDevice c(XDevice x) {
            return x == null ? null : new CDevice(x);
        }

        public XDevice x() {
            XDevice x = new XDevice();
            super.x((EditableDataObject)x);
            x.id = this.id == null || this.id == 0 ? null : this.id;
            x.isDeleted = this.isDeleted;
            x.name = this.name;
            x.version.plain_set((Object)this.version);
            x.modificationStatus.plain_set((Object)ModificationStatus.from((String)this.modificationStatus));
            return x;
        }
    }

    public static class CDrugStrength
    extends CEditableDataObject {
        private static final long serialVersionUID = 1L;
        public static final String type = "drugstrength";
        public Integer id;
        public String strength;
        public Integer din;
        public Set<String> ahfs;
        public Boolean isDeleted;
        public String name;
        public String searchName;
        public String baseName;
        public XDrugType drugType;
        public String searchBaseName;
        private String completeName;

        public CDrugStrength() {
            this.strength = "";
            this.isDeleted = false;
        }

        public CDrugStrength(String name) {
            this.strength = name;
            this.isDeleted = false;
        }

        public String getText() {
            String n = this.getName();
            if (n == null) {
                n = this.getBaseName();
            }
            return n == null ? "" : n;
        }

        public boolean isActive() {
            return Boolean.TRUE.equals(this.getIsDeleted());
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            boolean equals = false;
            if (obj instanceof CDrugStrength) {
                equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
            }
            return equals;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = this.getId() == null ? super.hashCode() : ("XDrugStrength" + this.getId().hashCode()).hashCode();
            return hashCode;
        }

        public CDrugStrength clone() {
            CDrugStrength c = new CDrugStrength();
            c.id = this.id;
            c.din = this.din;
            c.strength = this.strength;
            c.isDeleted = this.isDeleted;
            c.name = this.name;
            c.baseName = this.baseName;
            c.searchName = this.searchName;
            c.searchBaseName = this.searchBaseName;
            c.ahfs = new LinkedHashSet<String>(this.ahfs);
            return c;
        }

        public String getCommercialName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Boolean getIsDeleted() {
            return this.isDeleted;
        }

        public void setIsDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
        }

        public String getType() {
            return type;
        }

        public Integer getDin() {
            return this.din;
        }

        public void setDin(Integer din) {
            this.din = din;
        }

        public XDrugType getDrugType() {
            return this.drugType;
        }

        public void setDrugType(XDrugType drugType) {
            this.drugType = drugType;
        }

        public String getStrength() {
            return this.strength;
        }

        public void setStrength(String strength) {
            this.strength = strength;
        }

        public String getSearchName() {
            return this.searchName;
        }

        public void setSearchName(String searchName) {
            this.searchName = searchName;
        }

        public String getGenericName() {
            return this.baseName;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public void setBaseName(String baseName) {
            this.baseName = baseName;
        }

        public String getSearchBaseName() {
            return this.searchBaseName;
        }

        public void setSearchBaseName(String searchBaseName) {
            this.searchBaseName = searchBaseName;
        }

        public String toString() {
            return String.format("CDrugStrength [id=%s, name=%s, din=%s, ahfs=%s, isDeleted=%s, drug=%s]", this.id, this.strength, this.din, this.ahfs, this.isDeleted, this.name);
        }

        public Set<String> getAhfs() {
            return this.ahfs;
        }

        public void setAhfs(Set<String> ahfs) {
            this.ahfs = ahfs;
        }

        public String getCompleteName() {
            if (this.completeName == null) {
                ArrayList<String> list = new ArrayList<String>(2);
                if (!StringUtils.isBlank((CharSequence)this.name)) {
                    list.add(this.name);
                }
                if (!StringUtils.isBlank((CharSequence)this.baseName)) {
                    list.add(this.baseName);
                }
                if (list.size() == 1) {
                    return (String)list.get(0);
                }
                if (list.size() == 2) {
                    if (this.baseName.toUpperCase().equals(this.name.toUpperCase())) {
                        return this.baseName;
                    }
                    this.completeName = StringUtils.join(list, (String)", ");
                }
            }
            return this.completeName;
        }

        public void setCommercialName(String commercial) {
            this.setName(commercial);
        }

        public void setGenericName(String generic) {
            this.setBaseName(generic);
        }

        public void setCompleteName(String completeName2) {
            this.completeName = completeName2;
        }

        public CDrugStrength(XDrugStrength x) {
            this.init(x);
        }

        private void init(XDrugStrength x) {
            super.init((IEditableDataObject)x);
            this.id = x.id;
            this.din = x.din;
            this.strength = x.strength;
            this.isDeleted = x.isDeleted;
            this.name = x.name;
            this.baseName = x.baseName;
            this.searchName = x.searchName;
            this.searchBaseName = x.searchBaseName;
            this.ahfs = new LinkedHashSet<String>(x.ahfs);
            this.version = x.getVersion();
            this.modificationStatus = x.getModificationStatus().toString();
        }

        public <T> void convertc(T type) {
            XDrugStrength x = (XDrugStrength)XDrugStrength.class.cast(type);
            this.init(x);
        }

        public XDrugStrength convertx() {
            return this.x();
        }

        public static CDrugStrength c(XDrugStrength x) {
            return x == null ? null : new CDrugStrength(x);
        }

        public XDrugStrength x() {
            XDrugStrength x = new XDrugStrength();
            super.x((EditableDataObject)x);
            x.id = this.id;
            x.din = this.din;
            x.strength = this.strength;
            x.isDeleted = this.isDeleted;
            x.name = this.name;
            x.baseName = this.baseName;
            x.searchName = this.searchName;
            x.searchBaseName = this.searchBaseName;
            x.ahfs = new LinkedHashSet<String>(this.ahfs);
            x.version.plain_set((Object)this.version);
            x.modificationStatus.plain_set((Object)ModificationStatus.from((String)this.modificationStatus));
            return x;
        }
    }
}

