/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.eform.XAttenteResultats;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.ofys.ui.dashboard.models.CAppointment;
import ca.infodata.ofys.ui.dashboard.models.CAttenteResultats;
import ca.infodata.ofys.ui.dashboard.models.CLabelDef;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.CPatientImage;
import ca.infodata.ofys.ui.dashboard.models.CPatientImageProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.DocDescription;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CBasePatientImage
extends DocDescription {
    private static final long serialVersionUID = 1L;
    public String className = CBasePatientImage.class.getSimpleName();
    public Long activityDate;
    public int uid;
    public Integer id;
    public Integer idPatient;
    public String str;
    public XPatientImageResultType result;
    public String date;
    public Long datetimeScanned;
    public List<CPatientImageProfessionnal> profs = new ArrayList<CPatientImageProfessionnal>();
    public List<CLabelDef> labels = new ArrayList<CLabelDef>();
    public String notValidated = null;
    public CPatientImageProfessionnal activeProf;
    public CPatientImageProfessionnal selectedProf;
    public boolean hasNote = false;
    public String allNotes = null;
    public CPatient patient = null;
    public Boolean fromSearch = Boolean.FALSE;
    public List<CAppointment> futurApts;
    public Boolean appTodayOrFutur;
    public Boolean appHasOnlyToday;
    public Boolean appHasOnlyFutur;
    public Boolean appHasTodayAndFutur;
    public List<CAttenteResultats> attentes;

    public CBasePatientImage() {
    }

    public CBasePatientImage(XPatientImage x) {
        super(x);
        this.id = x.id;
        this.uid = Utils.getNewAtomicInteger();
        this.activityDate = x.getDocumentDate() == null ? null : Long.valueOf(x.getDocumentDate().toTimeInMillisUTC());
        this.datetimeScanned = x.datetimeScanned;
        if (x.futurApts != null && !x.futurApts.isEmpty()) {
            this.futurApts = new ArrayList<CAppointment>(x.futurApts.size());
            boolean hasToday = false;
            boolean hasFutur = false;
            for (XAppointment xApt : x.futurApts) {
                CAppointment cApt = new CAppointment(xApt);
                this.futurApts.add(cApt);
                hasToday = hasToday || cApt.when == 0;
                hasFutur = hasFutur || cApt.when > 0;
            }
            this.appTodayOrFutur = hasToday || hasFutur;
            this.appHasOnlyFutur = !hasToday && hasFutur;
            this.appHasOnlyToday = hasToday && !hasFutur;
            this.appHasTodayAndFutur = hasToday && hasFutur;
        }
        if (x.attentes != null && !x.attentes.isEmpty()) {
            this.attentes = new ArrayList<CAttenteResultats>(x.attentes.size());
            for (XAttenteResultats xAtt : x.attentes) {
                CAttenteResultats cAtt = new CAttenteResultats(xAtt);
                this.attentes.add(cAtt);
            }
        }
    }

    public CBasePatientImage(XBasePatientImage x, Integer activeIdProf, Integer selectedIdProf) {
        super(x.str);
        this.activityDate = x.getDocumentDate() == null ? null : Long.valueOf(x.getDocumentDate().toTimeInMillisUTC());
        this.uid = Utils.getNewAtomicInteger();
        this.id = x.id;
        this.idPatient = x.idPatient;
        this.str = x.str;
        this.result = x.result;
        if (x.patient != null) {
            this.patient = CPatient.c(x.patient);
        }
        boolean seen = false;
        if (x.professionnals != null) {
            for (XPatientImageProfessionnal xPIP : x.professionnals) {
                this.hasNote = this.hasNote || StringUtils.isNotEmpty((String)xPIP.getNote());
                CPatientImageProfessionnal cPatientImageProfessionnal = new CPatientImageProfessionnal(xPIP);
                if (xPIP.getProfessionnal() != null) {
                    if (xPIP.getProfessionnal().equals(activeIdProf)) {
                        this.activeProf = cPatientImageProfessionnal;
                    }
                    if (xPIP.getProfessionnal().equals(selectedIdProf)) {
                        this.selectedProf = cPatientImageProfessionnal;
                    }
                }
                this.profs.add(cPatientImageProfessionnal);
                if (seen || !cPatientImageProfessionnal.st.contains(XPatientImageProfessionnalStatus.SEEN)) continue;
                seen = true;
            }
            Collections.sort(this.profs, CPatientImage.compCPtImgProf);
        }
        if (!seen) {
            this.notValidated = XPatientImageProfessionnalStatus.UNSEEN.name();
        }
        if (x.labels != null) {
            for (XLabelDef l : x.labels) {
                this.labels.add(new CLabelDef(l));
            }
        }
        this.date = null == x.documentDate ? null : x.documentDate.formatHyphen();
        this.datetimeScanned = x.dateScanned;
        if (x.futurApts != null && !x.futurApts.isEmpty()) {
            this.futurApts = new ArrayList<CAppointment>(x.futurApts.size());
            boolean hasToday = false;
            boolean hasFutur = false;
            for (XAppointment xApt : x.futurApts) {
                CAppointment cApt = new CAppointment(xApt);
                this.futurApts.add(cApt);
                hasToday = hasToday || cApt.when == 0;
                hasFutur = hasFutur || cApt.when > 0;
            }
            this.appTodayOrFutur = hasToday || hasFutur;
            this.appHasOnlyFutur = !hasToday && hasFutur;
            this.appHasOnlyToday = hasToday && !hasFutur;
            this.appHasTodayAndFutur = hasToday && hasFutur;
        }
        if (x.attentes != null && !x.attentes.isEmpty()) {
            this.attentes = new ArrayList<CAttenteResultats>(x.attentes.size());
            for (XAttenteResultats xAtt : x.attentes) {
                CAttenteResultats cAtt = new CAttenteResultats(xAtt);
                this.attentes.add(cAtt);
            }
        }
    }

    public XBasePatientImage xbase(XBasePatientImage xbase) {
        if (xbase == null) {
            xbase = new XBasePatientImage();
        }
        xbase.id = this.id;
        xbase.idPatient = this.idPatient;
        xbase.patient = this.patient.x();
        xbase.str = this.str;
        xbase.result = this.result;
        xbase.documentDate = Utils.strToLocalDate(this.date);
        xbase.dateScanned = this.datetimeScanned;
        xbase.labels = CLabelDef.CLablelToXList(this.labels);
        xbase.professionnals = CPatientImageProfessionnal.CtoXList(this.profs);
        return xbase;
    }

    public <T> void convertc(T type) {
        XPatientImage x = (XPatientImage)XPatientImage.class.cast(type);
        this.init((IEditableDataObject)x);
    }

    public Object convertx() {
        return this.xbase(null);
    }
}

