/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.accessor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XObjectContainer;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecallSearchCriteria;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XSearchPeriodCriteria;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientHaveAppRecall;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.dashboard.accessor.AbstractDashboardAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CAppointment;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppointmentSyncAccessorClient
extends AbstractDashboardAccessorClient {
    private static final Logger logger = Logger.getLogger(AppointmentSyncAccessorClient.class.getName());

    public List<XAppointment> findFutureAppointmentsByPatient(int patientId) {
        String sortBy = null;
        Integer limit = 25;
        ReturnObject response = Application.get().getDataAccessors().getAppointmentAccessor().findFutureAppointmentsByPatient(patientId, sortBy, limit);
        return (List)response.getObj();
    }

    public XPatientHaveAppRecall countPatientRecallAndFutureAppointment(int idPatient) {
        ReturnObject response = Application.get().getDataAccessors().getAppointmentAccessor().countPatientRecallAndFutureAppointment(idPatient);
        return (XPatientHaveAppRecall)response.getObj();
    }

    public List<XAppointment> findFutureFamillyAppointmentsByPatient(int patientId) {
        String sortBy = null;
        ReturnObject response = Application.get().getDataAccessors().getAppointmentAccessor().findFutureFamillyAppointmentsByPatient(patientId, sortBy);
        return (List)response.getObj();
    }

    public List<XAppointment> findPastAppointmentsByPatient(int patientId) {
        String sortBy = null;
        Integer limit = 25;
        ReturnObject response = Application.get().getDataAccessors().getAppointmentAccessor().findPastAppointmentsByPatient(patientId, sortBy, limit);
        return (List)response.getObj();
    }

    public ReturnObject findPeriod(XSearchPeriodCriteria criteria) {
        ReturnObject response = Application.get().getDataAccessors().getAppointmentAccessor().findAvailableAppointmentSpaces(criteria);
        return response;
    }

    public ReturnObject saveAppointment(ArrayList<XAppointment> appointments) {
        for (XAppointment app : appointments) {
            if (app.getTag() != null) continue;
            app.setTag();
        }
        ReturnObject response = Application.get().getDataAccessors().getAppointmentAccessor().save(appointments, false);
        XObjectContainer res = (XObjectContainer)response.getObj();
        ArrayList<CAppointment> responseAppointments = new ArrayList<CAppointment>();
        IEditableDataObjectList apps = res.getObjects();
        for (IMinimalEditableDataObject app : apps) {
            XAppointment a = (XAppointment)app;
            responseAppointments.add(new CAppointment(a));
        }
        response.setObj(responseAppointments);
        return response;
    }

    public List<XPatientRecall> findPatientRecall(XPatientRecallSearchCriteria criteria) {
        ReturnObject response = Application.get().getDataAccessors().getAppointmentAccessor().findPatientRecall(criteria);
        return (List)response.getObj();
    }

    public IStatus setPatientStatus(int appointmentId, XPatientStatus status) {
        ReturnObject response = null;
        try {
            if (status == null) {
                throw new Exception("invalid patient status " + status);
            }
            response = Application.get().getDataAccessors().getAppointmentAccessor().setPatientStatus(appointmentId, status);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to set setPatientStatus. ", e);
        }
        return response == null ? null : response.getStatus();
    }

    public IStatus setAppointmentStatus(int appointmentId, XAppointmentStatus status) {
        ReturnObject response = null;
        try {
            if (status == null) {
                throw new Exception("invalid patient status " + status);
            }
            response = Application.get().getDataAccessors().getAppointmentAccessor().setAppointmentStatus(appointmentId, status);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to set setPatientStatus. ", e);
        }
        return response == null ? null : response.getStatus();
    }

    public List<XAppointment> getAllAppointmentsByPatient(int patientId) {
        ReturnObject response = Application.get().getDataAccessors().getAppointmentAccessor().findAllAppointmentsByPatient(patientId);
        return (List)response.getObj();
    }

    public ReturnObject save(Serializable obj) {
        ReturnObject response = Application.get().getDataAccessors().getAppointmentAccessor().save(obj, false);
        return response;
    }

    public List<XAppointment> findAppointmentsByProfessional(int idProf, LocalDate date) {
        ReturnObject response = Application.get().getDataAccessors().getAppointmentAccessor().findAppointmentsByProfessional(idProf, date);
        List list = (List)response.getObj();
        Application.get().getGlobalInstances().getNotificationSystem().addProfIdForApptNotification(idProf);
        return list;
    }

    public ReturnObject suppressFuturApp(int idPatient) {
        ReturnObject response = Application.get().getDataAccessors().getAppointmentAccessor().suppressPatientRecallAndFutureAppointment(idPatient);
        return response;
    }
}

