/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.protocol.HttpContext;

public class RestfulClientHttpResquestRetryHandler
implements HttpRequestRetryHandler {
    private final int retryCount;
    private final long defaultRetryInterval;
    private final TimeUnit defaultRetryIntervalUnit;
    private final List<Class<? extends IOException>> nonRetriableClasses;

    public RestfulClientHttpResquestRetryHandler(int maxRetries, long retryInterval, TimeUnit retryIntervalUnit) {
        this.retryCount = maxRetries;
        this.defaultRetryInterval = retryInterval;
        this.defaultRetryIntervalUnit = retryIntervalUnit;
        this.nonRetriableClasses = Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class);
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        if (executionCount > this.retryCount) {
            return false;
        }
        if (this.nonRetriableClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        if (this.requestIsAborted(request)) {
            return false;
        }
        if (this.handleAsIdempotent(request)) {
            return this.waitAndReturnTrue();
        }
        if (!clientContext.isRequestSent()) {
            return this.waitAndReturnTrue();
        }
        if (exception instanceof NoHttpResponseException) {
            return this.waitAndReturnTrue();
        }
        String method = request.getRequestLine().getMethod().toUpperCase(Locale.ROOT);
        if ("POST".equals(method) && request.getFirstHeader("disableStandardRetry") == null) {
            return this.waitAndReturnTrue();
        }
        return false;
    }

    private boolean waitAndReturnTrue() {
        try {
            this.defaultRetryIntervalUnit.sleep(this.defaultRetryInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private boolean handleAsIdempotent(HttpRequest request) {
        return !(request instanceof HttpEntityEnclosingRequest);
    }

    private boolean requestIsAborted(HttpRequest request) {
        HttpRequest req = request;
        if (request instanceof RequestWrapper) {
            req = ((RequestWrapper)request).getOriginal();
        }
        return req instanceof HttpUriRequest && ((HttpUriRequest)req).isAborted();
    }
}

