/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.core.routes;

import ca.infodata.ofys.client.web.core.routes.RequestPredicate;
import ca.infodata.ofys.client.web.core.routes.ServerRequestContext;

public class PathPredicate
implements RequestPredicate {
    private final String path;
    private final PathStrategy strategy;

    public PathPredicate() {
        this.path = null;
        this.strategy = PathStrategy.EXACT;
    }

    public PathPredicate(String path, PathStrategy strategy) {
        this.path = path;
        this.strategy = strategy;
    }

    @Override
    public boolean test(ServerRequestContext request) {
        Integer offset;
        boolean test = true;
        if (this.path != null && (test = this.match(request, offset = (Integer)request.state().get("pathStartWithOffset")))) {
            offset = offset == null ? Integer.valueOf(this.path.length()) : Integer.valueOf(offset + this.path.length());
            request.state().put("pathStartWithOffset", offset);
        }
        return test;
    }

    private boolean match(ServerRequestContext request, Integer offset) {
        switch (this.strategy) {
            case EXACT: {
                return this.matchExact(request, offset);
            }
            case START_WITH: {
                return this.matchStartWith(request, offset);
            }
        }
        throw new IllegalStateException("unsupported match strategy " + (Object)((Object)this.strategy));
    }

    private boolean matchExact(ServerRequestContext request, Integer offset) {
        String requestPath = request.getPath();
        if (offset == null) {
            return requestPath.equals(this.path);
        }
        return requestPath.startsWith(this.path, offset) && requestPath.endsWith(this.path);
    }

    private boolean matchStartWith(ServerRequestContext request, Integer offset) {
        if (offset == null) {
            return request.getPath().startsWith(this.path);
        }
        return request.getPath().startsWith(this.path, offset);
    }

    public static enum PathStrategy {
        START_WITH,
        EXACT;

    }
}

