/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.core;

import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.IWebSocketFilter;
import java.util.stream.Stream;

public class WebSocketFilterByRequest
implements IWebSocketFilter {
    private IWebSocketChannel channel;
    private String sessionId;

    public WebSocketFilterByRequest(IServerRequest request) {
        if (request.getWebSocketRequest() != null) {
            this.channel = request.getWebSocketRequest().getChannel();
        } else {
            this.sessionId = request.getHttpSessionId();
        }
    }

    @Override
    public Stream<? extends IWebSocketChannel> apply(Stream<? extends IWebSocketChannel> stream) {
        if (this.channel != null) {
            return stream.filter(c -> c == this.channel);
        }
        if (this.sessionId != null) {
            return stream.filter(c -> this.sessionId.equals(c.getHttpSessionId()));
        }
        return stream.filter(c -> false);
    }
}

