/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.controller.PatientController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.chat.LINK_TYPE;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.task.XTask;
import ca.infodata.ofys.data.middle.dataobjects.task.XTaskCriteria;
import ca.infodata.ofys.ui.dashboard.accessor.CommonSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.accessor.TaskSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CTask;
import java.util.ArrayList;
import java.util.List;

public class TaskController
extends AbstractWebController {
    private final TaskSyncAccessorClient accessor;
    private final CommonSyncAccessorClient commonAccessor;
    private final TaskController taskController;
    private final PatientController patientController;

    protected static int compPriority(CTask o1, CTask o2) {
        int p1 = o1.priority.value;
        int p2 = o2.priority.value;
        if (p1 == p2) {
            return o1.createDatetime.compareTo(o2.createDatetime);
        }
        return p1 > p2 ? -1 : 1;
    }

    public TaskController(TaskController taskController, PatientController patientController) {
        this.taskController = taskController;
        this.patientController = patientController;
        this.commonAccessor = new CommonSyncAccessorClient();
        this.accessor = new TaskSyncAccessorClient();
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNotification);
    }

    private void handleNotification(DataObjectUpdatedNotification notification) throws Exception {
        IDataObject object = notification.getObject();
        if (object instanceof XTask) {
            CTask jMsg = new CTask((XTask)object);
            ServerResponses.sendJsonToClient(notification.getClientId(), "task.update", (Object)jMsg);
        }
    }

    public List<CTask> ToCTask(List<XTask> tasks) {
        ArrayList<CTask> res = new ArrayList<CTask>();
        if (tasks != null) {
            for (XTask obj : tasks) {
                if (obj == null) continue;
                res.add(new CTask(obj));
            }
        }
        return res;
    }

    public XTask getTaskById(int id) {
        return this.accessor.getById(id);
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/tasks/ws", RouterFunctions.route("/find", this::handleFind, ActionResult.class), RouterFunctions.route("/findIds", this::handleFindIds, ActionResult.class), RouterFunctions.route("/list/bypat", this::handleListByPat, ActionResult.class), RouterFunctions.route("/byIds", this::handleListByIds, ActionResult.class), RouterFunctions.route("/openTask", this::handleOpenTask, ActionResult.class), RouterFunctions.route("/modifEntry", this::handleModif, ActionResult.class), RouterFunctions.route("/save", this::handleSave, ActionResult.class));
    }

    private ActionResult handleSave(IServerRequest req) {
        CTask taskToSave = req.getPostBody(CTask.class);
        return ServerResponses.toJsonActionResult(this.createTask(taskToSave));
    }

    private ActionResult handleModif(IServerRequest req) {
        Integer id = req.getRequiredQueryParam("id", Integer.class);
        ServerResponses.toJsonActionResult(this.commonAccessor.findModificationEntries("task", id));
        return ServerResponses.SUCCESS();
    }

    private ActionResult handleOpenTask(IServerRequest req) {
        Integer id = req.getRequiredQueryParam("id", Integer.class);
        Application.get().getApplicationUiPlugin().openTask(id == null ? null : this.getTaskById(id), this.getMessageLinkFromParams(req));
        return ServerResponses.SUCCESS();
    }

    private ActionResult handleListByIds(IServerRequest req) {
        Integer[] ids = req.getRequiredQueryParam("ids", Integer[].class);
        return ServerResponses.toJsonActionResult(this.ToCTask(this.accessor.byIds(ids, Boolean.TRUE)));
    }

    private ActionResult handleListByPat(IServerRequest req) {
        Integer idPat = req.getRequiredQueryParam("id", Integer.class);
        return ServerResponses.toJsonActionResult(this.ToCTask(this.accessor.taskListByPatient(idPat)));
    }

    private ActionResult handleFindIds(IServerRequest req) {
        XTaskCriteria data = req.getPostBody(XTaskCriteria.class);
        return ServerResponses.toJsonActionResult(this.accessor.findIds(data));
    }

    private ActionResult handleFind(IServerRequest req) {
        XTaskCriteria data = req.getPostBody(XTaskCriteria.class);
        return ServerResponses.toJsonActionResult(this.ToCTask(this.accessor.find(data)));
    }

    public ReturnObject createTask(CTask taskToSave) {
        XTask xtask = taskToSave.x();
        xtask.setModificationStatus(ModificationStatus.STATUS_UPDATED);
        ReturnObject res = this.accessor.save(xtask);
        res.setObj((Object)new CTask((XTask)res.getObj()));
        return res;
    }

    public MessageLink getMessageLinkFromParams(IServerRequest req) {
        MessageLink ml = null;
        Integer linkId = req.getQueryParam("linkId", Integer.class);
        LINK_TYPE linkType = req.getQueryParam("linkType", LINK_TYPE.S_O, LINK_TYPE.class);
        Integer linkPatient = req.getQueryParam("linkPatient", Integer.class);
        if (linkPatient != null) {
            XPatient pt = Application.get().getPersonPluginController().getCurrentPatient();
            if (pt == null || !pt.getId().equals(linkPatient)) {
                pt = this.patientController.getPatient(linkPatient);
            }
            ml = pt != null ? new MessageLink((IPatient)pt, linkType, linkId) : null;
        }
        return ml;
    }
}

