/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IPrintController;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XReportContainer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReportCategory;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.ui.dashboard.accessor.ReportSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CFinishedReportQuery;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.CReportContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public class ReportController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(ReportController.class.getName());
    private final ReportSyncAccessorClient reportAccessor = new ReportSyncAccessorClient();

    public ReportController() {
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNotification);
    }

    private void handleNotification(DataObjectUpdatedNotification notification) throws Exception {
        IDataObject object = notification.getObject();
        if (object instanceof XPatient) {
            CPatient jMsg = new CPatient((XPatient)notification.getObject());
            ServerResponses.sendJsonToClient(notification.getClientId(), "patient.update", (Object)jMsg);
        }
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard", RouterFunctions.routes("/print/ws", RouterFunctions.routeAction("/getReports", req -> {
            CFinishedReportQuery query = req.getPostBody(CFinishedReportQuery.class);
            return ServerResponses.toJsonActionResult(this.getAvailableReports(query));
        }), RouterFunctions.routeReturnObject("/print", req -> {
            CFinishedReportQuery query = req.getPostBody(CFinishedReportQuery.class);
            return this.print(query, req.getBrowser());
        })));
    }

    public Collection<? extends CReportContainer> getAvailableReports(CFinishedReportQuery query) {
        XReportContainer container = this.reportAccessor.getReport(query.getDataObject(), null);
        ArrayList<CReportContainer> cContainer = new ArrayList<CReportContainer>();
        for (IReportCategory report : container.getCategories()) {
            cContainer.add(new CReportContainer(report));
        }
        return cContainer;
    }

    public ReturnObject print(CFinishedReportQuery query, IServerRequest.Browser browser) {
        IPrintController ctrl = Application.get().getPrintControllerFactory().newPrintController(query.getDataObject());
        ctrl.getSelection().add((IReport)query.getIReport());
        return ServerResponses.print(ctrl, browser);
    }
}

