/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.base64.Base64DecodedString;
import ca.infodata.ofys.client.modules.person.IPersonPluginController;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XWebSearchProvince;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.dashboard.accessor.ProfessionnalSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CBaseProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CProfessional;
import ca.infodata.util1.encryption.DesEncrypter;
import ca.infodata.util1.encryption.EncryptionException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class ProfessionalController
extends AbstractWebController {
    private ProfessionnalSyncAccessorClient profAccessor = new ProfessionnalSyncAccessorClient();
    private static final Logger logger = Logger.getLogger(ProfessionalController.class.getName());

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/Prof/ws", RouterFunctions.routeAction("/profs", req -> ServerResponses.toJsonActionResult(this.getProfessionals())), RouterFunctions.routeAction("/findBaseProfById", req -> {
            Integer id = req.getRequiredQueryParam("id", Integer.class);
            CBaseProfessionnal res = this.findBaseProfById(id);
            return ServerResponses.toJsonActionResult(res);
        }), RouterFunctions.routeAction("/findProfById", req -> {
            Integer id = req.getRequiredQueryParam("id", Integer.class);
            CProfessional res = this.findProfById(id);
            return ServerResponses.toJsonActionResult((Object)res);
        }), RouterFunctions.routeAction("/getNbPatientToReplaceProv", req -> {
            Integer from = req.getRequiredQueryParam("from", Integer.class);
            return ServerResponses.toJsonActionResult(this.getNbPatientToReplaceProv(from));
        }), RouterFunctions.routeAction("/doPatientToReplaceProv", req -> {
            Integer from = req.getRequiredQueryParam("from", Integer.class);
            Integer to = req.getRequiredQueryParam("to", Integer.class);
            return ServerResponses.toJsonActionResult(this.doPatientToReplaceProv(from, to));
        }), RouterFunctions.routeAction("/search", req -> {
            ProfessionalSearch q = req.getPostBody(ProfessionalSearch.class);
            List<CBaseProfessionnal> res = this.findProf(q);
            return ServerResponses.toJsonActionResult(res);
        }), RouterFunctions.routeAction("/create", req -> {
            CBaseProfessionnal prof = req.getPostBody(CBaseProfessionnal.class);
            return ServerResponses.toJsonActionResult(this.create(prof));
        }), RouterFunctions.routeAction("/save", req -> {
            Boolean question = req.getRequiredQueryParam("question", Boolean.class);
            CProfessional prof = req.getPostBody(CProfessional.class);
            return ServerResponses.toJsonActionResult(this.save(prof, question));
        }), RouterFunctions.routeAction("/prof/typesinuse", req -> ServerResponses.toJsonActionResult(this.profAccessor.findProfessionnalTypeInUse())));
    }

    private ReturnObject doPatientToReplaceProv(Integer from, Integer to) {
        return this.profAccessor.doPatientToReplaceProv(from, to);
    }

    private ReturnObject getNbPatientToReplaceProv(Integer from) {
        return this.profAccessor.getNbPatientToReplaceProv(from);
    }

    public ReturnObject create(CBaseProfessionnal cprof) {
        XBaseProfessionnal baseProf = cprof.xbase(new XBaseProfessionnal());
        XProfessionnal prof = new XProfessionnal();
        prof.setNew();
        prof.initialize();
        prof.setFirstName(baseProf.getFirstName());
        prof.setLastName(baseProf.getLastName());
        prof.setCode(baseProf.getCode());
        prof.setIsProfTx(false);
        prof.setIsSetSeenManual(false);
        prof.setUseAppointment(false);
        prof.setProfessionnalType(baseProf.getProfessionalType());
        prof.setRxvLicence(baseProf.getRxvLicence());
        prof.setSpeciality(baseProf.getSpeciality());
        ReturnObject response = this.profAccessor.save((IDataObject)prof, false);
        if (response.getStatus().isOkToProceed()) {
            XProfessionnal saved = (XProfessionnal)response.getObj();
            response.setObj((Object)new CBaseProfessionnal(new XBaseProfessionnal(saved)));
        }
        return response;
    }

    public ReturnObject save(CProfessional prof, Boolean question) {
        XProfessionnal xprof;
        ReturnObject answer;
        XProfessionnal[] res;
        if (prof.user != null && prof.user.changePassword) {
            try {
                prof.user.encryptedPassword = DesEncrypter.encryptMe((String)new Base64DecodedString(prof.user.newPassword).getDecoded());
                prof.user.encryptedPasswordConfirm = DesEncrypter.encryptMe((String)new Base64DecodedString(prof.user.newPasswordConfirm).getDecoded());
                prof.user.mustChangePassword = true;
            }
            catch (EncryptionException e) {
                logger.log(Level.SEVERE, "password encryption error", e);
                return ServerResponses.ErrorReturnObject("Erreur de sauvegarde du professionel, format du mot de pass invalide");
            }
        }
        if ((res = (answer = this.profAccessor.save((IDataObject)(xprof = prof.x()), question)).getObj() instanceof XProfessionnal ? new XProfessionnal[]{(XProfessionnal)answer.getObj()} : (XProfessionnal[])answer.getObj()) != null) {
            ArrayList<CProfessional> retour = new ArrayList<CProfessional>();
            for (XProfessionnal i : res) {
                retour.add(new CProfessional(i));
            }
            answer.setObj(retour);
        }
        return answer;
    }

    public List<CBaseProfessionnal> findProf(ProfessionalSearch s) {
        return CBaseProfessionnal.XBaseProffessionalListToC(this.profAccessor.findProfessional(s.text, s.type, s.isWebSearch, s.isActive, s.returnOneOrNone, s.webProvince));
    }

    public CBaseProfessionnal findBaseProfById(Integer id) {
        return new CBaseProfessionnal(this.profAccessor.getBaseById(id));
    }

    public CProfessional findProfById(Integer id) {
        return new CProfessional(this.profAccessor.getById(id));
    }

    protected List<CBaseProfessionnal> getProfessionals() {
        IPersonPluginController personPluginController = Application.get().getPersonPluginController();
        ArrayList<CBaseProfessionnal> clist = new ArrayList<CBaseProfessionnal>(50);
        Stream<XBaseProfessionnal> lstProfessional = personPluginController.getTreatingProfessionnals().sorted();
        lstProfessional.forEachOrdered(e -> clist.add(new CBaseProfessionnal((XBaseProfessionnal)e)));
        Stream<XPersonGroup> lstGroup = personPluginController.getActivePersonGroups().sorted();
        lstGroup.forEachOrdered(xg -> {
            boolean allUsesAppt = true;
            for (Integer idPerson : xg.getPersons()) {
                XBaseProfessionnal prof = personPluginController.getBaseProfessionnalByIdPerson(idPerson, false, false);
                if (prof != null && prof.useAppointment) continue;
                allUsesAppt = false;
                break;
            }
            if (allUsesAppt) {
                XBaseProfessionnal x = new XBaseProfessionnal();
                x.setId(Integer.valueOf(-xg.getId().intValue()));
                x.setLastName("\u4e00GRP");
                x.setFirstName(xg.getName());
                x.useAppointment = true;
                x.str = "Groupe de prof.";
                CBaseProfessionnal c = new CBaseProfessionnal(x);
                clist.add(c);
            }
        });
        return clist;
    }

    public class ProfessionalSearch {
        public String text;
        public Integer type;
        public boolean isWebSearch;
        public boolean returnOneOrNone;
        public boolean isActive = true;
        public XWebSearchProvince webProvince;
    }
}

