/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IPrintController;
import ca.infodata.ofys.client.modules.eform.EFormPrepare;
import ca.infodata.ofys.client.modules.eform.EformController;
import ca.infodata.ofys.client.util.ExceptionUtils;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.controller.PatientController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.JsonAsMap;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.dataaccess.client.CnesstAccessorClient;
import ca.infodata.ofys.data.dataaccess.client.EFormAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.LightweightReport;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.ReportProperties;
import ca.infodata.ofys.data.middle.dataobjects.XFinishedDocument;
import ca.infodata.ofys.data.middle.dataobjects.XFinishedReport;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.eform.XAttenteResultats;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.properties.IReportProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.FaxData;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.FaxDataProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.OutputProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrintMode;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.dashboard.models.CAttenteResultats;
import ca.infodata.ofys.ui.dashboard.models.CForm;
import ca.infodata.ofys.ui.dashboard.models.CFormData;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.Pair;
import ca.infodata.util1.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(FormController.class.getName());
    private final EformController controller = new EformController();
    private final CnesstAccessorClient cnesstSyncAccessorClient;
    private final EFormAccessorClient eFormAccessorClient;
    private final PatientController patientController;

    public FormController(PatientController patientController) {
        this.patientController = patientController;
        this.cnesstSyncAccessorClient = new CnesstAccessorClient();
        this.eFormAccessorClient = new EFormAccessorClient();
    }

    private XEformData prepareForDashboard(XEformData data) {
        XEform eform = (XEform)data.getForm();
        String html = eform.getHtml();
        html = EFormPrepare.injectAdditionalHtml(html);
        html = this.injectDashboardAdditionalHtml(html);
        html = html.replace(":formDataId", String.valueOf(data.getId()));
        eform.setHtml(html);
        return data;
    }

    private String injectDashboardAdditionalHtml(String html) {
        String s1 = "<script type=\"text/javascript\" src=\"/dashboard/resources/ofys/eform/eformInject.js\"></script>\n";
        s1 = s1 + "<style type=\"text/css\">body{margin:0px} @media print {body {-webkit-print-color-adjust: exact;margin: 6.35mm 6.35mm 6.35mm 6.35mm;}}</style>\n";
        String addition = "<input type=\"hidden\" id=\"formDataId\" name=\"formDataId\" value=\":formDataId\" />";
        Pattern pattern2 = Pattern.compile("(.*)(</.?[fF][oO][rR][Mm].?>.*)", 32);
        Matcher matcher2 = pattern2.matcher(html);
        if (matcher2.find()) {
            String start = matcher2.group(1);
            String close = matcher2.group(2);
            if (!StringUtils.isBlank((CharSequence)start) && !StringUtils.isBlank((CharSequence)close)) {
                StringBuilder sb = new StringBuilder();
                sb.append(start);
                sb.append(close);
                html = sb.toString();
            }
        }
        return EFormPrepare.injectBeforeClosingBody(html, s1);
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/forms/ws", RouterFunctions.route("/getformhtml", req -> {
            Integer idEformData = req.getRequiredQueryParam("idEformData", Integer.class);
            return ServerResponses.toJsonActionResult(this.getformhtml(idEformData));
        }, ActionResult.class), RouterFunctions.routeAction("/get", req -> {
            Integer idEformData = req.getRequiredQueryParam("id", Integer.class);
            return ServerResponses.toJsonActionResult(this.get(idEformData));
        }), RouterFunctions.routeAction("/byIdAnchors", req -> {
            Boolean revision = req.getQueryParam("revision", Boolean.class);
            Integer[] ids = req.getRequiredQueryParam("ids", Integer[].class);
            return ServerResponses.toJsonActionResult(this.dataByIdAnchors(ids, Boolean.TRUE.equals(revision)));
        }), RouterFunctions.routeAction("/getFormHtmlForCrds", req -> {
            Integer formId = req.getRequiredQueryParam("formId", Integer.class);
            Integer formDataId = req.getQueryParam("formDataId", Integer.class);
            return ServerResponses.toJsonActionResult(this.getFormHtmlForCrds(formId, formDataId));
        }), RouterFunctions.routeAction("/addToFavorites", req -> {
            Integer eformId = req.getRequiredQueryParam("formId", Integer.class);
            return ServerResponses.toJsonActionResult(this.addToFavorites(eformId));
        }), RouterFunctions.routeAction("/removeFavorite", req -> {
            Integer eformId = req.getRequiredQueryParam("formId", Integer.class);
            return ServerResponses.toJsonActionResult(this.removeFavorite(eformId));
        }), RouterFunctions.routeAction("/new", req -> {
            Integer patientId = req.getQueryParam("patientId", Integer.class);
            Integer formId = req.getRequiredQueryParam("formId", Integer.class);
            return ServerResponses.toJsonActionResult(this.newformData(patientId, formId));
        }), RouterFunctions.routeAction("/copy", req -> {
            Integer patientId = req.getRequiredQueryParam("patientId", Integer.class);
            Integer formDataId = req.getRequiredQueryParam("formDataId", Integer.class);
            return ServerResponses.toJsonActionResult(this.copy(patientId, formDataId));
        }), RouterFunctions.routeAction("/autoFill", req -> {
            FormAutoFill arg = req.getPostBody(FormAutoFill.class);
            return ServerResponses.toJsonActionResult(this.autoFill(arg));
        }), RouterFunctions.routeAction("/save", req -> {
            FormDataSave payload = req.getPostBody(FormDataSave.class);
            return ServerResponses.toJsonActionResult(this.save(payload));
        }), RouterFunctions.routeAction("/saveAttenteResultats", req -> {
            CAttenteResultats payload = req.getPostBody(CAttenteResultats.class);
            return ServerResponses.toJsonActionResult(this.save(payload));
        }), RouterFunctions.routeAction("/delAttenteResultats", req -> {
            Integer formDataId = req.getPostBody(JsonAsMap.class).getRequired("id", Integer.class);
            return ServerResponses.toJsonActionResult(this.delAttenteResultats(formDataId));
        }), RouterFunctions.routeAction("/getCnesstDV", req -> ServerResponses.toJsonActionResult(this.getDomainValues())), RouterFunctions.routeAction("/toCnesst", req -> {
            Integer idEformData = req.getQueryParam("eformDataId", Integer.class);
            return ServerResponses.toJsonActionResult(this.sendDataToCnesst(idEformData));
        }), RouterFunctions.routeAction("/delete", req -> {
            Integer formDataId = req.getPostBody(JsonAsMap.class).getRequired("formDataId", Integer.class);
            return ServerResponses.toJsonActionResult(this.delete(formDataId));
        }), RouterFunctions.routeAction("/undelete", req -> {
            Integer formDataId = req.getPostBody(JsonAsMap.class).getRequired("formDataId", Integer.class);
            return ServerResponses.toJsonActionResult(this.unDelete(formDataId));
        }), RouterFunctions.routeAction("/cancel", req -> {
            Integer preSavedTag = req.getQueryParam("preSavedTag", Integer.class);
            return ServerResponses.toJsonActionResult(this.cancel(preSavedTag));
        }), RouterFunctions.routeAction("/loadPreSaved", req -> {
            Integer preSavedTag = req.getPostBody(JsonAsMap.class).getRequired("preSavedTag", Integer.class);
            return ServerResponses.toJsonActionResult(this.loadPreSaved(preSavedTag));
        }), RouterFunctions.routeAction("/patientFormData", req -> {
            Integer patientId = req.getRequiredQueryParam("patientId", Integer.class);
            return ServerResponses.toJsonActionResult(this.patientFormData(patientId));
        }), RouterFunctions.routeAction("/userFormData", req -> {
            Integer idPerson = req.getRequiredQueryParam("idPerson", Integer.class);
            return ServerResponses.toJsonActionResult(this.userFormData(idPerson));
        }), RouterFunctions.routeAction("/availablesList", req -> ServerResponses.toJsonActionResult(this.availableList())), RouterFunctions.routeAction("/favoritesList", req -> ServerResponses.toJsonActionResult(this.favoriteList())), RouterFunctions.routeAction("/print", req -> {
            Integer formDataId = req.getRequiredQueryParam("formDataId", Integer.class);
            Integer idPat = req.getRequiredQueryParam("idPatient", Integer.class);
            return ServerResponses.toJsonActionResult(this.print(formDataId, idPat));
        }), RouterFunctions.routeAction("/printWithLinks", req -> {
            Integer formDataId = req.getRequiredQueryParam("formDataId", Integer.class);
            Integer idPat = req.getRequiredQueryParam("idPatient", Integer.class);
            return ServerResponses.toJsonActionResult(this.printWithLinks(formDataId, idPat));
        }), RouterFunctions.routeAction("/fax", req -> {
            FormFaxPrint faxPrint = req.getPostBody(FormFaxPrint.class);
            return ServerResponses.toJsonActionResult(this.fax(faxPrint));
        }), RouterFunctions.routeAction("/faxWithLinks", req -> {
            FormFaxPrint faxPrint = req.getPostBody(FormFaxPrint.class);
            return ServerResponses.toJsonActionResult(this.faxWithLinks(faxPrint));
        }));
    }

    public ActionResult getformhtml(Integer idEformData) {
        try {
            ActionResult res = new ActionResult("form" + idEformData);
            XEformData data = this.controller.getFormData(idEformData, true);
            data = this.prepareForDashboard(data);
            CFormData c = new CFormData(data, data.getForm());
            res.setSkin(c.form.html.replaceAll("../tools", "/tools"));
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object delete(Integer formDataId) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            this.controller.deleteFormData(formDataId);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to delete eform data. formDataId=" + formDataId, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage("Erreur lors de l'effacement du formulaire: " + ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private Object unDelete(Integer formDataId) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            if (!this.controller.unDeleteFormData(formDataId)) {
                ms.setSeverity(IStatus.Severity.ERROR);
                ms.setMessage("Erreur lors de la r\u00e9activation du formulaire");
            }
            ro.setStatus(ms);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to reactivate eform data. formDataId=" + formDataId, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage("Erreur lors de la r\u00e9activation du formulaire: " + ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject getFormHtmlForCrds(Integer formId, Integer formDataId) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            XEform form = new EformController().getFullEForm(formId, formDataId);
            XEformData data = new XEformData();
            data.setEform((XBaseEform)form);
            data.setId(formDataId);
            data = this.prepareForDashboard(data);
            ro.setObj((Object)form.getHtml());
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to load eform data. formId=" + formId + ", formDataId=" + formDataId, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject get(Integer idEformData) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            XEformData data = this.controller.getFormData(idEformData, true);
            data = this.prepareForDashboard(data);
            CFormData c = new CFormData(data, data.getForm());
            if (c.data != null) {
                c.data = c.data.replaceAll("~~~", "=");
            }
            ro.setObj((Object)c);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to load eform data. idEformData=" + idEformData, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject dataByIdAnchors(Integer[] ids, Boolean revision) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            if (ids != null && ids.length > 0) {
                List<XBaseEformData> list = this.controller.dataByIdAnchors(ids, true, revision);
                ArrayList<CFormData> clist = new ArrayList<CFormData>(list.size());
                for (XBaseEformData x : list) {
                    clist.add(new CFormData(x, x.getForm()));
                }
                ro.setObj(clist);
            }
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to load eform data by ids. ids=" + ids, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject addToFavorites(Integer eformId) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            boolean o = this.controller.addToFavorites(eformId);
            ro.setObj((Object)o);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add eform to favorite. formId=" + eformId, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    public ReturnObject removeFavorite(Integer eformId) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            boolean o = this.controller.removeFromFavorites(eformId);
            ro.setObj((Object)o);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to remvoe eform from favorite. formId=" + eformId, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject newformData(Integer patientId, Integer formId) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            XEformData data = this.controller.newFormData(formId, patientId);
            data = this.prepareForDashboard(data);
            CFormData o = new CFormData(data, data.getForm());
            ro.setObj((Object)o);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to create new form data. patientId=" + patientId + ", formId=" + formId, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    public ReturnObject copy(Integer patientId, Integer formDataId) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            XEformData res = this.controller.newFormDataCopy(formDataId, patientId);
            res = this.prepareForDashboard(res);
            CFormData o = new CFormData(res, res.getForm());
            ro.setObj((Object)o);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to create copy form data. formDataId=" + formDataId + ", patientId=" + patientId, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject autoFill(FormAutoFill arg) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            CFormData data = arg.formData;
            Boolean readonly = arg.readonly;
            Object[] in = arg.inputs;
            String errorMessge = StringUtils.safeToString((Logger)logger, (Object)(data == null || data.form == null ? "FormNameNull" : data.form.name));
            Map<String, Object> inputs = this.controller.mapFormInputs(in, errorMessge);
            XPatient patient = null;
            if (data.patient != null) {
                patient = data.patient.x();
            } else if (data.idPatient != null) {
                patient = this.patientController.getPatient(data.idPatient);
            }
            EFormPrepare config = new EFormPrepare(patient);
            config.edata = data.toXEformData();
            config.inputs = inputs;
            config.readonly = readonly;
            config.doPropertyAndSavedStatusSetup();
            ro.setObj((Object)config);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to autoFill eform data. ", e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject cancel(Integer preSavedTag) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        if (preSavedTag != null) {
            Application.get().getPreSaveController().removeByTag("XFORM", preSavedTag);
        }
        ms.setSeverity(IStatus.Severity.OK);
        ro.setStatus(ms);
        return ro;
    }

    private ReturnObject getDomainValues() {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            Map<String, String> dv = this.cnesstSyncAccessorClient.getDomainValues();
            ms.setSeverity(IStatus.Severity.OK);
            ms.setMessage("");
            ro.setStatus(ms);
            ro.setObj(dv);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to getDomainValues", e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage("Erreur lors de getDomainValues " + ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject sendDataToCnesst(Integer idEformData) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        if (idEformData == null) {
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage("eformDataId est null");
            ro.setStatus(ms);
        } else {
            try {
                Pair<XEformData, MultiStatus> response = this.cnesstSyncAccessorClient.sendEformData(idEformData);
                if (!((MultiStatus)response.second).isOK()) {
                    ms.setMessage(((MultiStatus)response.second).getMessage());
                    ms.setSeverity(((MultiStatus)response.second).getSeverity());
                }
                ro.setStatus(ms);
                ro.setObj(response.first);
            }
            catch (StatusException e) {
                ms.setSeverity(IStatus.Severity.ERROR);
                String message = e.getStatus().getMessage();
                if (e.getStatus() instanceof MultiStatus) {
                    MultiStatus multiStatus = (MultiStatus)e.getStatus();
                    for (IStatus st : multiStatus.getChildren()) {
                        if (message.indexOf(st.getMessage()) != -1) continue;
                        message = message + "<br>" + st.getMessage().replaceAll("\n", "<br>");
                    }
                }
                ms.setMessage(message);
                ro.setStatus(ms);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to sendDataToCnesst for idEformData : " + idEformData, e);
                ms.setSeverity(IStatus.Severity.ERROR);
                ms.setMessage("Erreur lors de l'envoi du formulaire: " + ExceptionUtils.getMessage(e));
                ro.setStatus(ms);
            }
        }
        return ro;
    }

    private ReturnObject save(CAttenteResultats data) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            XAttenteResultats xData = data.convertx();
            XAttenteResultats savedData = this.eFormAccessorClient.save(xData);
            CAttenteResultats cAttenteResultats = new CAttenteResultats(savedData);
            return ServerResponses.OKReturnObject((Object)cAttenteResultats);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to save AttenteResultats. payload=" + (Object)((Object)data), e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage("Erreur lors de la sauvegarde de AttenteResultats: " + ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private Object delAttenteResultats(Integer formDataId) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            this.controller.delAttenteResultats(formDataId);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to delete eform data. formDataId=" + formDataId, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage("Erreur lors de l'effacement du formulaire: " + ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject save(FormDataSave data) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            boolean doPreSaveOnly = Boolean.TRUE.equals(data.preSaveOnly);
            if (doPreSaveOnly) {
                return this._preSave(data);
            }
            return this._save(data);
        }
        catch (StatusException e) {
            ms.setSeverity(e.getStatus().getSeverity());
            ms.setMessage(e.getStatus().getMessage().replace("\n", "<br>"));
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to save eform data. payload=" + data, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage("Erreur lors de la sauvegarde du formulaire: " + ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject _preSave(FormDataSave data) {
        boolean mustCheckMetaData = Boolean.TRUE.equals(data.mustCheckMetaData);
        Integer tag = data.formData.getSetTag();
        XEformData xData = data.formData.toXEformData();
        String formName = StringUtils.safeToString((Logger)logger, (Object)data.formData.form.name);
        Map<String, Object> inputs = this.controller.mapFormInputs(data.inputs, formName);
        xData = this.controller.saveInputsToEFormData(xData, inputs, data.metas, mustCheckMetaData, data.resumeValue);
        Application.get().getPreSaveController().saveOrUpdate("XFORM", tag, xData);
        return ServerResponses.OKReturnObject(tag);
    }

    private ReturnObject _save(FormDataSave data) throws Exception {
        boolean mustCheckMetaData = Boolean.TRUE.equals(data.mustCheckMetaData);
        XEformData xData = data.formData.toXEformData();
        String formName = StringUtils.safeToString((Logger)logger, (Object)data.formData.form.name);
        Map<String, Object> inputs = this.controller.mapFormInputs(data.inputs, formName);
        XEformData savedData = this.eFormAccessorClient.saveData(xData = this.controller.saveInputsToEFormData(xData, inputs, data.metas, mustCheckMetaData, data.resumeValue));
        if (savedData.getData() != null) {
            savedData.setData(savedData.getData().replaceAll("~~~", "="));
        }
        if (data.formData.form.type != 2) {
            Application.get().getPreSaveController().removeByTag("XFORM", data.formData.tag);
        } else {
            data.formData.id = savedData.getId();
            data.formData.idAnchor = savedData.getIdAnchor();
            if (data.formData.attente != null) {
                data.formData.attente.setId(data.formData.id);
            }
            ServerResponses.OKReturnObject(data.formData);
        }
        return ServerResponses.OKReturnObject(new CFormData(savedData));
    }

    private ReturnObject loadPreSaved(Integer preSavedTag) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            if (preSavedTag != null) {
                XEformData xData = null;
                Object object = Application.get().getPreSaveController().getByTag("XFORM", preSavedTag);
                if (object == null) {
                    ms.setSeverity(IStatus.Severity.ERROR);
                    ms.setMessage("Les donn\u00e9es 'preSavedTag pour le formulaire (formData) n'ont pas \u00e9t\u00e9 retrouv\u00e9es dans la cache id " + preSavedTag);
                    ro.setStatus(ms);
                    return ro;
                }
                xData = (XEformData)object;
                if (xData != null) {
                    ro.setObj((Object)new CFormData(xData));
                    ms.setSeverity(IStatus.Severity.OK);
                    ms.setMessage("");
                    ro.setStatus(ms);
                }
            } else {
                ms.setSeverity(IStatus.Severity.ERROR);
                ms.setMessage("Erreur lors de la r\u00e9cup\u00e9ration du formulaire: preSavedTag null");
                ro.setStatus(ms);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to save eform data. preSavedTag=" + preSavedTag, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage("Erreur lors de la r\u00e9cup\u00e9ration du formulaire: " + ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject userFormData(Integer idPerson) {
        return this.personFormData(idPerson);
    }

    private ReturnObject personFormData(Integer personId) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            List<XBaseEformData> list = this.controller.listPersonFormData(personId, false);
            ArrayList<CFormData> clist = new ArrayList<CFormData>(list.size());
            for (XBaseEformData x : list) {
                clist.add(new CFormData(x, x.getForm()));
            }
            ro.setObj(clist);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to list person eform data", e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject patientFormData(Integer patientId) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            List<XBaseEformData> list = this.controller.listFormData(patientId, true);
            ArrayList<CFormData> clist = new ArrayList<CFormData>(list.size());
            for (XBaseEformData x : list) {
                clist.add(new CFormData(x, x.getForm()));
            }
            ro.setObj(clist);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to list patient eform data", e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    public ReturnObject favoriteList() {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            List<XBaseEform> favorites = this.controller.getFavorites();
            ArrayList<CForm> list = new ArrayList<CForm>(favorites.size());
            for (XBaseEform f : favorites) {
                list.add(new CForm(f));
            }
            ro.setObj(list);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading favorite eform list", e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    public ReturnObject availableList() {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            List<XBaseEform> forms = this.controller.getAllForms();
            ArrayList<CForm> list = new ArrayList<CForm>(forms.size());
            for (XBaseEform f : forms) {
                if (f == null) continue;
                list.add(new CForm(f));
            }
            ro.setObj(list);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading available eform list", e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private ReturnObject printWithLinks(Integer formDataId, Integer idPatient) {
        try {
            XEformData data = new XEformData();
            data.setId(formDataId);
            data.setIdPatient(idPatient);
            IPrintController printController = Application.get().getPrintControllerFactory().newPrintController((Serializable)data, "form");
            LightweightReport report = new LightweightReport("eformdata", Messages.getString((String)"FORMULAIRE", (String[])new String[0]), PrintMode.ACTUAL_SIZE);
            report.setProperties(new ReportProperties());
            report.getProperties().put("includeAddedLinks", (Serializable)Boolean.valueOf(true));
            report.getProperties().put("joinAsOneDocument", (Serializable)Boolean.valueOf(true));
            printController.getSelection().add((IReport)report);
            return ServerResponses.print(printController);
        }
        catch (Exception e) {
            ReturnObject ro = new ReturnObject();
            MultiStatus ms = new MultiStatus();
            logger.log(Level.SEVERE, "Error printing formDataId=" + formDataId, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage("Erreur d'impression du formulaire avec liens.");
            ro.setStatus(ms);
            return ro;
        }
    }

    private ReturnObject print(Integer formDataId, Integer idPatient) {
        try {
            XEformData data = new XEformData();
            data.setId(formDataId);
            data.setIdPatient(idPatient);
            IPrintController printController = Application.get().getPrintControllerFactory().newPrintController((Serializable)data, "form");
            LightweightReport report = new LightweightReport("eformdata", Messages.getString((String)"FORMULAI", (String[])new String[0]), PrintMode.ACTUAL_SIZE);
            printController.getSelection().add((IReport)report);
            return ServerResponses.print(printController);
        }
        catch (Exception e) {
            ReturnObject ro = new ReturnObject();
            MultiStatus ms = new MultiStatus();
            logger.log(Level.SEVERE, "Erreur d'impression de formulaire  formDataId=" + formDataId, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage("Erreur d'impression du formulaire");
            ro.setStatus(ms);
            return ro;
        }
    }

    private ActionResult fax(FormFaxPrint faxPrint) {
        try {
            if (faxPrint.id != null) {
                XFinishedReport finishedReport = new XFinishedReport(null);
                finishedReport.setProperties(new ReportProperties());
                finishedReport.getProperties().put((IReportProperty)new OutputProperty("pdf"));
                XEformData xData = new XEformData();
                xData.setId(faxPrint.id);
                xData.setIdPatient(faxPrint.faxdata == null ? null : faxPrint.faxdata.idPatient);
                IPrintController printController = Application.get().getPrintControllerFactory().newPrintController((Serializable)xData, "form");
                LightweightReport report = new LightweightReport("eformdata", Messages.getString((String)"FORMULAIRE", (String[])new String[0]), PrintMode.ACTUAL_SIZE);
                report.setFinishedReport(finishedReport);
                report.setNumberOfDocuments(Integer.valueOf(1));
                printController.getSelection().add((IReport)report);
                FaxDataProperty faxProp = this.setFaxProp(faxPrint, finishedReport, report);
                if (faxProp != null) {
                    report.getProperties().put("faxData", (Serializable)faxProp);
                }
                try {
                    printController.printSync();
                }
                catch (Exception e1) {
                    return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(e1.getMessage()));
                }
                return ServerResponses.toJsonActionResult(ServerResponses.OKReturnObject());
            }
            return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(Messages.getString((String)"NOTHING_TO_PRINT", (String[])new String[0])));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error printing", e);
            return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(MiscUtil.getStackTraceAsString((Throwable)e)));
        }
    }

    private ActionResult faxWithLinks(FormFaxPrint faxPrint) {
        try {
            if (faxPrint.id != null) {
                XFinishedReport finishedReport = new XFinishedReport(null);
                finishedReport.setProperties(new ReportProperties());
                finishedReport.getProperties().put((IReportProperty)new OutputProperty("pdf"));
                IDDataObject data = new IDDataObject(faxPrint.id, XEformData.class, XEformData.class.getName());
                IPrintController printController = Application.get().getPrintControllerFactory().newPrintController((Serializable)data, "form");
                LightweightReport report = new LightweightReport("eformdata", Messages.getString((String)"FORMULAIRE", (String[])new String[0]), PrintMode.ACTUAL_SIZE);
                report.getProperties().put("includeAddedLinks", (Serializable)Boolean.valueOf(true));
                report.getProperties().put("joinAsOneDocument", (Serializable)Boolean.valueOf(true));
                report.setFinishedReport(finishedReport);
                report.setNumberOfDocuments(Integer.valueOf(1));
                printController.getSelection().add((IReport)report);
                FaxDataProperty faxProp = this.setFaxProp(faxPrint, finishedReport, report);
                if (faxProp != null) {
                    report.getProperties().put("faxData", (Serializable)faxProp);
                }
                try {
                    printController.printSync();
                }
                catch (Exception e1) {
                    return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(e1.getMessage()));
                }
                return ServerResponses.toJsonActionResult(ServerResponses.OKReturnObject());
            }
            return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(Messages.getString((String)"NOTHING_TO_PRINT", (String[])new String[0])));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error printing", e);
            return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(MiscUtil.getStackTraceAsString((Throwable)e)));
        }
    }

    private FaxDataProperty setFaxProp(FormFaxPrint faxPrint, XFinishedReport finishedReport, LightweightReport report) {
        FaxDataProperty faxProp = null;
        if (faxPrint.faxdata != null) {
            faxPrint.faxdata.idSite = Application.get().getSitePluginController().getContextSite().getId();
            List documents = finishedReport.getDocuments();
            HashSet<String> set = new HashSet<String>(documents.size());
            for (XFinishedDocument x : documents) {
                set.add(x.name);
            }
            faxPrint.faxdata.docName = (StringUtils.isBlank((CharSequence)faxPrint.faxdata.docName) ? report.getName() : faxPrint.faxdata.docName) + (set.isEmpty() ? "" : ": " + new JoinList(", ", set).toString());
            faxProp = new FaxDataProperty("faxData", faxPrint.faxdata);
            finishedReport.getProperties().put("faxData", (Serializable)faxProp);
        }
        return faxProp;
    }

    public static class FormFaxPrint {
        public Integer id;
        public FaxData faxdata;
    }

    public static class FormAutoFill {
        public CFormData formData;
        public Boolean readonly;
        public Object[] inputs;
    }

    public static class FormDataSave {
        Boolean preSaveOnly;
        Boolean mustCheckMetaData;
        CFormData formData;
        Object[] inputs;
        Object[] metas;
        String resumeValue;

        public String toString() {
            return "FormSavePayload [preSaveOnly=" + this.preSaveOnly + ", mustCheckMetaData=" + this.mustCheckMetaData + ", formData=" + this.formData + ", inputs=" + Arrays.toString(this.inputs) + ", metas=" + Arrays.toString(this.metas) + ", resumeValue=" + this.resumeValue + "]";
        }
    }
}

