/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.IWebController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.Handler;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.ServerRequestContext;
import ca.infodata.ofys.data.dataaccess.util.notification.ConsumerAdapter;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.StatusException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractWebController
implements IWebController {
    private static final Logger logger = Logger.getLogger(AbstractWebController.class.getName());
    private final ConsumerAdapter notificationSystemConsumer;
    private final RouterFunction<?> routes = this.getRoutes();

    public AbstractWebController() {
        this.notificationSystemConsumer = new ConsumerAdapter();
        Application.get().getGlobalInstances().getNotificationSystem().addListener(this.notificationSystemConsumer);
    }

    protected XSession getSession() {
        return Application.get().getGlobalInstances().getSession();
    }

    protected ConsumerAdapter getNotificationSystemConsumer() {
        return this.notificationSystemConsumer;
    }

    @Override
    public final ActionResult getAction(IServerRequest req) {
        Application.get().getApplicationUiPlugin().notifyUserInteraction();
        try {
            return this.handle(req);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while calling getAction2 for req " + req.printDebugInfo(), e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult handle(IServerRequest request) throws Exception {
        Handler<ActionResult> handler = this.getHandler(request);
        if (handler == null) {
            return null;
        }
        Class<?> returnType = handler.returnType();
        if (ActionResult.class.equals(returnType)) {
            return this.handleActionResult(request, handler);
        }
        if (ReturnObject.class.equals(returnType)) {
            return this.handleReturnObject(request, handler);
        }
        throw new Exception("unsupported handler returnType " + returnType);
    }

    private ActionResult handleReturnObject(IServerRequest request, Handler<ReturnObject> handler) {
        try {
            ReturnObject returnObject = handler.function().handle(request);
            if (returnObject == null) {
                returnObject = ServerResponses.ErrorReturnObject(Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]));
            }
            return ServerResponses.toJsonActionResult(returnObject);
        }
        catch (StatusException e) {
            return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(e.getMessage()));
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error handling request. Handler=" + handler + " request=" + request.printDebugInfo(), e);
            return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0])));
        }
    }

    private ActionResult handleActionResult(IServerRequest request, Handler<ActionResult> handler) {
        try {
            return handler.function().handle(request);
        }
        catch (StatusException e) {
            return ServerResponses.ERROR(e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error handling request. Handler=" + handler + " request=" + request.printDebugInfo(), e);
            return ServerResponses.ERROR(Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]));
        }
    }

    private Handler<?> getHandler(IServerRequest request) {
        ServerRequestContext context = new ServerRequestContext(request);
        return this.routes.route(context);
    }

    public String getHostAddr(IServerRequest req) {
        if (req != null) {
            return req.getHostAddr();
        }
        return null;
    }

    @Override
    public void dispose() {
        Application.get().getGlobalInstances().getNotificationSystem().removeListener(this.notificationSystemConsumer);
    }
}

