/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.util;

import ca.infodata.ofys.client.util.ClosureE;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {
    private static final Logger logger = Logger.getLogger(Util.class.getName());

    public static <T> void executeAndIgnore(ClosureE closure) {
        try {
            if (closure != null) {
                closure.execute();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> void executeAndLogOnError(Collection<ClosureE> c) {
        for (ClosureE closureE : c) {
            Util.executeAndLogOnError(closureE);
        }
    }

    public static <T> void executeAndLogOnError(ClosureE closure) {
        try {
            if (closure != null) {
                closure.execute();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error executing closure " + closure, e);
        }
    }

    public static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }
}

