/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.resources.impl;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.cache.IResourceCache;
import ca.infodata.ofys.client.resources.IResourceDelegate;
import ca.infodata.ofys.client.util.SupplierE;
import ca.infodata.util1.StringUtils;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceDelegateImpl
implements IResourceDelegate {
    private final ConcurrentHashMap<String, SupplierE<byte[]>> registry = new ConcurrentHashMap();

    @Override
    public byte[] get(String resourceName) throws Exception {
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            throw new IllegalArgumentException("resourceName cant be blank");
        }
        return this.internalGet(resourceName);
    }

    private byte[] internalGet(String resourceName) throws Exception {
        if (this.registry.containsKey(resourceName)) {
            IResourceCache cache = this.getCache();
            return cache.get(resourceName, this.registry.get(resourceName));
        }
        throw new IllegalArgumentException("no resource registered with resourceName " + resourceName);
    }

    private IResourceCache getCache() {
        return Application.get().getCache().getResourceCache();
    }

    @Override
    public byte[] get(String resourceName, SupplierE<byte[]> resourceSupplier) throws Exception {
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            throw new IllegalArgumentException("resourceName cant be blank");
        }
        if (resourceSupplier == null) {
            return this.internalGet(resourceName);
        }
        if (this.registry.containsKey(resourceName)) {
            IResourceCache cache = this.getCache();
            return cache.get(resourceName, () -> {
                try {
                    return this.registry.get(resourceName).get();
                }
                catch (Exception e) {
                    return (byte[])resourceSupplier.get();
                }
            });
        }
        byte[] data = resourceSupplier.get();
        if (data != null) {
            this.registry.put(resourceName, resourceSupplier);
        }
        return data;
    }

    @Override
    public String readAsString(String resourceName, Charset charset) throws Exception {
        byte[] data = this.get(resourceName);
        return new String(data, charset);
    }

    @Override
    public void register(String resourceName, SupplierE<byte[]> resourceSupplier) {
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            throw new IllegalArgumentException("resourceName cant be blank");
        }
        if (resourceSupplier == null) {
            throw new IllegalArgumentException("resourceSupplier cant be null");
        }
        if (this.registry.containsKey(resourceName)) {
            throw new IllegalArgumentException("a resource has already been registered for resourceName " + resourceName);
        }
        this.registry.put(resourceName, resourceSupplier);
    }

    @Override
    public void dispose() {
        if (this.getCache() != null) {
            this.getCache().dispose();
        }
        this.registry.clear();
    }
}

