/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.person;

import ca.infodata.ofys.client.modules.person.INamValidatorService;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.NAM_NB;
import ca.infodata.ofys.data.middle.dataobjects.patient.NAM_QC;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.util1.JoinList;

public class DefaultNamValidatorService
implements INamValidatorService {
    private boolean doValidQc = true;
    private boolean doValidNb = true;

    @Override
    public IStatus valid(IPatient patient) {
        if (patient == null) {
            return Status.OK_STATUS;
        }
        JoinList messages = new JoinList("\n");
        IStatus.Severity severity = null;
        if (this.doValidQc) {
            boolean validQc = NAM_QC.validateNAM((String)patient.getHealthInsuranceNumber());
            if (validQc) {
                severity = this.setSeverity(severity, IStatus.Severity.INFO);
                messages.add((CharSequence)"valide pour le Qu\u00e9bec");
            } else {
                severity = this.setSeverity(severity, IStatus.Severity.WARNING);
                messages.add((CharSequence)"invalide pour le Qu\u00e9bec");
            }
        }
        if (this.doValidNb) {
            boolean validNb = NAM_NB.validateNAM((String)patient.getHealthInsuranceNumber());
            if (validNb) {
                severity = this.setSeverity(severity, IStatus.Severity.INFO);
                messages.add((CharSequence)"valide pour le Nouveau-Brunswick");
            } else {
                severity = this.setSeverity(severity, IStatus.Severity.WARNING);
                messages.add((CharSequence)"invalide pour le Nouveau-Brunswick");
            }
        }
        if (severity == null) {
            severity = IStatus.Severity.OK;
        }
        return new Status(severity, messages.toString());
    }

    private IStatus.Severity setSeverity(IStatus.Severity old, IStatus.Severity s) {
        if (old == IStatus.Severity.INFO || old == IStatus.Severity.OK) {
            return old;
        }
        return s;
    }

    public boolean isDoValidQc() {
        return this.doValidQc;
    }

    public void setDoValidQc(boolean doValidQc) {
        this.doValidQc = doValidQc;
    }

    public boolean isDoValidNb() {
        return this.doValidNb;
    }

    public void setDoValidNb(boolean doValidNb) {
        this.doValidNb = doValidNb;
    }
}

