/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.eform.autocomplete;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.eform.autocomplete.AutoComplete;
import ca.infodata.ofys.client.modules.eform.autocomplete.IComplexAutoComplete;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.ICrds;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergy;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBloodPressure;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBodyTemperature;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCustomMeasure;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDiagnostic;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocuments;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XFrequency;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XImmunization;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XIntervention;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XLifeHabit;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XMeasurement;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPhysicalExamination;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPlan;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPrevent;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XRappel;
import ca.infodata.ofys.data.middle.dataobjects.identifiers.XPatientIdentifier;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.PreviousLabResults;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.runtime.Platform;

public abstract class EFormAutoComplete {
    protected static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.eform.autocomplete.EFormAutoComplete");
    public XPatient patient;
    public XBaseProfessionnal professionnal;
    public XBaseProfessionnal superviseur;
    public Map<String, Object> properties;
    public ArrayList<AutoComplete> autoCompletes;
    public ArrayList<IComplexAutoComplete> complexAutoCompletes;
    public OnTheFly<HashMap<String, Integer>> creatinine;
    public OnTheFly<List<PreviousLabResults>> rnis;
    public OnTheFly<List<PreviousLabResults>> creatinines;
    public OnTheFly<List<PreviousLabResults>> clearance;
    public OnTheFly<List<PreviousLabResults>> ca_ionises;
    public OnTheFly<List<PreviousLabResults>> ca_totals;
    public OnTheFly<List<PreviousLabResults>> ferritines;
    public OnTheFly<List<PreviousLabResults>> glycemies;
    public OnTheFly<List<PreviousLabResults>> hbs;
    public OnTheFly<List<PreviousLabResults>> kals;
    public OnTheFly<List<PreviousLabResults>> mags;
    public OnTheFly<List<PreviousLabResults>> nats;
    public OnTheFly<List<PreviousLabResults>> seds;
    public OnTheFly<List<PreviousLabResults>> urees;
    public OnTheFly<List<PreviousLabResults>> cholt;
    public OnTheFly<List<PreviousLabResults>> hdls;
    public OnTheFly<List<PreviousLabResults>> ldls;
    public OnTheFly<XEncounter> encounter;
    public OnTheFly<List<XAllergy>> allergies;
    public OnTheFly<List<XDiagnostic>> diagnostics;
    public OnTheFly<List<XPrevent>> prevents;
    public OnTheFly<List<XBloodPressure>> bloodPressures;
    public OnTheFly<List<XFrequency>> frenquencies;
    public OnTheFly<List<XDocuments>> documents;
    public OnTheFly<List<XCustomMeasure>> customMeasures;
    public OnTheFly<List<XImmunization>> immunizations;
    public OnTheFly<List<XIntervention>> interventions;
    public OnTheFly<List<XLifeHabit>> lifeHabits;
    public OnTheFly<List<XMeasurement>> measurements;
    public OnTheFly<List<XPlan>> plans;
    public OnTheFly<List<XRappel>> rappels;
    public OnTheFly<List<XPhysicalExamination>> physicalExaminations;
    public OnTheFly<List<XBodyTemperature>> bodyTemperatures;
    public OnTheFly<List<XPatientIdentifier>> patientIdentifiers;
    public OnTheFly<List<XPrescription>> prescriptions;
    public OnTheFly<List<XSite>> drugStores;

    protected void initAutoCompleteList() {
        this.autoCompletes = new ArrayList();
        this.complexAutoCompletes = new ArrayList();
        this.patient = this.getXPatient();
        if (this.professionnal == null) {
            this.professionnal = Application.get().getPersonPluginController().getSessionProfessionnal();
        }
        if (this.superviseur == null) {
            this.superviseur = Application.get().getPersonPluginController().getSessionSuperviseur();
        }
    }

    private void complete(String key, Object value) {
        if (value == null) {
            value = "";
        }
        this.properties.put(key, String.valueOf(value));
    }

    private AutoComplete findAutoComplete(String key) {
        for (AutoComplete auto : this.autoCompletes) {
            if (!auto.toComplete(key)) continue;
            return auto;
        }
        return null;
    }

    private IComplexAutoComplete findComplexAutoComplete(String key) {
        for (IComplexAutoComplete auto : this.complexAutoCompletes) {
            if (!auto.toComplete(key)) continue;
            return auto;
        }
        return null;
    }

    public static XContactInformation findFirstContact(XPerson person, List<Integer> contactTypes, XContactInformation ... excluding) {
        XContactInformation contact = null;
        for (XContactInformation c : person.getLstContactInformation()) {
            if (!contactTypes.contains(c.getTypeContact()) || ArrayUtils.contains((Object[])excluding, (Object)c)) continue;
            contact = c;
            break;
        }
        return contact;
    }

    public static XContactInformation findExactSequenceContact(XPatient patient, List<Integer> contactTypes, int sequenceNumber) {
        XContactInformation contact = null;
        int i = 1;
        for (XContactInformation c : patient.getLstContactInformation()) {
            if (!contactTypes.contains(c.getTypeContact())) continue;
            if (sequenceNumber == i) {
                contact = c;
                break;
            }
            ++i;
        }
        return contact;
    }

    protected XPatient getXPatient() {
        XPatient pat;
        if (this.patient != null) {
            pat = this.patient;
        } else {
            if (!Platform.isRunning()) {
                return null;
            }
            pat = Application.get().getPersonPluginController().getCurrentPatient();
        }
        return pat;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public void setPatient(XPatient patient) {
        this.patient = patient;
    }

    public XBaseProfessionnal getProfessionnal() {
        return this.professionnal;
    }

    public void setProfessionnal(XBaseProfessionnal professionnal) {
        this.professionnal = professionnal;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void autoComplete() {
        if (this.properties == null) {
            throw new IllegalStateException("properties not been setted");
        }
        long l1 = System.currentTimeMillis();
        for (String key : new ArrayList<String>(this.properties.keySet())) {
            Object ac;
            try {
                ac = this.findAutoComplete(key);
                if (ac != null) {
                    if (ac instanceof ICrds) {
                        String[] crds = ((ICrds)ac).completeCrds();
                        if (crds == null) continue;
                        this.complete(key, crds[0] + (crds.length == 2 ? "\u0131" + crds[1] : ""));
                        continue;
                    }
                    this.complete(key, ((AutoComplete)ac).complete());
                    continue;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to complete eform autocomplete field " + key + ". This is not a blocking error.", e);
            }
            try {
                ac = this.findComplexAutoComplete(key);
                if (ac == null) continue;
                ac.complete(this.properties);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to complete eform autocomplete field " + key + ". This is not a blocking error.", e);
            }
        }
        long l2 = System.currentTimeMillis();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "autoComplete time : " + (l2 - l1) + " ns. En ms=" + (l2 - l1) / 1000L);
        }
    }

    protected static String normalizedString(String s, int l) {
        while (s.length() < l) {
            s = s + " ";
        }
        return s;
    }

    protected static String valueOf(Object o) {
        if (o == null) {
            return "";
        }
        return StringUtils.defaultString((String)o.toString()).trim();
    }

    protected static Integer getAgeAtASpecificDate(LocalDate birthdate, LocalDate base) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (birthdate == null) {
            return null;
        }
        LocalDate today = base;
        int age = today.year - birthdate.year;
        if (today.before((IPartialDate)birthdate.withYear(today.year))) {
            --age;
        }
        return age;
    }

    public abstract class OnTheFly<E> {
        private E object = null;
        private boolean tried = false;

        public abstract E loadObject();

        public E get() {
            if (this.object == null && !this.tried) {
                this.tried = true;
                this.object = this.loadObject();
            }
            return this.object;
        }
    }
}

