/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.eform;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.eform.autocomplete.EFormAutoComplete;
import ca.infodata.ofys.client.modules.eform.autocomplete.EFormAutoCompleteAll;
import ca.infodata.ofys.client.modules.eform.autocomplete.EFormAutoCompleteCrds;
import ca.infodata.ofys.client.modules.eform.metadata.MetaDataContainer;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformType;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import com.google.gson.Gson;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.FastDateFormat;

public class EFormPrepare {
    private static final Logger logger = Logger.getLogger(EFormPrepare.class.getName());
    protected static final String PRINTED_BY = Messages.getString((String)"PRINTED_BY", (String[])new String[0]);
    protected static final String JQUERY_JS = "jquery-1.11.3.min.js";
    protected static final String JQUERYUI_JS = "jquery-ui-1.10.3.custom.min.js";
    protected static final String INFODATA_JS = "infodata.js";
    protected static final String INFODATA_CSS = "infodata.css";
    private static final Pattern submitButtonRowPattern = Pattern.compile("The submit/print/reset.*End of submit/print/reset", 34);
    private static final Pattern removeConfirmExitPattern = Pattern.compile("window.onbeforeunload = confirmExit;", 32);
    public List<String> meta;
    public List<String> auto;
    public List<String> saved;
    public XEformData edata;
    public String jsonProperties;
    public transient Properties properties;
    public Boolean readonly;
    public Map<String, Object> inputs;
    private XPatient patient;

    public static String singHtmlDocument(String html) {
        String add = "";
        String username = Application.get().getGlobalInstances().getSession().getUser().getName();
        add = add + "\n\t<script type=\"text/javascript\">";
        String printedBy = PRINTED_BY;
        add = add + "\n\t\tvar _INFODATA_SINGPART_MSG_PRINT_BY = \"" + printedBy + "\"";
        add = add + "\n\t\tvar _INFODATA_SINGPART_USERNAME = \"" + username + "\"";
        add = add + "\n\t\tvar _INFODATA_SINGPART_HOUR = \"" + FastDateFormat.getInstance((String)"yyyy/MM/dd HH:mm:ss").format(DateUtil.newCalendar().getTime()) + "\"";
        add = add + "\n\t\tvar _INFODATA_SINGPART_MSG_CONFI = \"" + Messages.getString((String)"CONFIDENTIALITE_SHORT", (String[])new String[0]) + "\"";
        add = add + "\n\t\t";
        add = add + "\n\t</script>";
        return EFormPrepare.injectBeforeClosingBody(html, add);
    }

    public static String injectBeforeClosingBody(String html, String addition) {
        Pattern pattern = Pattern.compile("(.*)(</.?[bB][oO][dD][yY].?>.*)", 32);
        Matcher matcher = pattern.matcher(html);
        if (matcher.find()) {
            String start = matcher.group(1);
            String close = matcher.group(2);
            if (!StringUtils.isBlank((CharSequence)start) && !StringUtils.isBlank((CharSequence)close)) {
                StringBuilder sb = new StringBuilder();
                sb.append(start);
                sb.append(addition);
                sb.append(close);
                html = sb.toString();
            }
        }
        return html;
    }

    public static String injectAdditionalHtmlCRDS(String html) {
        if (html == null) {
            throw new IllegalArgumentException("form html is null");
        }
        try {
            String s1 = "<script type=\"text/javascript\" src=\"../tools/jquery-1.11.3.min.js\"></script>\n";
            String s2 = "<script type=\"text/javascript\" src=\"../tools/infodata.js\"></script>\n";
            String s3 = "<script type=\"text/javascript\" src=\"../tools/jquery-ui-1.10.3.custom.min.js\"></script>\n";
            int indexOf = html.indexOf("<head>");
            if (indexOf == -1) {
                indexOf = html.indexOf("<HEAD>");
            }
            StringBuilder b2 = new StringBuilder(html);
            indexOf = indexOf == -1 ? 0 : (indexOf += "<head>".length());
            b2.insert(indexOf, s1 + s2 + s3);
            String html2 = b2.toString();
            String html3 = EFormPrepare.singHtmlDocument(html2);
            String debug = "<script type=\"text/javascript\">\nvar inputs = listFormInputsCRDS();\nconsole.log(inputs);console.log(\"is working\");</script>\n";
            String html4 = EFormPrepare.injectBeforeClosingBody(html3, debug);
            return html4;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to set resource root path into html", e);
            return html;
        }
    }

    public static String injectAdditionalHtml(String html) {
        if (html == null) {
            throw new IllegalArgumentException("form html is null");
        }
        try {
            html = EFormPrepare.addCustomsMethods(html);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to set resource root path into html", e);
        }
        try {
            html = EFormPrepare.removeConfirmExitFromHtml(html);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to remove confirm exit from html", e);
        }
        try {
            html = EFormPrepare.removeSubmitButtonRowFromHtml(html);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to remove submit button row from html", e);
        }
        html = EFormPrepare.singHtmlDocument(html);
        return html;
    }

    public static String removeSubmitButtonRowFromHtml(String html) {
        Matcher matcher = submitButtonRowPattern.matcher(html);
        String html2 = matcher.replaceFirst("");
        return html2;
    }

    private static String removeConfirmExitFromHtml(String html) {
        Matcher matcher = removeConfirmExitPattern.matcher(html);
        String html2 = matcher.replaceFirst("");
        return html2;
    }

    public static String addCustomsMethods(String html) {
        int indexOf;
        String s1 = "<script type=\"text/javascript\" src=\"../tools/jquery-1.11.3.min.js\"></script>\n";
        String s2 = "<script type=\"text/javascript\" src=\"../tools/infodata.js\"></script>\n";
        String s3 = "<script type=\"text/javascript\" src=\"../tools/jquery-ui-1.10.3.custom.min.js\"></script>\n";
        String c1 = "<link rel=\"stylesheet\" href=\"../tools/infodata.css\"/>\n";
        String submitDataFunction = "";
        String relaodImage = "";
        if (html.indexOf("SubmitImage") == -1) {
            submitDataFunction = "<script type=\"text/javascript\" language=\"javascript\">function SubmitImage(){}</script>";
        }
        if (html.indexOf("ReloadImage") == -1) {
            relaodImage = "<script type=\"text/javascript\" language=\"javascript\">function ReloadImage(){}</script>";
        }
        if ((indexOf = html.indexOf("<head>")) == -1) {
            indexOf = html.indexOf("<HEAD>");
        }
        StringBuilder b2 = new StringBuilder(html);
        indexOf = indexOf == -1 ? 0 : (indexOf += "<head>".length());
        b2.insert(indexOf, s1 + s2 + s3 + c1 + submitDataFunction + relaodImage);
        return b2.toString();
    }

    public EFormPrepare(XPatient patient) {
        this.patient = patient;
        this.meta = new ArrayList<String>();
        this.auto = new ArrayList<String>();
        this.saved = new ArrayList<String>();
    }

    public static String propertiesToString(Properties prop) {
        String s = new Gson().toJson(EFormPrepare.propertiesToArrayList(prop));
        return s;
    }

    public static ArrayList<KeyValue> propertiesToArrayList(Properties prop) {
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        for (Map.Entry<Object, Object> e : prop.entrySet()) {
            list.add(new KeyValue((String)e.getKey(), (String)e.getValue()));
        }
        return list;
    }

    public void doPropertyAndSavedStatusSetup() {
        if (this.edata != null) {
            String value;
            String data = this.edata.getData();
            if (this.edata.getId() == null && StringUtils.isBlank((CharSequence)data)) {
                Object autocomplete;
                if (XEformType.CRDS.equals((Object)this.edata.getForm().getType())) {
                    autocomplete = new EFormAutoCompleteCrds(this.patient);
                    ((EFormAutoComplete)autocomplete).setProperties(this.inputs);
                    ((EFormAutoComplete)autocomplete).autoComplete();
                    this.properties = new Properties();
                    this.properties.putAll(this.inputs);
                    data = MiscUtil.propertiesToData((Properties)this.properties);
                    this.edata.setData(data);
                    try {
                        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                            Object object = entry.getValue();
                            if (!(object instanceof String) || !StringUtils.isNotBlank((String)(value = (String)object)) || !(entry.getKey() instanceof String)) continue;
                            this.auto.add((String)entry.getKey());
                        }
                    }
                    catch (Exception exception) {
                        logger.log(Level.WARNING, "Failed load data from eformdata " + this.edata, exception);
                    }
                } else {
                    autocomplete = new EFormAutoCompleteAll(this.patient);
                    ((EFormAutoComplete)autocomplete).setProperties(this.inputs);
                    ((EFormAutoComplete)autocomplete).autoComplete();
                    this.properties = new Properties();
                    this.properties.putAll(this.inputs);
                    data = MiscUtil.propertiesToData((Properties)this.properties);
                    this.edata.setData(data);
                    try {
                        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                            Object object = entry.getValue();
                            if (!(object instanceof String) || !StringUtils.isNotBlank((String)(value = (String)object)) || !(entry.getKey() instanceof String)) continue;
                            this.auto.add((String)entry.getKey());
                        }
                    }
                    catch (Exception exception) {
                        logger.log(Level.WARNING, "Failed load data from eformdata " + this.edata, exception);
                    }
                }
            } else if (StringUtils.isNotBlank((String)data)) {
                try {
                    this.properties = new Properties();
                    this.properties.load(new StringReader(data));
                    for (Map.Entry entry : this.properties.entrySet()) {
                        String string = (String)entry.getKey();
                        Object v = entry.getValue();
                        if (!(v instanceof String) || !StringUtils.isNotBlank((String)(value = (String)v))) continue;
                        this.saved.add(string);
                    }
                    if (this.readonly == null || Boolean.FALSE.equals(this.readonly)) {
                        HashMap<String, Object> autoProp = new HashMap<String, Object>();
                        for (String string : this.inputs.keySet()) {
                            autoProp.put(string, null);
                        }
                        if (XEformType.CRDS.equals((Object)this.edata.getForm().getType())) {
                            EFormAutoCompleteCrds eFormAutoCompleteCrds = new EFormAutoCompleteCrds(this.patient);
                            eFormAutoCompleteCrds.setProperties(this.inputs);
                            eFormAutoCompleteCrds.autoComplete();
                        } else {
                            EFormAutoCompleteAll eFormAutoCompleteAll = new EFormAutoCompleteAll(this.patient);
                            eFormAutoCompleteAll.setProperties(autoProp);
                            eFormAutoCompleteAll.autoComplete();
                        }
                        Properties properties = new Properties();
                        for (Map.Entry entry : autoProp.entrySet()) {
                            if (!(entry.getValue() instanceof String) || !StringUtils.isNotBlank((String)((String)entry.getValue()))) continue;
                            properties.put(entry.getKey(), entry.getValue());
                        }
                        try {
                            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                                String value2;
                                Object valueO2 = entry.getValue();
                                if (!(valueO2 instanceof String) || !StringUtils.isNotBlank((String)(value2 = (String)valueO2)) || !(entry.getKey() instanceof String)) continue;
                                this.auto.add((String)entry.getKey());
                            }
                            this.properties.putAll((Map<?, ?>)properties);
                            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                                Object value2;
                                Object autoValue = this.inputs.get(entry.getKey());
                                if (autoValue == null || (value2 = entry.getValue()) != null && (!(value2 instanceof String) || !StringUtils.isBlank((CharSequence)((String)value2)))) continue;
                                entry.setValue(autoValue);
                            }
                            data = MiscUtil.propertiesToData((Properties)this.properties);
                            this.edata.setData(data);
                        }
                        catch (Exception exception) {
                            logger.log(Level.WARNING, "Failed load data from eformdata " + this.edata, exception);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Failed load data from eformdata " + this.edata, ex);
                }
            }
            if (StringUtils.isNotBlank((String)this.edata.getMetaData())) {
                try {
                    List<MetaDataContainer> mData = MetaDataContainer.extractMetaDataFrom(this.edata.getMetaData());
                    for (MetaDataContainer metaDataContainer : mData) {
                        if (!metaDataContainer.extracted) continue;
                        this.meta.add(metaDataContainer.metaData.id);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.jsonProperties = EFormPrepare.propertiesToString(this.properties);
        }
    }

    public static class KeyValue {
        public final String key;
        public final String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

