/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationCriteria;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.StatusException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class QueryContinuationController {
    private static final Logger logger = Logger.getLogger(QueryContinuationController.class.getName());
    protected final IDSQPluginController dsq = Application.get().getDsqPluginController();
    protected final IDSQAccessor dsqAccessor = Application.get().getDataAccessors().getDSQAccessor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DsqCallback<QueryContinuationResult> continueQuery(Integer idPatient, QueryContinuationResult qcr, int continuationQuantity, IProgressMonitor monitor) {
        DsqCallback<QueryContinuationResult> callback = new DsqCallback<QueryContinuationResult>();
        try {
            XmlSignatureI signature = null;
            if (!this.dsq.hasSignatures(null)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.dsq.getAlias(monitor);
                signature = this.dsq.getSignatureI(monitor, alias);
            }
            QueryContinuationCriteria criteria = new QueryContinuationCriteria(qcr, continuationQuantity);
            ReturnObject r = this.dsqAccessor.continueQuery((Signature)signature, idPatient, criteria);
            if (r == null) {
                throw new AbortException("Erreur lors de la poursuite de la requ\u00eate");
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = (QueryContinuationResult)r.getObj();
        }
        catch (AbortException | CancelException | CannotConnectToServerException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = e.getMessage();
            logger.log(Level.SEVERE, "Error in continueQuery for qcr " + qcr, e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }
}

