/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.Id;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.domain.NIU_SH;
import ca.infodata.dsq.service.sommhosp.get.PatientDischargeCareDetails;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.NullProgressMonitor;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.util1.Triple;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetDischargeCareDetailController {
    private static final String OBTENTION_DU_RAPPORT = "Obtention du sommaire d'hospitalisation";
    private static final Logger logger = Logger.getLogger(GetDischargeCareDetailController.class.getName());
    private final GetCandidateController findCandidateAction;
    private final IDSQPluginController dsq;
    private final IDSQAccessor dsqAccessor;
    private final Integer idPatient;
    private Candidate candidate;

    public GetDischargeCareDetailController(Integer idPatient, GetCandidateController findCandidateAction) {
        if (findCandidateAction == null) {
            throw new NullPointerException("findCandidateAction");
        }
        this.idPatient = idPatient;
        this.findCandidateAction = findCandidateAction;
        this.dsq = Application.get().getDsqPluginController();
        this.dsqAccessor = Application.get().getDataAccessors().getDSQAccessor();
    }

    public void callback(DsqCallback<Triple<Integer, Candidate, PatientDischargeCareDetails>> dsqCallback) {
    }

    public void get(NIU_SH recordId, Boolean includeHistory) {
        this.callback(this.get3(recordId, includeHistory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DsqCallback<Triple<Integer, Candidate, PatientDischargeCareDetails>> get3(NIU_SH recordId, Boolean includeHistory) {
        IProgressMonitor monitor = NullProgressMonitor.INSTANCE;
        DsqCallback<Triple<Integer, Candidate, PatientDischargeCareDetails>> callback = new DsqCallback<Triple<Integer, Candidate, PatientDischargeCareDetails>>();
        try {
            Alias alias = null;
            XmlSignatureI signature = null;
            XmlSignatureI signatureNiu = null;
            this.dsq.checkIfActionWasCanceled(monitor);
            this.candidate = this.findCandidateAction.getCandidate(monitor.subMonitor(1));
            String niu = this.candidate.getNiu().value();
            if (!this.dsq.hasSignatures(this.idPatient)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                alias = this.dsq.getAlias(monitor);
                this.dsq.checkIfActionWasCanceled(monitor);
                signature = this.dsq.getSignatureI(monitor, alias);
                this.dsq.checkIfActionWasCanceled(monitor);
                signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, niu);
                this.dsq.checkIfActionWasCanceled(monitor);
            }
            this.dsq.checkIfActionWasCanceled(monitor);
            ReturnObject r = this.dsqAccessor.getPatientDischargeCareDetail((Signature)signature, (Signature)signatureNiu, this.idPatient, recordId, includeHistory);
            if (r == null) {
                throw new AbortException("Erreur lors de l'" + OBTENTION_DU_RAPPORT.toLowerCase());
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = Triple.newTriple((Object)this.idPatient, (Object)this.candidate, (Object)((PatientDischargeCareDetails)r.getObj()));
            this.dsq.checkIfActionWasCanceled(monitor);
        }
        catch (AbortException | CancelException | CannotConnectToServerException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = e.getMessage();
            logger.log(Level.SEVERE, String.format("Failed to get dischage care detail result exam detail %s, %s, %s", this.idPatient, recordId, includeHistory), e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public void clear() {
        this.candidate = null;
    }

    public static String toString(Id id) {
        return id == null ? null : id.root + ";" + id.extension;
    }

    public static String toString(Code code) {
        return code == null ? null : code.codeSystem + ";" + code.code;
    }

    public static String toString(NIU niu) {
        return niu == null ? null : niu.oid() + ";" + niu.value();
    }

    public Candidate getCandidate() {
        return this.candidate;
    }
}

