/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.NullProgressMonitor;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.OERetractController;
import ca.infodata.ofys.client.modules.encounter.XPrescriptionFormatter;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CPrescriptionFormatter;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ExportPrescriptionToDsqController {
    private static final Logger logger = Logger.getLogger(ExportData.class.getName());
    private final OERetractController retractController;
    private final IDSQPluginController dsq;
    private final IDSQAccessor dsqAccessor;
    private final GetCandidateController findCandidateController;
    private final Integer idPatient;

    public ExportPrescriptionToDsqController(Integer idPatient, GetCandidateController findCandidateController, OERetractController retractController) {
        this.findCandidateController = findCandidateController;
        this.retractController = retractController;
        this.idPatient = idPatient;
        this.dsq = Application.get().getDsqPluginController();
        this.dsqAccessor = Application.get().getDataAccessors().getDSQAccessor();
    }

    public ExportResult export(List<XPrescription> prescriptions) {
        IProgressMonitor monitor = NullProgressMonitor.INSTANCE;
        boolean isWindows = Application.get().getApplicationUiPlugin().isWindowsDesktop();
        if (prescriptions == null) {
            throw new NullPointerException("prescriptions");
        }
        ExportResult result = new ExportResult();
        if (prescriptions.isEmpty()) {
            return result;
        }
        try {
            for (XPrescription prescription : prescriptions) {
                Integer prevPrescriptionId = prescription.getPrevPrescriptionId();
                boolean doInclude = true;
                if (!prescription.isActiveNow() && prevPrescriptionId != null) {
                    for (XPrescription p : prescriptions) {
                        if (p.equals((Object)prescription) || !prevPrescriptionId.equals(p.getPrevPrescriptionId())) continue;
                        doInclude = false;
                        break;
                    }
                }
                if (!doInclude) continue;
                ExportData data = new ExportData();
                data.prescription = prescription;
                result.exported.add(data);
            }
        }
        catch (Exception e) {
            result.failed = new Status(IStatus.Severity.BUG, (Throwable)e);
        }
        if (result.failed != null) {
            return result;
        }
        if (result.exported.isEmpty()) {
            return result;
        }
        try {
            this.findCandidateController.getNiu(monitor);
        }
        catch (StatusException e) {
            result.failed = e.getStatus();
        }
        catch (AbortException | CancelException e) {
            result.failed = new Status(IStatus.Severity.ERROR, (Throwable)e);
        }
        catch (Exception e) {
            result.failed = new Status(IStatus.Severity.BUG, (Throwable)e);
        }
        if (result.failed != null) {
            return result;
        }
        XmlSignatureI signature = null;
        Alias alias = null;
        try {
            if (!isWindows) {
                throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
            }
            alias = this.dsq.getAlias(monitor);
            if (!this.dsq.hasSignatures(this.idPatient)) {
                signature = this.dsq.getSignatureI(monitor, alias);
            }
            monitor.worked(1);
        }
        catch (StatusException e) {
            result.failed = e.getStatus();
        }
        catch (AbortException | CancelException e) {
            result.failed = new Status(IStatus.Severity.ERROR, (Throwable)e);
        }
        catch (Exception e) {
            result.failed = new Status(IStatus.Severity.BUG, (Throwable)e);
        }
        if (result.failed != null) {
            return result;
        }
        try {
            this.retract(this.idPatient, result.exported);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error retracting prescriptions before sending new ones", e);
        }
        try {
            this.export1((Signature)signature, result.exported);
        }
        catch (StatusException e) {
            result.failed = e.getStatus();
        }
        catch (Exception e) {
            result.failed = new Status(IStatus.Severity.BUG, (Throwable)e);
        }
        if (result.failed != null) {
            return result;
        }
        try {
            this.signToBeApprovedRequest((Signature)signature, alias, result.exported);
        }
        catch (StatusException e) {
            result.failed = e.getStatus();
        }
        catch (AbortException | CancelException e) {
            result.failed = new Status(IStatus.Severity.ERROR, (Throwable)e);
        }
        catch (Exception e) {
            result.failed = new Status(IStatus.Severity.BUG, (Throwable)e);
        }
        if (result.failed != null) {
            return result;
        }
        try {
            this.export2((Signature)signature, result.exported);
        }
        catch (StatusException e) {
            result.failed = e.getStatus();
        }
        catch (AbortException | CancelException e) {
            result.failed = new Status(IStatus.Severity.ERROR, (Throwable)e);
        }
        catch (Exception e) {
            result.failed = new Status(IStatus.Severity.BUG, (Throwable)e);
        }
        return result;
    }

    private void retract(Integer idPatient, List<ExportData> exported) throws Exception {
        exported.forEach(data -> {
            String dsqPrevPrescriptionId = data.prescription.getDsqPrevPrescriptionId();
            String dsqPrevPrescriptionVersion = data.prescription.getDsqPrevPrescriptionVersion();
            if (dsqPrevPrescriptionId != null && dsqPrevPrescriptionVersion != null) {
                data.retractData = new OERetractController.RetractData();
                data.retractData.prescriptionFormat = XPrescriptionFormatter.getFormattedText(data.prescription, data.prescription.isActiveNow(), CPrescriptionFormatter.ShowMedFileDetail.MAXIMUM);
                data.retractData.prescriptionId = data.prescription.getDsqPrevPrescriptionId();
                data.retractData.prescriptionVersion = data.prescription.getDsqPrevPrescriptionVersion();
            }
        });
        List<OERetractController.RetractData> retractDatas = exported.stream().filter(data -> data.retractData != null).map(data -> data.retractData).collect(Collectors.toList());
        this.retractController.retract4(retractDatas, null);
    }

    private void signToBeApprovedRequest(Signature signature, Alias alias, List<ExportData> exportDatas) throws CancelException, AbortException {
        for (ExportData data : exportDatas) {
            try {
                if (data.status1 != null) {
                    if (!data.status1.isOK() || data.toBeApprovedHash == null) continue;
                    data.approvedHash = this.dsq.getSignatureS(NullProgressMonitor.INSTANCE, alias, data.toBeApprovedHash);
                    continue;
                }
                throw new RuntimeException("no status1 set in data " + data);
            }
            catch (AbortException | CancelException e) {
                throw e;
            }
            catch (Exception e) {
                data.status1 = new Status(IStatus.Severity.ERROR, (Throwable)e);
            }
        }
    }

    private void export1(Signature signature, List<ExportData> datas) throws Exception {
        if (datas == null || datas.size() == 0) {
            throw new NullPointerException("ExportData data");
        }
        if (datas.get((int)0).prescription == null) {
            throw new NullPointerException("datas.get(0).prescription");
        }
        if (datas.get((int)0).prescription.getId() == null) {
            throw new NullPointerException("datas.get(0).prescription.getId()");
        }
        List<Integer> localPrescriptionIds = datas.stream().map(d -> d.prescription.getId()).collect(Collectors.toList());
        ReturnObject response = this.dsqAccessor.exportLocalPrescriptionsToDsq1(signature, this.idPatient, localPrescriptionIds);
        this.dsq.manageDsqStatus(response.getStatus());
        Status status = (Status)response.getObj();
        Map idPrescriptionMapHash = (Map)((Object)status.getData());
        for (Map.Entry entry : idPrescriptionMapHash.entrySet()) {
            Integer idPrescription = (Integer)entry.getKey();
            String hash = (String)entry.getValue();
            for (ExportData exportData : datas) {
                try {
                    if (!exportData.prescription.getId().equals(idPrescription)) continue;
                    exportData.toBeApprovedHash = hash;
                    exportData.status1 = Status.OK_STATUS;
                }
                catch (Exception e2) {
                    exportData.status1 = new Status(IStatus.Severity.BUG, "Failed to export", (Throwable)e2);
                }
            }
        }
        for (ExportData exportData : datas) {
            if (exportData.status1 != null) continue;
            exportData.status1 = new Status(IStatus.Severity.BUG, "Unprocessed export data " + exportData);
        }
    }

    private void export2(Signature signature, List<ExportData> exportDatas) throws StatusException, Exception {
        HashMap<Integer, Signature> mapApprovedRequests = new HashMap<Integer, Signature>(exportDatas.size());
        for (ExportData ed : exportDatas) {
            mapApprovedRequests.put(ed.prescription.getId(), ed.approvedHash);
        }
        ReturnObject response = this.dsqAccessor.exportLocalPrescriptionsToDsq2(signature, this.idPatient, mapApprovedRequests);
        this.dsq.manageDsqStatus(response.getStatus());
    }

    static class ExportData {
        XPrescription prescription;
        String toBeApprovedHash;
        Signature approvedHash;
        IStatus status1;
        OERetractController.RetractData retractData;
        int number;

        ExportData() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.prescription == null ? 0 : this.prescription.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExportData other = (ExportData)obj;
            return !(this.prescription == null ? other.prescription != null : !this.prescription.equals((Object)other.prescription));
        }

        public String toString() {
            return String.format("ExportData [prescription=%s]", this.prescription);
        }
    }

    static class ExportResult {
        IStatus failed;
        List<ExportData> exported = new ArrayList<ExportData>();

        ExportResult() {
        }
    }
}

