/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.gson.impl;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.commons.lang3.math.NumberUtils;

public class EmptyStringToBigDecimalTypeAdapter
extends TypeAdapter<BigDecimal> {
    public void write(JsonWriter jsonWriter, BigDecimal number) throws IOException {
        if (number == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.value((Number)number);
    }

    public BigDecimal read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        try {
            String value = jsonReader.nextString();
            if ("".equals(value)) {
                return null;
            }
            return NumberUtils.createBigDecimal((String)value);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }
}

