/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.convert;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.convert.IConverter;
import ca.infodata.ofys.client.gson.IGsonProcessor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;

public final class StringMapToClassAsJson
implements IConverter<Map, Object> {
    @Override
    public <R> R convert(Map a, Class<R> r) throws Exception {
        if (a == null || a.isEmpty()) {
            return null;
        }
        IGsonProcessor gsonProcessor = Application.get().getGsonProcessor();
        Set entrySet = a.entrySet();
        R rInstance = r.newInstance();
        for (Map.Entry e : entrySet) {
            Field field = r.getField((String)e.getKey());
            Object convertedValue = gsonProcessor.fromJson((String)e.getValue(), field.getType());
            field.set(rInstance, convertedValue);
        }
        return rInstance;
    }

    @Override
    public <T, R> boolean canConvert(T t, Class<R> r) {
        boolean can;
        boolean bl = can = r != null && !r.isEnum() && (t == null || t instanceof Map);
        if (can) {
            Map map = (Map)t;
            Set entrySet = map.entrySet();
            for (Map.Entry e : entrySet) {
                if (e.getValue() == null || e.getValue() instanceof String) continue;
                can = false;
                break;
            }
        }
        return can;
    }
}

