/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public final class FileUtil {
    private static final Logger logger = Logger.getLogger(FileUtil.class.getName());

    private FileUtil() {
        throw new UnsupportedOperationException();
    }

    public static void copyFileRecursive(File in, File out) throws IOException {
        if (in.isDirectory() && out.exists() && !out.isDirectory()) {
            throw new IllegalArgumentException("in " + in + " is a directory and out " + out + " is not");
        }
        if (!in.isDirectory() && out.isDirectory()) {
            throw new IllegalArgumentException("out " + out + " is a directory and in " + in + " is not");
        }
        if (in.isDirectory()) {
            if (!out.exists()) {
                out.mkdir();
            }
            for (File fin : in.listFiles()) {
                File fout = new File(out, fin.getName());
                FileUtil.copyFileRecursive(fin, fout);
            }
        } else {
            if (!out.exists()) {
                out.createNewFile();
            }
            FileUtil.copyFile(in, out);
        }
    }

    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            inChannel = new FileInputStream(in).getChannel();
            outChannel = new FileOutputStream(out).getChannel();
            inChannel.transferTo(0L, inChannel.size(), (WritableByteChannel)((Object)outChannel));
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (inChannel != null) {
                    inChannel.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean strToFile(String f, String s) {
        FileWriter out = null;
        try {
            out = new FileWriter(f);
            ((Writer)out).write(s, 0, s.length());
            ((Writer)out).flush();
        }
        catch (IOException ioProblem) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    ((Writer)out).close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static String[] unzip(byte[] theZipBytes, String destination) {
        return FileUtil.unzip(new ByteArrayInputStream(theZipBytes), destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] unzip(InputStream inputStream, String destination) {
        ZipInputStream zip = null;
        ArrayList<String> lstNames = new ArrayList<String>();
        try {
            ZipEntry item;
            zip = new ZipInputStream(inputStream);
            FileOutputStream outputStream = null;
            while ((item = zip.getNextEntry()) != null) {
                try {
                    int theByte;
                    File file;
                    if (item.isDirectory()) {
                        File newdir = new File(destination, item.getName());
                        newdir.mkdirs();
                        continue;
                    }
                    String toAdd = "";
                    if (item.getName().indexOf("/") > -1) {
                        toAdd = item.getName().substring(0, item.getName().lastIndexOf("/"));
                    }
                    if (!(file = new File(destination, toAdd)).exists()) {
                        file.mkdirs();
                    }
                    outputStream = new FileOutputStream(new File(destination, item.getName()));
                    while ((theByte = zip.read()) > -1) {
                        outputStream.write(theByte);
                    }
                    lstNames.add(item.getName());
                    outputStream.flush();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception on unzip(" + inputStream + ", " + destination + ")", e);
                }
                finally {
                    try {
                        if (outputStream == null) continue;
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "erreur", e);
        }
        finally {
            try {
                inputStream.close();
                zip.close();
            }
            catch (IOException e) {}
        }
        String[] names = new String[lstNames.size()];
        lstNames.toArray(names);
        return names;
    }

    public static String[] unzip(String zipFile, String destination) {
        String[] names = new String[]{};
        try {
            names = FileUtil.unzip(new FileInputStream(zipFile), destination);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "erreur", e);
        }
        return names;
    }

    public static void deleteFile(File file) {
        File[] lstFile = file.listFiles();
        for (int i = 0; i < lstFile.length; ++i) {
            if (lstFile[i].isDirectory()) {
                FileUtil.deleteFile(lstFile[i]);
                continue;
            }
            lstFile[i].delete();
        }
        file.delete();
    }

    public static boolean renameFile(String from, String to) {
        boolean b = false;
        File f = new File(from);
        if (!f.exists()) {
            return b;
        }
        File ft = new File(to);
        if (ft.exists()) {
            b = ft.delete();
        }
        if (b) {
            b = f.renameTo(ft);
        }
        return b;
    }

    public static boolean renameFile(File f, File ft) {
        boolean b = false;
        if (!f.exists()) {
            return b;
        }
        b = ft.exists() ? ft.delete() : true;
        if (b) {
            b = f.renameTo(ft);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileAsByteArray(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
        }
        finally {
            fis.close();
        }
        byte[] bytes = bos.toByteArray();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File file) throws IOException {
        FileReader reader = new FileReader(file);
        StringWriter writer = new StringWriter((int)file.length());
        char[] buf = new char[1024];
        try {
            int readNum;
            while ((readNum = reader.read(buf)) != -1) {
                writer.write(buf, 0, readNum);
            }
        }
        finally {
            reader.close();
        }
        return writer.toString();
    }

    public static byte[] readImage(File file) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(file);
        byte[] b = new byte[(int)file.length()];
        iis.readFully(b);
        iis.close();
        return b;
    }
}

