/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import ca.infodata.util1.RangeNotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class FastLongRange {
    public static final long NULL = Long.MIN_VALUE;
    private volatile int hashCodeCache;
    private long start;
    private long end;
    private RangeNotation notation;

    public FastLongRange() {
        this(Long.MIN_VALUE, Long.MIN_VALUE, null);
    }

    public FastLongRange(RangeNotation notation) {
        this(Long.MIN_VALUE, Long.MIN_VALUE, notation);
    }

    public FastLongRange(long start, long end, RangeNotation notation) {
        this.start = start;
        this.end = end;
        this.notation = notation;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
        this.hashCodeCache = Integer.MIN_VALUE;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
        this.hashCodeCache = Integer.MIN_VALUE;
    }

    public RangeNotation getNotation() {
        return this.notation;
    }

    public void setNotation(RangeNotation notation) {
        this.notation = notation;
        this.hashCodeCache = Integer.MIN_VALUE;
    }

    public void valid() {
        if (this.notation == null) {
            throw new IllegalArgumentException("notation cant be null");
        }
        if (this.start != Long.MIN_VALUE && this.end != Long.MIN_VALUE) {
            long compareTo = this.start - this.end;
            if (compareTo > 0L) {
                throw new IllegalArgumentException("start must be lower than or equals to end");
            }
            switch (this.notation) {
                case LEFT_CLOSED: 
                case RIGHT_CLOSED: 
                case OPEN: {
                    if (compareTo != 0L) break;
                    throw new IllegalArgumentException("with LEFT_CLOSED, RIGHT_CLOSED or OPEN notation, start cant be equals to end");
                }
            }
        }
        if (this.start != Long.MIN_VALUE && this.end != Long.MIN_VALUE && this.notation == RangeNotation.OPEN && this.start + 1L == this.end) {
            throw new IllegalArgumentException("]n,n+1[ is invalid. was " + this);
        }
    }

    public boolean contains(long other) {
        this.valid();
        return this.inRange(other, this.start, this.end, this.notation);
    }

    public String toString() {
        String starts = this.start == Long.MIN_VALUE ? "" : String.valueOf(this.start);
        String ends = this.end == Long.MIN_VALUE ? "" : String.valueOf(this.end);
        switch (this.notation) {
            case OPEN: {
                return String.format("]%s...%s[", starts, ends);
            }
            case CLOSED: {
                return String.format("[%s...%s]", starts, ends);
            }
            case LEFT_CLOSED: {
                return String.format("[%s...%s[", starts, ends);
            }
            case RIGHT_CLOSED: {
                return String.format("]%s...%s]", starts, ends);
            }
        }
        return super.toString();
    }

    public List<FastLongRange> remove(FastLongRange range) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        if (this.intersect(range)) {
            FastLongRange r;
            long start1 = this.toClosedStart(this.start, this.notation);
            long end1 = this.toClosedEnd(this.end, this.notation);
            long start2 = this.toClosedStart(range.start, range.notation);
            long end2 = this.toClosedEnd(range.end, range.notation);
            if (start2 == Long.MIN_VALUE && end2 == Long.MIN_VALUE) {
                return Collections.emptyList();
            }
            if (start2 == Long.MIN_VALUE) {
                return Arrays.asList(new FastLongRange(end2, end1, end1 == Long.MIN_VALUE ? RangeNotation.OPEN : RangeNotation.RIGHT_CLOSED));
            }
            if (end2 == Long.MIN_VALUE) {
                return Arrays.asList(new FastLongRange(start1, start2, start1 == Long.MIN_VALUE ? RangeNotation.OPEN : RangeNotation.LEFT_CLOSED));
            }
            if (start1 == Long.MIN_VALUE && end1 == Long.MIN_VALUE) {
                FastLongRange r1 = new FastLongRange(Long.MIN_VALUE, start2, RangeNotation.OPEN);
                FastLongRange r2 = new FastLongRange(end2, Long.MIN_VALUE, RangeNotation.OPEN);
                return Arrays.asList(r1, r2);
            }
            if (start1 == Long.MIN_VALUE) {
                ArrayList<FastLongRange> list = new ArrayList<FastLongRange>(2);
                FastLongRange r1 = new FastLongRange(Long.MIN_VALUE, start2, RangeNotation.OPEN);
                list.add(r1);
                if (end1 > end2) {
                    FastLongRange r2 = new FastLongRange(end2, end1, RangeNotation.RIGHT_CLOSED);
                    list.add(r2);
                }
                return list;
            }
            if (end1 == Long.MIN_VALUE) {
                ArrayList<FastLongRange> list = new ArrayList<FastLongRange>(2);
                FastLongRange r1 = new FastLongRange(end2, Long.MIN_VALUE, RangeNotation.OPEN);
                list.add(r1);
                if (start1 < start2) {
                    FastLongRange r2 = new FastLongRange(start1, start2, RangeNotation.LEFT_CLOSED);
                    list.add(r2);
                }
                return list;
            }
            ArrayList<FastLongRange> list = new ArrayList<FastLongRange>(2);
            if (start1 < start2) {
                r = new FastLongRange(start1, start2, RangeNotation.LEFT_CLOSED);
                list.add(r);
            }
            if (end1 > end2) {
                r = new FastLongRange(end2, end1, RangeNotation.RIGHT_CLOSED);
                list.add(r);
            }
            return list;
        }
        return Arrays.asList(this);
    }

    public boolean intersect(FastLongRange range) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        long start1 = this.toClosedStart(this.start, this.notation);
        long end1 = this.toClosedEnd(this.end, this.notation);
        long start2 = this.toClosedStart(range.start, range.notation);
        long end2 = this.toClosedEnd(range.end, range.notation);
        return start1 == Long.MIN_VALUE && end1 == Long.MIN_VALUE && start2 == Long.MIN_VALUE && end2 == Long.MIN_VALUE || this.inRange(start2, start1, end1, RangeNotation.CLOSED) || this.inRange(end2, start1, end1, RangeNotation.CLOSED) || this.inRange(start1, start2, end2, RangeNotation.CLOSED) || this.inRange(end1, start2, end2, RangeNotation.CLOSED);
    }

    private boolean inRange(long value, long lowerLimit, long upperLimit, RangeNotation notation) {
        if (value == Long.MIN_VALUE) {
            return false;
        }
        if (lowerLimit == Long.MIN_VALUE) {
            return true;
        }
        if (upperLimit == Long.MIN_VALUE) {
            return true;
        }
        return notation.inRange(value, lowerLimit, upperLimit);
    }

    public FastLongRange merge(FastLongRange range) {
        long newStart;
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        long start1 = this.toClosedStart(this.start, this.notation);
        long end1 = this.toClosedEnd(this.end, this.notation);
        long start2 = this.toClosedStart(range.start, range.notation);
        long end2 = this.toClosedEnd(range.end, range.notation);
        if (start1 == Long.MIN_VALUE || start2 == Long.MIN_VALUE) {
            newStart = Long.MIN_VALUE;
        } else {
            long l = newStart = start1 < start2 ? start1 : start2;
        }
        long newEnd = end1 == Long.MIN_VALUE || end2 == Long.MIN_VALUE ? Long.MIN_VALUE : (end1 > end2 ? end1 : end2);
        return new FastLongRange(newStart, newEnd, RangeNotation.CLOSED);
    }

    private long toClosedEnd(long end, RangeNotation notation) {
        if (end == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        switch (notation) {
            case RIGHT_CLOSED: 
            case CLOSED: {
                return end;
            }
            case LEFT_CLOSED: 
            case OPEN: {
                return end - 1L;
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    private long toClosedStart(long start, RangeNotation notation) {
        if (start == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        switch (notation) {
            case LEFT_CLOSED: 
            case CLOSED: {
                return start;
            }
            case RIGHT_CLOSED: 
            case OPEN: {
                return start + 1L;
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    public int hashCode() {
        if (this.hashCodeCache == Integer.MIN_VALUE) {
            int prime = 31;
            int result = 1;
            long start = this.toClosedStart(this.start, this.notation);
            long end = this.toClosedEnd(this.end, this.notation);
            result = (int)((long)(31 * result) + (end == Long.MIN_VALUE ? 0L : end));
            result = (int)((long)(31 * result) + (start == Long.MIN_VALUE ? 0L : start));
            this.hashCodeCache = result = 31 * result + RangeNotation.CLOSED.hashCode();
        }
        return this.hashCodeCache;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }
}

