/*
 * Decompiled with CFR 0.152.
 */
package parser;

import ca.infodata.readhl7.MessageHandler;
import ca.infodata.readhl7.UtilDateUtilities;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.model.v23.message.ORU_R01;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PATHL7Handler
implements MessageHandler {
    Logger logger = Logger.getLogger(PATHL7Handler.class.getName());
    ORU_R01 msg = null;

    @Override
    public void init(String hl7Body) throws HL7Exception {
        PipeParser p = new PipeParser();
        ((Parser)p).setValidationContext(new NoValidation());
        this.msg = (ORU_R01)((Parser)p).parse(hl7Body.replaceAll("\n", "\r\n"));
    }

    @Override
    public String getMsgType() {
        return "PATHL7";
    }

    @Override
    public String getMsgPriority() {
        return "";
    }

    @Override
    public String getMsgDate() {
        return this.formatDateTime(this.getString(this.msg.getMSH().getDateTimeOfMessage().getTimeOfAnEvent().getValue()));
    }

    @Override
    public String getPatientName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    @Override
    public String getFirstName() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPatientName()[0].getGivenName().getValue());
    }

    @Override
    public String getLastName() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPatientName()[0].getGivenName().getValue());
    }

    @Override
    public String getDOB() {
        try {
            return this.formatDateTime(this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getDateOfBirth().getTimeOfAnEvent().getValue())).substring(0, 10);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getAge() {
        String age = "N/A";
        String dob = this.getDOB();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date date = formatter.parse(dob);
            String serviceD = this.getServiceDate();
            Date serviceDate = null;
            if (serviceD != null && (serviceDate = UtilDateUtilities.StringToDate(serviceD)) == null) {
                serviceDate = UtilDateUtilities.getDateFromString(serviceD, "yyyy-MM-dd");
            }
            age = UtilDateUtilities.calcAgeAtDate(date, serviceDate);
        }
        catch (ParseException e) {
            this.logger.log(Level.SEVERE, "Could not get age", e);
        }
        return age;
    }

    @Override
    public String getSex() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getSex().getValue());
    }

    @Override
    public String getHealthNum() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPatientIDExternalID().getID().getValue());
    }

    @Override
    public String getFileNum() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPid2_PatientIDExternalID().getID().getValue());
    }

    @Override
    public String getHomePhone() {
        String phone = "";
        int i = 0;
        try {
            while (!this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue()).equals("")) {
                phone = i == 0 ? this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue()) : phone + ", " + this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue());
                ++i;
            }
            return phone;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return phone number", e);
            return "";
        }
    }

    @Override
    public String getWorkPhone() {
        String phone = "";
        int i = 0;
        try {
            while (!this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue()).equals("")) {
                phone = i == 0 ? this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue()) : phone + ", " + this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue());
                ++i;
            }
            return phone;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return phone number", e);
            return "";
        }
    }

    @Override
    public String getPatientLocation() {
        return this.getString(this.msg.getMSH().getSendingFacility().getNamespaceID().getValue());
    }

    @Override
    public String getAccessionNum() {
        try {
            String str = this.msg.getRESPONSE().getORDER_OBSERVATION(0).getORC().getFillerOrderNumber().getEntityIdentifier().getValue();
            String accessionNum = this.getString(str);
            String[] nums = accessionNum.split("-");
            if (nums.length == 3) {
                return nums[0];
            }
            if (nums.length == 5) {
                return nums[0] + "-" + nums[1] + "-" + nums[2];
            }
            if (nums.length > 1) {
                return nums[1];
            }
            return "";
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return accession number", e);
            return "";
        }
    }

    @Override
    public int getOBRCount() {
        return this.msg.getRESPONSE().getORDER_OBSERVATIONReps();
    }

    @Override
    public String getOBRName(int i) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBR().getUniversalServiceIdentifier().getText().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getObservationHeader(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBR().getDiagnosticServiceSectionID().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public int getOBRCommentCount(int i) {
        try {
            if (!this.getOBRComment(i, 0).equals("")) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String getOBRComment(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getNTE(j).getComment(0).getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getServiceDate() {
        try {
            return this.formatDateTime(this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getObservationDateTime().getTimeOfAnEvent().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOrderStatus() {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getResultStatus().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getClientRef() {
        String docNum = "";
        int i = 0;
        try {
            while (!this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i).getIDNumber().getValue()).equals("")) {
                docNum = i == 0 ? this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i).getIDNumber().getValue()) : docNum + ", " + this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i).getIDNumber().getValue());
                ++i;
            }
            return docNum;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor id numbers", e);
            return "";
        }
    }

    @Override
    public String getDocName() {
        String docName = "";
        int i = 0;
        try {
            while (!this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i)).equals("")) {
                docName = i == 0 ? this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i)) : docName + ", " + this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i));
                ++i;
            }
            return docName;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor names", e);
            return "";
        }
    }

    @Override
    public String getCCDocs() {
        String docName = "";
        int i = 0;
        try {
            while (!this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i)).equals("")) {
                docName = i == 0 ? this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i)) : docName + ", " + this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i));
                ++i;
            }
            return docName;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return cc'ed doctors", e);
            return "";
        }
    }

    @Override
    public ArrayList<String> getDocNums() {
        ArrayList<String> docNums = new ArrayList<String>();
        try {
            String id;
            String providerId = this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(0).getIDNumber().getValue();
            docNums.add(providerId);
            int i = 0;
            while ((id = this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i).getIDNumber().getValue()) != null) {
                if (!id.equals(providerId)) {
                    docNums.add(id);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor nums", e);
        }
        return docNums;
    }

    @Override
    public int getOBXCount(int i) {
        int count = 0;
        try {
            count = this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATIONReps();
            if (count == 1) {
                String test = this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(0).getOBX().getObservationIdentifier().getText().getValue();
                this.logger.info("name: " + test);
                if (test == null) {
                    count = 0;
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx count", e);
            count = 0;
        }
        return count;
    }

    @Override
    public String getOBXIdentifier(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getIdentifier().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXValueType(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getValueType().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXName(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getText().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXResult(int i, int j) {
        try {
            return this.getString(Terser.get(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, 0, 1, 1));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXReferenceRange(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getReferencesRange().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXUnits(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getUnits().getIdentifier().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXResultStatus(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservResultStatus().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public int getOBXFinalResultCount() {
        int obrCount = this.getOBRCount();
        int count = 0;
        for (int i = 0; i < obrCount; ++i) {
            int obxCount = this.getOBXCount(i);
            for (int j = 0; j < obxCount; ++j) {
                String status = this.getOBXResultStatus(i, j);
                if (!status.equalsIgnoreCase("F") && !status.equalsIgnoreCase("C")) continue;
                ++count;
            }
        }
        String orderStatus = this.getOrderStatus();
        if (orderStatus.equalsIgnoreCase("F")) {
            count += 100;
        } else if (orderStatus.equalsIgnoreCase("C")) {
            count += 150;
        }
        return count;
    }

    @Override
    public String getTimeStamp(int i, int j) {
        try {
            return this.formatDateTime(this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getDateTimeOfTheObservation().getTimeOfAnEvent().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean isOBXAbnormal(int i, int j) {
        try {
            String abnormalFlag = this.getOBXAbnormalFlag(i, j);
            return !abnormalFlag.equals("") && !abnormalFlag.equalsIgnoreCase("N");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getOBXAbnormalFlag(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getAbnormalFlags(0).getValue());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx abnormal flag", e);
            return "";
        }
    }

    @Override
    public int getOBXCommentCount(int i, int j) {
        try {
            if (!this.getOBXComment(i, j, 0).equals("")) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String getOBXComment(int i, int j, int k) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE(k).getComment(0).getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        try {
            for (int i = 0; i < this.msg.getRESPONSE().getORDER_OBSERVATIONReps(); ++i) {
                String currentHeader = this.getObservationHeader(i, 0);
                int arraySize = headers.size();
                if (arraySize != 0 && currentHeader.equals(headers.get(arraySize - 1))) continue;
                headers.add(currentHeader);
            }
            return headers;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not create header list", e);
            return null;
        }
    }

    @Override
    public String audit() {
        return "";
    }

    private String getFullDocName(XCN docSeg) {
        String docName = "";
        if (docSeg.getPrefixEgDR().getValue() != null) {
            docName = docSeg.getPrefixEgDR().getValue();
        }
        if (docSeg.getGivenName().getValue() != null) {
            docName = docName.equals("") ? docSeg.getGivenName().getValue() : docName + " " + docSeg.getGivenName().getValue();
        }
        if (docSeg.getMiddleInitialOrName().getValue() != null) {
            docName = docName + " " + docSeg.getMiddleInitialOrName().getValue();
        }
        if (docSeg.getFamilyName().getValue() != null) {
            docName = docName + " " + docSeg.getFamilyName().getValue();
        }
        if (docSeg.getSuffixEgJRorIII().getValue() != null) {
            docName = docName + " " + docSeg.getSuffixEgJRorIII().getValue();
        }
        if (docSeg.getDegreeEgMD().getValue() != null) {
            docName = docName + " " + docSeg.getDegreeEgMD().getValue();
        }
        return docName;
    }

    private String formatDateTime(String plain) {
        String dateFormat = "yyyyMMddHHmmss";
        dateFormat = dateFormat.substring(0, plain.length());
        String stringFormat = "yyyy-MM-dd HH:mm:ss";
        stringFormat = stringFormat.substring(0, stringFormat.lastIndexOf(dateFormat.charAt(dateFormat.length() - 1)) + 1);
        Date date = UtilDateUtilities.StringToDate(plain, dateFormat);
        return UtilDateUtilities.DateToString(date, stringFormat);
    }

    private String getString(String retrieve) {
        if (retrieve != null) {
            return retrieve.trim().replaceAll("\\\\\\.br\\\\", "<br />");
        }
        return "";
    }

    @Override
    public String getPrelDate() {
        return null;
    }

    @Override
    public String getOBRSpecimen(int i) {
        return null;
    }

    @Override
    public String getOBXEquipment(int i, int j) {
        return null;
    }

    @Override
    public String getOBXUserCheck(int i, int j) {
        return null;
    }

    @Override
    public String getSpecimenName(int j) {
        return null;
    }

    @Override
    public String[] getDspLines() {
        return null;
    }

    @Override
    public String getPdfFromObx55(int j) {
        return null;
    }

    @Override
    public String getPerformingOrganisation(int i, int j) {
        return null;
    }

    @Override
    public String getOBXLoincIdentifier(int i, int j) {
        return null;
    }
}

