/*
 * Decompiled with CFR 0.152.
 */
package parser;

import ca.infodata.readhl7.MessageHandler;
import ca.infodata.readhl7.UtilDateUtilities;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.datatype.FT;
import ca.uhn.hl7v2.model.v24.message.OUL_R21;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OUL_R21Handler
implements MessageHandler {
    Logger logger = Logger.getLogger(OUL_R21Handler.class.getName());
    protected OUL_R21 msg = null;
    protected Terser terser;

    @Override
    public void init(String hl7Body) throws HL7Exception {
        PipeParser p = new PipeParser();
        ((Parser)p).setValidationContext(new NoValidation());
        this.msg = (OUL_R21)((Parser)p).parse(hl7Body.replaceAll("\n", "\r\n"));
        this.terser = new Terser(this.msg);
    }

    @Override
    public String getMsgType() {
        return "OUL_21";
    }

    @Override
    public String getMsgPriority() {
        return "";
    }

    @Override
    public String getMsgDate() {
        return this.formatDateTime(this.getString(this.msg.getMSH().getDateTimeOfMessage().getTimeOfAnEvent().getValue()));
    }

    @Override
    public String getPatientName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    @Override
    public String getFirstName() {
        return this.getString(this.msg.getPATIENT().getPID().getPatientName()[0].getGivenName().getValue());
    }

    @Override
    public String getLastName() {
        try {
            return this.getString(this.terser.get("/.PID-5-1"));
        }
        catch (HL7Exception ex) {
            return "";
        }
    }

    @Override
    public String getDOB() {
        try {
            return this.formatDateTime(this.getString(this.msg.getPATIENT().getPID().getDateTimeOfBirth().getTimeOfAnEvent().getValue())).substring(0, 10);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getAge() {
        String age = "N/A";
        String dob = this.getDOB();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date date = formatter.parse(dob);
            String serviceD = this.getServiceDate();
            Date serviceDate = null;
            if (serviceD != null && (serviceDate = UtilDateUtilities.StringToDate(serviceD)) == null) {
                serviceDate = UtilDateUtilities.getDateFromString(serviceD, "yyyy-MM-dd");
            }
            age = UtilDateUtilities.calcAgeAtDate(date, serviceDate);
        }
        catch (ParseException e) {
            this.logger.log(Level.SEVERE, "Could not get age", e);
        }
        return age;
    }

    @Override
    public String getSex() {
        return this.getString(this.msg.getPATIENT().getPID().getAdministrativeSex().getValue());
    }

    @Override
    public String getHealthNum() {
        try {
            String healthNum = this.getString(this.terser.get("/.PID-2-1"));
            if (healthNum.length() == 12 && !healthNum.startsWith("0")) {
                return healthNum;
            }
            healthNum = this.getString(this.terser.get("/.PID-4-1"));
            if (healthNum.length() == 12 && !healthNum.startsWith("0")) {
                return healthNum;
            }
            healthNum = this.getString(this.terser.get("/.PID-3-1"));
            if (healthNum.length() == 12 && !healthNum.startsWith("0")) {
                return healthNum;
            }
            healthNum = this.getString(this.terser.get("/.PID-19-1"));
            if (healthNum.length() == 12 && !healthNum.startsWith("0")) {
                return healthNum;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public String getFileNum() {
        return "";
    }

    @Override
    public String getHomePhone() {
        String phone = "";
        int i = 0;
        try {
            while (!this.getString(this.msg.getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue()).equals("")) {
                phone = i == 0 ? this.getString(this.msg.getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue()) : phone + ", " + this.getString(this.msg.getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue());
                ++i;
            }
            return phone;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return phone number", e);
            return "";
        }
    }

    @Override
    public String getWorkPhone() {
        String phone = "";
        int i = 0;
        try {
            while (!this.getString(this.msg.getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue()).equals("")) {
                phone = i == 0 ? this.getString(this.msg.getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue()) : phone + ", " + this.getString(this.msg.getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue());
                ++i;
            }
            return phone;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return phone number", e);
            return "";
        }
    }

    public String getDocAddr1() {
        return this.getString(this.msg.getORDER_OBSERVATION().getOBR().getOrderingProvider()[0].getAssigningFacility().getUniversalID().getValue());
    }

    @Override
    public String getPatientLocation() {
        return this.getString(this.msg.getMSH().getSendingFacility().getNamespaceID().getValue());
    }

    @Override
    public String getAccessionNum() {
        String accessionNum = null;
        try {
            accessionNum = this.getString(this.msg.getORDER_OBSERVATION(0).getOBR().getFillerOrderNumber().getEntityIdentifier().getValue());
            if (accessionNum != "") {
                if (accessionNum.indexOf("-") != -1) {
                    return accessionNum.substring(0, accessionNum.indexOf("-"));
                }
                return accessionNum;
            }
            for (int j = 1; j < this.getOBRCount(); ++j) {
                accessionNum = this.getString(this.msg.getORDER_OBSERVATION(j).getOBR().getFillerOrderNumber().getEntityIdentifier().getValue());
                if (accessionNum == "") continue;
                return accessionNum.substring(0, accessionNum.indexOf("-"));
            }
            if ((accessionNum == null || accessionNum.isEmpty()) && (accessionNum = this.msg.getORDER_OBSERVATION(0).getORC().getFillerOrderNumber().getEntityIdentifier().getValue()) != "") {
                return accessionNum;
            }
            return "";
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return accession number: " + accessionNum, e);
            return "";
        }
    }

    @Override
    public int getOBRCount() {
        return this.msg.getORDER_OBSERVATIONReps();
    }

    @Override
    public String getOBRName(int i) {
        try {
            return this.getString(this.msg.getORDER_OBSERVATION(i).getOBR().getUniversalServiceIdentifier().getText().getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getObservationHeader(int i, int j) {
        try {
            return this.getString(this.msg.getORDER_OBSERVATION(i).getOBR().getDiagnosticServSectID().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public int getOBRCommentCount(int i) {
        try {
            if (!this.getOBRComment(i, 0).equals("")) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String getOBRComment(int i, int j) {
        try {
            FT[] comments = this.msg.getORDER_OBSERVATION(i).getNTE().getComment();
            StringBuilder obxComment = new StringBuilder();
            for (FT ft : comments) {
                String s = ft.getValue();
                if (s != null && s.length() != 0 && s.length() > 80) {
                    s = this.getTextMaxLength(s, 80);
                }
                obxComment.append(s).append("\n");
            }
            obxComment.delete(obxComment.length() - 1, obxComment.length());
            return obxComment.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getServiceDate() {
        try {
            return this.formatDateTime(this.getString(this.msg.getORDER_OBSERVATION(0).getOBR().getObr8_ObservationEndDateTime().getTimeOfAnEvent().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOrderStatus() {
        try {
            return this.getString(this.msg.getORDER_OBSERVATION(0).getOBR().getResultStatus().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getClientRef() {
        String docNum = "";
        int i = 0;
        try {
            while (!this.getString(this.msg.getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i).getIDNumber().getValue()).equals("")) {
                docNum = i == 0 ? this.getString(this.msg.getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i).getIDNumber().getValue()) : docNum + ", " + this.getString(this.msg.getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i).getIDNumber().getValue());
                ++i;
            }
            return docNum;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor id numbers", e);
            return "";
        }
    }

    @Override
    public String getDocName() {
        try {
            return this.getFullDocName("/.OBR-16-");
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getCCDocs() {
        try {
            int i = 0;
            String docs = this.getFullDocName("/.OBR-28(" + i + ")-");
            String nextDoc = this.getFullDocName("/.OBR-28(" + ++i + ")-");
            while (!nextDoc.equals("")) {
                docs = docs + ", " + nextDoc;
                nextDoc = this.getFullDocName("/.OBR-28(" + ++i + ")-");
            }
            return docs;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public ArrayList<String> getDocNums() {
        ArrayList<String> nums = new ArrayList<String>();
        try {
            String docNum = this.terser.get("/.OBR-16-1");
            if (docNum != null) {
                nums.add(docNum);
            }
            int i = 0;
            while ((docNum = this.terser.get("/.OBR-28(" + i + ")-1")) != null) {
                nums.add(docNum);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nums;
    }

    @Override
    public int getOBXCount(int i) {
        int count = 0;
        try {
            count = this.msg.getORDER_OBSERVATION(i).getOBSERVATIONReps();
            if (count == 1) {
                String test = this.msg.getORDER_OBSERVATION(i).getOBSERVATION(0).getOBX().getObservationIdentifier().getText().getValue();
                this.logger.info("name: " + test);
                if (test == null) {
                    count = 0;
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx count", e);
            count = 0;
        }
        return count;
    }

    @Override
    public String getOBXIdentifier(int i, int j) {
        try {
            return this.getString(this.msg.getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getIdentifier().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXValueType(int i, int j) {
        try {
            return this.getString(this.msg.getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getValueType().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXName(int i, int j) {
        try {
            return this.getString(this.msg.getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getText().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXResult(int i, int j) {
        try {
            StringBuilder sb = new StringBuilder();
            int m = this.msg.getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationValue().length;
            for (int k = 0; k < m; ++k) {
                String s = Terser.get(this.msg.getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, k, 1, 1);
                String ss = Terser.get(this.msg.getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, k, 2, 1);
                if (ss != null) {
                    s = ss;
                }
                if (s == null) continue;
                if (s.length() > 80) {
                    s = this.getTextMaxLength(s, 80);
                }
                sb.append(sb.length() == 0 ? s : "\n" + s);
            }
            String ss = sb.toString();
            return ss;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXReferenceRange(int i, int j) {
        try {
            return this.getString(this.msg.getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getReferencesRange().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXUnits(int i, int j) {
        try {
            return this.getString(this.msg.getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getUnits().getIdentifier().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXResultStatus(int i, int j) {
        try {
            return this.getString(this.msg.getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationResultStatus().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public int getOBXFinalResultCount() {
        int obrCount = this.getOBRCount();
        int count = 0;
        for (int i = 0; i < obrCount; ++i) {
            int obxCount = this.getOBXCount(i);
            for (int j = 0; j < obxCount; ++j) {
                String status = this.getOBXResultStatus(i, j);
                if (!status.equalsIgnoreCase("F") && !status.equalsIgnoreCase("C")) continue;
                ++count;
            }
        }
        String orderStatus = this.getOrderStatus();
        if (orderStatus.equalsIgnoreCase("F")) {
            count += 100;
        } else if (orderStatus.equalsIgnoreCase("C")) {
            count += 150;
        }
        return count;
    }

    @Override
    public String getTimeStamp(int i, int j) {
        try {
            return this.formatDateTime(this.getString(this.msg.getORDER_OBSERVATION(i).getOBR().getObservationDateTime().getTimeOfAnEvent().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean isOBXAbnormal(int i, int j) {
        try {
            String abnormalFlag = this.getOBXAbnormalFlag(i, j);
            return !abnormalFlag.equals("") && !abnormalFlag.equalsIgnoreCase("N");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getOBXAbnormalFlag(int i, int j) {
        try {
            return this.getString(this.msg.getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getAbnormalFlags().getValue());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx abnormal flag", e);
            return "";
        }
    }

    public int getOBXCommentCountOld(int i, int j) {
        try {
            Structure[] nteSegs;
            int count = 0;
            for (Structure nteSeg : nteSegs = this.terser.getFinder().getRoot().getAll("NTE")) {
                System.out.println(nteSeg);
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "OBR Comment count error", e);
            return 0;
        }
    }

    @Override
    public int getOBXCommentCount(int i, int j) {
        try {
            if (!this.getOBXComment(i, j, 0).equals("")) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String getTextMaxLength(String t, int width) {
        String[] mots = t.split(" ");
        String line = "";
        StringBuffer lineTemp = new StringBuffer();
        StringBuffer ss = new StringBuffer();
        for (String element : mots) {
            lineTemp.append(element).append(" ");
            if (lineTemp.length() < width - 2) {
                line = lineTemp.toString();
                continue;
            }
            ss.append(line).append("\n");
            lineTemp = new StringBuffer(element).append(" ");
            line = lineTemp.toString();
        }
        if (line.length() > 0) {
            ss.append(line);
        }
        return ss.toString().length() > 0 ? ss.toString() : "NO DATA";
    }

    @Override
    public String getOBXComment(int i, int j, int nteNum) {
        try {
            FT[] comments = this.msg.getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE(nteNum).getComment();
            StringBuilder obxComment = new StringBuilder();
            for (FT ft : comments) {
                String s = ft.getValue();
                obxComment.append(s);
            }
            return obxComment.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        try {
            for (int i = 0; i < this.msg.getORDER_OBSERVATIONReps(); ++i) {
                String currentHeader = this.getObservationHeader(i, 0);
                int arraySize = headers.size();
                if (arraySize != 0 && currentHeader.equals(headers.get(arraySize - 1))) continue;
                headers.add(currentHeader);
            }
            return headers;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not create header list", e);
            return null;
        }
    }

    @Override
    public String audit() {
        return "";
    }

    private String getFullDocName(String docSeg) throws HL7Exception {
        String docName = "";
        String temp = this.terser.get(docSeg + "6");
        if (temp != null) {
            docName = temp;
        }
        if ((temp = this.terser.get(docSeg + "3")) != null) {
            docName = docName.equals("") ? temp : docName + " " + temp;
        }
        if (this.terser.get(docSeg + "4") != null) {
            docName = docName + " " + this.terser.get(docSeg + "4");
        }
        if (this.terser.get(docSeg + "2") != null) {
            docName = docName + " " + this.terser.get(docSeg + "2");
        }
        if (this.terser.get(docSeg + "5") != null) {
            docName = docName + " " + this.terser.get(docSeg + "5");
        }
        if (this.terser.get(docSeg + "7") != null) {
            docName = docName + " " + this.terser.get(docSeg + "7");
        }
        return docName;
    }

    private String formatDateTime(String plain) {
        if (plain == null) {
            return null;
        }
        String dateFormat = "yyyyMMddHHmmss";
        dateFormat = dateFormat.substring(0, plain.length());
        String stringFormat = "yyyy-MM-dd HH:mm:ss";
        stringFormat = stringFormat.substring(0, stringFormat.lastIndexOf(dateFormat.charAt(dateFormat.length() - 1)) + 1);
        Date date = UtilDateUtilities.StringToDate(plain, dateFormat);
        return UtilDateUtilities.DateToString(date, stringFormat);
    }

    private String getString(String retrieve) {
        if (retrieve != null) {
            return retrieve.trim().replaceAll("\\\\\\.br\\\\", "<br />");
        }
        return "";
    }

    @Override
    public String getPrelDate() {
        try {
            return this.formatDateTime(this.getString(this.msg.getORDER_OBSERVATION(0).getOBR().getObservationDateTime().getTimeOfAnEvent().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBRSpecimen(int i) {
        return null;
    }

    @Override
    public String getOBXEquipment(int i, int j) {
        return null;
    }

    @Override
    public String getOBXUserCheck(int i, int j) {
        return null;
    }

    @Override
    public String getSpecimenName(int j) {
        return null;
    }

    @Override
    public String[] getDspLines() {
        return null;
    }

    @Override
    public String getPdfFromObx55(int j) {
        return null;
    }

    @Override
    public String getPerformingOrganisation(int i, int j) {
        return null;
    }

    @Override
    public String getOBXLoincIdentifier(int i, int j) {
        return null;
    }
}

