/*
 * Decompiled with CFR 0.152.
 */
package org.ga.log.ro;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DebugLevel {
    public static final DebugLevel L1_FATAL = new DebugLevel(1, "Fatal");
    public static final DebugLevel L2_ERROR = new DebugLevel(2, "Error");
    public static final DebugLevel L3_WARN = new DebugLevel(3, "Warn");
    public static final DebugLevel L4_INFO = new DebugLevel(4, "Info");
    public static final DebugLevel L5_DEBUG = new DebugLevel(5, "Debug");
    public static final DebugLevel L6_VERBOSE = new DebugLevel(6, "Verbose");
    public static final DebugLevel L7_LUDICROUS = new DebugLevel(7, "Ludicrous");
    static final DebugLevel FAKE_TRACE = new DebugLevel(Integer.MAX_VALUE, "Trace");
    private static final Map<String, DebugLevel> levelsByName;
    private final int level;
    private final String name;

    private DebugLevel(int level, String name) {
        this.level = level;
        this.name = name;
    }

    boolean shouldLog(DebugLevel logLevel) {
        return logLevel.level <= this.level;
    }

    public static DebugLevel fromInt(int level) {
        switch (level) {
            case 1: {
                return L1_FATAL;
            }
            case 2: {
                return L2_ERROR;
            }
            case 3: {
                return L3_WARN;
            }
            case 4: {
                return L4_INFO;
            }
            case 5: {
                return L5_DEBUG;
            }
            case 6: {
                return L6_VERBOSE;
            }
            case 7: {
                return L7_LUDICROUS;
            }
        }
        if (level < 1) {
            return L1_FATAL;
        }
        return L7_LUDICROUS;
    }

    static DebugLevel fromName(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        DebugLevel level = levelsByName.get(name.toLowerCase());
        if (level == null) {
            throw new IllegalArgumentException("Unrecognised DebugLevel name: '" + name + "'");
        }
        return level;
    }

    public int hashCode() {
        return this.level;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        return this.level == ((DebugLevel)o).level;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, DebugLevel> levels = new HashMap<String, DebugLevel>(10, 0.8f);
        levels.put("fatal", L1_FATAL);
        levels.put("error", L2_ERROR);
        levels.put("warn", L3_WARN);
        levels.put("info", L4_INFO);
        levels.put("debug", L5_DEBUG);
        levels.put("verbose", L6_VERBOSE);
        levels.put("ludicrous", L7_LUDICROUS);
        levelsByName = Collections.unmodifiableMap(levels);
    }
}

