/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CNE;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.CX;
import ca.uhn.hl7v2.model.v281.datatype.DT;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.EI;
import ca.uhn.hl7v2.model.v281.datatype.EIP;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.NULLDT;
import ca.uhn.hl7v2.model.v281.datatype.PL;
import ca.uhn.hl7v2.model.v281.datatype.XAD;
import ca.uhn.hl7v2.model.v281.datatype.XCN;
import ca.uhn.hl7v2.model.v281.datatype.XON;
import ca.uhn.hl7v2.model.v281.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ORC
extends AbstractSegment {
    public ORC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 0, new Object[]{this.getMessage(), new Integer(119)}, "Order Control");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Placer Order Number");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Filler Order Number");
            this.add(EIP.class, false, 1, 0, new Object[]{this.getMessage()}, "Placer Group Number");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(38)}, "Order Status");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(121)}, "Response Flag");
            this.add(NULLDT.class, false, 0, 0, new Object[]{this.getMessage()}, "Deliver-To Location");
            this.add(EIP.class, false, 1, 0, new Object[]{this.getMessage()}, "Parent Order");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Date/Time of Transaction");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Entered By");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Verified By");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Ordering Provider");
            this.add(PL.class, false, 1, 0, new Object[]{this.getMessage()}, "Enterer's Location");
            this.add(XTN.class, false, 2, 0, new Object[]{this.getMessage()}, "Call Back Phone Number");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Order Effective Date/Time");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Order Control Code Reason");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Entering Organization");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Entering Device");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Action By");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Advanced Beneficiary Notice Code");
            this.add(XON.class, false, 0, 0, new Object[]{this.getMessage()}, "Ordering Facility Name");
            this.add(XAD.class, false, 0, 0, new Object[]{this.getMessage()}, "Ordering Facility Address");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Ordering Facility Phone Number");
            this.add(XAD.class, false, 0, 0, new Object[]{this.getMessage()}, "Ordering Provider Address");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Order Status Modifier");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Advanced Beneficiary Notice Override Reason");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Filler's Expected Availability Date/Time");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Confidentiality Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Order Type");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Enterer Authorization Mode");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Parent Universal Service Identifier");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Advanced Beneficiary Notice Date");
            this.add(CX.class, false, 0, 0, new Object[]{this.getMessage()}, "Alternate Placer Order Number");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Order Workflow Profile");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORC - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getOrderControl() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getOrc1_OrderControl() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPlacerOrderNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getOrc2_PlacerOrderNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getFillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getOrc3_FillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EIP getPlacerGroupNumber() {
        EIP retVal = (EIP)this.getTypedField(4, 0);
        return retVal;
    }

    public EIP getOrc4_PlacerGroupNumber() {
        EIP retVal = (EIP)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getOrderStatus() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getOrc5_OrderStatus() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getResponseFlag() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getOrc6_ResponseFlag() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public NULLDT[] getDeliverToLocation() {
        NULLDT[] retVal = (NULLDT[])this.getTypedField(7, new NULLDT[0]);
        return retVal;
    }

    public NULLDT[] getOrc7_DeliverToLocation() {
        NULLDT[] retVal = (NULLDT[])this.getTypedField(7, new NULLDT[0]);
        return retVal;
    }

    public int getDeliverToLocationReps() {
        return this.getReps(7);
    }

    public NULLDT getDeliverToLocation(int rep) {
        NULLDT retVal = (NULLDT)this.getTypedField(7, rep);
        return retVal;
    }

    public NULLDT getOrc7_DeliverToLocation(int rep) {
        NULLDT retVal = (NULLDT)this.getTypedField(7, rep);
        return retVal;
    }

    public int getOrc7_DeliverToLocationReps() {
        return this.getReps(7);
    }

    public NULLDT insertDeliverToLocation(int rep) throws HL7Exception {
        return (NULLDT)super.insertRepetition(7, rep);
    }

    public NULLDT insertOrc7_DeliverToLocation(int rep) throws HL7Exception {
        return (NULLDT)super.insertRepetition(7, rep);
    }

    public NULLDT removeDeliverToLocation(int rep) throws HL7Exception {
        return (NULLDT)super.removeRepetition(7, rep);
    }

    public NULLDT removeOrc7_DeliverToLocation(int rep) throws HL7Exception {
        return (NULLDT)super.removeRepetition(7, rep);
    }

    public EIP getParentOrder() {
        EIP retVal = (EIP)this.getTypedField(8, 0);
        return retVal;
    }

    public EIP getOrc8_ParentOrder() {
        EIP retVal = (EIP)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getDateTimeOfTransaction() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public DTM getOrc9_DateTimeOfTransaction() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public XCN[] getEnteredBy() {
        XCN[] retVal = (XCN[])this.getTypedField(10, new XCN[0]);
        return retVal;
    }

    public XCN[] getOrc10_EnteredBy() {
        XCN[] retVal = (XCN[])this.getTypedField(10, new XCN[0]);
        return retVal;
    }

    public int getEnteredByReps() {
        return this.getReps(10);
    }

    public XCN getEnteredBy(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public XCN getOrc10_EnteredBy(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public int getOrc10_EnteredByReps() {
        return this.getReps(10);
    }

    public XCN insertEnteredBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN insertOrc10_EnteredBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN removeEnteredBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public XCN removeOrc10_EnteredBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public XCN[] getVerifiedBy() {
        XCN[] retVal = (XCN[])this.getTypedField(11, new XCN[0]);
        return retVal;
    }

    public XCN[] getOrc11_VerifiedBy() {
        XCN[] retVal = (XCN[])this.getTypedField(11, new XCN[0]);
        return retVal;
    }

    public int getVerifiedByReps() {
        return this.getReps(11);
    }

    public XCN getVerifiedBy(int rep) {
        XCN retVal = (XCN)this.getTypedField(11, rep);
        return retVal;
    }

    public XCN getOrc11_VerifiedBy(int rep) {
        XCN retVal = (XCN)this.getTypedField(11, rep);
        return retVal;
    }

    public int getOrc11_VerifiedByReps() {
        return this.getReps(11);
    }

    public XCN insertVerifiedBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(11, rep);
    }

    public XCN insertOrc11_VerifiedBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(11, rep);
    }

    public XCN removeVerifiedBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(11, rep);
    }

    public XCN removeOrc11_VerifiedBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(11, rep);
    }

    public XCN[] getOrderingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(12, new XCN[0]);
        return retVal;
    }

    public XCN[] getOrc12_OrderingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(12, new XCN[0]);
        return retVal;
    }

    public int getOrderingProviderReps() {
        return this.getReps(12);
    }

    public XCN getOrderingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(12, rep);
        return retVal;
    }

    public XCN getOrc12_OrderingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(12, rep);
        return retVal;
    }

    public int getOrc12_OrderingProviderReps() {
        return this.getReps(12);
    }

    public XCN insertOrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(12, rep);
    }

    public XCN insertOrc12_OrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(12, rep);
    }

    public XCN removeOrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(12, rep);
    }

    public XCN removeOrc12_OrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(12, rep);
    }

    public PL getEntererSLocation() {
        PL retVal = (PL)this.getTypedField(13, 0);
        return retVal;
    }

    public PL getOrc13_EntererSLocation() {
        PL retVal = (PL)this.getTypedField(13, 0);
        return retVal;
    }

    public XTN[] getCallBackPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(14, new XTN[0]);
        return retVal;
    }

    public XTN[] getOrc14_CallBackPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(14, new XTN[0]);
        return retVal;
    }

    public int getCallBackPhoneNumberReps() {
        return this.getReps(14);
    }

    public XTN getCallBackPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(14, rep);
        return retVal;
    }

    public XTN getOrc14_CallBackPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getOrc14_CallBackPhoneNumberReps() {
        return this.getReps(14);
    }

    public XTN insertCallBackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(14, rep);
    }

    public XTN insertOrc14_CallBackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(14, rep);
    }

    public XTN removeCallBackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(14, rep);
    }

    public XTN removeOrc14_CallBackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(14, rep);
    }

    public DTM getOrderEffectiveDateTime() {
        DTM retVal = (DTM)this.getTypedField(15, 0);
        return retVal;
    }

    public DTM getOrc15_OrderEffectiveDateTime() {
        DTM retVal = (DTM)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getOrderControlCodeReason() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getOrc16_OrderControlCodeReason() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getEnteringOrganization() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getOrc17_EnteringOrganization() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getEnteringDevice() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getOrc18_EnteringDevice() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public XCN[] getActionBy() {
        XCN[] retVal = (XCN[])this.getTypedField(19, new XCN[0]);
        return retVal;
    }

    public XCN[] getOrc19_ActionBy() {
        XCN[] retVal = (XCN[])this.getTypedField(19, new XCN[0]);
        return retVal;
    }

    public int getActionByReps() {
        return this.getReps(19);
    }

    public XCN getActionBy(int rep) {
        XCN retVal = (XCN)this.getTypedField(19, rep);
        return retVal;
    }

    public XCN getOrc19_ActionBy(int rep) {
        XCN retVal = (XCN)this.getTypedField(19, rep);
        return retVal;
    }

    public int getOrc19_ActionByReps() {
        return this.getReps(19);
    }

    public XCN insertActionBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(19, rep);
    }

    public XCN insertOrc19_ActionBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(19, rep);
    }

    public XCN removeActionBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(19, rep);
    }

    public XCN removeOrc19_ActionBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(19, rep);
    }

    public CWE getAdvancedBeneficiaryNoticeCode() {
        CWE retVal = (CWE)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getOrc20_AdvancedBeneficiaryNoticeCode() {
        CWE retVal = (CWE)this.getTypedField(20, 0);
        return retVal;
    }

    public XON[] getOrderingFacilityName() {
        XON[] retVal = (XON[])this.getTypedField(21, new XON[0]);
        return retVal;
    }

    public XON[] getOrc21_OrderingFacilityName() {
        XON[] retVal = (XON[])this.getTypedField(21, new XON[0]);
        return retVal;
    }

    public int getOrderingFacilityNameReps() {
        return this.getReps(21);
    }

    public XON getOrderingFacilityName(int rep) {
        XON retVal = (XON)this.getTypedField(21, rep);
        return retVal;
    }

    public XON getOrc21_OrderingFacilityName(int rep) {
        XON retVal = (XON)this.getTypedField(21, rep);
        return retVal;
    }

    public int getOrc21_OrderingFacilityNameReps() {
        return this.getReps(21);
    }

    public XON insertOrderingFacilityName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(21, rep);
    }

    public XON insertOrc21_OrderingFacilityName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(21, rep);
    }

    public XON removeOrderingFacilityName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(21, rep);
    }

    public XON removeOrc21_OrderingFacilityName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(21, rep);
    }

    public XAD[] getOrderingFacilityAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(22, new XAD[0]);
        return retVal;
    }

    public XAD[] getOrc22_OrderingFacilityAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(22, new XAD[0]);
        return retVal;
    }

    public int getOrderingFacilityAddressReps() {
        return this.getReps(22);
    }

    public XAD getOrderingFacilityAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(22, rep);
        return retVal;
    }

    public XAD getOrc22_OrderingFacilityAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(22, rep);
        return retVal;
    }

    public int getOrc22_OrderingFacilityAddressReps() {
        return this.getReps(22);
    }

    public XAD insertOrderingFacilityAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(22, rep);
    }

    public XAD insertOrc22_OrderingFacilityAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(22, rep);
    }

    public XAD removeOrderingFacilityAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(22, rep);
    }

    public XAD removeOrc22_OrderingFacilityAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(22, rep);
    }

    public XTN[] getOrderingFacilityPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(23, new XTN[0]);
        return retVal;
    }

    public XTN[] getOrc23_OrderingFacilityPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(23, new XTN[0]);
        return retVal;
    }

    public int getOrderingFacilityPhoneNumberReps() {
        return this.getReps(23);
    }

    public XTN getOrderingFacilityPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(23, rep);
        return retVal;
    }

    public XTN getOrc23_OrderingFacilityPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(23, rep);
        return retVal;
    }

    public int getOrc23_OrderingFacilityPhoneNumberReps() {
        return this.getReps(23);
    }

    public XTN insertOrderingFacilityPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(23, rep);
    }

    public XTN insertOrc23_OrderingFacilityPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(23, rep);
    }

    public XTN removeOrderingFacilityPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(23, rep);
    }

    public XTN removeOrc23_OrderingFacilityPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(23, rep);
    }

    public XAD[] getOrderingProviderAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(24, new XAD[0]);
        return retVal;
    }

    public XAD[] getOrc24_OrderingProviderAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(24, new XAD[0]);
        return retVal;
    }

    public int getOrderingProviderAddressReps() {
        return this.getReps(24);
    }

    public XAD getOrderingProviderAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(24, rep);
        return retVal;
    }

    public XAD getOrc24_OrderingProviderAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(24, rep);
        return retVal;
    }

    public int getOrc24_OrderingProviderAddressReps() {
        return this.getReps(24);
    }

    public XAD insertOrderingProviderAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(24, rep);
    }

    public XAD insertOrc24_OrderingProviderAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(24, rep);
    }

    public XAD removeOrderingProviderAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(24, rep);
    }

    public XAD removeOrc24_OrderingProviderAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(24, rep);
    }

    public CWE getOrderStatusModifier() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getOrc25_OrderStatusModifier() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getAdvancedBeneficiaryNoticeOverrideReason() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getOrc26_AdvancedBeneficiaryNoticeOverrideReason() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public DTM getFillerSExpectedAvailabilityDateTime() {
        DTM retVal = (DTM)this.getTypedField(27, 0);
        return retVal;
    }

    public DTM getOrc27_FillerSExpectedAvailabilityDateTime() {
        DTM retVal = (DTM)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getConfidentialityCode() {
        CWE retVal = (CWE)this.getTypedField(28, 0);
        return retVal;
    }

    public CWE getOrc28_ConfidentialityCode() {
        CWE retVal = (CWE)this.getTypedField(28, 0);
        return retVal;
    }

    public CWE getOrderType() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getOrc29_OrderType() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public CNE getEntererAuthorizationMode() {
        CNE retVal = (CNE)this.getTypedField(30, 0);
        return retVal;
    }

    public CNE getOrc30_EntererAuthorizationMode() {
        CNE retVal = (CNE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getParentUniversalServiceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE getOrc31_ParentUniversalServiceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public DT getAdvancedBeneficiaryNoticeDate() {
        DT retVal = (DT)this.getTypedField(32, 0);
        return retVal;
    }

    public DT getOrc32_AdvancedBeneficiaryNoticeDate() {
        DT retVal = (DT)this.getTypedField(32, 0);
        return retVal;
    }

    public CX[] getAlternatePlacerOrderNumber() {
        CX[] retVal = (CX[])this.getTypedField(33, new CX[0]);
        return retVal;
    }

    public CX[] getOrc33_AlternatePlacerOrderNumber() {
        CX[] retVal = (CX[])this.getTypedField(33, new CX[0]);
        return retVal;
    }

    public int getAlternatePlacerOrderNumberReps() {
        return this.getReps(33);
    }

    public CX getAlternatePlacerOrderNumber(int rep) {
        CX retVal = (CX)this.getTypedField(33, rep);
        return retVal;
    }

    public CX getOrc33_AlternatePlacerOrderNumber(int rep) {
        CX retVal = (CX)this.getTypedField(33, rep);
        return retVal;
    }

    public int getOrc33_AlternatePlacerOrderNumberReps() {
        return this.getReps(33);
    }

    public CX insertAlternatePlacerOrderNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(33, rep);
    }

    public CX insertOrc33_AlternatePlacerOrderNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(33, rep);
    }

    public CX removeAlternatePlacerOrderNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(33, rep);
    }

    public CX removeOrc33_AlternatePlacerOrderNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(33, rep);
    }

    public CWE[] getOrderWorkflowProfile() {
        CWE[] retVal = (CWE[])this.getTypedField(34, new CWE[0]);
        return retVal;
    }

    public CWE[] getOrc34_OrderWorkflowProfile() {
        CWE[] retVal = (CWE[])this.getTypedField(34, new CWE[0]);
        return retVal;
    }

    public int getOrderWorkflowProfileReps() {
        return this.getReps(34);
    }

    public CWE getOrderWorkflowProfile(int rep) {
        CWE retVal = (CWE)this.getTypedField(34, rep);
        return retVal;
    }

    public CWE getOrc34_OrderWorkflowProfile(int rep) {
        CWE retVal = (CWE)this.getTypedField(34, rep);
        return retVal;
    }

    public int getOrc34_OrderWorkflowProfileReps() {
        return this.getReps(34);
    }

    public CWE insertOrderWorkflowProfile(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(34, rep);
    }

    public CWE insertOrc34_OrderWorkflowProfile(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(34, rep);
    }

    public CWE removeOrderWorkflowProfile(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(34, rep);
    }

    public CWE removeOrc34_OrderWorkflowProfile(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(34, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(119));
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new EIP(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(38));
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(121));
            }
            case 6: {
                return new NULLDT(this.getMessage());
            }
            case 7: {
                return new EIP(this.getMessage());
            }
            case 8: {
                return new DTM(this.getMessage());
            }
            case 9: {
                return new XCN(this.getMessage());
            }
            case 10: {
                return new XCN(this.getMessage());
            }
            case 11: {
                return new XCN(this.getMessage());
            }
            case 12: {
                return new PL(this.getMessage());
            }
            case 13: {
                return new XTN(this.getMessage());
            }
            case 14: {
                return new DTM(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new XCN(this.getMessage());
            }
            case 19: {
                return new CWE(this.getMessage());
            }
            case 20: {
                return new XON(this.getMessage());
            }
            case 21: {
                return new XAD(this.getMessage());
            }
            case 22: {
                return new XTN(this.getMessage());
            }
            case 23: {
                return new XAD(this.getMessage());
            }
            case 24: {
                return new CWE(this.getMessage());
            }
            case 25: {
                return new CWE(this.getMessage());
            }
            case 26: {
                return new DTM(this.getMessage());
            }
            case 27: {
                return new CWE(this.getMessage());
            }
            case 28: {
                return new CWE(this.getMessage());
            }
            case 29: {
                return new CNE(this.getMessage());
            }
            case 30: {
                return new CWE(this.getMessage());
            }
            case 31: {
                return new DT(this.getMessage());
            }
            case 32: {
                return new CX(this.getMessage());
            }
            case 33: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

