/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v281.segment.DSC;
import ca.uhn.hl7v2.model.v281.segment.DSP;
import ca.uhn.hl7v2.model.v281.segment.ERR;
import ca.uhn.hl7v2.model.v281.segment.MSA;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.QAK;
import ca.uhn.hl7v2.model.v281.segment.QPD;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RDY_Z80
extends AbstractMessage {
    public RDY_Z80() {
        this(new DefaultModelClassFactory());
    }

    public RDY_Z80(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QAK.class, true, false);
            this.add(QPD.class, true, false);
            this.add(DSP.class, false, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RDY_Z80 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public QAK getQAK() {
        return this.getTyped("QAK", QAK.class);
    }

    public QPD getQPD() {
        return this.getTyped("QPD", QPD.class);
    }

    public DSP getDSP() {
        return this.getTyped("DSP", DSP.class);
    }

    public DSP getDSP(int rep) {
        return this.getTyped("DSP", rep, DSP.class);
    }

    public int getDSPReps() {
        return this.getReps("DSP");
    }

    public List<DSP> getDSPAll() throws HL7Exception {
        return this.getAllAsList("DSP", DSP.class);
    }

    public void insertDSP(DSP structure, int rep) throws HL7Exception {
        super.insertRepetition("DSP", structure, rep);
    }

    public DSP insertDSP(int rep) throws HL7Exception {
        return (DSP)super.insertRepetition("DSP", rep);
    }

    public DSP removeDSP(int rep) throws HL7Exception {
        return (DSP)super.removeRepetition("DSP", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

