/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v281.group.PEX_P07_EXPERIENCE;
import ca.uhn.hl7v2.model.v281.group.PEX_P07_VISIT;
import ca.uhn.hl7v2.model.v281.segment.ARV;
import ca.uhn.hl7v2.model.v281.segment.EVN;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.NTE;
import ca.uhn.hl7v2.model.v281.segment.PD1;
import ca.uhn.hl7v2.model.v281.segment.PID;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PEX_P07
extends AbstractMessage {
    public PEX_P07() {
        this(new DefaultModelClassFactory());
    }

    public PEX_P07(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(PRT.class, false, true);
            this.add(ARV.class, false, true);
            this.add(NTE.class, false, true);
            this.add(PEX_P07_VISIT.class, false, false);
            this.add(PEX_P07_EXPERIENCE.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PEX_P07 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return this.getTyped("PD1", PD1.class);
    }

    public PRT getPRT() {
        return this.getTyped("PRT", PRT.class);
    }

    public PRT getPRT(int rep) {
        return this.getTyped("PRT", rep, PRT.class);
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ARV getARV() {
        return this.getTyped("ARV", ARV.class);
    }

    public ARV getARV(int rep) {
        return this.getTyped("ARV", rep, ARV.class);
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public PEX_P07_VISIT getVISIT() {
        return this.getTyped("VISIT", PEX_P07_VISIT.class);
    }

    public PEX_P07_EXPERIENCE getEXPERIENCE() {
        return this.getTyped("EXPERIENCE", PEX_P07_EXPERIENCE.class);
    }

    public PEX_P07_EXPERIENCE getEXPERIENCE(int rep) {
        return this.getTyped("EXPERIENCE", rep, PEX_P07_EXPERIENCE.class);
    }

    public int getEXPERIENCEReps() {
        return this.getReps("EXPERIENCE");
    }

    public List<PEX_P07_EXPERIENCE> getEXPERIENCEAll() throws HL7Exception {
        return this.getAllAsList("EXPERIENCE", PEX_P07_EXPERIENCE.class);
    }

    public void insertEXPERIENCE(PEX_P07_EXPERIENCE structure, int rep) throws HL7Exception {
        super.insertRepetition("EXPERIENCE", structure, rep);
    }

    public PEX_P07_EXPERIENCE insertEXPERIENCE(int rep) throws HL7Exception {
        return (PEX_P07_EXPERIENCE)super.insertRepetition("EXPERIENCE", rep);
    }

    public PEX_P07_EXPERIENCE removeEXPERIENCE(int rep) throws HL7Exception {
        return (PEX_P07_EXPERIENCE)super.removeRepetition("EXPERIENCE", rep);
    }
}

