/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v281.group.OML_O33_PATIENT;
import ca.uhn.hl7v2.model.v281.group.OML_O33_SPECIMEN;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.NTE;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OML_O33
extends AbstractMessage {
    public OML_O33() {
        this(new DefaultModelClassFactory());
    }

    public OML_O33(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(NTE.class, false, true);
            this.add(OML_O33_PATIENT.class, false, false);
            this.add(OML_O33_SPECIMEN.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OML_O33 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OML_O33_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", OML_O33_PATIENT.class);
    }

    public OML_O33_SPECIMEN getSPECIMEN() {
        return this.getTyped("SPECIMEN", OML_O33_SPECIMEN.class);
    }

    public OML_O33_SPECIMEN getSPECIMEN(int rep) {
        return this.getTyped("SPECIMEN", rep, OML_O33_SPECIMEN.class);
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<OML_O33_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", OML_O33_SPECIMEN.class);
    }

    public void insertSPECIMEN(OML_O33_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", structure, rep);
    }

    public OML_O33_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (OML_O33_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public OML_O33_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (OML_O33_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

