/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v281.group.MFN_M17_MF_DRG;
import ca.uhn.hl7v2.model.v281.segment.MFI;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M17
extends AbstractMessage {
    public MFN_M17() {
        this(new DefaultModelClassFactory());
    }

    public MFN_M17(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M17_MF_DRG.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M17 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public MFI getMFI() {
        return this.getTyped("MFI", MFI.class);
    }

    public MFN_M17_MF_DRG getMF_DRG() {
        return this.getTyped("MF_DRG", MFN_M17_MF_DRG.class);
    }

    public MFN_M17_MF_DRG getMF_DRG(int rep) {
        return this.getTyped("MF_DRG", rep, MFN_M17_MF_DRG.class);
    }

    public int getMF_DRGReps() {
        return this.getReps("MF_DRG");
    }

    public List<MFN_M17_MF_DRG> getMF_DRGAll() throws HL7Exception {
        return this.getAllAsList("MF_DRG", MFN_M17_MF_DRG.class);
    }

    public void insertMF_DRG(MFN_M17_MF_DRG structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_DRG", structure, rep);
    }

    public MFN_M17_MF_DRG insertMF_DRG(int rep) throws HL7Exception {
        return (MFN_M17_MF_DRG)super.insertRepetition("MF_DRG", rep);
    }

    public MFN_M17_MF_DRG removeMF_DRG(int rep) throws HL7Exception {
        return (MFN_M17_MF_DRG)super.removeRepetition("MF_DRG", rep);
    }
}

