/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v281.segment.ARV;
import ca.uhn.hl7v2.model.v281.segment.NTE;
import ca.uhn.hl7v2.model.v281.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORN_O08_PATIENT
extends AbstractGroup {
    public ORN_O08_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(ARV.class, false, true, false);
            this.add(NTE.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORN_O08_PATIENT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public ARV getARV() {
        ARV retVal = this.getTyped("ARV", ARV.class);
        return retVal;
    }

    public ARV getARV(int rep) {
        ARV retVal = this.getTyped("ARV", rep, ARV.class);
        return retVal;
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

