/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v281.group.OML_O21_OBSERVATION;
import ca.uhn.hl7v2.model.v281.group.OML_O21_PRIOR_RESULT;
import ca.uhn.hl7v2.model.v281.group.OML_O21_SPECIMEN;
import ca.uhn.hl7v2.model.v281.segment.CTD;
import ca.uhn.hl7v2.model.v281.segment.DG1;
import ca.uhn.hl7v2.model.v281.segment.NTE;
import ca.uhn.hl7v2.model.v281.segment.OBR;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.model.v281.segment.TCD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OML_O21_OBSERVATION_REQUEST
extends AbstractGroup {
    public OML_O21_OBSERVATION_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(TCD.class, false, false, false);
            this.add(NTE.class, false, true, false);
            this.add(PRT.class, false, true, false);
            this.add(CTD.class, false, false, false);
            this.add(DG1.class, false, true, false);
            this.add(OML_O21_OBSERVATION.class, false, true, false);
            this.add(OML_O21_SPECIMEN.class, false, true, false);
            this.add(OML_O21_PRIOR_RESULT.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OML_O21_OBSERVATION_REQUEST - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public TCD getTCD() {
        TCD retVal = this.getTyped("TCD", TCD.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public CTD getCTD() {
        CTD retVal = this.getTyped("CTD", CTD.class);
        return retVal;
    }

    public DG1 getDG1() {
        DG1 retVal = this.getTyped("DG1", DG1.class);
        return retVal;
    }

    public DG1 getDG1(int rep) {
        DG1 retVal = this.getTyped("DG1", rep, DG1.class);
        return retVal;
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public OML_O21_OBSERVATION getOBSERVATION() {
        OML_O21_OBSERVATION retVal = this.getTyped("OBSERVATION", OML_O21_OBSERVATION.class);
        return retVal;
    }

    public OML_O21_OBSERVATION getOBSERVATION(int rep) {
        OML_O21_OBSERVATION retVal = this.getTyped("OBSERVATION", rep, OML_O21_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<OML_O21_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", OML_O21_OBSERVATION.class);
    }

    public void insertOBSERVATION(OML_O21_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public OML_O21_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (OML_O21_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public OML_O21_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (OML_O21_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public OML_O21_SPECIMEN getSPECIMEN() {
        OML_O21_SPECIMEN retVal = this.getTyped("SPECIMEN", OML_O21_SPECIMEN.class);
        return retVal;
    }

    public OML_O21_SPECIMEN getSPECIMEN(int rep) {
        OML_O21_SPECIMEN retVal = this.getTyped("SPECIMEN", rep, OML_O21_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<OML_O21_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", OML_O21_SPECIMEN.class);
    }

    public void insertSPECIMEN(OML_O21_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", structure, rep);
    }

    public OML_O21_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (OML_O21_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public OML_O21_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (OML_O21_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }

    public OML_O21_PRIOR_RESULT getPRIOR_RESULT() {
        OML_O21_PRIOR_RESULT retVal = this.getTyped("PRIOR_RESULT", OML_O21_PRIOR_RESULT.class);
        return retVal;
    }

    public OML_O21_PRIOR_RESULT getPRIOR_RESULT(int rep) {
        OML_O21_PRIOR_RESULT retVal = this.getTyped("PRIOR_RESULT", rep, OML_O21_PRIOR_RESULT.class);
        return retVal;
    }

    public int getPRIOR_RESULTReps() {
        return this.getReps("PRIOR_RESULT");
    }

    public List<OML_O21_PRIOR_RESULT> getPRIOR_RESULTAll() throws HL7Exception {
        return this.getAllAsList("PRIOR_RESULT", OML_O21_PRIOR_RESULT.class);
    }

    public void insertPRIOR_RESULT(OML_O21_PRIOR_RESULT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRIOR_RESULT", structure, rep);
    }

    public OML_O21_PRIOR_RESULT insertPRIOR_RESULT(int rep) throws HL7Exception {
        return (OML_O21_PRIOR_RESULT)super.insertRepetition("PRIOR_RESULT", rep);
    }

    public OML_O21_PRIOR_RESULT removePRIOR_RESULT(int rep) throws HL7Exception {
        return (OML_O21_PRIOR_RESULT)super.removeRepetition("PRIOR_RESULT", rep);
    }
}

