/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v281.segment.CDM;
import ca.uhn.hl7v2.model.v281.segment.MFE;
import ca.uhn.hl7v2.model.v281.segment.NTE;
import ca.uhn.hl7v2.model.v281.segment.PRC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M04_MF_CDM
extends AbstractGroup {
    public MFN_M04_MF_CDM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(CDM.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(PRC.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M04_MF_CDM - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public MFE getMFE() {
        MFE retVal = this.getTyped("MFE", MFE.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public CDM getCDM() {
        CDM retVal = this.getTyped("CDM", CDM.class);
        return retVal;
    }

    public NTE getNTE2() {
        NTE retVal = this.getTyped("NTE2", NTE.class);
        return retVal;
    }

    public NTE getNTE2(int rep) {
        NTE retVal = this.getTyped("NTE2", rep, NTE.class);
        return retVal;
    }

    public int getNTE2Reps() {
        return this.getReps("NTE2");
    }

    public List<NTE> getNTE2All() throws HL7Exception {
        return this.getAllAsList("NTE2", NTE.class);
    }

    public void insertNTE2(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE2", structure, rep);
    }

    public NTE insertNTE2(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE2", rep);
    }

    public NTE removeNTE2(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE2", rep);
    }

    public PRC getPRC() {
        PRC retVal = this.getTyped("PRC", PRC.class);
        return retVal;
    }

    public PRC getPRC(int rep) {
        PRC retVal = this.getTyped("PRC", rep, PRC.class);
        return retVal;
    }

    public int getPRCReps() {
        return this.getReps("PRC");
    }

    public List<PRC> getPRCAll() throws HL7Exception {
        return this.getAllAsList("PRC", PRC.class);
    }

    public void insertPRC(PRC structure, int rep) throws HL7Exception {
        super.insertRepetition("PRC", structure, rep);
    }

    public PRC insertPRC(int rep) throws HL7Exception {
        return (PRC)super.insertRepetition("PRC", rep);
    }

    public PRC removePRC(int rep) throws HL7Exception {
        return (PRC)super.removeRepetition("PRC", rep);
    }
}

