/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v281.group.CQU_I19_GOAL_OBSERVATION;
import ca.uhn.hl7v2.model.v281.group.CQU_I19_ROLE_GOAL;
import ca.uhn.hl7v2.model.v281.segment.GOL;
import ca.uhn.hl7v2.model.v281.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CQU_I19_GOAL
extends AbstractGroup {
    public CQU_I19_GOAL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(GOL.class, true, false, false);
            this.add(VAR.class, false, true, false);
            this.add(CQU_I19_ROLE_GOAL.class, false, true, false);
            this.add(CQU_I19_GOAL_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CQU_I19_GOAL - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public GOL getGOL() {
        GOL retVal = this.getTyped("GOL", GOL.class);
        return retVal;
    }

    public VAR getVAR() {
        VAR retVal = this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public CQU_I19_ROLE_GOAL getROLE_GOAL() {
        CQU_I19_ROLE_GOAL retVal = this.getTyped("ROLE_GOAL", CQU_I19_ROLE_GOAL.class);
        return retVal;
    }

    public CQU_I19_ROLE_GOAL getROLE_GOAL(int rep) {
        CQU_I19_ROLE_GOAL retVal = this.getTyped("ROLE_GOAL", rep, CQU_I19_ROLE_GOAL.class);
        return retVal;
    }

    public int getROLE_GOALReps() {
        return this.getReps("ROLE_GOAL");
    }

    public List<CQU_I19_ROLE_GOAL> getROLE_GOALAll() throws HL7Exception {
        return this.getAllAsList("ROLE_GOAL", CQU_I19_ROLE_GOAL.class);
    }

    public void insertROLE_GOAL(CQU_I19_ROLE_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROLE_GOAL", structure, rep);
    }

    public CQU_I19_ROLE_GOAL insertROLE_GOAL(int rep) throws HL7Exception {
        return (CQU_I19_ROLE_GOAL)super.insertRepetition("ROLE_GOAL", rep);
    }

    public CQU_I19_ROLE_GOAL removeROLE_GOAL(int rep) throws HL7Exception {
        return (CQU_I19_ROLE_GOAL)super.removeRepetition("ROLE_GOAL", rep);
    }

    public CQU_I19_GOAL_OBSERVATION getGOAL_OBSERVATION() {
        CQU_I19_GOAL_OBSERVATION retVal = this.getTyped("GOAL_OBSERVATION", CQU_I19_GOAL_OBSERVATION.class);
        return retVal;
    }

    public CQU_I19_GOAL_OBSERVATION getGOAL_OBSERVATION(int rep) {
        CQU_I19_GOAL_OBSERVATION retVal = this.getTyped("GOAL_OBSERVATION", rep, CQU_I19_GOAL_OBSERVATION.class);
        return retVal;
    }

    public int getGOAL_OBSERVATIONReps() {
        return this.getReps("GOAL_OBSERVATION");
    }

    public List<CQU_I19_GOAL_OBSERVATION> getGOAL_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("GOAL_OBSERVATION", CQU_I19_GOAL_OBSERVATION.class);
    }

    public void insertGOAL_OBSERVATION(CQU_I19_GOAL_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_OBSERVATION", structure, rep);
    }

    public CQU_I19_GOAL_OBSERVATION insertGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (CQU_I19_GOAL_OBSERVATION)super.insertRepetition("GOAL_OBSERVATION", rep);
    }

    public CQU_I19_GOAL_OBSERVATION removeGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (CQU_I19_GOAL_OBSERVATION)super.removeRepetition("GOAL_OBSERVATION", rep);
    }
}

