/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.EI;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.NULLDT;
import ca.uhn.hl7v2.model.v28.datatype.PL;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.model.v28.datatype.XAD;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXG
extends AbstractSegment {
    public RXG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Give Sub-ID Counter");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense Sub-ID Counter");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Quantity/Timing");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Give Code");
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Give Amount - Minimum");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Amount - Maximum");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Give Units");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Dosage Form");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Administration Notes");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(167)}, "Substitution Status");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense-to Location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Needs Human Review");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Special Administration Instructions");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Per (Time Unit)");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Rate Amount");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Rate Units");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Strength");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Strength Units");
            this.add(ST.class, false, 0, 0, new Object[]{this.getMessage()}, "Substance Lot Number");
            this.add(DTM.class, false, 0, 0, new Object[]{this.getMessage()}, "Substance Expiration Date");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Substance Manufacturer Name");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Indication");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Drug Strength Volume");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Drug Strength Volume Units");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Barcode Identifier");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(480)}, "Pharmacy Order Type");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense to Pharmacy");
            this.add(XAD.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense to Pharmacy Address");
            this.add(PL.class, false, 1, 0, new Object[]{this.getMessage()}, "Deliver-to Patient Location");
            this.add(XAD.class, false, 1, 0, new Object[]{this.getMessage()}, "Deliver-to Address");
            this.add(EI.class, false, 0, 0, new Object[]{this.getMessage()}, "Give Tag Identifier");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense Amount");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense Units");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXG - this is probably a bug in the source code generator.", e);
        }
    }

    public NM getGiveSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getRxg1_GiveSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getDispenseSubIDCounter() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getRxg2_DispenseSubIDCounter() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NULLDT getQuantityTiming() {
        NULLDT retVal = (NULLDT)this.getTypedField(3, 0);
        return retVal;
    }

    public NULLDT getRxg3_QuantityTiming() {
        NULLDT retVal = (NULLDT)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getGiveCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getRxg4_GiveCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getGiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getRxg5_GiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getGiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getRxg6_GiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getGiveUnits() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getRxg7_GiveUnits() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getGiveDosageForm() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getRxg8_GiveDosageForm() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE[] getAdministrationNotes() {
        CWE[] retVal = (CWE[])this.getTypedField(9, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxg9_AdministrationNotes() {
        CWE[] retVal = (CWE[])this.getTypedField(9, new CWE[0]);
        return retVal;
    }

    public int getAdministrationNotesReps() {
        return this.getReps(9);
    }

    public CWE getAdministrationNotes(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public CWE getRxg9_AdministrationNotes(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getRxg9_AdministrationNotesReps() {
        return this.getReps(9);
    }

    public CWE insertAdministrationNotes(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE insertRxg9_AdministrationNotes(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE removeAdministrationNotes(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE removeRxg9_AdministrationNotes(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public ID getSubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getRxg10_SubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public NULLDT getDispenseToLocation() {
        NULLDT retVal = (NULLDT)this.getTypedField(11, 0);
        return retVal;
    }

    public NULLDT getRxg11_DispenseToLocation() {
        NULLDT retVal = (NULLDT)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getNeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getRxg12_NeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE[] getSpecialAdministrationInstructions() {
        CWE[] retVal = (CWE[])this.getTypedField(13, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxg13_SpecialAdministrationInstructions() {
        CWE[] retVal = (CWE[])this.getTypedField(13, new CWE[0]);
        return retVal;
    }

    public int getSpecialAdministrationInstructionsReps() {
        return this.getReps(13);
    }

    public CWE getSpecialAdministrationInstructions(int rep) {
        CWE retVal = (CWE)this.getTypedField(13, rep);
        return retVal;
    }

    public CWE getRxg13_SpecialAdministrationInstructions(int rep) {
        CWE retVal = (CWE)this.getTypedField(13, rep);
        return retVal;
    }

    public int getRxg13_SpecialAdministrationInstructionsReps() {
        return this.getReps(13);
    }

    public CWE insertSpecialAdministrationInstructions(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(13, rep);
    }

    public CWE insertRxg13_SpecialAdministrationInstructions(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(13, rep);
    }

    public CWE removeSpecialAdministrationInstructions(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(13, rep);
    }

    public CWE removeRxg13_SpecialAdministrationInstructions(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(13, rep);
    }

    public ST getGivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getRxg14_GivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getGiveRateAmount() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getRxg15_GiveRateAmount() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getGiveRateUnits() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getRxg16_GiveRateUnits() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getGiveStrength() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getRxg17_GiveStrength() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getGiveStrengthUnits() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getRxg18_GiveStrengthUnits() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public ST[] getSubstanceLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(19, new ST[0]);
        return retVal;
    }

    public ST[] getRxg19_SubstanceLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(19, new ST[0]);
        return retVal;
    }

    public int getSubstanceLotNumberReps() {
        return this.getReps(19);
    }

    public ST getSubstanceLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(19, rep);
        return retVal;
    }

    public ST getRxg19_SubstanceLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(19, rep);
        return retVal;
    }

    public int getRxg19_SubstanceLotNumberReps() {
        return this.getReps(19);
    }

    public ST insertSubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(19, rep);
    }

    public ST insertRxg19_SubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(19, rep);
    }

    public ST removeSubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(19, rep);
    }

    public ST removeRxg19_SubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(19, rep);
    }

    public DTM[] getSubstanceExpirationDate() {
        DTM[] retVal = (DTM[])this.getTypedField(20, new DTM[0]);
        return retVal;
    }

    public DTM[] getRxg20_SubstanceExpirationDate() {
        DTM[] retVal = (DTM[])this.getTypedField(20, new DTM[0]);
        return retVal;
    }

    public int getSubstanceExpirationDateReps() {
        return this.getReps(20);
    }

    public DTM getSubstanceExpirationDate(int rep) {
        DTM retVal = (DTM)this.getTypedField(20, rep);
        return retVal;
    }

    public DTM getRxg20_SubstanceExpirationDate(int rep) {
        DTM retVal = (DTM)this.getTypedField(20, rep);
        return retVal;
    }

    public int getRxg20_SubstanceExpirationDateReps() {
        return this.getReps(20);
    }

    public DTM insertSubstanceExpirationDate(int rep) throws HL7Exception {
        return (DTM)super.insertRepetition(20, rep);
    }

    public DTM insertRxg20_SubstanceExpirationDate(int rep) throws HL7Exception {
        return (DTM)super.insertRepetition(20, rep);
    }

    public DTM removeSubstanceExpirationDate(int rep) throws HL7Exception {
        return (DTM)super.removeRepetition(20, rep);
    }

    public DTM removeRxg20_SubstanceExpirationDate(int rep) throws HL7Exception {
        return (DTM)super.removeRepetition(20, rep);
    }

    public CWE[] getSubstanceManufacturerName() {
        CWE[] retVal = (CWE[])this.getTypedField(21, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxg21_SubstanceManufacturerName() {
        CWE[] retVal = (CWE[])this.getTypedField(21, new CWE[0]);
        return retVal;
    }

    public int getSubstanceManufacturerNameReps() {
        return this.getReps(21);
    }

    public CWE getSubstanceManufacturerName(int rep) {
        CWE retVal = (CWE)this.getTypedField(21, rep);
        return retVal;
    }

    public CWE getRxg21_SubstanceManufacturerName(int rep) {
        CWE retVal = (CWE)this.getTypedField(21, rep);
        return retVal;
    }

    public int getRxg21_SubstanceManufacturerNameReps() {
        return this.getReps(21);
    }

    public CWE insertSubstanceManufacturerName(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(21, rep);
    }

    public CWE insertRxg21_SubstanceManufacturerName(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(21, rep);
    }

    public CWE removeSubstanceManufacturerName(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(21, rep);
    }

    public CWE removeRxg21_SubstanceManufacturerName(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(21, rep);
    }

    public CWE[] getIndication() {
        CWE[] retVal = (CWE[])this.getTypedField(22, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxg22_Indication() {
        CWE[] retVal = (CWE[])this.getTypedField(22, new CWE[0]);
        return retVal;
    }

    public int getIndicationReps() {
        return this.getReps(22);
    }

    public CWE getIndication(int rep) {
        CWE retVal = (CWE)this.getTypedField(22, rep);
        return retVal;
    }

    public CWE getRxg22_Indication(int rep) {
        CWE retVal = (CWE)this.getTypedField(22, rep);
        return retVal;
    }

    public int getRxg22_IndicationReps() {
        return this.getReps(22);
    }

    public CWE insertIndication(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(22, rep);
    }

    public CWE insertRxg22_Indication(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(22, rep);
    }

    public CWE removeIndication(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(22, rep);
    }

    public CWE removeRxg22_Indication(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(22, rep);
    }

    public NM getGiveDrugStrengthVolume() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public NM getRxg23_GiveDrugStrengthVolume() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE getGiveDrugStrengthVolumeUnits() {
        CWE retVal = (CWE)this.getTypedField(24, 0);
        return retVal;
    }

    public CWE getRxg24_GiveDrugStrengthVolumeUnits() {
        CWE retVal = (CWE)this.getTypedField(24, 0);
        return retVal;
    }

    public CWE getGiveBarcodeIdentifier() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getRxg25_GiveBarcodeIdentifier() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getPharmacyOrderType() {
        ID retVal = (ID)this.getTypedField(26, 0);
        return retVal;
    }

    public ID getRxg26_PharmacyOrderType() {
        ID retVal = (ID)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getDispenseToPharmacy() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getRxg27_DispenseToPharmacy() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public XAD getDispenseToPharmacyAddress() {
        XAD retVal = (XAD)this.getTypedField(28, 0);
        return retVal;
    }

    public XAD getRxg28_DispenseToPharmacyAddress() {
        XAD retVal = (XAD)this.getTypedField(28, 0);
        return retVal;
    }

    public PL getDeliverToPatientLocation() {
        PL retVal = (PL)this.getTypedField(29, 0);
        return retVal;
    }

    public PL getRxg29_DeliverToPatientLocation() {
        PL retVal = (PL)this.getTypedField(29, 0);
        return retVal;
    }

    public XAD getDeliverToAddress() {
        XAD retVal = (XAD)this.getTypedField(30, 0);
        return retVal;
    }

    public XAD getRxg30_DeliverToAddress() {
        XAD retVal = (XAD)this.getTypedField(30, 0);
        return retVal;
    }

    public EI[] getGiveTagIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(31, new EI[0]);
        return retVal;
    }

    public EI[] getRxg31_GiveTagIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(31, new EI[0]);
        return retVal;
    }

    public int getGiveTagIdentifierReps() {
        return this.getReps(31);
    }

    public EI getGiveTagIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(31, rep);
        return retVal;
    }

    public EI getRxg31_GiveTagIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(31, rep);
        return retVal;
    }

    public int getRxg31_GiveTagIdentifierReps() {
        return this.getReps(31);
    }

    public EI insertGiveTagIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(31, rep);
    }

    public EI insertRxg31_GiveTagIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(31, rep);
    }

    public EI removeGiveTagIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(31, rep);
    }

    public EI removeRxg31_GiveTagIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(31, rep);
    }

    public NM getDispenseAmount() {
        NM retVal = (NM)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getRxg32_DispenseAmount() {
        NM retVal = (NM)this.getTypedField(32, 0);
        return retVal;
    }

    public CWE getDispenseUnits() {
        CWE retVal = (CWE)this.getTypedField(33, 0);
        return retVal;
    }

    public CWE getRxg33_DispenseUnits() {
        CWE retVal = (CWE)this.getTypedField(33, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new NULLDT(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(167));
            }
            case 10: {
                return new NULLDT(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new ST(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new NM(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new DTM(this.getMessage());
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new CWE(this.getMessage());
            }
            case 22: {
                return new NM(this.getMessage());
            }
            case 23: {
                return new CWE(this.getMessage());
            }
            case 24: {
                return new CWE(this.getMessage());
            }
            case 25: {
                return new ID(this.getMessage(), new Integer(480));
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new XAD(this.getMessage());
            }
            case 28: {
                return new PL(this.getMessage());
            }
            case 29: {
                return new XAD(this.getMessage());
            }
            case 30: {
                return new EI(this.getMessage());
            }
            case 31: {
                return new NM(this.getMessage());
            }
            case 32: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

